package event

type EventType string

func (t EventType) String() string {
	return string(t)
}

const (
	EventReady                               EventType = "READY"
	EventResumed                             EventType = "RESUMED"
	EventApplicationCommandPermissionsUpdate EventType = "APPLICATION_COMMAND_PERMISSIONS_UPDATE"
	EventAutoModerationRuleCreate            EventType = "AUTO_MODERATION_RULE_CREATE"
	EventAutoModerationRuleUpdate            EventType = "AUTO_MODERATION_RULE_UPDATE"
	EventAutoModerationRuleDelete            EventType = "AUTO_MODERATION_RULE_DELETE"
	EventAutoModerationActionExecution       EventType = "AUTO_MODERATION_ACTION_EXECUTION"
	EventChannelCreate                       EventType = "CHANNEL_CREATE"
	EventChannelUpdate                       EventType = "CHANNEL_UPDATE"
	EventChannelDelete                       EventType = "CHANNEL_DELETE"
	EventChannelPinsUpdate                   EventType = "CHANNEL_PINS_UPDATE"
	EventThreadCreate                        EventType = "THREAD_CREATE"
	EventThreadUpdate                        EventType = "THREAD_UPDATE"
	EventThreadDelete                        EventType = "THREAD_DELETE"
	EventThreadListSync                      EventType = "THREAD_LIST_SYNC"
	EventThreadMemberUpdate                  EventType = "THREAD_MEMBER_UPDATE"
	EventThreadMembersUpdate                 EventType = "THREAD_MEMBERS_UPDATE"
	EventGuildCreate                         EventType = "GUILD_CREATE"
	EventGuildUpdate                         EventType = "GUILD_UPDATE"
	EventGuildDelete                         EventType = "GUILD_DELETE"
	EventGuildBanAdd                         EventType = "GUILD_BAN_ADD"
	EventGuildBanRemove                      EventType = "GUILD_BAN_REMOVE"
	EventGuildEmojisUpdate                   EventType = "GUILD_EMOJIS_UPDATE"
	EventGuildStickersUpdate                 EventType = "GUILD_STICKERS_UPDATE" // TGM KHIROO
	EventGuildIntegrationsUpdate             EventType = "GUILD_INTEGRATIONS_UPDATE"
	EventGuildMemberAdd                      EventType = "GUILD_MEMBER_ADD"
	EventGuildMemberRemove                   EventType = "GUILD_MEMBER_REMOVE"
	EventGuildMemberUpdate                   EventType = "GUILD_MEMBER_UPDATE"
	EventGuildMembersChunk                   EventType = "GUILD_MEMBERS_CHUNK"
	EventGuildRoleCreate                     EventType = "GUILD_ROLE_CREATE"
	EventGuildRoleUpdate                     EventType = "GUILD_ROLE_UPDATE"
	EventGuildRoleDelete                     EventType = "GUILD_ROLE_DELETE"
	EventGuildScheduledEventCreate           EventType = "GUILD_SCHEDULED_EVENT_CREATE"
	EventGuildScheduledEventUpdate           EventType = "GUILD_SCHEDULED_EVENT_UPDATE"
	EventGuildScheduledEventDelete           EventType = "GUILD_SCHEDULED_EVENT_DELETE"
	EventGuildScheduledEventUserAdd          EventType = "GUILD_SCHEDULED_EVENT_USER_ADD"
	EventGuildScheduledEventUserRemove       EventType = "GUILD_SCHEDULED_EVENT_USER_REMOVE"
	EventIntegrationCreate                   EventType = "INTEGRATION_CREATE"
	EventIntegrationUpdate                   EventType = "INTEGRATION_UPDATE"
	EventIntegrationDelete                   EventType = "INTEGRATION_DELETE"
	EventInteractionCreate                   EventType = "INTERACTION_CREATE"
	EventInviteCreate                        EventType = "INVITE_CREATE"
	EventInviteDelete                        EventType = "INVITE_DELETE"
	EventMessageCreate                       EventType = "MESSAGE_CREATE"
	EventMessageUpdate                       EventType = "MESSAGE_UPDATE"
	EventMessageDelete                       EventType = "MESSAGE_DELETE"
	EventMessageDeleteBulk                   EventType = "MESSAGE_DELETE_BULK"
	EventMessageReactionAdd                  EventType = "MESSAGE_REACTION_ADD"
	EventMessageReactionRemove               EventType = "MESSAGE_REACTION_REMOVE"
	EventMessageReactionRemoveAll            EventType = "MESSAGE_REACTION_REMOVE_ALL"
	EventMessageReactionRemoveEmoji          EventType = "MESSAGE_REACTION_REMOVE_EMOJI"
	EventPresenceUpdate                      EventType = "PRESENCE_UPDATE"
	EventStageInstanceCreate                 EventType = "STAGE_INSTANCE_CREATE"
	EventStageInstanceUpdate                 EventType = "STAGE_INSTANCE_UPDATE"
	EventStageInstanceDelete                 EventType = "STAGE_INSTANCE_DELETE"
	EventTypingStart                         EventType = "TYPING_START"
	EventUserUpdate                          EventType = "USER_UPDATE"
	EventVoiceStateUpdate                    EventType = "VOICE_STATE_UPDATE"
	EventVoiceServerUpdate                   EventType = "VOICE_SERVER_UPDATE"
	EventWebhooksUpdate                      EventType = "WEBHOOKS_UPDATE"
)
