import { Resource } from "@/types";

export const web: Resource[] = [
  {
    title: "MDN Web Docs",
    description:
      "Comprehensive documentation and learning resources for web technologies, including HTML, CSS, and JavaScript",
    tags: ["documentation", "HTML", "CSS", "JavaScript"],
    link: "https://developer.mozilla.org/en-US/",
  },
  {
    title: "freeCodeCamp",
    description:
      "Free coding bootcamp offering certifications in responsive web design, JavaScript algorithms, front-end libraries, and more",
    tags: ["free", "course", "full-stack"],
    link: "https://www.freecodecamp.org/",
  },
  {
    title: "React Documentation",
    description:
      "Official documentation for React, a popular JavaScript library for building user interfaces",
    tags: ["React", "JavaScript", "UI"],
    link: "https://reactjs.org/docs/getting-started.html",
  },
  {
    title: "Vue.js Guide",
    description:
      "Official guide and documentation for Vue.js, a progressive JavaScript framework",
    tags: ["Vue.js", "JavaScript", "framework"],
    link: "https://vuejs.org/guide/introduction.html",
  },
  {
    title: "Next.js Documentation",
    description:
      "Learn about Next.js features and API, a React framework for production-grade applications",
    tags: ["Next.js", "React", "framework"],
    link: "https://nextjs.org/docs",
  },
  {
    title: "CSS-Tricks",
    description:
      "A website dedicated to teaching all things web design and development, with a focus on CSS",
    tags: ["CSS", "web design", "tutorials"],
    link: "https://css-tricks.com/",
  },
  {
    title: "The Odin Project",
    description:
      "Free, open-source coding curriculum that can be taken entirely online",
    tags: ["free", "full-stack", "curriculum"],
    link: "https://www.theodinproject.com/",
  },
  {
    title: "Web.dev",
    description: "Guidance and tutorials for modern web development by Google",
    tags: ["Google", "best practices", "performance"],
    link: "https://web.dev/",
  },
  {
    title: "Frontend Masters",
    description:
      "In-depth, modern frontend engineering courses from experts in the field",
    tags: ["courses", "frontend", "professional"],
    link: "https://frontendmasters.com/",
  },
  {
    title: "Smashing Magazine",
    description:
      "A website and eBook publisher providing cutting-edge content for web developers and designers",
    tags: ["articles", "tutorials", "web design"],
    link: "https://www.smashingmagazine.com/",
  },
];

export const DocsBlogsGen: Resource[] = [
  {
    title: "VuePress",
    description:
      "VuePress is a markdown-centered static site generator. You can write your content (documentations, blogs, etc.) in Markdown, then VuePress will help you to generate a static site to host them.",
    tags: ["Documentation", "Blog", "VueJs"],
    link: "https://vuepress.vuejs.org/",
  },
  {
    title: "Nextra",
    description:
      "Nextra is a Next.js-based static site generator, ideal for creating documentation websites. It's simple to use and provides a clean, customizable interface.",
    tags: ["Documentation", "NextJs", "Blogs"],
    link: "https://nextra.site/",
  },
  {
    title: "Docusaurus",
    description:
      "Docusaurus is a project for building, deploying, and maintaining open source project websites easily. It's created by Meta and works well with React-based projects.",
    tags: ["Documentation", "Blog", "Meta"],
    link: "https://docusaurus.io/",
  },
  {
    title: "VitePress",
    description:
      "VitePress is a Static Site Generator (SSG) designed for building fast, content-centric websites. In a nutshell, VitePress takes your source content written in Markdown, applies a theme to it, and generates static HTML pages that can be easily deployed anywhere.",
    tags: ["Documentation", "VueJs", "Vite"],
    link: "https://vitepress.dev/",
  },
  {
    title: "Gatsby",
    description:
      "Gatsby is a React-based open source framework for creating websites and apps. It's great for blogs, e-commerce sites, and documentation with its large plugin ecosystem.",
    tags: ["Documentation", "Blog", "React", "GraphQL"],
    link: "https://www.gatsbyjs.com/",
  },
  {
    title: "Docz",
    description:
      "Docz enables you to quickly create live-reloading, seo-friendly, production-ready documentation sites with MDX and customize the look, feel and behavior when required by leveraging GatsbyJS and Gatsby theme shadowing.",
    tags: ["Documentation", "Blog", "Gatsby", "Docz"],
    link: "https://www.docz.site/",
  },
  {
    title: "Kitdocs",
    description:
      "KitDocs makes it easy to build a documentation site with SvelteKit. You can think of it as a VitePress alternative for Sveltalowdas (i.e., the people of Svelte).",
    tags: ["Documentation", "Blog", "Svelte", "SvelteKit"],
    link: "https://kitdocs.vercel.app/",
  },
  {
    title: "11ty",
    description:
      "A simpler static site generator. An alternative to Jekyll. Written in JavaScript. Transforms a directory of templates (of varying types) into HTML.",
    tags: ["Documentation", "Blog", "JavaScript"],
    link: "https://www.11ty.dev/",
  },
  {
    title: "Mkdocs",
    description:
      "MkDocs is a fast, simple and downright gorgeous static site generator that's geared towards building project documentation.",
    tags: ["Documentation", "Blog", "Mkdocs"],
    link: "https://www.mkdocs.org/",
  },
  {
    title: "Jekyllrb",
    description:
      "Jekyll is a static site generator. It takes text written in your favorite markup language and uses layouts to create a static website. You can tweak the site’s look and feel, URLs, the data displayed on the page, and more.",
    tags: ["Documentation", "Blog", "Jekyllrb"],
    link: "https://jekyllrb.com/",
  },
  {
    title: "Starlight",
    description:
      "Everything you need to build a stellar documentation website. Fast, accessible, and easy-to-use.",
    tags: ["Documentation", "Blog", "Astro"],
    link: "https://starlight.astro.build/",
  },
  {
    title: "Hugo",
    description:
      "Hugo is one of the most popular open-source static site generators. Written in Go, it's known for its speed and flexibility.",
    tags: ["Documentation", "Blog", "Go"],
    link: "https://gohugo.io/",
  },
  {
    title: "mdBook",
    description:
      "mdBook is a command-line tool to create modern online books from Markdown files. It's used for Rust's official documentation and other technical documentation projects.",
    tags: ["Documentation", "Rust", "Book"],
    link: "https://rust-lang.github.io/mdBook/",
  },
  {
    title: "GitBook",
    description:
      "GitBook is a free, open-source, static site generator that allows users to create and publish documentation, including books, internal wikis, and product and program documentation.",
    tags: ["Documentation", "Book", "GitBook"],
    link: "https://www.gitbook.com/",
  },
  {
    title: "Docus",
    description:
      "Write pages in Markdown, use Vue components and enjoy the power of Nuxt.",
    tags: ["Documentation", "Blog", "Nuxt"],
    link: "https://docus.dev/",
  },
];
