import { Resource } from "@/types";

export const mobile: Resource[] = [
  {
    title: "React Native Documentation",
    description:
      "Official documentation for React Native, covering setup, core components, and APIs",
    tags: ["react native", "documentation", "official"],
    link: "https://reactnative.dev/docs/getting-started",
  },
  {
    title: "React Native Express",
    description:
      "A comprehensive guide to React Native and related tools, from basics to advanced topics",
    tags: ["react native", "tutorial", "comprehensive"],
    link: "https://www.reactnative.express/",
  },
  {
    title: "The Complete React Native + Hooks Course",
    description:
      "Udemy course covering React Native, Hooks, Redux, and more for building mobile apps",
    tags: ["react native", "hooks", "course", "udemy"],
    link: "https://www.udemy.com/course/the-complete-react-native-and-redux-course/",
  },
  {
    title: "React Native Paper",
    description:
      "Cross-platform Material Design for React Native, with customizable components",
    tags: ["react native", "ui library", "material design"],
    link: "https://callstack.github.io/react-native-paper/",
  },
  {
    title: "React Native Testing Library",
    description:
      "Simple and complete React Native testing utilities that encourage good testing practices",
    tags: ["react native", "testing", "library"],
    link: "https://callstack.github.io/react-native-testing-library/",
  },
  {
    title: "React Native Navigation",
    description:
      "A complete native navigation solution for React Native with easy-to-use APIs",
    tags: ["react native", "navigation", "library"],
    link: "https://wix.github.io/react-native-navigation/",
  },
  {
    title: "Expo",
    description:
      "A framework and platform for universal React applications, simplifying React Native development",
    tags: ["react native", "expo", "framework"],
    link: "https://expo.dev/",
  },
];
