import { Resource } from "@/types";

export const misc: Resource[] = [
  {
    title: "DevOps Roadmap",
    description: "A comprehensive guide to becoming a DevOps engineer",
    tags: ["devops", "roadmap", "career"],
    link: "https://roadmap.sh/devops",
  },
  {
    title: "GitHub Actions Documentation",
    description: "Official documentation for GitHub's CI/CD platform",
    tags: ["github", "ci/cd", "documentation"],
    link: "https://docs.github.com/en/actions",
  },
  {
    title: "Docker Documentation",
    description:
      "Official docs for Docker, a popular containerization platform",
    tags: ["docker", "containers", "documentation"],
    link: "https://docs.docker.com/",
  },
  {
    title: "Kubernetes Documentation",
    description:
      "Official documentation for Kubernetes, a container orchestration system",
    tags: ["kubernetes", "containers", "orchestration"],
    link: "https://kubernetes.io/docs/home/",
  },
  {
    title: "The Terraform Book",
    description:
      "Comprehensive guide to HashiCorp's infrastructure as code tool",
    tags: ["terraform", "iac", "book"],
    link: "https://www.terraformbook.com/",
  },
  {
    title: "AWS DevOps Blog",
    description: "Official blog with best practices for DevOps on AWS",
    tags: ["aws", "devops", "cloud"],
    link: "https://aws.amazon.com/blogs/devops/",
  },
  {
    title: "Jenkins User Documentation",
    description: "User guide for Jenkins, an open source automation server",
    tags: ["jenkins", "ci/cd", "automation"],
    link: "https://www.jenkins.io/doc/",
  },
  {
    title: "Ansible Documentation",
    description: "Official docs for Ansible, an IT automation tool",
    tags: ["ansible", "automation", "configuration management"],
    link: "https://docs.ansible.com/",
  },
  {
    title: "Prometheus Documentation",
    description: "Docs for Prometheus, an open-source monitoring system",
    tags: ["prometheus", "monitoring", "observability"],
    link: "https://prometheus.io/docs/introduction/overview/",
  },
  {
    title: "The Phoenix Project",
    description: "A novel about IT, DevOps, and helping your business win",
    tags: ["book", "devops", "it"],
    link: "https://itrevolution.com/product/the-phoenix-project/",
  },
];
