import { Resource } from "@/types";

export const ai: Resource[] = [
  {
    title: "Coursera Machine Learning Specialization",
    description:
      "A comprehensive introduction to machine learning, data mining, and statistical pattern recognition by Andrew Ng",
    tags: ["course", "machine learning", "beginner"],
    link: "https://www.coursera.org/specializations/machine-learning-introduction",
  },
  {
    title: "Fast.ai",
    description:
      "Free courses on deep learning, covering practical AI applications using PyTorch",
    tags: ["deep learning", "free", "practical"],
    link: "https://www.fast.ai/",
  },
  {
    title: "TensorFlow Documentation",
    description:
      "Official documentation and tutorials for TensorFlow, an open-source machine learning platform",
    tags: ["TensorFlow", "documentation", "machine learning"],
    link: "https://www.tensorflow.org/learn",
  },
  {
    title: "Kaggle",
    description:
      "Platform for data science competitions, datasets, and notebooks with a strong community",
    tags: ["data science", "competitions", "datasets"],
    link: "https://www.kaggle.com/",
  },
  {
    title: "deeplearning.ai",
    description:
      "Offers various specializations and courses in AI, including the popular Deep Learning Specialization",
    tags: ["deep learning", "course", "specialization"],
    link: "https://www.deeplearning.ai/",
  },
  {
    title: "Google AI Education",
    description:
      "Free resources and courses on machine learning and AI fundamentals by Google",
    tags: ["Google", "free", "fundamentals"],
    link: "https://ai.google/education/",
  },
  {
    title: "OpenAI Spinning Up",
    description:
      "Educational resource for learning about deep reinforcement learning",
    tags: ["reinforcement learning", "deep learning", "tutorial"],
    link: "https://spinningup.openai.com/en/latest/",
  },
  {
    title: "PyTorch Tutorials",
    description:
      "Official tutorials and resources for PyTorch, an open source machine learning library",
    tags: ["PyTorch", "tutorials", "machine learning"],
    link: "https://pytorch.org/tutorials/",
  },
  {
    title: "Elements of AI",
    description:
      "Free online course covering the basics of AI for non-technical people",
    tags: ["basics", "free", "non-technical"],
    link: "https://www.elementsofai.com/",
  },
  {
    title: "AI Ethics Course",
    description:
      "Course on the ethics of artificial intelligence by the University of Helsinki",
    tags: ["ethics", "AI", "course"],
    link: "https://ethics-of-ai.mooc.fi/",
  },
  {
    title: "Papers With Code",
    description:
      "Free and open resource with Machine Learning papers, code, and evaluation tables",
    tags: ["research papers", "code", "state-of-the-art"],
    link: "https://paperswithcode.com/",
  },
  {
    title: "Hugging Face",
    description:
      "Platform for building, training and deploying state-of-the-art machine learning models",
    tags: ["NLP", "transformers", "models"],
    link: "https://huggingface.co/",
  },
];
