export function ThemesAnimation(props: any) {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      fill="none"
      viewBox="-50 0 268 250"
      {...props}
    >
      <circle
        cx="83.4"
        cy="142.4"
        r="48.84"
        fill="#DDD"
        fillOpacity="0.2"
        stroke="#E6E6E6"
        strokeWidth="3"
      />
      <path
        fill="#000"
        d="M61.88 146.8v-7.13h.07l4.74 7.13h1.75v-10.67h-1.97v7.1h-.07l-4.73-7.1h-1.76v10.67h1.97zm12.14.15c2.22 0 3.3-1.32 3.5-2.65H75.6c-.17.67-.75 1.08-1.57 1.08-1.05 0-1.76-.8-1.76-2.06v-.22h5.31v-.82c0-2.38-1.4-3.92-3.65-3.92-2.18 0-3.67 1.44-3.67 3.87v.76c0 2.54 1.48 3.96 3.75 3.96zm-1.74-5.16v-.01c0-1.07.67-1.89 1.67-1.89 1 0 1.65.82 1.65 1.89v.01h-3.32zm11.7 5h2.32l-2.69-4.14 2.71-4.14h-2.27l-1.64 2.82h-.06l-1.64-2.82h-2.38l2.65 4.14-2.63 4.15h2.2l1.69-2.82h.05l1.7 2.82zm4.46-8.28h-1.21v1.6h1.17v4.35c0 1.7.68 2.39 2.74 2.39.42 0 .78-.04.94-.07v-1.53l-.44.02c-.85 0-1.2-.25-1.2-1.08v-4.09h1.6v-1.59h-1.6v-1.98h-2v1.98zm5.4 7.24c0 .67.55 1.22 1.22 1.22a1.22 1.22 0 000-2.43c-.67 0-1.22.55-1.22 1.21zm4.26-9.3c0 .65.53 1.08 1.17 1.08.64 0 1.16-.43 1.16-1.07 0-.65-.52-1.09-1.16-1.09-.64 0-1.17.44-1.17 1.09zm2.19 2.06h-2.05v8.44c0 .89-.34 1.25-1.07 1.25-.16 0-.35-.01-.47-.03v1.48c.15.02.57.06.86.06 1.64 0 2.73-.83 2.73-2.74v-8.46zm1.84 2.46c0 1.53 1.2 2.09 2.7 2.4 1.06.21 2.05.33 2.05 1.13 0 .54-.45 1-1.42 1-.88 0-1.41-.42-1.5-1.03h-1.99c0 1.48 1.24 2.48 3.38 2.48 2.19 0 3.53-1.01 3.53-2.71 0-1.53-1.12-2.06-2.64-2.33-.95-.17-2.14-.31-2.14-1.13 0-.61.51-.99 1.32-.99 1 0 1.33.58 1.39 1.1h1.82c0-1.54-1.2-2.53-3.18-2.53-1.74 0-3.32.77-3.32 2.61z"
      />
      <path
        fill="#888"
        d="M84.48 35.77h2.8v-.97h-2.8v-2.88h-.97v2.88h-2.78v.97h2.78v3.05h.97v-3.05z"
      />
      <path
        className="dash-ring"
        stroke="#E6E6E6"
        strokeDasharray="7 7"
        strokeLinecap="round"
        strokeWidth="3"
        d="M166 143a82 82 0 11-164 0 82 82 0 01164 0z"
      />
      <path
        fill="#fff"
        fillOpacity="0.82"
        d="M64.77 67v3h3v-3h-3zm0-6.24v-3h-3v3h3zm.05 0l2.5-1.66-.89-1.34h-1.6v3zM68.97 67l-2.5 1.66.9 1.34h1.6v-3zm1.53 0v3h3v-3h-3zm0-9.33h3v-3h-3v3zm-1.72 0v-3h-3v3h3zm0 6.2v3h3v-3h-3zm-.06 0l-2.5 1.67.9 1.34h1.6v-3zm-4.14-6.2l2.5-1.66-.9-1.34h-1.6v3zm-1.53 0v-3h-3v3h3zm0 9.33h-3v3h3v-3zm4.72 0v-6.24h-6V67h6zm-3-3.24h.05v-6h-.05v6zm-2.45-1.34l4.15 6.24 5-3.32-4.15-6.24-5 3.32zM68.97 70h1.53v-6h-1.53v6zm4.53-3v-9.33h-6V67h6zm-3-12.33h-1.72v6h1.72v-6zm-4.72 3v6.2h6v-6.2h-6zm3 3.2h-.06v6h.06v-6zm2.44 1.34l-4.14-6.2-5 3.32 4.14 6.2 5-3.32zm-6.64-7.54h-1.53v6h1.53v-6zm-4.53 3V67h6v-9.33h-6zm3 12.33h1.72v-6h-1.72v6zm15.68-5.19l2.96.44.51-3.44h-3.47v3zm-1.67 0v-3h-2.33l-.58 2.26 2.9.74zm-2.91-1.05v-3h-3v3h3zm4.64 0v3h3v-3h-3zm-4.64-1.14h-3v3h3v-3zm2.9 0v3h3v-3h-3zm-1.38 7.51c1.6 0 3.04-.49 4.16-1.46a5.6 5.6 0 001.86-3.42l-5.93-.87a.4.4 0 01.14-.24c.04-.04.07-.05.06-.04-.02 0-.1.03-.29.03v6zm3.06-8.32h-1.67v6h1.67v-6zm-4.58 2.26c.1-.38.35-.77.73-1.03.36-.25.67-.28.8-.28v6c1.8 0 3.73-1.03 4.28-3.2l-5.8-1.5zm1.53-1.31c.36 0 .82.16 1.16.55.3.35.3.65.3.65h-6c0 1.1.32 2.3 1.16 3.27a4.43 4.43 0 003.38 1.53v-6zm1.47 1.2v-.2h-6v.2h6zm-3 2.8h4.64v-6h-4.64v6zm7.64-3v-.71h-6v.71h6zm0-.71a6.6 6.6 0 00-1.65-4.54 6.08 6.08 0 00-4.54-1.9v6a.91.91 0 01.2.03l-.02-.01a.26.26 0 01-.05-.04c-.06-.08.06 0 .06.46h6zm-6.2-6.43c-1.62 0-3.25.55-4.47 1.8A6.45 6.45 0 0069.38 63h6c0-.22.04-.35.05-.4.02-.04.02-.03 0 0-.04.04-.06.05-.06.04.01 0 .08-.02.23-.02v-6zM69.4 63v.66h6V63h-6zm0 .66c0 1.7.5 3.39 1.74 4.66a6.22 6.22 0 004.54 1.81v-6a.89.89 0 01-.3-.04s.02 0 .06.05c.04.03.03.05.01 0a1.54 1.54 0 01-.06-.48h-6zm7.76-1.04v-.02h-6v.02h6zm0-.02c0 .15-.05.47-.33.8a1.7 1.7 0 01-1.21.56v-6c-2.94 0-4.46 2.48-4.46 4.64h6zm-1.54 1.36c-.44 0-.91-.2-1.23-.58a1.23 1.23 0 01-.33-.78h6c0-1.05-.32-2.2-1.1-3.12a4.34 4.34 0 00-3.34-1.52v6zm-1.56-1.36v.02h6v-.02h-6zm3-2.98h-2.9v6h2.9v-6zM84.67 67l-2.57 1.55.87 1.45h1.7v-3zm2.02 0v3h5.52l-3-4.63L86.69 67zm-2.35-3.63l-2.51-1.64-1.07 1.63L81.82 65l2.52-1.63zm2.37-3.62l2.51 1.64 3.04-4.64h-5.55v3zm-1.99 0v-3H83l-.87 1.49 2.6 1.5zM83.3 62.2v3H85l.87-1.49-2.6-1.5zm-.05 0l-2.6 1.51.87 1.5h1.73v-3zm-1.44-2.46l2.6-1.51-.87-1.5H81.8v3zm-2.08 0v-3h-5.48l2.95 4.61 2.53-1.61zm2.31 3.62l2.54 1.6 1.02-1.6-1.03-1.62-2.53 1.62zM79.73 67l-2.53-1.6-2.9 4.6h5.45v-3zm1.94 0v3h1.7l.87-1.46L81.67 67zm1.47-2.47v-3h-1.71L80.56 63l2.58 1.53zm.04 0L85.75 63l-.87-1.46h-1.7v3zM84.67 70h2.02v-6h-2.02v6zm4.54-4.63l-2.35-3.63L81.82 65l2.35 3.63 5.04-3.26zM86.85 65l2.37-3.62-5.02-3.29-2.37 3.63L86.85 65zm-.14-8.26h-1.99v6h2v-6zm-4.58 1.49l-1.44 2.47 5.19 3.01 1.43-2.46-5.18-3.02zm1.16.97h-.05v6h.05v-6zm2.54 1.5l-1.43-2.47-5.2 3.02 1.44 2.46 5.2-3.01zm-4.03-3.96h-2.08v6h2.08v-6zm-4.61 4.61L79.51 65l5.05-3.24-2.32-3.62-5.05 3.23zm2.31.4l-2.3 3.64 5.07 3.2 2.3-3.63-5.07-3.2zm.24 8.24h1.93v-6h-1.93v6zm4.5-1.46l1.47-2.47L80.56 63l-1.47 2.46 5.15 3.08zm-1.1-1h.04v-6h-.04v6zm-2.53-1.46l1.49 2.47 5.14-3.1L85.75 63l-5.14 3.09zm8.23-6.33v3h3v-3h-3zm-1.06 0v-3h-3v3h3zm0 1.4h-3v3h3v-3zm1.03 0h3v-3h-3v3zm3.22 5.83l.59 2.94 2.4-.48v-2.46h-3zm0-1.33h3v-3.26l-3.25.27.25 2.99zm-1.44-4.5v-3h-3v3h3zm1.41 0v3h3v-3h-3zm0-1.4h3v-3h-3v3zm-1.4 0h-3v3h3v-3zm0-1.74h3v-3h-3v3zm-1.76 0v-3h-3v3h3zm0-1.26h-1.06v6h1.06v-6zm-4.06 3v1.4h6v-1.4h-6zm3 4.4h1.03v-6h-1.03v6zm-1.97-3v3.8h6v-3.8h-6zm0 3.8c0 1.04.19 2.64 1.51 3.83a5.64 5.64 0 003.89 1.26v-6c-.3 0-.4-.03-.39-.02a1.59 1.59 0 01.97.98c.04.13.02.14.02-.05h-6zm5.4 5.1c.5 0 1.02-.05 1.4-.13l-1.17-5.88.06-.01h.01-.06l-.24.01v6zm3.82-3.07v-1.33h-6v1.33h6zm-3.25-4.32c.01 0 .01 0 0 0a1.5 1.5 0 01-.13 0v6c.22 0 .45 0 .63-.02l-.5-5.98zm-.13 0c-.06 0 .03 0 .21.04a2.37 2.37 0 011.64 1.53c.1.28.1.48.1.49h-6c0 .68.12 2.02 1.3 3.02 1.03.89 2.25.92 2.75.92v-6zm1.94 2.06v-3.58h-6v3.58h6zm-3-.58H92v-6h-1.4v6zm4.41-3v-1.4h-6v1.4h6zm-3-4.4h-1.4v6H92v-6zm1.6 3V58h-6v1.74h6zm-3-4.73h-1.76v6h1.75v-6zm-4.76 3v1.74h6V58h-6zm8 8.99h-3v3h3v-3zm1.85 0v3h3v-3h-3zm2.3-5.76l-.82 2.89 3.82 1.1v-3.99h-3zm0-1.55h3V57.2l-2.44-.46-.56 2.95zm-2.27 1.06v3h2.12l.7-2-2.82-1zm-.08 0h-3v3h3v-3zm0-1h3v-3h-3v3zm-1.8 0v-3h-3v3h3zm0 10.25h1.85v-6h-1.84v6zm4.85-3v-4.14h-6V67h6zm0-4.14c0-.13.03.26-.35.73a1.78 1.78 0 01-.96.58.64.64 0 01-.1.01v-6a4.5 4.5 0 00-3.54 1.55 4.81 4.81 0 00-1.05 3.13h6zm-1.41 1.32a2.67 2.67 0 01.16 0h-.03a1.59 1.59 0 01-.24-.05l1.64-5.77a5.91 5.91 0 00-1.53-.18v6zm3.7-2.94V59.7h-6v1.55h6zm-2.43-4.5c-.34-.07-.72-.1-1.13-.1v6h.05-.04l1.12-5.9zm-1.13-.1a4.74 4.74 0 00-4.53 3.1l5.66 2c-.1.29-.26.5-.44.64-.23.18-.5.26-.7.26v-6zm-1.7 1.1h-.08v6h.08v-6zm2.92 3v-1h-6v1h6zm-3-4h-1.8v6h1.8v-6zm-4.8 3V67h6v-7.25h-6zm12.5 6.38v-3h-1.79l-.85 1.58 2.64 1.42zm.08 0h3v-3h-3v3zm0 .88h-3v3h3v-3zm1.7 0v3h3v-3h-3zm-5.87-5.04l-3-.13-.13 3.13h3.13v-3zm1.69 0v3h2.76l.22-2.75-2.98-.25zm2.4.82v3h3v-3h-3zm0 1.08h3v-3h-3v3zm-1.97 6.25c2.04 0 3.74-.96 4.61-2.57l-5.28-2.84c.12-.22.29-.4.48-.5.2-.1.3-.1.2-.1v6zm1.97-1h.08v-6h-.08v6zm-2.92-3v.9h6v-.88h-6zm3 3.89h1.7v-6h-1.7v6zm4.7-3v-4.9h-6V67h6zm0-4.9a5.2 5.2 0 00-2.01-4.24 6.39 6.39 0 00-3.93-1.23v6c.19 0 .3.02.35.04.05.01 0 0-.09-.06a.93.93 0 01-.26-.34c-.07-.14-.06-.21-.06-.17h6zm-5.94-5.47a6.1 6.1 0 00-4.27 1.52 5.3 5.3 0 00-1.65 3.68l6 .27-.05.13a.9.9 0 01-.35.4l-.05.04s.11-.04.37-.04v-6zm-2.93 8.33h1.69v-6h-1.69v6zm4.67-2.75a2 2 0 01-.72 1.35c-.46.39-.9.43-1.06.43v-6a4.3 4.3 0 00-2.78.96 3.99 3.99 0 00-1.41 2.77l5.97.49zm-1.78 1.78a1.8 1.8 0 01-1.16-.52c-.55-.5-.64-1.1-.64-1.35h6c0-.98-.3-2.13-1.26-3.03a4.24 4.24 0 00-2.94-1.1v6zm-1.8-1.87v.66h6v-.66h-6zm3-2.34h-1.77v6h1.77v-6zm-1.77 0a5.9 5.9 0 00-3.87 1.29 4.95 4.95 0 00-1.7 3.85h6c0 .02 0 .13-.07.3a1.2 1.2 0 01-.33.43c-.27.23-.4.14-.02.14v-6zM96 64.9a5.1 5.1 0 001.65 3.84 5.51 5.51 0 003.73 1.36v-6c-.13 0 .05-.03.3.19.11.1.2.24.26.37.05.13.06.22.06.24h-6zm5.96-2.11c.2 0 .6.04 1 .36a2.1 2.1 0 01.83 1.63h-6c0 1.3.6 2.43 1.54 3.14.86.65 1.83.87 2.63.87v-6zm1.83 2c0 .46-.2 1.13-.78 1.61-.51.44-1 .45-1.04.45v-6c-.84 0-1.9.2-2.82.96a3.84 3.84 0 00-1.36 2.97h6zm-1.82 2.06h1.38v-6h-1.38v6zm-1.62-3v.76h6v-.76h-6zm0 .76c0-.6.29-1.13.7-1.46.35-.3.7-.36.91-.36v6c1.86 0 4.4-1.3 4.4-4.18h-6z"
      />
      <path
        fill="#000"
        d="M64.77 67v-6.24h.05L68.97 67h1.53v-9.33h-1.72v6.2h-.06l-4.14-6.2h-1.53V67h1.72zm10.9.13c1.94 0 2.89-1.16 3.06-2.32h-1.67c-.15.59-.66.95-1.38.95-.91 0-1.53-.7-1.53-1.8v-.2h4.64v-.71c0-2.09-1.22-3.43-3.2-3.43-1.9 0-3.2 1.26-3.2 3.38v.66c0 2.23 1.3 3.47 3.28 3.47zm-1.52-4.51v-.02c0-.93.58-1.64 1.46-1.64.87 0 1.44.7 1.44 1.64v.02h-2.9zM84.67 67h2.02l-2.35-3.63 2.37-3.62h-1.99L83.3 62.2h-.05l-1.44-2.46h-2.08l2.31 3.62-2.3 3.63h1.94l1.47-2.47h.04L84.67 67zm4.17-7.25h-1.06v1.4h1.03v3.8c0 1.48.6 2.1 2.4 2.1.36 0 .68-.04.82-.07v-1.33l-.38.01c-.75 0-1.06-.22-1.06-.94v-3.58H92v-1.4h-1.4v-1.73h-1.76v1.74zm5 7.25h1.85v-4.14c0-.97.4-1.68 1.59-1.68.28 0 .57.02.7.06V59.7a3.05 3.05 0 00-.56-.05c-1 0-1.54.64-1.7 1.1h-.08v-1h-1.8V67zm7.53.1c1.07 0 1.68-.45 1.97-.98h.08V67h1.7v-4.9c0-1.69-1.27-2.47-2.94-2.47-2.1 0-2.87 1.12-2.93 2.33h1.69c.04-.58.47-.97 1.2-.97.76 0 1.2.4 1.2 1.13v.66h-1.77c-1.68 0-2.58.83-2.58 2.13 0 1.37.97 2.2 2.38 2.2zm.58-1.3c-.6 0-1.17-.33-1.17-1 0-.56.39-.94 1.18-.94h1.38v.76c0 .7-.61 1.18-1.39 1.18z"
      />
      <path
        className="theme-1"
        fill="#000"
        d="M53.13 6.53c0-1.63.7-2.54 1.92-2.54 1.04 0 1.74.7 1.75 1.7h1.3V5.6c0-1.62-1.29-2.76-3.06-2.76-2.06 0-3.25 1.4-3.25 3.69v.98c0 2.28 1.2 3.65 3.25 3.65 1.77 0 3.06-1.1 3.06-2.65v-.09h-1.3c-.01.94-.7 1.6-1.75 1.6-1.22 0-1.92-.9-1.92-2.5v-1zM64.58 4.8h-1.3v3.74c0 .92-.58 1.42-1.36 1.42-.7 0-1.31-.32-1.31-1.4V4.8h-1.3v4.12c0 1.43.87 2.16 2.15 2.16 1 0 1.58-.46 1.78-.95h.06V11h1.28V4.8zM66 6.6c0 1.14.92 1.52 2.05 1.76.83.17 1.55.27 1.55.92 0 .46-.38.85-1.2.85-.74 0-1.18-.34-1.25-.85h-1.27c0 1.11.94 1.82 2.43 1.82 1.56 0 2.56-.73 2.56-1.98 0-1.18-.9-1.53-2.06-1.74-.7-.13-1.56-.25-1.56-.9 0-.52.45-.82 1.11-.82.85 0 1.12.48 1.16.91h1.17c0-1.1-.83-1.88-2.3-1.88-1.25 0-2.39.58-2.39 1.92zm6.58-1.8h-.88v1.04h.86v3.41c0 1.24.41 1.78 1.92 1.78.26 0 .51-.02.62-.04v-1c-.08.02-.19.02-.3.02-.7 0-.95-.2-.95-.87v-3.3h1.21V4.81h-1.2V3.3h-1.28v1.5zm6.3-.1c-1.77 0-2.75 1.25-2.75 2.93v.5c0 1.75.97 2.97 2.76 2.97 1.78 0 2.74-1.22 2.74-2.97v-.5c0-1.68-.96-2.94-2.74-2.94zm0 1.03c.97 0 1.45.79 1.45 1.92v.47c0 1.12-.47 1.93-1.44 1.93-.98 0-1.45-.82-1.45-1.93v-.47c0-1.12.48-1.92 1.45-1.92zM83.06 11h1.3V7.17c0-.9.53-1.34 1.2-1.34.73 0 1.2.43 1.2 1.35V11h1.27V7.18c0-.82.45-1.35 1.23-1.35.75 0 1.19.49 1.19 1.27V11h1.3V6.78c0-1.25-.76-2.07-2.05-2.07-1.03 0-1.67.5-1.9 1.03h-.04c-.23-.62-.8-1.03-1.76-1.03-.88 0-1.42.49-1.6.93h-.07V4.8h-1.27V11zM93.3 3.3c0 .42.36.73.78.73.42 0 .77-.3.77-.74a.74.74 0 00-.77-.73c-.42 0-.78.3-.78.73zm.13 7.7h1.3V4.8h-1.3V11zm2.73 0h4.78V9.94H97.8v-.05l3.08-4.2v-.88H96.2v1.06h3.08v.04l-3.13 4.25V11zm8.52.1c1.53 0 2.34-.88 2.52-1.88h-1.23c-.16.53-.61.86-1.27.86-.89 0-1.45-.7-1.45-1.73V8.2h4.02v-.6c0-1.74-1-2.9-2.65-2.9-1.62 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.06 2.93 2.72 2.93zm-1.43-3.8v-.02c0-.88.54-1.57 1.38-1.57.83 0 1.37.69 1.37 1.57v.01h-2.75zm7.59-2.58c-1.52 0-2.42 1.18-2.42 2.91v.54c0 1.76.86 2.91 2.42 2.91.83 0 1.48-.39 1.8-1.02h.04V11h1.27V2.58h-1.3v3.11h-.05c-.3-.56-.94-.97-1.76-.97zm.32 1.08c.92 0 1.5.72 1.5 1.88v.46c0 1.2-.57 1.88-1.48 1.88-.84 0-1.44-.63-1.44-1.89v-.45c0-1.26.6-1.88 1.42-1.88z"
      />
      <path
        className="theme-2"
        fill="#000"
        d="M50.34 11V5.47h.04l2.08 4.68h.95l2.07-4.68h.05V11h1.2V3H55.4l-2.44 5.63h-.04L50.48 3h-1.34v8h1.2zm8.08-7.7c0 .42.35.73.77.73.42 0 .77-.3.77-.74a.74.74 0 00-.77-.73c-.42 0-.77.3-.77.73zm.12 7.7h1.3V4.8h-1.3V11zm6.59 0h1.48l-2.05-3.1 2.04-3.1h-1.45L63.8 7.04h-.02L62.41 4.8H60.9l2 3.1-2.02 3.1h1.41l1.4-2.21h.03l1.4 2.21zm4.83.1c1.53 0 2.34-.88 2.53-1.88h-1.24c-.15.53-.6.86-1.27.86-.88 0-1.44-.7-1.44-1.73V8.2h4.02v-.6c0-1.74-1-2.9-2.65-2.9-1.63 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.06 2.93 2.71 2.93zm-1.42-3.8v-.02c0-.88.54-1.57 1.38-1.57.82 0 1.37.69 1.37 1.57v.01h-2.75zm7.58-2.58c-1.51 0-2.42 1.18-2.42 2.91v.54c0 1.76.86 2.91 2.42 2.91.84 0 1.49-.39 1.8-1.02h.05V11h1.26V2.58h-1.3v3.11h-.04c-.3-.56-.94-.97-1.77-.97zm.33 1.08c.92 0 1.5.72 1.5 1.88v.46c0 1.2-.57 1.88-1.49 1.88-.83 0-1.43-.63-1.43-1.89v-.45c0-1.26.6-1.88 1.42-1.88zm9.78 5.2V4.14h2.35V3h-6.02v1.14h2.35V11h1.32zm3.3 0h1.3V7.3c0-.8.45-1.46 1.37-1.46.77 0 1.34.45 1.34 1.45V11h1.3V7.02c0-1.51-.92-2.3-2.18-2.3-1.01 0-1.57.54-1.78.95h-.05V2.58h-1.3V11zm9.33.1c1.53 0 2.34-.88 2.53-1.88h-1.24c-.16.53-.6.86-1.27.86-.88 0-1.45-.7-1.45-1.73V8.2h4.03v-.6c0-1.74-1-2.9-2.65-2.9-1.63 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.06 2.93 2.71 2.93zm-1.43-3.8v-.02c0-.88.55-1.57 1.39-1.57.82 0 1.37.69 1.37 1.57v.01h-2.76zm5.42 3.7h1.3V7.17c0-.9.53-1.34 1.2-1.34.73 0 1.2.43 1.2 1.35V11h1.27V7.18c0-.82.45-1.35 1.23-1.35.75 0 1.19.49 1.19 1.27V11h1.3V6.78c0-1.25-.76-2.07-2.05-2.07-1.03 0-1.67.5-1.89 1.03h-.05c-.23-.62-.8-1.03-1.76-1.03-.88 0-1.42.49-1.6.93h-.06V4.8h-1.28V11zm12.77.1c1.53 0 2.34-.88 2.53-1.88h-1.24c-.16.53-.6.86-1.27.86-.89 0-1.45-.7-1.45-1.73V8.2h4.03v-.6c0-1.74-1-2.9-2.65-2.9-1.63 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.05 2.93 2.71 2.93zm-1.43-3.8v-.02c0-.88.55-1.57 1.38-1.57.83 0 1.38.69 1.38 1.57v.01h-2.76z"
      />
      <path
        className="theme-3"
        fill="#000"
        d="M52.3 3v8h2.75c2.38 0 3.56-1.44 3.56-4.01C58.6 4.4 57.44 3 55.05 3H52.3zm1.33 1.12h1.28c1.64 0 2.32 1.06 2.32 2.88 0 2.06-.83 2.88-2.32 2.88h-1.28V4.12zm8.79.58c-1.78 0-2.76 1.26-2.76 2.94v.5c0 1.75.97 2.97 2.76 2.97 1.79 0 2.75-1.22 2.75-2.97v-.5c0-1.68-.97-2.94-2.75-2.94zm0 1.04c.97 0 1.44.79 1.44 1.92v.47c0 1.12-.47 1.93-1.44 1.93s-1.45-.82-1.45-1.93v-.47c0-1.12.48-1.92 1.45-1.92zm3.9 2.41c0 1.74 1 2.96 2.68 2.96 1.44 0 2.34-.74 2.5-1.98h-1.23c-.09.48-.47.9-1.2.9-.88 0-1.44-.73-1.44-1.88v-.53c0-1.14.54-1.84 1.44-1.84.62 0 1.06.46 1.17.98h1.23C71.42 5.67 70.5 4.7 69 4.7c-1.68 0-2.67 1.2-2.67 2.9v.55zm6.24-1.53c0 1.13.92 1.51 2.05 1.75.83.17 1.55.27 1.55.92 0 .46-.38.85-1.2.85-.74 0-1.18-.34-1.25-.85h-1.26c0 1.11.93 1.82 2.42 1.82 1.56 0 2.56-.73 2.56-1.98 0-1.18-.9-1.53-2.06-1.74-.7-.13-1.56-.25-1.56-.9 0-.52.45-.82 1.11-.82.85 0 1.12.48 1.16.91h1.17c0-1.1-.83-1.88-2.3-1.88-1.24 0-2.39.58-2.39 1.92zM84.06 11V4.14h2.34V3h-6.02v1.14h2.35V11h1.32zm3.3 0h1.3V7.3c0-.8.44-1.46 1.36-1.46.77 0 1.35.45 1.35 1.45V11h1.29V7.02c0-1.51-.91-2.3-2.17-2.3-1.02 0-1.58.54-1.8.95h-.04V2.58h-1.3V11zm9.33.1c1.52 0 2.33-.88 2.52-1.88h-1.24c-.15.53-.6.86-1.27.86-.88 0-1.44-.7-1.44-1.73V8.2h4.02v-.6c0-1.74-1-2.9-2.65-2.9-1.63 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.06 2.93 2.72 2.93zm-1.43-3.8v-.02c0-.88.54-1.57 1.38-1.57.82 0 1.37.69 1.37 1.57v.01h-2.75zm5.41 3.7h1.3V7.17c0-.9.53-1.34 1.2-1.34.73 0 1.2.43 1.2 1.35V11h1.27V7.18c0-.82.46-1.35 1.23-1.35.75 0 1.19.49 1.19 1.27V11h1.3V6.78c0-1.25-.76-2.07-2.05-2.07-1.03 0-1.67.5-1.89 1.03h-.05c-.23-.62-.8-1.03-1.76-1.03-.88 0-1.42.49-1.6.93h-.06V4.8h-1.28V11zm12.77.1c1.53 0 2.34-.88 2.53-1.88h-1.24c-.16.53-.6.86-1.27.86-.88 0-1.45-.7-1.45-1.73V8.2h4.03v-.6c0-1.74-1-2.9-2.65-2.9-1.63 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.05 2.93 2.71 2.93zm-1.43-3.8v-.02c0-.88.55-1.57 1.39-1.57.82 0 1.37.69 1.37 1.57v.01H112z"
      />
      <path
        className="theme-4"
        fill="#000"
        d="M53.09 11h3.13c1.67 0 2.79-.83 2.79-2.25 0-1.16-.75-1.85-1.76-1.96v-.06a1.7 1.7 0 001.32-1.76c0-1.22-.9-1.97-2.3-1.97H53.1v8zm1.32-6.94h1.6c.78 0 1.25.42 1.25 1.13 0 .8-.53 1.2-1.72 1.2H54.4V4.05zm0 3.32h1.7c.99 0 1.54.5 1.54 1.32 0 .85-.56 1.25-1.96 1.25H54.4V7.38zM60.34 11h1.3V2.58h-1.3V11zm5.5-6.3c-1.78 0-2.76 1.26-2.76 2.94v.5c0 1.75.97 2.97 2.76 2.97 1.79 0 2.75-1.22 2.75-2.97v-.5c0-1.68-.97-2.94-2.75-2.94zm0 1.04c.97 0 1.44.79 1.44 1.92v.47c0 1.12-.47 1.93-1.44 1.93s-1.45-.82-1.45-1.93v-.47c0-1.12.48-1.92 1.45-1.92zm6.69 6.53c-.75 0-1.24-.39-1.35-.85H69.9c.12 1.03.94 1.85 2.62 1.85 1.4 0 2.76-.72 2.76-2.36V4.8H74v.9h-.04c-.27-.55-.94-.99-1.79-.99-1.43 0-2.41 1.02-2.41 2.88v.44c0 1.88.99 2.89 2.41 2.89.86 0 1.52-.44 1.76-.98h.05v.9c0 .9-.56 1.42-1.45 1.42zm.02-6.48c.87 0 1.43.7 1.43 1.87v.37c0 1.18-.53 1.87-1.43 1.87-.92 0-1.47-.69-1.47-1.87v-.37c0-1.2.55-1.87 1.47-1.87zm9.7 5.21V4.14h2.36V3h-6.02v1.14h2.35V11h1.32zm3.3 0h1.3V7.3c0-.8.45-1.46 1.37-1.46.78 0 1.35.45 1.35 1.45V11h1.3V7.02c0-1.51-.92-2.3-2.18-2.3-1.01 0-1.57.54-1.79.95h-.04V2.58h-1.3V11zm9.34.1c1.53 0 2.34-.88 2.53-1.88h-1.24c-.16.53-.61.86-1.27.86-.89 0-1.45-.7-1.45-1.73V8.2h4.03v-.6c0-1.74-1-2.9-2.65-2.9-1.63 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.05 2.93 2.71 2.93zm-1.43-3.8v-.02c0-.88.55-1.57 1.38-1.57.83 0 1.37.69 1.37 1.57v.01h-2.75zm5.42 3.7h1.29V7.17c0-.9.54-1.34 1.21-1.34.72 0 1.2.43 1.2 1.35V11h1.27V7.18c0-.82.45-1.35 1.22-1.35.76 0 1.2.49 1.2 1.27V11h1.3V6.78c0-1.25-.76-2.07-2.06-2.07-1.02 0-1.67.5-1.88 1.03h-.06c-.22-.62-.8-1.03-1.75-1.03-.88 0-1.42.49-1.6.93h-.07V4.8h-1.28V11zm12.77.1c1.53 0 2.34-.88 2.52-1.88h-1.23c-.16.53-.61.86-1.27.86-.89 0-1.45-.7-1.45-1.73V8.2h4.02v-.6c0-1.74-1-2.9-2.64-2.9-1.63 0-2.66 1.12-2.66 2.85v.63c0 1.83 1.05 2.93 2.7 2.93zm-1.43-3.8v-.02c0-.88.54-1.57 1.38-1.57.83 0 1.37.69 1.37 1.57v.01h-2.75z"
      />
      <style jsx>{`
        svg {
          opacity: 0.8;
          pointer-events: none;
        }
        .theme-1,
        .theme-2,
        .theme-3,
        .theme-4 {
          will-change: opacity, transform;
          animation: switching 8s ease infinite;
        }
        .theme-2 {
          animation-delay: -2s;
        }
        .theme-3 {
          animation-delay: -4s;
        }
        .theme-4 {
          animation-delay: -6s;
        }
        @keyframes switching {
          0% {
            opacity: 0;
            transform: translate3d(-80%, 0, 0);
          }
          25% {
            opacity: 0.2;
            transform: translate3d(-40%, 0, 0);
          }
          50% {
            opacity: 1;
            transform: translate3d(0%, 0, 0);
          }
          75% {
            opacity: 0.2;
            transform: translate3d(40%, 0, 0);
          }
          100% {
            opacity: 0;
            transform: translate3d(80%, 0, 0);
          }
        }
        .dash-ring {
          animation: rotation 3s linear infinite;
        }
        @keyframes rotation {
          0% {
            stroke-dashoffset: 0;
          }
          100% {
            stroke-dashoffset: -14;
          }
        }
      `}</style>
    </svg>
  );
}
