# Awesome Project Ideas
![Project Ideas](./assets/cover.png)

[![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat)](./CONTRIBUTING.md)

Do you want to learn web development, but just **don't know what to create?**
This list was designed for you then!

These ideas are great for:
- Displaying in your **portfolio**!
- Learn a new **JS Framework**!
- Practicing your **Webdev Skills**!

Each idea has the following features:
1. **Screenshots** of the idea.
2. **Details** that explain what should be implemented.
3. **Inspiration** resources that can help guide you.
4. **Hints** that you can use if you're stuck.
5. **Tutorials** as a last-resort in case you're stuck.

The ideas are split into 3 groups:

| Level | Requirements |
| --- | --- |
| Beginner | Know the basics of HTML, CSS, and JS. |
| Intermediate | Proficient in [web fundamentals](https://developer.mozilla.org/en-US/docs/Learn) |

## 👶️ Beginner
![Beginner](./assets/beginner.png)

### 1. Simple Calculator
![](./assets/simple_calc_carousel.png)

What better way to start off this list than the classic example: a calculator!

#### <img src="./assets/triangle.svg" width="15" height="15"/> Details
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can enter decimals.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can enter operators.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can see result.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> app saves history of math expressions.

#### <img src="./assets/triangle.svg" width="15" height="15"/> Inspiration
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Samsung Calculator](https://play.google.com/store/apps/details?id=com.sec.android.app.popupcalculator)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Google Calculator](https://play.google.com/store/apps/details?id=com.google.android.calculator)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Xiaomi Calculator](https://play.google.com/store/apps/details?id=com.miui.calculator)  

#### <img src="./assets/triangle.svg" width="15" height="15"/> Hints for Javascript
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> use [`eval()`](https://www.w3schools.com/jsref/jsref_eval.asp) to calculate.

#### <img src="./assets/triangle.svg" width="15" height="15"/> Tutorials for React
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Tyler Potts | 21K views | 7 months ago](https://youtu.be/oiX-6Y2oGjI)  
[![](https://img.youtube.com/vi/oiX-6Y2oGjI/default.jpg)](https://youtu.be/oiX-6Y2oGjI)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Web Dev Simplified | 73K views | 3 months ago](https://youtu.be/DgRrrOt0Vr8)  
[![](https://img.youtube.com/vi/DgRrrOt0Vr8/default.jpg)](https://youtu.be/DgRrrOt0Vr8)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Digital Solutions Master | 30K views | 10 months ago](https://youtu.be/hpfDRnijdPE)  
[![](https://img.youtube.com/vi/hpfDRnijdPE/default.jpg)](https://youtu.be/hpfDRnijdPE)

### 2. Tic Tac Toe
![](./assets/tic-tac-toe-carousel.png)

We all know Tic Tac Toe...

#### <img src="./assets/triangle.svg" width="15" height="15"/> Details
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can play offline by switching between 2 players.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can choose a difficulty level.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can choose a board size.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can unlock achievements.   

#### <img src="./assets/triangle.svg" width="15" height="15"/> Inspiration
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Google's Tic Tac Toe](https://www.google.com/search?q=tic+tac+toe&oq=tic+tac+toe)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Classic Tic Tac Toe](https://playtictactoe.org/)

#### <img src="./assets/triangle.svg" width="15" height="15"/> Hints for Javascript
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> efficient algorithm for [detecting the winner](https://stackoverflow.com/questions/16571035/javascript-tictactoe-if-winner-detection)

#### <img src="./assets/triangle.svg" width="15" height="15"/> Tutorials for React
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [codeSTACKr | 31K views | 1 year ago](https://youtu.be/08r9mDQvXpU)  
[![](https://img.youtube.com/vi/08r9mDQvXpU/default.jpg)](https://youtu.be/08r9mDQvXpU)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Learn Code By Doing | 4.7K views | 10 months ago](https://youtu.be/mM-Se5TEmX8)  
[![](https://img.youtube.com/vi/mM-Se5TEmX8/default.jpg)](https://youtu.be/mM-Se5TEmX8)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Coding with Basir | 35K views | 2 years ago](https://youtu.be/it54tShOsuI)  
[![](https://img.youtube.com/vi/it54tShOsuI/default.jpg)](https://youtu.be/it54tShOsuI)  

### 3. Countdown Timer
![](./assets/countdown-timer-carousel.png)

Create an app that counts down the hours, minutes, and seconds.

#### <img src="./assets/triangle.svg" width="15" height="15"/> Details
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can enter an amount of time in hours, minutes, and seconds.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can visually see how much time is left.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can pause and reset the timer.  

#### <img src="./assets/triangle.svg" width="15" height="15"/> Inspiration
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Simple Timer (codepen)](https://codepen.io/karlo-stekovic/pen/OajKVK)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Stopwatch Timer App](https://play.google.com/store/apps/details?id=stopwatch.timer.app)

#### <img src="./assets/triangle.svg" width="15" height="15"/> Hints for Javascript
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> Use [`setInterval`](https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/setInterval) and [`clearInterval`](https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/clearInterval) to create and reset the timer.  

#### <img src="./assets/triangle.svg" width="15" height="15"/> Tutorials for React
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Code Boost | 9.8K views | 1 year ago](https://youtu.be/sSWGdj8a5Fs)  
[![](https://img.youtube.com/vi/sSWGdj8a5Fs/default.jpg)](https://youtu.be/sSWGdj8a5Fs)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Coding with Elias | 19K views | 2 years ago](https://youtu.be/qwKh4pH7KAk)  
[![](https://img.youtube.com/vi/qwKh4pH7KAk/default.jpg)](https://youtu.be/qwKh4pH7KAk)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Uzoanya Dominic | 24K views | 1 year ago](https://youtu.be/ZVOGPvo08zM)  
[![](https://img.youtube.com/vi/ZVOGPvo08zM/default.jpg)](https://youtu.be/ZVOGPvo08zM)  

### 4. Notes
![](./assets/notes-carousel.png)

Write down what's on your mind!

#### <img src="./assets/triangle.svg" width="15" height="15"/> Details
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can create Markdown notes.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can star notes.  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can reorder, edit and delete notes.  

#### <img src="./assets/triangle.svg" width="15" height="15"/> Inspiration
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Markdown Notes with React](https://github.com/email2vimalraj/notes-app)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Notes App Android](https://play.google.com/store/apps/details?id=com.eco.note)  
 
#### <img src="./assets/triangle.svg" width="15" height="15"/> Hints for Javascript
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> Use [Marked](https://github.com/markedjs/marked) to transform Markdown to HTML.  
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> Use [`localStorage`](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage) to save notes.  

#### <img src="./assets/triangle.svg" width="15" height="15"/> Tutorials for React
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Chris Blakely | 22K views | 9 months ago](https://youtu.be/8KB3DHI-QbM)  
[![](https://img.youtube.com/vi/8KB3DHI-QbM/default.jpg)](https://youtu.be/8KB3DHI-QbM)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [James Grimshaw | 12K views | 1 year ago](https://youtu.be/ulOKYl5sHGk)  
[![](https://img.youtube.com/vi/ulOKYl5sHGk/default.jpg)](https://youtu.be/ulOKYl5sHGk)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Dennis Ivy | 43K views | 5 months ago](https://youtu.be/tYKRAXIio28)  
[![](https://img.youtube.com/vi/tYKRAXIio28/default.jpg)](https://youtu.be/tYKRAXIio28)  

### 5. Pomodoro Timer
![](./assets/pomodoro-timer-carousel.png)

Efficiently manage your time using the Pomodoro!

#### <img src="./assets/triangle.svg" width="15" height="15"/> Details
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can start, pause, and stop work periods (25 minutes)  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can start, pause, and stop short breaks (5-10 minutes)  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> user can start, pause, and stop long breaks (20-30 minutes)  
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> app keeps history of work, short breaks, and long breaks.  

#### <img src="./assets/triangle.svg" width="15" height="15"/> Inspiration
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Online Pomodoro Timer](https://en.m.wikipedia.org/wiki/Pomodoro_Technique)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Pomodoro Android App](https://play.google.com/store/apps/details?id=com.pomodrone.app)  
 
#### <img src="./assets/triangle.svg" width="15" height="15"/> Hints for Javascript
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> Learn more about the [pomodoro technique](https://en.wikipedia.org/wiki/Pomodoro_Technique)  
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> Use [`localStorage`](https://developer.mozilla.org/en-US/docs/Web/API/Window/localStorage) to save notes.  
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> Use [`setInterval`](https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/setInterval) and [`clearInterval`](https://developer.mozilla.org/en-US/docs/Web/API/WindowOrWorkerGlobalScope/clearInterval) to create and reset the timer.  

#### <img src="./assets/triangle.svg" width="15" height="15"/> Tutorials for React
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Coding With Dawid | 4.6K views | 6 months ago](https://youtu.be/B1tjrnX160k)  
[![](https://img.youtube.com/vi/B1tjrnX160k/default.jpg)](https://youtu.be/B1tjrnX160k)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Siphiwo Julayi | 7.7K views | 1 year ago](https://youtu.be/0PnSEPm2UKY)  
[![](https://img.youtube.com/vi/0PnSEPm2UKY/default.jpg)](https://youtu.be/0PnSEPm2UKY)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Siphiwo Julayi | 7.7K views | 1 year ago](https://youtu.be/9z1qBcFwdXg)  
[![](https://img.youtube.com/vi/9z1qBcFwdXg/default.jpg)](https://youtu.be/9z1qBcFwdXg)  


## 💪️ Intermediate
![Intermediate](./assets/intermediate.png)

### 1. Airbnb Clone
![](./assets/airbnb-clone-carousel.png)

Airbnb has very beatiful UI... Let's recreate it!

#### <img src="./assets/triangle.svg" width="15" height="15"/> Details
<img src="./assets/checkmark.svg" width="20" height="20" alt="checkmark"/> create an app whose UI is similar to that of Airbnb.

#### <img src="./assets/triangle.svg" width="15" height="15"/> Inspiration
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [The Airbnb Design Blog](https://medium.com/airbnb-design)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Airbnb Android App](https://play.google.com/store/apps/details?id=com.airbnb.android)  
<img src="./assets/magic.svg" width="20" height="20" alt="magic wand"/> [Airbnb iOS App](https://abnb.me/EVmg/xw6tvraTDs)

#### <img src="./assets/triangle.svg" width="15" height="15"/> Hints for React
<img src="./assets/eye.svg" width="20" height="20" alt="eye"/> Use [Material UI](https://mui.com/) to build the UI.

#### <img src="./assets/triangle.svg" width="15" height="15"/> Tutorials for React
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Clever Programmer | 169K views | 1 year ago](https://youtu.be/BtJeH_-XYaA)  
[![](https://img.youtube.com/vi/BtJeH_-XYaA/default.jpg)](https://youtu.be/BtJeH_-XYaA)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [notJust.dev | 28K views | 1 year ago](https://youtu.be/ch2oOdnLkqw)  
[![](https://img.youtube.com/vi/ch2oOdnLkqw/default.jpg)](https://youtu.be/ch2oOdnLkqw)  
<img src="./assets/youtube.svg" width="20" height="20" alt="youtube"/> [Shloka Tech | 4.4K views | 1 year ago](https://youtu.be/JD_4iQ_gErk)  
[![](https://img.youtube.com/vi/JD_4iQ_gErk/default.jpg)](https://youtu.be/JD_4iQ_gErk)  