import React from "react";
import NavbarMain from "../../components/navbar-main";
import "./styles.css";
import "./style.css";
import { useState, CSSProperties, useEffect } from "react";
import { useNavigate } from "react-router-dom";
import IP_ADDRESS from "../consts";
import { BarLoader, CircleLoader, ClipLoader } from "react-spinners";



export default function UserSearch() {

    const [loading, setLoading] = useState(false);
    const [error, setError] = useState(null);

    const [text_area, setText_area] = useState('');
    const [genre, setGenre] = useState('');

    const navigate = useNavigate();

    const [backgroundFade, setBackgroundFade] = useState(false);

    const genre_list = [];



    async function handleOnSubmit(event) {
        event.preventDefault(); // Prevent default form submission

        setLoading(true); // Set loading state

        const formData = new FormData();

        try {
            formData.append('query', text_area);
            // formData.append('genre', genre);


            var requestOptions1 = {
                method: 'POST',
                body: formData,
                headers: {
                    'Origin': `${IP_ADDRESS}` // Replace with your React app's origin
                },
                // redirect: 'follow'
            };



            const response = await fetch(`${IP_ADDRESS}/findBook/querySearch`, requestOptions1)


            const data = await response.json();
            // navigate("/upload-success")
            console.log(data);

            // console.log("genre is :  ",data['genre']);
            genre_list.push(data['genre']);





            navigate("/results", {
                state: {
                    apiResponse: data,
                    textAreaValue: text_area,
                },
            });
        }

        catch (error) {
            console.error(error);
            setError('Error submitting form.');
            <h1>Error Occurred</h1>

            setLoading(false); // Reset loading state

        }

        finally {
            setLoading(false); // Reset loading state
        }


    }

    useEffect(() => {
        // Update background fade based on loading state
        setBackgroundFade(loading);
    }, [loading]);





    return (

        <div className={`MainContainer  ${backgroundFade ? "fade" : ""}`}>
            <div>
                <NavbarMain />
            </div>
            {
                        loading && (

                            <div className="overlay">


                                <div class="AnimationBox">
                                    <div class="star">
                                        <svg class="star1" width="33" height="33" viewBox="0 0 33 33" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_761_828)">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.0487 2.69824C12.2415 2.6984 10.4605 3.13073 8.85435 3.95917C7.24821 4.78761 5.86347 5.98813 4.81566 7.46058C3.76785 8.93303 3.08736 10.6347 2.83096 12.4236C2.57455 14.2126 2.74968 16.0369 3.34172 17.7444C3.93375 19.4518 4.92554 20.993 6.23433 22.2392C7.54311 23.4854 9.13095 24.4006 10.8654 24.9084C12.5998 25.4161 14.4305 25.5018 16.2047 25.1581C17.9789 24.8145 19.6453 24.0515 21.0647 22.9329L25.934 27.8022C26.1855 28.0451 26.5223 28.1795 26.8719 28.1765C27.2215 28.1734 27.5559 28.0332 27.8031 27.786C28.0503 27.5388 28.1905 27.2044 28.1936 26.8548C28.1966 26.5052 28.0622 26.1684 27.8193 25.9169L22.95 21.0476C24.2673 19.3764 25.0876 17.3681 25.3168 15.2525C25.5461 13.137 25.1751 10.9996 24.2463 9.08503C23.3175 7.17046 21.8685 5.55605 20.0651 4.42655C18.2616 3.29705 16.1766 2.6981 14.0487 2.69824ZM5.38201 14.0316C5.38201 11.733 6.2951 9.52863 7.92042 7.90332C9.54573 6.278 11.7501 5.36491 14.0487 5.36491C16.3472 5.36491 18.5516 6.278 20.1769 7.90332C21.8023 9.52863 22.7153 11.733 22.7153 14.0316C22.7153 16.3301 21.8023 18.5345 20.1769 20.1598C18.5516 21.7852 16.3472 22.6982 14.0487 22.6982C11.7501 22.6982 9.54573 21.7852 7.92042 20.1598C6.2951 18.5345 5.38201 16.3301 5.38201 14.0316Z" fill="#797DD5" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_761_828">
                                                    <rect width="32" height="32" fill="white" transform="translate(0.048584 0.0317383)" />
                                                </clipPath>
                                            </defs>
                                        </svg>

                                    </div>
                                    <div class="book"> <svg class="book" width="89" height="119" viewBox="0 0 89 119" fill="none" xmlns="http://www.w3.org/2000/svg">
                                        <rect x="10.5793" y="3.16602" width="75.2194" height="104.774" rx="5.5" stroke="#DAE2FF" stroke-width="5" />
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M74.6782 24.2559H8.07946V33.805H74.6782V24.2559ZM74.6781 47.0981H8.07935V56.6473H74.6781V47.0981ZM8.07935 69.9404H74.6781V79.4895H8.07935V69.9404ZM74.6781 92.7827H8.07935V102.332H74.6781V92.7827Z" fill="url(#paint0_linear_607_682)" />
                                        <rect x="0.808105" y="8.90625" width="79.2194" height="108.774" rx="7.5" fill="url(#paint1_linear_607_682)" stroke="#DAE2FF" />
                                        <path fill-rule="evenodd" clip-rule="evenodd" d="M74.6782 29.0294C74.6782 26.3925 72.5405 24.2549 69.9036 24.2549H12.854C10.2171 24.2549 8.07946 26.3925 8.07946 29.0294V29.0294C8.07946 31.6664 10.2171 33.804 12.854 33.804H69.9036C72.5405 33.804 74.6782 31.6664 74.6782 29.0294V29.0294ZM74.6781 51.8717C74.6781 49.2348 72.5404 47.0972 69.9035 47.0972H12.8539C10.217 47.0972 8.07935 49.2348 8.07935 51.8717V51.8717C8.07935 54.5086 10.217 56.6463 12.8539 56.6463H69.9035C72.5404 56.6463 74.6781 54.5086 74.6781 51.8717V51.8717ZM8.07935 74.714C8.07935 72.0771 10.217 69.9394 12.8539 69.9394H69.9035C72.5404 69.9394 74.6781 72.0771 74.6781 74.714V74.714C74.6781 77.3509 72.5404 79.4886 69.9035 79.4886H12.8539C10.217 79.4886 8.07935 77.3509 8.07935 74.714V74.714ZM74.6781 97.5563C74.6781 94.9194 72.5404 92.7817 69.9035 92.7817H12.8539C10.217 92.7817 8.07935 94.9194 8.07935 97.5563V97.5563C8.07935 100.193 10.217 102.331 12.8539 102.331H69.9035C72.5404 102.331 74.6781 100.193 74.6781 97.5563V97.5563Z" fill="url(#paint2_linear_607_682)" />
                                        <defs>
                                            <linearGradient id="paint0_linear_607_682" x1="8.07935" y1="102.727" x2="74.6781" y2="102.727" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#EFEFFF" />
                                                <stop offset="1" stop-color="#D3D2FF" />
                                            </linearGradient>
                                            <linearGradient id="paint1_linear_607_682" x1="40.4178" y1="8.40625" x2="40.4178" y2="118.18" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#7073CA" />
                                                <stop offset="1" stop-color="#8487E2" />
                                            </linearGradient>
                                            <linearGradient id="paint2_linear_607_682" x1="8.07935" y1="102.726" x2="74.6781" y2="102.726" gradientUnits="userSpaceOnUse">
                                                <stop stop-color="#EFEFFF" />
                                                <stop offset="1" stop-color="#D3D2FF" />
                                            </linearGradient>
                                        </defs>
                                    </svg>
                                    </div>
                                    <div class="star down">
                                        <svg class="star2" width="19" height="19" viewBox="0 0 33 33" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <g clip-path="url(#clip0_761_828)">
                                                <path fill-rule="evenodd" clip-rule="evenodd" d="M14.0487 2.69824C12.2415 2.6984 10.4605 3.13073 8.85435 3.95917C7.24821 4.78761 5.86347 5.98813 4.81566 7.46058C3.76785 8.93303 3.08736 10.6347 2.83096 12.4236C2.57455 14.2126 2.74968 16.0369 3.34172 17.7444C3.93375 19.4518 4.92554 20.993 6.23433 22.2392C7.54311 23.4854 9.13095 24.4006 10.8654 24.9084C12.5998 25.4161 14.4305 25.5018 16.2047 25.1581C17.9789 24.8145 19.6453 24.0515 21.0647 22.9329L25.934 27.8022C26.1855 28.0451 26.5223 28.1795 26.8719 28.1765C27.2215 28.1734 27.5559 28.0332 27.8031 27.786C28.0503 27.5388 28.1905 27.2044 28.1936 26.8548C28.1966 26.5052 28.0622 26.1684 27.8193 25.9169L22.95 21.0476C24.2673 19.3764 25.0876 17.3681 25.3168 15.2525C25.5461 13.137 25.1751 10.9996 24.2463 9.08503C23.3175 7.17046 21.8685 5.55605 20.0651 4.42655C18.2616 3.29705 16.1766 2.6981 14.0487 2.69824ZM5.38201 14.0316C5.38201 11.733 6.2951 9.52863 7.92042 7.90332C9.54573 6.278 11.7501 5.36491 14.0487 5.36491C16.3472 5.36491 18.5516 6.278 20.1769 7.90332C21.8023 9.52863 22.7153 11.733 22.7153 14.0316C22.7153 16.3301 21.8023 18.5345 20.1769 20.1598C18.5516 21.7852 16.3472 22.6982 14.0487 22.6982C11.7501 22.6982 9.54573 21.7852 7.92042 20.1598C6.2951 18.5345 5.38201 16.3301 5.38201 14.0316Z" fill="#797DD5" />
                                            </g>
                                            <defs>
                                                <clipPath id="clip0_761_828">
                                                    <rect width="32" height="32" fill="white" transform="translate(0.048584 0.0317383)" />
                                                </clipPath>
                                            </defs>
                                        </svg>
                                    </div>
                                </div>

                            </div>


                        )
                    }

            <div className="container4">
                <div className="bg">
                <svg width="414" height="724" viewBox="0 0 414 724" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M216.997 0H0.000152588V723.263H413.375L216.997 0Z" fill="url(#paint0_linear_798_696)"/>
<defs>
<linearGradient id="paint0_linear_798_696" x1="-12.9962" y1="553.088" x2="297.513" y2="607.227" gradientUnits="userSpaceOnUse">
<stop stop-color="white"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>
<svg width="414" height="724" viewBox="0 0 414 724" fill="none" xmlns="http://www.w3.org/2000/svg">
<path d="M197.003 0H414V723.263H0.624512L197.003 0Z" fill="url(#paint0_linear_798_690)"/>
<defs>
<linearGradient id="paint0_linear_798_690" x1="426.996" y1="553.088" x2="116.487" y2="607.227" gradientUnits="userSpaceOnUse">
<stop stop-color="white"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>

                </div>
                <div className="el">
                    <svg width="316" height="64" viewBox="0 0 316 64" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="0.536285" y="24.0666" width="312" height="39" rx="15.5" transform="rotate(-4.32521 0.536285 24.0666)" fill="#F8F1FF"/>
<rect x="0.536285" y="24.0666" width="312" height="39" rx="15.5" transform="rotate(-4.32521 0.536285 24.0666)" stroke="url(#paint0_linear_807_335)"/>
<path d="M34.6789 45.974L37.9824 48.8129M36.461 40.485C36.7768 44.66 33.6594 48.2995 29.4992 48.6142C25.3381 48.9289 21.7088 45.7997 21.3931 41.6256C21.0772 37.4485 24.1947 33.81 28.3548 33.4954C32.5159 33.1807 36.1452 36.3099 36.461 40.485Z" stroke="url(#paint1_linear_807_335)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M49.8851 35.1918L49.7791 33.7895L59.5693 33.049L59.6753 34.4513L55.5706 34.7617L56.4518 46.4131L54.8711 46.5327L53.9899 34.8813L49.8851 35.1918ZM64.9541 45.9752C64.0108 46.0465 63.1813 45.8999 62.4657 45.5352C61.754 45.1659 61.1849 44.6192 60.7583 43.8951C60.3357 43.1664 60.0864 42.3006 60.0106 41.2978C59.9347 40.295 60.0506 39.3973 60.3582 38.6048C60.6697 37.8077 61.1386 37.1697 61.7647 36.6907C62.3948 36.2072 63.1518 35.932 64.0356 35.8651C64.5455 35.8265 65.0555 35.8734 65.5655 36.0058C66.0755 36.1382 66.549 36.3802 66.9858 36.7317C67.4223 37.0791 67.7853 37.5559 68.0748 38.1622C68.3642 38.7685 68.5435 39.5285 68.6126 40.4421L68.6608 41.0794L61.1142 41.6502L61.0158 40.3499L67.0327 39.8949C66.991 39.3425 66.8432 38.8579 66.5895 38.4412C66.34 38.0242 66.0039 37.7056 65.5813 37.4854C65.1629 37.2649 64.6817 37.1752 64.1378 37.2164C63.5387 37.2617 63.0315 37.4496 62.6164 37.7802C62.2051 38.1061 61.9005 38.5138 61.7024 39.0031C61.5044 39.4925 61.4258 40.007 61.4666 40.5466L61.5322 41.4135C61.5881 42.1528 61.763 42.77 62.0568 43.2648C62.3546 43.7551 62.7431 44.1168 63.2222 44.3498C63.7011 44.5785 64.2443 44.6699 64.8519 44.6239C65.2471 44.5941 65.5999 44.5118 65.9102 44.3772C66.2245 44.2381 66.4899 44.0471 66.7066 43.8042C66.923 43.557 67.082 43.2587 67.1838 42.9091L68.6679 43.2071C68.5522 43.7116 68.3279 44.1645 67.995 44.5657C67.6618 44.9627 67.2375 45.2854 66.722 45.5338C66.2063 45.7779 65.617 45.9251 64.9541 45.9752ZM71.2592 32.1649L72.2464 45.2185L70.7422 45.3323L69.7549 32.2787L71.2592 32.1649ZM74.98 31.8835L75.9673 44.9371L74.4631 45.0509L73.4758 31.9973L74.98 31.8835ZM82.6936 44.4284L81.9531 34.6382L83.4063 34.5283L83.522 36.058L83.6495 36.0483C83.8139 35.5103 84.1126 35.0795 84.5454 34.7562C84.9779 34.4286 85.5128 34.2407 86.1502 34.1925C86.7961 34.1437 87.3447 34.2496 87.796 34.5104C88.2513 34.7665 88.6198 35.1468 88.9015 35.6511L89.0035 35.6434C89.216 35.1188 89.5617 34.6888 90.0406 34.3534C90.5192 34.0138 91.109 33.8175 91.8102 33.7644C92.6855 33.6982 93.4222 33.9182 94.0203 34.4242C94.6181 34.926 94.9606 35.7527 95.0476 36.9042L95.5432 43.4565L94.039 43.5703L93.5434 37.018C93.4888 36.2956 93.2522 35.7943 92.8335 35.514C92.4149 35.2337 91.9379 35.1138 91.4024 35.1543C90.7141 35.2063 90.1965 35.4549 89.8499 35.8999C89.5029 36.3407 89.3533 36.8776 89.4012 37.5108L89.8832 43.8846L88.3535 44.0003L87.8464 37.295C87.8043 36.7384 87.5898 36.3037 87.2029 35.9911C86.8157 35.6743 86.3374 35.5374 85.768 35.5804C85.377 35.61 85.0195 35.7417 84.6953 35.9757C84.3754 36.2093 84.1253 36.5188 83.945 36.9042C83.7687 37.2851 83.6987 37.7156 83.735 38.1957L84.1978 44.3146L82.6936 44.4284ZM101.875 43.1828C100.932 43.2541 100.102 43.1074 99.3868 42.7428C98.6751 42.3735 98.106 41.8268 97.6794 41.1026C97.2568 40.3739 97.0076 39.5081 96.9317 38.5053C96.8559 37.5025 96.9717 36.6049 97.2793 35.8124C97.5908 35.0153 98.0597 34.3773 98.6858 33.8983C99.3159 33.4147 100.073 33.1395 100.957 33.0727C101.467 33.0341 101.977 33.081 102.487 33.2134C102.997 33.3457 103.47 33.5877 103.907 33.9393C104.343 34.2866 104.706 34.7634 104.996 35.3698C105.285 35.9761 105.465 36.736 105.534 37.6496L105.582 38.287L98.0353 38.8578L97.9369 37.5575L103.954 37.1024C103.912 36.55 103.764 36.0655 103.511 35.6488C103.261 35.2317 102.925 34.9131 102.502 34.693C102.084 34.4725 101.603 34.3828 101.059 34.4239C100.46 34.4692 99.9526 34.6572 99.5375 34.9877C99.1262 35.3137 98.8216 35.7214 98.6236 36.2107C98.4255 36.7 98.3469 37.2145 98.3877 37.7542L98.4533 38.621C98.5092 39.3604 98.6841 39.9775 98.9779 40.4724C99.2757 40.9627 99.6642 41.3243 100.143 41.5573C100.622 41.7861 101.165 41.8775 101.773 41.8315C102.168 41.8016 102.521 41.7194 102.831 41.5848C103.146 41.4456 103.411 41.2546 103.628 41.0117C103.844 40.7646 104.003 40.4662 104.105 40.1167L105.589 40.4147C105.473 40.9192 105.249 41.372 104.916 41.7733C104.583 42.1703 104.159 42.493 103.643 42.7413C103.127 42.9855 102.538 43.1326 101.875 43.1828ZM115.071 42.2103C114.451 42.2573 113.879 42.183 113.356 41.9875C112.832 41.7878 112.405 41.4761 112.073 41.0525C111.742 40.6245 111.552 40.0919 111.504 39.4545C111.461 38.8936 111.538 38.4306 111.732 38.0654C111.926 37.696 112.201 37.3975 112.555 37.1698C112.91 36.9421 113.307 36.7626 113.745 36.6311C114.188 36.495 114.635 36.3801 115.085 36.2862C115.674 36.1647 116.152 36.0709 116.519 36.0047C116.889 35.9339 117.156 35.8432 117.319 35.7326C117.485 35.6217 117.56 35.4452 117.541 35.203L117.537 35.152C117.49 34.5231 117.281 34.0474 116.91 33.725C116.544 33.4023 116.015 33.2671 115.322 33.3195C114.604 33.3738 114.053 33.5736 113.669 33.9189C113.284 34.2642 113.023 34.6216 112.884 34.9911L111.418 34.5892C111.628 33.975 111.933 33.4861 112.333 33.1225C112.736 32.7544 113.186 32.4853 113.682 32.3154C114.181 32.1408 114.678 32.0349 115.171 31.9976C115.485 31.9738 115.849 31.9848 116.263 32.0304C116.681 32.0715 117.089 32.1923 117.489 32.3928C117.893 32.593 118.24 32.9151 118.53 33.3589C118.82 33.8028 118.994 34.4136 119.053 35.1912L119.541 41.6415L118.037 41.7553L117.937 40.4295L117.86 40.4353C117.774 40.6555 117.621 40.8957 117.402 41.1559C117.182 41.4161 116.881 41.6461 116.499 41.846C116.117 42.0458 115.641 42.1673 115.071 42.2103ZM115.199 40.8417C115.793 40.7967 116.286 40.642 116.676 40.3774C117.071 40.1125 117.358 39.7874 117.538 39.4019C117.723 39.0162 117.8 38.6193 117.769 38.2114L117.665 36.8347C117.607 36.916 117.472 36.9967 117.26 37.0768C117.052 37.1524 116.81 37.2241 116.533 37.2921C116.26 37.3555 115.993 37.4141 115.732 37.468C115.475 37.5174 115.266 37.5588 115.107 37.5923C114.72 37.6728 114.36 37.7833 114.029 37.9237C113.702 38.0596 113.443 38.248 113.251 38.489C113.064 38.7254 112.985 39.0348 113.014 39.4172C113.053 39.9399 113.277 40.3204 113.684 40.5589C114.094 40.7928 114.599 40.887 115.199 40.8417ZM121.952 41.4592L120.965 28.4055L122.469 28.2918L122.834 33.1104L122.961 33.1007C123.059 32.9224 123.195 32.6941 123.371 32.4159C123.55 32.1331 123.817 31.8736 124.171 31.6374C124.529 31.3967 125.026 31.2522 125.664 31.204C126.488 31.1417 127.23 31.2928 127.89 31.6574C128.55 32.022 129.085 32.5692 129.495 33.2988C129.905 34.0285 130.149 34.9075 130.227 35.9358C130.305 36.9727 130.197 37.8847 129.902 38.672C129.606 39.455 129.162 40.0784 128.569 40.5421C127.975 41.0015 127.271 41.262 126.455 41.3237C125.826 41.3713 125.314 41.3053 124.921 41.1257C124.526 40.9418 124.217 40.7237 123.993 40.4715C123.768 40.2149 123.594 40.0016 123.47 39.8315L123.292 39.845L123.405 41.3492L121.952 41.4592ZM123.061 36.4522C123.117 37.1916 123.274 37.8356 123.534 38.3844C123.793 38.9289 124.143 39.3447 124.583 39.6319C125.023 39.9149 125.545 40.0335 126.149 39.9879C126.777 39.9403 127.29 39.7349 127.685 39.3717C128.085 39.0039 128.369 38.5293 128.539 37.9481C128.713 37.3623 128.773 36.721 128.721 36.0241C128.669 35.3357 128.515 34.7234 128.261 34.1871C128.011 33.6462 127.661 33.2303 127.212 32.9395C126.766 32.6441 126.225 32.5206 125.587 32.5688C124.976 32.615 124.473 32.809 124.08 33.1507C123.687 33.4881 123.405 33.9411 123.234 34.5096C123.063 35.0738 123.005 35.7213 123.061 36.4522ZM136.35 40.5753C135.466 40.6422 134.675 40.4905 133.976 40.1203C133.281 39.7497 132.718 39.2004 132.287 38.4723C131.86 37.7439 131.609 36.8741 131.532 35.8628C131.455 34.8429 131.573 33.9387 131.885 33.1502C132.201 32.3613 132.675 31.7314 133.306 31.2606C133.941 30.7895 134.701 30.5205 135.585 30.4537C136.469 30.3868 137.258 30.5387 137.953 30.9092C138.651 31.2794 139.215 31.8308 139.642 32.5635C140.073 33.2958 140.328 34.1719 140.405 35.1917C140.481 36.203 140.361 37.101 140.044 37.8856C139.732 38.67 139.258 39.2977 138.623 39.7688C137.992 40.2396 137.234 40.5085 136.35 40.5753ZM136.248 39.2241C136.919 39.1733 137.459 38.9594 137.866 38.5824C138.274 38.2055 138.56 37.7287 138.726 37.152C138.892 36.5754 138.95 35.9599 138.9 35.3055C138.851 34.6511 138.701 34.0492 138.45 33.4998C138.199 32.9504 137.843 32.5179 137.384 32.2022C136.924 31.8866 136.358 31.7541 135.687 31.8049C135.016 31.8557 134.476 32.0717 134.069 32.4529C133.662 32.8341 133.376 33.3152 133.21 33.8961C133.045 34.477 132.987 35.0946 133.037 35.749C133.086 36.4034 133.236 37.0031 133.487 37.5483C133.737 38.0934 134.092 38.5217 134.552 38.8331C135.011 39.1445 135.577 39.2748 136.248 39.2241ZM148.396 35.4335L147.958 29.646L149.462 29.5323L150.203 39.3225L148.699 39.4362L148.573 37.779L148.471 37.7868C148.279 38.3013 147.954 38.7511 147.496 39.1361C147.038 39.517 146.439 39.7353 145.7 39.7913C145.088 39.8375 144.534 39.7448 144.038 39.5131C143.541 39.2772 143.136 38.8975 142.823 38.3742C142.51 37.8466 142.322 37.1664 142.259 36.3335L141.788 30.1127L143.293 29.9989L143.755 36.1178C143.809 36.8317 144.052 37.3859 144.484 37.7807C144.919 38.1751 145.45 38.3486 146.074 38.3014C146.448 38.2731 146.821 38.1487 147.194 37.9283C147.57 37.7075 147.875 37.3895 148.109 36.9744C148.346 36.559 148.442 36.0454 148.396 35.4335ZM155.937 29.0426L156.033 30.3173L150.96 30.7011L150.863 29.4263L155.937 29.0426ZM152.165 26.9689L153.669 26.8551L154.374 36.1864C154.407 36.6114 154.492 36.9254 154.632 37.1285C154.775 37.3271 154.947 37.4551 155.148 37.5126C155.353 37.5654 155.566 37.5835 155.787 37.5668C155.952 37.5543 156.088 37.5355 156.193 37.5105C156.297 37.4812 156.381 37.4578 156.444 37.4402L156.852 38.7683C156.753 38.8143 156.613 38.8633 156.433 38.9153C156.254 38.9716 156.024 39.0104 155.744 39.0316C155.319 39.0638 154.895 39.0039 154.474 38.852C154.056 38.6998 153.699 38.4469 153.403 38.0932C153.112 37.7392 152.944 37.2775 152.901 36.7081L152.165 26.9689ZM169.869 41.5274L169.477 36.3519L169.35 36.3615C169.253 36.5483 169.112 36.7854 168.929 37.0728C168.745 37.3559 168.472 37.618 168.11 37.8591C167.748 38.0959 167.252 38.2381 166.623 38.2857C165.807 38.3474 165.072 38.1958 164.416 37.8308C163.76 37.4617 163.227 36.9122 162.817 36.1825C162.407 35.4486 162.162 34.5632 162.084 33.5264C162.006 32.4981 162.115 31.5924 162.41 30.8094C162.706 30.0263 163.153 29.405 163.75 28.9452C164.348 28.4855 165.059 28.2244 165.883 28.1621C166.521 28.1139 167.032 28.182 167.418 28.3665C167.808 28.5465 168.11 28.7629 168.326 29.0158C168.546 29.2641 168.717 29.4691 168.841 29.6307L169.019 29.6172L168.901 28.062L170.355 27.9521L171.373 41.4137L169.869 41.5274ZM166.725 36.919C167.328 36.8734 167.827 36.6776 168.219 36.3316C168.611 35.9814 168.895 35.5177 169.069 34.9404C169.243 34.3589 169.302 33.6984 169.246 32.9591C169.191 32.2282 169.036 31.5967 168.782 31.0646C168.528 30.5283 168.181 30.1229 167.742 29.8485C167.302 29.5698 166.776 29.4536 166.164 29.4998C165.527 29.548 165.008 29.7518 164.608 30.1111C164.211 30.4659 163.928 30.9296 163.758 31.5024C163.591 32.0705 163.534 32.6988 163.586 33.3871C163.639 34.084 163.793 34.7091 164.049 35.2624C164.308 35.8112 164.661 36.2375 165.107 36.5414C165.557 36.8407 166.096 36.9666 166.725 36.919ZM179.177 33.1054L178.74 27.3179L180.244 27.2042L180.984 36.9944L179.48 37.1082L179.355 35.451L179.253 35.4587C179.061 35.9732 178.736 36.423 178.278 36.8081C177.819 37.1889 177.221 37.4073 176.481 37.4632C175.869 37.5095 175.315 37.4167 174.819 37.185C174.323 36.9491 173.918 36.5694 173.605 36.0461C173.291 35.5185 173.103 34.8383 173.04 34.0055L172.57 27.7846L174.074 27.6708L174.537 33.7897C174.591 34.5036 174.833 35.0579 175.265 35.4526C175.701 35.847 176.231 36.0205 176.856 35.9733C177.23 35.945 177.603 35.8206 177.975 35.6002C178.351 35.3794 178.656 35.0615 178.89 34.6464C179.128 34.2309 179.224 33.7173 179.177 33.1054ZM186.099 36.8383C185.479 36.8852 184.907 36.811 184.384 36.6155C183.86 36.4158 183.433 36.1041 183.101 35.6804C182.77 35.2525 182.58 34.7198 182.532 34.0825C182.489 33.5216 182.565 33.0585 182.76 32.6934C182.954 32.324 183.229 32.0254 183.583 31.7978C183.938 31.5701 184.335 31.3905 184.773 31.259C185.216 31.123 185.663 31.008 186.113 30.9142C186.702 30.7927 187.18 30.6988 187.547 30.6326C187.917 30.5619 188.184 30.4712 188.346 30.3606C188.513 30.2497 188.588 30.0731 188.569 29.8309L188.565 29.7799C188.518 29.151 188.309 28.6754 187.938 28.353C187.572 28.0303 187.042 27.8951 186.35 27.9475C185.632 28.0018 185.081 28.2016 184.696 28.5469C184.312 28.8922 184.051 29.2496 183.912 29.619L182.446 29.2171C182.656 28.6029 182.961 28.1141 183.361 27.7505C183.764 27.3823 184.214 27.1133 184.71 26.9433C185.209 26.7688 185.706 26.6629 186.199 26.6256C186.513 26.6018 186.877 26.6127 187.291 26.6584C187.708 26.6994 188.117 26.8202 188.517 27.0208C188.921 27.221 189.268 27.543 189.558 27.9869C189.848 28.4308 190.022 29.0415 190.081 29.8191L190.569 36.2695L189.065 36.3832L188.965 35.0575L188.888 35.0633C188.802 35.2834 188.649 35.5236 188.43 35.7838C188.21 36.044 187.909 36.2741 187.527 36.4739C187.144 36.6738 186.669 36.7952 186.099 36.8383ZM186.226 35.4697C186.821 35.4247 187.314 35.2699 187.704 35.0054C188.099 34.7405 188.386 34.4153 188.566 34.0299C188.751 33.6441 188.828 33.2473 188.797 32.8394L188.693 31.4626C188.635 31.5439 188.5 31.6247 188.288 31.7048C188.08 31.7803 187.837 31.8521 187.561 31.92C187.288 31.9834 187.021 32.0421 186.76 32.096C186.503 32.1453 186.294 32.1868 186.135 32.2202C185.747 32.3008 185.388 32.4113 185.057 32.5517C184.73 32.6876 184.47 32.876 184.279 33.1169C184.092 33.3533 184.013 33.6627 184.042 34.0452C184.081 34.5678 184.305 34.9484 184.711 35.1868C185.122 35.4207 185.627 35.515 186.226 35.4697ZM193.835 30.0993L194.28 35.9888L192.776 36.1025L192.036 26.3123L193.489 26.2024L193.605 27.7321L193.732 27.7225C193.924 27.208 194.242 26.7822 194.687 26.4451C195.131 26.1038 195.723 25.9052 196.462 25.8493C197.125 25.7992 197.715 25.8913 198.233 26.1256C198.751 26.3557 199.168 26.7344 199.486 27.2617C199.803 27.7847 199.993 28.4626 200.056 29.2955L200.527 35.5163L199.022 35.6301L198.56 29.5112C198.501 28.7421 198.256 28.1581 197.825 27.7591C197.392 27.3559 196.828 27.1806 196.131 27.2334C195.651 27.2697 195.23 27.4062 194.867 27.6431C194.509 27.8795 194.237 28.2057 194.05 28.6215C193.864 29.0373 193.792 29.5299 193.835 30.0993ZM206.254 25.2369L206.351 26.5117L201.277 26.8954L201.181 25.6207L206.254 25.2369ZM202.482 23.1632L203.986 23.0495L204.692 32.3808C204.724 32.8057 204.81 33.1197 204.949 33.3229C205.092 33.5214 205.264 33.6495 205.465 33.7069C205.67 33.7598 205.883 33.7779 206.104 33.7612C206.27 33.7486 206.405 33.7298 206.51 33.7048C206.615 33.6755 206.698 33.6521 206.761 33.6345L207.169 34.9627C207.07 35.0086 206.931 35.0576 206.751 35.1097C206.571 35.166 206.341 35.2048 206.061 35.226C205.636 35.2581 205.213 35.1982 204.791 35.0464C204.373 34.8942 204.017 34.6413 203.721 34.2876C203.429 33.9336 203.262 33.4719 203.219 32.9025L202.482 23.1632ZM214.586 30.4273L214.148 24.6399L215.653 24.5261L216.393 34.3163L214.889 34.4301L214.763 32.7729L214.661 32.7806C214.47 33.2951 214.145 33.7449 213.687 34.13C213.228 34.5108 212.629 34.7292 211.89 34.7851C211.278 34.8314 210.724 34.7387 210.228 34.507C209.731 34.271 209.327 33.8914 209.014 33.368C208.7 32.8404 208.512 32.1602 208.449 31.3274L207.978 25.1065L209.483 24.9927L209.945 31.1116C209.999 31.8255 210.242 32.3798 210.674 32.7745C211.11 33.1689 211.64 33.3425 212.264 33.2952C212.638 33.267 213.012 33.1426 213.384 32.9221C213.76 32.7013 214.065 32.3834 214.299 31.9683C214.537 31.5529 214.632 31.0392 214.586 30.4273ZM218.61 34.1487L217.869 24.3585L219.322 24.2485L219.438 25.7783L219.566 25.7686C219.73 25.2305 220.029 24.7998 220.461 24.4765C220.894 24.1489 221.429 23.961 222.066 23.9128C222.712 23.864 223.261 23.9699 223.712 24.2306C224.167 24.4868 224.536 24.8671 224.818 25.3714L224.92 25.3637C225.132 24.8391 225.478 24.4091 225.957 24.0737C226.435 23.7341 227.025 23.5378 227.726 23.4847C228.602 23.4185 229.338 23.6384 229.936 24.1445C230.534 24.6463 230.877 25.473 230.964 26.6245L231.459 33.1768L229.955 33.2906L229.46 26.7383C229.405 26.0159 229.168 25.5146 228.75 25.2343C228.331 24.954 227.854 24.8341 227.319 24.8745C226.63 24.9266 226.113 25.1752 225.766 25.6202C225.419 26.061 225.269 26.5979 225.317 27.2311L225.799 33.6049L224.27 33.7206L223.762 27.0153C223.72 26.4587 223.506 26.024 223.119 25.7114C222.732 25.3945 222.253 25.2576 221.684 25.3007C221.293 25.3303 220.936 25.462 220.611 25.6959C220.291 25.9295 220.041 26.2391 219.861 26.6245C219.685 27.0053 219.615 27.4359 219.651 27.916L220.114 34.0349L218.61 34.1487ZM238.458 36.3398L237.44 22.8782L238.894 22.7683L239.011 24.3235L239.19 24.31C239.287 24.1317 239.424 23.9034 239.599 23.6252C239.779 23.3424 240.046 23.0829 240.4 22.8467C240.757 22.606 241.255 22.4615 241.892 22.4133C242.717 22.351 243.459 22.5021 244.119 22.8667C244.779 23.2313 245.314 23.7785 245.724 24.5081C246.134 25.2378 246.378 26.1168 246.455 27.1451C246.534 28.182 246.425 29.094 246.13 29.8813C245.835 30.6643 245.391 31.2877 244.797 31.7514C244.204 32.2108 243.499 32.4713 242.683 32.533C242.055 32.5806 241.543 32.5146 241.149 32.335C240.755 32.1511 240.446 31.933 240.221 31.6808C239.997 31.4242 239.823 31.2109 239.699 31.0408L239.571 31.0505L239.963 36.226L238.458 36.3398ZM239.289 27.6615C239.345 28.4009 239.503 29.0449 239.762 29.5937C240.021 30.1382 240.371 30.554 240.812 30.8412C241.252 31.1242 241.774 31.2428 242.377 31.1972C243.006 31.1496 243.518 30.9442 243.914 30.581C244.314 30.2132 244.598 29.7386 244.768 29.1574C244.941 28.5716 245.002 27.9303 244.949 27.2334C244.897 26.545 244.744 25.9327 244.49 25.3964C244.239 24.8555 243.89 24.4396 243.44 24.1488C242.995 23.8534 242.453 23.7299 241.816 23.7781C241.204 23.8243 240.702 24.0183 240.309 24.36C239.916 24.6974 239.634 25.1504 239.463 25.7189C239.292 26.2831 239.234 26.9306 239.289 27.6615ZM249.639 25.8787L250.084 31.7682L248.58 31.8819L247.593 18.8283L249.097 18.7145L249.459 23.5077L249.587 23.498C249.778 22.975 250.092 22.5474 250.528 22.2153C250.969 21.8786 251.573 21.6811 252.342 21.6229C253.01 21.5725 253.604 21.6621 254.126 21.8919C254.647 22.1175 255.066 22.4938 255.384 23.0211C255.706 23.5438 255.898 24.2258 255.962 25.0672L256.432 31.288L254.928 31.4018L254.465 25.2829C254.407 24.5053 254.159 23.9193 253.723 23.5249C253.292 23.1259 252.721 22.9533 252.011 23.007C251.518 23.0443 251.084 23.1818 250.709 23.4196C250.338 23.657 250.055 23.984 249.86 24.4004C249.669 24.8166 249.596 25.3093 249.639 25.8787ZM259.542 34.7452C259.287 34.7645 259.058 34.7604 258.855 34.733C258.652 34.7099 258.511 34.6821 258.432 34.6496L258.714 33.295C259.087 33.3608 259.412 33.3704 259.691 33.3237C259.969 33.277 260.208 33.1328 260.408 32.8912C260.612 32.6535 260.787 32.2792 260.932 31.7682L261.155 30.9822L256.79 21.4148L258.422 21.2914L261.714 28.8885L261.816 28.8808L263.929 20.8748L265.56 20.7514L262.253 32.2837C262.104 32.8035 261.904 33.2396 261.653 33.5919C261.402 33.9485 261.1 34.2213 260.747 34.4104C260.398 34.5992 259.996 34.7108 259.542 34.7452ZM274.108 22.3101L272.786 22.7947C272.684 22.5759 272.542 22.3666 272.36 22.1667C272.182 21.9622 271.948 21.8004 271.657 21.6814C271.365 21.5624 271.001 21.5194 270.563 21.5525C269.964 21.5978 269.475 21.7737 269.097 22.0801C268.722 22.382 268.551 22.7432 268.583 23.1639C268.611 23.5378 268.769 23.8229 269.058 24.019C269.346 24.2151 269.785 24.3636 270.373 24.4644L271.854 24.7114C272.745 24.8576 273.422 25.1334 273.884 25.5386C274.346 25.9395 274.603 26.4821 274.655 27.1662C274.697 27.7271 274.574 28.2407 274.284 28.7071C273.999 29.1731 273.579 29.5553 273.025 29.8536C272.47 30.152 271.813 30.3299 271.052 30.3874C270.054 30.463 269.211 30.3088 268.524 29.9248C267.836 29.5409 267.374 28.9391 267.137 28.1194L268.538 27.6545C268.714 28.1711 269.001 28.5469 269.399 28.7817C269.801 29.0162 270.31 29.1102 270.926 29.0636C271.628 29.0106 272.173 28.8197 272.563 28.4911C272.956 28.1579 273.137 27.781 273.105 27.3603C273.08 27.0204 272.939 26.7447 272.684 26.5332C272.428 26.3175 272.05 26.1709 271.548 26.0935L269.887 25.8345C268.975 25.6898 268.291 25.4103 267.837 24.996C267.386 24.577 267.135 24.0298 267.084 23.3541C267.043 22.8017 267.161 22.3014 267.439 21.853C267.721 21.4043 268.123 21.0384 268.644 20.7554C269.17 20.472 269.777 20.3043 270.465 20.2523C271.434 20.179 272.211 20.3339 272.795 20.7171C273.384 21.0999 273.822 21.6309 274.108 22.3101ZM276.587 29.7637L275.846 19.9735L277.351 19.8597L278.091 29.6499L276.587 29.7637ZM276.488 18.2839C276.195 18.3061 275.934 18.2254 275.707 18.0417C275.483 17.8577 275.361 17.6255 275.34 17.3451C275.319 17.0646 275.405 16.8167 275.598 16.6012C275.795 16.3854 276.04 16.2665 276.334 16.2443C276.627 16.2221 276.885 16.303 277.108 16.487C277.336 16.6706 277.46 16.9027 277.482 17.1831C277.503 17.4636 277.415 17.7117 277.217 17.9275C277.024 18.1429 276.781 18.2617 276.488 18.2839ZM284.3 29.3854C283.383 29.4548 282.576 29.2979 281.88 28.9146C281.185 28.5313 280.629 27.9729 280.215 27.2393C279.801 26.5057 279.556 25.6502 279.482 24.6729C279.407 23.6785 279.524 22.7873 279.832 21.999C280.143 21.2062 280.612 20.5703 281.239 20.0913C281.869 19.6077 282.626 19.3325 283.509 19.2657C284.198 19.2136 284.828 19.2942 285.4 19.5074C285.971 19.7205 286.451 20.0432 286.838 20.4755C287.226 20.9077 287.485 21.4266 287.616 22.032L286.112 22.1458C285.963 21.7083 285.679 21.3324 285.257 21.0181C284.84 20.6992 284.3 20.5649 283.637 20.615C283.051 20.6594 282.548 20.8512 282.129 21.1906C281.715 21.5254 281.405 21.9783 281.2 22.5494C280.999 23.1158 280.927 23.7687 280.983 24.5081C281.04 25.2645 281.209 25.9141 281.489 26.457C281.774 26.9996 282.147 27.4094 282.608 27.6865C283.073 27.9633 283.603 28.0792 284.198 28.0342C284.589 28.0046 284.939 27.9098 285.247 27.7497C285.556 27.5896 285.811 27.3737 286.012 27.1021C286.214 26.8304 286.348 26.5126 286.415 26.1486L287.919 26.0348C287.878 26.6191 287.707 27.1556 287.406 27.6441C287.109 28.1281 286.697 28.5268 286.169 28.8402C285.646 29.1491 285.023 29.3308 284.3 29.3854ZM296.155 20.6426L294.833 21.1272C294.731 20.9084 294.589 20.6991 294.407 20.4992C294.23 20.2947 293.995 20.1329 293.704 20.0139C293.413 19.8949 293.049 19.8519 292.611 19.885C292.012 19.9303 291.523 20.1062 291.144 20.4126C290.77 20.7144 290.598 21.0757 290.63 21.4964C290.659 21.8703 290.817 22.1553 291.105 22.3515C291.394 22.5476 291.832 22.6961 292.421 22.7968L293.901 23.0439C294.793 23.1901 295.469 23.4659 295.932 23.8711C296.394 24.272 296.65 24.8146 296.702 25.4987C296.745 26.0596 296.621 26.5732 296.332 27.0396C296.046 27.5056 295.626 27.8878 295.072 28.1861C294.518 28.4845 293.86 28.6624 293.1 28.7199C292.101 28.7954 291.258 28.6412 290.571 28.2573C289.884 27.8734 289.422 27.2716 289.185 26.4519L290.585 25.987C290.761 26.5036 291.048 26.8793 291.446 27.1142C291.849 27.3487 292.358 27.4427 292.974 27.3961C293.675 27.3431 294.22 27.1522 294.61 26.8236C295.004 26.4904 295.185 26.1135 295.153 25.6928C295.127 25.3529 294.987 25.0772 294.731 24.8657C294.476 24.65 294.097 24.5034 293.595 24.426L291.935 24.167C291.022 24.0223 290.339 23.7428 289.884 23.3285C289.434 22.9095 289.183 22.3623 289.132 21.6866C289.09 21.1342 289.208 20.6338 289.486 20.1855C289.769 19.7367 290.17 19.3709 290.692 19.0879C291.217 18.8045 291.824 18.6368 292.513 18.5848C293.481 18.5115 294.258 18.6664 294.843 19.0496C295.431 19.4324 295.869 19.9634 296.155 20.6426Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_807_335" x1="0" y1="43.6057" x2="313" y2="43.6057" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_807_335" x1="28.7985" y1="33.4618" x2="30.0052" y2="49.4163" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>

<svg width="386" height="140" viewBox="0 0 386 140" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="10.7061" y="1.55353" width="387" height="39" rx="15.5" transform="rotate(15 10.7061 1.55353)" fill="#F8F1FF"/>
<rect x="10.7061" y="1.55353" width="387" height="39" rx="15.5" transform="rotate(15 10.7061 1.55353)" stroke="url(#paint0_linear_798_630)"/>
<path d="M35.6749 33.5254L37.8528 37.2976M39.1731 28.9354C38.0894 32.9797 33.9432 35.3825 29.9134 34.3027C25.8826 33.2226 23.4933 29.0687 24.5767 25.0253C25.6609 20.979 29.8068 18.5772 33.8366 19.657C37.8674 20.7371 40.2567 24.891 39.1731 28.9354Z" stroke="url(#paint1_linear_798_630)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M51.2602 39.8548L54.6483 27.21L56.1796 27.6203L54.6708 33.2512L61.413 35.0577L62.9218 29.4268L64.453 29.8371L61.0649 42.482L59.5336 42.0717L61.0491 36.4161L54.3068 34.6095L52.7914 40.2651L51.2602 39.8548ZM67.211 44.3406C66.3548 44.1112 65.6582 43.7061 65.1212 43.1255C64.5882 42.5459 64.2388 41.8413 64.0729 41.0115C63.9111 40.1829 63.9615 39.2788 64.224 38.2991C64.4887 37.3113 64.8988 36.4969 65.4543 35.8561C66.014 35.2163 66.6695 34.7787 67.4208 34.5433C68.1762 34.3089 68.982 34.3065 69.8381 34.5359C70.6943 34.7653 71.3889 35.1698 71.9218 35.7493C72.4588 36.33 72.8077 37.0367 72.9684 37.8694C73.1332 38.7033 73.0832 39.6142 72.8185 40.602C72.556 41.5817 72.1455 42.3893 71.587 43.0249C71.0325 43.6617 70.3776 44.0972 69.6222 44.3315C68.8709 44.567 68.0671 44.57 67.211 44.3406ZM67.5617 43.0316C68.2121 43.2059 68.7918 43.1826 69.301 42.9617C69.8102 42.7408 70.2384 42.3857 70.5857 41.8964C70.933 41.4071 71.1916 40.8455 71.3614 40.2116C71.5313 39.5777 71.5887 38.96 71.5337 38.3585C71.4787 37.757 71.2865 37.2313 70.9571 36.7813C70.6276 36.3312 70.1378 36.0191 69.4874 35.8448C68.8371 35.6706 68.2567 35.6959 67.7465 35.921C67.2362 36.146 66.8068 36.5052 66.4584 36.9986C66.1101 37.492 65.851 38.0557 65.6811 38.6896C65.5113 39.3235 65.4544 39.9391 65.5105 40.5365C65.5666 41.1338 65.7599 41.6555 66.0904 42.1014C66.4209 42.5473 66.9114 42.8574 67.5617 43.0316ZM75.0899 46.24L74.7415 35.9821L76.2727 36.3924L76.377 44.2025L76.4758 44.229L80.4465 37.5107L82.0024 37.9276L82.0639 45.6999L82.1627 45.7263L86.1515 39.0394L87.6827 39.4497L82.252 48.1591L80.8196 47.7752L80.6972 39.9338L80.549 39.8941L76.5223 46.6238L75.0899 46.24ZM97.5803 42.1017L97.2494 43.3366L92.3347 42.0197L92.6656 40.7848L97.5803 42.1017ZM94.7068 38.8965L96.1639 39.287L93.7419 48.326C93.6316 48.7377 93.6086 49.0624 93.6728 49.3002C93.7422 49.5349 93.8623 49.7127 94.0328 49.8334C94.2087 49.9511 94.4036 50.0386 94.6176 50.096C94.7782 50.139 94.9121 50.166 95.0194 50.1771C95.1278 50.1841 95.2145 50.1897 95.2796 50.1939L95.2252 51.5823C95.1165 51.5929 94.9687 51.593 94.7818 51.5826C94.5938 51.5763 94.3639 51.5368 94.0922 51.464C93.6806 51.3537 93.301 51.1571 92.9532 50.8742C92.6096 50.5925 92.3567 50.2357 92.1944 49.804C92.0363 49.3734 92.0311 48.8823 92.1789 48.3308L94.7068 38.8965ZM100.407 53.2355C99.5511 53.0061 98.8545 52.6011 98.3175 52.0204C97.7845 51.4409 97.4351 50.7362 97.2692 49.9065C97.1074 49.0778 97.1578 48.1737 97.4203 47.1941C97.685 46.2062 98.0951 45.3918 98.6506 44.751C99.2103 44.1112 99.8658 43.6737 100.617 43.4382C101.372 43.2039 102.178 43.2014 103.034 43.4308C103.891 43.6602 104.585 44.0647 105.118 44.6443C105.655 45.2249 106.004 45.9316 106.165 46.7644C106.329 47.5982 106.28 48.5091 106.015 49.497C105.752 50.4766 105.342 51.2842 104.783 51.9199C104.229 52.5566 103.574 52.9921 102.818 53.2265C102.067 53.4619 101.263 53.4649 100.407 53.2355ZM100.758 51.9266C101.408 52.1008 101.988 52.0775 102.497 51.8566C103.007 51.6357 103.435 51.2806 103.782 50.7913C104.129 50.302 104.388 49.7404 104.558 49.1065C104.728 48.4726 104.785 47.8549 104.73 47.2535C104.675 46.652 104.483 46.1262 104.153 45.6762C103.824 45.2262 103.334 44.914 102.684 44.7397C102.033 44.5655 101.453 44.5909 100.943 44.8159C100.432 45.0409 100.003 45.4001 99.6548 45.8935C99.3064 46.387 99.0473 46.9506 98.8774 47.5845C98.7076 48.2184 98.6507 48.834 98.7068 49.4314C98.7629 50.0288 98.9562 50.5504 99.2867 50.9963C99.6172 51.4422 100.108 51.7523 100.758 51.9266ZM119.518 50.2564L118.11 50.2761C118.086 50.0359 118.021 49.7914 117.916 49.5426C117.816 49.2907 117.648 49.0605 117.413 48.8519C117.178 48.6432 116.848 48.4821 116.424 48.3685C115.844 48.213 115.324 48.2172 114.866 48.3811C114.412 48.5419 114.131 48.8261 114.022 49.2336C113.925 49.5958 113.98 49.9172 114.187 50.1977C114.394 50.4782 114.759 50.7635 115.281 51.0534L116.596 51.7764C117.389 52.2094 117.936 52.6936 118.239 53.2289C118.542 53.7602 118.605 54.3571 118.427 55.0198C118.282 55.5632 117.995 56.007 117.567 56.3512C117.144 56.6966 116.621 56.9183 116 57.0164C115.378 57.1145 114.698 57.0648 113.962 56.8674C112.994 56.6082 112.25 56.1837 111.729 55.594C111.207 55.0043 110.97 54.2835 111.018 53.4315L112.493 53.4563C112.488 54.002 112.635 54.4516 112.933 54.8049C113.235 55.1594 113.684 55.4166 114.281 55.5765C114.96 55.7585 115.538 55.7589 116.014 55.5777C116.496 55.3936 116.792 55.0978 116.901 54.6903C116.989 54.361 116.948 54.0543 116.777 53.7703C116.607 53.4821 116.298 53.2185 115.85 52.9794L114.369 52.1854C113.556 51.7469 113.003 51.257 112.711 50.7156C112.425 50.1712 112.369 49.5717 112.545 48.9173C112.688 48.3822 112.965 47.9491 113.376 47.618C113.791 47.288 114.291 47.0757 114.877 46.9811C115.466 46.8877 116.095 46.9303 116.762 47.109C117.7 47.3605 118.382 47.7637 118.807 48.3187C119.235 48.8748 119.473 49.5207 119.518 50.2564ZM126.056 49.7319L125.725 50.9667L120.811 49.6498L121.142 48.415L126.056 49.7319ZM123.183 46.5267L124.64 46.9171L122.218 55.9562C122.108 56.3678 122.085 56.6925 122.149 56.9303C122.218 57.1651 122.338 57.3428 122.509 57.4635C122.685 57.5812 122.88 57.6688 123.094 57.7261C123.254 57.7691 123.388 57.7962 123.495 57.8073C123.604 57.8143 123.691 57.8199 123.756 57.8241L123.701 59.2124C123.593 59.223 123.445 59.2231 123.258 59.2127C123.07 59.2065 122.84 59.1669 122.568 59.0941C122.157 58.9838 121.777 58.7873 121.429 58.5044C121.086 58.2226 120.833 57.8659 120.671 57.4342C120.512 57.0036 120.507 56.5125 120.655 55.9609L123.183 46.5267ZM127.917 60.6331C127.316 60.4721 126.801 60.2127 126.371 59.8551C125.943 59.4933 125.643 59.0578 125.471 58.5484C125.3 58.0348 125.297 57.4694 125.462 56.852C125.608 56.3086 125.833 55.8969 126.137 55.6167C126.443 55.3324 126.801 55.1415 127.211 55.044C127.621 54.9465 128.054 54.9083 128.512 54.9294C128.975 54.9476 129.434 54.9868 129.89 55.0472C130.486 55.1275 130.968 55.1971 131.336 55.256C131.709 55.3119 131.991 55.3146 132.181 55.2641C132.375 55.2146 132.504 55.0726 132.566 54.838L132.58 54.7886C132.743 54.1794 132.703 53.6613 132.46 53.2345C132.221 52.8087 131.766 52.506 131.095 52.3262C130.4 52.1398 129.814 52.1459 129.337 52.3447C128.86 52.5434 128.495 52.7941 128.242 53.0968L126.991 52.2323C127.393 51.7222 127.842 51.3618 128.34 51.151C128.843 50.9373 129.356 50.8322 129.88 50.8358C130.409 50.8365 130.913 50.9008 131.39 51.0287C131.695 51.1103 132.035 51.2411 132.41 51.4211C132.791 51.598 133.136 51.8473 133.447 52.1688C133.762 52.4915 133.983 52.9102 134.11 53.425C134.237 53.9399 134.199 54.5739 133.997 55.3272L132.323 61.5755L130.866 61.1851L131.21 59.9008L131.136 59.881C130.982 60.0603 130.758 60.2364 130.465 60.4093C130.171 60.5821 129.811 60.6996 129.384 60.7617C128.957 60.8237 128.468 60.7809 127.917 60.6331ZM128.49 59.3837C129.066 59.5381 129.582 59.5551 130.038 59.4346C130.498 59.3152 130.877 59.1034 131.174 58.7994C131.476 58.4964 131.68 58.1473 131.786 57.7522L132.143 56.4186C132.061 56.4761 131.907 56.5076 131.681 56.5131C131.46 56.5156 131.207 56.5031 130.923 56.4756C130.645 56.445 130.373 56.412 130.109 56.3766C129.851 56.3381 129.64 56.3082 129.478 56.2869C129.086 56.2348 128.711 56.2202 128.352 56.2431C127.998 56.263 127.691 56.355 127.431 56.5191C127.176 56.6802 126.999 56.946 126.9 57.3165C126.764 57.8228 126.849 58.2558 127.154 58.6154C127.464 58.9721 127.909 59.2282 128.49 59.3837ZM134.461 62.1484L137.002 52.6647L138.41 53.0419L138.026 54.4744L138.125 54.5008C138.423 54.0779 138.838 53.781 139.369 53.6101C139.9 53.4391 140.45 53.4298 141.018 53.582C141.125 53.6107 141.258 53.6486 141.418 53.6957C141.577 53.7428 141.697 53.7815 141.777 53.8118L141.38 55.2936C141.334 55.268 141.226 55.2192 141.055 55.1471C140.89 55.0719 140.711 55.0085 140.517 54.9566C140.056 54.8331 139.619 54.8195 139.205 54.9159C138.796 55.0093 138.441 55.1966 138.141 55.4779C137.846 55.7562 137.641 56.1094 137.526 56.5374L135.918 62.5388L134.461 62.1484ZM147.668 55.5227L147.337 56.7576L142.423 55.4407L142.753 54.2058L147.668 55.5227ZM144.795 52.3175L146.252 52.708L143.83 61.747C143.719 62.1587 143.696 62.4834 143.761 62.7212C143.83 62.9559 143.95 63.1337 144.121 63.2544C144.297 63.3721 144.491 63.4596 144.705 63.517C144.866 63.56 145 63.587 145.107 63.5981C145.216 63.6051 145.302 63.6107 145.367 63.6149L145.313 65.0033C145.204 65.0139 145.057 65.014 144.87 65.0036C144.682 64.9973 144.452 64.9578 144.18 64.885C143.768 64.7747 143.389 64.5781 143.041 64.2952C142.697 64.0135 142.445 63.6567 142.282 63.225C142.124 62.7944 142.119 62.3033 142.267 61.7518L144.795 52.3175ZM154.965 67.8543C154.076 67.6161 153.367 67.201 152.837 66.6091C152.308 66.0172 151.969 65.3065 151.82 64.4771C151.672 63.6477 151.725 62.7596 151.978 61.8129C152.237 60.8497 152.641 60.0471 153.193 59.4052C153.749 58.7602 154.402 58.3154 155.152 58.0706C155.906 57.8228 156.712 57.8136 157.568 58.043C158.235 58.2217 158.803 58.5062 159.272 58.8965C159.74 59.2869 160.086 59.7501 160.309 60.2862C160.531 60.8223 160.604 61.3977 160.528 62.0125L159.071 61.6221C159.075 61.1601 158.931 60.7111 158.637 60.2751C158.349 59.8361 157.884 59.5306 157.242 59.3586C156.674 59.2064 156.136 59.2211 155.629 59.4027C155.126 59.5814 154.684 59.9063 154.302 60.3774C153.925 60.8455 153.641 61.4377 153.449 62.1539C153.252 62.8866 153.197 63.5555 153.282 64.1606C153.371 64.7668 153.587 65.2769 153.93 65.691C154.278 66.1062 154.74 66.391 155.316 66.5454C155.695 66.6468 156.056 66.6731 156.4 66.6241C156.744 66.5751 157.056 66.4558 157.337 66.2662C157.617 66.0765 157.848 65.821 158.032 65.4995L159.489 65.8899C159.256 66.4277 158.918 66.8773 158.472 67.2388C158.032 67.5973 157.511 67.8372 156.91 67.9583C156.313 68.0765 155.665 68.0418 154.965 67.8543ZM160.356 69.087L162.897 59.6033L164.354 59.9938L161.813 69.4774L160.356 69.087ZM164.062 58.2213C163.778 58.1452 163.559 57.9828 163.405 57.7342C163.255 57.4867 163.216 57.2271 163.289 56.9555C163.362 56.6838 163.525 56.4782 163.779 56.3388C164.036 56.2005 164.307 56.1694 164.591 56.2455C164.875 56.3216 165.092 56.4834 165.242 56.7309C165.396 56.9795 165.436 57.2397 165.364 57.5113C165.291 57.783 165.126 57.988 164.868 58.1263C164.614 58.2657 164.346 58.2974 164.062 58.2213ZM163.96 70.0528L166.502 60.5691L167.909 60.9463L167.525 62.3788L167.624 62.4052C167.923 61.9823 168.338 61.6854 168.869 61.5145C169.4 61.3435 169.949 61.3342 170.518 61.4864C170.625 61.515 170.758 61.5529 170.917 61.6001C171.077 61.6472 171.196 61.6859 171.276 61.7162L170.879 63.198C170.833 63.1724 170.725 63.1236 170.555 63.0515C170.39 62.9763 170.21 62.9128 170.017 62.861C169.556 62.7375 169.118 62.7239 168.704 62.8203C168.295 62.9137 167.941 63.101 167.64 63.3823C167.345 63.6606 167.14 64.0138 167.026 64.4418L165.418 70.4432L163.96 70.0528ZM173.419 72.799C172.53 72.5607 171.821 72.1457 171.291 71.5537C170.761 70.9618 170.422 70.2512 170.274 69.4217C170.126 68.5923 170.178 67.7042 170.432 66.7575C170.69 65.7943 171.095 64.9918 171.646 64.3498C172.203 63.7049 172.856 63.26 173.605 63.0152C174.36 62.7674 175.165 62.7582 176.022 62.9876C176.688 63.1663 177.256 63.4508 177.725 63.8412C178.194 64.2315 178.54 64.6947 178.762 65.2308C178.985 65.7669 179.058 66.3424 178.981 66.9571L177.524 66.5667C177.529 66.1047 177.385 65.6557 177.091 65.2198C176.803 64.7808 176.338 64.4752 175.695 64.3032C175.127 64.151 174.59 64.1657 174.082 64.3474C173.58 64.526 173.138 64.8509 172.756 65.322C172.379 65.7902 172.094 66.3823 171.902 67.0985C171.706 67.8312 171.65 68.5001 171.735 69.1052C171.824 69.7114 172.041 70.2215 172.384 70.6356C172.732 71.0508 173.194 71.3356 173.77 71.49C174.148 71.5915 174.51 71.6177 174.854 71.5687C175.198 71.5197 175.51 71.4004 175.79 71.2108C176.07 71.0212 176.302 70.7656 176.485 70.4441L177.942 70.8346C177.71 71.3723 177.371 71.8219 176.926 72.1835C176.486 72.542 175.965 72.7818 175.363 72.903C174.767 73.0211 174.119 72.9864 173.419 72.799ZM185.825 71.7556L187.328 66.1494L188.785 66.5399L186.244 76.0235L184.786 75.6331L185.217 74.0278L185.118 74.0013C184.766 74.4233 184.311 74.7402 183.751 74.952C183.193 75.1597 182.555 75.1676 181.839 74.9757C181.246 74.8169 180.754 74.546 180.363 74.1632C179.972 73.7762 179.716 73.284 179.594 72.6866C179.473 72.085 179.52 71.3808 179.736 70.574L181.351 64.548L182.808 64.9384L181.22 70.8657C181.034 71.5572 181.08 72.1606 181.357 72.6759C181.638 73.1923 182.08 73.5316 182.686 73.6937C183.048 73.7907 183.441 73.7968 183.865 73.712C184.293 73.6282 184.687 73.4291 185.044 73.1147C185.406 72.8014 185.667 72.3484 185.825 71.7556ZM188.391 76.5988L190.932 67.1152L192.389 67.5056L189.848 76.9893L188.391 76.5988ZM192.096 65.7331C191.812 65.657 191.593 65.4947 191.439 65.2461C191.289 64.9986 191.251 64.739 191.324 64.4673C191.397 64.1956 191.56 63.9901 191.813 63.8507C192.071 63.7124 192.342 63.6813 192.626 63.7574C192.91 63.8335 193.127 63.9953 193.277 64.2428C193.43 64.4914 193.471 64.7515 193.398 65.0232C193.325 65.2949 193.16 65.4998 192.903 65.6382C192.649 65.7776 192.38 65.8092 192.096 65.7331ZM198.661 69.1861L198.33 70.421L193.415 69.1041L193.746 67.8692L198.661 69.1861ZM195.787 65.9809L197.244 66.3714L194.822 75.4104C194.712 75.8221 194.689 76.1468 194.753 76.3846C194.823 76.6193 194.943 76.7971 195.113 76.9178C195.289 77.0355 195.484 77.123 195.698 77.1804C195.859 77.2234 195.992 77.2504 196.1 77.2615C196.208 77.2685 196.295 77.2741 196.36 77.2783L196.306 78.6667C196.197 78.6773 196.049 78.6774 195.862 78.667C195.674 78.6607 195.444 78.6212 195.173 78.5484C194.761 78.4381 194.381 78.2415 194.034 77.9586C193.69 77.6769 193.437 77.3201 193.275 76.8884C193.117 76.4578 193.111 75.9667 193.259 75.4152L195.787 65.9809ZM205.686 81.4449C204.896 81.2332 204.252 80.8466 203.754 80.2852C203.257 79.7197 202.936 79.0248 202.79 78.2006C202.646 77.3723 202.708 76.4559 202.978 75.4516C203.244 74.4555 203.647 73.6368 204.185 72.9957C204.723 72.3546 205.35 71.916 206.066 71.6799C206.782 71.4439 207.54 71.4329 208.338 71.6468C208.956 71.8123 209.416 72.0459 209.719 72.3476C210.027 72.6464 210.241 72.9508 210.361 73.2608C210.486 73.5679 210.58 73.8181 210.643 74.0114L210.766 74.0445L212.017 69.3768L213.474 69.7672L210.086 82.412L208.678 82.0348L209.069 80.5777L208.896 80.5314C208.742 80.6756 208.532 80.8529 208.263 81.0634C207.996 81.2698 207.652 81.4268 207.231 81.5345C206.81 81.638 206.295 81.6082 205.686 81.4449ZM206.235 80.1889C206.819 80.3455 207.354 80.3256 207.839 80.1291C208.325 79.9285 208.746 79.5846 209.101 79.0975C209.458 78.6063 209.732 78.0026 209.924 77.2864C210.114 76.5784 210.177 75.9314 210.113 75.3452C210.051 74.755 209.858 74.2576 209.534 73.8532C209.211 73.4446 208.753 73.1609 208.16 73.0021C207.543 72.8367 206.986 72.8573 206.489 73.0639C205.998 73.2676 205.577 73.6114 205.227 74.0955C204.882 74.5765 204.62 75.1505 204.441 75.8173C204.26 76.4924 204.199 77.1332 204.257 77.7399C204.32 78.3436 204.512 78.8627 204.832 79.297C205.158 79.7284 205.625 80.0257 206.235 80.1889ZM216.359 84.3046C215.445 84.0597 214.711 83.6468 214.156 83.0658C213.607 82.4819 213.25 81.7776 213.088 80.9531C212.93 80.1256 212.981 79.2261 213.241 78.2547C213.502 77.2833 213.908 76.4746 214.461 75.8285C215.018 75.1794 215.672 74.7325 216.421 74.4877C217.176 74.2399 217.981 74.2307 218.838 74.4602C219.331 74.5925 219.797 74.8055 220.235 75.0992C220.672 75.3929 221.039 75.7779 221.335 76.2542C221.632 76.7265 221.816 77.2965 221.889 77.9645C221.961 78.6324 221.879 79.4089 221.642 80.2939L221.477 80.9113L214.166 78.9525L214.504 77.693L220.332 79.2547C220.476 78.7196 220.497 78.2134 220.395 77.7362C220.298 77.2601 220.086 76.8483 219.76 76.5006C219.438 76.1541 219.014 75.9103 218.487 75.7691C217.906 75.6136 217.366 75.6231 216.864 75.7976C216.369 75.9691 215.946 76.253 215.597 76.6492C215.249 77.0455 215.004 77.505 214.864 78.0277L214.639 78.8674C214.447 79.5836 214.408 80.2239 214.521 80.7881C214.64 81.3493 214.887 81.8191 215.262 82.1976C215.638 82.5719 216.121 82.8379 216.709 82.9956C217.092 83.0982 217.452 83.1373 217.79 83.113C218.132 83.0857 218.446 82.9933 218.731 82.8358C219.017 82.6742 219.266 82.4453 219.477 82.1491L220.779 82.9214C220.503 83.3592 220.141 83.7123 219.695 83.9808C219.249 84.2452 218.741 84.4092 218.173 84.4731C217.605 84.5328 217.001 84.4766 216.359 84.3046ZM230.723 80.0536L229.315 80.0733C229.291 79.8331 229.226 79.5886 229.121 79.3398C229.021 79.0879 228.853 78.8577 228.618 78.6491C228.382 78.4405 228.053 78.2793 227.629 78.1657C227.048 78.0102 226.529 78.0144 226.07 78.1783C225.617 78.3391 225.336 78.6233 225.226 79.0308C225.129 79.3931 225.184 79.7144 225.392 79.9949C225.599 80.2754 225.964 80.5607 226.486 80.8506L227.801 81.5736C228.594 82.0066 229.141 82.4908 229.443 83.0261C229.747 83.5574 229.809 84.1543 229.632 84.817C229.486 85.3604 229.2 85.8042 228.772 86.1484C228.349 86.4938 227.826 86.7155 227.204 86.8136C226.582 86.9117 225.903 86.862 225.166 86.6646C224.199 86.4054 223.455 85.9809 222.933 85.3912C222.412 84.8015 222.175 84.0807 222.222 83.2287L223.698 83.2535C223.693 83.7992 223.839 84.2488 224.137 84.6021C224.439 84.9566 224.889 85.2138 225.486 85.3737C226.165 85.5557 226.743 85.5561 227.219 85.375C227.701 85.1908 227.996 84.895 228.105 84.4875C228.194 84.1582 228.152 83.8515 227.981 83.5675C227.812 83.2793 227.503 83.0157 227.055 82.7766L225.574 81.9827C224.76 81.5441 224.208 81.0542 223.916 80.5128C223.63 79.9684 223.574 79.369 223.749 78.7145C223.893 78.1794 224.17 77.7463 224.581 77.4152C224.996 77.0852 225.496 76.8729 226.081 76.7784C226.671 76.6849 227.299 76.7275 227.966 76.9062C228.905 77.1577 229.586 77.5609 230.011 78.1159C230.44 78.672 230.677 79.3179 230.723 80.0536ZM230.596 87.9076L233.137 78.4239L234.594 78.8144L232.053 88.298L230.596 87.9076ZM234.301 77.0419C234.017 76.9658 233.798 76.8034 233.644 76.5548C233.494 76.3073 233.456 76.0477 233.529 75.776C233.601 75.5044 233.764 75.2988 234.018 75.1594C234.276 75.0211 234.546 74.99 234.83 75.0661C235.114 75.1422 235.331 75.304 235.481 75.5515C235.635 75.8001 235.676 76.0603 235.603 76.3319C235.53 76.6036 235.365 76.8086 235.107 76.9469C234.854 77.0863 234.585 77.118 234.301 77.0419ZM237.022 93.653C236.318 93.4644 235.737 93.2117 235.28 92.895C234.821 92.5823 234.462 92.2346 234.202 91.8519C233.946 91.4745 233.763 91.0946 233.654 90.7124L235.033 90.2084C235.119 90.4166 235.232 90.6588 235.375 90.9352C235.516 91.2156 235.739 91.485 236.045 91.7434C236.354 92.007 236.794 92.2155 237.366 92.3688C238.132 92.5739 238.813 92.558 239.411 92.321C240.008 92.084 240.412 91.5703 240.624 90.78L241.14 88.8537L241.017 88.8206C240.863 88.9648 240.654 89.138 240.388 89.3403C240.127 89.5395 239.787 89.6889 239.368 89.7883C238.954 89.8847 238.438 89.8502 237.821 89.6847C237.055 89.4796 236.416 89.1143 235.904 88.5888C235.396 88.0645 235.058 87.4091 234.889 86.6227C234.724 85.8375 234.774 84.9509 235.039 83.963C235.299 82.9916 235.697 82.1915 236.232 81.5627C236.767 80.9298 237.393 80.4974 238.108 80.2655C238.824 80.0295 239.581 80.0184 240.38 80.2324C240.997 80.3978 241.46 80.632 241.767 80.9349C242.079 81.2347 242.297 81.5402 242.421 81.8514C242.55 82.1595 242.646 82.4102 242.709 82.6036L242.857 82.6433L243.261 81.1367L244.669 81.5139L242.055 91.2693C241.836 92.0843 241.474 92.6973 240.966 93.1085C240.462 93.5248 239.867 93.7691 239.182 93.8413C238.499 93.9187 237.779 93.856 237.022 93.653ZM238.369 88.4287C238.953 88.5853 239.483 88.5839 239.958 88.4244C240.433 88.265 240.843 87.9623 241.188 87.5164C241.532 87.0704 241.798 86.4976 241.986 85.7979C242.169 85.1146 242.227 84.484 242.162 83.9061C242.096 83.3282 241.901 82.837 241.577 82.4326C241.253 82.0281 240.795 81.7465 240.202 81.5877C239.585 81.4222 239.028 81.4408 238.533 81.6433C238.041 81.8469 237.622 82.1846 237.275 82.6563C236.932 83.1292 236.675 83.6866 236.503 84.3288C236.326 84.9874 236.273 85.5974 236.343 86.1588C236.419 86.7172 236.622 87.1951 236.952 87.5924C237.287 87.9867 237.76 88.2655 238.369 88.4287ZM247.259 86.258L245.73 91.963L244.273 91.5725L246.814 82.0889L248.222 82.4661L247.825 83.9479L247.949 83.981C248.3 83.559 248.741 83.2625 249.272 83.0915C249.804 82.9165 250.429 82.9249 251.145 83.1168C251.787 83.2889 252.313 83.5712 252.724 83.9636C253.137 84.352 253.405 84.8475 253.531 85.4502C253.657 86.0488 253.612 86.7514 253.396 87.5582L251.781 93.5842L250.324 93.1938L251.912 87.2665C252.112 86.5215 252.074 85.8893 251.798 85.3699C251.524 84.8464 251.049 84.4942 250.374 84.3133C249.909 84.1887 249.466 84.1781 249.046 84.2816C248.63 84.3863 248.265 84.6039 247.951 84.9346C247.638 85.2653 247.407 85.7064 247.259 86.258ZM261.022 96.2985C260.421 96.1375 259.906 95.8781 259.477 95.5205C259.049 95.1588 258.748 94.7232 258.576 94.2138C258.405 93.7003 258.402 93.1348 258.567 92.5174C258.713 91.974 258.938 91.5623 259.242 91.2821C259.548 90.9978 259.906 90.8069 260.316 90.7094C260.726 90.6119 261.159 90.5737 261.617 90.5949C262.08 90.613 262.539 90.6522 262.995 90.7126C263.591 90.7929 264.073 90.8625 264.441 90.9215C264.814 90.9774 265.096 90.98 265.286 90.9295C265.48 90.88 265.609 90.738 265.672 90.5034L265.685 90.454C265.848 89.8448 265.808 89.3267 265.565 88.8999C265.326 88.4741 264.871 88.1714 264.201 87.9916C263.505 87.8052 262.919 87.8113 262.442 88.0101C261.965 88.2088 261.6 88.4595 261.347 88.7623L260.096 87.8977C260.498 87.3876 260.947 87.0272 261.445 86.8164C261.948 86.6027 262.461 86.4976 262.985 86.5012C263.514 86.5019 264.018 86.5662 264.495 86.6941C264.8 86.7757 265.14 86.9065 265.515 87.0865C265.896 87.2634 266.241 87.5127 266.552 87.8342C266.867 88.1569 267.088 88.5756 267.215 89.0904C267.342 89.6053 267.304 90.2393 267.102 90.9926L265.428 97.2409L263.971 96.8505L264.315 95.5662L264.241 95.5464C264.087 95.7257 263.863 95.9018 263.57 96.0747C263.277 96.2475 262.916 96.365 262.49 96.4271C262.063 96.4892 261.573 96.4463 261.022 96.2985ZM261.595 95.0491C262.171 95.2035 262.687 95.2205 263.143 95.1C263.603 94.9806 263.982 94.7688 264.279 94.4648C264.581 94.1618 264.785 93.8128 264.891 93.4176L265.248 92.084C265.166 92.1415 265.012 92.173 264.786 92.1785C264.565 92.181 264.312 92.1685 264.028 92.141C263.75 92.1104 263.479 92.0775 263.214 92.042C262.956 92.0035 262.745 91.9736 262.583 91.9523C262.191 91.9002 261.816 91.8856 261.457 91.9086C261.103 91.9284 260.796 92.0204 260.536 92.1846C260.281 92.3457 260.104 92.6114 260.005 92.9819C259.869 93.4882 259.954 93.9212 260.259 94.2808C260.569 94.6375 261.014 94.8936 261.595 95.0491ZM276.256 92.254L274.847 92.2738C274.823 92.0336 274.759 91.789 274.653 91.5402C274.553 91.2884 274.386 91.0582 274.15 90.8495C273.915 90.6409 273.585 90.4798 273.161 90.3662C272.581 90.2107 272.062 90.2149 271.603 90.3787C271.15 90.5396 270.868 90.8238 270.759 91.2313C270.662 91.5935 270.717 91.9149 270.924 92.1954C271.131 92.4759 271.496 92.7611 272.019 93.0511L273.334 93.774C274.126 94.207 274.674 94.6912 274.976 95.2266C275.279 95.7578 275.342 96.3548 275.164 97.0175C275.019 97.5608 274.732 98.0046 274.305 98.3489C273.881 98.6942 273.359 98.916 272.737 99.014C272.115 99.1121 271.436 99.0624 270.699 98.865C269.732 98.6058 268.987 98.1814 268.466 97.5917C267.944 97.002 267.708 96.2811 267.755 95.4292L269.231 95.454C269.226 95.9997 269.372 96.4492 269.67 96.8026C269.972 97.157 270.421 97.4142 271.018 97.5742C271.698 97.7561 272.275 97.7566 272.752 97.5754C273.233 97.3912 273.529 97.0954 273.638 96.6879C273.726 96.3586 273.685 96.052 273.514 95.7679C273.344 95.4798 273.035 95.2162 272.588 94.9771L271.106 94.1831C270.293 93.7446 269.74 93.2546 269.449 92.7132C269.162 92.1688 269.107 91.5694 269.282 90.9149C269.426 90.3798 269.703 89.9467 270.113 89.6156C270.528 89.2856 271.029 89.0733 271.614 88.9788C272.204 88.8854 272.832 88.928 273.499 89.1066C274.437 89.3581 275.119 89.7613 275.544 90.3163C275.973 90.8724 276.21 91.5183 276.256 92.254ZM283.228 102.249C282.627 102.088 282.112 101.828 281.683 101.471C281.255 101.109 280.954 100.673 280.782 100.164C280.611 99.6503 280.608 99.0849 280.773 98.4674C280.919 97.9241 281.144 97.5124 281.448 97.2322C281.754 96.9479 282.112 96.757 282.522 96.6595C282.932 96.562 283.365 96.5238 283.823 96.5449C284.286 96.5631 284.745 96.6023 285.201 96.6627C285.797 96.743 286.279 96.8126 286.647 96.8715C287.02 96.9274 287.302 96.9301 287.492 96.8796C287.686 96.8301 287.815 96.6881 287.878 96.4534L287.891 96.404C288.054 95.7949 288.014 95.2768 287.771 94.85C287.532 94.4242 287.077 94.1214 286.407 93.9417C285.711 93.7553 285.125 93.7614 284.648 93.9601C284.171 94.1589 283.806 94.4096 283.553 94.7123L282.302 93.8478C282.704 93.3377 283.153 92.9773 283.651 92.7665C284.154 92.5528 284.667 92.4477 285.191 92.4513C285.72 92.452 286.224 92.5163 286.701 92.6442C287.006 92.7258 287.346 92.8566 287.721 93.0366C288.102 93.2135 288.447 93.4628 288.758 93.7843C289.073 94.1069 289.294 94.5257 289.421 95.0405C289.548 95.5554 289.51 96.1894 289.308 96.9427L287.634 103.191L286.177 102.801L286.521 101.516L286.447 101.496C286.293 101.676 286.069 101.852 285.776 102.025C285.483 102.198 285.122 102.315 284.696 102.377C284.269 102.439 283.779 102.396 283.228 102.249ZM283.801 100.999C284.377 101.154 284.893 101.171 285.349 101.05C285.809 100.931 286.188 100.719 286.485 100.415C286.787 100.112 286.991 99.7628 287.097 99.3677L287.454 98.034C287.372 98.0916 287.218 98.1231 286.992 98.1286C286.771 98.1311 286.518 98.1186 286.234 98.0911C285.956 98.0605 285.685 98.0275 285.421 97.9921C285.162 97.9536 284.951 97.9237 284.789 97.9024C284.397 97.8503 284.022 97.8357 283.663 97.8586C283.309 97.8785 283.002 97.9705 282.742 98.1346C282.487 98.2957 282.31 98.5615 282.211 98.932C282.075 99.4383 282.16 99.8712 282.465 100.231C282.775 100.588 283.22 100.844 283.801 100.999ZM294.338 104.987L297.726 92.3425L299.183 92.7329L297.933 97.4006L298.056 97.4337C298.207 97.2977 298.412 97.1275 298.669 96.9231C298.932 96.7156 299.27 96.559 299.682 96.4532C300.099 96.3445 300.617 96.3728 301.234 96.5383C302.033 96.7522 302.683 97.1405 303.185 97.703C303.687 98.2655 304.011 98.9588 304.157 99.783C304.302 100.607 304.241 101.517 303.974 102.514C303.705 103.518 303.301 104.343 302.762 104.988C302.224 105.629 301.598 106.07 300.885 106.312C300.173 106.549 299.422 106.561 298.632 106.35C298.022 106.186 297.562 105.955 297.249 105.655C296.938 105.351 296.719 105.043 296.591 104.731C296.464 104.414 296.37 104.155 296.309 103.954L296.136 103.907L295.746 105.365L294.338 104.987ZM297.041 100.629C296.849 101.346 296.785 102.005 296.848 102.609C296.912 103.209 297.105 103.717 297.425 104.134C297.747 104.546 298.2 104.831 298.785 104.988C299.394 105.151 299.945 105.127 300.439 104.915C300.938 104.7 301.363 104.346 301.716 103.854C302.073 103.359 302.343 102.773 302.524 102.098C302.702 101.432 302.76 100.803 302.698 100.213C302.641 99.6195 302.448 99.1114 302.121 98.6882C301.798 98.2621 301.328 97.9663 300.711 97.8009C300.118 97.6421 299.579 97.6588 299.096 97.8512C298.613 98.0395 298.197 98.3736 297.848 98.8536C297.5 99.3294 297.231 99.9213 297.041 100.629ZM308.341 108.951C307.427 108.706 306.693 108.293 306.138 107.712C305.589 107.128 305.233 106.424 305.07 105.6C304.912 104.772 304.963 103.873 305.224 102.901C305.484 101.93 305.89 101.121 306.443 100.475C307.001 99.826 307.654 99.3791 308.404 99.1343C309.158 98.8865 309.964 98.8773 310.82 99.1067C311.314 99.2391 311.779 99.4521 312.217 99.7458C312.654 100.039 313.021 100.424 313.317 100.901C313.614 101.373 313.799 101.943 313.871 102.611C313.944 103.279 313.861 104.055 313.624 104.94L313.459 105.558L306.148 103.599L306.486 102.34L312.314 103.901C312.458 103.366 312.479 102.86 312.377 102.383C312.28 101.907 312.068 101.495 311.742 101.147C311.42 100.801 310.996 100.557 310.469 100.416C309.889 100.26 309.348 100.27 308.847 100.444C308.351 100.616 307.928 100.9 307.58 101.296C307.231 101.692 306.986 102.152 306.846 102.674L306.621 103.514C306.429 104.23 306.39 104.87 306.504 105.435C306.622 105.996 306.869 106.466 307.244 106.844C307.621 107.218 308.103 107.484 308.692 107.642C309.074 107.745 309.434 107.784 309.772 107.76C310.114 107.732 310.428 107.64 310.713 107.482C310.999 107.321 311.248 107.092 311.459 106.796L312.761 107.568C312.485 108.006 312.124 108.359 311.677 108.627C311.231 108.892 310.724 109.056 310.155 109.12C309.588 109.179 308.983 109.123 308.341 108.951ZM316.838 115.04C316.134 114.851 315.553 114.598 315.095 114.282C314.636 113.969 314.277 113.621 314.018 113.238C313.762 112.861 313.579 112.481 313.47 112.099L314.849 111.595C314.934 111.803 315.048 112.045 315.19 112.322C315.331 112.602 315.555 112.872 315.86 113.13C316.169 113.394 316.61 113.602 317.182 113.755C317.947 113.96 318.629 113.945 319.226 113.708C319.824 113.471 320.228 112.957 320.44 112.167L320.956 110.24L320.832 110.207C320.679 110.351 320.469 110.525 320.204 110.727C319.943 110.926 319.603 111.075 319.184 111.175C318.769 111.271 318.254 111.237 317.636 111.071C316.871 110.866 316.232 110.501 315.72 109.975C315.212 109.451 314.873 108.796 314.705 108.009C314.54 107.224 314.59 106.337 314.855 105.35C315.115 104.378 315.513 103.578 316.047 102.949C316.583 102.316 317.208 101.884 317.923 101.652C318.64 101.416 319.397 101.405 320.195 101.619C320.813 101.784 321.275 102.019 321.582 102.321C321.895 102.621 322.113 102.927 322.237 103.238C322.366 103.546 322.462 103.797 322.525 103.99L322.673 104.03L323.077 102.523L324.484 102.9L321.87 112.656C321.652 113.471 321.289 114.084 320.782 114.495C320.278 114.911 319.683 115.156 318.997 115.228C318.315 115.305 317.595 115.242 316.838 115.04ZM318.185 109.815C318.769 109.972 319.299 109.97 319.774 109.811C320.249 109.652 320.659 109.349 321.003 108.903C321.348 108.457 321.614 107.884 321.801 107.184C321.984 106.501 322.043 105.871 321.977 105.293C321.912 104.715 321.717 104.224 321.393 103.819C321.069 103.415 320.61 103.133 320.018 102.974C319.4 102.809 318.844 102.827 318.348 103.03C317.857 103.233 317.438 103.571 317.091 104.043C316.748 104.516 316.491 105.073 316.319 105.715C316.142 106.374 316.089 106.984 316.159 107.545C316.234 108.104 316.437 108.582 316.768 108.979C317.103 109.373 317.575 109.652 318.185 109.815ZM324.089 112.959L326.63 103.475L328.087 103.866L325.546 113.349L324.089 112.959ZM327.794 102.093C327.51 102.017 327.291 101.855 327.137 101.606C326.988 101.359 326.949 101.099 327.022 100.828C327.095 100.556 327.258 100.35 327.511 100.211C327.769 100.073 328.04 100.041 328.324 100.118C328.608 100.194 328.825 100.355 328.975 100.603C329.129 100.852 329.169 101.112 329.096 101.383C329.024 101.655 328.858 101.86 328.601 101.998C328.347 102.138 328.078 102.169 327.794 102.093ZM330.679 108.61L329.15 114.315L327.693 113.925L330.234 104.441L331.642 104.818L331.245 106.3L331.369 106.333C331.72 105.911 332.161 105.615 332.692 105.444C333.224 105.269 333.849 105.277 334.565 105.469C335.207 105.641 335.733 105.923 336.144 106.316C336.557 106.704 336.825 107.2 336.95 107.803C337.077 108.401 337.032 109.104 336.816 109.911L335.201 115.937L333.744 115.546L335.332 109.619C335.532 108.874 335.494 108.242 335.218 107.722C334.944 107.199 334.469 106.846 333.794 106.666C333.329 106.541 332.886 106.53 332.466 106.634C332.05 106.739 331.685 106.956 331.371 107.287C331.057 107.618 330.827 108.059 330.679 108.61ZM340.328 111.196L338.799 116.901L337.342 116.51L339.883 107.027L341.291 107.404L340.894 108.886L341.017 108.919C341.369 108.497 341.81 108.2 342.341 108.029C342.873 107.854 343.497 107.863 344.214 108.055C344.856 108.227 345.382 108.509 345.793 108.901C346.205 109.29 346.474 109.785 346.599 110.388C346.726 110.986 346.681 111.689 346.465 112.496L344.85 118.522L343.393 118.132L344.981 112.204C345.181 111.459 345.143 110.827 344.867 110.308C344.593 109.784 344.118 109.432 343.443 109.251C342.978 109.126 342.535 109.116 342.115 109.219C341.699 109.324 341.334 109.542 341.02 109.872C340.706 110.203 340.476 110.644 340.328 111.196ZM350.914 120.359C350.001 120.114 349.266 119.701 348.712 119.12C348.162 118.536 347.806 117.832 347.643 117.007C347.486 116.18 347.537 115.28 347.797 114.309C348.058 113.337 348.464 112.529 349.016 111.883C349.574 111.234 350.228 110.787 350.977 110.542C351.732 110.294 352.537 110.285 353.393 110.514C353.887 110.647 354.353 110.86 354.79 111.153C355.228 111.447 355.595 111.832 355.891 112.308C356.187 112.781 356.372 113.351 356.445 114.019C356.517 114.687 356.435 115.463 356.198 116.348L356.032 116.965L348.722 115.007L349.06 113.747L354.888 115.309C355.031 114.774 355.052 114.268 354.951 113.79C354.853 113.314 354.642 112.902 354.316 112.555C353.994 112.208 353.569 111.964 353.043 111.823C352.462 111.668 351.921 111.677 351.42 111.852C350.924 112.023 350.502 112.307 350.153 112.703C349.804 113.1 349.56 113.559 349.42 114.082L349.195 114.922C349.003 115.638 348.964 116.278 349.077 116.842C349.196 117.403 349.443 117.873 349.818 118.252C350.194 118.626 350.676 118.892 351.265 119.05C351.648 119.152 352.008 119.191 352.345 119.167C352.688 119.14 353.002 119.047 353.287 118.89C353.573 118.728 353.821 118.499 354.033 118.203L355.335 118.976C355.059 119.413 354.697 119.766 354.25 120.035C353.804 120.299 353.297 120.463 352.729 120.527C352.161 120.587 351.556 120.531 350.914 120.359ZM356.589 121.667L359.13 112.184L360.538 112.561L360.154 113.993L360.253 114.02C360.552 113.597 360.966 113.3 361.497 113.129C362.029 112.958 362.578 112.949 363.146 113.101C363.253 113.13 363.386 113.168 363.546 113.215C363.705 113.262 363.825 113.301 363.905 113.331L363.508 114.813C363.462 114.787 363.354 114.738 363.183 114.666C363.018 114.591 362.839 114.528 362.645 114.476C362.184 114.352 361.747 114.339 361.333 114.435C360.924 114.528 360.569 114.716 360.269 114.997C359.974 115.275 359.769 115.628 359.654 116.057L358.046 122.058L356.589 121.667Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_798_630" x1="10.3525" y1="20.9412" x2="398.353" y2="20.9412" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_798_630" x1="34.2665" y1="19.7722" x2="30.1254" y2="35.227" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>
<svg width="411" height="146" viewBox="0 0 411 146" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="0.612372" y="107.505" width="413" height="39" rx="15.5" transform="rotate(-15 0.612372 107.505)" fill="#F8F1FF"/>
<rect x="0.612372" y="107.505" width="413" height="39" rx="15.5" transform="rotate(-15 0.612372 107.505)" stroke="url(#paint0_linear_807_367)"/>
<path d="M38.2219 122.709L41.9941 124.886M38.9564 116.984C40.0401 121.029 37.6508 125.183 33.6209 126.262C29.5901 127.343 25.444 124.94 24.3606 120.896C23.2764 116.85 25.6659 112.697 29.6958 111.617C33.7266 110.537 37.8727 112.94 38.9564 116.984Z" stroke="url(#paint1_linear_807_367)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M54.8838 120.398L51.4956 107.753L53.0268 107.342L54.5356 112.973L61.2779 111.167L59.7691 105.536L61.3003 105.126L64.6885 117.77L63.1573 118.181L61.6419 112.525L54.8996 114.332L56.415 119.987L54.8838 120.398ZM71.064 116.274C70.1502 116.519 69.3079 116.528 68.5371 116.302C67.7693 116.071 67.1088 115.64 66.5555 115.007C66.0052 114.369 65.5999 113.564 65.3396 112.593C65.0793 111.622 65.0269 110.718 65.1823 109.882C65.3408 109.041 65.6834 108.327 66.21 107.741C66.7396 107.149 67.4325 106.738 68.2886 106.509C68.7826 106.376 69.2924 106.328 69.8181 106.364C70.3438 106.399 70.8539 106.549 71.3483 106.814C71.8416 107.074 72.2866 107.476 72.6834 108.018C73.0801 108.56 73.3971 109.274 73.6342 110.159L73.7996 110.776L66.4893 112.735L66.1519 111.475L71.9803 109.914C71.837 109.379 71.602 108.93 71.2755 108.567C70.953 108.204 70.5638 107.953 70.1077 107.815C69.6557 107.676 69.1662 107.677 68.6394 107.818C68.059 107.973 67.5954 108.252 67.2487 108.654C66.9049 109.05 66.6811 109.507 66.5771 110.025C66.4731 110.542 66.4912 111.062 66.6313 111.585L66.8563 112.425C67.0482 113.141 67.3343 113.715 67.7148 114.147C68.0982 114.574 68.5469 114.857 69.061 114.997C69.5739 115.133 70.1246 115.123 70.7133 114.965C71.0961 114.862 71.4275 114.716 71.7075 114.526C71.9906 114.331 72.2161 114.095 72.384 113.816C72.5508 113.533 72.6519 113.21 72.6871 112.848L74.2007 112.866C74.1805 113.383 74.0439 113.869 73.7911 114.325C73.5372 114.777 73.18 115.173 72.7195 115.513C72.258 115.848 71.7061 116.102 71.064 116.274ZM74.7018 101.535L78.0899 114.179L76.6328 114.57L73.2446 101.925L74.7018 101.535ZM81.1901 117.16L77.696 104.12L79.1037 103.743L79.5074 105.25L79.6803 105.203C79.7432 105.01 79.8351 104.761 79.9561 104.455C80.0801 104.143 80.2941 103.839 80.5982 103.541C80.9052 103.239 81.3675 103.004 81.9849 102.839C82.7834 102.625 83.5408 102.636 84.257 102.872C84.9731 103.108 85.6002 103.547 86.1382 104.188C86.6761 104.829 87.0786 105.648 87.3455 106.644C87.6146 107.648 87.677 108.564 87.5328 109.393C87.3875 110.217 87.0663 110.912 86.5694 111.477C86.0713 112.039 85.4271 112.425 84.6368 112.637C84.0276 112.8 83.5128 112.83 83.0924 112.727C82.6709 112.619 82.3266 112.462 82.0596 112.256C81.7914 112.045 81.5807 111.868 81.4273 111.723L81.3038 111.757L82.6472 116.77L81.1901 117.16ZM80.399 108.478C80.5909 109.195 80.8652 109.798 81.2218 110.29C81.5773 110.777 81.9981 111.121 82.4842 111.321C82.9692 111.518 83.504 111.538 84.0885 111.381C84.6976 111.218 85.163 110.921 85.4844 110.491C85.8089 110.055 86.0007 109.536 86.0599 108.934C86.122 108.326 86.0626 107.684 85.8817 107.009C85.7031 106.343 85.4391 105.769 85.0899 105.289C84.7438 104.804 84.323 104.46 83.8275 104.258C83.3351 104.05 82.7802 104.029 82.1628 104.194C81.57 104.353 81.1122 104.637 80.7894 105.045C80.4654 105.45 80.2722 105.947 80.2098 106.537C80.1462 107.123 80.2093 107.77 80.399 108.478ZM94.679 109.734L92.1378 100.251L93.5455 99.8736L93.9426 101.355L94.0661 101.322C94.128 100.763 94.3417 100.285 94.7071 99.8866C95.0714 99.4846 95.5623 99.2009 96.1797 99.0354C96.8054 98.8678 97.3641 98.8703 97.856 99.0429C98.3508 99.2103 98.7834 99.5157 99.1537 99.9591L99.2524 99.9327C99.3641 99.3778 99.6241 98.8912 100.033 98.4729C100.44 98.0505 100.983 97.7483 101.662 97.5663C102.51 97.3391 103.275 97.4188 103.957 97.8053C104.637 98.1877 105.127 98.9366 105.426 100.052L107.126 106.399L105.669 106.79L103.968 100.443C103.781 99.7428 103.455 99.2939 102.992 99.096C102.529 98.8981 102.038 98.8687 101.519 99.0076C100.852 99.1863 100.39 99.5264 100.132 100.028C99.8723 100.525 99.8248 101.081 99.9891 101.694L101.643 107.868L100.162 108.265L98.4213 101.77C98.2768 101.231 97.9855 100.843 97.5474 100.608C97.1082 100.368 96.6128 100.322 96.0612 100.47C95.6825 100.572 95.3556 100.767 95.0803 101.057C94.8092 101.346 94.6207 101.697 94.515 102.109C94.4123 102.516 94.4232 102.952 94.5479 103.417L96.1361 109.344L94.679 109.734ZM113.298 104.957C112.384 105.202 111.542 105.212 110.771 104.986C110.003 104.755 109.343 104.323 108.789 103.69C108.239 103.053 107.834 102.248 107.574 101.276C107.313 100.305 107.261 99.4015 107.416 98.5657C107.575 97.7248 107.917 97.0109 108.444 96.4242C108.974 95.8323 109.666 95.4217 110.523 95.1923C111.017 95.0599 111.526 95.0115 112.052 95.0471C112.578 95.0827 113.088 95.2328 113.582 95.4974C114.076 95.7579 114.521 96.1592 114.917 96.7014C115.314 97.2436 115.631 97.9572 115.868 98.8422L116.034 99.4596L108.723 101.418L108.386 100.159L114.214 98.5971C114.071 98.062 113.836 97.6132 113.509 97.2507C113.187 96.8871 112.798 96.6363 112.342 96.4982C111.89 96.359 111.4 96.36 110.873 96.5012C110.293 96.6567 109.829 96.9353 109.483 97.3371C109.139 97.7336 108.915 98.1906 108.811 98.7082C108.707 99.2257 108.725 99.7459 108.865 100.269L109.09 101.108C109.282 101.825 109.568 102.399 109.949 102.83C110.332 103.257 110.781 103.541 111.295 103.681C111.808 103.817 112.359 103.806 112.947 103.648C113.33 103.546 113.661 103.4 113.941 103.21C114.225 103.015 114.45 102.778 114.618 102.499C114.785 102.216 114.886 101.894 114.921 101.531L116.435 101.549C116.414 102.066 116.278 102.553 116.025 103.009C115.771 103.461 115.414 103.856 114.954 104.196C114.492 104.531 113.94 104.785 113.298 104.957ZM121.304 89.0475L124.692 101.692L123.235 102.083L119.847 89.438L121.304 89.0475ZM130.869 100.249C129.955 100.494 129.113 100.504 128.342 100.278C127.574 100.047 126.913 99.6149 126.36 98.9823C125.81 98.3445 125.405 97.5398 125.144 96.5684C124.884 95.597 124.832 94.6934 124.987 93.8577C125.146 93.0167 125.488 92.3029 126.015 91.7162C126.544 91.1243 127.237 90.7136 128.093 90.4842C128.587 90.3519 129.097 90.3035 129.623 90.3391C130.149 90.3747 130.659 90.5248 131.153 90.7894C131.646 91.0498 132.091 91.4511 132.488 91.9934C132.885 92.5356 133.202 93.2492 133.439 94.1341L133.604 94.7516L126.294 96.7103L125.957 95.4508L131.785 93.8891C131.642 93.354 131.407 92.9052 131.08 92.5427C130.758 92.1791 130.368 91.9282 129.912 91.7902C129.46 91.651 128.971 91.652 128.444 91.7931C127.864 91.9487 127.4 92.2273 127.053 92.629C126.71 93.0255 126.486 93.4826 126.382 94.0001C126.278 94.5177 126.296 95.0378 126.436 95.5606L126.661 96.4003C126.853 97.1165 127.139 97.6905 127.519 98.1224C127.903 98.5491 128.352 98.8325 128.866 98.9727C129.379 99.1088 129.929 99.098 130.518 98.9403C130.901 98.8377 131.232 98.6915 131.512 98.5018C131.795 98.3068 132.021 98.0699 132.189 97.7911C132.356 97.5082 132.457 97.1855 132.492 96.8232L134.005 96.8411C133.985 97.3583 133.849 97.8449 133.596 98.3008C133.342 98.7527 132.985 99.1484 132.524 99.4879C132.063 99.8234 131.511 100.077 130.869 100.249ZM139.288 98.0198C138.687 98.1808 138.111 98.2137 137.561 98.1186C137.009 98.0193 136.531 97.7922 136.127 97.4372C135.722 97.0781 135.437 96.5898 135.272 95.9724C135.126 95.4291 135.115 94.96 135.239 94.5651C135.361 94.1661 135.576 93.8219 135.882 93.5325C136.188 93.2431 136.545 92.9931 136.951 92.7827C137.361 92.567 137.779 92.3713 138.204 92.1956C138.76 91.9671 139.212 91.7864 139.561 91.6534C139.912 91.5152 140.157 91.3767 140.296 91.2379C140.44 91.098 140.48 90.9107 140.417 90.6761L140.404 90.6267C140.241 90.0175 139.947 89.5888 139.523 89.3407C139.104 89.0914 138.558 89.0566 137.887 89.2364C137.192 89.4228 136.687 89.7212 136.373 90.1317C136.06 90.5422 135.869 90.9418 135.801 91.3306L134.286 91.2072C134.379 90.5648 134.588 90.0279 134.913 89.5965C135.242 89.1599 135.634 88.8122 136.09 88.5534C136.548 88.2893 137.016 88.0933 137.494 87.9654C137.798 87.8838 138.158 87.8271 138.573 87.7953C138.991 87.7583 139.415 87.8013 139.845 87.9243C140.279 88.0462 140.68 88.2984 141.047 88.6809C141.414 89.0633 141.699 89.6312 141.901 90.3845L143.575 96.6328L142.118 97.0232L141.774 95.739L141.7 95.7588C141.656 95.9911 141.55 96.2555 141.383 96.5518C141.215 96.8482 140.962 97.13 140.623 97.3972C140.285 97.6645 139.839 97.872 139.288 98.0198ZM139.159 96.6513C139.736 96.4969 140.191 96.2535 140.525 95.9212C140.864 95.5879 141.086 95.2151 141.192 94.803C141.302 94.3897 141.304 93.9855 141.198 93.5904L140.841 92.2567C140.799 92.3474 140.681 92.4517 140.488 92.5697C140.297 92.6824 140.072 92.7979 139.813 92.9159C139.556 93.0288 139.305 93.1359 139.059 93.2372C138.815 93.3333 138.618 93.4126 138.467 93.475C138.102 93.6259 137.769 93.801 137.47 94.0004C137.173 94.1945 136.953 94.4277 136.81 94.6999C136.67 94.9669 136.649 95.2856 136.749 95.6561C136.884 96.1624 137.174 96.495 137.618 96.6539C138.065 96.8077 138.579 96.8068 139.159 96.6513ZM145.713 96.0599L143.172 86.5763L144.579 86.1991L144.963 87.6315L145.062 87.6051C145.109 87.0895 145.32 86.6249 145.695 86.2114C146.069 85.7978 146.54 85.5149 147.108 85.3627C147.215 85.334 147.35 85.3002 147.511 85.2613C147.673 85.2224 147.796 85.1961 147.88 85.1823L148.278 86.6641C148.225 86.665 148.107 86.6768 147.923 86.6995C147.742 86.717 147.555 86.7517 147.362 86.8035C146.901 86.927 146.515 87.1341 146.205 87.4246C145.898 87.7099 145.684 88.0494 145.565 88.4432C145.448 88.8317 145.447 89.2401 145.562 89.6681L147.17 95.6695L145.713 96.0599ZM151.589 88.3709L153.117 94.0759L151.66 94.4663L149.119 84.9827L150.527 84.6055L150.924 86.0873L151.047 86.0542C151.141 85.5131 151.375 85.0357 151.749 84.6221C152.122 84.2045 152.667 83.8997 153.383 83.7078C154.026 83.5357 154.623 83.5169 155.175 83.6513C155.726 83.7815 156.206 84.0763 156.616 84.5356C157.025 84.9908 157.337 85.6218 157.554 86.4285L159.168 92.4546L157.711 92.845L156.123 86.9178C155.923 86.1727 155.574 85.6442 155.076 85.3321C154.577 85.016 153.989 84.9483 153.314 85.1292C152.849 85.2538 152.46 85.4661 152.148 85.7659C151.84 86.0647 151.633 86.4356 151.527 86.8788C151.42 87.322 151.441 87.8193 151.589 88.3709ZM165.875 90.6575L162.487 78.0126L163.944 77.6222L165.195 82.2899L165.318 82.2568C165.381 82.0635 165.473 81.8139 165.594 81.5079C165.718 81.1968 165.932 80.8924 166.236 80.5947C166.543 80.2919 167.006 80.0577 167.623 79.8923C168.422 79.6783 169.179 79.6893 169.895 79.9254C170.611 80.1614 171.238 80.6 171.776 81.2411C172.314 81.8823 172.717 82.7009 172.984 83.697C173.253 84.7013 173.315 85.6177 173.171 86.446C173.026 87.2702 172.704 87.9651 172.207 88.5306C171.709 89.092 171.065 89.4786 170.275 89.6903C169.666 89.8536 169.151 89.8834 168.73 89.7799C168.309 89.6722 167.965 89.5152 167.698 89.3089C167.43 89.0984 167.219 88.921 167.065 88.7768L166.893 88.8231L167.283 90.2803L165.875 90.6575ZM166.037 85.5318C166.229 86.248 166.503 86.8517 166.86 87.3429C167.215 87.83 167.636 88.1739 168.122 88.3745C168.607 88.571 169.142 88.591 169.727 88.4343C170.336 88.2711 170.801 87.9744 171.123 87.5441C171.447 87.1087 171.639 86.5896 171.698 85.987C171.76 85.3792 171.701 84.7378 171.52 84.0627C171.341 83.3959 171.077 82.8225 170.728 82.3426C170.382 81.8574 169.961 81.5135 169.466 81.311C168.973 81.1032 168.418 81.0821 167.801 81.2475C167.208 81.4063 166.75 81.69 166.427 82.0986C166.103 82.5031 165.91 83.0004 165.848 83.5907C165.784 84.1768 165.847 84.8238 166.037 85.5318ZM178.805 87.4311C178.204 87.5922 177.628 87.6251 177.078 87.53C176.526 87.4307 176.049 87.2036 175.645 86.8486C175.24 86.4895 174.954 86.0012 174.789 85.3838C174.643 84.8405 174.632 84.3713 174.756 83.9765C174.878 83.5775 175.093 83.2333 175.399 82.9439C175.705 82.6544 176.062 82.4045 176.469 82.194C176.879 81.9783 177.296 81.7827 177.721 81.607C178.277 81.3785 178.73 81.1978 179.078 81.0648C179.429 80.9265 179.674 80.788 179.814 80.6493C179.957 80.5094 179.997 80.3221 179.934 80.0875L179.921 80.0381C179.758 79.4289 179.464 79.0002 179.041 78.752C178.621 78.5027 178.075 78.468 177.405 78.6477C176.709 78.8341 176.204 79.1326 175.891 79.5431C175.577 79.9535 175.387 80.3532 175.319 80.7419L173.803 80.6186C173.896 79.9761 174.105 79.4392 174.431 79.0079C174.759 78.5713 175.151 78.2236 175.607 77.9648C176.066 77.7007 176.534 77.5047 177.011 77.3767C177.316 77.2951 177.675 77.2384 178.09 77.2066C178.508 77.1696 178.932 77.2126 179.362 77.3356C179.797 77.4575 180.197 77.7097 180.564 78.0922C180.932 78.4747 181.216 79.0426 181.418 79.7958L183.092 86.0442L181.635 86.4346L181.291 85.1504L181.217 85.1702C181.173 85.4025 181.068 85.6668 180.9 85.9632C180.732 86.2596 180.479 86.5414 180.141 86.8086C179.802 87.0758 179.357 87.2833 178.805 87.4311ZM178.677 86.0626C179.253 85.9082 179.708 85.6649 180.043 85.3326C180.381 84.9992 180.604 84.6265 180.709 84.2143C180.819 83.8011 180.821 83.3969 180.715 83.0017L180.358 81.6681C180.316 81.7587 180.198 81.863 180.005 81.981C179.815 82.0938 179.59 82.2092 179.33 82.3273C179.074 82.4401 178.822 82.5472 178.576 82.6485C178.332 82.7446 178.135 82.8239 177.984 82.8864C177.619 83.0373 177.286 83.2124 176.987 83.4118C176.69 83.6059 176.471 83.8391 176.327 84.1113C176.187 84.3783 176.167 84.697 176.266 85.0674C176.402 85.5737 176.691 85.9063 177.136 86.0653C177.583 86.219 178.096 86.2181 178.677 86.0626ZM189.976 76.3116L188.766 77.0328C188.625 76.8367 188.447 76.6573 188.231 76.4945C188.019 76.3265 187.758 76.2109 187.45 76.1479C187.142 76.0849 186.776 76.1101 186.352 76.2237C185.772 76.3793 185.324 76.6426 185.009 77.0139C184.697 77.3799 184.595 77.7666 184.704 78.1741C184.801 78.5363 185.01 78.7871 185.329 78.9265C185.649 79.0658 186.108 79.1304 186.705 79.1204L188.205 79.0889C189.108 79.0676 189.825 79.2131 190.354 79.5257C190.882 79.8342 191.235 80.3197 191.413 80.9824C191.558 81.5258 191.532 82.0534 191.334 82.5653C191.14 83.0761 190.798 83.5294 190.308 83.9253C189.819 84.3212 189.206 84.6178 188.469 84.8152C187.502 85.0744 186.645 85.079 185.899 84.829C185.152 84.579 184.586 84.0732 184.202 83.3117L185.492 82.5953C185.76 83.0705 186.112 83.3865 186.547 83.5436C186.986 83.6995 187.503 83.6975 188.1 83.5376C188.779 83.3556 189.28 83.0671 189.602 82.672C189.927 82.2716 190.035 81.8677 189.926 81.4602C189.838 81.1309 189.649 80.886 189.358 80.7255C189.067 80.5609 188.668 80.487 188.161 80.5038L186.481 80.5568C185.557 80.5837 184.834 80.4357 184.311 80.1127C183.79 79.7845 183.442 79.2931 183.267 78.6386C183.124 78.1035 183.147 77.5899 183.337 77.0978C183.532 76.6046 183.859 76.1706 184.319 75.7959C184.783 75.4201 185.348 75.1429 186.015 74.9642C186.953 74.7127 187.745 74.7211 188.391 74.9894C189.04 75.2565 189.568 75.6973 189.976 76.3116ZM193.792 83.1771L191.251 73.6934L192.708 73.303L195.25 82.7866L193.792 83.1771ZM191.569 71.9143C191.285 71.9904 191.014 71.9593 190.756 71.821C190.503 71.6816 190.34 71.476 190.267 71.2044C190.194 70.9327 190.232 70.6731 190.382 70.4256C190.536 70.177 190.755 70.0146 191.039 69.9385C191.323 69.8624 191.592 69.8941 191.846 70.0335C192.103 70.1718 192.268 70.3768 192.341 70.6485C192.414 70.9201 192.373 71.1803 192.219 71.4289C192.07 71.6764 191.853 71.8382 191.569 71.9143ZM201.302 81.3765C200.413 81.6148 199.592 81.61 198.837 81.3622C198.082 81.1144 197.433 80.6684 196.89 80.0243C196.347 79.3801 195.949 78.5847 195.695 77.638C195.437 76.6748 195.386 75.7774 195.543 74.9457C195.702 74.1089 196.045 73.3971 196.572 72.8104C197.102 72.2185 197.794 71.8079 198.651 71.5784C199.317 71.3998 199.951 71.3622 200.553 71.4658C201.154 71.5694 201.685 71.7977 202.146 72.1507C202.607 72.5037 202.957 72.9655 203.199 73.5362L201.742 73.9266C201.515 73.5242 201.165 73.2076 200.693 72.9768C200.224 72.7407 199.668 72.7087 199.026 72.8808C198.458 73.033 198 73.3146 197.651 73.7257C197.305 74.1315 197.085 74.634 196.989 75.233C196.897 75.8269 196.947 76.4819 197.139 77.1981C197.335 77.9308 197.621 78.5379 197.997 79.0195C198.378 79.5 198.82 79.8337 199.324 80.0205C199.833 80.2063 200.375 80.222 200.952 80.0676C201.33 79.9661 201.656 79.8082 201.93 79.5937C202.203 79.3793 202.414 79.1199 202.562 78.8156C202.71 78.5113 202.783 78.1741 202.78 77.8041L204.238 77.4136C204.305 77.9955 204.237 78.5543 204.032 79.0901C203.83 79.6207 203.499 80.0888 203.038 80.4945C202.581 80.895 202.002 81.189 201.302 81.3765ZM211.333 70.589L210.123 71.3102C209.982 71.1141 209.804 70.9347 209.588 70.7719C209.376 70.6039 209.115 70.4883 208.807 70.4253C208.499 70.3623 208.133 70.3875 207.709 70.5011C207.129 70.6567 206.681 70.92 206.366 71.2912C206.054 71.6572 205.952 72.044 206.061 72.4515C206.158 72.8137 206.367 73.0645 206.686 73.2038C207.006 73.3432 207.465 73.4078 208.062 73.3978L209.562 73.3663C210.465 73.3449 211.182 73.4905 211.711 73.8031C212.239 74.1116 212.592 74.5971 212.77 75.2598C212.915 75.8032 212.889 76.3308 212.691 76.8427C212.497 77.3535 212.155 77.8068 211.666 78.2027C211.176 78.5985 210.563 78.8952 209.826 79.0926C208.859 79.3518 208.002 79.3564 207.256 79.1064C206.509 78.8564 205.944 78.3506 205.559 77.5891L206.849 76.8727C207.117 77.3478 207.469 77.6639 207.904 77.821C208.343 77.9769 208.86 77.9749 209.457 77.815C210.136 77.633 210.637 77.3445 210.959 76.9493C211.284 76.549 211.392 76.1451 211.283 75.7376C211.195 75.4083 211.006 75.1634 210.716 75.0029C210.424 74.8383 210.025 74.7644 209.518 74.7812L207.838 74.8342C206.914 74.8611 206.191 74.7131 205.668 74.3901C205.147 74.0618 204.799 73.5705 204.624 72.916C204.481 72.3809 204.504 71.8673 204.694 71.3752C204.889 70.882 205.216 70.448 205.676 70.0733C206.14 69.6975 206.705 69.4203 207.372 69.2416C208.31 68.9901 209.102 68.9985 209.748 69.2667C210.397 69.5339 210.926 69.9746 211.333 70.589ZM223.424 75.4492C222.567 75.6786 221.762 75.6761 221.006 75.4418C220.255 75.2063 219.6 74.7708 219.041 74.1352C218.487 73.4985 218.079 72.6903 217.816 71.7106C217.551 70.7228 217.499 69.8124 217.66 68.9797C217.825 68.1458 218.174 67.4391 218.707 66.8596C219.244 66.2789 219.94 65.8739 220.796 65.6445C221.653 65.4151 222.456 65.4181 223.208 65.6535C223.963 65.8879 224.619 66.3255 225.174 66.9663C225.734 67.606 226.146 68.4199 226.411 69.4077C226.673 70.3874 226.721 71.2921 226.555 72.1218C226.394 72.9504 226.044 73.6551 225.507 74.2357C224.974 74.8153 224.28 75.2198 223.424 75.4492ZM223.073 74.1402C223.723 73.966 224.214 73.6559 224.544 73.21C224.875 72.7641 225.068 72.2424 225.124 71.6451C225.18 71.0477 225.123 70.4321 224.953 69.7982C224.784 69.1643 224.525 68.6006 224.176 68.1072C223.828 67.6138 223.398 67.2546 222.888 67.0296C222.378 66.8045 221.798 66.7792 221.147 66.9534C220.497 67.1277 220.007 67.4398 219.678 67.8899C219.348 68.3399 219.156 68.8656 219.101 69.4671C219.046 70.0686 219.103 70.6863 219.273 71.3202C219.443 71.9541 219.702 72.5157 220.049 73.005C220.396 73.4943 220.824 73.8494 221.334 74.0703C221.843 74.2912 222.423 74.3145 223.073 74.1402ZM231.053 63.0287L231.384 64.2635L226.271 65.6334L225.94 64.3985L231.053 63.0287ZM230.013 73.4719L227.121 62.6793C226.975 62.136 226.982 61.649 227.14 61.2184C227.298 60.7878 227.556 60.4273 227.915 60.137C228.274 59.8467 228.68 59.6409 229.133 59.5196C229.491 59.4236 229.791 59.3742 230.033 59.3711C230.275 59.3681 230.458 59.3764 230.582 59.396L230.5 60.768C230.419 60.7632 230.308 60.7599 230.166 60.7581C230.029 60.7553 229.855 60.782 229.645 60.8382C229.164 60.9673 228.848 61.1819 228.699 61.4821C228.554 61.7812 228.545 62.1654 228.671 62.6346L231.47 73.0814L230.013 73.4719ZM242.333 70.4089C241.732 70.5699 241.156 70.6029 240.606 70.5077C240.054 70.4085 239.576 70.1813 239.173 69.8263C238.768 69.4672 238.482 68.979 238.317 68.3615C238.171 67.8182 238.16 67.3491 238.284 66.9542C238.406 66.5552 238.621 66.211 238.927 65.9216C239.233 65.6322 239.59 65.3823 239.997 65.1718C240.407 64.9561 240.824 64.7604 241.249 64.5848C241.805 64.3563 242.258 64.1755 242.606 64.0425C242.957 63.9043 243.202 63.7658 243.341 63.627C243.485 63.4871 243.525 63.2999 243.462 63.0652L243.449 63.0158C243.286 62.4067 242.992 61.978 242.568 61.7298C242.149 61.4805 241.603 61.4457 240.932 61.6255C240.237 61.8119 239.732 62.1103 239.419 62.5208C239.105 62.9313 238.914 63.3309 238.847 63.7197L237.331 63.5963C237.424 62.9539 237.633 62.417 237.958 61.9856C238.287 61.5491 238.679 61.2014 239.135 60.9425C239.593 60.6784 240.061 60.4824 240.539 60.3545C240.844 60.2729 241.203 60.2162 241.618 60.1844C242.036 60.1474 242.46 60.1904 242.89 60.3134C243.325 60.4353 243.725 60.6875 244.092 61.07C244.46 61.4525 244.744 62.0203 244.946 62.7736L246.62 69.0219L245.163 69.4124L244.819 68.1281L244.745 68.148C244.701 68.3803 244.596 68.6446 244.428 68.941C244.26 69.2374 244.007 69.5192 243.668 69.7864C243.33 70.0536 242.885 70.2611 242.333 70.4089ZM242.205 69.0404C242.781 68.886 243.236 68.6426 243.571 68.3104C243.909 67.977 244.131 67.6042 244.237 67.1921C244.347 66.7788 244.349 66.3746 244.243 65.9795L243.886 64.6458C243.844 64.7365 243.726 64.8408 243.533 64.9588C243.343 65.0716 243.118 65.187 242.858 65.3051C242.602 65.4179 242.35 65.525 242.104 65.6263C241.86 65.7224 241.663 65.8017 241.512 65.8642C241.147 66.015 240.814 66.1901 240.515 66.3895C240.218 66.5837 239.998 66.8168 239.855 67.089C239.715 67.356 239.695 67.6747 239.794 68.0452C239.929 68.5515 240.219 68.8841 240.663 69.0431C241.11 69.1968 241.624 69.1959 242.205 69.0404ZM248.758 68.4491L246.217 58.9654L247.625 58.5882L248.008 60.0207L248.107 59.9942C248.154 59.4786 248.365 59.0141 248.74 58.6005C249.114 58.1869 249.585 57.904 250.153 57.7518C250.26 57.7231 250.395 57.6894 250.556 57.6505C250.718 57.6116 250.841 57.5852 250.926 57.5714L251.323 59.0532C251.27 59.0541 251.152 59.0659 250.968 59.0886C250.788 59.1061 250.601 59.1408 250.407 59.1926C249.946 59.3162 249.56 59.5232 249.25 59.8137C248.943 60.099 248.729 60.4385 248.61 60.8323C248.493 61.2209 248.492 61.6292 248.607 62.0573L250.215 68.0586L248.758 68.4491ZM256.883 56.1074L257.214 57.3423L252.299 58.6592L251.968 57.4243L256.883 56.1074ZM252.792 54.7684L254.249 54.378L256.671 63.4171C256.781 63.8287 256.924 64.1214 257.098 64.2952C257.276 64.4638 257.469 64.5577 257.677 64.577C257.888 64.591 258.1 64.5693 258.314 64.512C258.475 64.469 258.605 64.4254 258.703 64.3814C258.8 64.3333 258.878 64.2947 258.937 64.2658L259.584 65.4954C259.495 65.5589 259.367 65.6329 259.2 65.7173C259.034 65.8059 258.815 65.8866 258.544 65.9594C258.132 66.0697 257.705 66.0893 257.262 66.0182C256.824 65.946 256.426 65.7635 256.07 65.4707C255.718 65.1769 255.468 64.7542 255.32 64.2026L252.792 54.7684ZM261.094 65.1435L258.553 55.6599L260.01 55.2695L262.552 64.7531L261.094 65.1435ZM258.871 53.8808C258.587 53.9569 258.316 53.9258 258.058 53.7875C257.805 53.648 257.642 53.4425 257.569 53.1708C257.496 52.8992 257.534 52.6396 257.684 52.3921C257.838 52.1435 258.057 51.9811 258.341 51.905C258.625 51.8289 258.894 51.8606 259.148 52C259.405 52.1383 259.57 52.3433 259.643 52.615C259.716 52.8866 259.675 53.1468 259.522 53.3954C259.372 53.6429 259.155 53.8047 258.871 53.8808ZM266.381 53.5625L266.712 54.7974L261.599 56.1672L261.269 54.9324L266.381 53.5625ZM265.341 64.0057L262.449 53.2131C262.303 52.6698 262.31 52.1828 262.468 51.7522C262.626 51.3216 262.885 50.9612 263.244 50.6709C263.603 50.3806 264.008 50.1748 264.461 50.0534C264.819 49.9575 265.119 49.908 265.361 49.905C265.603 49.9019 265.786 49.9102 265.91 49.9298L265.828 51.3019C265.747 51.297 265.636 51.2937 265.495 51.292C265.357 51.2891 265.183 51.3158 264.973 51.3721C264.492 51.5011 264.176 51.7157 264.028 52.0159C263.883 52.315 263.873 52.6992 263.999 53.1685L266.798 63.6153L265.341 64.0057ZM270.443 62.6387L267.901 53.1551L269.358 52.7647L271.9 62.2483L270.443 62.6387ZM268.219 51.376C267.935 51.4521 267.664 51.421 267.406 51.2827C267.153 51.1432 266.99 50.9377 266.917 50.666C266.844 50.3944 266.883 50.1348 267.032 49.8873C267.186 49.6387 267.405 49.4763 267.689 49.4002C267.973 49.3241 268.242 49.3558 268.496 49.4952C268.753 49.6335 268.919 49.8385 268.991 50.1102C269.064 50.3818 269.024 50.642 268.87 50.8906C268.72 51.1381 268.503 51.2999 268.219 51.376ZM277.953 60.8382C277.063 61.0764 276.242 61.0716 275.487 60.8239C274.732 60.5761 274.083 60.1301 273.54 59.4859C272.997 58.8418 272.599 58.0464 272.345 57.0996C272.087 56.1365 272.036 55.2391 272.193 54.4074C272.352 53.5705 272.695 52.8588 273.222 52.2721C273.752 51.6802 274.444 51.2695 275.301 51.0401C275.967 50.8614 276.602 50.8239 277.203 50.9275C277.804 51.0311 278.335 51.2594 278.796 51.6124C279.257 51.9654 279.608 52.4272 279.849 52.9979L278.392 53.3883C278.165 52.9859 277.815 52.6693 277.343 52.4384C276.874 52.2024 276.318 52.1704 275.676 52.3424C275.108 52.4946 274.65 52.7763 274.301 53.1873C273.955 53.5932 273.735 54.0957 273.64 54.6947C273.547 55.2886 273.597 55.9436 273.789 56.6598C273.985 57.3925 274.271 57.9996 274.647 58.4812C275.028 58.9617 275.47 59.2953 275.975 59.4822C276.483 59.668 277.026 59.6837 277.602 59.5293C277.98 59.4278 278.307 59.2698 278.58 59.0554C278.853 58.841 279.064 58.5816 279.212 58.2773C279.36 57.9729 279.433 57.6358 279.431 57.2657L280.888 56.8753C280.955 57.4572 280.887 58.016 280.682 58.5518C280.48 59.0824 280.149 59.5505 279.688 59.9562C279.231 60.3567 278.652 60.6507 277.953 60.8382ZM283.237 59.2104L280.696 49.7267L282.153 49.3363L284.694 58.8199L283.237 59.2104ZM281.014 47.9476C280.73 48.0237 280.459 47.9926 280.201 47.8543C279.948 47.7149 279.784 47.5093 279.712 47.2377C279.639 46.966 279.677 46.7064 279.827 46.4589C279.981 46.2103 280.2 46.048 280.484 45.9719C280.768 45.8958 281.037 45.9274 281.29 46.0668C281.548 46.2051 281.713 46.4101 281.786 46.6818C281.859 46.9535 281.818 47.2136 281.664 47.4622C281.515 47.7097 281.298 47.8715 281.014 47.9476ZM289.692 57.7191C289.091 57.8801 288.515 57.9131 287.965 57.8179C287.413 57.7187 286.935 57.4915 286.532 57.1365C286.126 56.7774 285.841 56.2892 285.676 55.6717C285.53 55.1284 285.519 54.6593 285.643 54.2644C285.765 53.8654 285.98 53.5212 286.286 53.2318C286.592 52.9424 286.949 52.6925 287.356 52.482C287.765 52.2663 288.183 52.0706 288.608 51.895C289.164 51.6665 289.617 51.4857 289.965 51.3527C290.316 51.2145 290.561 51.076 290.7 50.9372C290.844 50.7973 290.884 50.6101 290.821 50.3754L290.808 50.326C290.645 49.7169 290.351 49.2882 289.927 49.04C289.508 48.7907 288.962 48.7559 288.291 48.9357C287.596 49.1221 287.091 49.4205 286.778 49.831C286.464 50.2415 286.273 50.6411 286.206 51.0299L284.69 50.9065C284.783 50.2641 284.992 49.7272 285.317 49.2958C285.646 48.8593 286.038 48.5116 286.494 48.2527C286.952 47.9886 287.42 47.7926 287.898 47.6647C288.202 47.5831 288.562 47.5264 288.977 47.4946C289.395 47.4576 289.819 47.5006 290.249 47.6236C290.683 47.7455 291.084 47.9977 291.451 48.3802C291.819 48.7627 292.103 49.3305 292.305 50.0838L293.979 56.3321L292.522 56.7226L292.178 55.4383L292.104 55.4582C292.06 55.6905 291.954 55.9548 291.787 56.2512C291.619 56.5476 291.366 56.8294 291.027 57.0966C290.689 57.3638 290.244 57.5713 289.692 57.7191ZM289.564 56.3506C290.14 56.1962 290.595 55.9528 290.93 55.6206C291.268 55.2872 291.49 54.9144 291.596 54.5023C291.706 54.089 291.708 53.6848 291.602 53.2897L291.245 51.956C291.203 52.0467 291.085 52.151 290.892 52.269C290.702 52.3818 290.477 52.4972 290.217 52.6153C289.961 52.7281 289.709 52.8352 289.463 52.9365C289.219 53.0326 289.022 53.1119 288.871 53.1744C288.506 53.3252 288.173 53.5004 287.874 53.6997C287.577 53.8939 287.357 54.127 287.214 54.3992C287.074 54.6662 287.054 54.9849 287.153 55.3554C287.288 55.8617 287.578 56.1943 288.022 56.3533C288.469 56.507 288.983 56.5061 289.564 56.3506ZM294.186 42.724L297.574 55.3688L296.117 55.7593L292.729 43.1144L294.186 42.724ZM304.09 53.623L301.549 44.1393L303.006 43.7489L305.547 53.2325L304.09 53.623ZM301.866 42.3602C301.582 42.4363 301.311 42.4052 301.054 42.2669C300.8 42.1275 300.637 41.9219 300.564 41.6503C300.491 41.3786 300.53 41.119 300.68 40.8715C300.834 40.6229 301.053 40.4606 301.337 40.3845C301.621 40.3084 301.889 40.34 302.143 40.4794C302.401 40.6177 302.566 40.8227 302.639 41.0944C302.711 41.3661 302.671 41.6262 302.517 41.8748C302.367 42.1223 302.15 42.2841 301.866 42.3602ZM307.623 46.5618L309.151 52.2668L307.694 52.6572L305.153 43.1736L306.561 42.7964L306.958 44.2782L307.081 44.2451C307.174 43.7039 307.408 43.2266 307.783 42.813C308.156 42.3953 308.701 42.0905 309.417 41.8986C310.059 41.7266 310.656 41.7077 311.209 41.8421C311.76 41.9724 312.24 42.2672 312.65 42.7265C313.059 43.1817 313.371 43.8126 313.587 44.6194L315.202 50.6455L313.745 51.0359L312.157 45.1086C311.957 44.3636 311.608 43.8351 311.11 43.523C310.61 43.2068 310.023 43.1392 309.348 43.3201C308.883 43.4447 308.494 43.6569 308.182 43.9568C307.874 44.2555 307.667 44.6265 307.56 45.0697C307.454 45.5128 307.475 46.0102 307.623 46.5618ZM318.926 39.483L319.257 40.7179L314.342 42.0348L314.012 40.7999L318.926 39.483ZM314.835 38.144L316.292 37.7535L318.714 46.7926C318.825 47.2042 318.967 47.497 319.142 47.6708C319.319 47.8394 319.512 47.9333 319.72 47.9526C319.931 47.9666 320.144 47.9449 320.358 47.8876C320.518 47.8445 320.648 47.801 320.746 47.757C320.844 47.7088 320.922 47.6703 320.98 47.6414L321.627 48.8709C321.538 48.9345 321.41 49.0084 321.243 49.0929C321.077 49.1815 320.858 49.2622 320.587 49.335C320.175 49.4453 319.748 49.4649 319.305 49.3938C318.867 49.3215 318.47 49.1391 318.113 48.8463C317.761 48.5525 317.511 48.1298 317.363 47.5782L314.835 38.144ZM327.065 47.6786C326.151 47.9234 325.309 47.9329 324.538 47.7071C323.77 47.4761 323.11 47.0443 322.556 46.4117C322.006 45.7738 321.601 44.9692 321.341 43.9978C321.08 43.0264 321.028 42.1228 321.183 41.287C321.342 40.4461 321.684 39.7322 322.211 39.1455C322.741 38.5536 323.433 38.143 324.29 37.9136C324.784 37.7812 325.293 37.7328 325.819 37.7684C326.345 37.804 326.855 37.9541 327.349 38.2187C327.843 38.4792 328.288 38.8805 328.684 39.4227C329.081 39.9649 329.398 40.6785 329.635 41.5635L329.801 42.1809L322.49 44.1397L322.153 42.8802L327.981 41.3184C327.838 40.7833 327.603 40.3345 327.276 39.972C326.954 39.6084 326.565 39.3576 326.109 39.2195C325.657 39.0803 325.167 39.0813 324.64 39.2225C324.06 39.378 323.596 39.6566 323.25 40.0584C322.906 40.4549 322.682 40.9119 322.578 41.4295C322.474 41.947 322.492 42.4672 322.632 42.9899L322.857 43.8296C323.049 44.5458 323.335 45.1199 323.716 45.5518C324.099 45.9784 324.548 46.2619 325.062 46.4021C325.575 46.5381 326.126 46.5273 326.714 46.3696C327.097 46.267 327.428 46.1209 327.709 45.9311C327.992 45.7362 328.217 45.4993 328.385 45.2205C328.552 44.9376 328.653 44.6149 328.688 44.2525L330.202 44.2705C330.181 44.7876 330.045 45.2742 329.792 45.7302C329.538 46.182 329.181 46.5778 328.721 46.9173C328.259 47.2528 327.707 47.5065 327.065 47.6786ZM330.703 32.9394L334.091 45.5842L332.634 45.9746L329.246 33.3298L330.703 32.9394ZM334.307 31.9736L337.695 44.6184L336.238 45.0089L332.85 32.364L334.307 31.9736ZM339.842 44.0431L337.301 34.5594L338.758 34.169L341.3 43.6526L339.842 44.0431ZM337.619 32.7803C337.335 32.8564 337.064 32.8253 336.806 32.687C336.553 32.5476 336.39 32.342 336.317 32.0704C336.244 31.7987 336.282 31.5391 336.432 31.2916C336.586 31.043 336.805 30.8807 337.089 30.8046C337.373 30.7285 337.642 30.7601 337.896 30.8995C338.153 31.0378 338.318 31.2428 338.391 31.5145C338.464 31.7862 338.423 32.0463 338.27 32.2949C338.12 32.5424 337.903 32.7042 337.619 32.7803ZM348.281 45.8055C347.577 45.9941 346.948 46.0657 346.393 46.0202C345.839 45.9789 345.354 45.8573 344.938 45.6555C344.528 45.4567 344.18 45.2192 343.894 44.9428L344.836 43.8168C345.014 43.9544 345.234 44.1073 345.495 44.2755C345.757 44.4478 346.086 44.5695 346.48 44.6404C346.879 44.7143 347.364 44.6746 347.937 44.5213C348.702 44.3161 349.284 43.9616 349.683 43.4577C350.082 42.9538 350.176 42.3067 349.964 41.5164L349.448 39.59L349.324 39.6231C349.263 39.8247 349.168 40.0795 349.039 40.3876C348.913 40.6906 348.693 40.9899 348.38 41.2856C348.069 41.5762 347.606 41.8041 346.988 41.9696C346.223 42.1747 345.487 42.1778 344.78 41.9788C344.078 41.7787 343.458 41.3803 342.918 40.7837C342.383 40.1859 341.983 39.3931 341.718 38.4052C341.458 37.4338 341.402 36.5421 341.551 35.7303C341.699 34.9143 342.024 34.2271 342.527 33.6687C343.029 33.1062 343.68 32.718 344.478 32.504C345.096 32.3386 345.613 32.3102 346.031 32.419C346.451 32.5225 346.793 32.678 347.056 32.8855C347.321 33.0878 347.53 33.2569 347.681 33.3928L347.829 33.3531L347.426 31.8466L348.833 31.4694L351.447 41.2247C351.666 42.0397 351.658 42.7521 351.424 43.3617C351.196 43.9744 350.803 44.4834 350.245 44.8887C349.693 45.297 349.038 45.6026 348.281 45.8055ZM346.835 40.6077C347.42 40.4511 347.878 40.1849 348.209 39.8093C348.541 39.4337 348.745 38.9666 348.82 38.4082C348.895 37.8498 348.839 37.2207 348.652 36.521C348.469 35.8377 348.204 35.2622 347.858 34.7946C347.512 34.327 347.098 33.9991 346.615 33.8108C346.132 33.6225 345.595 33.6078 345.002 33.7666C344.385 33.9321 343.912 34.2263 343.584 34.6495C343.26 35.0715 343.066 35.5735 343.002 36.1555C342.941 36.7364 342.997 37.3479 343.169 37.9901C343.345 38.6487 343.604 39.2035 343.946 39.6547C344.29 40.1006 344.705 40.413 345.19 40.592C345.677 40.7657 346.226 40.7709 346.835 40.6077ZM357.549 39.5103C356.636 39.7551 355.793 39.7647 355.022 39.5388C354.255 39.3078 353.594 38.876 353.041 38.2434C352.491 37.6056 352.085 36.8009 351.825 35.8295C351.565 34.8581 351.512 33.9545 351.668 33.1188C351.826 32.2778 352.169 31.564 352.695 30.9773C353.225 30.3854 353.918 29.9747 354.774 29.7453C355.268 29.6129 355.778 29.5646 356.303 29.6002C356.829 29.6358 357.339 29.7859 357.834 30.0504C358.327 30.3109 358.772 30.7122 359.169 31.2544C359.566 31.7967 359.882 32.5102 360.12 33.3952L360.285 34.0126L352.975 35.9714L352.637 34.7119L358.466 33.1502C358.322 32.6151 358.087 32.1663 357.761 31.8038C357.438 31.4402 357.049 31.1893 356.593 31.0512C356.141 30.9121 355.652 30.9131 355.125 31.0542C354.544 31.2098 354.081 31.4884 353.734 31.8901C353.39 32.2866 353.166 32.7437 353.062 33.2612C352.959 33.7788 352.977 34.2989 353.117 34.8217L353.342 35.6614C353.534 36.3776 353.82 36.9516 354.2 37.3835C354.584 37.8102 355.032 38.0936 355.546 38.2338C356.059 38.3699 356.61 38.3591 357.199 38.2014C357.581 38.0988 357.913 37.9526 358.193 37.7629C358.476 37.5679 358.701 37.331 358.869 37.0522C359.036 36.7693 359.137 36.4466 359.172 36.0842L360.686 36.1022C360.666 36.6194 360.529 37.106 360.277 37.5619C360.023 38.0138 359.665 38.4095 359.205 38.749C358.743 39.0845 358.191 39.3382 357.549 39.5103ZM363.047 31.7109L364.575 37.4159L363.118 37.8064L360.577 28.3227L361.985 27.9455L362.382 29.4274L362.505 29.3943C362.599 28.8531 362.832 28.3758 363.207 27.9622C363.58 27.5445 364.125 27.2397 364.841 27.0478C365.483 26.8757 366.08 26.8569 366.633 26.9913C367.184 27.1216 367.664 27.4164 368.074 27.8757C368.483 28.3308 368.795 28.9618 369.011 29.7686L370.626 35.7946L369.169 36.1851L367.581 30.2578C367.381 29.5128 367.032 28.9842 366.534 28.6722C366.034 28.356 365.447 28.2884 364.772 28.4692C364.307 28.5939 363.918 28.8061 363.606 29.106C363.298 29.4047 363.091 29.7757 362.984 30.2188C362.878 30.662 362.899 31.1594 363.047 31.7109ZM376.673 34.3862C375.784 34.6244 374.962 34.6196 374.207 34.3718C373.453 34.124 372.804 33.6781 372.261 33.0339C371.717 32.3898 371.319 31.5944 371.065 30.6476C370.807 29.6845 370.756 28.787 370.913 27.9554C371.073 27.1185 371.416 26.4068 371.942 25.8201C372.472 25.2282 373.165 24.8175 374.021 24.5881C374.688 24.4094 375.322 24.3719 375.923 24.4755C376.524 24.5791 377.055 24.8074 377.516 25.1604C377.977 25.5134 378.328 25.9752 378.569 26.5459L377.112 26.9363C376.885 26.5339 376.535 26.2173 376.063 25.9864C375.594 25.7504 375.038 25.7184 374.396 25.8904C373.828 26.0426 373.37 26.3243 373.021 26.7353C372.676 27.1412 372.455 27.6436 372.36 28.2427C372.267 28.8366 372.317 29.4916 372.509 30.2078C372.705 30.9405 372.992 31.5476 373.368 32.0292C373.748 32.5096 374.19 32.8433 374.695 33.0302C375.203 33.216 375.746 33.2317 376.322 33.0772C376.701 32.9758 377.027 32.8178 377.3 32.6034C377.574 32.3889 377.784 32.1296 377.932 31.8252C378.08 31.5209 378.153 31.1838 378.151 30.8137L379.608 30.4233C379.676 31.0052 379.607 31.564 379.402 32.0998C379.2 32.6303 378.869 33.0985 378.408 33.5042C377.951 33.9047 377.373 34.1987 376.673 34.3862ZM385.987 31.8905C385.073 32.1354 384.231 32.1449 383.46 31.9191C382.692 31.688 382.032 31.2562 381.478 30.6236C380.928 29.9858 380.523 29.1812 380.262 28.2098C380.002 27.2383 379.95 26.3347 380.105 25.499C380.264 24.658 380.606 23.9442 381.133 23.3575C381.662 22.7656 382.355 22.3549 383.211 22.1255C383.705 21.9932 384.215 21.9448 384.741 21.9804C385.267 22.016 385.777 22.1661 386.271 22.4307C386.764 22.6911 387.209 23.0925 387.606 23.6347C388.003 24.1769 388.32 24.8905 388.557 25.7754L388.722 26.3929L381.412 28.3517L381.075 27.0921L386.903 25.5304C386.76 24.9953 386.525 24.5465 386.198 24.184C385.876 23.8204 385.487 23.5695 385.03 23.4315C384.578 23.2923 384.089 23.2933 383.562 23.4345C382.982 23.59 382.518 23.8686 382.171 24.2703C381.828 24.6668 381.604 25.1239 381.5 25.6414C381.396 26.159 381.414 26.6791 381.554 27.2019L381.779 28.0416C381.971 28.7578 382.257 29.3318 382.638 29.7637C383.021 30.1904 383.47 30.4738 383.984 30.614C384.497 30.7501 385.047 30.7393 385.636 30.5816C386.019 30.479 386.35 30.3328 386.63 30.1431C386.913 29.9482 387.139 29.7113 387.307 29.4324C387.474 29.1495 387.575 28.8269 387.61 28.4645L389.123 28.4824C389.103 28.9996 388.967 29.4862 388.714 29.9422C388.46 30.394 388.103 30.7897 387.642 31.1293C387.181 31.4647 386.629 31.7185 385.987 31.8905Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_807_367" x1="0" y1="127.151" x2="414" y2="127.151" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_807_367" x1="30.1256" y1="111.502" x2="34.2667" y2="126.957" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>
<svg width="251" height="59" viewBox="0 0 251 59" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="0.536342" y="19.1952" width="247" height="39" rx="15.5" transform="rotate(-4.33238 0.536342 19.1952)" fill="#F8F1FF"/>
<rect x="0.536342" y="19.1952" width="247" height="39" rx="15.5" transform="rotate(-4.33238 0.536342 19.1952)" stroke="url(#paint0_linear_807_359)"/>
<path d="M34.6816 41.0985L37.9855 43.937M36.463 35.6092C36.7793 39.7843 33.6624 43.4241 29.5023 43.7393C25.3412 44.0545 21.7115 40.9258 21.3953 36.7517C21.0788 32.5747 24.1958 28.9358 28.3559 28.6207C32.517 28.3054 36.1467 31.4342 36.463 35.6092Z" stroke="url(#paint1_linear_807_359)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M51.4832 41.9113L50.4943 28.8578L52.075 28.7381L52.5153 34.551L59.4755 34.0237L59.0351 28.2108L60.6158 28.091L61.6047 41.1445L60.024 41.2643L59.5817 35.4259L52.6216 35.9532L53.0639 41.7916L51.4832 41.9113ZM68.0196 40.8637C67.1358 40.9306 66.3444 40.7791 65.6454 40.4089C64.9506 40.0385 64.3876 39.4892 63.9564 38.7612C63.5294 38.0329 63.2776 37.163 63.201 36.1517C63.1238 35.1319 63.2412 34.2277 63.5532 33.4391C63.8695 32.6502 64.3432 32.0203 64.9742 31.5494C65.6094 31.0782 66.369 30.8091 67.2528 30.7421C68.1366 30.6752 68.9259 30.8269 69.6207 31.1974C70.3197 31.5675 70.8828 32.1189 71.3101 32.8515C71.7417 33.5837 71.9961 34.4598 72.0733 35.4796C72.1499 36.4909 72.0299 37.3889 71.7133 38.1736C71.4009 38.9579 70.9271 39.5857 70.2919 40.0569C69.6609 40.5278 68.9034 40.7967 68.0196 40.8637ZM67.9172 39.5124C68.5886 39.4616 69.128 39.2476 69.5353 38.8706C69.9426 38.4936 70.2292 38.0168 70.3949 37.4401C70.5606 36.8634 70.6187 36.2479 70.5691 35.5935C70.5195 34.9392 70.3692 34.3373 70.1182 33.7879C69.8672 33.2386 69.5118 32.8061 69.052 32.4905C68.5921 32.1749 68.0265 32.0425 67.3552 32.0934C66.6838 32.1442 66.1446 32.3603 65.7376 32.7416C65.3306 33.1228 65.0444 33.6039 64.879 34.1848C64.7136 34.7658 64.6557 35.3834 64.7052 36.0378C64.7548 36.6921 64.9049 37.2919 65.1556 37.837C65.4063 38.3821 65.7614 38.8104 66.2209 39.1217C66.6804 39.4331 67.2459 39.5633 67.9172 39.5124ZM76.083 40.0477L72.3584 30.4835L73.9391 30.3638L76.6231 37.699L76.7251 37.6913L78.2478 30.0374L79.854 29.9157L82.485 37.2293L82.587 37.2216L84.1372 29.5912L85.7179 29.4714L83.4766 39.4876L81.9979 39.5996L79.2865 32.2408L79.1336 32.2523L77.5618 39.9357L76.083 40.0477ZM96.1315 38.734C95.3157 38.7958 94.5799 38.6442 93.924 38.2794C93.2678 37.9103 92.7347 37.3609 92.3248 36.6313C91.9144 35.8974 91.67 35.0121 91.5915 33.9753C91.5136 32.947 91.6223 32.0413 91.9177 31.2582C92.2131 30.4751 92.6596 29.8537 93.2572 29.3939C93.8549 28.9341 94.5659 28.6729 95.3902 28.6105C96.0276 28.5622 96.5392 28.6303 96.925 28.8147C97.3147 28.9946 97.6174 29.211 97.8331 29.4639C98.0528 29.7122 98.2243 29.9172 98.3477 30.0788L98.4752 30.0691L98.1101 25.2505L99.6143 25.1366L100.603 38.1901L99.15 38.3002L99.0361 36.7959L98.8576 36.8095C98.7606 36.9963 98.6205 37.2334 98.4371 37.5208C98.2534 37.804 97.9806 38.0661 97.6185 38.3072C97.2561 38.5441 96.7604 38.6863 96.1315 38.734ZM96.2331 37.3673C96.8365 37.3216 97.3345 37.1257 97.7271 36.7797C98.1194 36.4295 98.4026 35.9657 98.5769 35.3884C98.7507 34.8068 98.8097 34.1464 98.7537 33.407C98.6983 32.6762 98.5436 32.0447 98.2896 31.5127C98.0353 30.9764 97.6884 30.571 97.2488 30.2966C96.8089 30.018 96.283 29.9018 95.6711 29.9482C95.0337 29.9965 94.5149 30.2003 94.1148 30.5597C93.7186 30.9145 93.4354 31.3783 93.2651 31.951C93.0987 32.5192 93.0416 33.1474 93.0938 33.8358C93.1466 34.5327 93.3007 35.1578 93.5563 35.7111C93.8159 36.2598 94.1687 36.6861 94.6148 36.9899C95.0648 37.2891 95.6043 37.4149 96.2331 37.3673ZM107.021 37.909C106.137 37.9759 105.346 37.8243 104.647 37.4542C103.952 37.0838 103.389 36.5345 102.958 35.8065C102.531 35.0781 102.279 34.2083 102.203 33.197C102.125 32.1772 102.243 31.273 102.555 30.4844C102.871 29.6955 103.345 29.0655 103.976 28.5947C104.611 28.1234 105.371 27.8544 106.254 27.7874C107.138 27.7204 107.928 27.8722 108.622 28.2426C109.321 28.6128 109.884 29.1641 110.312 29.8967C110.743 30.629 110.998 31.5051 111.075 32.5249C111.152 33.5362 111.032 34.4342 110.715 35.2188C110.403 36.0032 109.929 36.631 109.294 37.1022C108.663 37.5731 107.905 37.842 107.021 37.909ZM106.919 36.5577C107.59 36.5069 108.13 36.2929 108.537 35.9159C108.944 35.5389 109.231 35.062 109.397 34.4854C109.562 33.9087 109.62 33.2932 109.571 32.6388C109.521 31.9844 109.371 31.3826 109.12 30.8332C108.869 30.2838 108.513 29.8514 108.054 29.5358C107.594 29.2202 107.028 29.0878 106.357 29.1386C105.685 29.1895 105.146 29.4056 104.739 29.7868C104.332 30.1681 104.046 30.6492 103.881 31.2301C103.715 31.811 103.657 32.4287 103.707 33.0831C103.756 33.7374 103.907 34.3372 104.157 34.8823C104.408 35.4274 104.763 35.8557 105.223 36.167C105.682 36.4783 106.248 36.6086 106.919 36.5577ZM117.709 36.8941L116.968 27.104L118.472 26.99L119.213 36.7802L117.709 36.8941ZM117.609 25.4144C117.316 25.4366 117.055 25.3559 116.828 25.1723C116.604 24.9883 116.482 24.7561 116.461 24.4757C116.44 24.1952 116.525 23.9473 116.719 23.7318C116.916 23.516 117.161 23.397 117.454 23.3748C117.747 23.3526 118.006 23.4334 118.229 23.6174C118.457 23.801 118.581 24.033 118.602 24.3134C118.624 24.5939 118.536 24.842 118.338 25.0578C118.145 25.2733 117.902 25.3922 117.609 25.4144ZM126.455 23.1031L127.444 36.1567L125.94 36.2706L124.951 23.2171L126.455 23.1031ZM133.781 35.8817C132.837 35.9532 132.008 35.8066 131.292 35.442C130.58 35.0729 130.011 34.5262 129.585 33.8021C129.162 33.0735 128.912 32.2077 128.837 31.2049C128.761 30.2021 128.876 29.3044 129.184 28.5119C129.495 27.7148 129.964 27.0767 130.59 26.5976C131.22 26.114 131.977 25.8387 132.861 25.7717C133.371 25.7331 133.881 25.7799 134.391 25.9123C134.901 26.0446 135.374 26.2865 135.811 26.638C136.248 26.9853 136.611 27.462 136.9 28.0683C137.19 28.6746 137.369 29.4345 137.438 30.3481L137.487 30.9855L129.94 31.5572L129.842 30.257L135.858 29.8011C135.817 29.2487 135.669 28.7642 135.415 28.3475C135.165 27.9305 134.829 27.612 134.407 27.3918C133.988 27.1714 133.507 27.0818 132.963 27.123C132.364 27.1684 131.857 27.3564 131.442 27.687C131.031 28.013 130.726 28.4207 130.528 28.9101C130.33 29.3994 130.252 29.9139 130.292 30.4536L130.358 31.3204C130.414 32.0598 130.589 32.6769 130.883 33.1717C131.181 33.662 131.569 34.0236 132.049 34.2565C132.527 34.4852 133.071 34.5765 133.678 34.5305C134.073 34.5005 134.426 34.4183 134.737 34.2836C135.051 34.1444 135.316 33.9534 135.533 33.7105C135.749 33.4633 135.908 33.1649 136.01 32.8153L137.494 33.1132C137.378 33.6177 137.154 34.0706 136.821 34.4719C136.488 34.8689 136.064 35.1916 135.548 35.4401C135.033 35.6843 134.444 35.8315 133.781 35.8817ZM142.467 35.2493C141.847 35.2963 141.275 35.2221 140.751 35.0267C140.228 34.827 139.8 34.5154 139.469 34.0918C139.137 33.6639 138.947 33.1313 138.899 32.4939C138.857 31.933 138.933 31.47 139.127 31.1048C139.322 30.7354 139.596 30.4368 139.95 30.2091C140.305 29.9814 140.702 29.8017 141.14 29.6702C141.583 29.5341 142.03 29.4191 142.48 29.3252C143.069 29.2036 143.547 29.1097 143.914 29.0434C144.284 28.9726 144.551 28.8819 144.713 28.7713C144.88 28.6604 144.954 28.4838 144.936 28.2416L144.932 28.1906C144.885 27.5617 144.676 27.0861 144.305 26.7638C143.939 26.4411 143.409 26.306 142.717 26.3584C141.998 26.4128 141.447 26.6127 141.063 26.9581C140.679 27.3034 140.418 27.6608 140.279 28.0303L138.813 27.6286C139.023 27.0144 139.327 26.5255 139.727 26.1618C140.131 25.7936 140.581 25.5245 141.076 25.3545C141.576 25.1799 142.072 25.0739 142.565 25.0366C142.88 25.0127 143.244 25.0236 143.657 25.0692C144.075 25.1102 144.484 25.231 144.883 25.4314C145.288 25.6316 145.635 25.9536 145.925 26.3975C146.215 26.8413 146.389 27.452 146.448 28.2296L146.937 34.6799L145.433 34.7939L145.332 33.4681L145.256 33.4739C145.17 33.6941 145.017 33.9343 144.797 34.1945C144.578 34.4548 144.277 34.6848 143.895 34.8847C143.512 35.0846 143.036 35.2062 142.467 35.2493ZM142.594 33.8807C143.189 33.8356 143.681 33.6808 144.072 33.4162C144.466 33.1512 144.754 32.826 144.934 32.4406C145.118 32.0548 145.195 31.658 145.164 31.25L145.06 29.8733C145.002 29.9546 144.867 30.0353 144.655 30.1155C144.447 30.1911 144.205 30.2629 143.928 30.3309C143.655 30.3943 143.388 30.453 143.127 30.5069C142.87 30.5563 142.662 30.5977 142.502 30.6312C142.115 30.7118 141.756 30.8223 141.424 30.9628C141.097 31.0987 140.838 31.2872 140.647 31.5282C140.459 31.7646 140.38 32.074 140.409 32.4564C140.449 32.9791 140.672 33.3596 141.079 33.598C141.49 33.8318 141.995 33.9261 142.594 33.8807ZM149.144 34.5127L148.402 24.7226L149.855 24.6125L149.967 26.0912L150.069 26.0835C150.211 25.5855 150.504 25.168 150.949 24.8309C151.393 24.4938 151.909 24.3031 152.495 24.2586C152.606 24.2503 152.744 24.2419 152.91 24.2336C153.076 24.2253 153.202 24.2222 153.287 24.2242L153.403 25.754C153.351 25.7451 153.233 25.7348 153.048 25.7231C152.868 25.7069 152.678 25.7064 152.478 25.7215C152.002 25.7576 151.585 25.8896 151.226 26.1176C150.871 26.3411 150.598 26.6353 150.408 27.0001C150.222 27.3604 150.145 27.7615 150.179 28.2034L150.648 34.3987L149.144 34.5127ZM156.341 28.0442L156.788 33.9336L155.283 34.0476L154.542 24.2574L155.995 24.1473L156.111 25.677L156.238 25.6674C156.43 25.1528 156.748 24.727 157.193 24.3899C157.637 24.0486 158.229 23.8499 158.968 23.7939C159.631 23.7437 160.221 23.8357 160.739 24.07C161.257 24.3 161.674 24.6786 161.992 25.2059C162.309 25.7288 162.5 26.4067 162.563 27.2396L163.034 33.4604L161.53 33.5743L161.066 27.4555C161.008 26.6864 160.763 26.1024 160.331 25.7035C159.899 25.3003 159.334 25.1252 158.637 25.178C158.157 25.2143 157.736 25.3509 157.373 25.5878C157.015 25.8243 156.743 26.1505 156.556 26.5664C156.37 26.9822 156.298 27.4748 156.341 28.0442ZM170.032 36.6226L169.012 23.1612L170.465 23.0511L170.583 24.6063L170.762 24.5928C170.859 24.4144 170.996 24.1861 171.171 23.9079C171.351 23.625 171.617 23.3655 171.971 23.1293C172.329 22.8885 172.827 22.744 173.464 22.6957C174.288 22.6332 175.031 22.7843 175.691 23.1488C176.351 23.5133 176.886 24.0604 177.296 24.7901C177.706 25.5197 177.95 26.3987 178.028 27.427C178.106 28.4638 177.998 29.3758 177.703 30.1632C177.408 30.9462 176.963 31.5696 176.37 32.0334C175.777 32.4929 175.072 32.7535 174.256 32.8153C173.628 32.863 173.116 32.797 172.722 32.6175C172.328 32.4336 172.019 32.2156 171.794 31.9634C171.57 31.7069 171.396 31.4936 171.272 31.3235L171.144 31.3331L171.536 36.5086L170.032 36.6226ZM170.862 27.9442C170.918 28.6836 171.075 29.3276 171.335 29.8763C171.594 30.4208 171.944 30.8366 172.385 31.1238C172.825 31.4067 173.347 31.5252 173.95 31.4795C174.579 31.4319 175.091 31.2264 175.487 30.8631C175.886 30.4952 176.171 30.0207 176.34 29.4394C176.514 28.8536 176.574 28.2123 176.522 27.5154C176.469 26.8271 176.316 26.2147 176.062 25.6784C175.812 25.1376 175.462 24.7217 175.012 24.431C174.567 24.1357 174.025 24.0122 173.388 24.0605C172.776 24.1068 172.274 24.3009 171.881 24.6426C171.488 24.9801 171.206 25.4331 171.035 26.0016C170.864 26.5658 170.806 27.2134 170.862 27.9442ZM181.049 35.788C180.794 35.8073 180.565 35.8032 180.362 35.7759C180.16 35.7528 180.019 35.725 179.939 35.6925L180.221 34.3378C180.594 34.4036 180.919 34.4131 181.198 34.3664C181.476 34.3197 181.715 34.1755 181.915 33.9339C182.119 33.6962 182.294 33.3218 182.439 32.8108L182.661 32.0247L178.296 22.4579L179.927 22.3343L183.221 29.931L183.323 29.9233L185.434 21.9171L187.066 21.7934L183.76 33.3261C183.611 33.8459 183.412 34.282 183.16 34.6344C182.91 34.991 182.608 35.2639 182.255 35.453C181.906 35.6419 181.504 35.7535 181.049 35.788ZM192.771 21.3613L192.867 22.636L187.794 23.0204L187.697 21.7456L192.771 21.3613ZM188.998 19.288L190.502 19.1741L191.209 28.5053C191.241 28.9302 191.327 29.2442 191.467 29.4474C191.61 29.6459 191.782 29.7739 191.983 29.8313C192.188 29.8842 192.401 29.9023 192.622 29.8855C192.787 29.873 192.923 29.8542 193.028 29.8291C193.132 29.7998 193.216 29.7764 193.279 29.7588L193.687 31.0869C193.588 31.1328 193.448 31.1819 193.269 31.234C193.089 31.2903 192.859 31.3291 192.579 31.3503C192.154 31.3825 191.73 31.3227 191.309 31.1709C190.891 31.0188 190.534 30.7659 190.238 30.4122C189.947 30.0583 189.779 29.5966 189.736 29.0272L188.998 19.288ZM196.505 25.0015L196.951 30.8909L195.447 31.0048L194.458 17.9513L195.962 17.8374L196.325 22.6305L196.453 22.6208C196.644 22.0978 196.958 21.6701 197.394 21.3379C197.834 21.0011 198.439 20.8036 199.208 20.7454C199.875 20.6948 200.47 20.7844 200.991 21.0141C201.513 21.2396 201.932 21.6159 202.25 22.1431C202.572 22.6658 202.764 23.3478 202.828 24.1891L203.299 30.4099L201.795 30.5239L201.332 24.4051C201.273 23.6275 201.025 23.0415 200.589 22.6472C200.158 22.2482 199.587 22.0757 198.877 22.1294C198.384 22.1668 197.95 22.3044 197.575 22.5422C197.204 22.7797 196.921 23.1067 196.726 23.5232C196.536 23.9393 196.462 24.4321 196.505 25.0015ZM209.505 30.1449C208.622 30.2119 207.83 30.0603 207.131 29.6901C206.437 29.3197 205.874 28.7705 205.442 28.0424C205.015 27.3141 204.764 26.4442 204.687 25.4329C204.61 24.4131 204.727 23.5089 205.039 22.7203C205.355 21.9314 205.829 21.3015 206.46 20.8306C207.095 20.3594 207.855 20.0903 208.739 20.0233C209.623 19.9564 210.412 20.1081 211.107 20.4786C211.806 20.8487 212.369 21.4001 212.796 22.1327C213.228 22.8649 213.482 23.741 213.559 24.7608C213.636 25.7721 213.516 26.6701 213.199 27.4548C212.887 28.2391 212.413 28.8669 211.778 29.3381C211.147 29.809 210.389 30.0779 209.505 30.1449ZM209.403 28.7937C210.075 28.7428 210.614 28.5289 211.021 28.1518C211.429 27.7748 211.715 27.298 211.881 26.7213C212.047 26.1446 212.105 25.5291 212.055 24.8747C212.005 24.2204 211.855 23.6185 211.604 23.0691C211.353 22.5198 210.998 22.0873 210.538 21.7717C210.078 21.4561 209.512 21.3237 208.841 21.3746C208.17 21.4254 207.631 21.6415 207.223 22.0228C206.816 22.404 206.53 22.8851 206.365 23.466C206.199 24.047 206.142 24.6646 206.191 25.319C206.241 25.9734 206.391 26.5731 206.642 27.1182C206.892 27.6633 207.247 28.0916 207.707 28.4029C208.166 28.7143 208.732 28.8445 209.403 28.7937ZM216.742 23.4684L217.188 29.3577L215.684 29.4717L214.942 19.6816L216.395 19.5715L216.511 21.1012L216.639 21.0915C216.831 20.577 217.149 20.1512 217.593 19.8141C218.038 19.4727 218.629 19.274 219.369 19.218C220.032 19.1678 220.622 19.2598 221.14 19.4941C221.657 19.7242 222.075 20.1028 222.392 20.63C222.71 21.153 222.9 21.8309 222.963 22.6637L223.434 28.8845L221.93 28.9985L221.467 22.8797C221.408 22.1106 221.163 21.5265 220.731 21.1276C220.299 20.7245 219.735 20.5493 219.038 20.6021C218.557 20.6385 218.136 20.7751 217.774 21.012C217.416 21.2485 217.143 21.5747 216.957 21.9905C216.77 22.4064 216.699 22.899 216.742 23.4684ZM227.33 24.8971L227.324 24.8206C227.271 24.0083 227.307 23.356 227.432 22.8636C227.557 22.3712 227.757 21.9651 228.032 21.6451C228.307 21.3251 228.643 21.024 229.041 20.7417C229.28 20.5698 229.491 20.3721 229.675 20.1488C229.859 19.9212 229.997 19.665 230.091 19.3801C230.189 19.0949 230.226 18.7844 230.2 18.4487C230.169 18.0323 230.044 17.6785 229.825 17.3874C229.606 17.0963 229.327 16.8802 228.987 16.7393C228.648 16.5984 228.278 16.543 227.879 16.5733C227.53 16.5997 227.2 16.6974 226.888 16.8663C226.576 17.0352 226.323 17.283 226.13 17.6096C225.937 17.9362 225.842 18.3515 225.846 18.8555L224.24 18.9772C224.219 18.2522 224.359 17.6198 224.66 17.0799C224.966 16.5397 225.388 16.1124 225.929 15.7979C226.473 15.4831 227.09 15.2997 227.778 15.2475C228.526 15.1909 229.187 15.2904 229.762 15.546C230.341 15.8012 230.802 16.1766 231.143 16.6722C231.488 17.1674 231.685 17.7464 231.736 18.4093C231.771 18.8767 231.731 19.305 231.615 19.6941C231.503 20.0829 231.325 20.4362 231.08 20.7539C230.839 21.0713 230.54 21.3589 230.184 21.6167C229.828 21.8787 229.547 22.1479 229.341 22.4241C229.135 22.6961 228.995 23.0124 228.919 23.3728C228.844 23.7332 228.822 24.1771 228.854 24.7047L228.859 24.7812L227.33 24.8971ZM228.431 28.6085C228.117 28.6324 227.839 28.5402 227.596 28.332C227.354 28.1239 227.221 27.8626 227.197 27.5482C227.173 27.2337 227.265 26.9554 227.474 26.7131C227.682 26.4708 227.943 26.3378 228.258 26.314C228.572 26.2902 228.85 26.3823 229.093 26.5905C229.335 26.7986 229.468 27.0599 229.492 27.3743C229.507 27.5825 229.469 27.7778 229.376 27.96C229.287 28.142 229.16 28.2927 228.993 28.4121C228.831 28.527 228.644 28.5924 228.431 28.6085Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_807_359" x1="0" y1="38.7344" x2="248" y2="38.7344" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_807_359" x1="28.7997" y1="28.5871" x2="30.0083" y2="44.5414" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>
<svg width="259" height="77" viewBox="0 0 259 77" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="0.567367" y="37.4877" width="254" height="39" rx="15.5" transform="rotate(-8.35786 0.567367 37.4877)" fill="#F8F1FF"/>
<rect x="0.567367" y="37.4877" width="254" height="39" rx="15.5" transform="rotate(-8.35786 0.567367 37.4877)" stroke="url(#paint0_linear_807_363)"/>
<path d="M36.1659 56.9399L39.6609 59.5395M37.5576 51.3392C38.1662 55.4817 35.3124 59.3314 31.1848 59.9378C27.0561 60.5444 23.2157 57.6782 22.6072 53.5366C21.9983 49.3921 24.8522 45.5434 28.9799 44.937C33.1086 44.3304 36.949 47.1966 37.5576 51.3392Z" stroke="url(#paint1_linear_807_363)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M52.9831 56.5713L51.0803 43.6195L52.6487 43.389L53.496 49.1567L60.402 48.1421L59.5547 42.3744L61.1231 42.144L63.0259 55.0959L61.4575 55.3263L60.6064 49.5334L53.7004 50.548L54.5515 56.3409L52.9831 56.5713ZM69.5317 54.3468C68.5957 54.4843 67.758 54.3964 67.0185 54.0829C66.2826 53.7646 65.6764 53.2593 65.2 52.5669C64.7271 51.8697 64.4176 51.0236 64.2714 50.0286C64.1253 49.0336 64.1777 48.1301 64.4288 47.3179C64.6835 46.5009 65.1063 45.8315 65.6972 45.3096C66.2918 44.783 67.0275 44.4552 67.9045 44.3264C68.4104 44.252 68.9224 44.263 69.4405 44.3591C69.9585 44.4553 70.4478 44.6634 70.9083 44.9834C71.3682 45.2991 71.7638 45.7493 72.0952 46.3337C72.4265 46.9182 72.6588 47.6636 72.792 48.5701L72.8849 49.2025L65.3971 50.3026L65.2075 49.0125L71.1776 48.1354C71.097 47.5873 70.9156 47.1143 70.6331 46.7165C70.3549 46.318 69.9973 46.0239 69.5602 45.8339C69.1274 45.6434 68.6411 45.5878 68.1014 45.6671C67.507 45.7544 67.0143 45.9776 66.6234 46.3365C66.2361 46.6906 65.9609 47.1186 65.7977 47.6207C65.6346 48.1228 65.5924 48.6415 65.671 49.177L65.7974 50.037C65.9052 50.7706 66.123 51.3739 66.4509 51.8469C66.7824 52.3151 67.1954 52.6485 67.6897 52.8472C68.1835 53.0417 68.7318 53.0947 69.3347 53.0061C69.7268 52.9485 70.0729 52.8417 70.373 52.6856C70.6767 52.5247 70.9281 52.3155 71.1272 52.0579C71.3256 51.7962 71.4633 51.4874 71.5402 51.1315L73.0416 51.3244C72.9616 51.8358 72.7698 52.3033 72.4659 52.727C72.1614 53.1464 71.7608 53.4982 71.2642 53.7822C70.7669 54.062 70.1894 54.2502 69.5317 54.3468ZM74.8499 40.1273L76.7527 53.0792L75.2602 53.2985L73.3574 40.3466L74.8499 40.1273ZM79.4873 56.3988L77.525 43.0422L78.9669 42.8303L79.1936 44.3734L79.3706 44.3474C79.4555 44.1627 79.5757 43.9253 79.7312 43.6355C79.8904 43.3407 80.1381 43.0631 80.4746 42.8026C80.8146 42.5373 81.3009 42.3582 81.9333 42.2653C82.7512 42.1451 83.5022 42.2437 84.1863 42.561C84.8703 42.8783 85.4425 43.3865 85.9027 44.0855C86.3629 44.7846 86.6679 45.6442 86.8178 46.6645C86.9689 47.6933 86.925 48.6107 86.6859 49.4168C86.4462 50.2187 86.0469 50.8717 85.4878 51.3759C84.9281 51.876 84.2435 52.1854 83.434 52.3044C82.81 52.396 82.2953 52.3661 81.8897 52.2147C81.4835 52.059 81.1597 51.8632 80.9183 51.6273C80.6763 51.3872 80.4874 51.1867 80.3518 51.0257L80.2253 51.0443L80.9798 56.1795L79.4873 56.3988ZM79.7057 47.6836C79.8135 48.4172 80.0161 49.0486 80.3135 49.5777C80.6103 50.1026 80.9885 50.4929 81.4481 50.7484C81.9071 50.9997 82.436 51.0813 83.0347 50.9934C83.6587 50.9017 84.1552 50.6608 84.5243 50.2706C84.897 49.8756 85.1475 49.3822 85.2759 48.7905C85.4079 48.194 85.4232 47.55 85.3216 46.8585C85.2212 46.1755 85.0254 45.5754 84.7341 45.0583C84.4463 44.5364 84.0681 44.1461 83.5994 43.8877C83.1344 43.6243 82.5856 43.5391 81.9532 43.632C81.3461 43.7212 80.8585 43.9501 80.4906 44.3186C80.122 44.6828 79.8726 45.1545 79.7423 45.7335C79.6114 46.3084 79.5992 46.9584 79.7057 47.6836ZM93.7445 50.5828L92.3174 40.8689L93.7593 40.6571L93.9823 42.1749L94.1088 42.1563C94.235 41.608 94.5026 41.1574 94.9116 40.8044C95.32 40.4472 95.8404 40.2221 96.4728 40.1292C97.1136 40.0351 97.6683 40.1022 98.1369 40.3305C98.6091 40.554 99.0034 40.9074 99.3199 41.3907L99.4211 41.3758C99.5961 40.8376 99.9107 40.3843 100.365 40.0161C100.818 39.6437 101.393 39.4064 102.089 39.3042C102.957 39.1766 103.708 39.3441 104.34 39.8069C104.971 40.2654 105.371 41.0659 105.539 42.2085L106.494 48.7097L105.002 48.929L104.046 42.4278C103.941 41.711 103.67 41.2276 103.232 40.9774C102.795 40.7272 102.311 40.6412 101.78 40.7192C101.097 40.8196 100.598 41.1039 100.283 41.5722C99.9682 42.0363 99.8568 42.5824 99.9491 43.2106L100.878 49.5348L99.3604 49.7578L98.383 43.1048C98.3018 42.5525 98.0573 42.134 97.6494 41.8493C97.2408 41.5605 96.7541 41.4576 96.1891 41.5406C95.8012 41.5976 95.4538 41.7541 95.1469 42.0103C94.8442 42.2658 94.6165 42.5921 94.4638 42.9893C94.3147 43.3816 94.2751 43.816 94.3451 44.2924L95.237 50.3636L93.7445 50.5828ZM112.791 47.9913C111.855 48.1288 111.017 48.0409 110.278 47.7274C109.542 47.4091 108.936 46.9038 108.459 46.2114C107.987 45.5142 107.677 44.6681 107.531 43.6731C107.385 42.6781 107.437 41.7746 107.688 40.9624C107.943 40.1454 108.366 39.476 108.957 38.9541C109.551 38.4275 110.287 38.0997 111.164 37.9709C111.67 37.8965 112.182 37.9075 112.7 38.0036C113.218 38.0998 113.707 38.3079 114.168 38.6279C114.628 38.9436 115.023 39.3938 115.355 39.9782C115.686 40.5627 115.918 41.3081 116.051 42.2146L116.144 42.847L108.657 43.9471L108.467 42.657L114.437 41.7799C114.356 41.2318 114.175 40.7588 113.893 40.361C113.614 39.9625 113.257 39.6684 112.82 39.4785C112.387 39.2879 111.901 39.2323 111.361 39.3116C110.766 39.3989 110.274 39.6221 109.883 39.981C109.496 40.3351 109.22 40.7632 109.057 41.2652C108.894 41.7673 108.852 42.286 108.93 42.8215L109.057 43.6815C109.165 44.4151 109.382 45.0184 109.71 45.4914C110.042 45.9596 110.455 46.293 110.949 46.4917C111.443 46.6862 111.991 46.7392 112.594 46.6506C112.986 46.593 113.332 46.4862 113.632 46.3301C113.936 46.1692 114.188 45.96 114.387 45.7024C114.585 45.4407 114.723 45.1319 114.8 44.776L116.301 44.9689C116.221 45.4803 116.029 45.9478 115.725 46.3715C115.421 46.7909 115.02 47.1427 114.524 47.4267C114.026 47.7065 113.449 47.8947 112.791 47.9913ZM122.584 33.1145L124.487 46.0663L122.994 46.2856L121.091 33.3337L122.584 33.1145ZM130.789 45.3472C129.853 45.4848 129.015 45.3968 128.275 45.0833C127.539 44.765 126.933 44.2597 126.457 43.5674C125.984 42.8702 125.674 42.0241 125.528 41.0291C125.382 40.0341 125.435 39.1305 125.686 38.3183C125.94 37.5013 126.363 36.8319 126.954 36.31C127.549 35.7834 128.284 35.4556 129.161 35.3268C129.667 35.2524 130.179 35.2634 130.697 35.3595C131.215 35.4557 131.705 35.6638 132.165 35.9838C132.625 36.2996 133.021 36.7497 133.352 37.3341C133.683 37.9186 133.916 38.664 134.049 39.5705L134.142 40.2029L126.654 41.303L126.464 40.0129L132.434 39.1358C132.354 38.5877 132.172 38.1147 131.89 37.7169C131.612 37.3184 131.254 37.0243 130.817 36.8344C130.384 36.6438 129.898 36.5882 129.358 36.6675C128.764 36.7548 128.271 36.978 127.88 37.3369C127.493 37.691 127.218 38.1191 127.055 38.6211C126.891 39.1232 126.849 39.6419 126.928 40.1774L127.054 41.0375C127.162 41.7711 127.38 42.3743 127.708 42.8473C128.039 43.3155 128.452 43.6489 128.947 43.8476C129.44 44.0421 129.989 44.0951 130.592 44.0065C130.984 43.9489 131.33 43.8421 131.63 43.686C131.934 43.5251 132.185 43.3159 132.384 43.0584C132.582 42.7966 132.72 42.4878 132.797 42.1319L134.298 42.3248C134.218 42.8362 134.027 43.3037 133.723 43.7274C133.418 44.1469 133.018 44.4986 132.521 44.7826C132.024 45.0624 131.446 45.2506 130.789 45.3472ZM139.409 44.1066C138.793 44.197 138.218 44.1632 137.682 44.005C137.146 43.8426 136.697 43.5617 136.337 43.1624C135.976 42.7588 135.75 42.2409 135.657 41.6085C135.575 41.0519 135.618 40.5847 135.787 40.2068C135.954 39.8246 136.207 39.5075 136.545 39.2555C136.883 39.0034 137.266 38.7964 137.694 38.6344C138.126 38.4676 138.563 38.3215 139.006 38.1962C139.585 38.0336 140.055 37.9063 140.416 37.8145C140.781 37.7178 141.041 37.6086 141.195 37.4869C141.354 37.3645 141.415 37.1832 141.38 36.9429L141.373 36.8923C141.281 36.2683 141.039 35.8085 140.647 35.513C140.259 35.2168 139.721 35.1192 139.034 35.2202C138.321 35.3248 137.786 35.5629 137.427 35.9344C137.068 36.3058 136.832 36.6807 136.72 37.059L135.229 36.7612C135.395 36.1338 135.665 35.6247 136.038 35.2339C136.415 34.8383 136.845 34.5382 137.327 34.3338C137.813 34.1246 138.301 33.984 138.79 33.9122C139.102 33.8663 139.466 33.8516 139.882 33.8681C140.301 33.8797 140.717 33.9714 141.13 34.1433C141.547 34.3146 141.916 34.6115 142.237 35.0339C142.557 35.4563 142.774 36.0532 142.888 36.8248L143.828 43.2248L142.335 43.4441L142.142 42.1287L142.066 42.1398C141.996 42.3655 141.86 42.6158 141.66 42.8908C141.459 43.1658 141.175 43.4165 140.807 43.6427C140.44 43.869 139.974 44.0236 139.409 44.1066ZM139.44 42.7324C140.03 42.6457 140.51 42.4567 140.881 42.1653C141.256 41.8734 141.52 41.5288 141.673 41.1316C141.829 40.7339 141.878 40.3326 141.819 39.9279L141.618 38.5618C141.566 38.647 141.437 38.737 141.231 38.8319C141.029 38.9219 140.792 39.0105 140.521 39.0977C140.253 39.1802 139.991 39.2575 139.734 39.3296C139.482 39.3969 139.277 39.4528 139.119 39.4975C138.739 39.605 138.389 39.7405 138.068 39.9039C137.751 40.0625 137.506 40.2686 137.332 40.5224C137.162 40.7714 137.105 41.0856 137.16 41.4651C137.236 41.9837 137.486 42.3476 137.909 42.5568C138.335 42.7612 138.845 42.8198 139.44 42.7324ZM146.018 42.9031L144.591 33.1892L146.032 32.9774L146.248 34.4446L146.349 34.4297C146.456 33.923 146.719 33.486 147.139 33.1185C147.558 32.751 148.059 32.5245 148.641 32.4391C148.751 32.423 148.888 32.4049 149.053 32.385C149.218 32.3651 149.343 32.3531 149.429 32.3491L149.652 33.8669C149.599 33.8617 149.481 33.8598 149.296 33.8611C149.114 33.8576 148.924 33.8704 148.726 33.8996C148.254 33.9689 147.847 34.1299 147.505 34.3826C147.167 34.6304 146.916 34.943 146.751 35.3203C146.591 35.6928 146.543 36.0983 146.607 36.5367L147.51 42.6838L146.018 42.9031ZM152.744 35.9453L153.602 41.7888L152.11 42.0081L150.682 32.2942L152.124 32.0824L152.347 33.6002L152.474 33.5816C152.629 33.0548 152.916 32.6077 153.336 32.2403C153.755 31.8686 154.332 31.6288 155.065 31.5211C155.723 31.4244 156.318 31.4748 156.851 31.6722C157.384 31.8653 157.827 32.2137 158.181 32.7173C158.534 33.2167 158.771 33.8796 158.893 34.7059L159.8 40.8783L158.307 41.0976L157.415 35.0264C157.303 34.2633 157.018 33.6979 156.559 33.3303C156.099 32.9585 155.524 32.8234 154.832 32.925C154.356 32.9949 153.945 33.1608 153.6 33.4225C153.26 33.6836 153.011 34.0281 152.854 34.456C152.697 34.8839 152.661 35.3804 152.744 35.9453ZM167.201 39.791L165.557 40.0325L168.409 26.382L170.028 26.1441L176.687 38.3973L175.043 38.6389L169.571 28.3046L169.469 28.3195L167.201 39.791ZM167.065 34.6424L173.692 33.6687L173.897 35.06L167.269 36.0338L167.065 34.6424ZM177.968 38.2091L176.541 28.4952L177.983 28.2834L178.198 29.7506L178.299 29.7357C178.406 29.2291 178.669 28.792 179.089 28.4245C179.509 28.057 180.009 27.8306 180.591 27.7451C180.701 27.729 180.838 27.711 181.003 27.691C181.168 27.6711 181.293 27.6591 181.379 27.6552L181.602 29.173C181.55 29.1678 181.431 29.1658 181.246 29.1672C181.064 29.1637 180.875 29.1765 180.676 29.2056C180.204 29.2749 179.797 29.436 179.455 29.6886C179.117 29.9365 178.866 30.249 178.702 30.6263C178.541 30.9988 178.493 31.4043 178.557 31.8428L179.46 37.9899L177.968 38.2091ZM187.462 37.0211C186.652 37.14 185.908 37.0405 185.228 36.7226C184.547 36.4005 183.977 35.8899 183.517 35.1908C183.056 34.4875 182.75 33.6215 182.599 32.5928C182.449 31.5725 182.494 30.6614 182.734 29.8595C182.973 29.0577 183.375 28.4064 183.939 27.9058C184.503 27.4051 185.194 27.0947 186.012 26.9746C186.644 26.8817 187.159 26.9137 187.557 27.0706C187.958 27.2227 188.275 27.4173 188.508 27.6544C188.745 27.8867 188.93 28.0791 189.065 28.2316L189.191 28.213L188.489 23.432L189.981 23.2127L191.884 36.1646L190.442 36.3764L190.223 34.8839L190.046 34.9099C189.962 35.1031 189.839 35.3495 189.676 35.649C189.513 35.9444 189.259 36.225 188.915 36.491C188.57 36.7527 188.086 36.9294 187.462 37.0211ZM187.467 35.6506C188.066 35.5626 188.549 35.3323 188.916 34.9596C189.283 34.5827 189.533 34.1002 189.666 33.5121C189.799 32.9198 189.811 32.2568 189.703 31.5232C189.597 30.798 189.398 30.179 189.108 29.6661C188.816 29.1489 188.442 28.769 187.984 28.5261C187.526 28.279 186.993 28.2001 186.386 28.2893C185.753 28.3822 185.25 28.6219 184.876 29.0085C184.506 29.3903 184.256 29.8728 184.126 30.4561C184 31.0345 183.987 31.6652 184.088 32.3482C184.189 33.0397 184.387 33.6524 184.681 34.1864C184.978 34.7155 185.36 35.116 185.826 35.3877C186.296 35.6547 186.843 35.7423 187.467 35.6506ZM199.829 30.9401L198.985 25.1977L200.478 24.9785L201.905 34.6924L200.412 34.9116L200.171 33.2674L200.07 33.2822C199.915 33.809 199.622 34.2805 199.192 34.6968C198.762 35.1089 198.18 35.3689 197.446 35.4767C196.839 35.5659 196.28 35.5123 195.769 35.3161C195.257 35.1156 194.826 34.7654 194.477 34.2654C194.127 33.7612 193.892 33.0959 193.77 32.2695L192.864 26.0971L194.356 25.8779L195.248 31.949C195.352 32.6574 195.633 33.1932 196.091 33.5566C196.554 33.9194 197.095 34.0552 197.715 33.9642C198.086 33.9096 198.449 33.7593 198.805 33.5133C199.165 33.2665 199.447 32.9279 199.651 32.4974C199.859 32.0663 199.918 31.5472 199.829 30.9401ZM204.104 34.3693L202.677 24.6553L204.17 24.4361L205.597 34.15L204.104 34.3693ZM203.198 22.9249C202.907 22.9676 202.642 22.9054 202.402 22.7382C202.166 22.5704 202.028 22.3474 201.987 22.0691C201.946 21.7908 202.015 21.5374 202.192 21.3089C202.374 21.0798 202.61 20.9439 202.901 20.9011C203.192 20.8584 203.455 20.9209 203.691 21.0887C203.931 21.2559 204.071 21.4786 204.112 21.7569C204.153 22.0352 204.083 22.2889 203.901 22.518C203.723 22.7465 203.489 22.8821 203.198 22.9249ZM208.43 27.7641L209.289 33.6076L207.796 33.8269L206.369 24.113L207.811 23.9011L208.034 25.4189L208.16 25.4003C208.316 24.8736 208.603 24.4265 209.023 24.059C209.442 23.6873 210.019 23.4476 210.752 23.3398C211.41 23.2432 212.005 23.2935 212.538 23.4909C213.07 23.684 213.514 24.0324 213.867 24.536C214.221 25.0354 214.458 25.6983 214.58 26.5247L215.486 32.6971L213.994 32.9163L213.102 26.8451C212.99 26.082 212.704 25.5167 212.245 25.1491C211.786 24.7772 211.21 24.6421 210.519 24.7437C210.043 24.8137 209.632 24.9796 209.287 25.2413C208.946 25.5024 208.698 25.8469 208.541 26.2748C208.384 26.7027 208.347 27.1991 208.43 27.7641ZM221.655 31.9975C220.778 32.1263 219.978 32.0307 219.255 31.7105C218.536 31.3897 217.936 30.8814 217.455 30.1854C216.978 29.4888 216.665 28.6388 216.518 27.6354C216.369 26.6235 216.423 25.7133 216.679 24.9047C216.939 24.0956 217.367 23.4339 217.964 22.9199C218.564 22.4053 219.303 22.0835 220.18 21.9547C221.057 21.8259 221.855 21.9218 222.574 22.2426C223.297 22.5627 223.898 23.0732 224.375 23.774C224.857 24.4742 225.173 25.3302 225.321 26.3421C225.469 27.3455 225.412 28.2497 225.151 29.0547C224.895 29.859 224.466 30.5185 223.865 31.0332C223.269 31.5472 222.532 31.8686 221.655 31.9975ZM221.458 30.6567C222.125 30.5589 222.648 30.3076 223.027 29.9029C223.407 29.4982 223.66 29.0025 223.785 28.4156C223.909 27.8287 223.924 27.2106 223.829 26.5613C223.733 25.9121 223.541 25.3222 223.252 24.7918C222.963 24.2614 222.578 23.855 222.097 23.5724C221.617 23.2899 221.043 23.1976 220.377 23.2954C219.711 23.3933 219.188 23.6467 218.809 24.0556C218.43 24.4645 218.178 24.9645 218.054 25.5556C217.929 26.1467 217.915 26.7668 218.01 27.4161C218.106 28.0654 218.298 28.6531 218.586 29.1793C218.874 29.7055 219.259 30.1077 219.739 30.3861C220.219 30.6644 220.792 30.7546 221.458 30.6567ZM233.658 26.306L233.647 26.2301C233.537 25.4235 233.528 24.7703 233.618 24.2704C233.708 23.7704 233.879 23.3512 234.131 23.0127C234.383 22.6742 234.697 22.3502 235.073 22.0408C235.3 21.8525 235.497 21.6404 235.665 21.4047C235.832 21.1648 235.952 20.8995 236.026 20.6087C236.104 20.3173 236.118 20.0051 236.069 19.672C236.008 19.2588 235.859 18.9147 235.62 18.6396C235.382 18.3646 235.088 18.1687 234.739 18.0519C234.391 17.9352 234.018 17.906 233.622 17.9642C233.276 18.015 232.953 18.1356 232.654 18.326C232.355 18.5164 232.12 18.7813 231.95 19.1207C231.78 19.4601 231.715 19.881 231.755 20.3834L230.161 20.6176C230.089 19.8959 230.185 19.2552 230.447 18.6955C230.714 18.1351 231.105 17.6792 231.622 17.3276C232.143 16.9754 232.745 16.7491 233.428 16.6488C234.17 16.5397 234.837 16.5925 235.429 16.8071C236.024 17.0211 236.51 17.3633 236.885 17.8337C237.264 18.3035 237.502 18.8672 237.598 19.5249C237.666 19.9887 237.656 20.4187 237.568 20.815C237.484 21.2107 237.331 21.5756 237.109 21.9097C236.891 22.2433 236.613 22.5511 236.275 22.8333C235.938 23.1197 235.677 23.4079 235.491 23.6979C235.305 23.9837 235.187 24.309 235.137 24.6738C235.087 25.0386 235.097 25.483 235.165 26.0071L235.176 26.083L233.658 26.306ZM235.018 29.9309C234.706 29.9768 234.422 29.9044 234.166 29.7137C233.909 29.5231 233.758 29.2718 233.712 28.9598C233.667 28.6478 233.739 28.3637 233.93 28.1074C234.12 27.8511 234.371 27.7001 234.683 27.6542C234.995 27.6084 235.28 27.6808 235.536 27.8714C235.792 28.062 235.943 28.3133 235.989 28.6253C236.019 28.8319 235.995 29.0294 235.915 29.2177C235.839 29.4055 235.722 29.5647 235.565 29.6955C235.411 29.8215 235.229 29.9 235.018 29.9309Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_807_363" x1="0" y1="57.0657" x2="255" y2="57.0657" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_807_363" x1="29.4202" y1="44.8723" x2="31.7458" y2="60.7024" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>

<svg width="445" height="93" viewBox="0 0 445 93" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="0.555878" y="53.0845" width="442" height="39" rx="15.5" transform="rotate(-6.82535 0.555878 53.0845)" fill="#F8F1FF"/>
<rect x="0.555878" y="53.0845" width="442" height="39" rx="15.5" transform="rotate(-6.82535 0.555878 53.0845)" stroke="url(#paint0_linear_807_343)"/>
<path d="M35.6217 73.4817L39.0459 76.1738M37.1627 67.9202C37.6603 72.0775 34.7046 75.8495 30.5622 76.3453C26.4187 76.8412 22.6564 73.8733 22.1589 69.717C21.661 65.5577 24.6168 61.7867 28.7593 61.2909C32.9027 60.7949 36.6651 63.7628 37.1627 67.9202Z" stroke="url(#paint1_linear_807_343)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M54.8037 73.2806L49.6937 60.7079L51.2931 60.5164L55.2766 70.7777L55.4035 70.7625L56.9036 59.8449L58.6807 59.6322L62.715 69.8874L62.8419 69.8722L64.2912 58.9607L65.8906 58.7692L63.8922 72.1928L62.2674 72.3872L58.1589 62.3727L58.0574 62.3849L56.4284 73.0861L54.8037 73.2806ZM69.4642 65.5775L70.1661 71.4418L68.6682 71.6211L67.1125 58.623L68.6103 58.4437L69.1816 63.2165L69.3085 63.2013C69.4767 62.6704 69.7716 62.2296 70.1931 61.8787C70.6183 61.5231 71.2139 61.2994 71.9797 61.2078C72.644 61.1282 73.2418 61.1919 73.7729 61.3987C74.3036 61.6013 74.7391 61.959 75.0795 62.4719C75.4236 62.9801 75.6457 63.653 75.746 64.4908L76.4874 70.6852L74.9896 70.8645L74.2603 64.7716C74.1677 63.9973 73.895 63.4227 73.4424 63.0477C72.9935 62.6679 72.4158 62.5203 71.7092 62.6049C71.2184 62.6637 70.7907 62.82 70.4263 63.0739C70.0661 63.3273 69.7976 63.6663 69.621 64.0909C69.4486 64.515 69.3963 65.0105 69.4642 65.5775ZM79.7447 74.0035C79.4908 74.0339 79.2619 74.0398 79.058 74.0213C78.8545 74.007 78.7125 73.9854 78.6318 73.9564L78.8545 72.5907C79.2296 72.6403 79.5552 72.6356 79.8314 72.5768C80.1076 72.518 80.3402 72.3635 80.5292 72.1135C80.7228 71.8671 80.881 71.4855 81.0037 70.9687L81.1918 70.1737L76.414 60.8058L78.0387 60.6113L81.6596 68.0576L81.7611 68.0455L83.5223 59.955L85.1471 59.7605L82.346 71.4261C82.2201 71.9518 82.0394 72.3962 81.8039 72.7592C81.5688 73.1263 81.279 73.4121 80.9344 73.6164C80.594 73.8203 80.1974 73.9493 79.7447 74.0035ZM95.9506 68.5617C95.1382 68.6589 94.3965 68.5395 93.7254 68.2035C93.0538 67.8633 92.4973 67.3377 92.056 66.6266C91.6141 65.9112 91.3314 65.0373 91.2079 64.0049C91.0853 62.981 91.1545 62.0714 91.4156 61.2763C91.6766 60.4811 92.0957 59.8408 92.6728 59.3554C93.2499 58.8701 93.9488 58.5782 94.7697 58.48C95.4044 58.404 95.9184 58.4498 96.3118 58.6173C96.709 58.7801 97.0208 58.9831 97.2474 59.2263C97.4776 59.4649 97.6579 59.6622 97.7882 59.8182L97.9151 59.8031L97.3408 55.0049L98.8387 54.8256L100.394 67.8238L98.9474 67.997L98.7681 66.4991L98.5904 66.5204C98.5016 66.7113 98.3719 66.9543 98.2012 67.2494C98.03 67.5403 97.7688 67.814 97.4176 68.0706C97.0658 68.323 96.5768 68.4867 95.9506 68.5617ZM95.9927 67.1918C96.5935 67.1199 97.0825 66.9026 97.4597 66.5399C97.8363 66.1729 98.0991 65.6972 98.2481 65.1129C98.3965 64.5243 98.4267 63.8619 98.3386 63.1257C98.2515 62.3979 98.0695 61.7738 97.7926 61.2533C97.5152 60.7286 97.1509 60.3387 96.6998 60.0837C96.2482 59.8245 95.7177 59.7313 95.1084 59.8042C94.4738 59.8802 93.9644 60.1064 93.5802 60.4828C93.1998 60.8545 92.937 61.3302 92.7918 61.9098C92.6503 62.4847 92.6206 63.1148 92.7027 63.8003C92.7857 64.4942 92.9669 65.112 93.2464 65.6536C93.5295 66.1905 93.9005 66.6011 94.3594 66.8852C94.822 67.1646 95.3665 67.2668 95.9927 67.1918ZM106.794 67.2638C105.914 67.3691 105.117 67.2521 104.402 66.9127C103.692 66.5728 103.106 66.0486 102.643 65.34C102.185 64.6309 101.896 63.7729 101.775 62.7659C101.654 61.7504 101.732 60.8419 102.009 60.0405C102.291 59.2386 102.737 58.5886 103.346 58.0908C103.961 57.5924 104.708 57.2905 105.588 57.1851C106.468 57.0798 107.263 57.1971 107.973 57.537C108.688 57.8763 109.274 58.4027 109.733 59.116C110.196 59.8288 110.488 60.693 110.61 61.7084C110.73 62.7155 110.65 63.6178 110.367 64.4155C110.089 65.2127 109.643 65.8605 109.029 66.3589C108.419 66.8568 107.674 67.1584 106.794 67.2638ZM106.633 65.9183C107.302 65.8383 107.831 65.6011 108.222 65.2067C108.612 64.8123 108.878 64.3234 109.018 63.7401C109.159 63.1568 109.19 62.5393 109.112 61.8877C109.034 61.2361 108.858 60.6414 108.583 60.1034C108.308 59.5655 107.934 59.1489 107.461 58.8536C106.988 58.5583 106.417 58.4506 105.749 58.5307C105.08 58.6107 104.551 58.85 104.161 59.2486C103.771 59.6472 103.506 60.1403 103.366 60.7279C103.226 61.3154 103.195 61.935 103.273 62.5866C103.351 63.2382 103.527 63.8308 103.801 64.3645C104.075 64.8982 104.449 65.3106 104.921 65.6017C105.394 65.8928 105.965 65.9983 106.633 65.9183ZM117.049 66.0364C116.11 66.1488 115.275 66.0384 114.544 65.7053C113.817 65.3675 113.224 64.8461 112.766 64.1413C112.312 63.4317 112.026 62.5776 111.906 61.579C111.787 60.5805 111.863 59.6786 112.136 58.8735C112.412 58.0636 112.853 57.4057 113.458 56.8998C114.066 56.3893 114.81 56.0813 115.69 55.976C116.198 55.9152 116.71 55.9398 117.225 56.0498C117.74 56.1598 118.224 56.3809 118.676 56.7131C119.127 57.041 119.51 57.5016 119.826 58.0947C120.142 58.6878 120.354 59.4392 120.463 60.3489L120.539 60.9836L113.024 61.883L112.869 60.5883L118.86 59.8711C118.795 59.3211 118.626 58.8434 118.354 58.4382C118.087 58.0324 117.737 57.7288 117.305 57.5273C116.878 57.3253 116.393 57.2566 115.851 57.3215C115.255 57.3929 114.756 57.6028 114.356 57.9511C113.959 58.2947 113.673 58.7153 113.496 59.2128C113.32 59.7103 113.264 60.2277 113.328 60.7651L113.431 61.6282C113.519 62.3645 113.721 62.9734 114.036 63.4549C114.355 63.9318 114.759 64.2762 115.248 64.488C115.736 64.6957 116.283 64.7633 116.888 64.6908C117.281 64.6438 117.63 64.5462 117.934 64.3982C118.242 64.2455 118.499 64.0431 118.705 63.791C118.911 63.5346 119.056 63.2296 119.143 62.8759L120.639 63.1089C120.545 63.618 120.341 64.0802 120.026 64.4956C119.71 64.9067 119.3 65.2476 118.796 65.5183C118.291 65.7847 117.709 65.9574 117.049 66.0364ZM128.803 56.7498L127.503 57.2916C127.392 57.0775 127.241 56.8745 127.051 56.6827C126.864 56.4862 126.623 56.3348 126.327 56.2286C126.031 56.1224 125.665 56.0954 125.229 56.1475C124.633 56.2189 124.152 56.416 123.787 56.7386C123.426 57.0565 123.27 57.4249 123.321 57.8438C123.365 58.2161 123.536 58.494 123.832 58.6773C124.129 58.8607 124.574 58.9899 125.166 59.0649L126.656 59.2471C127.553 59.3543 128.241 59.6003 128.721 59.9849C129.2 60.3654 129.48 60.8962 129.561 61.5774C129.628 62.1359 129.527 62.6544 129.258 63.133C128.994 63.611 128.591 64.0111 128.05 64.3334C127.509 64.6556 126.86 64.862 126.103 64.9527C125.108 65.0717 124.26 64.9544 123.556 64.6008C122.853 64.2472 122.365 63.6662 122.092 62.8576L123.472 62.3321C123.67 62.8405 123.973 63.2034 124.381 63.4206C124.793 63.6374 125.306 63.709 125.919 63.6356C126.618 63.5521 127.154 63.3376 127.529 62.9923C127.908 62.6423 128.072 62.2578 128.022 61.8389C127.981 61.5004 127.829 61.2311 127.565 61.031C127.3 60.8266 126.915 60.6967 126.411 60.6412L124.74 60.4549C123.822 60.3502 123.127 60.1008 122.655 59.7066C122.187 59.3078 121.912 58.772 121.832 58.0992C121.766 57.5491 121.862 57.0441 122.12 56.584C122.383 56.1234 122.768 55.7404 123.277 55.4349C123.79 55.1289 124.389 54.9348 125.074 54.8528C126.039 54.7373 126.822 54.8582 127.422 55.2155C128.027 55.5723 128.488 56.0837 128.803 56.7498ZM132.401 58.0445L133.103 63.9088L131.605 64.0881L130.438 54.3395L131.885 54.1663L132.068 55.6895L132.195 55.6743C132.364 55.152 132.663 54.7127 133.093 54.3566C133.522 53.9962 134.104 53.772 134.84 53.6839C135.5 53.6049 136.094 53.6711 136.622 53.8827C137.149 54.09 137.582 54.4501 137.923 54.963C138.262 55.4717 138.482 56.1407 138.581 56.97L139.323 63.1644L137.825 63.3437L137.096 57.2508C137.004 56.4849 136.734 55.9122 136.285 55.5324C135.835 55.1484 135.264 54.998 134.57 55.081C134.092 55.1383 133.677 55.2931 133.325 55.5455C132.977 55.7974 132.72 56.1351 132.551 56.5587C132.383 56.9822 132.333 57.4775 132.401 58.0445ZM141.263 49.7479L141.797 54.216L140.401 54.3831L139.866 49.915L141.263 49.7479ZM148.022 52.2349L148.174 53.5042L143.122 54.1089L142.97 52.8396L148.022 52.2349ZM144.163 50.3277L145.661 50.1484L146.773 59.4401C146.824 59.8632 146.923 60.1732 147.071 60.3701C147.223 60.5622 147.4 60.6826 147.603 60.7312C147.81 60.7751 148.024 60.7839 148.244 60.7576C148.409 60.7378 148.543 60.7131 148.647 60.6835C148.75 60.6497 148.833 60.6227 148.895 60.6024L149.361 61.9114C149.264 61.9617 149.126 62.0167 148.949 62.0766C148.772 62.1407 148.544 62.1894 148.265 62.2228C147.842 62.2735 147.416 62.2321 146.988 62.0988C146.564 61.965 146.197 61.7279 145.886 61.3874C145.579 61.0465 145.392 60.5925 145.324 60.0255L144.163 50.3277ZM161.396 52.8487L160.096 53.3905C159.985 53.1764 159.834 52.9734 159.643 52.7816C159.457 52.5851 159.216 52.4337 158.92 52.3275C158.624 52.2213 158.258 52.1943 157.822 52.2465C157.225 52.3179 156.745 52.5149 156.38 52.8375C156.019 53.1554 155.863 53.5238 155.913 53.9427C155.958 54.315 156.129 54.5929 156.425 54.7763C156.722 54.9596 157.166 55.0888 157.759 55.1638L159.249 55.346C160.146 55.4533 160.834 55.6992 161.313 56.0839C161.792 56.4643 162.073 56.9951 162.154 57.6763C162.221 58.2348 162.12 58.7534 161.851 59.2319C161.586 59.7099 161.184 60.11 160.643 60.4323C160.102 60.7545 159.453 60.961 158.696 61.0516C157.701 61.1706 156.852 61.0533 156.149 60.6998C155.446 60.3462 154.958 59.7651 154.685 58.9566L156.064 58.431C156.263 58.9394 156.566 59.3023 156.974 59.5196C157.386 59.7363 157.899 59.808 158.512 59.7345C159.21 59.651 159.747 59.4365 160.122 59.0912C160.501 58.7412 160.665 58.3567 160.615 57.9378C160.574 57.5994 160.422 57.33 160.157 57.1299C159.893 56.9256 159.508 56.7956 159.004 56.7401L157.333 56.5538C156.415 56.4491 155.72 56.1997 155.248 55.8056C154.78 55.4067 154.505 54.8709 154.425 54.1981C154.359 53.6481 154.455 53.143 154.713 52.6829C154.976 52.2223 155.361 51.8393 155.87 51.5338C156.382 51.2278 156.981 51.0338 157.667 50.9517C158.632 50.8363 159.414 50.9572 160.015 51.3144C160.62 51.6712 161.08 52.1826 161.396 52.8487ZM169.864 55.4659L169.175 49.7031L170.672 49.5238L171.839 59.2724L170.341 59.4517L170.144 57.8015L170.042 57.8137C169.873 58.3361 169.568 58.7996 169.127 59.2043C168.686 59.6048 168.097 59.8491 167.361 59.9372C166.752 60.0101 166.194 59.9417 165.688 59.7318C165.182 59.5177 164.761 59.1561 164.425 58.6469C164.089 58.1335 163.872 57.4622 163.772 56.6329L163.031 50.4384L164.529 50.2592L165.258 56.352C165.343 57.0629 165.61 57.606 166.058 57.9816C166.511 58.3566 167.048 58.5068 167.67 58.4324C168.042 58.3878 168.41 58.2473 168.772 58.0108C169.138 57.7738 169.429 57.4429 169.645 57.018C169.864 56.5926 169.937 56.0752 169.864 55.4659ZM174.484 62.664L172.88 49.2596L174.327 49.0864L174.512 50.635L174.69 50.6138C174.78 50.4314 174.906 50.1973 175.069 49.9117C175.236 49.6213 175.491 49.3505 175.835 49.0991C176.182 48.843 176.673 48.6769 177.307 48.6009C178.128 48.5027 178.876 48.6213 179.551 48.9568C180.227 49.2923 180.785 49.8155 181.226 50.5267C181.668 51.2378 181.95 52.1053 182.072 53.1292C182.196 54.1616 182.127 55.0775 181.867 55.877C181.606 56.6721 181.189 57.3143 180.617 57.8034C180.044 58.2883 179.351 58.5793 178.539 58.6765C177.913 58.7515 177.399 58.7078 176.998 58.5456C176.596 58.3791 176.277 58.1747 176.042 57.9325C175.807 57.686 175.623 57.4805 175.492 57.3159L175.365 57.3311L175.982 62.4847L174.484 62.664ZM174.936 53.9577C175.024 54.6939 175.209 55.3305 175.492 55.8674C175.775 56.4001 176.143 56.8003 176.595 57.068C177.047 57.3315 177.574 57.4273 178.175 57.3553C178.801 57.2804 179.304 57.0528 179.683 56.6727C180.066 56.2878 180.33 55.8013 180.474 55.2132C180.622 54.6204 180.654 53.977 180.571 53.2831C180.489 52.5977 180.31 51.9926 180.032 51.4679C179.759 50.9384 179.391 50.5382 178.929 50.2673C178.471 49.9916 177.925 49.8918 177.291 49.9677C176.681 50.0407 176.188 50.2564 175.81 50.6149C175.432 50.9691 175.17 51.434 175.024 52.0093C174.878 52.5805 174.848 53.2299 174.936 53.9577ZM188.513 57.4827C187.574 57.5952 186.739 57.4848 186.008 57.1517C185.281 56.8138 184.688 56.2925 184.23 55.5876C183.776 54.878 183.49 54.024 183.37 53.0254C183.251 52.0269 183.327 51.125 183.6 50.3198C183.876 49.5099 184.317 48.8521 184.922 48.3462C185.53 47.8356 186.274 47.5277 187.154 47.4223C187.662 47.3616 188.174 47.3862 188.689 47.4962C189.204 47.6062 189.688 47.8272 190.139 48.1594C190.591 48.4874 190.974 48.9479 191.29 49.541C191.605 50.1342 191.818 50.8856 191.927 51.7953L192.003 52.4299L184.488 53.3294L184.333 52.0346L190.324 51.3175C190.258 50.7675 190.09 50.2898 189.818 49.8846C189.551 49.4788 189.201 49.1752 188.769 48.9737C188.342 48.7716 187.857 48.703 187.315 48.7678C186.719 48.8392 186.22 49.0491 185.82 49.3975C185.423 49.7411 185.137 50.1616 184.96 50.6591C184.784 51.1567 184.728 51.6741 184.792 52.2115L184.895 53.0746C184.983 53.8108 185.185 54.4197 185.5 54.9013C185.819 55.3782 186.223 55.7225 186.712 55.9344C187.2 56.142 187.747 56.2096 188.352 56.1372C188.745 56.0901 189.094 55.9926 189.398 55.8446C189.706 55.6919 189.963 55.4894 190.169 55.2373C190.374 54.981 190.52 54.676 190.607 54.3223L192.102 54.5553C192.009 55.0643 191.804 55.5266 191.489 55.9419C191.174 56.3531 190.764 56.694 190.26 56.9646C189.755 57.231 189.173 57.4037 188.513 57.4827ZM194.267 56.588L193.101 46.8394L194.548 46.6662L194.724 48.1386L194.825 48.1264C194.945 47.6228 195.22 47.193 195.65 46.8368C196.079 46.4807 196.586 46.2677 197.17 46.1978C197.28 46.1847 197.417 46.1703 197.583 46.1548C197.749 46.1393 197.874 46.1307 197.96 46.129L198.142 47.6522C198.09 47.6456 197.971 47.6405 197.786 47.6369C197.605 47.6285 197.415 47.6363 197.216 47.6601C196.742 47.7168 196.331 47.8669 195.982 48.1103C195.638 48.349 195.378 48.6547 195.204 49.0275C195.033 49.3956 194.974 49.7996 195.027 50.2396L195.765 56.4087L194.267 56.588ZM204.069 55.6208C203.155 55.7302 202.342 55.6086 201.631 55.256C200.919 54.9034 200.34 54.3697 199.894 53.6549C199.448 52.9401 199.167 52.0961 199.05 51.1229C198.932 50.1328 199.009 49.2373 199.282 48.4364C199.559 47.6307 200 46.9749 200.605 46.4691C201.213 45.9585 201.957 45.6505 202.837 45.5452C203.523 45.4632 204.156 45.5162 204.736 45.7042C205.317 45.8922 205.81 46.1937 206.216 46.6086C206.622 47.0236 206.903 47.5306 207.061 48.1298L205.563 48.3091C205.396 47.8785 205.095 47.5153 204.66 47.2197C204.229 46.9194 203.684 46.8087 203.024 46.8877C202.44 46.9576 201.946 47.1712 201.543 47.5285C201.143 47.8811 200.853 48.3471 200.673 48.9265C200.498 49.5012 200.454 50.1566 200.542 50.8928C200.632 51.646 200.829 52.2876 201.133 52.8178C201.441 53.3474 201.831 53.7406 202.304 53.9973C202.781 54.2535 203.316 54.3462 203.908 54.2753C204.297 54.2287 204.642 54.1187 204.944 53.9453C205.245 53.7719 205.49 53.5452 205.68 53.265C205.869 52.9847 205.989 52.6614 206.04 52.2948L207.538 52.1155C207.522 52.7011 207.375 53.2445 207.096 53.7457C206.82 54.2422 206.426 54.6584 205.913 54.9946C205.403 55.326 204.788 55.5347 204.069 55.6208ZM213.516 54.49C212.636 54.5954 211.839 54.4784 211.125 54.139C210.414 53.7991 209.828 53.2749 209.366 52.5663C208.907 51.8572 208.618 50.9992 208.497 49.9921C208.376 48.9767 208.454 48.0682 208.731 47.2668C209.013 46.4648 209.459 45.8149 210.069 45.317C210.683 44.8186 211.43 44.5167 212.31 44.4114C213.19 44.3061 213.985 44.4233 214.695 44.7632C215.41 45.1026 215.996 45.6289 216.455 46.3423C216.918 47.0551 217.21 47.9192 217.332 48.9347C217.453 49.9417 217.372 50.8441 217.09 51.6418C216.812 52.439 216.365 53.0868 215.751 53.5852C215.141 54.0831 214.396 54.3847 213.516 54.49ZM213.355 53.1445C214.024 53.0645 214.553 52.8273 214.944 52.4329C215.334 52.0386 215.6 51.5497 215.74 50.9664C215.881 50.383 215.912 49.7656 215.834 49.114C215.756 48.4624 215.58 47.8676 215.305 47.3297C215.03 46.7918 214.657 46.3751 214.183 46.0798C213.71 45.7845 213.14 45.6769 212.471 45.7569C211.803 45.8369 211.273 46.0762 210.883 46.4749C210.493 46.8735 210.228 47.3666 210.088 47.9541C209.948 48.5417 209.917 49.1613 209.995 49.8129C210.073 50.4645 210.249 51.0571 210.523 51.5908C210.798 52.1245 211.171 52.5369 211.644 52.828C212.116 53.119 212.687 53.2245 213.355 53.1445ZM220.456 47.5051L221.157 53.3695L219.66 53.5487L218.493 43.8001L219.94 43.6269L220.122 45.1502L220.249 45.135C220.418 44.6126 220.718 44.1733 221.147 43.8172C221.576 43.4568 222.159 43.2326 222.895 43.1445C223.555 43.0655 224.149 43.1317 224.676 43.3433C225.203 43.5506 225.637 43.9107 225.977 44.4236C226.317 44.9323 226.537 45.6013 226.636 46.4306L227.377 52.625L225.879 52.8043L225.15 46.7114C225.058 45.9456 224.788 45.3728 224.339 44.993C223.89 44.6091 223.318 44.4586 222.624 44.5416C222.146 44.5989 221.731 44.7537 221.38 45.0061C221.032 45.258 220.774 45.5957 220.606 46.0193C220.438 46.4428 220.388 46.9381 220.456 47.5051ZM233.284 52.1241C232.471 52.2213 231.729 52.1019 231.058 51.766C230.387 51.4258 229.83 50.9001 229.389 50.189C228.947 49.4736 228.664 48.5998 228.541 47.5674C228.418 46.5434 228.487 45.6339 228.748 44.8387C229.01 44.0435 229.429 43.4032 230.006 42.9178C230.583 42.4325 231.282 42.1407 232.103 42.0424C232.737 41.9664 233.251 42.0122 233.645 42.1797C234.042 42.3425 234.354 42.5455 234.58 42.7887C234.811 43.0273 234.991 43.2246 235.121 43.3807L235.248 43.3655L234.674 38.5673L236.172 38.388L237.727 51.3862L236.28 51.5594L236.101 50.0616L235.923 50.0828C235.835 50.2737 235.705 50.5167 235.534 50.8118C235.363 51.1027 235.102 51.3764 234.75 51.633C234.399 51.8854 233.91 52.0491 233.284 52.1241ZM233.326 50.7543C233.926 50.6823 234.415 50.465 234.793 50.1023C235.169 49.7353 235.432 49.2597 235.581 48.6753C235.729 48.0867 235.76 47.4243 235.671 46.6881C235.584 45.9604 235.402 45.3362 235.125 44.8157C234.848 44.291 234.484 43.9011 234.033 43.6461C233.581 43.3869 233.051 43.2937 232.441 43.3666C231.807 43.4426 231.297 43.6688 230.913 44.0453C230.533 44.417 230.27 44.8926 230.125 45.4722C229.983 46.0471 229.954 46.6772 230.036 47.3627C230.119 48.0566 230.3 48.6744 230.579 49.216C230.862 49.753 231.233 50.1635 231.692 50.4476C232.155 50.727 232.699 50.8292 233.326 50.7543ZM245.809 46.376L245.119 40.6132L246.617 40.4339L247.784 50.1825L246.286 50.3618L246.089 48.7116L245.987 48.7238C245.818 49.2462 245.513 49.7097 245.072 50.1144C244.631 50.5149 244.042 50.7591 243.306 50.8473C242.696 50.9202 242.139 50.8517 241.633 50.6419C241.127 50.4278 240.706 50.0662 240.37 49.557C240.034 49.0436 239.816 48.3722 239.717 47.5429L238.976 41.3485L240.473 41.1692L241.203 47.2621C241.288 47.973 241.554 48.5161 242.003 48.8916C242.455 49.2666 242.993 49.4169 243.615 49.3425C243.987 49.2979 244.354 49.1574 244.717 48.9209C245.083 48.6839 245.374 48.353 245.589 47.9281C245.809 47.5027 245.882 46.9853 245.809 46.376ZM253.976 49.6474C253.062 49.7568 252.249 49.6352 251.537 49.2826C250.826 48.93 250.247 48.3963 249.801 47.6815C249.355 46.9667 249.073 46.1227 248.957 45.1495C248.838 44.1594 248.916 43.2639 249.189 42.4629C249.466 41.6573 249.907 41.0015 250.511 40.4957C251.12 39.9851 251.864 39.6771 252.744 39.5718C253.429 39.4898 254.062 39.5427 254.643 39.7308C255.223 39.9188 255.716 40.2203 256.122 40.6352C256.528 41.0502 256.81 41.5572 256.967 42.1564L255.47 42.3356C255.302 41.905 255.001 41.5419 254.567 41.2463C254.136 40.9459 253.591 40.8353 252.93 40.9143C252.347 40.9842 251.853 41.1978 251.449 41.5551C251.049 41.9076 250.76 42.3736 250.58 42.9531C250.404 43.5278 250.36 44.1832 250.449 44.9194C250.539 45.6726 250.736 46.3142 251.039 46.8444C251.347 47.374 251.738 47.7672 252.211 48.0239C252.688 48.2801 253.222 48.3728 253.815 48.3019C254.204 48.2553 254.549 48.1453 254.85 47.9719C255.151 47.7985 255.397 47.5717 255.586 47.2915C255.776 47.0113 255.896 46.688 255.947 46.3214L257.445 46.1421C257.429 46.7277 257.281 47.2711 257.002 47.7723C256.727 48.2687 256.333 48.685 255.819 49.0212C255.31 49.3526 254.695 49.5613 253.976 49.6474ZM262.511 38.5315L262.663 39.8009L257.611 40.4055L257.459 39.1362L262.511 38.5315ZM258.652 36.6243L260.15 36.4451L261.262 45.7367C261.313 46.1598 261.412 46.4698 261.56 46.6667C261.712 46.8588 261.889 46.9792 262.092 47.0278C262.299 47.0717 262.513 47.0805 262.733 47.0542C262.898 47.0344 263.032 47.0098 263.136 46.9802C263.239 46.9464 263.322 46.9193 263.384 46.899L263.85 48.2081C263.753 48.2583 263.615 48.3133 263.438 48.3732C263.261 48.4373 263.033 48.486 262.754 48.5195C262.331 48.5701 261.905 48.5288 261.477 48.3955C261.053 48.2616 260.686 48.0245 260.375 47.6841C260.068 47.3431 259.881 46.8892 259.813 46.3222L258.652 36.6243ZM269.275 47.8162C268.395 47.9216 267.597 47.8045 266.883 47.4652C266.173 47.1253 265.587 46.601 265.124 45.8925C264.666 45.1834 264.376 44.3253 264.256 43.3183C264.134 42.3028 264.212 41.3944 264.49 40.5929C264.771 39.791 265.217 39.1411 265.827 38.6432C266.441 38.1448 267.188 37.8429 268.068 37.7376C268.949 37.6322 269.744 37.7495 270.454 38.0894C271.168 38.4288 271.755 38.9551 272.214 39.6684C272.677 40.3813 272.969 41.2454 273.091 42.2609C273.211 43.2679 273.13 44.1703 272.848 44.968C272.57 45.7652 272.124 46.413 271.51 46.9114C270.9 47.4093 270.155 47.7109 269.275 47.8162ZM269.114 46.4707C269.782 46.3907 270.312 46.1535 270.702 45.7591C271.093 45.3647 271.358 44.8759 271.499 44.2925C271.639 43.7092 271.671 43.0918 271.593 42.4402C271.515 41.7886 271.338 41.1938 271.064 40.6559C270.789 40.1179 270.415 39.7013 269.942 39.406C269.469 39.1107 268.898 39.0031 268.23 39.0831C267.561 39.1631 267.032 39.4024 266.642 39.801C266.252 40.1996 265.987 40.6927 265.847 41.2803C265.707 41.8679 265.676 42.4874 265.754 43.139C265.832 43.7906 266.008 44.3833 266.282 44.917C266.556 45.4507 266.929 45.8631 267.402 46.1541C267.875 46.4452 268.445 46.5507 269.114 46.4707ZM275.418 46.8749L274.251 37.1263L275.698 36.9531L275.875 38.4256L275.976 38.4134C276.096 37.9098 276.371 37.4799 276.8 37.1238C277.23 36.7677 277.736 36.5547 278.32 36.4848C278.43 36.4716 278.568 36.4573 278.734 36.4417C278.899 36.4262 279.025 36.4176 279.11 36.416L279.293 37.9392C279.24 37.9326 279.122 37.9275 278.937 37.9238C278.756 37.9155 278.565 37.9232 278.367 37.947C277.893 38.0037 277.482 38.1538 277.133 38.3973C276.788 38.6359 276.529 38.9417 276.354 39.3145C276.184 39.6825 276.125 40.0866 276.178 40.5266L276.916 46.6956L275.418 46.8749ZM287.531 37.7513L286.232 38.2932C286.12 38.0791 285.969 37.8761 285.779 37.6843C285.592 37.4878 285.351 37.3364 285.055 37.2302C284.759 37.124 284.393 37.0969 283.957 37.1491C283.361 37.2205 282.88 37.4175 282.515 37.7402C282.154 38.0581 281.999 38.4265 282.049 38.8453C282.093 39.2177 282.264 39.4955 282.561 39.6789C282.857 39.8623 283.302 39.9915 283.894 40.0665L285.384 40.2487C286.281 40.3559 286.969 40.6019 287.449 40.9865C287.928 41.3669 288.208 41.8978 288.29 42.579C288.356 43.1375 288.255 43.656 287.986 44.1345C287.722 44.6126 287.319 45.0127 286.778 45.3349C286.237 45.6572 285.588 45.8636 284.831 45.9543C283.837 46.0733 282.988 45.956 282.285 45.6024C281.581 45.2488 281.093 44.6678 280.821 43.8592L282.2 43.3336C282.398 43.8421 282.701 44.205 283.109 44.4222C283.521 44.639 284.034 44.7106 284.648 44.6372C285.346 44.5536 285.882 44.3392 286.257 43.9939C286.636 43.6438 286.8 43.2594 286.75 42.8405C286.71 42.502 286.557 42.2327 286.293 42.0326C286.028 41.8282 285.643 41.6983 285.139 41.6428L283.469 41.4565C282.55 41.3518 281.855 41.1024 281.383 40.7082C280.915 40.3093 280.641 39.7735 280.56 39.1008C280.494 38.5507 280.59 38.0457 280.849 37.5856C281.111 37.125 281.497 36.7419 282.005 36.4364C282.518 36.1304 283.117 35.9364 283.802 35.8544C284.767 35.7389 285.55 35.8598 286.15 36.2171C286.755 36.5739 287.216 37.0853 287.531 37.7513ZM295.62 38.5086L296.321 44.373L294.824 44.5522L293.268 31.5541L294.766 31.3748L295.337 36.1476L295.464 36.1324C295.632 35.6015 295.927 35.1607 296.349 34.8098C296.774 34.4542 297.369 34.2305 298.135 34.1389C298.799 34.0594 299.397 34.123 299.928 34.3298C300.459 34.5324 300.895 34.8901 301.235 35.403C301.579 35.9112 301.801 36.5841 301.901 37.4219L302.643 43.6163L301.145 43.7956L300.416 37.7027C300.323 36.9284 300.05 36.3538 299.598 35.9788C299.149 35.599 298.571 35.4515 297.865 35.536C297.374 35.5948 296.946 35.7511 296.582 36.005C296.221 36.2584 295.953 36.5974 295.776 37.022C295.604 37.4461 295.552 37.9416 295.62 38.5086ZM307.743 43.2377C307.125 43.3116 306.551 43.2623 306.019 43.0899C305.487 42.9132 305.047 42.6205 304.697 42.2116C304.348 41.7986 304.135 41.2747 304.059 40.6401C303.992 40.0815 304.048 39.6156 304.226 39.2423C304.404 38.8648 304.665 38.5546 305.01 38.3117C305.354 38.0688 305.742 37.872 306.175 37.7216C306.611 37.5663 307.052 37.432 307.498 37.3186C308.081 37.1715 308.555 37.0569 308.918 36.9748C309.285 36.8879 309.548 36.7857 309.706 36.6681C309.867 36.55 309.934 36.3704 309.905 36.1292L309.899 36.0784C309.824 35.4522 309.594 34.9861 309.21 34.6802C308.83 34.3738 308.295 34.2618 307.606 34.3444C306.89 34.43 306.349 34.6536 305.98 35.0153C305.611 35.3771 305.366 35.7455 305.243 36.1207L303.761 35.7831C303.944 35.1604 304.227 34.6586 304.61 34.278C304.998 33.8926 305.435 33.6041 305.923 33.4127C306.415 33.2165 306.906 33.0891 307.397 33.0303C307.71 32.9928 308.074 32.9879 308.489 33.0154C308.908 33.0382 309.322 33.1411 309.73 33.324C310.143 33.5064 310.503 33.813 310.812 34.2438C311.121 34.6746 311.322 35.2772 311.415 36.0515L312.184 42.4744L310.686 42.6537L310.528 41.3335L310.452 41.3426C310.375 41.5664 310.233 41.813 310.025 42.0825C309.817 42.3521 309.527 42.595 309.153 42.8113C308.78 43.0277 308.31 43.1698 307.743 43.2377ZM307.81 41.8648C308.403 41.7939 308.888 41.6178 309.266 41.3365C309.649 41.0546 309.922 40.7172 310.085 40.3243C310.253 39.9309 310.312 39.5311 310.264 39.1249L310.099 37.754C310.045 37.8377 309.914 37.9243 309.706 38.0135C309.501 38.0981 309.262 38.1804 308.988 38.2603C308.718 38.3356 308.454 38.4058 308.196 38.4711C307.941 38.5316 307.735 38.582 307.577 38.6224C307.194 38.7198 306.84 38.8458 306.515 39.0006C306.194 39.1506 305.943 39.3502 305.762 39.5992C305.586 39.8436 305.52 40.1561 305.566 40.5369C305.628 41.0574 305.868 41.4278 306.284 41.6483C306.705 41.864 307.214 41.9362 307.81 41.8648ZM320.837 31.5504L318.399 41.7305L316.876 41.9128L312.104 32.5957L313.729 32.4012L317.349 39.8475L317.451 39.8354L319.212 31.7449L320.837 31.5504ZM327.207 40.8822C326.268 40.9946 325.433 40.8843 324.702 40.5512C323.975 40.2133 323.382 39.6919 322.925 38.9871C322.471 38.2775 322.184 37.4234 322.064 36.4249C321.945 35.4263 322.021 34.5245 322.294 33.7193C322.571 32.9094 323.011 32.2515 323.616 31.7457C324.224 31.2351 324.969 30.9271 325.849 30.8218C326.356 30.761 326.868 30.7856 327.383 30.8956C327.898 31.0056 328.382 31.2267 328.834 31.5589C329.285 31.8869 329.668 32.3474 329.984 32.9405C330.3 33.5336 330.512 34.285 330.621 35.1947L330.697 35.8294L323.182 36.7288L323.027 35.4341L329.019 34.717C328.953 34.1669 328.784 33.6893 328.512 33.284C328.245 32.8783 327.895 32.5746 327.463 32.3731C327.036 32.1711 326.551 32.1025 326.01 32.1673C325.413 32.2387 324.915 32.4486 324.514 32.7969C324.118 33.1405 323.831 33.5611 323.654 34.0586C323.478 34.5561 323.422 35.0736 323.486 35.6109L323.59 36.4741C323.678 37.2103 323.879 37.8192 324.194 38.3008C324.513 38.7776 324.917 39.122 325.406 39.3339C325.894 39.5415 326.441 39.6091 327.046 39.5367C327.44 39.4896 327.789 39.392 328.093 39.244C328.401 39.0913 328.657 38.8889 328.863 38.6368C329.069 38.3805 329.215 38.0754 329.301 37.7218L330.797 37.9548C330.703 38.4638 330.499 38.926 330.184 39.3414C329.868 39.7526 329.458 40.0935 328.954 40.3641C328.45 40.6305 327.867 40.8032 327.207 40.8822ZM337.452 39.45L336.285 29.7014L337.732 29.5282L337.909 31.0006L338.01 30.9884C338.13 30.4848 338.405 30.0549 338.834 29.6988C339.264 29.3427 339.771 29.1297 340.354 29.0598C340.464 29.0466 340.602 29.0323 340.768 29.0168C340.933 29.0013 341.059 28.9927 341.144 28.991L341.327 30.5142C341.274 30.5076 341.156 30.5025 340.971 30.4989C340.79 30.4905 340.6 30.4983 340.401 30.5221C339.927 30.5788 339.516 30.7289 339.167 30.9723C338.822 31.211 338.563 31.5167 338.388 31.8895C338.218 32.2576 338.159 32.6616 338.212 33.1016L338.95 39.2707L337.452 39.45ZM347.381 38.4676C346.441 38.58 345.606 38.4697 344.875 38.1366C344.148 37.7987 343.556 37.2774 343.098 36.5725C342.644 35.8629 342.357 35.0088 342.238 34.0103C342.118 33.0117 342.195 32.1099 342.468 31.3047C342.744 30.4948 343.185 29.8369 343.789 29.3311C344.398 28.8205 345.142 28.5125 346.022 28.4072C346.53 28.3464 347.041 28.371 347.557 28.481C348.072 28.591 348.555 28.8121 349.007 29.1443C349.459 29.4723 349.842 29.9328 350.158 30.5259C350.473 31.119 350.685 31.8704 350.794 32.7801L350.87 33.4148L343.356 34.3142L343.201 33.0195L349.192 32.3024C349.126 31.7523 348.958 31.2747 348.686 30.8694C348.418 30.4637 348.069 30.1601 347.637 29.9585C347.209 29.7565 346.725 29.6879 346.183 29.7527C345.587 29.8241 345.088 30.034 344.688 30.3823C344.291 30.7259 344.004 31.1465 343.828 31.644C343.651 32.1415 343.595 32.659 343.66 33.1963L343.763 34.0595C343.851 34.7957 344.053 35.4046 344.368 35.8862C344.687 36.363 345.091 36.7074 345.58 36.9193C346.068 37.1269 346.615 37.1945 347.22 37.1221C347.613 37.075 347.962 36.9774 348.266 36.8295C348.574 36.6767 348.831 36.4743 349.037 36.2222C349.242 35.9659 349.388 35.6609 349.475 35.3072L350.97 35.5402C350.877 36.0492 350.672 36.5114 350.357 36.9268C350.042 37.338 349.632 37.6789 349.128 37.9495C348.623 38.2159 348.041 38.3886 347.381 38.4676ZM359.135 29.181L357.835 29.7229C357.724 29.5087 357.573 29.3058 357.382 29.114C357.196 28.9174 356.954 28.766 356.659 28.6598C356.363 28.5536 355.997 28.5266 355.561 28.5788C354.964 28.6502 354.484 28.8472 354.119 29.1698C353.758 29.4877 353.602 29.8561 353.652 30.275C353.697 30.6473 353.867 30.9252 354.164 31.1086C354.461 31.292 354.905 31.4211 355.498 31.4961L356.988 31.6783C357.885 31.7856 358.573 32.0315 359.052 32.4162C359.531 32.7966 359.812 33.3274 359.893 34.0086C359.96 34.5672 359.859 35.0857 359.59 35.5642C359.325 36.0422 358.923 36.4424 358.382 36.7646C357.841 37.0868 357.192 37.2933 356.434 37.3839C355.44 37.503 354.591 37.3857 353.888 37.0321C353.185 36.6785 352.697 36.0974 352.424 35.2889L353.803 34.7633C354.001 35.2718 354.305 35.6346 354.713 35.8519C355.125 36.0686 355.638 36.1403 356.251 36.0669C356.949 35.9833 357.486 35.7689 357.861 35.4236C358.239 35.0735 358.404 34.689 358.354 34.2702C358.313 33.9317 358.161 33.6624 357.896 33.4622C357.632 33.2579 357.247 33.128 356.742 33.0725L355.072 32.8861C354.154 32.7814 353.459 32.532 352.987 32.1379C352.519 31.739 352.244 31.2032 352.164 30.5304C352.098 29.9804 352.194 29.4753 352.452 29.0152C352.715 28.5546 353.1 28.1716 353.609 27.8661C354.121 27.5601 354.72 27.3661 355.406 27.284C356.371 27.1686 357.153 27.2895 357.754 27.6468C358.359 28.0035 358.819 28.5149 359.135 29.181ZM361.937 36.5194L360.77 26.7708L362.268 26.5915L363.435 36.3401L361.937 36.5194ZM361.337 25.0548C361.045 25.0898 360.781 25.0205 360.546 24.8469C360.315 24.6729 360.183 24.4462 360.149 24.167C360.116 23.8877 360.191 23.6363 360.374 23.4126C360.562 23.1884 360.802 23.0588 361.094 23.0239C361.386 22.9889 361.647 23.0585 361.879 23.2325C362.114 23.4061 362.248 23.6325 362.282 23.9117C362.315 24.191 362.238 24.4427 362.05 24.6669C361.867 24.8906 361.629 25.0199 361.337 25.0548ZM371.642 27.6841L370.342 28.2259C370.23 28.0118 370.079 27.8088 369.889 27.617C369.702 27.4205 369.461 27.2691 369.165 27.1629C368.869 27.0567 368.503 27.0297 368.067 27.0819C367.471 27.1533 366.99 27.3503 366.625 27.6729C366.264 27.9908 366.109 28.3592 366.159 28.7781C366.203 29.1504 366.374 29.4283 366.671 29.6117C366.967 29.795 367.412 29.9242 368.005 29.9992L369.494 30.1814C370.391 30.2886 371.079 30.5346 371.559 30.9193C372.038 31.2997 372.318 31.8305 372.4 32.5117C372.466 33.0702 372.365 33.5888 372.097 34.0673C371.832 34.5453 371.429 34.9454 370.888 35.2677C370.347 35.5899 369.698 35.7964 368.941 35.887C367.947 36.006 367.098 35.8887 366.395 35.5352C365.691 35.1816 365.203 34.6005 364.931 33.792L366.31 33.2664C366.508 33.7748 366.811 34.1377 367.219 34.355C367.631 34.5717 368.144 34.6434 368.758 34.5699C369.456 34.4864 369.992 34.2719 370.367 33.9266C370.746 33.5766 370.91 33.1921 370.86 32.7732C370.82 32.4347 370.667 32.1654 370.403 31.9653C370.138 31.761 369.753 31.631 369.249 31.5755L367.579 31.3892C366.661 31.2845 365.965 31.0351 365.493 30.641C365.025 30.2421 364.751 29.7063 364.67 29.0335C364.604 28.4835 364.7 27.9784 364.959 27.5183C365.221 27.0577 365.607 26.6747 366.115 26.3692C366.628 26.0632 367.227 25.8692 367.912 25.7871C368.877 25.6716 369.66 25.7926 370.26 26.1498C370.865 26.5066 371.326 27.018 371.642 27.6841ZM377.516 24.7664L377.668 26.0357L372.616 26.6404L372.464 25.3711L377.516 24.7664ZM373.657 22.8592L375.155 22.68L376.267 31.9716C376.318 32.3947 376.417 32.7047 376.565 32.9016C376.717 33.0937 376.894 33.2141 377.097 33.2627C377.304 33.3066 377.518 33.3154 377.738 33.2891C377.903 33.2693 378.037 33.2446 378.141 33.2151C378.244 33.1812 378.327 33.1542 378.389 33.1339L378.855 34.4429C378.758 34.4932 378.62 34.5482 378.443 34.6081C378.266 34.6722 378.038 34.7209 377.759 34.7544C377.336 34.805 376.91 34.7637 376.482 34.6303C376.058 34.4965 375.691 34.2594 375.38 33.9189C375.073 33.578 374.886 33.124 374.818 32.5571L373.657 22.8592ZM383.296 34.1946C382.678 34.2685 382.104 34.2193 381.572 34.0468C381.04 33.8702 380.6 33.5774 380.25 33.1686C379.901 32.7555 379.688 32.2317 379.612 31.597C379.545 31.0385 379.601 30.5726 379.779 30.1993C379.957 29.8218 380.218 29.5116 380.563 29.2686C380.907 29.0257 381.295 28.829 381.728 28.6785C382.164 28.5233 382.605 28.3889 383.051 28.2755C383.634 28.1285 384.108 28.0139 384.471 27.9317C384.838 27.8448 385.101 27.7426 385.258 27.625C385.42 27.507 385.487 27.3273 385.458 27.0862L385.452 27.0354C385.377 26.4092 385.147 25.9431 384.763 25.6372C384.383 25.3307 383.848 25.2188 383.158 25.3013C382.443 25.3869 381.901 25.6106 381.533 25.9723C381.164 26.334 380.918 26.7025 380.796 27.0776L379.314 26.7401C379.497 26.1173 379.78 25.6156 380.163 25.2349C380.551 24.8495 380.988 24.5611 381.476 24.3697C381.968 24.1735 382.459 24.046 382.95 23.9873C383.263 23.9498 383.627 23.9448 384.042 23.9724C384.461 23.9952 384.875 24.098 385.283 24.2809C385.695 24.4633 386.056 24.7699 386.365 25.2008C386.674 25.6316 386.875 26.2341 386.968 27.0084L387.737 33.4313L386.239 33.6106L386.081 32.2905L386.005 32.2996C385.928 32.5233 385.786 32.7699 385.578 33.0395C385.37 33.309 385.079 33.552 384.706 33.7683C384.333 33.9846 383.863 34.1267 383.296 34.1946ZM383.363 32.8218C383.956 32.7509 384.441 32.5747 384.819 32.2934C385.202 32.0116 385.475 31.6742 385.638 31.2813C385.806 30.8878 385.865 30.488 385.816 30.0818L385.652 28.7109C385.598 28.7947 385.467 28.8812 385.259 28.9705C385.054 29.0551 384.815 29.1373 384.541 29.2173C384.271 29.2925 384.007 29.3628 383.749 29.428C383.494 29.4885 383.288 29.539 383.13 29.5794C382.747 29.6767 382.393 29.8028 382.068 29.9576C381.747 30.1076 381.496 30.3071 381.315 30.5562C381.139 30.8005 381.073 31.1131 381.119 31.4939C381.181 32.0143 381.42 32.3848 381.837 32.6053C382.258 32.821 382.767 32.8932 383.363 32.8218ZM390.73 27.1246L391.432 32.989L389.934 33.1683L388.767 23.4197L390.215 23.2465L390.397 24.7697L390.524 24.7545C390.693 24.2321 390.992 23.7929 391.422 23.4367C391.851 23.0764 392.433 22.8522 393.17 22.764C393.83 22.685 394.423 22.7513 394.951 22.9628C395.478 23.1702 395.912 23.5303 396.252 24.0432C396.592 24.5518 396.811 25.2208 396.911 26.0501L397.652 32.2446L396.154 32.4238L395.425 26.331C395.333 25.5651 395.063 24.9923 394.614 24.6126C394.165 24.2286 393.593 24.0781 392.899 24.1612C392.421 24.2184 392.006 24.3732 391.654 24.6256C391.307 24.8775 391.049 25.2153 390.881 25.6388C390.713 26.0624 390.662 26.5576 390.73 27.1246ZM403.837 31.7102C402.924 31.8196 402.111 31.698 401.399 31.3454C400.687 30.9928 400.108 30.4591 399.662 29.7443C399.216 29.0295 398.935 28.1855 398.819 27.2123C398.7 26.2222 398.777 25.3267 399.051 24.5258C399.328 23.7201 399.768 23.0643 400.373 22.5585C400.981 22.0479 401.726 21.7399 402.606 21.6346C403.291 21.5526 403.924 21.6056 404.505 21.7936C405.085 21.9816 405.578 22.2831 405.984 22.698C406.39 23.113 406.672 23.62 406.829 24.2192L405.331 24.3985C405.164 23.9679 404.863 23.6047 404.428 23.3091C403.998 23.0088 403.452 22.8981 402.792 22.9771C402.208 23.047 401.715 23.2606 401.311 23.6179C400.911 23.9705 400.621 24.4365 400.442 25.0159C400.266 25.5906 400.222 26.246 400.31 26.9822C400.4 27.7354 400.597 28.377 400.901 28.9072C401.209 29.4368 401.6 29.83 402.072 30.0867C402.549 30.3429 403.084 30.4356 403.676 30.3647C404.066 30.3181 404.411 30.2081 404.712 30.0347C405.013 29.8614 405.259 29.6346 405.448 29.3544C405.638 29.0742 405.758 28.7508 405.808 28.3842L407.306 28.2049C407.291 28.7905 407.143 29.3339 406.864 29.8351C406.589 30.3316 406.194 30.7479 405.681 31.084C405.171 31.4154 404.557 31.6241 403.837 31.7102ZM413.412 30.5642C412.472 30.6767 411.637 30.5663 410.906 30.2332C410.179 29.8954 409.587 29.374 409.129 28.6691C408.675 27.9596 408.388 27.1055 408.269 26.1069C408.149 25.1084 408.226 24.2065 408.499 23.4013C408.775 22.5914 409.216 21.9336 409.82 21.4277C410.429 20.9171 411.173 20.6092 412.053 20.5038C412.561 20.4431 413.072 20.4677 413.588 20.5777C414.103 20.6877 414.586 20.9088 415.038 21.241C415.489 21.5689 415.873 22.0294 416.189 22.6226C416.504 23.2157 416.716 23.9671 416.825 24.8768L416.901 25.5115L409.387 26.4109L409.232 25.1161L415.223 24.399C415.157 23.849 414.989 23.3713 414.717 22.9661C414.449 22.5603 414.1 22.2567 413.668 22.0552C413.24 21.8531 412.756 21.7845 412.214 21.8494C411.618 21.9208 411.119 22.1306 410.719 22.479C410.322 22.8226 410.035 23.2432 409.859 23.7407C409.682 24.2382 409.626 24.7556 409.691 25.293L409.794 26.1561C409.882 26.8924 410.084 27.5013 410.399 27.9828C410.718 28.4597 411.122 28.804 411.611 29.0159C412.099 29.2235 412.646 29.2912 413.251 29.2187C413.644 29.1716 413.993 29.0741 414.297 28.9261C414.605 28.7734 414.862 28.571 415.068 28.3188C415.273 28.0625 415.419 27.7575 415.505 27.4038L417.001 27.6368C416.908 28.1459 416.703 28.6081 416.388 29.0235C416.073 29.4346 415.663 29.7755 415.159 30.0461C414.654 30.3125 414.072 30.4852 413.412 30.5642ZM420.683 25.7798L420.674 25.7036C420.586 24.8945 420.594 24.2412 420.697 23.7438C420.801 23.2465 420.983 22.832 421.244 22.5003C421.504 22.1687 421.827 21.8532 422.212 21.554C422.443 21.3718 422.646 21.1651 422.82 20.934C422.994 20.6986 423.121 20.4366 423.202 20.1479C423.288 19.8587 423.311 19.5469 423.271 19.2127C423.221 18.798 423.081 18.45 422.85 18.1687C422.619 17.8873 422.33 17.6836 421.985 17.5576C421.639 17.4316 421.268 17.3924 420.87 17.44C420.523 17.4815 420.197 17.5935 419.893 17.7758C419.588 17.9582 419.347 18.2167 419.168 18.5514C418.989 18.8861 418.913 19.3051 418.939 19.8084L417.339 19.9999C417.287 19.2765 417.4 18.6386 417.677 18.0861C417.958 17.5331 418.362 17.0878 418.888 16.7502C419.418 16.412 420.026 16.2019 420.712 16.1199C421.456 16.0308 422.122 16.1014 422.707 16.3317C423.297 16.5615 423.773 16.9166 424.135 17.3968C424.501 17.8766 424.724 18.4465 424.803 19.1065C424.859 19.572 424.837 20.0016 424.738 20.3954C424.644 20.7886 424.481 21.1493 424.25 21.4774C424.023 21.805 423.737 22.1053 423.392 22.3784C423.048 22.6556 422.779 22.9368 422.585 23.2217C422.392 23.5024 422.265 23.8244 422.205 24.1878C422.146 24.5511 422.143 24.9956 422.198 25.5213L422.207 25.5975L420.683 25.7798ZM421.946 29.4398C421.632 29.4773 421.35 29.3973 421.099 29.1999C420.848 29.0025 420.704 28.7472 420.666 28.4341C420.629 28.121 420.709 27.8389 420.906 27.5878C421.104 27.3367 421.359 27.1925 421.672 27.155C421.985 27.1175 422.267 27.1975 422.518 27.3949C422.769 27.5923 422.914 27.8476 422.951 28.1607C422.976 28.368 422.946 28.5647 422.861 28.7509C422.78 28.9365 422.659 29.0926 422.499 29.2191C422.341 29.3409 422.157 29.4145 421.946 29.4398Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_807_343" x1="0" y1="72.6475" x2="443" y2="72.6475" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_807_343" x1="29.2011" y1="61.238" x2="31.1026" y2="77.1246" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>

<svg width="229" height="88" viewBox="0 0 229 88" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="0.59679" y="49.337" width="224" height="39" rx="15.5" transform="rotate(-12.5637 0.59679 49.337)" fill="#F8F1FF"/>
<rect x="0.59679" y="49.337" width="224" height="39" rx="15.5" transform="rotate(-12.5637 0.59679 49.337)" stroke="url(#paint0_linear_807_339)"/>
<path d="M37.5263 66.1261L41.2025 68.4624M38.5034 60.4384C39.4142 64.5251 36.8505 68.5737 32.7784 69.4813C28.7053 70.389 24.6651 67.8121 23.7545 63.7264C22.8433 59.6377 25.4072 55.59 29.4793 54.6825C33.5524 53.7748 37.5927 56.3516 38.5034 60.4384Z" stroke="url(#paint1_linear_807_339)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M56.592 64.0079L50.2505 52.0091L51.8228 51.6588L56.8123 61.4703L56.9371 61.4425L57.338 50.4296L59.0849 50.0403L64.1244 59.8407L64.2491 59.8129L64.6002 48.8112L66.1724 48.4608L65.5262 62.0169L63.929 62.3728L58.8398 52.8193L58.74 52.8415L58.1891 63.652L56.592 64.0079ZM70.4088 54.8776L71.6936 60.6424L70.2212 60.9705L67.3736 48.1931L68.846 47.865L69.8916 52.5567L70.0163 52.5289C70.1306 51.9838 70.3799 51.5157 70.7643 51.1244C71.1518 50.7281 71.722 50.446 72.4749 50.2783C73.1279 50.1327 73.729 50.1363 74.2782 50.2889C74.8264 50.4374 75.2955 50.7498 75.6855 51.2261C76.0786 51.6974 76.367 52.3447 76.5505 53.1683L77.9076 59.2575L76.4352 59.5857L75.1004 53.5962C74.9307 52.8351 74.602 52.2906 74.1142 51.9627C73.6296 51.6297 73.04 51.5407 72.3454 51.6955C71.8629 51.803 71.453 52.0013 71.1158 52.2904C70.7827 52.5785 70.5495 52.9427 70.4162 53.3828C70.2871 53.822 70.2846 54.3202 70.4088 54.8776ZM82.9443 58.3708C82.337 58.5061 81.7604 58.5146 81.2145 58.3961C80.6676 58.2735 80.1999 58.0263 79.8114 57.6544C79.422 57.2784 79.1578 56.7785 79.0188 56.1546C78.8964 55.6056 78.9054 55.1364 79.0456 54.7471C79.185 54.3537 79.4138 54.0189 79.7321 53.7428C80.0504 53.4667 80.4173 53.2321 80.8327 53.0391C81.2513 52.841 81.6767 52.6633 82.1087 52.5059C82.6743 52.3012 83.1339 52.1399 83.4874 52.0218C83.8442 51.8986 84.0951 51.7707 84.2401 51.6379C84.3894 51.5043 84.4375 51.3189 84.3847 51.0818L84.3736 51.0319C84.2364 50.4163 83.9613 49.9755 83.5484 49.7096C83.1397 49.4426 82.5963 49.3847 81.9183 49.5358C81.2154 49.6925 80.6986 49.9692 80.3679 50.366C80.0372 50.7628 79.8297 51.1539 79.7453 51.5394L78.2366 51.3518C78.3563 50.7139 78.5881 50.1863 78.9317 49.7692C79.2785 49.347 79.6851 49.0163 80.1513 48.777C80.6208 48.5327 81.0967 48.3568 81.5792 48.2492C81.887 48.1807 82.2489 48.1393 82.6649 48.1252C83.0841 48.106 83.5059 48.167 83.9303 48.3081C84.3588 48.4484 84.7484 48.7174 85.099 49.1151C85.4496 49.5129 85.7097 50.0923 85.8794 50.8535L87.2865 57.1673L85.8141 57.4955L85.5249 56.1978L85.45 56.2145C85.3965 56.4447 85.2797 56.7043 85.0996 56.9933C84.9196 57.2823 84.6546 57.553 84.3049 57.8056C83.9552 58.0582 83.5016 58.2466 82.9443 58.3708ZM82.8741 56.9981C83.4564 56.8683 83.9217 56.6446 84.27 56.3268C84.6225 56.0081 84.8603 55.6451 84.9835 55.2379C85.1108 54.8297 85.13 54.4259 85.041 54.0266L84.7407 52.679C84.695 52.7678 84.573 52.867 84.3748 52.9766C84.1798 53.0812 83.9501 53.187 83.6858 53.2939C83.4247 53.3958 83.1689 53.492 82.9185 53.5828C82.6713 53.6685 82.4709 53.7393 82.3175 53.7953C81.946 53.9305 81.6063 54.0913 81.2986 54.2778C80.9941 54.4592 80.7646 54.6828 80.6099 54.9486C80.4584 55.2094 80.4244 55.527 80.5078 55.9013C80.6219 56.4129 80.8973 56.7576 81.3342 56.9352C81.7743 57.1078 82.2876 57.1288 82.8741 56.9981ZM91.4788 46.174L91.7569 47.4218L86.7906 48.5286L86.5126 47.2808L91.4788 46.174ZM87.4483 44.6622L88.9207 44.3341L90.9563 53.468C91.049 53.8839 91.1788 54.1824 91.3458 54.3635C91.516 54.5395 91.7046 54.6415 91.9117 54.6696C92.1221 54.6926 92.3354 54.68 92.5516 54.6318C92.7139 54.5956 92.8451 54.5577 92.9454 54.5178C93.0447 54.4739 93.1242 54.4387 93.1838 54.4123L93.7781 55.6682C93.6866 55.7279 93.5556 55.7964 93.3851 55.8737C93.2155 55.9551 92.9934 56.0265 92.7189 56.0876C92.303 56.1803 91.8754 56.1818 91.4363 56.0919C91.0013 56.0011 90.612 55.8019 90.2684 55.4943C89.9289 55.1857 89.6971 54.7528 89.5729 54.1954L87.4483 44.6622ZM102.587 53.9933C101.979 54.1287 101.403 54.1371 100.857 54.0186C100.31 53.896 99.8422 53.6488 99.4537 53.277C99.0643 52.901 98.8001 52.401 98.661 51.7771C98.5387 51.2281 98.5476 50.7589 98.6879 50.3697C98.8273 49.9762 99.0561 49.6415 99.3744 49.3653C99.6927 49.0892 100.06 48.8546 100.475 48.6616C100.894 48.4635 101.319 48.2858 101.751 48.1284C102.317 47.9237 102.776 47.7624 103.13 47.6443C103.486 47.5211 103.737 47.3932 103.882 47.2604C104.032 47.1268 104.08 46.9414 104.027 46.7043L104.016 46.6544C103.879 46.0388 103.604 45.598 103.191 45.3321C102.782 45.0652 102.239 45.0072 101.561 45.1583C100.858 45.315 100.341 45.5917 100.01 45.9885C99.6795 46.3853 99.4719 46.7764 99.3876 47.162L97.8788 46.9743C97.9986 46.3364 98.2303 45.8088 98.5739 45.3917C98.9208 44.9695 99.3274 44.6388 99.7936 44.3995C100.263 44.1552 100.739 43.9793 101.221 43.8718C101.529 43.8032 101.891 43.7618 102.307 43.7477C102.726 43.7285 103.148 43.7895 103.573 43.9306C104.001 44.0709 104.391 44.3399 104.741 44.7376C105.092 45.1354 105.352 45.7148 105.522 46.476L106.929 52.7899L105.456 53.118L105.167 51.8203L105.092 51.837C105.039 52.0672 104.922 52.3268 104.742 52.6158C104.562 52.9048 104.297 53.1756 103.947 53.4281C103.597 53.6807 103.144 53.8691 102.587 53.9933ZM102.516 52.6206C103.099 52.4908 103.564 52.2671 103.912 51.9493C104.265 51.6306 104.503 51.2677 104.626 50.8604C104.753 50.4522 104.772 50.0484 104.683 49.6491L104.383 48.3015C104.337 48.3903 104.215 48.4895 104.017 48.5992C103.822 48.7037 103.592 48.8095 103.328 48.9164C103.067 49.0183 102.811 49.1146 102.561 49.2053C102.314 49.291 102.113 49.3618 101.96 49.4178C101.588 49.553 101.249 49.7138 100.941 49.9003C100.636 50.0817 100.407 50.3053 100.252 50.5712C100.101 50.8319 100.067 51.1495 100.15 51.5238C100.264 52.0354 100.54 52.3801 100.976 52.5578C101.417 52.7304 101.93 52.7513 102.516 52.6206ZM109.089 52.3084L106.953 42.7253L108.376 42.4083L108.698 43.8557L108.798 43.8335C108.867 43.3204 109.098 42.8652 109.489 42.4679C109.881 42.0707 110.364 41.8081 110.938 41.6801C111.046 41.656 111.182 41.628 111.345 41.596C111.508 41.564 111.632 41.5429 111.717 41.5327L112.051 43.03C111.998 43.0287 111.88 43.0355 111.695 43.0504C111.514 43.0602 111.326 43.0869 111.13 43.1304C110.664 43.2343 110.27 43.4247 109.948 43.7018C109.629 43.9737 109.401 44.3039 109.265 44.6922C109.132 45.0755 109.114 45.4834 109.21 45.916L110.562 51.9803L109.089 52.3084ZM118.87 50.3383C117.946 50.544 117.104 50.5177 116.344 50.2594C115.587 49.9959 114.945 49.5364 114.419 48.8808C113.896 48.2202 113.526 47.3991 113.307 46.4175C113.088 45.4359 113.074 44.5309 113.265 43.7025C113.459 42.869 113.832 42.1704 114.383 41.6066C114.937 41.0378 115.647 40.6569 116.512 40.4641C117.011 40.3529 117.522 40.3262 118.046 40.3841C118.57 40.4421 119.073 40.6137 119.556 40.8991C120.038 41.1802 120.465 41.6001 120.839 42.1587C121.212 42.7173 121.498 43.4437 121.698 44.338L121.837 44.9619L114.45 46.6081L114.166 45.3354L120.056 44.0228C119.935 43.4821 119.719 43.0237 119.409 42.6477C119.102 42.2707 118.724 42.0035 118.274 41.8462C117.828 41.6879 117.339 41.6681 116.807 41.7868C116.22 41.9175 115.745 42.1761 115.382 42.5628C115.021 42.9443 114.778 43.3914 114.652 43.9041C114.527 44.4168 114.523 44.9372 114.64 45.4654L114.829 46.3139C114.991 47.0377 115.252 47.6234 115.614 48.071C115.979 48.5136 116.415 48.8158 116.923 48.9778C117.429 49.1355 117.98 49.1481 118.575 49.0156C118.962 48.9294 119.299 48.7974 119.587 48.6198C119.878 48.437 120.113 48.2099 120.293 47.9385C120.472 47.6629 120.586 47.3449 120.637 46.9843L122.148 47.0666C122.106 47.5824 121.949 48.0628 121.677 48.5076C121.404 48.9482 121.031 49.3284 120.556 49.6481C120.081 49.9636 119.519 50.1937 118.87 50.3383ZM129.108 41.7959L130.392 47.5607L128.92 47.8888L126.784 38.3058L128.207 37.9887L128.541 39.4861L128.665 39.4583C128.782 38.9216 129.035 38.4546 129.427 38.0573C129.818 37.6559 130.375 37.3745 131.099 37.2132C131.748 37.0686 132.345 37.0752 132.891 37.233C133.436 37.3865 133.904 37.7015 134.294 38.1778C134.683 38.6499 134.968 39.2936 135.15 40.1088L136.507 46.1981L135.034 46.5262L133.699 40.5368C133.532 39.784 133.206 39.2411 132.721 38.9081C132.235 38.571 131.652 38.4784 130.969 38.6305C130.499 38.7352 130.102 38.9307 129.777 39.217C129.457 39.5024 129.234 39.8642 129.109 40.3025C128.984 40.7407 128.984 41.2385 129.108 41.7959ZM142.733 45.0201C141.809 45.2259 140.967 45.1996 140.207 44.9413C139.45 44.6778 138.808 44.2183 138.282 43.5627C137.759 42.9021 137.389 42.081 137.17 41.0994C136.951 40.1178 136.937 39.2128 137.128 38.3844C137.322 37.5509 137.695 36.8523 138.246 36.2885C138.8 35.7196 139.51 35.3388 140.375 35.146C140.874 35.0348 141.385 35.0081 141.909 35.066C142.433 35.124 142.936 35.2956 143.419 35.5809C143.901 35.8621 144.328 36.282 144.701 36.8406C145.075 37.3992 145.361 38.1256 145.56 39.0199L145.699 39.6438L138.313 41.29L138.029 40.0173L143.918 38.7047C143.798 38.164 143.582 37.7056 143.271 37.3296C142.965 36.9526 142.587 36.6854 142.137 36.5281C141.691 36.3698 141.202 36.35 140.67 36.4687C140.083 36.5994 139.608 36.858 139.245 37.2447C138.884 37.6262 138.641 38.0733 138.515 38.586C138.39 39.0986 138.385 39.6191 138.503 40.1473L138.692 40.9958C138.854 41.7196 139.115 42.3052 139.477 42.7529C139.842 43.1955 140.278 43.4977 140.786 43.6597C141.292 43.8174 141.843 43.83 142.438 43.6975C142.825 43.6113 143.162 43.4793 143.45 43.3017C143.741 43.1189 143.976 42.8918 144.156 42.6204C144.335 42.3448 144.449 42.0268 144.5 41.6662L146.011 41.7485C145.969 42.2643 145.812 42.7447 145.54 43.1895C145.267 43.6301 144.894 44.0103 144.419 44.33C143.944 44.6455 143.381 44.8755 142.733 45.0201ZM153.535 38.2905L152.272 32.6255L153.745 32.2973L155.881 41.8804L154.408 42.2086L154.047 40.5864L153.947 40.6087C153.831 41.1454 153.574 41.6371 153.175 42.0838C152.776 42.5264 152.215 42.8283 151.491 42.9896C150.892 43.1231 150.331 43.1107 149.806 42.9525C149.281 42.7901 148.826 42.4724 148.441 41.9993C148.056 41.5221 147.772 40.8759 147.59 40.0607L146.233 33.9714L147.706 33.6433L149.04 39.6327C149.196 40.3315 149.516 40.8452 149.999 41.174C150.487 41.5019 151.037 41.5977 151.648 41.4615C152.014 41.3799 152.366 41.2033 152.703 40.9318C153.043 40.6594 153.3 40.301 153.471 39.8567C153.647 39.4115 153.668 38.8894 153.535 38.2905ZM160.082 30.885L160.36 32.1328L155.394 33.2396L155.116 31.9918L160.082 30.885ZM156.052 29.3732L157.524 29.0451L159.56 38.179C159.652 38.5949 159.782 38.8934 159.949 39.0745C160.119 39.2505 160.308 39.3525 160.515 39.3806C160.726 39.4036 160.939 39.391 161.155 39.3428C161.317 39.3066 161.449 39.2686 161.549 39.2288C161.648 39.1849 161.728 39.1497 161.787 39.1233L162.382 40.3792C162.29 40.4389 162.159 40.5074 161.989 40.5847C161.819 40.6661 161.597 40.7374 161.322 40.7986C160.906 40.8913 160.479 40.8927 160.04 40.8029C159.605 40.7121 159.215 40.5129 158.872 40.2053C158.532 39.8967 158.301 39.4638 158.176 38.9064L156.052 29.3732ZM163.906 40.0919L161.77 30.5088L163.193 30.1918L163.515 31.6393L163.615 31.617C163.684 31.1039 163.914 30.6487 164.306 30.2515C164.698 29.8542 165.181 29.5916 165.755 29.4637C165.863 29.4396 165.998 29.4115 166.161 29.3795C166.325 29.3475 166.449 29.3264 166.534 29.3162L166.867 30.8136C166.815 30.8122 166.696 30.819 166.512 30.8339C166.331 30.8437 166.142 30.8704 165.947 30.914C165.481 31.0178 165.087 31.2082 164.764 31.4853C164.445 31.7573 164.217 32.0874 164.081 32.4758C163.948 32.859 163.93 33.2669 164.027 33.6995L165.378 39.7638L163.906 40.0919ZM169.916 38.7526L167.78 29.1695L169.252 28.8413L171.388 38.4244L169.916 38.7526ZM168.173 27.4055C167.886 27.4694 167.616 27.4268 167.365 27.2777C167.117 27.1276 166.963 26.9153 166.902 26.6408C166.841 26.3663 166.89 26.1086 167.051 25.8677C167.215 25.6258 167.441 25.4729 167.728 25.409C168.015 25.345 168.282 25.3881 168.529 25.5381C168.781 25.6873 168.937 25.8991 168.998 26.1736C169.059 26.4481 169.008 26.7063 168.843 26.9481C168.683 27.1891 168.46 27.3415 168.173 27.4055ZM173.745 31.8479L175.03 37.6127L173.558 37.9409L171.422 28.3578L172.844 28.0408L173.178 29.5381L173.303 29.5103C173.419 28.9736 173.673 28.5066 174.065 28.1094C174.456 27.7079 175.013 27.4266 175.737 27.2653C176.385 27.1207 176.983 27.1272 177.529 27.285C178.074 27.4386 178.541 27.7535 178.931 28.2298C179.32 28.702 179.606 29.3456 179.787 30.1609L181.144 36.2501L179.672 36.5783L178.337 30.5888C178.169 29.836 177.843 29.2931 177.359 28.9601C176.873 28.623 176.289 28.5305 175.607 28.6825C175.137 28.7872 174.74 28.9828 174.415 29.2691C174.094 29.5544 173.871 29.9163 173.746 30.3545C173.622 30.7928 173.621 31.2906 173.745 31.8479ZM187.245 35.1C186.38 35.2928 185.575 35.2561 184.831 34.9898C184.09 34.7227 183.454 34.2597 182.923 33.6009C182.396 32.9412 182.022 32.1164 181.802 31.1264C181.579 30.1282 181.566 29.2165 181.762 28.3913C181.962 27.5653 182.341 26.874 182.898 26.3176C183.459 25.7603 184.172 25.3853 185.037 25.1925C185.903 24.9997 186.705 25.0369 187.446 25.304C188.191 25.5703 188.827 26.0353 189.355 26.6992C189.887 27.3621 190.264 28.1927 190.487 29.191C190.707 30.1809 190.717 31.0868 190.516 31.9087C190.319 32.7298 189.94 33.4189 189.379 33.9762C188.822 34.5326 188.111 34.9072 187.245 35.1ZM186.951 33.7773C187.608 33.6309 188.111 33.3419 188.46 32.9105C188.809 32.479 189.025 31.966 189.106 31.3716C189.188 30.7771 189.157 30.1596 189.014 29.5191C188.871 28.8786 188.636 28.3044 188.309 27.7967C187.982 27.2889 187.569 26.9117 187.068 26.6652C186.568 26.4187 185.989 26.3687 185.332 26.5151C184.675 26.6616 184.172 26.9526 183.824 27.3882C183.476 27.8239 183.261 28.341 183.181 28.9396C183.1 29.5382 183.132 30.1578 183.274 30.7983C183.417 31.4388 183.651 32.0109 183.978 32.5145C184.304 33.0181 184.717 33.3911 185.216 33.6335C185.715 33.8758 186.293 33.9238 186.951 33.7773ZM198.394 24.5995L197.155 25.2686C197.023 25.0667 196.852 24.8799 196.644 24.708C196.439 24.5311 196.183 24.4046 195.878 24.3286C195.573 24.2525 195.206 24.2622 194.778 24.3577C194.191 24.4884 193.733 24.7325 193.402 25.09C193.075 25.4424 192.957 25.8244 193.049 26.2362C193.13 26.6022 193.328 26.8616 193.641 27.0144C193.955 27.1672 194.41 27.2513 195.007 27.2667L196.507 27.299C197.411 27.3161 198.12 27.492 198.636 27.8267C199.15 28.1574 199.482 28.6575 199.631 29.3272C199.754 29.8762 199.705 30.4022 199.485 30.9052C199.27 31.4073 198.909 31.8457 198.403 32.2204C197.897 32.5951 197.272 32.8654 196.528 33.0314C195.55 33.2492 194.694 33.2174 193.959 32.9359C193.224 32.6544 192.68 32.125 192.328 31.3478L193.648 30.6869C193.896 31.173 194.233 31.5038 194.661 31.6791C195.093 31.8536 195.61 31.8736 196.213 31.7392C196.9 31.5863 197.412 31.3193 197.751 30.9382C198.092 30.552 198.218 30.1531 198.126 29.7413C198.052 29.4086 197.873 29.1558 197.59 28.9831C197.306 28.8063 196.91 28.7155 196.403 28.7107L194.722 28.6923C193.798 28.6799 193.082 28.5013 192.573 28.1563C192.067 27.8062 191.74 27.3006 191.593 26.6392C191.472 26.0985 191.518 25.5864 191.728 25.1028C191.944 24.6182 192.289 24.1986 192.764 23.8438C193.244 23.488 193.82 23.2351 194.494 23.0849C195.443 22.8736 196.233 22.9156 196.867 23.211C197.504 23.5055 198.014 23.9684 198.394 24.5995ZM203.037 27.5991L203.02 27.5242C202.851 26.7279 202.793 26.0771 202.847 25.5719C202.9 25.0667 203.04 24.6361 203.266 24.28C203.492 23.924 203.782 23.5778 204.135 23.2416C204.347 23.0372 204.528 22.8113 204.678 22.5639C204.827 22.3124 204.928 22.0389 204.98 21.7435C205.036 21.4472 205.027 21.1348 204.954 20.8062C204.863 20.3986 204.689 20.0663 204.431 19.8095C204.173 19.5527 203.866 19.3788 203.509 19.288C203.153 19.1972 202.779 19.1953 202.388 19.2824C202.047 19.3585 201.734 19.5024 201.45 19.7143C201.165 19.9261 200.95 20.2075 200.806 20.5584C200.662 20.9093 200.627 21.3339 200.703 21.8321L199.131 22.1825C199.007 21.468 199.055 20.822 199.276 20.2446C199.5 19.6662 199.858 19.1828 200.347 18.7942C200.841 18.4047 201.425 18.1349 202.099 17.9847C202.831 17.8216 203.5 17.8253 204.105 17.996C204.715 18.1657 205.224 18.4714 205.633 18.913C206.045 19.3537 206.324 19.8985 206.468 20.5473C206.57 21.0049 206.592 21.4345 206.533 21.8362C206.478 22.2369 206.352 22.6121 206.155 22.9617C205.962 23.3103 205.708 23.6377 205.392 23.9439C205.077 24.2542 204.837 24.5608 204.673 24.8636C204.508 25.1623 204.414 25.4954 204.392 25.8629C204.369 26.2303 204.411 26.6729 204.517 27.1905L204.534 27.2654L203.037 27.5991ZM204.658 31.1146C204.35 31.1832 204.062 31.1318 203.792 30.9605C203.523 30.7892 203.354 30.5496 203.285 30.2418C203.216 29.934 203.268 29.6454 203.439 29.3758C203.61 29.1062 203.85 28.9371 204.158 28.8685C204.465 28.7999 204.754 28.8513 205.024 29.0226C205.293 29.1939 205.462 29.4335 205.531 29.7413C205.576 29.9451 205.566 30.1438 205.5 30.3375C205.438 30.5303 205.334 30.6977 205.186 30.8397C205.042 30.9766 204.866 31.0682 204.658 31.1146Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_807_339" x1="0" y1="68.9578" x2="225" y2="68.9578" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_807_339" x1="29.9137" y1="54.5857" x2="33.3941" y2="70.2026" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>
<svg width="523" height="109" viewBox="0 0 523 109" fill="none" xmlns="http://www.w3.org/2000/svg">
<rect x="5.90876" y="0.563018" width="521" height="36.8208" rx="15.5" transform="rotate(7.77131 5.90876 0.563018)" fill="#F8F1FF"/>
<rect x="5.90876" y="0.563018" width="521" height="36.8208" rx="15.5" transform="rotate(7.77131 5.90876 0.563018)" stroke="url(#paint0_linear_807_347)"/>
<path d="M34.8497 28.0594L37.485 31.5275M37.7425 23.0657C37.1764 27.2142 33.3655 30.1196 29.2318 29.5555C25.0971 28.9912 22.2041 25.1709 22.7702 21.0234C23.3366 16.8728 27.1473 13.9684 31.281 14.5326C35.4157 15.0968 38.3087 18.9171 37.7425 23.0657Z" stroke="url(#paint1_linear_807_347)" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"/>
<path d="M51.1072 32.3774L52.8773 19.4067L60.7053 20.475L60.5152 21.8684L54.2578 21.0144L53.6597 25.3971L59.5117 26.1957L59.3216 27.5891L53.4696 26.7904L52.868 31.1984L59.2267 32.0662L59.0365 33.4595L51.1072 32.3774ZM63.4708 24.1555L65.2586 28.4509L68.1321 24.7917L69.8548 25.0267L66.0496 29.462L68.5272 34.7548L66.8045 34.5197L64.989 30.4269L62.1431 33.8835L60.4205 33.6484L64.175 29.2062L61.7481 23.9204L63.4708 24.1555ZM69.627 38.6208L71.4525 25.2448L72.8965 25.4419L72.6856 26.9872L72.8629 27.0114C72.9957 26.8575 73.1771 26.6629 73.4071 26.4276C73.6418 26.1887 73.957 25.9909 74.3525 25.8341C74.7529 25.6737 75.2698 25.6367 75.9031 25.7232C76.7222 25.8349 77.4163 26.1383 77.9853 26.6331C78.5543 27.1279 78.9627 27.775 79.2106 28.5744C79.4584 29.3738 79.5127 30.2844 79.3732 31.3062C79.2326 32.3364 78.9355 33.2055 78.4819 33.9134C78.0289 34.6172 77.4639 35.1336 76.7867 35.4626C76.1102 35.7875 75.3665 35.8946 74.5559 35.784C73.931 35.6987 73.4448 35.5269 73.0972 35.2688C72.7503 35.0064 72.4936 34.7284 72.3272 34.4347C72.1614 34.1368 72.0358 33.8917 71.9502 33.6994L71.8235 33.6821L71.1217 38.8248L69.627 38.6208ZM72.258 30.3093C72.1577 31.044 72.177 31.7068 72.3157 32.2977C72.4549 32.8845 72.7098 33.3644 73.0804 33.7375C73.4515 34.1064 73.9369 34.3318 74.5364 34.4136C75.1613 34.4989 75.7053 34.4054 76.1682 34.1331C76.6359 33.8572 77.0137 33.4528 77.3014 32.9201C77.594 32.3837 77.7875 31.7693 77.882 31.0768C77.9754 30.3928 77.9539 29.762 77.8177 29.1843C77.6863 28.6029 77.4314 28.123 77.053 27.7445C76.6793 27.3623 76.1759 27.1281 75.5425 27.0416C74.9345 26.9586 74.4026 27.043 73.9468 27.2948C73.4915 27.5423 73.1209 27.9261 72.8348 28.4462C72.5494 28.9621 72.3571 29.5831 72.258 30.3093ZM83.7226 23.6163L81.9525 36.587L80.4578 36.383L82.228 23.4123L83.7226 23.6163ZM86.9866 37.5062C86.3702 37.4221 85.8266 37.2296 85.3558 36.9288C84.8856 36.6238 84.533 36.2295 84.298 35.7458C84.0635 35.2579 83.9895 34.6973 84.0759 34.064C84.152 33.5066 84.3234 33.0698 84.5902 32.7536C84.8576 32.4331 85.1885 32.1987 85.5829 32.0504C85.9773 31.9021 86.4028 31.8096 86.8594 31.773C87.3208 31.7328 87.7814 31.7139 88.2412 31.7164C88.8427 31.7211 89.3297 31.7295 89.7022 31.7416C90.0796 31.7501 90.3593 31.7173 90.5414 31.6433C90.7278 31.5698 90.8374 31.4127 90.8702 31.172L90.8772 31.1214C90.9624 30.4965 90.8577 29.9876 90.563 29.5947C90.2724 29.2024 89.7831 28.9593 89.0948 28.8653C88.3813 28.768 87.8005 28.8478 87.3525 29.105C86.9046 29.3621 86.574 29.6567 86.361 29.9889L85.0114 29.2887C85.3455 28.7321 85.746 28.318 86.2132 28.0463C86.6852 27.7709 87.1813 27.6021 87.7016 27.5398C88.2267 27.4738 88.7342 27.4742 89.2239 27.5411C89.5364 27.5837 89.8901 27.6707 90.2851 27.802C90.6848 27.9297 91.0591 28.1335 91.408 28.4133C91.7611 28.6938 92.0329 29.0814 92.2235 29.5762C92.414 30.071 92.4565 30.7047 92.3511 31.4774L91.4764 37.8867L89.9817 37.6827L90.1615 36.3654L90.0855 36.355C89.9554 36.5523 89.7556 36.7551 89.4863 36.9635C89.2171 37.1719 88.8746 37.3338 88.4588 37.4491C88.0431 37.5644 87.5524 37.5834 86.9866 37.5062ZM87.3978 36.1947C87.9889 36.2753 88.503 36.2272 88.94 36.0503C89.3813 35.874 89.7304 35.6163 89.9874 35.2772C90.2487 34.9386 90.407 34.5667 90.4623 34.1614L90.649 32.7934C90.5753 32.8607 90.4264 32.9114 90.2025 32.9453C89.9833 32.9756 89.7312 32.995 89.4462 33.0034C89.166 33.0082 88.8927 33.0096 88.6263 33.0076C88.3647 33.002 88.1522 32.9989 87.9889 32.9981C87.5936 32.9957 87.2192 33.0285 86.8659 33.0964C86.5173 33.1607 86.2244 33.2906 85.9869 33.4861C85.7543 33.678 85.612 33.964 85.5602 34.344C85.4893 34.8633 85.6278 35.2822 85.9758 35.6006C86.3285 35.9154 86.8025 36.1134 87.3978 36.1947ZM93.6694 38.186L94.997 28.458L96.4917 28.662L95.1641 38.39L93.6694 38.186ZM95.9783 26.9404C95.687 26.9006 95.4493 26.7671 95.2653 26.5398C95.0855 26.3132 95.0146 26.0605 95.0526 25.7818C95.0906 25.5032 95.2266 25.2787 95.4606 25.1085C95.6988 24.9389 95.9636 24.8739 96.2549 24.9137C96.5462 24.9535 96.7818 25.0867 96.9616 25.3134C97.1456 25.5406 97.2186 25.7936 97.1806 26.0722C97.1426 26.3509 97.0045 26.5751 96.7663 26.7447C96.5323 26.9149 96.2696 26.9801 95.9783 26.9404ZM99.6599 33.0425L98.8613 38.8945L97.3666 38.6906L98.6943 28.9626L100.138 29.1596L99.9308 30.6796L100.057 30.6969C100.353 30.234 100.753 29.8844 101.259 29.648C101.765 29.4074 102.385 29.3372 103.12 29.4375C103.778 29.5273 104.336 29.7411 104.793 30.0788C105.251 30.4122 105.58 30.8699 105.78 31.4521C105.981 32.03 106.025 32.7327 105.912 33.5602L105.068 39.7416L103.573 39.5376L104.403 33.4576C104.507 32.6934 104.39 32.071 104.051 31.5903C103.713 31.1055 103.198 30.8159 102.506 30.7214C102.029 30.6562 101.588 30.7015 101.184 30.8571C100.784 31.0133 100.45 31.2751 100.18 31.6426C99.9105 32.0101 99.7372 32.4768 99.6599 33.0425ZM117.303 31.5022L117.131 32.7689L112.089 32.0809L112.262 30.8142L117.303 31.5022ZM114.05 28.6841L115.544 28.888L114.279 38.16C114.221 38.5823 114.239 38.9073 114.333 39.1351C114.431 39.3593 114.573 39.5205 114.757 39.6188C114.946 39.7134 115.151 39.7757 115.37 39.8057C115.535 39.8282 115.671 39.8382 115.779 39.8357C115.888 39.829 115.974 39.8236 116.039 39.8196L116.16 41.2037C116.054 41.2279 115.907 41.2466 115.72 41.2598C115.533 41.2773 115.3 41.267 115.021 41.229C114.599 41.1713 114.198 41.0241 113.817 40.7872C113.441 40.5509 113.145 40.2288 112.93 39.821C112.719 39.4137 112.652 38.9272 112.729 38.3614L114.05 28.6841ZM120.191 35.8445L119.393 41.6965L117.898 41.4926L119.668 28.5219L121.163 28.7259L120.513 33.4885L120.64 33.5058C120.936 33.0345 121.333 32.6822 121.829 32.4488C122.33 32.2119 122.963 32.1455 123.727 32.2498C124.39 32.3403 124.952 32.5525 125.414 32.8865C125.877 33.2163 126.208 33.6722 126.408 34.2543C126.613 34.8328 126.658 35.5401 126.544 36.3761L125.701 42.5574L124.206 42.3534L125.036 36.2734C125.141 35.5007 125.022 34.8759 124.679 34.399C124.34 33.9184 123.818 33.6299 123.113 33.5337C122.623 33.4669 122.17 33.5104 121.753 33.6643C121.341 33.8187 120.996 34.0791 120.718 34.4455C120.444 34.8124 120.269 35.2787 120.191 35.8445ZM131.951 43.6169C131.014 43.4889 130.234 43.1717 129.61 42.6651C128.992 42.155 128.55 41.5011 128.284 40.7037C128.024 39.9025 127.962 39.0038 128.098 38.0073C128.234 37.0109 128.535 36.1574 129.002 35.447C129.473 34.7329 130.066 34.2073 130.778 33.8702C131.496 33.5294 132.294 33.4189 133.172 33.5388C133.678 33.6079 134.167 33.7606 134.638 33.9969C135.109 34.2333 135.521 34.5691 135.875 35.0044C136.229 35.4355 136.484 35.9778 136.64 36.6313C136.796 37.2848 136.812 38.0654 136.688 38.9732L136.602 39.6066L129.103 38.5832L129.279 37.2912L135.258 38.1071C135.333 37.5582 135.29 37.0535 135.129 36.5928C134.972 36.1328 134.711 35.7508 134.344 35.447C133.981 35.1437 133.529 34.9552 132.989 34.8814C132.393 34.8002 131.858 34.8777 131.383 35.1139C130.912 35.3464 130.529 35.6812 130.233 36.1182C129.937 36.5551 129.752 37.0417 129.679 37.578L129.561 38.4393C129.461 39.174 129.503 39.814 129.686 40.3595C129.875 40.9013 130.179 41.3363 130.598 41.6646C131.019 41.9886 131.531 42.1918 132.134 42.2742C132.527 42.3278 132.889 42.3213 133.221 42.2547C133.557 42.1845 133.857 42.0534 134.12 41.8613C134.383 41.665 134.601 41.4066 134.774 41.0861L136.163 41.6885C135.944 42.1575 135.629 42.5533 135.22 42.8759C134.811 43.1943 134.328 43.4209 133.772 43.5557C133.217 43.6864 132.61 43.7067 131.951 43.6169ZM144.52 39.1647L143.721 45.0167L142.226 44.8127L143.554 35.0847L144.998 35.2818L144.791 36.8018L144.917 36.819C145.213 36.3562 145.613 36.0065 146.118 35.7701C146.624 35.5295 147.245 35.4593 147.979 35.5596C148.638 35.6495 149.196 35.8633 149.653 36.2009C150.111 36.5343 150.44 36.9921 150.64 37.5742C150.84 38.1521 150.884 38.8548 150.771 39.6824L149.928 45.8637L148.433 45.6597L149.263 39.5797C149.367 38.8155 149.25 38.1931 148.911 37.7125C148.573 37.2277 148.058 36.938 147.365 36.8435C146.888 36.7784 146.448 36.8236 146.044 36.9792C145.644 37.1354 145.309 37.3973 145.04 37.7648C144.77 38.1323 144.597 38.5989 144.52 39.1647ZM156.048 46.9055C155.17 46.7856 154.428 46.4714 153.822 45.963C153.221 45.4551 152.785 44.8 152.516 43.9977C152.252 43.1961 152.188 42.2928 152.325 41.2879C152.463 40.2745 152.768 39.4151 153.238 38.7094C153.713 38.0043 154.308 37.4877 155.024 37.1596C155.744 36.8321 156.543 36.7283 157.421 36.8481C158.299 36.968 159.039 37.2818 159.641 37.7897C160.247 38.2982 160.682 38.9554 160.946 39.7613C161.214 40.5678 161.279 41.4777 161.141 42.491C161.004 43.4959 160.698 44.3488 160.224 45.0496C159.754 45.7511 159.159 46.2655 158.439 46.5931C157.724 46.9212 156.927 47.0253 156.048 46.9055ZM156.232 45.5628C156.899 45.6538 157.471 45.5577 157.948 45.2745C158.426 44.9913 158.806 44.5851 159.089 44.056C159.372 43.5269 159.557 42.9373 159.646 42.287C159.735 41.6368 159.714 41.0168 159.584 40.427C159.454 39.8372 159.197 39.3398 158.813 38.9348C158.43 38.5298 157.905 38.2818 157.238 38.1908C156.571 38.0997 155.998 38.1979 155.52 38.4854C155.042 38.7728 154.661 39.1832 154.378 39.7165C154.094 40.2499 153.908 40.8416 153.82 41.4919C153.731 42.1421 153.752 42.76 153.883 43.3455C154.014 43.9311 154.271 44.4243 154.655 44.8251C155.039 45.2258 155.564 45.4717 156.232 45.5628ZM162.231 47.5427L163.558 37.8147L165.002 38.0118L164.795 39.5318L164.921 39.5491C165.195 39.0574 165.577 38.6988 166.068 38.4734C166.56 38.2437 167.122 38.1721 167.755 38.2585C168.397 38.3461 168.911 38.5646 169.298 38.9142C169.69 39.2601 169.97 39.7091 170.14 40.2613L170.241 40.2751C170.559 39.8067 170.987 39.4586 171.526 39.2311C172.065 38.9993 172.683 38.9309 173.379 39.026C174.249 39.1447 174.924 39.5142 175.402 40.1343C175.882 40.7502 176.043 41.6303 175.887 42.7745L174.999 49.2852L173.504 49.0812L174.392 42.5706C174.49 41.8528 174.364 41.313 174.013 40.9512C173.663 40.5894 173.222 40.3721 172.69 40.2995C172.006 40.2062 171.447 40.3408 171.015 40.7033C170.584 41.0615 170.325 41.5552 170.239 42.1843L169.375 48.5177L167.855 48.3102L168.764 41.6476C168.839 41.0945 168.721 40.6245 168.408 40.2378C168.096 39.8468 167.657 39.6127 167.091 39.5355C166.702 39.4825 166.325 39.5364 165.959 39.6971C165.597 39.8585 165.288 40.1087 165.031 40.4478C164.779 40.7833 164.62 41.1896 164.555 41.6667L163.725 47.7467L162.231 47.5427ZM181.247 50.3444C180.31 50.2165 179.53 49.8993 178.906 49.3927C178.288 48.8825 177.846 48.2287 177.581 47.4312C177.32 46.6301 177.258 45.7314 177.394 44.7349C177.53 43.7385 177.831 42.885 178.298 42.1746C178.77 41.4605 179.362 40.9349 180.074 40.5977C180.792 40.257 181.59 40.1465 182.468 40.2664C182.975 40.3355 183.463 40.4882 183.934 40.7245C184.405 40.9608 184.818 41.2967 185.171 41.732C185.525 42.1631 185.78 42.7054 185.936 43.3589C186.092 44.0124 186.108 44.793 185.984 45.7008L185.898 46.3341L178.399 45.3108L178.575 44.0188L184.554 44.8347C184.629 44.2858 184.586 43.7811 184.425 43.3204C184.269 42.8604 184.007 42.4784 183.64 42.1746C183.277 41.8713 182.825 41.6828 182.285 41.609C181.689 41.5278 181.154 41.6053 180.679 41.8415C180.208 42.074 179.825 42.4088 179.529 42.8458C179.233 43.2827 179.048 43.7693 178.975 44.3056L178.857 45.1669C178.757 45.9016 178.799 46.5416 178.982 47.0871C179.171 47.6289 179.475 48.0639 179.895 48.3922C180.315 48.7162 180.827 48.9194 181.431 49.0018C181.823 49.0554 182.185 49.0489 182.517 48.9823C182.854 48.9121 183.153 48.781 183.416 48.5889C183.679 48.3926 183.897 48.1342 184.07 47.8137L185.459 48.4161C185.24 48.8851 184.926 49.2809 184.516 49.6035C184.107 49.9218 183.625 50.1485 183.069 50.2833C182.513 50.414 181.906 50.4343 181.247 50.3444ZM189.335 45.2807L188.536 51.1327L187.042 50.9288L188.369 41.2008L189.813 41.3978L189.606 42.9178L189.732 42.9351C190.028 42.4722 190.428 42.1226 190.934 41.8862C191.44 41.6456 192.06 41.5754 192.795 41.6757C193.453 41.7655 194.011 41.9793 194.468 42.317C194.926 42.6504 195.255 43.1081 195.455 43.6903C195.656 44.2682 195.7 44.9709 195.587 45.7984L194.743 51.9798L193.248 51.7758L194.078 45.6958C194.182 44.9316 194.065 44.3092 193.726 43.8285C193.388 43.3437 192.873 43.0541 192.181 42.9596C191.704 42.8944 191.263 42.9397 190.859 43.0953C190.459 43.2515 190.125 43.5133 189.855 43.8808C189.586 44.2483 189.412 44.715 189.335 45.2807ZM200.864 53.0215C199.952 52.897 199.196 52.5745 198.596 52.054C197.996 51.5334 197.57 50.8711 197.319 50.0669C197.067 49.2627 197.008 48.375 197.14 47.4039C197.275 46.4159 197.575 45.5688 198.042 44.8626C198.513 44.1527 199.105 43.6292 199.817 43.2921C200.535 42.9513 201.333 42.8409 202.211 42.9607C202.895 43.0541 203.494 43.2649 204.008 43.5931C204.523 43.9213 204.924 44.3374 205.212 44.8412C205.5 45.345 205.645 45.9067 205.647 46.5262L204.152 46.3222C204.098 45.8634 203.899 45.4361 203.553 45.0405C203.211 44.6413 202.712 44.3967 202.053 44.3068C201.47 44.2273 200.939 44.3096 200.458 44.5537C199.982 44.7941 199.584 45.172 199.265 45.6875C198.95 46.1993 198.742 46.8226 198.642 47.5573C198.539 48.3088 198.568 48.9794 198.728 49.569C198.893 50.1592 199.172 50.638 199.565 51.0056C199.962 51.3738 200.456 51.5982 201.047 51.6788C201.435 51.7319 201.797 51.7124 202.132 51.6205C202.467 51.5286 202.762 51.371 203.016 51.1476C203.27 50.9243 203.468 50.6416 203.609 50.2996L205.104 50.5036C204.941 51.0663 204.661 51.555 204.265 51.9697C203.873 52.3807 203.387 52.6842 202.805 52.8801C202.229 53.0723 201.581 53.1195 200.864 53.0215ZM209.631 40.7994L207.861 53.7701L206.367 53.5661L208.137 40.5954L209.631 40.7994ZM212.895 54.6893C212.279 54.6052 211.735 54.4127 211.264 54.1119C210.794 53.8069 210.442 53.4126 210.207 52.9289C209.972 52.441 209.898 51.8804 209.985 51.2471C210.061 50.6897 210.232 50.2529 210.499 49.9367C210.766 49.6162 211.097 49.3818 211.492 49.2335C211.886 49.0852 212.311 48.9927 212.768 48.9561C213.229 48.9159 213.69 48.897 214.15 48.8995C214.751 48.9042 215.238 48.9126 215.611 48.9248C215.988 48.9332 216.268 48.9004 216.45 48.8264C216.636 48.7529 216.746 48.5958 216.779 48.3552L216.786 48.3045C216.871 47.6796 216.766 47.1707 216.472 46.7778C216.181 46.3855 215.692 46.1424 215.004 46.0484C214.29 45.9511 213.709 46.0309 213.261 46.2881C212.813 46.5452 212.483 46.8399 212.27 47.172L210.92 46.4718C211.254 45.9152 211.655 45.5011 212.122 45.2294C212.594 44.954 213.09 44.7852 213.61 44.7229C214.135 44.6569 214.643 44.6574 215.133 44.7242C215.445 44.7668 215.799 44.8538 216.194 44.9851C216.593 45.1128 216.968 45.3166 217.317 45.5964C217.67 45.8769 217.942 46.2645 218.132 46.7593C218.323 47.2541 218.365 47.8878 218.26 48.6605L217.385 55.0698L215.89 54.8658L216.07 53.5485L215.994 53.5381C215.864 53.7354 215.664 53.9382 215.395 54.1466C215.126 54.355 214.783 54.5169 214.368 54.6322C213.952 54.7475 213.461 54.7665 212.895 54.6893ZM213.307 53.3778C213.898 53.4584 214.412 53.4103 214.849 53.2334C215.29 53.0571 215.639 52.7994 215.896 52.4603C216.157 52.1218 216.316 51.7498 216.371 51.3445L216.558 49.9765C216.484 50.0438 216.335 50.0945 216.111 50.1284C215.892 50.1587 215.64 50.1781 215.355 50.1865C215.075 50.1913 214.801 50.1927 214.535 50.1907C214.273 50.1852 214.061 50.182 213.898 50.1812C213.502 50.1788 213.128 50.2116 212.775 50.2795C212.426 50.3438 212.133 50.4737 211.896 50.6692C211.663 50.8611 211.521 51.1471 211.469 51.5271C211.398 52.0464 211.537 52.4653 211.884 52.7837C212.237 53.0985 212.711 53.2965 213.307 53.3778ZM225.136 46.2185L224.964 47.4851L219.922 46.7971L220.095 45.5305L225.136 46.2185ZM221.882 43.4003L223.377 43.6043L222.112 52.8763C222.054 53.2985 222.072 53.6235 222.166 53.8514C222.264 54.0755 222.406 54.2368 222.59 54.3351C222.779 54.4297 222.984 54.492 223.203 54.522C223.368 54.5444 223.504 54.5544 223.612 54.5519C223.72 54.5452 223.807 54.5399 223.872 54.5358L223.993 55.92C223.886 55.9442 223.74 55.9629 223.553 55.9761C223.366 55.9935 223.133 55.9832 222.854 55.9452C222.432 55.8876 222.031 55.7403 221.65 55.5035C221.274 55.2672 220.978 54.9451 220.763 54.5372C220.551 54.13 220.485 53.6434 220.562 53.0777L221.882 43.4003ZM232.196 53.0396L232.98 47.289L234.475 47.4929L233.147 57.2209L231.653 57.017L231.877 55.3703L231.776 55.3565C231.481 55.8193 231.069 56.1911 230.54 56.4716C230.012 56.7479 229.381 56.8359 228.646 56.7357C228.038 56.6527 227.516 56.4459 227.079 56.1154C226.643 55.7806 226.327 55.3246 226.131 54.7473C225.935 54.1657 225.893 53.4612 226.006 52.6336L226.85 46.4523L228.344 46.6563L227.515 52.7363C227.418 53.4456 227.539 54.0385 227.878 54.5148C228.222 54.9918 228.704 55.2726 229.325 55.3574C229.696 55.4081 230.087 55.3646 230.497 55.2271C230.911 55.0901 231.276 54.8431 231.592 54.4862C231.911 54.1298 232.113 53.6476 232.196 53.0396ZM235.35 57.5215L236.678 47.7935L238.122 47.9906L237.921 49.4599L238.022 49.4737C238.265 49.0166 238.64 48.6699 239.145 48.4335C239.65 48.1971 240.194 48.1186 240.777 48.1981C240.887 48.2131 241.024 48.234 241.188 48.2607C241.352 48.2874 241.476 48.3107 241.559 48.3307L241.351 49.8507C241.302 49.8311 241.189 49.7962 241.011 49.7461C240.838 49.6924 240.652 49.6519 240.453 49.6249C239.98 49.5603 239.545 49.6019 239.146 49.7497C238.752 49.8938 238.424 50.1242 238.161 50.4411C237.904 50.7542 237.745 51.1304 237.685 51.5695L236.845 57.7255L235.35 57.5215ZM245.206 59.073C244.268 58.9451 243.488 58.6278 242.865 58.1213C242.246 57.6111 241.804 56.9573 241.539 56.1598C241.278 55.3587 241.216 54.4599 241.352 53.4635C241.488 52.467 241.789 51.6136 242.256 50.9031C242.728 50.189 243.32 49.6634 244.033 49.3263C244.75 48.9855 245.548 48.8751 246.426 48.9949C246.933 49.0641 247.422 49.2168 247.893 49.4531C248.364 49.6894 248.776 50.0252 249.129 50.4605C249.483 50.8916 249.738 51.4339 249.894 52.0874C250.05 52.7409 250.066 53.5216 249.942 54.4294L249.856 55.0627L242.357 54.0393L242.534 52.7473L248.512 53.5633C248.587 53.0144 248.544 52.5096 248.383 52.049C248.227 51.5889 247.965 51.207 247.598 50.9031C247.235 50.5999 246.783 50.4113 246.243 50.3376C245.648 50.2563 245.112 50.3338 244.637 50.57C244.167 50.8026 243.783 51.1373 243.487 51.5743C243.191 52.0113 243.006 52.4979 242.933 53.0341L242.816 53.8954C242.715 54.6301 242.757 55.2702 242.941 55.8156C243.129 56.3575 243.433 56.7925 243.853 57.1207C244.273 57.4447 244.785 57.6479 245.389 57.7303C245.782 57.7839 246.144 57.7774 246.475 57.7109C246.812 57.6407 247.111 57.5095 247.374 57.3174C247.637 57.1211 247.856 56.8627 248.028 56.5422L249.417 57.1446C249.198 57.6137 248.884 58.0095 248.474 58.332C248.065 58.6504 247.583 58.877 247.027 59.0119C246.471 59.1425 245.864 59.1629 245.206 59.073ZM259.405 61.0109C258.527 60.891 257.785 60.5768 257.179 60.0684C256.577 59.5605 256.142 58.9054 255.873 58.1031C255.608 57.3015 255.545 56.3982 255.682 55.3933C255.82 54.3799 256.124 53.5205 256.595 52.8148C257.07 52.1097 257.665 51.5931 258.381 51.265C259.1 50.9375 259.9 50.8337 260.778 50.9535C261.656 51.0734 262.396 51.3872 262.998 51.8951C263.603 52.4036 264.038 53.0608 264.303 53.8667C264.571 54.6732 264.636 55.5831 264.498 56.5964C264.361 57.6013 264.055 58.4542 263.581 59.155C263.111 59.8565 262.516 60.3709 261.796 60.6985C261.08 61.0266 260.283 61.1307 259.405 61.0109ZM259.588 59.6682C260.256 59.7592 260.828 59.6631 261.305 59.3799C261.782 59.0967 262.163 58.6905 262.446 58.1614C262.728 57.6323 262.914 57.0427 263.003 56.3924C263.092 55.7422 263.071 55.1222 262.941 54.5324C262.811 53.9426 262.554 53.4452 262.17 53.0402C261.787 52.6352 261.262 52.3872 260.595 52.2962C259.927 52.2051 259.355 52.3033 258.877 52.5908C258.399 52.8782 258.018 53.2886 257.735 53.8219C257.451 54.3553 257.265 54.947 257.176 55.5973C257.088 56.2475 257.109 56.8654 257.24 57.4509C257.37 58.0365 257.628 58.5297 258.012 58.9305C258.396 59.3312 258.921 59.5771 259.588 59.6682ZM271.247 52.5113L271.074 53.778L265.83 53.0623L266.003 51.7956L271.247 52.5113ZM266.246 61.738L267.757 50.6673C267.833 50.11 268.027 49.6634 268.34 49.3276C268.652 48.9918 269.03 48.7595 269.473 48.6307C269.917 48.502 270.371 48.4693 270.835 48.5327C271.203 48.5828 271.498 48.6533 271.722 48.7441C271.947 48.8349 272.112 48.9134 272.219 48.9797L271.612 50.2129C271.54 50.1772 271.439 50.1311 271.309 50.0747C271.183 50.0188 271.012 49.9762 270.797 49.9468C270.303 49.8794 269.929 49.9552 269.676 50.1744C269.426 50.3941 269.269 50.7446 269.203 51.226L267.741 61.942L266.246 61.738ZM277.837 59.7072L278.064 57.8544L278.368 57.8959L283.216 54.1447L285.065 54.3971L279.905 58.3636L279.778 58.3463L277.837 59.7072ZM275.96 63.0637L277.73 50.093L279.225 50.297L277.455 63.2677L275.96 63.0637ZM282.141 63.9073L278.998 58.5754L280.204 57.6819L284.041 64.1666L282.141 63.9073ZM288.777 65.0192C287.839 64.8913 287.059 64.5741 286.436 64.0675C285.817 63.5573 285.375 62.9035 285.11 62.1061C284.849 61.3049 284.787 60.4062 284.923 59.4097C285.059 58.4133 285.36 57.5598 285.827 56.8494C286.299 56.1353 286.891 55.6097 287.604 55.2725C288.321 54.9318 289.119 54.8213 289.997 54.9412C290.504 55.0103 290.993 55.163 291.464 55.3993C291.934 55.6356 292.347 55.9715 292.7 56.4068C293.054 56.8379 293.309 57.3802 293.465 58.0337C293.621 58.6872 293.637 59.4678 293.513 60.3756L293.427 61.009L285.928 59.9856L286.105 58.6936L292.083 59.5095C292.158 58.9606 292.115 58.4559 291.954 57.9952C291.798 57.5352 291.536 57.1532 291.169 56.8494C290.806 56.5461 290.354 56.3576 289.814 56.2838C289.219 56.2026 288.683 56.2801 288.208 56.5163C287.738 56.7488 287.354 57.0836 287.058 57.5206C286.762 57.9575 286.577 58.4441 286.504 58.9804L286.387 59.8417C286.286 60.5764 286.328 61.2164 286.512 61.7619C286.7 62.3037 287.004 62.7387 287.424 63.067C287.844 63.391 288.356 63.5942 288.96 63.6766C289.352 63.7302 289.715 63.7237 290.046 63.6571C290.383 63.5869 290.682 63.4558 290.945 63.2637C291.208 63.0674 291.426 62.809 291.599 62.4885L292.988 63.0909C292.769 63.5599 292.455 63.9557 292.045 64.2783C291.636 64.5967 291.154 64.8233 290.598 64.9581C290.042 65.0888 289.435 65.1091 288.777 65.0192ZM300.129 56.4529L299.956 57.7196L294.915 57.0316L295.088 55.7649L300.129 56.4529ZM296.875 53.6348L298.37 53.8388L297.104 63.1108C297.047 63.533 297.065 63.858 297.159 64.0858C297.257 64.31 297.398 64.4712 297.583 64.5695C297.772 64.6642 297.976 64.7265 298.196 64.7564C298.361 64.7789 298.497 64.7889 298.605 64.7864C298.713 64.7797 298.8 64.7743 298.865 64.7703L298.986 66.1545C298.879 66.1786 298.733 66.1973 298.546 66.2106C298.359 66.228 298.126 66.2177 297.847 66.1797C297.425 66.1221 297.023 65.9748 296.643 65.7379C296.266 65.5016 295.971 65.1796 295.755 64.7717C295.544 64.3644 295.477 63.8779 295.555 63.3121L296.875 53.6348ZM304.335 67.1425C303.456 67.0226 302.714 66.7085 302.109 66.2C301.507 65.6921 301.072 65.0371 300.803 64.2348C300.538 63.4331 300.474 62.5298 300.611 61.5249C300.749 60.5116 301.054 59.6521 301.524 58.9465C301.999 58.2414 302.594 57.7248 303.31 57.3967C304.03 57.0691 304.829 56.9653 305.707 57.0852C306.585 57.205 307.325 57.5189 307.927 58.0268C308.533 58.5352 308.968 59.1924 309.232 59.9983C309.5 60.8048 309.565 61.7147 309.427 62.7281C309.29 63.733 308.984 64.5858 308.51 65.2867C308.04 65.9881 307.445 66.5026 306.726 66.8301C306.01 67.1582 305.213 67.2624 304.335 67.1425ZM304.518 65.7998C305.185 65.8909 305.757 65.7948 306.235 65.5116C306.712 65.2283 307.092 64.8222 307.375 64.2931C307.658 63.764 307.844 63.1743 307.933 62.5241C308.021 61.8739 308.001 61.2539 307.87 60.6641C307.74 60.0743 307.483 59.5769 307.1 59.1719C306.716 58.7669 306.191 58.5189 305.524 58.4278C304.857 58.3368 304.284 58.435 303.806 58.7224C303.329 59.0099 302.948 59.4203 302.664 59.9536C302.381 60.4869 302.195 61.0787 302.106 61.7289C302.017 62.3791 302.038 62.997 302.169 63.5826C302.3 64.1682 302.557 64.6613 302.941 65.0621C303.325 65.4629 303.851 65.7088 304.518 65.7998ZM312.81 62.1317L312.012 67.9837L310.517 67.7798L311.844 58.0518L313.288 58.2488L313.081 59.7688L313.208 59.7861C313.503 59.3232 313.904 58.9736 314.409 58.7372C314.915 58.4966 315.535 58.4264 316.27 58.5267C316.928 58.6166 317.486 58.8303 317.943 59.168C318.401 59.5014 318.73 59.9591 318.93 60.5413C319.131 61.1192 319.175 61.8219 319.062 62.6495L318.218 68.8308L316.724 68.6268L317.553 62.5468C317.658 61.7826 317.54 61.1602 317.202 60.6796C316.864 60.1947 316.348 59.9051 315.656 59.8106C315.179 59.7454 314.738 59.7907 314.334 59.9463C313.934 60.1025 313.6 60.3643 313.33 60.7318C313.061 61.0993 312.887 61.566 312.81 62.1317ZM324.465 69.8898C323.528 69.7619 322.748 69.4446 322.124 68.9381C321.506 68.4279 321.064 67.7741 320.799 66.9766C320.538 66.1755 320.476 65.2767 320.612 64.2803C320.748 63.2838 321.049 62.4304 321.516 61.7199C321.988 61.0058 322.58 60.4802 323.292 60.1431C324.01 59.8023 324.808 59.6919 325.686 59.8117C326.193 59.8809 326.681 60.0336 327.152 60.2699C327.623 60.5062 328.036 60.842 328.389 61.2773C328.743 61.7084 328.998 62.2507 329.154 62.9042C329.31 63.5578 329.326 64.3384 329.202 65.2462L329.116 65.8795L321.617 64.8561L321.793 63.5641L327.772 64.3801C327.847 63.8312 327.804 63.3264 327.643 62.8658C327.487 62.4057 327.225 62.0238 326.858 61.7199C326.495 61.4167 326.043 61.2281 325.503 61.1544C324.907 61.0731 324.372 61.1506 323.897 61.3868C323.426 61.6194 323.043 61.9542 322.747 62.3911C322.451 62.8281 322.266 63.3147 322.193 63.8509L322.075 64.7123C321.975 65.4469 322.017 66.087 322.2 66.6325C322.389 67.1743 322.693 67.6093 323.113 67.9375C323.533 68.2615 324.045 68.4647 324.649 68.5471C325.041 68.6007 325.403 68.5942 325.735 68.5277C326.072 68.4575 326.371 68.3263 326.634 68.1342C326.897 67.9379 327.115 67.6795 327.288 67.359L328.677 67.9614C328.458 68.4305 328.144 68.8263 327.734 69.1489C327.325 69.4672 326.843 69.6938 326.287 69.8287C325.731 69.9593 325.124 69.9797 324.465 69.8898ZM338.181 63.8652L336.786 64.0619C336.732 63.8266 336.637 63.5922 336.501 63.3586C336.37 63.1214 336.175 62.9141 335.915 62.7367C335.656 62.5594 335.308 62.441 334.874 62.3816C334.278 62.3004 333.763 62.3699 333.329 62.5902C332.9 62.8068 332.656 63.1241 332.599 63.5421C332.549 63.9137 332.644 64.2256 332.884 64.4778C333.125 64.73 333.523 64.9671 334.078 65.189L335.473 65.7407C336.314 66.0705 336.918 66.482 337.285 66.9751C337.653 67.4639 337.79 68.0483 337.698 68.728C337.622 69.2854 337.393 69.7617 337.012 70.157C336.636 70.5529 336.145 70.8386 335.541 71.0142C334.936 71.1897 334.256 71.2259 333.5 71.1228C332.508 70.9874 331.716 70.66 331.125 70.1406C330.533 69.6212 330.207 68.9359 330.147 68.0847L331.614 67.9236C331.678 68.4656 331.88 68.8931 332.22 69.2062C332.564 69.5198 333.042 69.7184 333.654 69.802C334.351 69.8971 334.924 69.8248 335.374 69.5851C335.829 69.3418 336.085 69.0112 336.142 68.5932C336.188 68.2554 336.108 67.9563 335.903 67.6961C335.698 67.4316 335.359 67.2089 334.885 67.0281L333.315 66.4268C332.453 66.0941 331.843 65.6776 331.486 65.1772C331.133 64.6732 331.003 64.0855 331.094 63.4142C331.169 62.8653 331.389 62.4008 331.755 62.0206C332.125 61.641 332.595 61.3675 333.164 61.2C333.737 61.0331 334.366 60.9963 335.05 61.0896C336.013 61.221 336.74 61.5353 337.231 62.0324C337.726 62.5301 338.043 63.141 338.181 63.8652ZM343.524 72.2843L344.851 62.5563L346.346 62.7603L345.018 72.4883L343.524 72.2843ZM345.832 61.0387C345.541 60.9989 345.303 60.8654 345.119 60.6381C344.94 60.4115 344.869 60.1588 344.907 59.8801C344.945 59.6014 345.081 59.377 345.315 59.2068C345.553 59.0372 345.818 58.9722 346.109 59.012C346.4 59.0517 346.636 59.185 346.816 59.4116C347 59.6389 347.073 59.8919 347.035 60.1705C346.997 60.4492 346.859 60.6733 346.62 60.843C346.386 61.0132 346.124 61.0784 345.832 61.0387ZM349.514 67.1408L348.715 72.9928L347.221 72.7888L348.548 63.0608L349.992 63.2579L349.785 64.7779L349.912 64.7952C350.207 64.3323 350.607 63.9827 351.113 63.7463C351.619 63.5057 352.239 63.4355 352.974 63.5357C353.632 63.6256 354.19 63.8394 354.647 64.177C355.105 64.5105 355.434 64.9682 355.634 65.5504C355.835 66.1282 355.879 66.831 355.766 67.6585L354.922 73.8399L353.427 73.6359L354.257 67.5559C354.361 66.7917 354.244 66.1692 353.906 65.6886C353.567 65.2038 353.052 64.9141 352.36 64.8196C351.883 64.7545 351.442 64.7998 351.038 64.9554C350.638 65.1116 350.304 65.3734 350.034 65.7409C349.765 66.1084 349.591 66.575 349.514 67.1408ZM365.524 75.4931C364.645 75.3733 363.903 75.0591 363.298 74.5507C362.696 74.0428 362.261 73.3877 361.992 72.5854C361.727 71.7837 361.663 70.8804 361.8 69.8756C361.938 68.8622 362.243 68.0027 362.713 67.2971C363.188 66.592 363.783 66.0754 364.499 65.7473C365.219 65.4198 366.018 65.3159 366.896 65.4358C367.774 65.5556 368.514 65.8695 369.116 66.3774C369.722 66.8859 370.157 67.5431 370.421 68.349C370.689 69.1555 370.754 70.0654 370.616 71.0787C370.479 72.0836 370.173 72.9365 369.699 73.6373C369.229 74.3387 368.634 74.8532 367.915 75.1807C367.199 75.5089 366.402 75.613 365.524 75.4931ZM365.707 74.1505C366.374 74.2415 366.946 74.1454 367.424 73.8622C367.901 73.579 368.281 73.1728 368.564 72.6437C368.847 72.1146 369.033 71.5249 369.122 70.8747C369.21 70.2245 369.19 69.6045 369.059 69.0147C368.929 68.4249 368.672 67.9275 368.289 67.5225C367.905 67.1175 367.38 66.8695 366.713 66.7785C366.046 66.6874 365.473 66.7856 364.995 67.0731C364.517 67.3605 364.137 67.7709 363.853 68.3042C363.57 68.8375 363.384 69.4293 363.295 70.0795C363.206 70.7298 363.227 71.3477 363.358 71.9332C363.489 72.5188 363.746 73.012 364.13 73.4127C364.514 73.8135 365.04 74.0594 365.707 74.1505ZM371.706 76.1304L373.033 66.4024L374.477 66.5995L374.277 68.0688L374.378 68.0826C374.621 67.6255 374.995 67.2787 375.501 67.0423C376.006 66.8059 376.55 66.7275 377.133 66.807C377.243 66.822 377.38 66.8428 377.544 66.8695C377.708 66.8962 377.831 66.9196 377.915 66.9395L377.707 68.4595C377.658 68.4399 377.545 68.4051 377.367 68.355C377.193 68.3012 377.008 68.2608 376.809 68.2337C376.336 68.1692 375.9 68.2108 375.502 68.3585C375.108 68.5026 374.78 68.7331 374.517 69.0499C374.259 69.3631 374.101 69.7393 374.041 70.1784L373.201 76.3344L371.706 76.1304ZM380.912 81.3091C380.19 81.2106 379.582 81.033 379.088 80.7763C378.593 80.5239 378.193 80.2242 377.888 79.8772C377.586 79.5349 377.357 79.1811 377.2 78.8157L378.505 78.1421C378.616 78.3379 378.76 78.5639 378.935 78.8202C379.11 79.0806 379.366 79.3198 379.702 79.5376C380.041 79.7603 380.505 79.9117 381.091 79.9918C381.877 80.099 382.551 79.9974 383.114 79.6871C383.676 79.3769 384.013 78.8164 384.124 78.0057L384.393 76.0297L384.267 76.0124C384.133 76.1748 383.946 76.373 383.708 76.6071C383.474 76.8376 383.156 77.0285 382.753 77.1799C382.354 77.3277 381.838 77.3583 381.205 77.2719C380.419 77.1647 379.739 76.8827 379.165 76.4259C378.595 75.9696 378.177 75.362 377.911 74.6031C377.649 73.8448 377.587 72.959 377.725 71.9457C377.861 70.9492 378.155 70.1055 378.606 69.4144C379.058 68.7191 379.624 68.2114 380.304 67.8914C380.985 67.5671 381.735 67.4609 382.554 67.5727C383.187 67.6591 383.675 67.8332 384.018 68.095C384.366 68.3532 384.621 68.6288 384.783 68.9219C384.95 69.2114 385.076 69.448 385.163 69.6319L385.315 69.6526L385.526 68.1073L386.97 68.3044L385.604 78.311C385.49 79.147 385.208 79.8009 384.756 80.2726C384.308 80.7491 383.749 81.0663 383.078 81.2241C382.411 81.3868 381.689 81.4151 380.912 81.3091ZM381.59 75.9569C382.19 76.0387 382.715 75.9706 383.167 75.7526C383.618 75.5347 383.986 75.1828 384.272 74.6971C384.558 74.2114 384.749 73.6096 384.847 72.8918C384.943 72.1909 384.922 71.558 384.784 70.993C384.646 70.4279 384.391 69.9652 384.019 69.6047C383.646 69.2442 383.156 69.0225 382.548 68.9395C381.915 68.8531 381.365 68.9415 380.899 69.2048C380.437 69.4686 380.064 69.8564 379.779 70.368C379.498 70.8802 379.313 71.4656 379.223 72.1243C379.131 72.7999 379.155 73.4117 379.295 73.9599C379.44 74.5044 379.702 74.9529 380.079 75.3055C380.462 75.6545 380.966 75.8716 381.59 75.9569ZM390.675 78.9514C390.059 78.8673 389.515 78.6748 389.044 78.374C388.574 78.069 388.221 77.6747 387.986 77.191C387.752 76.7031 387.678 76.1425 387.764 75.5092C387.84 74.9518 388.012 74.515 388.279 74.1988C388.546 73.8783 388.877 73.6439 389.271 73.4956C389.666 73.3473 390.091 73.2548 390.548 73.2182C391.009 73.178 391.47 73.1591 391.93 73.1616C392.531 73.1663 393.018 73.1747 393.391 73.1868C393.768 73.1953 394.048 73.1625 394.23 73.0885C394.416 73.015 394.526 72.8579 394.559 72.6172L394.566 72.5666C394.651 71.9417 394.546 71.4328 394.251 71.0399C393.961 70.6476 393.471 70.4045 392.783 70.3105C392.07 70.2132 391.489 70.293 391.041 70.5502C390.593 70.8073 390.262 71.1019 390.049 71.4341L388.7 70.7339C389.034 70.1773 389.434 69.7632 389.902 69.4915C390.374 69.2161 390.87 69.0473 391.39 68.985C391.915 68.919 392.423 68.9194 392.912 68.9863C393.225 69.0289 393.578 69.1159 393.973 69.2472C394.373 69.3749 394.748 69.5787 395.096 69.8585C395.45 70.139 395.721 70.5266 395.912 71.0214C396.102 71.5162 396.145 72.1499 396.039 72.9226L395.165 79.3319L393.67 79.1279L393.85 77.8106L393.774 77.8002C393.644 77.9975 393.444 78.2003 393.175 78.4087C392.905 78.6171 392.563 78.779 392.147 78.8943C391.732 79.0096 391.241 79.0286 390.675 78.9514ZM391.086 77.6399C391.677 77.7205 392.191 77.6724 392.628 77.4955C393.07 77.3192 393.419 77.0615 393.676 76.7224C393.937 76.3838 394.095 76.0119 394.151 75.6066L394.337 74.2386C394.264 74.3059 394.115 74.3566 393.891 74.3905C393.672 74.4208 393.42 74.4402 393.135 74.4486C392.854 74.4534 392.581 74.4548 392.315 74.4528C392.053 74.4472 391.841 74.4441 391.677 74.4433C391.282 74.4409 390.908 74.4737 390.554 74.5416C390.206 74.6059 389.913 74.7358 389.675 74.9313C389.443 75.1232 389.3 75.4092 389.249 75.7892C389.178 76.3085 389.316 76.7274 389.664 77.0458C390.017 77.3606 390.491 77.5586 391.086 77.6399ZM399.651 73.9832L398.852 79.8352L397.358 79.6312L398.685 69.9032L400.129 70.1003L399.922 71.6203L400.049 71.6375C400.344 71.1747 400.744 70.825 401.25 70.5886C401.756 70.348 402.376 70.2778 403.111 70.3781C403.769 70.468 404.327 70.6817 404.784 71.0194C405.242 71.3528 405.571 71.8106 405.771 72.3927C405.972 72.9706 406.016 73.6733 405.903 74.5009L405.059 80.6822L403.565 80.4782L404.394 74.3982C404.499 73.634 404.381 73.0116 404.043 72.531C403.705 72.0461 403.189 71.7565 402.497 71.662C402.02 71.5969 401.579 71.6421 401.175 71.7977C400.775 71.9539 400.441 72.2157 400.171 72.5832C399.902 72.9508 399.728 73.4174 399.651 73.9832ZM407.255 80.9819L408.583 71.2539L410.078 71.4579L408.75 81.1859L407.255 80.9819ZM409.564 69.7363C409.273 69.6966 409.035 69.563 408.851 69.3358C408.671 69.1091 408.601 68.8564 408.639 68.5778C408.677 68.2991 408.813 68.0747 409.047 67.9045C409.285 67.7348 409.55 67.6699 409.841 67.7096C410.132 67.7494 410.368 67.8826 410.548 68.1093C410.732 68.3366 410.805 68.5895 410.767 68.8682C410.729 69.1469 410.59 69.371 410.352 69.5406C410.118 69.7108 409.856 69.7761 409.564 69.7363ZM414.877 82.2285C413.965 82.1041 413.209 81.7815 412.609 81.261C412.009 80.7404 411.584 80.0781 411.332 79.2739C411.08 78.4697 411.021 77.5821 411.153 76.6109C411.288 75.6229 411.589 74.7758 412.055 74.0696C412.526 73.3597 413.118 72.8362 413.831 72.4991C414.548 72.1583 415.346 72.0479 416.224 72.1677C416.908 72.2611 417.507 72.4719 418.022 72.8001C418.536 73.1283 418.937 73.5444 419.225 74.0482C419.514 74.552 419.658 75.1137 419.66 75.7332L418.165 75.5293C418.112 75.0704 417.912 74.6431 417.566 74.2475C417.225 73.8483 416.725 73.6037 416.066 73.5138C415.484 73.4343 414.952 73.5166 414.471 73.7607C413.996 74.0011 413.598 74.3791 413.278 74.8945C412.963 75.4063 412.755 76.0296 412.655 76.7643C412.553 77.5158 412.581 78.1864 412.742 78.776C412.906 79.3662 413.185 79.845 413.578 80.2126C413.975 80.5808 414.469 80.8052 415.06 80.8859C415.449 80.9389 415.81 80.9194 416.146 80.8275C416.481 80.7356 416.775 80.578 417.029 80.3546C417.283 80.1313 417.481 79.8486 417.622 79.5066L419.117 79.7106C418.954 80.2733 418.675 80.762 418.278 81.1767C417.887 81.5877 417.4 81.8912 416.819 82.0871C416.242 82.2793 415.595 82.3265 414.877 82.2285ZM428.785 84.1266C427.873 84.0022 427.117 83.6796 426.517 83.1591C425.917 82.6385 425.492 81.9762 425.24 81.172C424.989 80.3678 424.929 79.4802 425.062 78.509C425.197 77.521 425.497 76.6739 425.963 75.9677C426.434 75.2578 427.026 74.7343 427.739 74.3972C428.456 74.0564 429.254 73.946 430.132 74.0658C430.816 74.1592 431.416 74.37 431.93 74.6982C432.444 75.0264 432.845 75.4425 433.134 75.9463C433.422 76.4501 433.567 77.0118 433.568 77.6313L432.074 77.4273C432.02 76.9685 431.82 76.5412 431.474 76.1456C431.133 75.7464 430.633 75.5018 429.975 75.4119C429.392 75.3324 428.86 75.4147 428.38 75.6588C427.904 75.8992 427.506 76.2771 427.186 76.7926C426.871 77.3044 426.664 77.9277 426.563 78.6624C426.461 79.4139 426.49 80.0845 426.65 80.6741C426.815 81.2643 427.093 81.7431 427.486 82.1107C427.883 82.4789 428.377 82.7033 428.968 82.7839C429.357 82.837 429.719 82.8175 430.054 82.7256C430.389 82.6337 430.683 82.4761 430.938 82.2527C431.192 82.0294 431.389 81.7467 431.531 81.4047L433.025 81.6087C432.863 82.1714 432.583 82.6601 432.187 83.0748C431.795 83.4858 431.309 83.7893 430.727 83.9852C430.15 84.1774 429.503 84.2246 428.785 84.1266ZM436.581 79.0232L435.783 84.8752L434.288 84.6712L436.058 71.7005L437.553 71.9045L436.903 76.6672L437.03 76.6844C437.326 76.2131 437.723 75.8608 438.219 75.6275C438.72 75.3905 439.353 75.3242 440.117 75.4284C440.78 75.5189 441.342 75.7311 441.804 76.0651C442.267 76.3949 442.598 76.8509 442.798 77.433C443.003 78.0115 443.048 78.7187 442.934 79.5547L442.091 85.736L440.596 85.532L441.426 79.452C441.531 78.6794 441.412 78.0546 441.069 77.5776C440.73 77.097 440.208 76.8086 439.503 76.7123C439.013 76.6455 438.56 76.689 438.143 76.8429C437.731 76.9973 437.386 77.2577 437.108 77.6241C436.834 77.991 436.659 78.4574 436.581 79.0232ZM448.341 86.7955C447.404 86.6676 446.624 86.3503 446 85.8438C445.382 85.3336 444.94 84.6798 444.674 83.8823C444.414 83.0812 444.352 82.1824 444.488 81.186C444.624 80.1895 444.925 79.3361 445.392 78.6256C445.864 77.9115 446.456 77.3859 447.168 77.0488C447.886 76.708 448.684 76.5975 449.562 76.7174C450.068 76.7865 450.557 76.9393 451.028 77.1756C451.499 77.4119 451.911 77.7477 452.265 78.183C452.619 78.6141 452.874 79.1564 453.03 79.8099C453.186 80.4634 453.202 81.2441 453.078 82.1519L452.992 82.7852L445.493 81.7618L445.669 80.4698L451.648 81.2858C451.723 80.7369 451.68 80.2321 451.519 79.7715C451.363 79.3114 451.101 78.9295 450.734 78.6256C450.371 78.3223 449.919 78.1338 449.379 78.0601C448.783 77.9788 448.248 78.0563 447.773 78.2925C447.302 78.5251 446.919 78.8598 446.623 79.2968C446.327 79.7338 446.142 80.2204 446.069 80.7566L445.951 81.6179C445.851 82.3526 445.893 82.9927 446.076 83.5381C446.265 84.0799 446.569 84.515 446.988 84.8432C447.409 85.1672 447.921 85.3704 448.524 85.4528C448.917 85.5064 449.279 85.4999 449.611 85.4334C449.947 85.3631 450.247 85.232 450.51 85.0399C450.773 84.8436 450.991 84.5852 451.164 84.2647L452.553 84.8671C452.334 85.3361 452.02 85.732 451.61 86.0545C451.201 86.3729 450.718 86.5995 450.162 86.7344C449.607 86.865 449 86.8854 448.341 86.7955ZM454.136 87.3798L455.463 77.6518L456.907 77.8489L456.7 79.3689L456.826 79.3861C457.1 78.8945 457.482 78.5359 457.973 78.3105C458.465 78.0808 459.027 78.0092 459.66 78.0956C460.302 78.1832 460.816 78.4017 461.203 78.7513C461.595 79.0971 461.875 79.5462 462.045 80.0984L462.146 80.1122C462.464 79.6437 462.892 79.2957 463.431 79.0682C463.97 78.8364 464.588 78.768 465.284 78.8631C466.154 78.9818 466.828 79.3512 467.307 79.9714C467.787 80.5873 467.948 81.4674 467.792 82.6116L466.904 89.1223L465.409 88.9183L466.297 82.4076C466.395 81.6899 466.269 81.1501 465.918 80.7883C465.568 80.4264 465.127 80.2092 464.595 80.1366C463.911 80.0433 463.352 80.1779 462.92 80.5403C462.488 80.8986 462.23 81.3923 462.144 82.0214L461.28 88.3548L459.76 88.1473L460.669 81.4847C460.744 80.9315 460.626 80.4616 460.313 80.0749C460.001 79.6839 459.562 79.4498 458.996 79.3726C458.607 79.3195 458.23 79.3734 457.864 79.5342C457.502 79.6956 457.193 79.9458 456.936 80.2849C456.684 80.6204 456.525 81.0267 456.46 81.5038L455.63 87.5838L454.136 87.3798ZM469.101 89.4222L470.429 79.6942L471.924 79.8982L470.596 89.6262L469.101 89.4222ZM471.41 78.1766C471.119 78.1368 470.881 78.0033 470.697 77.7761C470.517 77.5494 470.446 77.2967 470.484 77.0181C470.523 76.7394 470.659 76.515 470.892 76.3447C471.131 76.1751 471.395 76.1102 471.687 76.1499C471.978 76.1897 472.214 76.3229 472.393 76.5496C472.578 76.7768 472.651 77.0298 472.612 77.3085C472.574 77.5871 472.436 77.8113 472.198 77.9809C471.964 78.1511 471.702 78.2164 471.41 78.1766ZM480.719 83.3178L479.325 83.5146C479.271 83.2793 479.176 83.0449 479.04 82.8113C478.909 82.5741 478.714 82.3668 478.454 82.1894C478.195 82.012 477.847 81.8937 477.412 81.8343C476.817 81.7531 476.302 81.8226 475.868 82.0429C475.438 82.2595 475.195 82.5768 475.138 82.9948C475.087 83.3664 475.182 83.6783 475.423 83.9305C475.664 84.1827 476.062 84.4197 476.616 84.6417L478.012 85.1934C478.853 85.5232 479.457 85.9347 479.824 86.4278C480.192 86.9166 480.329 87.5009 480.236 88.1807C480.16 88.7381 479.932 89.2144 479.551 89.6097C479.175 90.0056 478.684 90.2913 478.079 90.4669C477.475 90.6424 476.795 90.6786 476.039 90.5755C475.047 90.44 474.255 90.1126 473.663 89.5932C473.072 89.0738 472.746 88.3885 472.686 87.5374L474.153 87.3763C474.217 87.9183 474.419 88.3458 474.759 88.6589C475.103 88.9725 475.581 89.1711 476.193 89.2547C476.89 89.3497 477.463 89.2774 477.913 89.0378C478.368 88.7945 478.624 88.4638 478.681 88.0458C478.727 87.708 478.647 87.409 478.442 87.1488C478.237 86.8843 477.898 86.6616 477.423 86.4808L475.854 85.8795C474.992 85.5468 474.382 85.1303 474.025 84.6299C473.672 84.1259 473.541 83.5382 473.633 82.8668C473.708 82.3179 473.928 81.8534 474.294 81.4733C474.664 81.0937 475.134 80.8201 475.703 80.6527C476.276 80.4858 476.905 80.449 477.589 80.5423C478.551 80.6737 479.278 80.9879 479.77 81.4851C480.265 81.9828 480.582 82.5937 480.719 83.3178ZM487.14 81.9748L486.967 83.2415L481.925 82.5534L482.098 81.2868L487.14 81.9748ZM483.886 79.1566L485.38 79.3606L484.115 88.6326C484.057 89.0548 484.075 89.3799 484.169 89.6077C484.268 89.8319 484.409 89.9931 484.593 90.0914C484.783 90.186 484.987 90.2483 485.207 90.2783C485.371 90.3008 485.507 90.3107 485.615 90.3083C485.724 90.3016 485.811 90.2962 485.876 90.2922L485.996 91.6763C485.89 91.7005 485.743 91.7192 485.556 91.7324C485.369 91.7499 485.136 91.7396 484.857 91.7015C484.435 91.6439 484.034 91.4967 483.653 91.2598C483.277 91.0235 482.981 90.7014 482.766 90.2936C482.555 89.8863 482.488 89.3998 482.565 88.834L483.886 79.1566ZM487.525 91.9366L488.853 82.2086L490.297 82.4057L490.096 83.875L490.198 83.8888C490.441 83.4317 490.815 83.0849 491.32 82.8485C491.826 82.6121 492.37 82.5337 492.952 82.6132C493.062 82.6282 493.199 82.649 493.363 82.6757C493.527 82.7024 493.651 82.7258 493.734 82.7457L493.527 84.2657C493.478 84.2462 493.364 84.2113 493.186 84.1612C493.013 84.1074 492.827 84.067 492.629 84.0399C492.156 83.9754 491.72 84.017 491.321 84.1647C490.928 84.3088 490.599 84.5393 490.337 84.8561C490.079 85.1693 489.92 85.5455 489.86 85.9846L489.02 92.1406L487.525 91.9366ZM494.387 96.589C494.134 96.5544 493.911 96.5025 493.718 96.4332C493.525 96.3681 493.393 96.3114 493.322 96.263L493.882 94.9975C494.232 95.1399 494.548 95.2175 494.83 95.2302C495.113 95.2429 495.377 95.1521 495.622 94.9577C495.872 94.7681 496.121 94.4387 496.37 93.9695L496.753 93.2475L494.49 82.9779L496.111 83.1991L497.739 91.3176L497.84 91.3314L501.583 83.9459L503.204 84.1672L497.554 94.7503C497.3 95.2274 497.013 95.6119 496.693 95.9038C496.373 96.1999 496.021 96.4034 495.636 96.5143C495.255 96.6257 494.839 96.6506 494.387 96.589Z" fill="#3D408E"/>
<defs>
<linearGradient id="paint0_linear_807_347" x1="5.48096" y1="18.9104" x2="527.481" y2="18.9104" gradientUnits="userSpaceOnUse">
<stop stop-color="#A6AAF2"/>
<stop offset="1" stop-color="#6A6FDA"/>
</linearGradient>
<linearGradient id="paint1_linear_807_347" x1="31.7219" y1="14.5927" x2="29.5584" y2="30.4458" gradientUnits="userSpaceOnUse">
<stop stop-color="#7073CA"/>
<stop offset="1" stop-color="#8487E2"/>
</linearGradient>
</defs>
</svg>
</div>
                <h1 className="Hero-header">No more keywords.<br></br>
                Search the way you are.</h1>

                <div className="search-space">
                    <form onSubmit={handleOnSubmit}>
                        <div className="search-space-1">
                            <div className="content">
                                <svg className="searchIcon" width="33" height="32" viewBox="0 0 33 32" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <rect x="0.328613" width="32" height="32" rx="16" fill="#6C70BF" />
                                    <path d="M15.3286 22C19.1946 22 22.3286 18.866 22.3286 15C22.3286 11.134 19.1946 8 15.3286 8C11.4626 8 8.32861 11.134 8.32861 15C8.32861 18.866 11.4626 22 15.3286 22Z" stroke="white" stroke-width="2" />
                                    <path d="M24.3286 24L21.3286 21" stroke="white" stroke-width="2" stroke-linecap="round" />
                                </svg>
                                <textarea className="text-area" placeholder="I want to know more about Artificial Intelligence..." onChange={e => setText_area(e.target.value)}></textarea>
                            </div>
                            {/* <div className="genre">
                                <label htmlFor="genre">Genre</label>
                                <input className="genre-input" type="text" placeholder="Type genres you are searching for(optional)" onChange={e => setGenre(e.target.value)} />
                            </div> */}

                            <div className="search-space-2">
                                <button className="primary hero-btn" type="submit" disabled={loading}>

                                    {loading ? "Searching" : "Search"}
                                </button>
                            </div>
                        </div>
                    </form>

                    {/* {loading && ( // Render spinner if loading state is true
                        <div className="overlay">    
                            <div className="spinner-container">
                                <ClipLoader color="#6C70BF" loading={loading} size={35}  aria-label="Loading Spinner" data-testid="loader" />
                            </div>
                        </div>
                    )} */}
                </div>
            </div>

        </div>

    )
}