import React from "react";

export function NetworkIcon() {
  return (
    <svg
      className="network-icon"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 511.373 511.373"
    >
      <path
        d="M443.768 153.286A295.958 295.958 0 0 0 223.352 53.02 295.938 295.938 0 0 0 2.978 153.286c-4.083 4.246-3.951 10.999.295 15.082s10.999 3.951 15.082-.295c.141-.146.277-.297.41-.451a274.876 274.876 0 0 1 204.587-93.269 274.879 274.879 0 0 1 204.608 93.355c4.083 4.246 10.836 4.378 15.082.295a10.667 10.667 0 0 0 .705-14.631l.021-.086z"
        fill="#e2ce31"
      />
      <path
        d="M223.373 138.353a222.316 222.316 0 0 0-165.547 75.349c-4.083 4.246-3.951 10.999.295 15.082s10.999 3.951 15.082-.295c.141-.146.277-.297.41-.451a201.239 201.239 0 0 1 149.76-68.352 201.197 201.197 0 0 1 149.76 68.267c3.834 4.473 10.568 4.99 15.041 1.156s4.99-10.568 1.156-15.041a10.287 10.287 0 0 0-.41-.451 222.23 222.23 0 0 0-165.547-75.264z"
        fill="#e2ce31"
      />
      <path
        d="M112.674 274.033c-4.083 4.246-3.951 10.999.295 15.082s10.999 3.951 15.082-.295c.141-.146.277-.297.41-.451 44.491-51.296 121.629-58.108 174.421-15.403 4.444 3.867 11.181 3.4 15.049-1.044 3.783-4.347 3.43-10.913-.798-14.828-61.587-50.357-151.999-42.867-204.459 16.939z"
        fill="#e2ce31"
      />
      <circle cx="223.373" cy="362.353" r="53.333" fill="#e2ce31" />
      <circle cx="394.04" cy="341.02" r="117.333" fill="transparent" />
      <path
        d="M436.706 394.353a10.663 10.663 0 0 1-7.552-3.115l-85.333-85.333c-4.093-4.237-3.975-10.99.262-15.083a10.666 10.666 0 0 1 14.821 0l85.333 85.333c4.171 4.16 4.179 10.914.019 15.085a10.667 10.667 0 0 1-7.571 3.134l.021-.021z"
        fill="#e2ce31"
      />
      <path
        d="M351.373 394.353a10.667 10.667 0 1 1-7.552-18.219l85.333-85.333c4.237-4.093 10.99-3.975 15.083.262a10.666 10.666 0 0 1 0 14.821l-85.333 85.333a10.667 10.667 0 0 1-7.531 3.136z"
        fill="#e2ce31"
      />
      <path
        d="M435.853 171.206a10.665 10.665 0 0 1-7.893-3.499 274.863 274.863 0 0 0-204.587-93.355 274.859 274.859 0 0 0-204.587 93.355c-3.982 4.359-10.745 4.665-15.104.683s-4.665-10.745-.683-15.104A295.918 295.918 0 0 1 223.373 53.02a295.912 295.912 0 0 1 220.373 100.267c3.959 4.363 3.631 11.108-.731 15.067a10.662 10.662 0 0 1-7.162 2.767v.085z"
        fill="#e2ce31"
      />
      <path
        d="M65.72 231.537c-5.891-.003-10.664-4.781-10.661-10.673a10.666 10.666 0 0 1 2.767-7.162 222.248 222.248 0 0 1 165.547-75.349 222.295 222.295 0 0 1 165.547 75.349c4.083 4.246 3.951 10.999-.295 15.082s-10.999 3.951-15.082-.295a10.96 10.96 0 0 1-.41-.451 201.24 201.24 0 0 0-149.76-68.267 201.215 201.215 0 0 0-149.76 68.267 10.668 10.668 0 0 1-7.893 3.499z"
        fill="#e2ce31"
      />
      <path
        d="M120.568 291.953c-5.891-.003-10.664-4.781-10.661-10.673a10.666 10.666 0 0 1 2.767-7.162c52.468-59.809 142.886-67.299 204.48-16.939 4.383 3.941 4.741 10.689.8 15.072s-10.689 4.741-15.072.8c-52.789-42.717-129.936-35.904-174.421 15.403a10.668 10.668 0 0 1-7.893 3.499zm102.805 123.733c-29.455 0-53.333-23.878-53.333-53.333s23.878-53.333 53.333-53.333 53.333 23.878 53.333 53.333-23.878 53.333-53.333 53.333zm0-85.333c-17.673 0-32 14.327-32 32s14.327 32 32 32 32-14.327 32-32-14.327-32-32-32z"
        fill="#e2ce31"
      />
      <path
        d="M394.04 458.353c-64.801 0-117.333-52.532-117.333-117.333s52.532-117.333 117.333-117.333 117.333 52.532 117.333 117.333c-.082 64.767-52.566 117.251-117.333 117.333zm0-213.333c-53.019 0-96 42.981-96 96s42.981 96 96 96 96-42.981 96-96-42.981-96-96-96z"
        fill="#e2ce31"
      />
      <path
        d="M436.706 394.353a10.663 10.663 0 0 1-7.552-3.115l-85.333-85.333c-4.093-4.237-3.975-10.99.262-15.083a10.666 10.666 0 0 1 14.821 0l85.333 85.333c4.171 4.16 4.179 10.914.019 15.085a10.667 10.667 0 0 1-7.571 3.134l.021-.021z"
        fill="#e2ce31"
      />
      <path
        d="M351.373 394.353a10.667 10.667 0 1 1-7.552-18.219l85.333-85.333c4.237-4.093 10.99-3.975 15.083.262a10.666 10.666 0 0 1 0 14.821l-85.333 85.333a10.667 10.667 0 0 1-7.531 3.136z"
        fill="#e2ce31"
      />
    </svg>
  );
}

export function DownloadIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="1.2em"
      height="1.2em"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      className="feather feather-download"
    >
      <path d="M21 15v4a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2v-4" />
      <polyline points="7 10 12 15 17 10" />
      <line x1="12" y1="15" x2="12" y2="3" />
    </svg>
  );
}

export function SearchIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      className="feather feather-search"
    >
      <circle cx="11" cy="11" r="8" />
      <line x1="21" y1="21" x2="16.65" y2="16.65" />
    </svg>
  );
}

export function SunIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      className="feather feather-sun"
    >
      <circle cx="12" cy="12" r="5" />
      <line x1="12" y1="1" x2="12" y2="3" />
      <line x1="12" y1="21" x2="12" y2="23" />
      <line x1="4.22" y1="4.22" x2="5.64" y2="5.64" />
      <line x1="18.36" y1="18.36" x2="19.78" y2="19.78" />
      <line x1="1" y1="12" x2="3" y2="12" />
      <line x1="21" y1="12" x2="23" y2="12" />
      <line x1="4.22" y1="19.78" x2="5.64" y2="18.36" />
      <line x1="18.36" y1="5.64" x2="19.78" y2="4.22" />
    </svg>
  );
}

export function ShareIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      className="feather feather-share-2"
    >
      <circle cx="18" cy="5" r="3" />
      <circle cx="6" cy="12" r="3" />
      <circle cx="18" cy="19" r="3" />
      <line x1="8.59" y1="13.51" x2="15.42" y2="17.49" />
      <line x1="15.41" y1="6.51" x2="8.59" y2="10.49" />
    </svg>
  );
}

export function MoonIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      className="feather feather-moon"
    >
      <path d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79z" />
    </svg>
  );
}
export function HomeIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      width="24"
      height="24"
      viewBox="0 0 24 24"
      fill="none"
      stroke="currentColor"
      strokeWidth="2"
      strokeLinecap="round"
      strokeLinejoin="round"
      className="feather feather-home"
    >
      <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z" />
      <polyline points="9 22 9 12 15 12 15 22" />
    </svg>
  );
}

export function RetryIcon() {
  return (
    <svg
      version="1.1"
      fill="#1e2126"
      id="Capa_1"
      x="0px"
      y="0px"
      width="20px"
      viewBox="0 0 561 561"
      style={{ enableBackground: "new 0 0 561 561" }}
    >
      <g>
        <g id="loop">
          <path
            d="M280.5,76.5V0l-102,102l102,102v-76.5c84.15,0,153,68.85,153,153c0,25.5-7.65,51-17.85,71.4l38.25,38.25
                        C471.75,357,484.5,321.3,484.5,280.5C484.5,168.3,392.7,76.5,280.5,76.5z M280.5,433.5c-84.15,0-153-68.85-153-153
                        c0-25.5,7.65-51,17.85-71.4l-38.25-38.25C89.25,204,76.5,239.7,76.5,280.5c0,112.2,91.8,204,204,204V561l102-102l-102-102V433.5z"
          />
        </g>
      </g>
    </svg>
  );
}

export function GophieLogo() {
  return (
    <svg
      className="gophieLogo"
      height="30"
      fill="none"
      xmlns="http://www.w3.org/2000/svg"
      width="100%"
      viewBox="235 320 1000 140"
    >
      <g fill="#fff">
        <path
          id="gophie-logo"
          strokeDasharray="1200 1000"
          d="m337.44 444.07a107.48 107.48 0 0 1 -35.39 6.32c-17.44 0-31.8-4.44-43.09-15.21-9.91-9.58-16.07-25-16.07-42.92.17-34.36 23.77-59.5 62.41-59.5 13.33 0 23.76 2.91 28.72 5.3l-3.59 12.14c-6.16-2.73-13.85-5-25.48-5-28 0-46.33 17.44-46.33 46.34 0 29.23 17.61 46.5 44.45 46.5 9.75 0 16.42-1.37 19.84-3.08v-34.32h-23.43v-12h38z"
        />
        <path
          id="gophie-logo"
          strokeDasharray="1200 1000"
          d="m520.21 335.33a171.87 171.87 0 0 1 28.55-2.23c14.71 0 25.48 3.42 32.32 9.58 6.32 5.47 10.08 13.85 10.08 24.11 0 10.43-3.07 18.63-8.89 24.62-7.86 8.37-20.69 12.65-35.22 12.65a51 51 0 0 1 -12-1v46.14h-14.84zm14.87 55.56a49.67 49.67 0 0 0 12.31 1.2c18 0 28.9-8.72 28.9-24.62 0-15.22-10.77-22.57-27.19-22.57-6.49 0-11.45.51-14 1.2z"
        />
        <path
          id="gophie-logo"
          strokeDasharray="1200 1000"
          d="m638.87 334v48.21h55.73v-48.21h15v115.2h-15v-54h-55.73v54h-14.87v-115.2z"
        />
        <path
          id="gophie-logo"
          strokeDasharray="1200 1000"
          d="m763.16 334v115.2h-14.87v-115.2z"
        />
        <path
          id="gophie-logo"
          strokeDasharray="1200 1000"
          d="m861.65 395.17h-44.8v41.54h49.93v12.49h-64.78v-115.2h62.23v12.48h-47.38v36.42h44.8z"
        />
      </g>
      <path
        id="gophie-logo"
        strokeDasharray="1200 1000"
        d="m431.25 327.4a60.48 60.48 0 1 0 60.49 60.47 60.45 60.45 0 0 0 -60.49-60.47zm.36 8.67a14.61 14.61 0 1 1 -14.61 14.62 14.61 14.61 0 0 1 14.61-14.62zm-34.87 17.08a14.6 14.6 0 1 1 -14.59 14.6 14.59 14.59 0 0 1 14.59-14.6zm.16 67.21a14.61 14.61 0 1 1 14.59-14.62 14.63 14.63 0 0 1 -14.59 14.62zm35.1 19.75a14.6 14.6 0 1 1 14.59-14.59 14.6 14.6 0 0 1 -14.59 14.59zm-.16-33.22a18.72 18.72 0 1 1 18.71-18.71 18.73 18.73 0 0 1 -18.7 18.71zm35.16-53.58a14.61 14.61 0 1 1 -14.59 14.59 14.62 14.62 0 0 1 14.59-14.59zm.16 66.86a14.59 14.59 0 1 1 14.6-14.59 14.59 14.59 0 0 1 -14.62 14.59z"
        fill="#ffe400"
      />
      <path
        id="gophie-logo"
        strokeDasharray="1200 1000"
        d="m447.41 388.18a15.56 15.56 0 1 1 -15.56-15.59 15.56 15.56 0 0 1 15.56 15.59z"
        fill="#ffe400"
      />
      <path
        id="gophie-logo"
        strokeDasharray="1200 1000"
        d="m431.25 448.36h-90.65l8.54-5.39h71.41z"
        fill="black"
      />
    </svg>
  );
}

export function TvIcon() {
  return (
    <svg
      height="18"
      className="tvIcon"
      strokeDasharray="1200 1000"
      width="100%"
      xmlns="http://www.w3.org/2000/svg"
      viewBox="0 0 426.667 426.667"
    >
      <path
        id="gophie-tv"
        d="M213.333 106.667c-58.88 0-106.667 47.787-106.667 106.667S154.453 320 213.333 320 320 272.213 320 213.333s-47.787-106.666-106.667-106.666z"
      />
      <path
        fill="red"
        d="M213.333 0C95.467 0 0 95.467 0 213.333s95.467 213.333 213.333 213.333S426.667 331.2 426.667 213.333 331.2 0 213.333 0zm0 384c-94.293 0-170.667-76.373-170.667-170.667S119.04 42.667 213.333 42.667 384 119.04 384 213.333 307.627 384 213.333 384z"
      />
    </svg>
  );
}

export function GitMark() {
  return (
    <svg role="img" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
      <path d="M12 .297c-6.63 0-12 5.373-12 12 0 5.303 3.438 9.8 8.205 11.385.6.113.82-.258.82-.577 0-.285-.01-1.04-.015-2.04-3.338.724-4.042-1.61-4.042-1.61C4.422 18.07 3.633 17.7 3.633 17.7c-1.087-.744.084-.729.084-.729 1.205.084 1.838 1.236 1.838 1.236 1.07 1.835 2.809 1.305 3.495.998.108-.776.417-1.305.76-1.605-2.665-.3-5.466-1.332-5.466-5.93 0-1.31.465-2.38 1.235-3.22-.135-.303-.54-1.523.105-3.176 0 0 1.005-.322 3.3 1.23.96-.267 1.98-.399 3-.405 1.02.006 2.04.138 3 .405 2.28-1.552 3.285-1.23 3.285-1.23.645 1.653.24 2.873.12 3.176.765.84 1.23 1.91 1.23 3.22 0 4.61-2.805 5.625-5.475 5.92.42.36.81 1.096.81 2.22 0 1.606-.015 2.896-.015 3.286 0 .315.21.69.825.57C20.565 22.092 24 17.592 24 12.297c0-6.627-5.373-12-12-12" />
    </svg>
  );
}

export function WalkingIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xlink="http://www.w3.org/1999/xlink"
      version="1.1"
      id="Capa_1"
      x="0px"
      y="0px"
      viewBox="0 0 458.667 458.667"
      style={{ enableBackground: "new 0 0 458.667 458.667" }}
      space="preserve"
    >
      <g>
        <g>
          <g>
            <path d="M250.667,85.333c23.467,0,42.667-19.2,42.667-42.667C293.333,19.2,274.133,0,250.667,0S208,19.2,208,42.667     S227.2,85.333,250.667,85.333z" />
            <path d="M368,245.333v-42.667c-39.467,0-73.6-21.333-92.8-52.267l-20.267-34.133C247.467,103.467,233.6,96,218.667,96     c-5.333,0-10.667,1.067-16,3.2l-112,45.867v100.267h42.667v-71.467l37.333-16L112,458.667h44.8L194.133,288L240,330.667v128     h42.667V297.6l-43.733-43.733l12.8-64C279.467,224,321.067,245.333,368,245.333z" />
          </g>
        </g>
      </g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
      <g></g>
    </svg>
  );
}

export function MovieReel() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnssvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="24"
      height="24"
      x="0"
      y="0"
      viewBox="0 0 192 192"
      fill="currentColor"
      stroke="currentColor"
      xmlSpace="preserve"
    >
      <g>
        <path
          xmlns="http://www.w3.org/2000/svg"
          d="m192 96c0-53.019531-42.980469-96-96-96s-96 42.980469-96 96 42.980469 96 96 96h96v-16h-43c26.839844-17.769531 42.988281-47.808594 43-80zm-48.976562 64.722656c-10.722657 7.789063-25.734376 5.414063-33.523438-5.3125-7.789062-10.722656-5.414062-25.730468 5.308594-33.523437 10.726562-7.789063 25.734375-5.414063 33.523437 5.3125 7.792969 10.722656 5.414063 25.730469-5.308593 33.523437zm-1.179688-104.851562c12.605469-4.097656 26.144531 2.800781 30.242188 15.40625 4.09375 12.609375-2.804688 26.148437-15.410157 30.242187-12.605469 4.097657-26.144531-2.800781-30.242187-15.40625-4.09375-12.605469 2.804687-26.148437 15.410156-30.242187zm-45.84375-39.871094c13.253906 0 24 10.746094 24 24s-10.746094 24-24 24-24-10.746094-24-24 10.746094-24 24-24zm-76.085938 55.277344c4.097657-12.605469 17.636719-19.503906 30.242188-15.410156 12.605469 4.097656 19.503906 17.636718 15.410156 30.242187-4.097656 12.605469-17.636718 19.503906-30.242187 15.410156s-19.503907-17.632812-15.410157-30.242187zm62.585938 84.132812c-7.789062 10.726563-22.800781 13.101563-33.523438 5.3125-10.722656-7.792968-13.101562-22.800781-5.308593-33.523437 7.789062-10.722657 22.800781-13.101563 33.523437-5.308594 10.722656 7.789063 13.097656 22.796875 5.308594 33.519531zm5.5-59.410156c0-4.417969 3.582031-8 8-8s8 3.582031 8 8-3.582031 8-8 8-8-3.582031-8-8zm0 0"
          fill="currentColor"
          stroke="currentColor"
          data-original="#000000"
        />
      </g>
    </svg>
  );
}

export function MusicNotes() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnssvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="24"
      height="24"
      x="0"
      y="0"
      fill="currentColor"
      stroke="currentColor"
      viewBox="0 0 512 512"
      xmlSpace="preserve"
    >
      <g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g>
            <path
              d="M209.297,106.47c-27.041-19.819-54.785-44.246-74.531-73.865L117.48,6.677c-3.662-5.493-10.488-7.939-16.831-6.035    C94.321,2.561,90,8.391,90,14.998v235.344c-8.86-5.167-19.023-8.344-30-8.344c-33.091,0-60,26.909-60,60    c0,33.091,26.909,59.999,60,59.999s60-26.909,60-60V64.249c21.196,26.792,47.71,48.93,71.558,66.42    C203.276,139.253,210,152.496,210,166.997c0,24.814-20.186,45-45,45c-8.291,0-15,6.709-15,15c0,8.291,6.709,15,15,15    c41.353,0,75-33.647,75-75C240,143.193,228.53,120.576,209.297,106.47z"
              fill="currentColor"
              stroke="currentColor"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g>
            <path
              d="M492.884,122.569l-212,60c-6.445,1.846-10.884,7.734-10.884,14.429v203.344c-8.86-5.167-19.023-8.344-30-8.344    c-33.091,0-60,26.909-60,60s26.909,60,60,60s60-26.909,60-60c0-3.42,0-183.68,0-183.68l182-51.429v123.453    c-8.86-5.167-19.023-8.344-30-8.344c-33.091,0-60,26.909-60,60s26.909,60,60,60s60-26.909,60-60c0-3.42,0-255,0-255    C512,127.077,502.51,119.85,492.884,122.569z"
              fill="currentColot"
              stroke="currentColor"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
      </g>
    </svg>
  );
}

export function ExpandIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnssvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="10"
      height="10"
      x="0"
      y="0"
      viewBox="0 0 306 306"
      xmlSpace="preserve"
    >
      <g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g id="expand-more">
            <polygon
              points="270.3,58.65 153,175.95 35.7,58.65 0,94.35 153,247.35 306,94.35   "
              fill="#e7d10a"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
      </g>
    </svg>
  );
}

export function CollapseIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnssvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="10"
      height="10"
      x="0"
      y="0"
      viewBox="0 0 256 256"
      xmlSpace="preserve"
    >
      <g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g>
            <polygon
              points="79.093,0 48.907,30.187 146.72,128 48.907,225.813 79.093,256 207.093,128   "
              fill="#e7d10a"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
      </g>
    </svg>
  );
}

export function GoToIcon() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnssvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="10"
      height="10"
      x="0"
      y="0"
      viewBox="0 0 512 512"
      xmlSpace="preserve"
    >
      <g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g>
            <path
              d="M255.15,468.625H63.787c-11.737,0-21.262-9.526-21.262-21.262V64.638c0-11.737,9.526-21.262,21.262-21.262H255.15    c11.758,0,21.262-9.504,21.262-21.262S266.908,0.85,255.15,0.85H63.787C28.619,0.85,0,29.47,0,64.638v382.724    c0,35.168,28.619,63.787,63.787,63.787H255.15c11.758,0,21.262-9.504,21.262-21.262    C276.412,478.129,266.908,468.625,255.15,468.625z"
              fill="#e7d10a"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g>
            <path
              d="M505.664,240.861L376.388,113.286c-8.335-8.25-21.815-8.143-30.065,0.213s-8.165,21.815,0.213,30.065l92.385,91.173    H191.362c-11.758,0-21.262,9.504-21.262,21.262c0,11.758,9.504,21.263,21.262,21.263h247.559l-92.385,91.173    c-8.377,8.25-8.441,21.709-0.213,30.065c4.167,4.21,9.653,6.336,15.139,6.336c5.401,0,10.801-2.041,14.926-6.124l129.276-127.575    c4.04-3.997,6.336-9.441,6.336-15.139C512,250.302,509.725,244.88,505.664,240.861z"
              fill="#e7d10a"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
      </g>
    </svg>
  );
}

export function SadFace() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnssvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="50"
      height="50"
      x="0"
      y="0"
      viewBox="0 0 46.47 46.47"
      xmlSpace="preserve"
      className=""
    >
      <g>
        <g xmlns="http://www.w3.org/2000/svg">
          <path
            d="M46.222,41.889c0.658,1.521-0.042,3.287-1.562,3.943c-1.521,0.66-3.286-0.041-3.944-1.562   c-2.893-6.689-9.73-11.012-17.421-11.012c-7.868,0-14.747,4.32-17.523,11.004C5.292,45.416,4.175,46.112,3,46.112   c-0.384,0-0.773-0.073-1.15-0.229c-1.53-0.637-2.255-2.393-1.62-3.922c3.71-8.932,12.764-14.703,23.064-14.703   C33.379,27.26,42.379,33.002,46.222,41.889z M2.445,6.559c0-3.423,2.777-6.201,6.201-6.201c3.423,0,6.2,2.777,6.2,6.201   c0,3.426-2.777,6.203-6.2,6.203C5.222,12.761,2.445,9.984,2.445,6.559z M30.562,6.559c0-3.423,2.779-6.201,6.203-6.201   c3.423,0,6.2,2.777,6.2,6.201c0,3.426-2.776,6.203-6.2,6.203S30.562,9.984,30.562,6.559z"
            fill="#e7d10a"
            data-original="#000000"
            className=""
          />
        </g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
      </g>
    </svg>
  );
}

export function Beaver() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnsSvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="50"
      height="50"
      x="0"
      y="0"
      viewBox="0 0 412.232 412.231"
      xmlSpace="preserve"
      className=""
    >
      <g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g>
            <path
              d="M138.553,137.994c0-18.063-14.698-32.764-32.764-32.764c-18.065,0-32.756,14.691-32.756,32.764    c0,18.062,14.691,32.757,32.756,32.757C123.855,170.751,138.553,156.055,138.553,137.994z M105.784,154.624    c-2.005,0-3.909-0.415-5.688-1.063c10.724-0.844,19.217-9.735,19.217-20.669c0-1.919-0.343-3.746-0.834-5.509    c2.425,2.892,3.943,6.57,3.943,10.627C122.428,147.165,114.96,154.624,105.784,154.624z M103.188,132.887    c0,2.59-2.118,4.708-4.715,4.708c-2.595,0-4.708-2.118-4.708-4.708c0-2.597,2.113-4.714,4.708-4.714    C101.07,128.172,103.188,130.29,103.188,132.887z"
              fill="#e7d10a"
              data-original="#000000"
            />
            <path
              d="M267.153,137.994c0,18.055,14.688,32.757,32.757,32.757c18.075,0,32.756-14.691,32.756-32.757    c0-18.068-14.681-32.764-32.756-32.764C281.841,105.229,267.153,119.931,267.153,137.994z M287.889,132.887    c0-2.597,2.114-4.714,4.713-4.714c2.595,0,4.704,2.118,4.704,4.714c0,2.59-2.109,4.708-4.704,4.708    C289.999,137.595,287.889,135.477,287.889,132.887z M299.91,154.624c-2.005,0-3.905-0.415-5.689-1.063    c10.729-0.844,19.212-9.735,19.212-20.669c0-1.919-0.346-3.746-0.828-5.514c2.424,2.892,3.937,6.57,3.937,10.626    C316.541,147.165,309.085,154.624,299.91,154.624z"
              fill="#e7d10a"
              data-original="#000000"
            />
            <path
              d="M404.179,161.821h-3.218c-3.088-36.439-26.826-67.03-59.456-80.059c-29.774-42.891-79.334-71.053-135.389-71.053    c-56.048,0-105.616,28.155-135.391,71.048c-32.627,13.029-56.36,43.614-59.446,80.064H8.063c-4.449,0-8.063,3.614-8.063,8.062    c0,4.452,3.615,8.063,8.063,8.063h3.216c2.483,29.331,18.299,54.916,41.412,70.575l22.84,146.17    c0.612,3.927,3.995,6.83,7.966,6.83h60.462c4.452,0,8.063-3.612,8.063-8.063c0-29.831,24.271-54.094,54.093-54.094    c29.824,0,54.092,24.276,54.092,54.094c0,4.451,3.612,8.063,8.063,8.063h60.462c3.963,0,7.349-2.898,7.954-6.83l22.845-146.17    c23.118-15.664,38.931-41.244,41.408-70.575h3.228c4.436,0,8.063-3.611,8.063-8.063    C412.232,165.435,408.625,161.821,404.179,161.821z M41.376,175.459c0,0.414,0.031,0.834,0.097,1.236l7.428,47.549    c-13.53-14.151-21.897-33.281-21.897-54.36c0-24.176,10.965-45.819,28.155-60.284C46.311,129.785,41.376,152.044,41.376,175.459z     M105.784,248.676c-13.906,0-26.958-3.659-38.31-10.001l-9.977-63.833c0.118-29.378,8.842-56.744,23.723-79.778    c7.74-2.545,15.979-3.971,24.564-3.971c43.449,0,78.793,35.341,78.793,78.791C184.583,213.326,149.233,248.676,105.784,248.676z     M248.34,285.71h-45.983c-4.448,0-8.062-3.617-8.062-8.063c0-4.451,3.614-8.063,8.062-8.063h45.983    c4.451,0,8.063,3.612,8.063,8.063C256.404,282.093,252.796,285.71,248.34,285.71z M344.761,238.675    c-11.345,6.357-24.41,10.001-38.31,10.001c-43.456,0-78.795-35.35-78.795-78.792c0-43.449,35.339-78.791,78.795-78.791    c8.583,0,16.818,1.431,24.557,3.971c14.886,23.035,23.611,50.4,23.726,79.778L344.761,238.675z M363.343,224.244l7.424-47.549    c0.067-0.401,0.099-0.822,0.099-1.236c0-23.41-4.934-45.675-13.779-65.859c17.197,14.459,28.169,36.108,28.169,60.284    C385.245,190.963,376.873,210.093,363.343,224.244z"
              fill="#e7d10a"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
      </g>
    </svg>
  );
}

export function ArrowUp() {
  return (
    <svg
      xmlns="http://www.w3.org/2000/svg"
      xmlnsXlink="http://www.w3.org/1999/xlink"
      xmlnsSvgjs="http://svgjs.com/svgjs"
      version="1.1"
      width="20"
      height="20"
      x="0"
      y="0"
      viewBox="0 0 512.005 512.005"
      xmlSpace="preserve"
    >
      <g>
        <g xmlns="http://www.w3.org/2000/svg">
          <g>
            <path
              d="M466.22,205.787L263.553,3.12c-4.16-4.16-10.923-4.16-15.083,0L45.804,205.787c-21.803,21.803-21.803,57.28,0,79.083    s57.28,21.803,79.083,0l77.781-77.781v251.584c0,29.397,23.936,53.333,53.333,53.333s53.333-23.936,53.333-53.333V207.088    l77.781,77.781c21.803,21.803,57.28,21.803,79.083,0C488.001,263.088,488.001,227.589,466.22,205.787z"
              fill="#e7d10a"
              data-original="#000000"
            />
          </g>
        </g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
        <g xmlns="http://www.w3.org/2000/svg"></g>
      </g>
    </svg>
  );
}

// export function ShareIcon() {
//   return (
//     <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 448 512">
//       <path d="M352 320c-22.608 0-43.387 7.819-59.79 20.895l-102.486-64.054a96.551 96.551 0 0 0 0-41.683l102.486-64.054C308.613 184.181 329.392 192 352 192c53.019 0 96-42.981 96-96S405.019 0 352 0s-96 42.981-96 96c0 7.158.79 14.13 2.276 20.841L155.79 180.895C139.387 167.819 118.608 160 96 160c-53.019 0-96 42.981-96 96s42.981 96 96 96c22.608 0 43.387-7.819 59.79-20.895l102.486 64.054A96.301 96.301 0 0 0 256 416c0 53.019 42.981 96 96 96s96-42.981 96-96-42.981-96-96-96z" />
//     </svg>
//   );
// }
