# UserControls
Relatively simple WinForms user controls for VB or C# projects.

# Screenshots

![All User Controls](screenshots/All%20User%20Controls.png?raw=true)

![Oval Shapes](screenshots/Oval%20Shapes.png?raw=true)

![Rotating Text Button](screenshots/Rotating%20Text%20Button.png?raw=true)

# Functionality
- ButtonControlArray
  - an array of Button controls where each button's click event can be associated with a different action.
  - actions are defined in the code.
- MyOvalShape
  - an oval shape control which could be manipulated to look as an LED light or just a decoration on the form.
  - allows for the Arc and Pie fill shapes to have symmetry and rotate (animation).
  - boolean switchable colors of the outer ring and the fill.
- MyRectangleShape
  - somewhat similar to the oval shape control but in rectangular form.
- RotatingImage1
  - a control that allows an image be rotated and/or flipped while being fully visible (no cut corners).
  - middle-center anchor point for image rotation.
  - fixed aspect ratio.
- RotatingImage2
  - a control that allows an image be rotated and/or flipped (with cut corners).
  - allows 9 different anchor points for image rotation.
  - fixed or free aspect ratio.
  - intended for special images.
- RotatingTextButton
  - a button control allowing horizontal, vertical and upside down text.
  - certain fonts will show as symbols.
- RotationalPositionIndicator
  - a control to indicate rotational position/angle.
  - could potentially be used as a weather vane.
  - zero/home position could be selected as either of E (0), N (90), W (180) or S (270).

Check the screenshots for possible visual appearances of each control.
Read any comments present within the control's code.

# Usage
- Download and extract the zip file of this repository.
- In your project, either use the project itself or create a new folder, right-click it and add controls as Existing Items, rebuild the solution and locate these in the Toolbox.

# Licensing
These are all licensed under MIT License.

# Trademarks
Any and all trademarks, either directly or indirectly mentioned in any of the controls, belong to their respective owners.

# Useful Resources
The AdvancedHMI website [forum](https://www.advancedhmi.com/forum/), which is another open source project providing a large number of user controls including a special version of all the controls included in this repository.
