# 测试文档

## Abstract

此文档主要测试主要后端接口，如测试功能可以阅读使用说明或直接访问链接[学生选课系统](http://www.gendml.cn:9000)

## 一、登录

```http
POST http://localhost:9000/{登陆者身份}/login?account={管理员id}&password={密码}
```

- 响应体部分的message是uuid生成的字符串作为**登录token**，验证用户是否处于登陆状态

## 二、注册（学生）

```http
POST http://localhost:9000/student/register?Sid={学号}&Spassword={密码}&Sname={姓名}&Ssex={性别}&Sidcard={身份证号}&Sgrade={年级}&Sinstitution={学院}
```

## 三、学生表

### （一）删除

```http
POST http://localhost:9000/deleteStudent?Sid={学号}
```

```json
###
POST http://localhost:9000/deleteStudent?Sid=19114731
```

### （二）更新

```http
POST http://localhost:9000/updateStudent?{Student实体}
```

```json
###
POST http://localhost:9000/student/updateStudent?{Student对应的各个字段}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （三）分页查询

```http
POST http://localhost:9000/student/getPageStudent/{当前页数}/{每一页学生数量}
```

```json
###
POST http://localhost:9000/student/getPageStudent/1/3
```

### （四）单个查询

```http
GET http://localhost:9000/getOneStudent/{学号}
```

```json
###
GET http://localhost:9000/student/getOneStudent/19114731
```

### （五）选课

```json
POST http://localhost:9000/insertCoursePlan?{CoursePlan实体}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （六）查询课表

```http
GET http://localhost:9000/getSchedule/{学号}
```

```json
###
GET http://localhost:9000/getSchedule/19114731
```

### （七）查成绩

```http
GET http://localhost:9000/getGrade/{学号}
```

```json
GET http://localhost:9000/student/getGrade/19114731
```

## 四、教师表

### （一）插入课程

```json
POST http://localhost:9000/teacher/insertCourse?{Course实体}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （二）删除课程

```json
POST http://localhost:9000/teacher/deleteCourse?Cid={课程号}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （三）更新课程

```json
POST http://localhost:9000/teacher/updateCourse?{Course实体}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （四）模糊查询课程

```json
GET http://localhost:9000/teacher/getCourse/{课程号}
```

### （五）查询单个课程

```json
GET http://localhost:9000/teacher/getOneCourse/{课程号}
```

### （六）分页查询课程

```json
GET http://localhost:9000/teacher/getPageCourse/{当前页数}/{每页大小}
```

### （七）新增教师

```json
POST http://localhost:9000/teacher/insertTeacher?{Teacher实体}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （八）删除教师

```json
POST http://localhost:9000/teacher/deleteTeacher?Tid={教师工号}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （九）更新教师信息

```json
POST http://localhost:9000/teacher/updateTeacher?{Teacher实体}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

### （十）查成绩

```json
GET http://localhost:9000/teacher/queryGrade/{教师工号}/{课程号}
```



### （...）更多见后端Controller

## 五、管理员

### （一）获取学生、教师、管理员、课程数量

```json
###
POST http://localhost:9000/getNumInfo

{
  "code": 200,
  "data": {
    "courseNum": 9,
    "teacherNum": 8,
    "adminNum": 1,
    "studentNum": 4
  },
  "message": "成功"
}
```

### （二）查询院系

```json
GET http://localhost:9000/queryFaculity

{
  "code": 200,
  "data": [
    {
      "fname": "信息与计算机学院"
    },
    {
      "fname": "外国语学院"
    },
    {
      "fname": "理学院"
    },
    {
      "fname": "植物保护学院"
    },
    {
      "fname": "动科院"
    },
    {
      "fname": "资源与环境学院"
    }
  ],
  "message": "成功"
}
```

### （三）新增院系

```json
POST http://localhost:9000/insertFaculity?faculityName={院系名称}

{
  "code": 200,
  "data": null,
  "message": "成功"
}
```

