/*
 * Copyright (c) 2022. Gavin Pease and contributors.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software and
 * associated documentation files (the "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is furnished to do so, subject to the
 * following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or substantial
 * portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
 * INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR
 * PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT
 * OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 */

using BlogSite.Models;
using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Identity;
using Microsoft.AspNetCore.Mvc;

namespace BlogSite.Controllers;

[Authorize(Roles = "Admin")]
public class AdminController : Controller
{
    private readonly IConfiguration _config;
    private readonly UserManager<Poster> _userManager;
    private readonly ILogger<AdminController> _logger;

    public AdminController(IConfiguration config, UserManager<Poster> userManager, ILogger<AdminController> logger)
    {
        _config = config;
        _userManager = userManager;
        _logger = logger;
    }

    [HttpGet]
    public IActionResult Index()
    {
        return View();
    }

    // role change post
    [HttpPost]
    public async Task<IActionResult> UpdateRole(string userId, string role, string add_remove)
    {
        var user = await _userManager.FindByIdAsync(userId);
        if (user == null)
        {
            _logger.LogError($"User with id {userId} not found");
            return Ok(new { success = false, message = $"User with ID = {userId} cannot be found" });
        }

        if (add_remove == "add")
        {
            await _userManager.AddToRoleAsync(user, role);
        }
        else
        {
            await _userManager.RemoveFromRoleAsync(user, role);
        }

        _logger.Log(LogLevel.Information, $"User {user.UserName} added to {role}");
        return Ok(new { success = true, message = "Role updated successfully" });
    }
}