### Contributing Guidelines:

1. Please read the contributing guidelines XD

2. These are the ways you can contribute to this repository:
* Adding simple encryption/decryption algorithms in the form of a .py file
* Adding other tool algorithms in the form of a .py file (please check all tools from [dcode.fr](https://dcode.fr/en/))
* Optimising algorithms
* Enhancing the UI/UX by using tkinter in Python3
* Adding widgets using tkinter in Python3
* Adding animations
* Introducing a dark-light mode toggle switch
* Designing a logo for ENCODN
* Checking if the current version of ENCODN.py and sample1.png match and making corresponding edits in README.md and updating sample1.png (pick a blank issue template for this)
* Suggestions to the maintainers (pick a blank issue template for this)

3. Please pick an issue template that best suits the kind of contribution you wish to make, edit it according to the instructions given in it and then raise it. But please do check if the issue previously exists or not.

4. If you see a issue already created, that you think you can resolve, comment on it and ask the maintainers to assign it to you. We will be more than glad to do so :)

5. Commit message should be of the stated syntax. Use only absolute verbs like **Create, Update, etc and no past or future tenses like creating/created.**

6. Add comments to codes. This increases readability. However do not raise issues or PRs only to add comments.

7. When naming the functions or variables use meaningful names instead of random names. Preferrably, refer to similar files to get and idea. Also **name buttons and frames according to the instructions given in issue templates.**

8. Every PR would be reviewed before it gets merged. If there is any conflict, please be patient until you resolve it with the maintainers.
