### DiseaseAi - README

---

### Introduction

Welcome to **DiseaseAi**, a cutting-edge platform designed to provide concise and accurate information about various diseases. Leveraging advanced technologies, Disease.Ai aims to revolutionize the way users access and understand medical information.

### Key Technologies

**DiseaseAi** utilizes the following technologies:
- **Streamlit**: For seamless and interactive hosting.
- **Pinecone**: A vector database ensuring efficient data matching.
- **Gemini 1.5 Flash**: To generate precise and contextually relevant outputs.
- **aspire/acge_text_embedding**: A sentence transformer model for high-quality embeddings.
- **LangChain**: For robust and coherent language processing.
- **deep-translator**: For language translation.
- **gTTs**: For converting text to speech, allowing users to listen to information.

### Features

- **User Input**: Users can input symptoms or disease names to receive brief descriptions, symptoms, and medication options.
- **Speed and Accuracy**: Optimized for rapid data retrieval and presentation, ensuring users get the information they need quickly and accurately.
- **Language Translation**: Convert disease information to Hindi and other languages.
- **Audio Output**: Listen to the information for better accessibility.

### Future Improvements

- **Healthcare System Integration**: Plans to integrate with healthcare systems for real-time updates.
- **Data Expansion**: Adding more diseases and comprehensive medical data to the platform.
- **Enhanced Accuracy**: Continuous efforts to improve data accuracy and response quality.
- **Performance Optimization**: Further optimizing processing speed for a better user experience.

### Screenshots

[Screenshot 1](https://ibb.co/0Dt7FPf)
[Screenshot 2](https://ibb.co/sKVnSft)

### Flow Graph

[Flow Graph](https://ibb.co/yYyfVJR)

### How to Use

1. **Clone the Repository**:
   ```bash
   git clone https://github.com/FurkanKhann/DiseaseAi.git
   ```
2. **Install Dependencies**:
   ```bash
   pip install -r requirements.txt
   ```
3. **Run the Application**:
   ```bash
   streamlit run main.py
   ```

### Contribution

We welcome contributions from the community. Feel free to open issues or submit pull requests to help us improve Disease.Ai.

### Contact

For more information, please contact:
- **Email**: khanfurkan575@gmail.com
- **GitHub**: [FurkanKhann](https://github.com/FurkanKhann)
- **LinkedIn**: [Furkan Khan](https://www.linkedin.com/in/furkankhan16/)

---

Join us on this journey to make accurate and reliable medical knowledge easily accessible for everyone!
