<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class LanguagePacksTableSeeder extends Seeder
{
    /**
     * Fresns seed file.
     */
    public function run(): void
    {
        DB::table('language_packs')->delete();

        DB::table('language_packs')->insert([
            [
                'lang_key' => 'language',
                'lang_values' => '{"en":"Language","zh-Hans":"语言","zh-Hant":"語言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'appearance',
                'lang_values' => '{"en":"Appearance","zh-Hans":"外观","zh-Hant":"外貌"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'switchLanguage',
                'lang_values' => '{"en":"Switch Language","zh-Hans":"切换语言","zh-Hant":"切換語言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'switchUser',
                'lang_values' => '{"en":"Switch user","zh-Hans":"切换用户","zh-Hant":"切換使用者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'admin',
                'lang_values' => '{"en":"Administrator","zh-Hans":"管理员","zh-Hant":"管理員"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'sitePrivate',
                'lang_values' => '{"en":"Site Private","zh-Hans":"站点私有模式","zh-Hant":"站點私有模式"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'sitePrivateDesc',
                'lang_values' => '{"en":"Introduction to the private model","zh-Hans":"私有模式介绍","zh-Hant":"私有模式介紹"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'checkVersion',
                'lang_values' => '{"en":"Check for Updates","zh-Hans":"检查更新","zh-Hant":"檢查更新"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'isLatestVersion',
                'lang_values' => '{"en":"Currently the latest version","zh-Hans":"当前已是最新版本","zh-Hant":"當前已是最新版本"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'useApp',
                'lang_values' => '{"en":"Use App","zh-Hans":"使用 App","zh-Hant":"使用 App"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'downloadApp',
                'lang_values' => '{"en":"Download App","zh-Hans":"下载 App","zh-Hant":"下載 App"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'openApp',
                'lang_values' => '{"en":"Open the app","zh-Hans":"打开应用","zh-Hant":"開啟應用程式"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'reviewApp',
                'lang_values' => '{"en":"Review App","zh-Hans":"评价 App","zh-Hant":"評價 App"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'upgradeApp',
                'lang_values' => '{"en":"Upgrade Now","zh-Hans":"立即升级","zh-Hant":"立即升級"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorUnknown',
                'lang_values' => '{"en":"Unknown Error","zh-Hans":"未知错误","zh-Hant":"未知錯誤"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorEmpty',
                'lang_values' => '{"en":"Cannot be empty","zh-Hans":"不能为空","zh-Hant":"不能為空"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorNotExist',
                'lang_values' => '{"en":"Does not exist","zh-Hans":"不存在","zh-Hant":"不存在"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorNotMatch',
                'lang_values' => '{"en":"You two input do not match","zh-Hans":"两次输入不一致","zh-Hant":"兩次輸入不一致"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorNoInfo',
                'lang_values' => '{"en":"Get info failed","zh-Hans":"无法获得信息","zh-Hant":"無法獲得資訊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorNoLogin',
                'lang_values' => '{"en":"Unable to operate without login","zh-Hans":"未登录无法操作","zh-Hant":"未登入無法操作"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorTimeout',
                'lang_values' => '{"en":"Timeout","zh-Hans":"服务超时","zh-Hant":"服務超時"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorRejection',
                'lang_values' => '{"en":"Service Rejected","zh-Hans":"服务被拒绝","zh-Hant":"服務被拒絕"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorUnavailable',
                'lang_values' => '{"en":"Temporarily Unavailable","zh-Hans":"暂时无法使用","zh-Hant":"暫時無法使用"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorIpLocation',
                'lang_values' => '{"en":"The IP location is unknown","zh-Hans":"IP 属地未知","zh-Hant":"IP 屬地未知"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'errorGetLocation',
                'lang_values' => '{"en":"Your device does not support location or refuses authorization","zh-Hans":"您的设备不支持定位或者拒绝授权","zh-Hant":"您的設備不支援定位或拒絕授權"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'inProgress',
                'lang_values' => '{"en":"In Progress...","zh-Hans":"处理中...","zh-Hant":"處理中..."}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'loading',
                'lang_values' => '{"en":"Loading...","zh-Hans":"数据加载中...","zh-Hant":"資料加載中..."}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'loadMore',
                'lang_values' => '{"en":"Load More","zh-Hans":"加载更多","zh-Hant":"加載更多"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'clickToLoadMore',
                'lang_values' => '{"en":"Click to load more","zh-Hans":"点击加载更多","zh-Hant":"點擊加載更多"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'scrollUpToLoadMore',
                'lang_values' => '{"en":"Scroll up to load more","zh-Hans":"上滑加载更多","zh-Hant":"上滑加載更多"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'scrollDownToLoadMore',
                'lang_values' => '{"en":"Scroll down to load more","zh-Hans":"下滑加载更多","zh-Hant":"下滑加載更多"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'pullDownRefresh',
                'lang_values' => '{"en":"Pull down to refresh","zh-Hans":"下拉刷新","zh-Hant":"下拉刷新"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'releaseToRefresh',
                'lang_values' => '{"en":"Release to refresh","zh-Hans":"松手刷新","zh-Hant":"放手刷新"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'refreshing',
                'lang_values' => '{"en":"Refreshing...","zh-Hans":"正在刷新","zh-Hant":"正在刷新"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'refreshDone',
                'lang_values' => '{"en":"Refresh done","zh-Hans":"刷新完成","zh-Hant":"刷新完成"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'executionDate',
                'lang_values' => '{"en":"Execution Date","zh-Hans":"执行日期","zh-Hant":"執行日期"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'getLocation',
                'lang_values' => '{"en":"Get Location","zh-Hans":"获取定位","zh-Hant":"獲取定位"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'reloadLocation',
                'lang_values' => '{"en":"Reload Location","zh-Hans":"重新定位","zh-Hant":"重新定位"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'locationLoading',
                'lang_values' => '{"en":"Location Loading...","zh-Hans":"正在定位...","zh-Hant":"正在定位..."}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'newPosts',
                'lang_values' => '{"en":"New posts","zh-Hans":"新帖子","zh-Hant":"新貼文"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'newComments',
                'lang_values' => '{"en":"New comments","zh-Hans":"新评论","zh-Hant":"新留言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'showMorePosts',
                'lang_values' => '{"en":"Show more posts","zh-Hans":"显示更多帖子","zh-Hant":"顯示更多貼文"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'showMoreComments',
                'lang_values' => '{"en":"Show more comments","zh-Hans":"显示更多评论","zh-Hant":"顯示更多留言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'listEmpty',
                'lang_values' => '{"en":"The list is empty, no content at the moment.","zh-Hans":"列表为空，暂无内容","zh-Hant":"清單為空，暫無內容"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'listWithoutPage',
                'lang_values' => '{"en":"No More","zh-Hans":"没有了","zh-Hant":"沒有了"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'whoSeesThis',
                'lang_values' => '{"en":"Who sees this?","zh-Hans":"谁可以看到？","zh-Hant":"誰可以看到？"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'whoCanReply',
                'lang_values' => '{"en":"Who can reply?","zh-Hans":"谁可以回复？","zh-Hant":"誰可以留言？"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'ok',
                'lang_values' => '{"en":"Ok","zh-Hans":"好","zh-Hant":"好"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'yes',
                'lang_values' => '{"en":"Yes","zh-Hans":"是","zh-Hant":"是"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'no',
                'lang_values' => '{"en":"No","zh-Hans":"否","zh-Hant":"否"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'allow',
                'lang_values' => '{"en":"Allow","zh-Hans":"允许","zh-Hant":"允許"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notAllow',
                'lang_values' => '{"en":"Don\'t Allow","zh-Hans":"不允许","zh-Hant":"不允許"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'success',
                'lang_values' => '{"en":"Success","zh-Hans":"成功","zh-Hant":"成功"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'failed',
                'lang_values' => '{"en":"Failed","zh-Hans":"失败","zh-Hant":"失敗"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'warning',
                'lang_values' => '{"en":"Warning","zh-Hans":"警告","zh-Hant":"警告"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'danger',
                'lang_values' => '{"en":"Danger","zh-Hans":"危险","zh-Hant":"危險"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'tip',
                'lang_values' => '{"en":"Tip","zh-Hans":"提示","zh-Hant":"提示"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'light',
                'lang_values' => '{"en":"Light","zh-Hans":"浅色","zh-Hant":"淺色"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'dark',
                'lang_values' => '{"en":"Dark","zh-Hans":"深色","zh-Hant":"深色"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'setting',
                'lang_values' => '{"en":"Setting","zh-Hans":"设置","zh-Hant":"設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'config',
                'lang_values' => '{"en":"Configuration","zh-Hans":"配置","zh-Hant":"配置"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'manage',
                'lang_values' => '{"en":"Manage","zh-Hans":"管理","zh-Hant":"管理"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'reset',
                'lang_values' => '{"en":"Reset","zh-Hans":"重置","zh-Hant":"重置"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'refresh',
                'lang_values' => '{"en":"Refresh","zh-Hans":"刷新","zh-Hant":"刷新"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'reload',
                'lang_values' => '{"en":"Reload","zh-Hans":"重新载入","zh-Hant":"重新載入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'retry',
                'lang_values' => '{"en":"Retry","zh-Hans":"重试","zh-Hant":"重試"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'reselect',
                'lang_values' => '{"en":"Reselect","zh-Hans":"重选","zh-Hant":"重選"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'automatic',
                'lang_values' => '{"en":"Automatic","zh-Hans":"自动","zh-Hant":"自動"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'default',
                'lang_values' => '{"en":"Default","zh-Hans":"默认","zh-Hant":"預設"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modify',
                'lang_values' => '{"en":"Modify","zh-Hans":"修改","zh-Hant":"修改"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'edit',
                'lang_values' => '{"en":"Edit","zh-Hans":"编辑","zh-Hant":"編輯"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'delete',
                'lang_values' => '{"en":"Delete","zh-Hans":"删除","zh-Hant":"刪除"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'add',
                'lang_values' => '{"en":"Add","zh-Hans":"新增","zh-Hant":"新增"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'remove',
                'lang_values' => '{"en":"Remove","zh-Hans":"移除","zh-Hant":"移除"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'previous',
                'lang_values' => '{"en":"Previous","zh-Hans":"上一步","zh-Hant":"上一步"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'next',
                'lang_values' => '{"en":"Next","zh-Hans":"下一步","zh-Hant":"下一步"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'previousPage',
                'lang_values' => '{"en":"Previous Page","zh-Hans":"上一页","zh-Hant":"上一頁"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'nextPage',
                'lang_values' => '{"en":"Next Page","zh-Hans":"下一页","zh-Hant":"下一頁"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'return',
                'lang_values' => '{"en":"Return","zh-Hans":"返回","zh-Hant":"返回"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'close',
                'lang_values' => '{"en":"Close","zh-Hans":"关闭","zh-Hant":"關閉"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'cancel',
                'lang_values' => '{"en":"Cancel","zh-Hans":"取消","zh-Hant":"取消"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'dismiss',
                'lang_values' => '{"en":"Dismiss","zh-Hans":"驳回","zh-Hant":"駁回"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'leave',
                'lang_values' => '{"en":"Leave","zh-Hans":"退出","zh-Hant":"退出"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'activate',
                'lang_values' => '{"en":"Activate","zh-Hans":"启用","zh-Hant":"啟用"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'deactivate',
                'lang_values' => '{"en":"Deactivate","zh-Hans":"停用","zh-Hant":"停用"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'status',
                'lang_values' => '{"en":"Status","zh-Hans":"状态","zh-Hant":"狀態"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'download',
                'lang_values' => '{"en":"Download","zh-Hans":"下载","zh-Hant":"下載"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'install',
                'lang_values' => '{"en":"Install","zh-Hans":"安装","zh-Hant":"安裝"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uninstall',
                'lang_values' => '{"en":"Uninstall","zh-Hans":"卸载","zh-Hant":"解除安裝"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'check',
                'lang_values' => '{"en":"Check","zh-Hans":"验证","zh-Hant":"驗證"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'done',
                'lang_values' => '{"en":"Done","zh-Hans":"完成","zh-Hant":"完成"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'search',
                'lang_values' => '{"en":"Search","zh-Hans":"搜索","zh-Hant":"搜尋"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'location',
                'lang_values' => '{"en":"Location","zh-Hans":"位置","zh-Hant":"位置"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'select',
                'lang_values' => '{"en":"Choose","zh-Hans":"选择","zh-Hant":"選擇"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'required',
                'lang_values' => '{"en":"Required","zh-Hans":"必填","zh-Hant":"必填"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optional',
                'lang_values' => '{"en":"Optional","zh-Hans":"选填","zh-Hant":"選填"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'update',
                'lang_values' => '{"en":"Update","zh-Hans":"更新","zh-Hant":"更新"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'recall',
                'lang_values' => '{"en":"Recall","zh-Hans":"撤回","zh-Hant":"撤回"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'submit',
                'lang_values' => '{"en":"Submit","zh-Hans":"提交","zh-Hant":"提交"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'save',
                'lang_values' => '{"en":"Save","zh-Hans":"保存","zh-Hant":"儲存"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'saveChanges',
                'lang_values' => '{"en":"Save Changes","zh-Hans":"保存更改","zh-Hant":"儲存變更"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'confirm',
                'lang_values' => '{"en":"Confirm","zh-Hans":"确认","zh-Hant":"確認"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'agree',
                'lang_values' => '{"en":"Agree","zh-Hans":"同意","zh-Hant":"同意"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'agreeAuth',
                'lang_values' => '{"en":"Agree to Authorization","zh-Hans":"同意授权","zh-Hant":"同意授權"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'disagree',
                'lang_values' => '{"en":"Disagree","zh-Hans":"不同意","zh-Hant":"不同意"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'know',
                'lang_values' => '{"en":"Got it","zh-Hans":"知道了","zh-Hant":"知道了"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'send',
                'lang_values' => '{"en":"Send","zh-Hans":"发送","zh-Hant":"傳送"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'sortOrder',
                'lang_values' => '{"en":"Sort Order","zh-Hans":"排序","zh-Hant":"排序"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'displayType',
                'lang_values' => '{"en":"Display Type","zh-Hans":"显示方式","zh-Hant":"顯示方式"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'type',
                'lang_values' => '{"en":"Type","zh-Hans":"类型","zh-Hant":"類型"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'view',
                'lang_values' => '{"en":"View","zh-Hans":"查看","zh-Hant":"查看"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'show',
                'lang_values' => '{"en":"Show","zh-Hans":"显示","zh-Hant":"顯示"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'more',
                'lang_values' => '{"en":"More","zh-Hans":"更多","zh-Hant":"更多"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'learnMore',
                'lang_values' => '{"en":"Learn More","zh-Hans":"了解详情","zh-Hant":"了解詳情"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'repost',
                'lang_values' => '{"en":"Repost","zh-Hans":"转发","zh-Hant":"轉發"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'quote',
                'lang_values' => '{"en":"Quote","zh-Hans":"引用","zh-Hant":"引用"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'share',
                'lang_values' => '{"en":"Share","zh-Hans":"分享","zh-Hant":"分享"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'shareMessage',
                'lang_values' => '{"en":"Share with a friend","zh-Hans":"发送给朋友","zh-Hant":"發送給朋友"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'sharePoster',
                'lang_values' => '{"en":"Generate share poster","zh-Hans":"生成分享图","zh-Hant":"產生分享圖"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'pleaseEnter',
                'lang_values' => '{"en":"Please enter","zh-Hans":"请输入","zh-Hant":"請輸入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'copyLink',
                'lang_values' => '{"en":"Copy Link","zh-Hans":"复制链接","zh-Hant":"複製連結"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'copySuccess',
                'lang_values' => '{"en":"Copy Success","zh-Hans":"复制成功","zh-Hant":"複製成功"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'home',
                'lang_values' => '{"en":"Home","zh-Hans":"首页","zh-Hant":"首頁"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'discover',
                'lang_values' => '{"en":"Discover","zh-Hans":"发现","zh-Hant":"發現"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'me',
                'lang_values' => '{"en":"Me","zh-Hans":"我的","zh-Hant":"我的"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'about',
                'lang_values' => '{"en":"About","zh-Hans":"关于","zh-Hant":"關於"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'she',
                'lang_values' => '{"en":"She","zh-Hans":"她","zh-Hant":"她"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'he',
                'lang_values' => '{"en":"He","zh-Hans":"他","zh-Hant":"他"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'they',
                'lang_values' => '{"en":"They","zh-Hans":"TA","zh-Hant":"TA"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'file',
                'lang_values' => '{"en":"File","zh-Hans":"文件","zh-Hant":"文件"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'image',
                'lang_values' => '{"en":"Image","zh-Hans":"图片","zh-Hant":"圖片"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'video',
                'lang_values' => '{"en":"Video","zh-Hans":"视频","zh-Hant":"影片"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'audio',
                'lang_values' => '{"en":"Audio","zh-Hans":"音频","zh-Hant":"音訊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'document',
                'lang_values' => '{"en":"Document","zh-Hans":"文档","zh-Hant":"文件"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'list',
                'lang_values' => '{"en":"List","zh-Hans":"列表","zh-Hant":"清單"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierCount',
                'lang_values' => '{"en":"Total","zh-Hans":"共","zh-Hant":"共"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierOr',
                'lang_values' => '{"en":"or","zh-Hans":"或者","zh-Hant":"或者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierCompleted',
                'lang_values' => '{"en":"Now","zh-Hans":"已","zh-Hant":"已"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierYear',
                'lang_values' => '{"en":"Year","zh-Hans":"年","zh-Hant":"年"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierMonth',
                'lang_values' => '{"en":"Month","zh-Hans":"月","zh-Hant":"月"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierDay',
                'lang_values' => '{"en":"Day","zh-Hans":"日","zh-Hant":"日"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierDays',
                'lang_values' => '{"en":"Days","zh-Hans":"天","zh-Hant":"天"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'modifierLength',
                'lang_values' => '{"en":"Length","zh-Hans":"长度","zh-Hant":"長度"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitSecond',
                'lang_values' => '{"en":"Second","zh-Hans":"秒","zh-Hant":"秒"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitMinute',
                'lang_values' => '{"en":"Minute","zh-Hans":"分钟","zh-Hant":"分鐘"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitWithinMinute',
                'lang_values' => '{"en":"Within Minute","zh-Hans":"分钟以内","zh-Hant":"分鐘以內"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitCharacter',
                'lang_values' => '{"en":"Character","zh-Hans":"字符","zh-Hant":"字元"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitNumber',
                'lang_values' => '{"en":"Number","zh-Hans":"个数","zh-Hant":"個數"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitNumberOfTimes',
                'lang_values' => '{"en":"Number of times","zh-Hans":"次数","zh-Hant":"次數"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitWordCount',
                'lang_values' => '{"en":"Word Count","zh-Hans":"字数","zh-Hant":"字數"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitKm',
                'lang_values' => '{"en":"Kilometer","zh-Hans":"公里","zh-Hant":"公里"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'unitMi',
                'lang_values' => '{"en":"Mile","zh-Hans":"英里","zh-Hant":"英哩"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'warningNudity',
                'lang_values' => '{"en":"Nudity","zh-Hans":"裸体","zh-Hant":"裸體"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'warningViolence',
                'lang_values' => '{"en":"Violence","zh-Hans":"暴力","zh-Hant":"暴力"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'warningSensitive',
                'lang_values' => '{"en":"Sensitive","zh-Hans":"敏感内容","zh-Hant":"敏感內容"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionPublic',
                'lang_values' => '{"en":"Public","zh-Hans":"公开","zh-Hant":"公開"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionPrivate',
                'lang_values' => '{"en":"Private","zh-Hans":"私有","zh-Hant":"私人"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionYourFollowers',
                'lang_values' => '{"en":"Your followers","zh-Hans":"你的关注者","zh-Hant":"你的追蹤者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionPeopleYouFollow',
                'lang_values' => '{"en":"People you follow","zh-Hans":"你关注的人","zh-Hant":"你跟隨的人"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionPeopleYouFollowOrVerified',
                'lang_values' => '{"en":"People you follow or verified","zh-Hans":"你关注的人和已认证的人","zh-Hant":"你跟隨的人和已認證的人"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionYouFollowEachOther',
                'lang_values' => '{"en":"You follow each other","zh-Hans":"你们互相关注","zh-Hant":"你們互相跟隨"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionOnlyUsersYouMention',
                'lang_values' => '{"en":"Only users you mention","zh-Hans":"仅限你提及到的用户","zh-Hant":"僅限你提及的使用者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionEveryone',
                'lang_values' => '{"en":"Everyone","zh-Hans":"所有人","zh-Hant":"所有人"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionOnlyYou',
                'lang_values' => '{"en":"Only you","zh-Hans":"仅对你自己","zh-Hant":"僅對你自己"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionNoOne',
                'lang_values' => '{"en":"No one","zh-Hans":"没有人","zh-Hant":"沒有人"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'optionNoOneIsAllowed',
                'lang_values' => '{"en":"No one is allowed","zh-Hans":"不允许所有人","zh-Hant":"不允許所有人"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'ipLocation',
                'lang_values' => '{"en":"IP Location","zh-Hans":"IP 属地","zh-Hant":"IP 屬地"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'groupAdmin',
                'lang_values' => '{"en":"Administrator","zh-Hans":"小组管理员","zh-Hant":"社團管理員"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountCenter',
                'lang_values' => '{"en":"Account Center","zh-Hans":"账户中心","zh-Hant":"帳戶中心"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountCenterDesc',
                'lang_values' => '{"en":"Manage your profile, password and other configuration information in the Account Center.","zh-Hans":"在账户中心管理你的资料和密码等配置信息。","zh-Hant":"在帳戶中心管理你的資料和密碼等設定資訊。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountCenterSeeMore',
                'lang_values' => '{"en":"See more in Accounts Center","zh-Hans":"在账户中心查看更多","zh-Hant":"在帳戶中心查看更多信息"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountCenterTip',
                'lang_values' => '{"en":"Please go to the Account Center for this feature","zh-Hans":"该功能请前往账户中心操作","zh-Hant":"此功能請前往帳戶中心操作"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'account',
                'lang_values' => '{"en":"Account","zh-Hans":"账号","zh-Hant":"帳號"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'email',
                'lang_values' => '{"en":"Email","zh-Hans":"邮箱","zh-Hant":"電子郵件地址"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'phone',
                'lang_values' => '{"en":"Phone Number","zh-Hans":"手机号","zh-Hant":"手機號碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'emailOrPhone',
                'lang_values' => '{"en":"Email or Phone Number","zh-Hans":"邮箱或手机号","zh-Hant":"電子郵件地址或手機號碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'newEmail',
                'lang_values' => '{"en":"New Email","zh-Hans":"新邮箱","zh-Hant":"新電子郵件地址"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'newPhone',
                'lang_values' => '{"en":"New Phone","zh-Hans":"新手机号","zh-Hant":"新手機號碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'currentEmail',
                'lang_values' => '{"en":"Current Email","zh-Hans":"当前邮箱","zh-Hant":"目前郵箱"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'currentPhone',
                'lang_values' => '{"en":"Current Phone Number","zh-Hans":"当前手机号","zh-Hant":"目前手機號碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'countryCallingCode',
                'lang_values' => '{"en":"Country Code","zh-Hans":"国际区号","zh-Hant":"國際區號"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'currentEmailDesc',
                'lang_values' => '{"en":"The email address currently used for the account","zh-Hans":"账户现在绑定的邮箱","zh-Hant":"帳戶現在綁定的電子郵件地址"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'currentPhoneDesc',
                'lang_values' => '{"en":"Phone number currently used for the account","zh-Hans":"账户现在绑定的手机号","zh-Hant":"帳戶現在綁定的手機號碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'emailEditDesc',
                'lang_values' => '{"en":"Once you have switched to a new email address, you can log in with your new email address and current password.","zh-Hans":"换绑新邮箱之后，可以用新的邮箱及当前密码登录","zh-Hant":"換綁新電子郵件地址之後，可以用新的電子郵件地址及目前密碼登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'phoneEditDesc',
                'lang_values' => '{"en":"After you change your mobile number, you can sign in with your new mobile number and current password.","zh-Hans":"换绑新手机号之后，可以用新的手机号及当前密码登录","zh-Hant":"換綁新手機號碼之後，可以用新的手機號碼及目前密碼登錄"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'verifyCode',
                'lang_values' => '{"en":"Verify Code","zh-Hans":"验证码","zh-Hant":"驗證碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'emailVerifyCode',
                'lang_values' => '{"en":"Email Code","zh-Hans":"邮件验证码","zh-Hant":"郵件驗證碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'emailVerifyCodeTip',
                'lang_values' => '{"en":"Verify code has been sent via Email to","zh-Hans":"验证码已通过邮件发送至","zh-Hant":"驗證碼已透過郵件發送至"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'smsVerifyCode',
                'lang_values' => '{"en":"SMS Code","zh-Hans":"短信验证码","zh-Hant":"簡訊驗證碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'smsVerifyCodeTip',
                'lang_values' => '{"en":"Verify code has been sent via SMS to","zh-Hans":"验证码已通过短信发送至","zh-Hant":"驗證碼已透過簡訊發送至"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'newVerifyCode',
                'lang_values' => '{"en":"New Verify Code","zh-Hans":"新验证码","zh-Hant":"新驗證碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'sendVerifyCode',
                'lang_values' => '{"en":"Send Code","zh-Hans":"获取验证码","zh-Hant":"取得驗證碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'resendVerifyCode',
                'lang_values' => '{"en":"Resend Code","zh-Hans":"重新发送","zh-Hant":"重新發送"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPassword',
                'lang_values' => '{"en":"Account Password","zh-Hans":"账号密码","zh-Hant":"帳號密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountType',
                'lang_values' => '{"en":"Account Type","zh-Hans":"账号类型","zh-Hant":"帳號類型"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountJoin',
                'lang_values' => '{"en":"Apply for Join","zh-Hans":"申请加入","zh-Hant":"申請加入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountRegister',
                'lang_values' => '{"en":"Sign Up","zh-Hans":"注册","zh-Hant":"註冊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLogin',
                'lang_values' => '{"en":"Sign In","zh-Hans":"登录","zh-Hant":"登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLoginOrRegister',
                'lang_values' => '{"en":"Login or Register","zh-Hans":"登录或注册","zh-Hant":"登入或註冊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLoginGoTo',
                'lang_values' => '{"en":"Go to Login","zh-Hans":"前往登录","zh-Hant":"前往登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLoginByPassword',
                'lang_values' => '{"en":"Password Login","zh-Hans":"密码登录","zh-Hant":"密碼登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLoginByCode',
                'lang_values' => '{"en":"Code Login","zh-Hans":"验证码登录","zh-Hant":"驗證碼登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLoginByConnects',
                'lang_values' => '{"en":"Quick Login","zh-Hans":"快速登录","zh-Hant":"快速登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLoggingIn',
                'lang_values' => '{"en":"Logging in...","zh-Hans":"登录中...","zh-Hant":"登入中..."}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountRegisterCloseDesc',
                'lang_values' => '{"en":"This registration channel has been closed and account registration through this function is prohibited","zh-Hans":"该注册通道已关闭，禁止通过此功能注册账号","zh-Hant":"此註冊通道已關閉，禁止透過此功能註冊帳號"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountResetPassword',
                'lang_values' => '{"en":"Forgot Password","zh-Hans":"忘记密码","zh-Hant":"忘記密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountConnectEmpty',
                'lang_values' => '{"en":"No account linkage information found","zh-Hans":"未查询到账号关联信息","zh-Hant":"未查詢到帳號關聯訊息"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountConnectLinked',
                'lang_values' => '{"en":"I have an account linked to a community","zh-Hans":"我有账号，绑定关联","zh-Hant":"我有帳號，綁定關聯"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountConnectLinkedTip',
                'lang_values' => '{"en":"Please log in to your account first using your \"Password\" or \"Verify Code\" and then go to the Account Centre on the Setup screen to operate connect after logging in.","zh-Hans":"请先使用「密码」或者「验证码」登录账号，登录后在设置页进入账户中心绑定关联。","zh-Hant":"請先使用「密碼」或「驗證碼」登入帳號，登入後在設定頁進入帳戶中心綁定關聯。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountConnectCreateNew',
                'lang_values' => '{"en":"No account, create a new account","zh-Hans":"没有账号，创建新账号","zh-Hant":"沒有帳號，建立新帳號"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountLogout',
                'lang_values' => '{"en":"Logout","zh-Hans":"退出登录","zh-Hant":"登出"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountDelete',
                'lang_values' => '{"en":"Delete Account","zh-Hans":"注销账号","zh-Hant":"註銷帳號"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountDeleteDesc',
                'lang_values' => '{"en":"Deleting an account requires an account verification code that must be associated with an email address or mobile phone number to work.","zh-Hans":"注销申请需要账号验证码，必须绑定了邮箱或手机号才可操作","zh-Hant":"註銷申請需要帳號驗證碼，必須綁定了信箱或手機號碼才可操作"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountApplyDelete',
                'lang_values' => '{"en":"Apply Delete Account","zh-Hans":"申请注销","zh-Hant":"申請註銷"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountWaitDelete',
                'lang_values' => '{"en":"Delete account wait execution","zh-Hans":"账号注销等待执行中","zh-Hant":"帳號註銷等待執行中"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountRevokeDelete',
                'lang_values' => '{"en":"Revoke Delete Account","zh-Hans":"撤销注销","zh-Hant":"撤銷註銷"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountReset',
                'lang_values' => '{"en":"Reset Password","zh-Hans":"重置密码","zh-Hant":"重設密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountError',
                'lang_values' => '{"en":"Account Error","zh-Hans":"账号错误","zh-Hant":"帳號錯誤"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountInfo',
                'lang_values' => '{"en":"By registering, you agree to the terms and conditions of this site","zh-Hans":"注册即表示同意本站条款","zh-Hant":"註冊即表示同意本站條款"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPolicies',
                'lang_values' => '{"en":"Privacy & Terms","zh-Hans":"隐私权和条款","zh-Hant":"隱私權和條款"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesCheck',
                'lang_values' => '{"en":"I have read and agree to","zh-Hans":"已阅读并同意","zh-Hant":"已閱讀並同意"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesAuthTip',
                'lang_values' => '{"en":"Feature Authorization Tips","zh-Hans":"功能授权提醒","zh-Hant":"功能授權提醒"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesAuthDesc',
                'lang_values' => '{"en":"Before using this feature, please read the Privacy & Terms carefully and click Agree to Authorize to indicate your full knowledge, understanding and agreement.","zh-Hans":"在您使用该功能前，请您认真阅读《服务条款》和《隐私政策》，并点击「同意授权」以表示您的充分知悉、理解及同意。","zh-Hant":"在您使用此功能前，請您認真閱讀《服務條款》和《隱私權政策》，並點選「同意授權」以表示您的充分知悉、瞭解及同意。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesError',
                'lang_values' => '{"en":"Please confirm that you have read and agree to the Terms and Data Policy.","zh-Hans":"请确认已经阅读并同意服务条款和隐私政策","zh-Hant":"請確認已閱讀並同意服務條款和隱私權政策"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesTerms',
                'lang_values' => '{"en":"Terms of Service","zh-Hans":"服务条款","zh-Hant":"服務條款"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesPrivacy',
                'lang_values' => '{"en":"Privacy Policy","zh-Hans":"隐私政策","zh-Hant":"隱私權政策"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesCookie',
                'lang_values' => '{"en":"Cookie Policy","zh-Hans":"Cookie 使用条款","zh-Hant":"Cookie 使用條款"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountPoliciesDelete',
                'lang_values' => '{"en":"Delete Account Description","zh-Hans":"注销说明","zh-Hant":"註銷說明"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'accountKyc',
                'lang_values' => '{"en":"Account KYC","zh-Hans":"实名认证","zh-Hant":"實名認證"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'password',
                'lang_values' => '{"en":"Password","zh-Hans":"密码","zh-Hant":"密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordCurrent',
                'lang_values' => '{"en":"Current Password","zh-Hans":"当前密码","zh-Hant":"目前密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordNew',
                'lang_values' => '{"en":"New Password","zh-Hans":"新密码","zh-Hant":"新密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordAgain',
                'lang_values' => '{"en":"Enter the password again","zh-Hans":"再输一次密码","zh-Hant":"再輸一次密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordAgainError',
                'lang_values' => '{"en":"The new password entered twice does not match","zh-Hans":"两次输入的新密码不一致","zh-Hant":"兩次輸入的新密碼不一致"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordError',
                'lang_values' => '{"en":"Password Error","zh-Hans":"密码错误","zh-Hant":"密碼錯誤"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordForgot',
                'lang_values' => '{"en":"Forgot your password","zh-Hans":"忘记密码","zh-Hant":"忘記密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordInfo',
                'lang_values' => '{"en":"Password must contain","zh-Hans":"密码必须包含","zh-Hant":"密碼必須包含"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordInfoNumbers',
                'lang_values' => '{"en":"Numbers","zh-Hans":"数字","zh-Hant":"數位"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordInfoLowercaseLetters',
                'lang_values' => '{"en":"Lowercase Letters","zh-Hans":"小写字母","zh-Hant":"小寫字母"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordInfoUppercaseLetters',
                'lang_values' => '{"en":"Uppercase Letters","zh-Hans":"大写字母","zh-Hant":"大寫字母"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'passwordInfoSymbols',
                'lang_values' => '{"en":"Symbols(Except space)","zh-Hans":"字符(除空格)","zh-Hant":"字元(除空格)"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'deviceManagement',
                'lang_values' => '{"en":"Device Management","zh-Hans":"设备管理","zh-Hant":"設備管理"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'deviceType',
                'lang_values' => '{"en":"Device Type","zh-Hans":"设备类型","zh-Hant":"設備類型"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'deviceInfo',
                'lang_values' => '{"en":"Device Information","zh-Hans":"设备信息","zh-Hant":"設備資訊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'deviceDesc',
                'lang_values' => '{"en":"When a device is deleted, the account logged on to that device is automatically logged off.","zh-Hans":"删除设备后，该设备登录的账号将自动退出登录","zh-Hant":"刪除設備後，該設備登入的帳號將自動登出登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'currentDevice',
                'lang_values' => '{"en":"Current Device","zh-Hans":"当前设备","zh-Hant":"目前設備"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'lastLoginTime',
                'lang_values' => '{"en":"Last Login Time","zh-Hans":"最近登录","zh-Hant":"最近登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletStatus',
                'lang_values' => '{"en":"Wallet Status","zh-Hans":"钱包状态","zh-Hant":"錢包狀態"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletBalance',
                'lang_values' => '{"en":"Balance","zh-Hans":"余额","zh-Hant":"餘額"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletFreezeAmount',
                'lang_values' => '{"en":"Freeze Amount","zh-Hans":"不可用金额","zh-Hant":"不可用金額"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletPassword',
                'lang_values' => '{"en":"Pay Password","zh-Hans":"钱包密码","zh-Hant":"錢包密碼"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecharge',
                'lang_values' => '{"en":"Top-up","zh-Hans":"充值","zh-Hant":"儲值"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletWithdraw',
                'lang_values' => '{"en":"Withdraw","zh-Hans":"提现","zh-Hant":"提現"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecords',
                'lang_values' => '{"en":"Transaction Record","zh-Hans":"钱包交易记录","zh-Hant":"錢包交易記錄"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType',
                'lang_values' => '{"en":"Type","zh-Hans":"交易类型","zh-Hant":"交易類型"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordAmountTotal',
                'lang_values' => '{"en":"Amount Total","zh-Hans":"交易总额","zh-Hant":"交易總額"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordAmount',
                'lang_values' => '{"en":"Amount","zh-Hans":"交易金额","zh-Hant":"交易金額"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordSystemFee',
                'lang_values' => '{"en":"System Fee","zh-Hans":"交易服务费","zh-Hant":"交易服務費"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordOpeningBalance',
                'lang_values' => '{"en":"Opening Balance","zh-Hans":"期初余额","zh-Hant":"期初餘額"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordClosingBalance',
                'lang_values' => '{"en":"Closing Balance","zh-Hans":"期末余额","zh-Hant":"期末餘額"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordTime',
                'lang_values' => '{"en":"Time","zh-Hans":"交易时间","zh-Hant":"交易時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordRemark',
                'lang_values' => '{"en":"Remark","zh-Hans":"交易备注","zh-Hant":"交易備註"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordUser',
                'lang_values' => '{"en":"User","zh-Hans":"交易用户","zh-Hant":"交易使用者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordCode',
                'lang_values' => '{"en":"Transaction Code","zh-Hans":"交易凭证","zh-Hant":"交易憑證"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordState',
                'lang_values' => '{"en":"State","zh-Hans":"交易状态","zh-Hant":"交易狀態"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType1',
                'lang_values' => '{"en":"Top-up","zh-Hans":"充值","zh-Hant":"儲值"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType2',
                'lang_values' => '{"en":"Unfreeze","zh-Hans":"解冻","zh-Hant":"解凍"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType3',
                'lang_values' => '{"en":"Transaction Income","zh-Hans":"交易收入","zh-Hant":"交易收入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType4',
                'lang_values' => '{"en":"Reversal Expense","zh-Hans":"撤回支出","zh-Hant":"撤回支出"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType5',
                'lang_values' => '{"en":"Withdraw","zh-Hans":"提现","zh-Hant":"提現"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType6',
                'lang_values' => '{"en":"Freeze","zh-Hans":"冻结","zh-Hant":"凍結"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType7',
                'lang_values' => '{"en":"Transaction Expense","zh-Hans":"交易支出","zh-Hant":"交易支出"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordType8',
                'lang_values' => '{"en":"Reversal Income","zh-Hans":"撤回收入","zh-Hant":"撤回收入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordState1',
                'lang_values' => '{"en":"Pending","zh-Hans":"等待处理","zh-Hant":"等待處理"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordState2',
                'lang_values' => '{"en":"Processing","zh-Hans":"处理中","zh-Hant":"處理中"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordState3',
                'lang_values' => '{"en":"Success","zh-Hans":"交易成功","zh-Hant":"交易成功"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordState4',
                'lang_values' => '{"en":"Failed","zh-Hans":"交易失败","zh-Hant":"交易失敗"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'walletRecordState5',
                'lang_values' => '{"en":"Reversed","zh-Hans":"交易撤回","zh-Hant":"交易撤回"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGeneral',
                'lang_values' => '{"en":"General","zh-Hans":"个人资料","zh-Hant":"個人資料"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingInteraction',
                'lang_values' => '{"en":"Interaction","zh-Hans":"互动设置","zh-Hant":"互動設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingAccount',
                'lang_values' => '{"en":"Account","zh-Hans":"账号设置","zh-Hant":"帳號設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingConnects',
                'lang_values' => '{"en":"Connects","zh-Hans":"互联信息","zh-Hant":"互聯資訊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingConversationPolicy',
                'lang_values' => '{"en":"Conversation","zh-Hans":"对话设置","zh-Hant":"對話設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingCommentPolicy',
                'lang_values' => '{"en":"Comment","zh-Hans":"评论设置","zh-Hant":"留言設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingContentPolicy',
                'lang_values' => '{"en":"Content","zh-Hans":"内容设置","zh-Hant":"內容設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingType',
                'lang_values' => '{"en":"Setting Type","zh-Hans":"修改方式","zh-Hant":"修改方式"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingAlready',
                'lang_values' => '{"en":"Already set","zh-Hans":"已设置","zh-Hant":"已設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingNot',
                'lang_values' => '{"en":"Not set","zh-Hans":"未设置","zh-Hant":"未設定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingWarning',
                'lang_values' => '{"en":"To protect the security of your account, please verify your identity and proceed to the next step after successful verification","zh-Hans":"为了保护你的账号安全，请验证身份，验证成功后进行下一步操作","zh-Hant":"為了保護你的帳號安全，請驗證身份，驗證成功後進行下一步操作"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingCheckError',
                'lang_values' => '{"en":"Operation verification failed, please pass the verification first and then operate","zh-Hans":"操作验证失败，请先通过验证再操作","zh-Hant":"操作驗證失敗，請先透過驗證再操作"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingIntervalDays',
                'lang_values' => '{"en":"Edit interval","zh-Hans":"修改间隔天数","zh-Hant":"修改間隔天數"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingLastTime',
                'lang_values' => '{"en":"Last edit time","zh-Hans":"上次修改时间","zh-Hant":"上次修改時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingNameWarning',
                'lang_values' => '{"en":"Alphabet and numbers only, can be pure letters or mixed with numbers, but not pure numbers","zh-Hans":"仅支持英文字母和数字，可以纯字母或者与数字混合，但不能纯数字","zh-Hant":"只支援英文字母和數字，可以純字母或與數字混合，但不能純數字"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingNicknameWarning',
                'lang_values' => '{"en":"No punctuation or special symbols in nickname","zh-Hans":"昵称不能带标点符号或特殊符号","zh-Hant":"暱稱不能帶標點符號或特殊符號"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingBirthdayTip',
                'lang_values' => '{"en":"Providing your birthday helps make sure you get the right Fresns experience for your age.","zh-Hans":"提供你的出生日期将确保 Fresns 提供与你年龄相符的使用体验。","zh-Hant":"提供你的出生日期將確保 Fresns 提供與你年齡相符的使用體驗。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingBirthdayDisplayType',
                'lang_values' => '{"en":"Birthday Display Type","zh-Hans":"生日显示方式","zh-Hant":"生日顯示方式"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingBirthdayDisplayType1',
                'lang_values' => '{"en":"Full Display","zh-Hans":"完整显示","zh-Hant":"完整顯示"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingBirthdayDisplayType2',
                'lang_values' => '{"en":"Display Year","zh-Hans":"显示年份","zh-Hant":"顯示年份"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingBirthdayDisplayType3',
                'lang_values' => '{"en":"Display Month and Day","zh-Hans":"显示月和日","zh-Hant":"顯示月和日"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingBirthdayDisplayType4',
                'lang_values' => '{"en":"Non-Public","zh-Hans":"不公开","zh-Hant":"不公開"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderNull',
                'lang_values' => '{"en":"Confidential","zh-Hans":"保密","zh-Hant":"保密"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderMale',
                'lang_values' => '{"en":"Male","zh-Hans":"男","zh-Hant":"男"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderFemale',
                'lang_values' => '{"en":"Female","zh-Hans":"女","zh-Hant":"女"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderCustom',
                'lang_values' => '{"en":"Custom","zh-Hans":"自定义","zh-Hant":"自訂"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderPronounOptionTip',
                'lang_values' => '{"en":"Select your pronoun","zh-Hans":"选择你的人称代词","zh-Hant":"選擇你的人稱代名詞"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderPronounOptionShe',
                'lang_values' => '{"en":"She: \"Wish her a happy birthday!\"","zh-Hans":"她: “祝她生日快乐！”","zh-Hant":"她: “祝她生日快樂！”"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderPronounOptionHe',
                'lang_values' => '{"en":"He: \"Wish him a happy birthday!\"","zh-Hans":"他: “祝他生日快乐！”","zh-Hant":"他: “祝他生日快樂！”"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderPronounOptionThey',
                'lang_values' => '{"en":"They: \"Wish them a happy birthday!\"","zh-Hans":"TA: “祝 TA 生日快乐！”","zh-Hant":"TA: “祝 TA 生日快樂！”"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingGenderPronounTip',
                'lang_values' => '{"en":"Your pronoun is visible to everyone.","zh-Hans":"所有人都能看到你的人称代词。","zh-Hant":"所有人都能看到你的人稱代名詞。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingAccountConnect',
                'lang_values' => '{"en":"Connect Account","zh-Hans":"绑定","zh-Hant":"綁定"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'settingAccountDisconnect',
                'lang_values' => '{"en":"Disconnect Account","zh-Hans":"解绑","zh-Hant":"解綁"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userCurrent',
                'lang_values' => '{"en":"Current User","zh-Hans":"当前用户","zh-Hant":"目前使用者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userPin',
                'lang_values' => '{"en":"Auth PIN","zh-Hans":"用户 PIN","zh-Hant":"使用者 PIN"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userPinLogin',
                'lang_values' => '{"en":"PIN Login","zh-Hans":"PIN 登录","zh-Hant":"PIN 登入"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userPinReset',
                'lang_values' => '{"en":"Forgot PIN","zh-Hans":"忘记 PIN","zh-Hant":"忘記 PIN"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userEnter',
                'lang_values' => '{"en":"Enter","zh-Hans":"进入社区","zh-Hant":"進入社區"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userProfile',
                'lang_values' => '{"en":"Profile","zh-Hans":"个人信息","zh-Hant":"個人資訊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userAvatar',
                'lang_values' => '{"en":"Avatar","zh-Hans":"头像","zh-Hant":"頭像"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userGender',
                'lang_values' => '{"en":"Gender","zh-Hans":"性别","zh-Hant":"性別"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userBirthday',
                'lang_values' => '{"en":"Birthday","zh-Hans":"生日","zh-Hant":"生日"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userFollowing',
                'lang_values' => '{"en":"Following","zh-Hans":"正在关注","zh-Hant":"正在跟隨"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userUnfollow',
                'lang_values' => '{"en":"Unfollow","zh-Hans":"取消关注","zh-Hant":"取消追蹤"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userFollowMutual',
                'lang_values' => '{"en":"Mutual follow","zh-Hans":"互相关注","zh-Hant":"互相跟隨"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userFollowedYou',
                'lang_values' => '{"en":"Followed you","zh-Hans":"关注了你","zh-Hant":"跟隨了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userBlockedYou',
                'lang_values' => '{"en":"Blocked you","zh-Hans":"拉黑了你","zh-Hant":"封鎖了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userFollowersYouKnow',
                'lang_values' => '{"en":"and others are also following they","zh-Hans":"等人也关注了他","zh-Hant":"等人也跟隨了他"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userFollowersYouFollow',
                'lang_values' => '{"en":"The person you are following is also following they","zh-Hans":"你关注的人也在关注他","zh-Hant":"你跟隨的人也在跟隨他"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userDeactivated',
                'lang_values' => '{"en":"User Deactivated","zh-Hans":"用户已注销","zh-Hant":"使用者已停用"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userSuspended',
                'lang_values' => '{"en":"User Suspended","zh-Hans":"用户已被冻结","zh-Hant":"使用者已被凍結"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userInterdiction',
                'lang_values' => '{"en":"User Interdiction","zh-Hans":"用户正在被禁言","zh-Hant":"使用者正在被禁言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcredits',
                'lang_values' => '{"en":"User Credits","zh-Hans":"用户积分","zh-Hant":"使用者積分"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecords',
                'lang_values' => '{"en":"Extcredits Records","zh-Hans":"用户扩展分值记录","zh-Hant":"使用者擴展分數記錄"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordName',
                'lang_values' => '{"en":"Extcredits","zh-Hans":"分值名称","zh-Hant":"分數名稱"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordType',
                'lang_values' => '{"en":"Type","zh-Hans":"操作类型","zh-Hant":"操作類型"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordAmount',
                'lang_values' => '{"en":"Amount","zh-Hans":"分值","zh-Hant":"分數"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordOpeningAmount',
                'lang_values' => '{"en":"Opening Amount","zh-Hans":"期初分值","zh-Hant":"期初分值"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordClosingAmount',
                'lang_values' => '{"en":"Closing Amount","zh-Hans":"期末分值","zh-Hant":"期末分數"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordApp',
                'lang_values' => '{"en":"App","zh-Hans":"应用","zh-Hant":"應用"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordRemark',
                'lang_values' => '{"en":"Remark","zh-Hans":"备注","zh-Hant":"備註"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userExtcreditsRecordTime',
                'lang_values' => '{"en":"Time","zh-Hans":"时间","zh-Hant":"時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'userConversationCloseDesc',
                'lang_values' => '{"en":"Conversation function is not enabled and cannot be used","zh-Hans":"对话功能未启用，无法使用","zh-Hant":"對話功能未啟用，無法使用"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'privateRenewal',
                'lang_values' => '{"en":"Renewal","zh-Hans":"续期","zh-Hant":"續期"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'privateContentHide',
                'lang_values' => '{"en":"Membership has expired, all site content is no longer visible.","zh-Hans":"会员已到期，站点内容全部不可见","zh-Hant":"會員已到期，站點內容全部不可見"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'privateContentShowOld',
                'lang_values' => '{"en":"Membership has expired, you can only browse content from before the expiration date and no longer have access to new content.","zh-Hans":"会员已到期，仅能浏览到期前内容，不再显示新内容","zh-Hant":"會員到期，僅能瀏覽到期前內容，不再顯示新內容"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationMarkAllAsRead',
                'lang_values' => '{"en":"Mark all as read","zh-Hans":"标记全部为已读","zh-Hant":"標記全部為已讀"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationMarkAsRead',
                'lang_values' => '{"en":"Mark as read","zh-Hans":"标记为已读","zh-Hant":"標記為已讀"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationLiked',
                'lang_values' => '{"en":"Liked you","zh-Hans":"点赞了你","zh-Hant":"喜歡了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationDisliked',
                'lang_values' => '{"en":"Disliked you","zh-Hans":"踩了你","zh-Hant":"不喜歡了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationFollowed',
                'lang_values' => '{"en":"Followed you","zh-Hans":"关注了你","zh-Hant":"跟隨了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationBlocked',
                'lang_values' => '{"en":"Blocked you","zh-Hans":"屏蔽了你","zh-Hant":"封鎖了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationMentioned',
                'lang_values' => '{"en":"Mentioned you","zh-Hans":"提及了你","zh-Hant":"提及了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationCommented',
                'lang_values' => '{"en":"Commented you","zh-Hans":"评论了你","zh-Hant":"回覆了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationQuoted',
                'lang_values' => '{"en":"Quoted you","zh-Hans":"引用了你","zh-Hant":"引用了你"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'notificationFromContentMentionYou',
                'lang_values' => '{"en":"a content that mention you","zh-Hans":"一条提及你的内容","zh-Hant":"一條提及你的內容"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
        ]);
        DB::table('language_packs')->insert([
            [
                'lang_key' => 'upload',
                'lang_values' => '{"en":"Upload","zh-Hans":"上传","zh-Hant":"上傳"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadButton',
                'lang_values' => '{"en":"Confirm","zh-Hans":"确认上传","zh-Hant":"確認上傳"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadTip',
                'lang_values' => '{"en":"Please select upload resources","zh-Hans":"请选择上传资源","zh-Hant":"請選擇上傳資源"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadTipExtensions',
                'lang_values' => '{"en":"Extensions","zh-Hans":"支持的扩展名","zh-Hant":"支援的擴展名"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadTipMaxSize',
                'lang_values' => '{"en":"Max size","zh-Hans":"支持的最大尺寸","zh-Hant":"支援的最大尺寸"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadTipMaxDuration',
                'lang_values' => '{"en":"Max duration","zh-Hans":"支持的最长时间","zh-Hant":"支援的最長時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadTipMaxNumber',
                'lang_values' => '{"en":"Max number","zh-Hans":"支持上传的数量","zh-Hant":"支援上傳的數量"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadWarningExtension',
                'lang_values' => '{"en":"This extension of file can not be uploaded","zh-Hans":"该文件类型不在允许上传的范围内","zh-Hant":"該文件類型不在允許上傳的範圍內"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadWarningMaxSize',
                'lang_values' => '{"en":"File size exceeds the set limit","zh-Hans":"文件尺寸超出设置的限制","zh-Hant":"文件尺寸超出設置的限制"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadWarningMaxDuration',
                'lang_values' => '{"en":"File time length exceeds the set limit","zh-Hans":"文件时长超出设置的限制","zh-Hant":"文件時長超出設置的限制"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'uploadWarningMaxNumber',
                'lang_values' => '{"en":"The number of files exceeds the set limit","zh-Hans":"文件数量超出设置的限制","zh-Hant":"文件數量超出設置的限制"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'fileWarning',
                'lang_values' => '{"en":"File Warning","zh-Hans":"内容警告","zh-Hant":"內容警告"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'fileWarningDesc',
                'lang_values' => '{"en":"Put a content warning on this file","zh-Hans":"给文件添加警告","zh-Hant":"給文件添加警告"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'fileWarningTip',
                'lang_values' => '{"en":"Select a category, and we\'ll put a content warning on this file. This helps people avoid content they don\'t want to see.","zh-Hans":"选择一个类别，我们就会在文件上加上警告。这可以帮助人们避开他们不想看到的内容。","zh-Hant":"選擇一個類別，我們就會在文件上加上警告。 這可以幫助人們避開他們不想看到的內容。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editor',
                'lang_values' => '{"en":"Editor","zh-Hans":"编辑器","zh-Hant":"編輯器"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorGoTo',
                'lang_values' => '{"en":"Go to Editor","zh-Hans":"进入编辑器","zh-Hant":"進入編輯器"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorDraftSelect',
                'lang_values' => '{"en":"Select a draft from the draft box","zh-Hans":"从草稿箱中选择一篇草稿","zh-Hant":"從草稿箱中選擇一篇草稿"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorDraftCreate',
                'lang_values' => '{"en":"Create a new draft","zh-Hans":"创建新草稿","zh-Hant":"建立新草稿"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorSelectAudience',
                'lang_values' => '{"en":"Choose audience","zh-Hans":"选择受众","zh-Hant":"選擇受眾"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorNoSelectGroup',
                'lang_values' => '{"en":"Not selected","zh-Hans":"未选择","zh-Hant":"未選擇"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorNoGroup',
                'lang_values' => '{"en":"Do not send to any group","zh-Hans":"不发到任何小组","zh-Hant":"不發到任何社團"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorMyFollowGroup',
                'lang_values' => '{"en":"I follow","zh-Hans":"我关注的","zh-Hant":"我跟隨的"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorStickers',
                'lang_values' => '{"en":"Stickers","zh-Hans":"表情","zh-Hant":"表情"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorImages',
                'lang_values' => '{"en":"Images","zh-Hans":"图片","zh-Hant":"圖片"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorVideos',
                'lang_values' => '{"en":"Videos","zh-Hans":"视频","zh-Hant":"影片"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorAudios',
                'lang_values' => '{"en":"Audios","zh-Hans":"音频","zh-Hant":"音訊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorDocuments',
                'lang_values' => '{"en":"Documents","zh-Hans":"文档","zh-Hant":"文件"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorTitle',
                'lang_values' => '{"en":"Title","zh-Hans":"标题","zh-Hant":"標題"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorMention',
                'lang_values' => '{"en":"Mention","zh-Hans":"艾特","zh-Hant":"艾特"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorHashtag',
                'lang_values' => '{"en":"Hashtag","zh-Hans":"话题","zh-Hant":"話題"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorExtends',
                'lang_values' => '{"en":"Extends","zh-Hans":"扩展","zh-Hant":"擴充"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorContent',
                'lang_values' => '{"en":"Content","zh-Hans":"正文","zh-Hant":"正文"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorContentMarkdown',
                'lang_values' => '{"en":"Content is Markdown format","zh-Hans":"正文为 Markdown 格式","zh-Hant":"正文為 Markdown 格式"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLocation',
                'lang_values' => '{"en":"Location","zh-Hans":"添加位置","zh-Hant":"增加位置"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorAnonymous',
                'lang_values' => '{"en":"Anonymous","zh-Hans":"是否匿名","zh-Hant":"是否匿名"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorCommentDisable',
                'lang_values' => '{"en":"Disable Comment","zh-Hans":"禁止评论","zh-Hant":"禁止留言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorCommentPrivate',
                'lang_values' => '{"en":"Only visible to post author","zh-Hans":"仅帖子作者可见","zh-Hant":"僅限貼文作者可見"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorVideoPlayTip',
                'lang_values' => '{"en":"Upload successfully and playable after publication","zh-Hans":"上传成功，发表后可播放","zh-Hant":"上傳成功，發表後可播放"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitTitle',
                'lang_values' => '{"en":"Publish Interdiction Tip","zh-Hans":"发表限制提醒","zh-Hant":"發表限制提醒"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitTypeName',
                'lang_values' => '{"en":"Interdiction Type","zh-Hans":"限制类型","zh-Hant":"限制類型"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitType1Desc',
                'lang_values' => '{"en":"Specify date range interdiction","zh-Hans":"指定日期范围内限制","zh-Hant":"指定日期範圍內限制"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitType2Desc',
                'lang_values' => '{"en":"Cycle limits within the time range of each day","zh-Hans":"每天的时间段范围内循环限制","zh-Hant":"每天的時間段範圍內循環限制"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitDateName',
                'lang_values' => '{"en":"Date range","zh-Hans":"日期范围","zh-Hant":"日期範圍"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitCycleName',
                'lang_values' => '{"en":"Time range","zh-Hans":"时间范围","zh-Hant":"時間範圍"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitRuleName',
                'lang_values' => '{"en":"Interdiction rules","zh-Hans":"限制规则","zh-Hant":"限制規則"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitRule1Desc',
                'lang_values' => '{"en":"It can be published, but it needs to be reviewed","zh-Hans":"可以发表，但是需要审核","zh-Hant":"可以發表，但是需要審核"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitRule2Desc',
                'lang_values' => '{"en":"Prohibited to publish","zh-Hans":"禁止发表","zh-Hant":"禁止發表"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorLimitPromptName',
                'lang_values' => '{"en":"Restrictions","zh-Hans":"限制说明","zh-Hant":"限制說明"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorRoleLimitTitle',
                'lang_values' => '{"en":"Publishing restriction information of role permissions","zh-Hans":"角色权限发表限制信息","zh-Hant":"角色權限發表限制訊息"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorMainRoleTitle',
                'lang_values' => '{"en":"User Main Role","zh-Hans":"用户主角色","zh-Hant":"使用者主角色"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorEditTimeTitle',
                'lang_values' => '{"en":"After the content is published successfully, it can only be edited within the specified time. After the time-out, it can not be edited again, but it can be deleted.","zh-Hans":"内容发表成功后，仅在规定时间内可以编辑，超时后不可再编辑，但可以删除。","zh-Hant":"內容發表成功後，僅在規定時間內可編輯，逾時後不可再編輯，但可刪除。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorEditTimeDesc',
                'lang_values' => '{"en":"Remaining Time","zh-Hans":"剩余时间","zh-Hant":"剩餘時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorReadConfigTitle',
                'lang_values' => '{"en":"Permissions Information","zh-Hans":"权限信息","zh-Hant":"權限資訊"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorReadConfigRoleName',
                'lang_values' => '{"en":"Specify user roles to be accessible","zh-Hans":"指定用户角色可访问","zh-Hant":"指定使用者角色可存取"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorReadConfigUserName',
                'lang_values' => '{"en":"Specified users can access","zh-Hans":"指定用户可访问","zh-Hant":"指定使用者可存取"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorReadConfigPercentageName',
                'lang_values' => '{"en":"Percentage of content before trial reading","zh-Hans":"可试读前内容比例","zh-Hant":"可試讀前內容比例"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorReadConfigButtonName',
                'lang_values' => '{"en":"Get read permission button text","zh-Hans":"获取阅读权限按钮文字","zh-Hant":"取得閱讀權限按鈕文字"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorCommentButtonTitle',
                'lang_values' => '{"en":"Comment Button Information","zh-Hans":"评论按钮信息","zh-Hant":"留言按鈕訊息"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorCommentButtonName',
                'lang_values' => '{"en":"Button Name","zh-Hans":"按钮名称","zh-Hant":"按鈕名稱"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorUserListTitle',
                'lang_values' => '{"en":"Associated Member Configuration","zh-Hans":"特定成员配置","zh-Hant":"特定成員配置"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'editorUserListName',
                'lang_values' => '{"en":"Associated Member Name","zh-Hans":"特定成员名称","zh-Hant":"特定成員名稱"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentReviewPending',
                'lang_values' => '{"en":"Content review in progress","zh-Hans":"内容审核中","zh-Hant":"內容審核中"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentReviewRejected',
                'lang_values' => '{"en":"Content review rejected","zh-Hans":"内容审核拒绝","zh-Hant":"內容審核拒絕"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentEditReviewTip',
                'lang_values' => '{"en":"The content is being reviewed and can not be edited","zh-Hans":"内容审核中不可编辑","zh-Hant":"內容審核中不可編輯"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentEditPublishedTip',
                'lang_values' => '{"en":"The content has been published and can not be edited","zh-Hans":"内容已正式发表不可编辑","zh-Hant":"內容已正式發表不可編輯"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentLoginTip',
                'lang_values' => '{"en":"Login is required to view","zh-Hans":"需要登录后才能查看","zh-Hant":"需要登入後才能查看"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentGroupTip',
                'lang_values' => '{"en":"Only members can see who\'s in the group and what they post.","zh-Hans":"只有小组成员才能查看小组内帖子","zh-Hant":"只有社團成員才能查看社團內貼文"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentWarning',
                'lang_values' => '{"en":"Content Warning","zh-Hans":"内容警告","zh-Hant":"內容警告"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentWarningTip',
                'lang_values' => '{"en":"The author flagged this file as showing sensitive content.","zh-Hans":"作者将此文件标记为显示敏感内容。","zh-Hant":"作者將此文件標記為顯示敏感內容。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentAllList',
                'lang_values' => '{"en":"All","zh-Hans":"所有","zh-Hant":"所有"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentNewList',
                'lang_values' => '{"en":"New","zh-Hans":"最新","zh-Hant":"最新"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentPopularList',
                'lang_values' => '{"en":"Popular","zh-Hans":"热门","zh-Hant":"熱門"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentBrowse',
                'lang_values' => '{"en":"Browse","zh-Hans":"浏览","zh-Hant":"瀏覽"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentDigest',
                'lang_values' => '{"en":"Digest","zh-Hans":"精华","zh-Hant":"精華"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentSticky',
                'lang_values' => '{"en":"Sticky","zh-Hans":"置顶","zh-Hant":"置頂"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentActive',
                'lang_values' => '{"en":"Active","zh-Hans":"活跃","zh-Hant":"活躍"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentRecommend',
                'lang_values' => '{"en":"Recommend","zh-Hans":"推荐","zh-Hant":"推薦"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentFull',
                'lang_values' => '{"en":"Show more","zh-Hans":"全文","zh-Hant":"全文"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentViewOriginal',
                'lang_values' => '{"en":"View Original Article","zh-Hans":"查看原文","zh-Hant":"看原文"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentAuthor',
                'lang_values' => '{"en":"Author","zh-Hans":"作者","zh-Hant":"作者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentAuthorAnonymous',
                'lang_values' => '{"en":"Anonymous","zh-Hans":"匿名者","zh-Hant":"匿名者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentAuthorLiked',
                'lang_values' => '{"en":"The author liked the comment","zh-Hans":"作者点赞了该评论","zh-Hant":"作者喜歡了這篇留言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentPublishTime',
                'lang_values' => '{"en":"Publish Time","zh-Hans":"发布时间","zh-Hant":"發佈時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentCommentTime',
                'lang_values' => '{"en":"Comment Time","zh-Hans":"评论时间","zh-Hant":"留言時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentDigestTime',
                'lang_values' => '{"en":"Digest Time","zh-Hans":"精华时间","zh-Hant":"精華時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentLastCommentTime',
                'lang_values' => '{"en":"Last Comment Time","zh-Hans":"最新评论时间","zh-Hant":"最新留言時間"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentPublishedOn',
                'lang_values' => '{"en":"Published on","zh-Hans":"发表于","zh-Hant":"發表於"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentEditedOn',
                'lang_values' => '{"en":"Edited on","zh-Hans":"编辑于","zh-Hant":"編輯於"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentDigestGeneral',
                'lang_values' => '{"en":"General Digest","zh-Hans":"普通精华","zh-Hant":"一般精選"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentDigestPremium',
                'lang_values' => '{"en":"Premium Digest","zh-Hans":"高级精华","zh-Hant":"進階精選"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentStickyGroup',
                'lang_values' => '{"en":"Group Sticky","zh-Hans":"小组置顶","zh-Hant":"社團置頂"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentStickyGlobal',
                'lang_values' => '{"en":"Global Sticky","zh-Hans":"全局置顶","zh-Hant":"全域置頂"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentFileUploader',
                'lang_values' => '{"en":"Uploader","zh-Hans":"上传者","zh-Hant":"上傳者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentFileDownloader',
                'lang_values' => '{"en":"Downloader","zh-Hans":"用户下载记录","zh-Hant":"使用者下載記錄"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentFileDownloaderDesc',
                'lang_values' => '{"en":"Only 30 users are displayed","zh-Hans":"仅展示 30 名用户","zh-Hant":"僅展示 30 位使用者"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentImageLong',
                'lang_values' => '{"en":"Long Image","zh-Hans":"长图","zh-Hant":"長圖"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentVideoPlay',
                'lang_values' => '{"en":"Play","zh-Hans":"播放","zh-Hant":"播放"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentDocumentDetail',
                'lang_values' => '{"en":"Detail","zh-Hans":"文件详情","zh-Hant":"文件詳情"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentDocumentInfo',
                'lang_values' => '{"en":"This document is protected by Fresns share and may only be downloaded and viewed by users of this site, all downloads are recorded and should not be distributed.","zh-Hans":"本文档受 Fresns 分享保护，仅限于本站用户下载查阅，所有下载均记录在案，请勿扩散。","zh-Hant":"本文檔受 Fresns 分享保護，僅限於本站使用者下載查閱，所有下載均記錄在案，請勿擴散。"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentPreReadInfo',
                'lang_values' => '{"en":"Trial content available","zh-Hans":"可试读内容","zh-Hant":"可試讀內容"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentTopComment',
                'lang_values' => '{"en":"Top Comment","zh-Hans":"热评","zh-Hant":"熱評"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentCommentWho',
                'lang_values' => '{"en":"Who can comment on the post?","zh-Hans":"谁可以评论该帖子？","zh-Hant":"誰可以留言該貼文？"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentCommentClose',
                'lang_values' => '{"en":"This post is closed to comments","zh-Hans":"该帖子已关闭评论","zh-Hant":"該貼文已關閉留言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentCommentCountDesc',
                'lang_values' => '{"en":"comments","zh-Hans":"条回复","zh-Hant":"條留言"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentCommentNotPublic',
                'lang_values' => '{"en":"Comments are only visible to the author of the post","zh-Hans":"评论仅帖子作者可见","zh-Hant":"留言僅貼文作者可見"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'lang_key' => 'contentCommentVisibilityRuleTip',
                'lang_values' => '{"en":"Comments are beyond the visible period, No longer displayed.","zh-Hans":"评论已超出可见期限，不再显示","zh-Hant":"留言已超出可見期限，不再顯示"}',
                'is_custom' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
        ]);
    }
}
