<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ConfigsTableSeeder extends Seeder
{
    /**
     * Fresns seed file.
     */
    public function run(): void
    {
        DB::table('configs')->delete();

        DB::table('configs')->insert([
            [
                'item_key' => 'installed_datetime',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'panel_configs',
                'item_value' => '{"path":"admin","port":null,"ipv4":[],"ipv6":[],"accountSupport":{"email":true,"phone":true,"aid":true}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'developer_configs',
                'item_value' => '{"cache":true,"apiSignature":true}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'build_type',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'check_version_datetime',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'cache_datetime',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'crontab_items',
                'item_value' => '[{"fskey":"Fresns","cmdWord":"checkUserRoleExpired","cronTableFormat":"*/10 * * * *"},{"fskey":"Fresns","cmdWord":"checkDeleteAccount","cronTableFormat":"* */6 * * *"},{"fskey":"Fresns","cmdWord":"checkAppsVersions","cronTableFormat":"* */8 * * *"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'subscribe_items',
                'item_value' => '[]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'platforms',
                'item_value' => '[{"id":1,"name":"Other"},{"id":2,"name":"Desktop Web"},{"id":3,"name":"Mobile Web"},{"id":4,"name":"Responsive Web"},{"id":5,"name":"iOS App"},{"id":6,"name":"Android App"},{"id":7,"name":"Mac App"},{"id":8,"name":"Windows App"},{"id":9,"name":"Linux App"},{"id":10,"name":"Vision App"},{"id":11,"name":"Mini Program"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'connects',
                'item_value' => '[{"id":1,"name":"Other"},{"id":2,"name":"Fresns"},{"id":3,"name":"SSO"},{"id":4,"name":"GitHub"},{"id":5,"name":"GitLab"},{"id":6,"name":"Bitbucket"},{"id":7,"name":"Google"},{"id":8,"name":"Facebook"},{"id":9,"name":"Instagram"},{"id":10,"name":"Twitter"},{"id":11,"name":"Discord"},{"id":12,"name":"Telegram"},{"id":13,"name":"Apple"},{"id":14,"name":"Microsoft"},{"id":15,"name":"LinkedIn"},{"id":16,"name":"PayPal"},{"id":17,"name":"Slack"},{"id":18,"name":"Netlify"},{"id":19,"name":"LINE"},{"id":20,"name":"KakaoTalk"},{"id":21,"name":"Lark"},{"id":22,"name":"Steam"},{"id":23,"name":"WeChat Open Platform (UnionID)"},{"id":24,"name":"WeChat Official Accounts Platform"},{"id":25,"name":"WeChat Mini Program"},{"id":26,"name":"WeChat Mobile Application"},{"id":27,"name":"WeChat Website Application"},{"id":28,"name":"WeCom"},{"id":29,"name":"Tencent QQ Open Platform (UnionID)"},{"id":30,"name":"Tencent QQ Mini Program"},{"id":31,"name":"Tencent QQ Mobile Application"},{"id":32,"name":"Tencent QQ Website Application"},{"id":33,"name":"Gitee"},{"id":34,"name":"Weibo"},{"id":35,"name":"Alipay"},{"id":36,"name":"ByteDance"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'maps',
                'item_value' => '[{"id":1,"name":"Unknown"},{"id":2,"name":"Google"},{"id":3,"name":"Apple"},{"id":4,"name":"Amap"},{"id":5,"name":"Tencent"},{"id":6,"name":"Baidu"},{"id":7,"name":"Bing"},{"id":8,"name":"Mapbox"},{"id":9,"name":"Here"},{"id":10,"name":"OpenStreetMap"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'continents',
                'item_value' => '[{"id":1,"name":"Asia"},{"id":2,"name":"Africa"},{"id":3,"name":"North America"},{"id":4,"name":"South America"},{"id":5,"name":"Antarctica"},{"id":6,"name":"Europe"},{"id":7,"name":"Oceania"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'area_codes',
                'item_value' => '[{"name":"Afghanistan","code":"AF","continentId":1,"callingCode":93,"localName":"افغانستان‎"},{"name":"Albania","code":"AL","continentId":6,"callingCode":355,"localName":"Shqipërisë"},{"name":"Algeria","code":"DZ","continentId":2,"callingCode":213,"localName":"الدزاير‎‎ al-dzāyīr"},{"name":"American Samoa","code":"AS","continentId":7,"callingCode":1684,"localName":"Amerika Sāmoa"},{"name":"Andorra","code":"AD","continentId":6,"callingCode":376,"localName":"Principat d\'Andorra"},{"name":"Angola","code":"AO","continentId":2,"callingCode":244,"localName":"Angola"},{"name":"Antarctica","code":"AQ","continentId":5,"callingCode":null,"localName":"Antarctica"},{"name":"Antigua and Barbuda","code":"AG","continentId":3,"callingCode":1,"localName":"Antigua and Barbuda"},{"name":"Argentina","code":"AR","continentId":4,"callingCode":54,"localName":"Argentina"},{"name":"Armenia","code":"AM","continentId":1,"callingCode":374,"localName":"Հայաստանի Հանրապետություն"},{"name":"Aruba","code":"AW","continentId":3,"callingCode":297,"localName":"Aruba"},{"name":"Australia","code":"AU","continentId":7,"callingCode":61,"localName":"Australia"},{"name":"Austria","code":"AT","continentId":6,"callingCode":43,"localName":"Österreich"},{"name":"Azerbaijan","code":"AZ","continentId":1,"callingCode":994,"localName":"Azərbaycan"},{"name":"Bahamas","code":"BS","continentId":3,"callingCode":1,"localName":"Bahamas"},{"name":"Bahrain","code":"BH","continentId":1,"callingCode":973,"localName":"مملكة البحرين"},{"name":"Bangladesh","code":"BD","continentId":1,"callingCode":880,"localName":"গণপ্রজাতন্ত্রী বাংলাদেশ"},{"name":"Barbados","code":"BB","continentId":3,"callingCode":1,"localName":"Barbados"},{"name":"Belarus","code":"BY","continentId":6,"callingCode":375,"localName":"Беларусь"},{"name":"Belgium","code":"BE","continentId":6,"callingCode":32,"localName":"België"},{"name":"Belize","code":"BZ","continentId":3,"callingCode":501,"localName":"Belize"},{"name":"Benin","code":"BJ","continentId":2,"callingCode":229,"localName":"Bénin"},{"name":"Bermuda","code":"BM","continentId":3,"callingCode":1,"localName":"Bermuda"},{"name":"Bhutan","code":"BT","continentId":1,"callingCode":975,"localName":"འབྲུག་ཡུལ་"},{"name":"Bolivia","code":"BO","continentId":4,"callingCode":591,"localName":"Bolivia"},{"name":"Bosnia and Herzegovina","code":"BA","continentId":6,"callingCode":387,"localName":"Босна и Херцеговина"},{"name":"Botswana","code":"BW","continentId":2,"callingCode":267,"localName":"Botswana"},{"name":"Bouvet Island","code":"BV","continentId":5,"callingCode":47,"localName":"Bouvetøya"},{"name":"Brazil","code":"BR","continentId":4,"callingCode":55,"localName":"Brasil"},{"name":"British Indian Ocean Territory","code":"IO","continentId":1,"callingCode":246,"localName":"British Indian Ocean Territory"},{"name":"Brunei Darussalam","code":"BN","continentId":1,"callingCode":673,"localName":"نڬارا بروني دارالسلام"},{"name":"Bulgaria","code":"BG","continentId":6,"callingCode":359,"localName":"България"},{"name":"Burkina Faso","code":"BF","continentId":2,"callingCode":226,"localName":"Burkina Faso"},{"name":"Burundi","code":"BI","continentId":2,"callingCode":257,"localName":"y\'Uburundi"},{"name":"Cambodia","code":"KH","continentId":1,"callingCode":855,"localName":"ព្រះរាជាណាចក្រកម្ពុជា"},{"name":"Cameroon","code":"CM","continentId":2,"callingCode":237,"localName":"Cameroun"},{"name":"Canada","code":"CA","continentId":3,"callingCode":1,"localName":"Canada"},{"name":"Cape Verde","code":"CV","continentId":2,"callingCode":238,"localName":"Cabo Verde"},{"name":"Cayman Islands","code":"KY","continentId":3,"callingCode":1,"localName":"Cayman Islands"},{"name":"Central African Republic","code":"CF","continentId":2,"callingCode":236,"localName":"Centrafricaine"},{"name":"Chad","code":"TD","continentId":2,"callingCode":235,"localName":"تشاد‎"},{"name":"Chile","code":"CL","continentId":4,"callingCode":56,"localName":"Chile"},{"name":"China","code":"CN","continentId":1,"callingCode":86,"localName":"内地"},{"name":"Christmas Island","code":"CX","continentId":1,"callingCode":61,"localName":"Christmas Island"},{"name":"Cocos (keeling) Islands","code":"CC","continentId":1,"callingCode":61,"localName":"Cocos (Keeling) Islands"},{"name":"Colombia","code":"CO","continentId":4,"callingCode":57,"localName":"Colombia"},{"name":"Comoros","code":"KM","continentId":2,"callingCode":269,"localName":"جزر القمر‎"},{"name":"Congo","code":"CG","continentId":2,"callingCode":242,"localName":"Congo"},{"name":"Congo, The Democratic Republic of The","code":"CD","continentId":2,"callingCode":243,"localName":"DR Congo"},{"name":"Cook Islands","code":"CK","continentId":7,"callingCode":682,"localName":"Kūki \'Āirani"},{"name":"Costa Rica","code":"CR","continentId":3,"callingCode":506,"localName":"Costa Rica"},{"name":"Cote d\'Ivoire","code":"CI","continentId":2,"callingCode":225,"localName":"CÔte d\'ivoire"},{"name":"Croatia","code":"HR","continentId":6,"callingCode":385,"localName":"Hrvatska"},{"name":"Cuba","code":"CU","continentId":3,"callingCode":53,"localName":"Cuba"},{"name":"Cyprus","code":"CY","continentId":6,"callingCode":357,"localName":"Κύπρος"},{"name":"Czech Republic","code":"CZ","continentId":6,"callingCode":420,"localName":"Česko"},{"name":"Denmark","code":"DK","continentId":6,"callingCode":45,"localName":"Danmark"},{"name":"Djibouti","code":"DJ","continentId":2,"callingCode":253,"localName":"جمهوريه جيبوتي‎"},{"name":"Dominica","code":"DM","continentId":3,"callingCode":1,"localName":"Dominica"},{"name":"Dominican Republic","code":"DO","continentId":3,"callingCode":1,"localName":"Dominicana"},{"name":"Ecuador","code":"EC","continentId":4,"callingCode":593,"localName":"Ecuador"},{"name":"Egypt","code":"EG","continentId":2,"callingCode":20,"localName":"جمهوريّة مصرالعربيّة‎"},{"name":"El Salvador","code":"SV","continentId":2,"callingCode":503,"localName":"El Salvador"},{"name":"Equatorial Guinea","code":"GQ","continentId":2,"callingCode":240,"localName":"Guinée équatoriale"},{"name":"Eritrea","code":"ER","continentId":2,"callingCode":291,"localName":"دولة إرتريا‎"},{"name":"Estonia","code":"EE","continentId":6,"callingCode":372,"localName":"Eesti"},{"name":"Ethiopia","code":"ET","continentId":2,"callingCode":251,"localName":"ኢትዮጵያ"},{"name":"Falkland Islands (malvinas)","code":"FK","continentId":4,"callingCode":500,"localName":"Falkland Islands"},{"name":"Faroe Islands","code":"FO","continentId":6,"callingCode":298,"localName":"Føroyar"},{"name":"Fiji","code":"FJ","continentId":7,"callingCode":679,"localName":"Matanitu Tugalala o Viti"},{"name":"Finland","code":"FI","continentId":6,"callingCode":358,"localName":"Suomen tasavalta"},{"name":"France","code":"FR","continentId":6,"callingCode":33,"localName":"française"},{"name":"French Guiana","code":"GF","continentId":4,"callingCode":594,"localName":"Guyane française"},{"name":"French Polynesia","code":"PF","continentId":7,"callingCode":689,"localName":"Polynésie française"},{"name":"French Southern Territories","code":"TF","continentId":5,"callingCode":262,"localName":"Terres australes et antarctiques françaises"},{"name":"Gabon","code":"GA","continentId":2,"callingCode":241,"localName":"gabonaise"},{"name":"Gambia","code":"GM","continentId":2,"callingCode":220,"localName":"The Gambia"},{"name":"Georgia","code":"GE","continentId":6,"callingCode":995,"localName":"საქართველო"},{"name":"Germany","code":"DE","continentId":6,"callingCode":49,"localName":"Deutschland"},{"name":"Ghana","code":"GH","continentId":2,"callingCode":233,"localName":"Ghana"},{"name":"Gibraltar","code":"GI","continentId":6,"callingCode":350,"localName":"Gibraltar"},{"name":"Greece","code":"GR","continentId":6,"callingCode":30,"localName":"Ελλάς"},{"name":"Greenland","code":"GL","continentId":3,"callingCode":299,"localName":"Kalaallit Nunaat"},{"name":"Grenada","code":"GD","continentId":3,"callingCode":1,"localName":"Grenada"},{"name":"Guadeloupe","code":"GP","continentId":3,"callingCode":590,"localName":"Guadeloupe"},{"name":"Guam","code":"GU","continentId":7,"callingCode":1,"localName":"Guåhån"},{"name":"Guatemala","code":"GT","continentId":3,"callingCode":502,"localName":"Guatemala"},{"name":"Guinea","code":"GN","continentId":2,"callingCode":224,"localName":"Guinée"},{"name":"Guinea-bissau","code":"GW","continentId":2,"callingCode":245,"localName":"Guiné-Bissau"},{"name":"Guyana","code":"GY","continentId":4,"callingCode":592,"localName":"Guyana"},{"name":"Haiti","code":"HT","continentId":3,"callingCode":509,"localName":"Haïti"},{"name":"Heard Island and Mcdonald Islands","code":"HM","continentId":7,"callingCode":672,"localName":"HIMI"},{"name":"Honduras","code":"HN","continentId":3,"callingCode":504,"localName":"Honduras"},{"name":"Hong Kong","code":"HK","continentId":1,"callingCode":852,"localName":"香港"},{"name":"Hungary","code":"HU","continentId":6,"callingCode":36,"localName":"Magyarország"},{"name":"Iceland","code":"IS","continentId":6,"callingCode":354,"localName":"Ísland"},{"name":"India","code":"IN","continentId":1,"callingCode":91,"localName":"भारत"},{"name":"Indonesia","code":"ID","continentId":1,"callingCode":62,"localName":"Indonesia"},{"name":"Iran","code":"IR","continentId":1,"callingCode":98,"localName":"ایران‎"},{"name":"Iraq","code":"IQ","continentId":1,"callingCode":964,"localName":"العراق‎"},{"name":"Ireland","code":"IE","continentId":6,"callingCode":353,"localName":"Éire"},{"name":"Israel","code":"IL","continentId":1,"callingCode":972,"localName":"יִשְׂרָאֵל‬"},{"name":"Italy","code":"IT","continentId":6,"callingCode":39,"localName":"Italia"},{"name":"Jamaica","code":"JM","continentId":3,"callingCode":1,"localName":"Jamaica"},{"name":"Japan","code":"JP","continentId":1,"callingCode":81,"localName":"日本"},{"name":"Jordan","code":"JO","continentId":1,"callingCode":962,"localName":"الأردنّ‎"},{"name":"Kazakhstan","code":"KZ","continentId":1,"callingCode":7,"localName":"Қазақстан"},{"name":"Kenya","code":"KE","continentId":2,"callingCode":254,"localName":"Kenya"},{"name":"Kiribati","code":"KI","continentId":7,"callingCode":686,"localName":"Kiribati"},{"name":"Korea, Democratic People\'s Republic Of","code":"KP","continentId":1,"callingCode":850,"localName":"북한"},{"name":"Korea, Republic Of","code":"KR","continentId":1,"callingCode":82,"localName":"대한민국"},{"name":"Kuwait","code":"KW","continentId":1,"callingCode":965,"localName":"الكويت‎"},{"name":"Kyrgyzstan","code":"KG","continentId":1,"callingCode":996,"localName":"Кыргызстан"},{"name":"Laos","code":"LA","continentId":1,"callingCode":856,"localName":"ລາວ Lāo"},{"name":"Latvia","code":"LV","continentId":6,"callingCode":371,"localName":"Latvija"},{"name":"Lebanon","code":"LB","continentId":1,"callingCode":961,"localName":"لبنان‎"},{"name":"Lesotho","code":"LS","continentId":2,"callingCode":266,"localName":"Lesotho"},{"name":"Liberia","code":"LR","continentId":2,"callingCode":231,"localName":"Liberia"},{"name":"Libya, State Of","code":"LY","continentId":2,"callingCode":218,"localName":"دولة ليبيا‎"},{"name":"Liechtenstein","code":"LI","continentId":6,"callingCode":423,"localName":"Fürstentum Liechtenstein"},{"name":"Lithuania","code":"LT","continentId":6,"callingCode":370,"localName":"Lietuva"},{"name":"Luxembourg","code":"LU","continentId":6,"callingCode":352,"localName":"Lëtzebuerg"},{"name":"Macao","code":"MO","continentId":1,"callingCode":853,"localName":"澳門"},{"name":"Macedonia","code":"MK","continentId":6,"callingCode":389,"localName":"Северна Македонија"},{"name":"Madagascar","code":"MG","continentId":2,"callingCode":261,"localName":"Madagasikara"},{"name":"Malawi","code":"MW","continentId":2,"callingCode":265,"localName":"Malaŵi"},{"name":"Malaysia","code":"MY","continentId":1,"callingCode":60,"localName":"Malaysia"},{"name":"Maldives","code":"MV","continentId":1,"callingCode":960,"localName":"ދިވެހިރާއްޖެ‎"},{"name":"Mali","code":"ML","continentId":2,"callingCode":223,"localName":"Mali"},{"name":"Malta","code":"MT","continentId":6,"callingCode":356,"localName":"Malta"},{"name":"Marshall Islands","code":"MH","continentId":7,"callingCode":692,"localName":"Aolepān Aorōkin M̧ajeļ"},{"name":"Martinique","code":"MQ","continentId":3,"callingCode":596,"localName":"Martinique"},{"name":"Mauritania","code":"MR","continentId":2,"callingCode":222,"localName":"موريتانيا‎"},{"name":"Mauritius","code":"MU","continentId":2,"callingCode":230,"localName":"Moris"},{"name":"Mayotte","code":"YT","continentId":2,"callingCode":262,"localName":"Maore"},{"name":"Mexico","code":"MX","continentId":3,"callingCode":52,"localName":"México"},{"name":"Micronesia","code":"FM","continentId":7,"callingCode":691,"localName":"Micronesia"},{"name":"Moldova","code":"MD","continentId":6,"callingCode":373,"localName":"Moldova"},{"name":"Monaco","code":"MC","continentId":6,"callingCode":377,"localName":"Principatu de Múnegu"},{"name":"Mongolia","code":"MN","continentId":1,"callingCode":976,"localName":"Монгол улс"},{"name":"Montenegro","code":"ME","continentId":6,"callingCode":382,"localName":"Црна Гора"},{"name":"Montserrat","code":"MS","continentId":3,"callingCode":1,"localName":"Montserrat"},{"name":"Morocco","code":"MA","continentId":2,"callingCode":212,"localName":"المغرب‎"},{"name":"Mozambique","code":"MZ","continentId":2,"callingCode":258,"localName":"Moçambique"},{"name":"Myanmar","code":"MM","continentId":1,"callingCode":95,"localName":"မြန်မာ"},{"name":"Namibia","code":"NA","continentId":2,"callingCode":264,"localName":"Namibië"},{"name":"Nauru","code":"NR","continentId":7,"callingCode":674,"localName":"Naoero"},{"name":"Nepal","code":"NP","continentId":1,"callingCode":977,"localName":"नेपाल"},{"name":"Netherlands","code":"NL","continentId":6,"callingCode":31,"localName":"Nederland"},{"name":"Netherlands Antilles","code":"AN","continentId":4,"callingCode":599,"localName":"Antias Hulandes"},{"name":"New Caledonia","code":"NC","continentId":7,"callingCode":687,"localName":"Nouvelle-Calédonie"},{"name":"New Zealand","code":"NZ","continentId":7,"callingCode":64,"localName":"New Zealand"},{"name":"Nicaragua","code":"NI","continentId":3,"callingCode":505,"localName":"Nicaragua"},{"name":"Niger","code":"NE","continentId":2,"callingCode":227,"localName":"Niger"},{"name":"Nigeria","code":"NG","continentId":2,"callingCode":234,"localName":"Nigeria"},{"name":"Niue","code":"NU","continentId":7,"callingCode":683,"localName":"Niuē"},{"name":"Norfolk Island","code":"NF","continentId":7,"callingCode":672,"localName":"Teratri of Norf\'k Ailen"},{"name":"Northern Mariana Islands","code":"MP","continentId":7,"callingCode":1,"localName":"Sankattan Siha Na Islas Mariånas"},{"name":"Norway","code":"NO","continentId":6,"callingCode":47,"localName":"Norge"},{"name":"Oman","code":"OM","continentId":1,"callingCode":968,"localName":"عُمان‎"},{"name":"Pakistan","code":"PK","continentId":1,"callingCode":92,"localName":"اسلامی جمہوریہ پاکستان"},{"name":"Palau","code":"PW","continentId":7,"callingCode":680,"localName":"Belau"},{"name":"Palestine, State Of","code":"PS","continentId":1,"callingCode":970,"localName":"دولة فلسطين"},{"name":"Panama","code":"PA","continentId":3,"callingCode":507,"localName":"Panamá"},{"name":"Papua New Guinea","code":"PG","continentId":7,"callingCode":675,"localName":"Papua Niugini"},{"name":"Paraguay","code":"PY","continentId":4,"callingCode":595,"localName":"Tetã Paraguái"},{"name":"Peru","code":"PE","continentId":4,"callingCode":51,"localName":"Perú"},{"name":"Philippines","code":"PH","continentId":1,"callingCode":63,"localName":"Pilipinas"},{"name":"Pitcairn","code":"PN","continentId":7,"callingCode":64,"localName":"Pitkern Ailen"},{"name":"Poland","code":"PL","continentId":6,"callingCode":48,"localName":"Polska"},{"name":"Portugal","code":"PT","continentId":6,"callingCode":351,"localName":"Portuguesa"},{"name":"Puerto Rico","code":"PR","continentId":3,"callingCode":1,"localName":"Puerto Rico"},{"name":"Qatar","code":"QA","continentId":1,"callingCode":974,"localName":"قطر‎"},{"name":"Reunion","code":"RE","continentId":2,"callingCode":262,"localName":"La Réunion"},{"name":"Romania","code":"RO","continentId":6,"callingCode":40,"localName":"România"},{"name":"Russian Federation","code":"RU","continentId":1,"callingCode":7,"localName":"Россия"},{"name":"Rwanda","code":"RW","continentId":2,"callingCode":250,"localName":"Rwanda"},{"name":"Saint Helena","code":"SH","continentId":2,"callingCode":290,"localName":"Saint Helena"},{"name":"Saint Kitts and Nevis","code":"KN","continentId":3,"callingCode":1,"localName":"Saint Kitts and Nevis"},{"name":"Saint Lucia","code":"LC","continentId":3,"callingCode":1,"localName":"Saint Lucia"},{"name":"Saint Pierre and Miquelon","code":"PM","continentId":3,"callingCode":508,"localName":"Saint-Pierre-et-Miquelon"},{"name":"Saint Vincent and The Grenadines","code":"VC","continentId":3,"callingCode":1,"localName":"Saint Vincent and the Grenadines"},{"name":"Samoa","code":"WS","continentId":7,"callingCode":685,"localName":"Malo Sa\'oloto Tuto\'atasi o Samoa"},{"name":"San Marino","code":"SM","continentId":6,"callingCode":378,"localName":"San Marino"},{"name":"Sao Tome and Principe","code":"ST","continentId":2,"callingCode":239,"localName":"São Tomé e Príncipe"},{"name":"Saudi Arabia","code":"SA","continentId":1,"callingCode":966,"localName":"العربية السعودية‎"},{"name":"Senegal","code":"SN","continentId":2,"callingCode":221,"localName":"Sénégal"},{"name":"Serbia","code":"RS","continentId":6,"callingCode":381,"localName":"Србија"},{"name":"Seychelles","code":"SC","continentId":2,"callingCode":248,"localName":"Repiblik Sesel"},{"name":"Sierra Leone","code":"SL","continentId":2,"callingCode":232,"localName":"Sierra Leone"},{"name":"Singapore","code":"SG","continentId":1,"callingCode":65,"localName":"新加坡"},{"name":"Slovakia","code":"SK","continentId":6,"callingCode":421,"localName":"Slovenská"},{"name":"Slovenia","code":"SI","continentId":6,"callingCode":386,"localName":"Slovenija"},{"name":"Solomon Islands","code":"SB","continentId":7,"callingCode":677,"localName":"Solomon Islands"},{"name":"Somalia","code":"SO","continentId":2,"callingCode":252,"localName":"الصومال"},{"name":"South Africa","code":"ZA","continentId":2,"callingCode":27,"localName":"Suid-Afrika"},{"name":"South Georgia and The South Sandwich Islands","code":"GS","continentId":7,"callingCode":500,"localName":"SGSSI"},{"name":"South Sudan","code":"SS","continentId":2,"callingCode":211,"localName":"South Sudan"},{"name":"Spain","code":"ES","continentId":6,"callingCode":34,"localName":"España"},{"name":"Sri Lanka","code":"LK","continentId":1,"callingCode":94,"localName":"ශ්‍රී ලංකාව"},{"name":"Sudan","code":"SD","continentId":2,"callingCode":249,"localName":"جمهورية السودان‎"},{"name":"Suriname","code":"SR","continentId":4,"callingCode":597,"localName":"Suriname"},{"name":"Svalbard and Jan Mayen","code":"SJ","continentId":6,"callingCode":47,"localName":"Svalbard og Jan Mayen"},{"name":"Swaziland","code":"SZ","continentId":2,"callingCode":268,"localName":"eSwatini"},{"name":"Sweden","code":"SE","continentId":6,"callingCode":46,"localName":"Sverige"},{"name":"Switzerland","code":"CH","continentId":6,"callingCode":41,"localName":"Schweiz"},{"name":"Syrian Arab","code":"SY","continentId":1,"callingCode":963,"localName":"‎سوريا‎‎"},{"name":"Taiwan","code":"TW","continentId":1,"callingCode":886,"localName":"台灣"},{"name":"Tajikistan","code":"TJ","continentId":1,"callingCode":992,"localName":"Ҷумҳурии Тоҷикистон"},{"name":"Tanzania","code":"TZ","continentId":2,"callingCode":255,"localName":"Jamhuri ya Muungano wa Tanzania"},{"name":"Thailand","code":"TH","continentId":1,"callingCode":66,"localName":"ประเทศไทย"},{"name":"Timor-leste","code":"TL","continentId":1,"callingCode":670,"localName":"Timor Lorosa\'e"},{"name":"Togo","code":"TG","continentId":2,"callingCode":228,"localName":"Togo"},{"name":"Tokelau","code":"TK","continentId":7,"callingCode":690,"localName":"Tokelau"},{"name":"Tonga","code":"TO","continentId":7,"callingCode":676,"localName":"Pule\'anga Fakatu\'i \'o Tonga"},{"name":"Trinidad and Tobago","code":"TT","continentId":3,"callingCode":1,"localName":"Trinidad and Tobago"},{"name":"Tunisia","code":"TN","continentId":2,"callingCode":216,"localName":"الجمهورية التونسية‎"},{"name":"Turkey","code":"TR","continentId":6,"callingCode":90,"localName":"Türkiye"},{"name":"Turkmenistan","code":"TM","continentId":1,"callingCode":993,"localName":"Türkmenistan"},{"name":"Turks and Caicos Islands","code":"TC","continentId":3,"callingCode":1,"localName":"Turks and Caicos Islands"},{"name":"Tuvalu","code":"TV","continentId":7,"callingCode":688,"localName":"Tuvalu"},{"name":"Uganda","code":"UG","continentId":2,"callingCode":256,"localName":"Uganda"},{"name":"Ukraine","code":"UA","continentId":6,"callingCode":380,"localName":"Україна"},{"name":"United Arab Emirates","code":"AE","continentId":1,"callingCode":971,"localName":"الإمارات‎"},{"name":"United Kingdom","code":"GB","continentId":6,"callingCode":44,"localName":"United Kingdom"},{"name":"United States","code":"US","continentId":3,"callingCode":1,"localName":"United States"},{"name":"United States Minor Outlying Islands","code":"UM","continentId":3,"callingCode":1,"localName":"United States Minor Outlying Islands"},{"name":"Uruguay","code":"UY","continentId":4,"callingCode":598,"localName":"Uruguay"},{"name":"Uzbekistan","code":"UZ","continentId":1,"callingCode":998,"localName":"O\'zbekiston"},{"name":"Vanuatu","code":"VU","continentId":7,"callingCode":678,"localName":"Vanuatu"},{"name":"Venezuela","code":"VE","continentId":4,"callingCode":58,"localName":"Venezuela"},{"name":"Viet Nam","code":"VN","continentId":1,"callingCode":84,"localName":"Việt Nam"},{"name":"Virgin Islands, British","code":"VG","continentId":3,"callingCode":1,"localName":"British Virgin Islands"},{"name":"Virgin Islands, U.S.","code":"VI","continentId":3,"callingCode":1,"localName":"United States Virgin Islands"},{"name":"Wallis and Futuna","code":"WF","continentId":7,"callingCode":681,"localName":"Wallis et Futuna"},{"name":"Western Sahara","code":"EH","continentId":2,"callingCode":212,"localName":"الصحراء الغربية‎"},{"name":"Yemen","code":"YE","continentId":1,"callingCode":967,"localName":"اليمن‎"},{"name":"Zambia","code":"ZM","continentId":2,"callingCode":260,"localName":"Zambia"},{"name":"Zimbabwe","code":"ZW","continentId":2,"callingCode":263,"localName":"Zimbabwe"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'currency_codes',
                'item_value' => '[{"ctryName":"AFGHANISTAN","name":"Afghani","code":"AFN","ccyNbr":"971","ccyMnrUnts":"2"},{"ctryName":"ÅLAND ISLANDS","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"ALBANIA","name":"Lek","code":"ALL","ccyNbr":"008","ccyMnrUnts":"2"},{"ctryName":"ALGERIA","name":"Algerian Dinar","code":"DZD","ccyNbr":"012","ccyMnrUnts":"2"},{"ctryName":"AMERICAN SAMOA","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"ANDORRA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"ANGOLA","name":"Kwanza","code":"AOA","ccyNbr":"973","ccyMnrUnts":"2"},{"ctryName":"ANGUILLA","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"ANTIGUA AND BARBUDA","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"ARGENTINA","name":"Argentine Peso","code":"ARS","ccyNbr":"032","ccyMnrUnts":"2"},{"ctryName":"ARMENIA","name":"Armenian Dram","code":"AMD","ccyNbr":"051","ccyMnrUnts":"2"},{"ctryName":"ARUBA","name":"Aruban Florin","code":"AWG","ccyNbr":"533","ccyMnrUnts":"2"},{"ctryName":"AUSTRALIA","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"AUSTRIA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"AZERBAIJAN","name":"Azerbaijan Manat","code":"AZN","ccyNbr":"944","ccyMnrUnts":"2"},{"ctryName":"BAHAMAS (THE)","name":"Bahamian Dollar","code":"BSD","ccyNbr":"044","ccyMnrUnts":"2"},{"ctryName":"BAHRAIN","name":"Bahraini Dinar","code":"BHD","ccyNbr":"048","ccyMnrUnts":"3"},{"ctryName":"BANGLADESH","name":"Taka","code":"BDT","ccyNbr":"050","ccyMnrUnts":"2"},{"ctryName":"BARBADOS","name":"Barbados Dollar","code":"BBD","ccyNbr":"052","ccyMnrUnts":"2"},{"ctryName":"BELARUS","name":"Belarusian Ruble","code":"BYN","ccyNbr":"933","ccyMnrUnts":"2"},{"ctryName":"BELGIUM","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"BELIZE","name":"Belize Dollar","code":"BZD","ccyNbr":"084","ccyMnrUnts":"2"},{"ctryName":"BENIN","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"BERMUDA","name":"Bermudian Dollar","code":"BMD","ccyNbr":"060","ccyMnrUnts":"2"},{"ctryName":"BHUTAN","name":"Indian Rupee","code":"INR","ccyNbr":"356","ccyMnrUnts":"2"},{"ctryName":"BHUTAN","name":"Ngultrum","code":"BTN","ccyNbr":"064","ccyMnrUnts":"2"},{"ctryName":"BOLIVIA (PLURINATIONAL STATE OF)","name":"Boliviano","code":"BOB","ccyNbr":"068","ccyMnrUnts":"2"},{"ctryName":"BONAIRE, SINT EUSTATIUS AND SABA","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"BOSNIA AND HERZEGOVINA","name":"Convertible Mark","code":"BAM","ccyNbr":"977","ccyMnrUnts":"2"},{"ctryName":"BOTSWANA","name":"Pula","code":"BWP","ccyNbr":"072","ccyMnrUnts":"2"},{"ctryName":"BOUVET ISLAND","name":"Norwegian Krone","code":"NOK","ccyNbr":"578","ccyMnrUnts":"2"},{"ctryName":"BRAZIL","name":"Brazilian Real","code":"BRL","ccyNbr":"986","ccyMnrUnts":"2"},{"ctryName":"BRITISH INDIAN OCEAN TERRITORY (THE)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"BRUNEI DARUSSALAM","name":"Brunei Dollar","code":"BND","ccyNbr":"096","ccyMnrUnts":"2"},{"ctryName":"BULGARIA","name":"Bulgarian Lev","code":"BGN","ccyNbr":"975","ccyMnrUnts":"2"},{"ctryName":"BURKINA FASO","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"BURUNDI","name":"Burundi Franc","code":"BIF","ccyNbr":"108","ccyMnrUnts":"0"},{"ctryName":"CABO VERDE","name":"Cabo Verde Escudo","code":"CVE","ccyNbr":"132","ccyMnrUnts":"2"},{"ctryName":"CAMBODIA","name":"Riel","code":"KHR","ccyNbr":"116","ccyMnrUnts":"2"},{"ctryName":"CAMEROON","name":"CFA Franc BEAC","code":"XAF","ccyNbr":"950","ccyMnrUnts":"0"},{"ctryName":"CANADA","name":"Canadian Dollar","code":"CAD","ccyNbr":"124","ccyMnrUnts":"2"},{"ctryName":"CAYMAN ISLANDS (THE)","name":"Cayman Islands Dollar","code":"KYD","ccyNbr":"136","ccyMnrUnts":"2"},{"ctryName":"CENTRAL AFRICAN REPUBLIC (THE)","name":"CFA Franc BEAC","code":"XAF","ccyNbr":"950","ccyMnrUnts":"0"},{"ctryName":"CHAD","name":"CFA Franc BEAC","code":"XAF","ccyNbr":"950","ccyMnrUnts":"0"},{"ctryName":"CHILE","name":"Chilean Peso","code":"CLP","ccyNbr":"152","ccyMnrUnts":"0"},{"ctryName":"CHINA","name":"Yuan Renminbi","code":"CNY","ccyNbr":"156","ccyMnrUnts":"2"},{"ctryName":"CHRISTMAS ISLAND","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"COCOS (KEELING) ISLANDS (THE)","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"COLOMBIA","name":"Colombian Peso","code":"COP","ccyNbr":"170","ccyMnrUnts":"2"},{"ctryName":"COMOROS (THE)","name":"Comorian Franc","code":"KMF","ccyNbr":"174","ccyMnrUnts":"0"},{"ctryName":"CONGO (THE DEMOCRATIC REPUBLIC OF THE)","name":"Congolese Franc","code":"CDF","ccyNbr":"976","ccyMnrUnts":"2"},{"ctryName":"CONGO (THE)","name":"CFA Franc BEAC","code":"XAF","ccyNbr":"950","ccyMnrUnts":"0"},{"ctryName":"COOK ISLANDS (THE)","name":"New Zealand Dollar","code":"NZD","ccyNbr":"554","ccyMnrUnts":"2"},{"ctryName":"COSTA RICA","name":"Costa Rican Colon","code":"CRC","ccyNbr":"188","ccyMnrUnts":"2"},{"ctryName":"CÔTE D\'IVOIRE","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"CROATIA","name":"Kuna","code":"HRK","ccyNbr":"191","ccyMnrUnts":"2"},{"ctryName":"CUBA","name":"Cuban Peso","code":"CUP","ccyNbr":"192","ccyMnrUnts":"2"},{"ctryName":"CUBA","name":"Peso Convertible","code":"CUC","ccyNbr":"931","ccyMnrUnts":"2"},{"ctryName":"CURAÇAO","name":"Netherlands Antillean Guilder","code":"ANG","ccyNbr":"532","ccyMnrUnts":"2"},{"ctryName":"CYPRUS","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"CZECHIA","name":"Czech Koruna","code":"CZK","ccyNbr":"203","ccyMnrUnts":"2"},{"ctryName":"DENMARK","name":"Danish Krone","code":"DKK","ccyNbr":"208","ccyMnrUnts":"2"},{"ctryName":"DJIBOUTI","name":"Djibouti Franc","code":"DJF","ccyNbr":"262","ccyMnrUnts":"0"},{"ctryName":"DOMINICA","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"DOMINICAN REPUBLIC (THE)","name":"Dominican Peso","code":"DOP","ccyNbr":"214","ccyMnrUnts":"2"},{"ctryName":"ECUADOR","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"EGYPT","name":"Egyptian Pound","code":"EGP","ccyNbr":"818","ccyMnrUnts":"2"},{"ctryName":"EL SALVADOR","name":"El Salvador Colon","code":"SVC","ccyNbr":"222","ccyMnrUnts":"2"},{"ctryName":"EL SALVADOR","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"EQUATORIAL GUINEA","name":"CFA Franc BEAC","code":"XAF","ccyNbr":"950","ccyMnrUnts":"0"},{"ctryName":"ERITREA","name":"Nakfa","code":"ERN","ccyNbr":"232","ccyMnrUnts":"2"},{"ctryName":"ESTONIA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"ESWATINI","name":"Lilangeni","code":"SZL","ccyNbr":"748","ccyMnrUnts":"2"},{"ctryName":"ETHIOPIA","name":"Ethiopian Birr","code":"ETB","ccyNbr":"230","ccyMnrUnts":"2"},{"ctryName":"EUROPEAN UNION","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"FALKLAND ISLANDS (THE) [MALVINAS]","name":"Falkland Islands Pound","code":"FKP","ccyNbr":"238","ccyMnrUnts":"2"},{"ctryName":"FAROE ISLANDS (THE)","name":"Danish Krone","code":"DKK","ccyNbr":"208","ccyMnrUnts":"2"},{"ctryName":"FIJI","name":"Fiji Dollar","code":"FJD","ccyNbr":"242","ccyMnrUnts":"2"},{"ctryName":"FINLAND","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"FRANCE","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"FRENCH GUIANA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"FRENCH POLYNESIA","name":"CFP Franc","code":"XPF","ccyNbr":"953","ccyMnrUnts":"0"},{"ctryName":"FRENCH SOUTHERN TERRITORIES (THE)","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"GABON","name":"CFA Franc BEAC","code":"XAF","ccyNbr":"950","ccyMnrUnts":"0"},{"ctryName":"GAMBIA (THE)","name":"Dalasi","code":"GMD","ccyNbr":"270","ccyMnrUnts":"2"},{"ctryName":"GEORGIA","name":"Lari","code":"GEL","ccyNbr":"981","ccyMnrUnts":"2"},{"ctryName":"GERMANY","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"GHANA","name":"Ghana Cedi","code":"GHS","ccyNbr":"936","ccyMnrUnts":"2"},{"ctryName":"GIBRALTAR","name":"Gibraltar Pound","code":"GIP","ccyNbr":"292","ccyMnrUnts":"2"},{"ctryName":"GREECE","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"GREENLAND","name":"Danish Krone","code":"DKK","ccyNbr":"208","ccyMnrUnts":"2"},{"ctryName":"GRENADA","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"GUADELOUPE","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"GUAM","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"GUATEMALA","name":"Quetzal","code":"GTQ","ccyNbr":"320","ccyMnrUnts":"2"},{"ctryName":"GUERNSEY","name":"Pound Sterling","code":"GBP","ccyNbr":"826","ccyMnrUnts":"2"},{"ctryName":"GUINEA","name":"Guinean Franc","code":"GNF","ccyNbr":"324","ccyMnrUnts":"0"},{"ctryName":"GUINEA-BISSAU","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"GUYANA","name":"Guyana Dollar","code":"GYD","ccyNbr":"328","ccyMnrUnts":"2"},{"ctryName":"HAITI","name":"Gourde","code":"HTG","ccyNbr":"332","ccyMnrUnts":"2"},{"ctryName":"HAITI","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"HEARD ISLAND AND McDONALD ISLANDS","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"HOLY SEE (THE)","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"HONDURAS","name":"Lempira","code":"HNL","ccyNbr":"340","ccyMnrUnts":"2"},{"ctryName":"HONG KONG","name":"Hong Kong Dollar","code":"HKD","ccyNbr":"344","ccyMnrUnts":"2"},{"ctryName":"HUNGARY","name":"Forint","code":"HUF","ccyNbr":"348","ccyMnrUnts":"2"},{"ctryName":"ICELAND","name":"Iceland Krona","code":"ISK","ccyNbr":"352","ccyMnrUnts":"0"},{"ctryName":"INDIA","name":"Indian Rupee","code":"INR","ccyNbr":"356","ccyMnrUnts":"2"},{"ctryName":"INDONESIA","name":"Rupiah","code":"IDR","ccyNbr":"360","ccyMnrUnts":"2"},{"ctryName":"INTERNATIONAL MONETARY FUND (IMF)","name":"SDR (Special Drawing Right)","code":"XDR","ccyNbr":"960","ccyMnrUnts":"N.A."},{"ctryName":"IRAN (ISLAMIC REPUBLIC OF)","name":"Iranian Rial","code":"IRR","ccyNbr":"364","ccyMnrUnts":"2"},{"ctryName":"IRAQ","name":"Iraqi Dinar","code":"IQD","ccyNbr":"368","ccyMnrUnts":"3"},{"ctryName":"IRELAND","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"ISLE OF MAN","name":"Pound Sterling","code":"GBP","ccyNbr":"826","ccyMnrUnts":"2"},{"ctryName":"ISRAEL","name":"New Israeli Sheqel","code":"ILS","ccyNbr":"376","ccyMnrUnts":"2"},{"ctryName":"ITALY","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"JAMAICA","name":"Jamaican Dollar","code":"JMD","ccyNbr":"388","ccyMnrUnts":"2"},{"ctryName":"JAPAN","name":"Yen","code":"JPY","ccyNbr":"392","ccyMnrUnts":"0"},{"ctryName":"JERSEY","name":"Pound Sterling","code":"GBP","ccyNbr":"826","ccyMnrUnts":"2"},{"ctryName":"JORDAN","name":"Jordanian Dinar","code":"JOD","ccyNbr":"400","ccyMnrUnts":"3"},{"ctryName":"KAZAKHSTAN","name":"Tenge","code":"KZT","ccyNbr":"398","ccyMnrUnts":"2"},{"ctryName":"KENYA","name":"Kenyan Shilling","code":"KES","ccyNbr":"404","ccyMnrUnts":"2"},{"ctryName":"KIRIBATI","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"KOREA (THE DEMOCRATIC PEOPLE’S REPUBLIC OF)","name":"North Korean Won","code":"KPW","ccyNbr":"408","ccyMnrUnts":"2"},{"ctryName":"KOREA (THE REPUBLIC OF)","name":"Won","code":"KRW","ccyNbr":"410","ccyMnrUnts":"0"},{"ctryName":"KUWAIT","name":"Kuwaiti Dinar","code":"KWD","ccyNbr":"414","ccyMnrUnts":"3"},{"ctryName":"KYRGYZSTAN","name":"Som","code":"KGS","ccyNbr":"417","ccyMnrUnts":"2"},{"ctryName":"LAO PEOPLE’S DEMOCRATIC REPUBLIC (THE)","name":"Lao Kip","code":"LAK","ccyNbr":"418","ccyMnrUnts":"2"},{"ctryName":"LATVIA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"LEBANON","name":"Lebanese Pound","code":"LBP","ccyNbr":"422","ccyMnrUnts":"2"},{"ctryName":"LESOTHO","name":"Loti","code":"LSL","ccyNbr":"426","ccyMnrUnts":"2"},{"ctryName":"LESOTHO","name":"Rand","code":"ZAR","ccyNbr":"710","ccyMnrUnts":"2"},{"ctryName":"LIBERIA","name":"Liberian Dollar","code":"LRD","ccyNbr":"430","ccyMnrUnts":"2"},{"ctryName":"LIBYA","name":"Libyan Dinar","code":"LYD","ccyNbr":"434","ccyMnrUnts":"3"},{"ctryName":"LIECHTENSTEIN","name":"Swiss Franc","code":"CHF","ccyNbr":"756","ccyMnrUnts":"2"},{"ctryName":"LITHUANIA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"LUXEMBOURG","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"MACAO","name":"Pataca","code":"MOP","ccyNbr":"446","ccyMnrUnts":"2"},{"ctryName":"NORTH MACEDONIA","name":"Denar","code":"MKD","ccyNbr":"807","ccyMnrUnts":"2"},{"ctryName":"MADAGASCAR","name":"Malagasy Ariary","code":"MGA","ccyNbr":"969","ccyMnrUnts":"2"},{"ctryName":"MALAWI","name":"Malawi Kwacha","code":"MWK","ccyNbr":"454","ccyMnrUnts":"2"},{"ctryName":"MALAYSIA","name":"Malaysian Ringgit","code":"MYR","ccyNbr":"458","ccyMnrUnts":"2"},{"ctryName":"MALDIVES","name":"Rufiyaa","code":"MVR","ccyNbr":"462","ccyMnrUnts":"2"},{"ctryName":"MALI","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"MALTA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"MARSHALL ISLANDS (THE)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"MARTINIQUE","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"MAURITANIA","name":"Ouguiya","code":"MRU","ccyNbr":"929","ccyMnrUnts":"2"},{"ctryName":"MAURITIUS","name":"Mauritius Rupee","code":"MUR","ccyNbr":"480","ccyMnrUnts":"2"},{"ctryName":"MAYOTTE","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"MEMBER COUNTRIES OF THE AFRICAN DEVELOPMENT BANK GROUP","name":"ADB Unit of Account","code":"XUA","ccyNbr":"965","ccyMnrUnts":"N.A."},{"ctryName":"MEXICO","name":"Mexican Peso","code":"MXN","ccyNbr":"484","ccyMnrUnts":"2"},{"ctryName":"MICRONESIA (FEDERATED STATES OF)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"MOLDOVA (THE REPUBLIC OF)","name":"Moldovan Leu","code":"MDL","ccyNbr":"498","ccyMnrUnts":"2"},{"ctryName":"MONACO","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"MONGOLIA","name":"Tugrik","code":"MNT","ccyNbr":"496","ccyMnrUnts":"2"},{"ctryName":"MONTENEGRO","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"MONTSERRAT","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"MOROCCO","name":"Moroccan Dirham","code":"MAD","ccyNbr":"504","ccyMnrUnts":"2"},{"ctryName":"MOZAMBIQUE","name":"Mozambique Metical","code":"MZN","ccyNbr":"943","ccyMnrUnts":"2"},{"ctryName":"MYANMAR","name":"Kyat","code":"MMK","ccyNbr":"104","ccyMnrUnts":"2"},{"ctryName":"NAMIBIA","name":"Namibia Dollar","code":"NAD","ccyNbr":"516","ccyMnrUnts":"2"},{"ctryName":"NAMIBIA","name":"Rand","code":"ZAR","ccyNbr":"710","ccyMnrUnts":"2"},{"ctryName":"NAURU","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"NEPAL","name":"Nepalese Rupee","code":"NPR","ccyNbr":"524","ccyMnrUnts":"2"},{"ctryName":"NETHERLANDS (THE)","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"NEW CALEDONIA","name":"CFP Franc","code":"XPF","ccyNbr":"953","ccyMnrUnts":"0"},{"ctryName":"NEW ZEALAND","name":"New Zealand Dollar","code":"NZD","ccyNbr":"554","ccyMnrUnts":"2"},{"ctryName":"NICARAGUA","name":"Cordoba Oro","code":"NIO","ccyNbr":"558","ccyMnrUnts":"2"},{"ctryName":"NIGER (THE)","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"NIGERIA","name":"Naira","code":"NGN","ccyNbr":"566","ccyMnrUnts":"2"},{"ctryName":"NIUE","name":"New Zealand Dollar","code":"NZD","ccyNbr":"554","ccyMnrUnts":"2"},{"ctryName":"NORFOLK ISLAND","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"NORTHERN MARIANA ISLANDS (THE)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"NORWAY","name":"Norwegian Krone","code":"NOK","ccyNbr":"578","ccyMnrUnts":"2"},{"ctryName":"OMAN","name":"Rial Omani","code":"OMR","ccyNbr":"512","ccyMnrUnts":"3"},{"ctryName":"PAKISTAN","name":"Pakistan Rupee","code":"PKR","ccyNbr":"586","ccyMnrUnts":"2"},{"ctryName":"PALAU","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"PANAMA","name":"Balboa","code":"PAB","ccyNbr":"590","ccyMnrUnts":"2"},{"ctryName":"PANAMA","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"PAPUA NEW GUINEA","name":"Kina","code":"PGK","ccyNbr":"598","ccyMnrUnts":"2"},{"ctryName":"PARAGUAY","name":"Guarani","code":"PYG","ccyNbr":"600","ccyMnrUnts":"0"},{"ctryName":"PERU","name":"Sol","code":"PEN","ccyNbr":"604","ccyMnrUnts":"2"},{"ctryName":"PHILIPPINES (THE)","name":"Philippine Peso","code":"PHP","ccyNbr":"608","ccyMnrUnts":"2"},{"ctryName":"PITCAIRN","name":"New Zealand Dollar","code":"NZD","ccyNbr":"554","ccyMnrUnts":"2"},{"ctryName":"POLAND","name":"Zloty","code":"PLN","ccyNbr":"985","ccyMnrUnts":"2"},{"ctryName":"PORTUGAL","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"PUERTO RICO","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"QATAR","name":"Qatari Rial","code":"QAR","ccyNbr":"634","ccyMnrUnts":"2"},{"ctryName":"RÉUNION","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"ROMANIA","name":"Romanian Leu","code":"RON","ccyNbr":"946","ccyMnrUnts":"2"},{"ctryName":"RUSSIAN FEDERATION (THE)","name":"Russian Ruble","code":"RUB","ccyNbr":"643","ccyMnrUnts":"2"},{"ctryName":"RWANDA","name":"Rwanda Franc","code":"RWF","ccyNbr":"646","ccyMnrUnts":"0"},{"ctryName":"SAINT BARTHÉLEMY","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"SAINT HELENA, ASCENSION AND TRISTAN DA CUNHA","name":"Saint Helena Pound","code":"SHP","ccyNbr":"654","ccyMnrUnts":"2"},{"ctryName":"SAINT KITTS AND NEVIS","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"SAINT LUCIA","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"SAINT MARTIN (FRENCH PART)","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"SAINT PIERRE AND MIQUELON","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"SAINT VINCENT AND THE GRENADINES","name":"East Caribbean Dollar","code":"XCD","ccyNbr":"951","ccyMnrUnts":"2"},{"ctryName":"SAMOA","name":"Tala","code":"WST","ccyNbr":"882","ccyMnrUnts":"2"},{"ctryName":"SAN MARINO","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"SAO TOME AND PRINCIPE","name":"Dobra","code":"STN","ccyNbr":"930","ccyMnrUnts":"2"},{"ctryName":"SAUDI ARABIA","name":"Saudi Riyal","code":"SAR","ccyNbr":"682","ccyMnrUnts":"2"},{"ctryName":"SENEGAL","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"SERBIA","name":"Serbian Dinar","code":"RSD","ccyNbr":"941","ccyMnrUnts":"2"},{"ctryName":"SEYCHELLES","name":"Seychelles Rupee","code":"SCR","ccyNbr":"690","ccyMnrUnts":"2"},{"ctryName":"SIERRA LEONE","name":"Leone","code":"SLL","ccyNbr":"694","ccyMnrUnts":"2"},{"ctryName":"SINGAPORE","name":"Singapore Dollar","code":"SGD","ccyNbr":"702","ccyMnrUnts":"2"},{"ctryName":"SINT MAARTEN (DUTCH PART)","name":"Netherlands Antillean Guilder","code":"ANG","ccyNbr":"532","ccyMnrUnts":"2"},{"ctryName":"SISTEMA UNITARIO DE COMPENSACION REGIONAL DE PAGOS(SUCRE)","name":"Sucre","code":"XSU","ccyNbr":"994","ccyMnrUnts":"N.A."},{"ctryName":"SLOVAKIA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"SLOVENIA","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"SOLOMON ISLANDS","name":"Solomon Islands Dollar","code":"SBD","ccyNbr":"090","ccyMnrUnts":"2"},{"ctryName":"SOMALIA","name":"Somali Shilling","code":"SOS","ccyNbr":"706","ccyMnrUnts":"2"},{"ctryName":"SOUTH AFRICA","name":"Rand","code":"ZAR","ccyNbr":"710","ccyMnrUnts":"2"},{"ctryName":"SOUTH SUDAN","name":"South Sudanese Pound","code":"SSP","ccyNbr":"728","ccyMnrUnts":"2"},{"ctryName":"SPAIN","name":"Euro","code":"EUR","ccyNbr":"978","ccyMnrUnts":"2"},{"ctryName":"SRI LANKA","name":"Sri Lanka Rupee","code":"LKR","ccyNbr":"144","ccyMnrUnts":"2"},{"ctryName":"SUDAN (THE)","name":"Sudanese Pound","code":"SDG","ccyNbr":"938","ccyMnrUnts":"2"},{"ctryName":"SURINAME","name":"Surinam Dollar","code":"SRD","ccyNbr":"968","ccyMnrUnts":"2"},{"ctryName":"SVALBARD AND JAN MAYEN","name":"Norwegian Krone","code":"NOK","ccyNbr":"578","ccyMnrUnts":"2"},{"ctryName":"SWEDEN","name":"Swedish Krona","code":"SEK","ccyNbr":"752","ccyMnrUnts":"2"},{"ctryName":"SWITZERLAND","name":"Swiss Franc","code":"CHF","ccyNbr":"756","ccyMnrUnts":"2"},{"ctryName":"SYRIAN ARAB REPUBLIC","name":"Syrian Pound","code":"SYP","ccyNbr":"760","ccyMnrUnts":"2"},{"ctryName":"TAIWAN","name":"New Taiwan Dollar","code":"TWD","ccyNbr":"901","ccyMnrUnts":"2"},{"ctryName":"TAJIKISTAN","name":"Somoni","code":"TJS","ccyNbr":"972","ccyMnrUnts":"2"},{"ctryName":"TANZANIA, UNITED REPUBLIC OF","name":"Tanzanian Shilling","code":"TZS","ccyNbr":"834","ccyMnrUnts":"2"},{"ctryName":"THAILAND","name":"Baht","code":"THB","ccyNbr":"764","ccyMnrUnts":"2"},{"ctryName":"TIMOR-LESTE","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"TOGO","name":"CFA Franc BCEAO","code":"XOF","ccyNbr":"952","ccyMnrUnts":"0"},{"ctryName":"TOKELAU","name":"New Zealand Dollar","code":"NZD","ccyNbr":"554","ccyMnrUnts":"2"},{"ctryName":"TONGA","name":"Pa’anga","code":"TOP","ccyNbr":"776","ccyMnrUnts":"2"},{"ctryName":"TRINIDAD AND TOBAGO","name":"Trinidad and Tobago Dollar","code":"TTD","ccyNbr":"780","ccyMnrUnts":"2"},{"ctryName":"TUNISIA","name":"Tunisian Dinar","code":"TND","ccyNbr":"788","ccyMnrUnts":"3"},{"ctryName":"TURKEY","name":"Turkish Lira","code":"TRY","ccyNbr":"949","ccyMnrUnts":"2"},{"ctryName":"TURKMENISTAN","name":"Turkmenistan New Manat","code":"TMT","ccyNbr":"934","ccyMnrUnts":"2"},{"ctryName":"TURKS AND CAICOS ISLANDS (THE)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"TUVALU","name":"Australian Dollar","code":"AUD","ccyNbr":"036","ccyMnrUnts":"2"},{"ctryName":"UGANDA","name":"Uganda Shilling","code":"UGX","ccyNbr":"800","ccyMnrUnts":"0"},{"ctryName":"UKRAINE","name":"Hryvnia","code":"UAH","ccyNbr":"980","ccyMnrUnts":"2"},{"ctryName":"UNITED ARAB EMIRATES (THE)","name":"UAE Dirham","code":"AED","ccyNbr":"784","ccyMnrUnts":"2"},{"ctryName":"UNITED KINGDOM OF GREAT BRITAIN AND NORTHERN IRELAND (THE)","name":"Pound Sterling","code":"GBP","ccyNbr":"826","ccyMnrUnts":"2"},{"ctryName":"UNITED STATES MINOR OUTLYING ISLANDS (THE)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"UNITED STATES OF AMERICA (THE)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"URUGUAY","name":"Peso Uruguayo","code":"UYU","ccyNbr":"858","ccyMnrUnts":"2"},{"ctryName":"URUGUAY","name":"Unidad Previsional","code":"UYW","ccyNbr":"927","ccyMnrUnts":"4"},{"ctryName":"UZBEKISTAN","name":"Uzbekistan Sum","code":"UZS","ccyNbr":"860","ccyMnrUnts":"2"},{"ctryName":"VANUATU","name":"Vatu","code":"VUV","ccyNbr":"548","ccyMnrUnts":"0"},{"ctryName":"VENEZUELA (BOLIVARIAN REPUBLIC OF)","name":"Bolívar Soberano","code":"VES","ccyNbr":"928","ccyMnrUnts":"2"},{"ctryName":"VIET NAM","name":"Dong","code":"VND","ccyNbr":"704","ccyMnrUnts":"0"},{"ctryName":"VIRGIN ISLANDS (BRITISH)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"VIRGIN ISLANDS (U.S.)","name":"US Dollar","code":"USD","ccyNbr":"840","ccyMnrUnts":"2"},{"ctryName":"WALLIS AND FUTUNA","name":"CFP Franc","code":"XPF","ccyNbr":"953","ccyMnrUnts":"0"},{"ctryName":"WESTERN SAHARA","name":"Moroccan Dirham","code":"MAD","ccyNbr":"504","ccyMnrUnts":"2"},{"ctryName":"YEMEN","name":"Yemeni Rial","code":"YER","ccyNbr":"886","ccyMnrUnts":"2"},{"ctryName":"ZAMBIA","name":"Zambian Kwacha","code":"ZMW","ccyNbr":"967","ccyMnrUnts":"2"},{"ctryName":"ZIMBABWE","name":"Zimbabwe Dollar","code":"ZWL","ccyNbr":"932","ccyMnrUnts":"2"},{"ctryName":"ZZ01_Bond Markets Unit European_EURCO","name":"Bond Markets Unit European Composite Unit (EURCO)","code":"XBA","ccyNbr":"955","ccyMnrUnts":"N.A."},{"ctryName":"ZZ02_Bond Markets Unit European_EMU-6","name":"Bond Markets Unit European Monetary Unit (E.M.U.-6)","code":"XBB","ccyNbr":"956","ccyMnrUnts":"N.A."},{"ctryName":"ZZ03_Bond Markets Unit European_EUA-9","name":"Bond Markets Unit European Unit of Account 9 (E.U.A.-9)","code":"XBC","ccyNbr":"957","ccyMnrUnts":"N.A."},{"ctryName":"ZZ04_Bond Markets Unit European_EUA-17","name":"Bond Markets Unit European Unit of Account 17 (E.U.A.-17)","code":"XBD","ccyNbr":"958","ccyMnrUnts":"N.A."},{"ctryName":"ZZ06_Testing_Code","name":"Codes specifically reserved for testing purposes","code":"XTS","ccyNbr":"963","ccyMnrUnts":"N.A."},{"ctryName":"ZZ07_No_Currency","name":"The codes assigned for transactions where no currency is involved","code":"XXX","ccyNbr":"999","ccyMnrUnts":"N.A."},{"ctryName":"ZZ08_Gold","name":"Gold","code":"XAU","ccyNbr":"959","ccyMnrUnts":"N.A."},{"ctryName":"ZZ09_Palladium","name":"Palladium","code":"XPD","ccyNbr":"964","ccyMnrUnts":"N.A."},{"ctryName":"ZZ10_Platinum","name":"Platinum","code":"XPT","ccyNbr":"962","ccyMnrUnts":"N.A."},{"ctryName":"ZZ11_Silver","name":"Silver","code":"XAG","ccyNbr":"961","ccyMnrUnts":"N.A."}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'language_codes',
                'item_value' => '[{"name":"Abkhazian","code":"ab","localName":"Аҧсуа","writingDirection":"ltr"},{"name":"Afar","code":"aa","localName":"Qafár af","writingDirection":"ltr"},{"name":"Afrikaans","code":"af","localName":"Afrikaans","writingDirection":"ltr"},{"name":"Akan","code":"ak","localName":"Akan","writingDirection":"ltr"},{"name":"Albanian","code":"sq","localName":"Shqip","writingDirection":"ltr"},{"name":"Amharic","code":"am","localName":"አማርኛ","writingDirection":"ltr"},{"name":"Arabic","code":"ar","localName":"العربية","writingDirection":"rtl"},{"name":"Aragonese","code":"an","localName":"Aragonés","writingDirection":"ltr"},{"name":"Armenian","code":"hy","localName":"Հայերեն","writingDirection":"ltr"},{"name":"Assamese","code":"as","localName":"অসমীয়া","writingDirection":"ltr"},{"name":"Avaric","code":"av","localName":"Авар","writingDirection":"ltr"},{"name":"Avestan","code":"ae","localName":"𐬎𐬞𐬀𐬯𐬙𐬀𐬎𐬎𐬀𐬐𐬀𐬉𐬥𐬀","writingDirection":"rtl"},{"name":"Aymara","code":"ay","localName":"Aymar","writingDirection":"ltr"},{"name":"Azerbaijani","code":"az","localName":"Azərbaycanca","writingDirection":"ltr"},{"name":"Bambara","code":"bm","localName":"Bamanankan","writingDirection":"ltr"},{"name":"Bashkir","code":"ba","localName":"Башҡорт","writingDirection":"ltr"},{"name":"Basque","code":"eu","localName":"Euskara","writingDirection":"ltr"},{"name":"Belarusian","code":"be","localName":"Беларуская","writingDirection":"ltr"},{"name":"Bengali (Bangla)","code":"bn","localName":"বাংলা","writingDirection":"ltr"},{"name":"Bihari","code":"bh","localName":"भोजपुरी","writingDirection":"ltr"},{"name":"Bislama","code":"bi","localName":"Bislama","writingDirection":"ltr"},{"name":"Bosnian","code":"bs","localName":"Bosanski","writingDirection":"ltr"},{"name":"Breton","code":"br","localName":"Brezhoneg","writingDirection":"ltr"},{"name":"Bulgarian","code":"bg","localName":"Български","writingDirection":"ltr"},{"name":"Burmese","code":"my","localName":"Myanmasa","writingDirection":"ltr"},{"name":"Catalan","code":"ca","localName":"Català","writingDirection":"ltr"},{"name":"Chamorro","code":"ch","localName":"Chamoru","writingDirection":"ltr"},{"name":"Chechen","code":"ce","localName":"Нохчийн","writingDirection":"ltr"},{"name":"Chichewa, Chewa, Nyanja","code":"ny","localName":"Chicheŵa/Chi-Chewa/Nyanja","writingDirection":"ltr"},{"name":"Chinese (Simplified)","code":"zh-Hans","localName":"简体中文","writingDirection":"ltr"},{"name":"Chinese (Traditional)","code":"zh-Hant","localName":"繁體中文","writingDirection":"ltr"},{"name":"Church Slavic","code":"cu","localName":"Словѣ́ньскъ/ⰔⰎⰑⰂⰡⰐⰠⰔⰍⰟ","writingDirection":"ltr"},{"name":"Chuvash","code":"cv","localName":"Чăвашла","writingDirection":"ltr"},{"name":"Cornish","code":"kw","localName":"Kernewek","writingDirection":"ltr"},{"name":"Corsican","code":"co","localName":"Corsu","writingDirection":"ltr"},{"name":"Cree","code":"cr","localName":"Nēhiyawēwin/ᓀᐦᐃᔭᐍᐏᐣ","writingDirection":"ltr"},{"name":"Croatian","code":"hr","localName":"Hrvatski","writingDirection":"ltr"},{"name":"Czech","code":"cs","localName":"Česky","writingDirection":"ltr"},{"name":"Danish","code":"da","localName":"Dansk","writingDirection":"ltr"},{"name":"Divehi, Dhivehi, Maldivian","code":"dv","localName":"ދިވެހިބަސް","writingDirection":"rtl"},{"name":"Dutch","code":"nl","localName":"Nederlands","writingDirection":"ltr"},{"name":"Dzongkha","code":"dz","localName":"ཇོང་ཁ","writingDirection":"ltr"},{"name":"English","code":"en","localName":"English","writingDirection":"ltr"},{"name":"Esperanto","code":"eo","localName":"Esperanto","writingDirection":"ltr"},{"name":"Estonian","code":"et","localName":"Eesti","writingDirection":"ltr"},{"name":"Ewe","code":"ee","localName":"Eʋegbe","writingDirection":"ltr"},{"name":"Faroese","code":"fo","localName":"Føroyskt","writingDirection":"ltr"},{"name":"Fijian","code":"fj","localName":"Na Vosa Vakaviti","writingDirection":"ltr"},{"name":"Finnish","code":"fi","localName":"Suomi","writingDirection":"ltr"},{"name":"French","code":"fr","localName":"Français","writingDirection":"ltr"},{"name":"Fula, Fulah, Pulaar, Pular","code":"ff","localName":"Fulfulde","writingDirection":"ltr"},{"name":"Galician","code":"gl","localName":"Galego","writingDirection":"ltr"},{"name":"Gaelic (Scottish)","code":"gd","localName":"Gàidhlig","writingDirection":"ltr"},{"name":"Gaelic (Manx)","code":"gv","localName":"Gaelg","writingDirection":"ltr"},{"name":"Georgian","code":"ka","localName":"ქართული","writingDirection":"ltr"},{"name":"German","code":"de","localName":"Deutsch","writingDirection":"ltr"},{"name":"Greek","code":"el","localName":"Ελληνικά","writingDirection":"ltr"},{"name":"Guarani","code":"gn","localName":"Avañe\'ẽ","writingDirection":"ltr"},{"name":"Gujarati","code":"gu","localName":"ગુજરાતી","writingDirection":"ltr"},{"name":"Haitian Creole","code":"ht","localName":"Kreyòl ayisyen","writingDirection":"ltr"},{"name":"Hausa","code":"ha","localName":"هَوُسَ","writingDirection":"rtl"},{"name":"Hebrew","code":"he","localName":"עברית","writingDirection":"rtl"},{"name":"Herero","code":"hz","localName":"Otsiherero","writingDirection":"ltr"},{"name":"Hindi","code":"hi","localName":"हिन्दी","writingDirection":"ltr"},{"name":"Hiri Motu","code":"ho","localName":"Hiri Motu","writingDirection":"ltr"},{"name":"Hungarian","code":"hu","localName":"Magyar","writingDirection":"ltr"},{"name":"Icelandic","code":"is","localName":"Íslenska","writingDirection":"ltr"},{"name":"Ido","code":"io","localName":"Ido","writingDirection":"ltr"},{"name":"Igbo","code":"ig","localName":"Igbo","writingDirection":"ltr"},{"name":"Indonesian","code":"id","localName":"Bahasa Indonesia","writingDirection":"ltr"},{"name":"Interlingua","code":"ia","localName":"Interlingua","writingDirection":"ltr"},{"name":"Interlingue","code":"ie","localName":"Interlingue","writingDirection":"ltr"},{"name":"Inuktitut","code":"iu","localName":"ᐃᓄᒃᑎᑐᑦ","writingDirection":"ltr"},{"name":"Inupiaq","code":"ik","localName":"Iñupiak","writingDirection":"ltr"},{"name":"Irish","code":"ga","localName":"Gaeilge","writingDirection":"ltr"},{"name":"Italian","code":"it","localName":"Italiano","writingDirection":"ltr"},{"name":"Japanese","code":"ja","localName":"日本語","writingDirection":"ltr"},{"name":"Javanese","code":"jv","localName":"Basa Jawa","writingDirection":"ltr"},{"name":"Kalaallisut, Greenlandic","code":"kl","localName":"Kalaallisut","writingDirection":"ltr"},{"name":"Kannada","code":"kn","localName":"ಕನ್ನಡ","writingDirection":"ltr"},{"name":"Kanuri","code":"kr","localName":"Kanuri","writingDirection":"ltr"},{"name":"Kashmiri","code":"ks","localName":"कश्मीरी - (كشميري)","writingDirection":"rtl"},{"name":"Kazakh","code":"kk","localName":"Қазақша","writingDirection":"ltr"},{"name":"Khmer","code":"km","localName":"ភាសាខ្មែរ","writingDirection":"ltr"},{"name":"Kikuyu","code":"ki","localName":"Gĩkũyũ","writingDirection":"ltr"},{"name":"Kinyarwanda (Rwanda)","code":"rw","localName":"Kinyarwanda","writingDirection":"ltr"},{"name":"Kirghiz","code":"ky","localName":"Кыргызча","writingDirection":"ltr"},{"name":"Komi","code":"kv","localName":"Коми","writingDirection":"ltr"},{"name":"Kongo","code":"kg","localName":"Kongo","writingDirection":"ltr"},{"name":"Korean","code":"ko","localName":"한국어","writingDirection":"ltr"},{"name":"Kurdish","code":"ku","localName":"Kurdî/كوردی","writingDirection":"rtl"},{"name":"Kwanyama","code":"kj","localName":"Kuanyama","writingDirection":"ltr"},{"name":"Lao","code":"lo","localName":"ລາວ","writingDirection":"ltr"},{"name":"Latin","code":"la","localName":"Latina","writingDirection":"ltr"},{"name":"Latvian (Lettish)","code":"lv","localName":"Latviešu","writingDirection":"ltr"},{"name":"Limburgish, Limburger, Limburgan","code":"li","localName":"Limburgs","writingDirection":"ltr"},{"name":"Lingala","code":"ln","localName":"Lingála","writingDirection":"ltr"},{"name":"Lithuanian","code":"lt","localName":"Lietuvių","writingDirection":"ltr"},{"name":"Luga-Katanga","code":"lu","localName":"Luga-Katanga","writingDirection":"ltr"},{"name":"Luganda, Ganda","code":"lg","localName":"Luganda","writingDirection":"ltr"},{"name":"Luxembourgish","code":"lb","localName":"Lëtzebuergesch","writingDirection":"ltr"},{"name":"Manx","code":"gv","localName":"Gaelg","writingDirection":"ltr"},{"name":"Macedonian","code":"mk","localName":"Македонски","writingDirection":"ltr"},{"name":"Malagasy","code":"mg","localName":"Malagasy","writingDirection":"ltr"},{"name":"Malay","code":"ms","localName":"Bahasa Melayu","writingDirection":"ltr"},{"name":"Malayalam","code":"ml","localName":"മലയാളം","writingDirection":"ltr"},{"name":"Maltese","code":"mt","localName":"Malti","writingDirection":"ltr"},{"name":"Maori","code":"mi","localName":"Māori","writingDirection":"ltr"},{"name":"Marathi","code":"mr","localName":"मराठी","writingDirection":"ltr"},{"name":"Marshallese","code":"mh","localName":"Ebon","writingDirection":"ltr"},{"name":"Moldovan","code":"mo","localName":"Молдовеняскэ","writingDirection":"ltr"},{"name":"Mongolian","code":"mn","localName":"Монгол","writingDirection":"ltr"},{"name":"Nauru","code":"na","localName":"Ekakairũ Naoero","writingDirection":"ltr"},{"name":"Navajo","code":"nv","localName":"Diné bizaad","writingDirection":"ltr"},{"name":"Ndonga","code":"ng","localName":"Oshiwambo","writingDirection":"ltr"},{"name":"Northern Ndebele","code":"nd","localName":"siNdebele saseNyakatho","writingDirection":"ltr"},{"name":"Nepali","code":"ne","localName":"नेपाली","writingDirection":"ltr"},{"name":"Norwegian","code":"no","localName":"Norsk","writingDirection":"ltr"},{"name":"Norwegian bokmål","code":"nb","localName":"Norsk (bokmål)","writingDirection":"ltr"},{"name":"Norwegian Nynorsk","code":"nn","localName":"Norsk (nynorsk)","writingDirection":"ltr"},{"name":"Occitan","code":"oc","localName":"Occitan","writingDirection":"ltr"},{"name":"Ojibwe","code":"oj","localName":"ᐊᓂᔑᓈᐯᒧᐎᓐ","writingDirection":"ltr"},{"name":"Oriya","code":"or","localName":"ଓଡ଼ିଆ","writingDirection":"ltr"},{"name":"Oromo (Afaan Oromo)","code":"om","localName":"Oromoo","writingDirection":"ltr"},{"name":"Ossetian","code":"os","localName":"Иронау","writingDirection":"ltr"},{"name":"Pali","code":"pi","localName":"पािऴ","writingDirection":"ltr"},{"name":"Pashto, Pushto","code":"ps","localName":"پښتو","writingDirection":"rtl"},{"name":"Persian (Farsi)","code":"fa","localName":"فارسی","writingDirection":"rtl"},{"name":"Polish","code":"pl","localName":"Polski","writingDirection":"ltr"},{"name":"Portuguese","code":"pt","localName":"Português","writingDirection":"ltr"},{"name":"Punjabi (Eastern)","code":"pa","localName":"ਪੰਜਾਬੀ","writingDirection":"ltr"},{"name":"Quechua","code":"qu","localName":"Runa Simi","writingDirection":"ltr"},{"name":"Romansh","code":"rm","localName":"Rumantsch","writingDirection":"ltr"},{"name":"Romanian","code":"ro","localName":"Română","writingDirection":"ltr"},{"name":"Russian","code":"ru","localName":"Русский","writingDirection":"ltr"},{"name":"Rundi","code":"rn","localName":"Kirundi","writingDirection":"ltr"},{"name":"Sami","code":"se","localName":"Davvisámegiella","writingDirection":"ltr"},{"name":"Samoan","code":"sm","localName":"Gagana Samoa","writingDirection":"ltr"},{"name":"Sango","code":"sg","localName":"Sängö","writingDirection":"ltr"},{"name":"Sanskrit","code":"sa","localName":"संस्कृत","writingDirection":"ltr"},{"name":"Serbian","code":"sr","localName":"Српски/Srpski","writingDirection":"ltr"},{"name":"Serbo-Croatian","code":"sh","localName":"Srpskohrvatski/Српскохрватски","writingDirection":"ltr"},{"name":"Shona","code":"sn","localName":"chiShona","writingDirection":"ltr"},{"name":"Sichuan Yi","code":"ii","localName":"ꆇꉙ","writingDirection":"ltr"},{"name":"Sindhi","code":"sd","localName":"سنڌي","writingDirection":"rtl"},{"name":"Sinhalese (Sinhala)","code":"si","localName":"සිංහල","writingDirection":"ltr"},{"name":"Siswati (Swati)","code":"ss","localName":"SiSwati","writingDirection":"ltr"},{"name":"Slovak","code":"sk","localName":"Slovenčina","writingDirection":"ltr"},{"name":"Slovenian","code":"sl","localName":"Slovenščina","writingDirection":"ltr"},{"name":"Somali","code":"so","localName":"Soomaaliga","writingDirection":"ltr"},{"name":"Southern Ndebele","code":"nr","localName":"Southern Ndebele","writingDirection":"ltr"},{"name":"Southern Sotho","code":"st","localName":"Sesotho","writingDirection":"ltr"},{"name":"Spanish","code":"es","localName":"Español","writingDirection":"ltr"},{"name":"Sundanese","code":"su","localName":"Basa Sunda","writingDirection":"ltr"},{"name":"Swahili","code":"sw","localName":"Kiswahili","writingDirection":"ltr"},{"name":"Swedish","code":"sv","localName":"Svenska","writingDirection":"ltr"},{"name":"Tagalog","code":"tl","localName":"Tagalog","writingDirection":"ltr"},{"name":"Tahitian","code":"ty","localName":"Reo Mā`ohi","writingDirection":"ltr"},{"name":"Tajik","code":"tg","localName":"Тоҷикӣ/tojikī","writingDirection":"ltr"},{"name":"Tamil","code":"ta","localName":"தமிழ்","writingDirection":"ltr"},{"name":"Tatar","code":"tt","localName":"Tatarça/Татарча","writingDirection":"ltr"},{"name":"Telugu","code":"te","localName":"తెలుగు","writingDirection":"ltr"},{"name":"Thai","code":"th","localName":"ไทย","writingDirection":"ltr"},{"name":"Tibetan","code":"bo","localName":"བོད་ཡིག","writingDirection":"ltr"},{"name":"Tigrinya","code":"ti","localName":"ትግርኛ","writingDirection":"ltr"},{"name":"Tonga","code":"to","localName":"faka-Tonga","writingDirection":"ltr"},{"name":"Tsonga","code":"ts","localName":"Xitsonga","writingDirection":"ltr"},{"name":"Tswana","code":"tn","localName":"Setswana","writingDirection":"ltr"},{"name":"Turkish","code":"tr","localName":"Türkçe","writingDirection":"ltr"},{"name":"Turkmen","code":"tk","localName":"Türkmen","writingDirection":"ltr"},{"name":"Twi","code":"tw","localName":"Twi","writingDirection":"ltr"},{"name":"Uyghur","code":"ug","localName":"ئۇيغۇرچە","writingDirection":"rtl"},{"name":"Ukrainian","code":"uk","localName":"Українська","writingDirection":"ltr"},{"name":"Urdu","code":"ur","localName":"اردو","writingDirection":"rtl"},{"name":"Uzbek","code":"uz","localName":"O\'zbek","writingDirection":"ltr"},{"name":"Venda","code":"ve","localName":"Tshivenda","writingDirection":"ltr"},{"name":"Vietnamese","code":"vi","localName":"Tiếng Việt","writingDirection":"ltr"},{"name":"Volapük","code":"vo","localName":"Volapük","writingDirection":"ltr"},{"name":"Wallon","code":"wa","localName":"Walon","writingDirection":"ltr"},{"name":"Welsh","code":"cy","localName":"Cymraeg","writingDirection":"ltr"},{"name":"Wolof","code":"wo","localName":"Wolof","writingDirection":"ltr"},{"name":"Western Frisian","code":"fy","localName":"Frysk","writingDirection":"ltr"},{"name":"Xhosa","code":"xh","localName":"isiXhosa","writingDirection":"ltr"},{"name":"Yiddish","code":"yi","localName":"ייִדיש","writingDirection":"rtl"},{"name":"Yoruba","code":"yo","localName":"Yorùbá","writingDirection":"ltr"},{"name":"Zhuang, Chuang","code":"za","localName":"Cuengh","writingDirection":"ltr"},{"name":"Zulu","code":"zu","localName":"isiZulu","writingDirection":"ltr"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'utc',
                'item_value' => '[{"value":"-12","name":"UTC-12"},{"value":"-11.5","name":"UTC-11:30"},{"value":"-11","name":"UTC-11"},{"value":"-10.5","name":"UTC-10:30"},{"value":"-10","name":"UTC-10"},{"value":"-9.5","name":"UTC-9:30"},{"value":"-9","name":"UTC-9"},{"value":"-8.5","name":"UTC-8:30"},{"value":"-8","name":"UTC-8"},{"value":"-7.5","name":"UTC-7:30"},{"value":"-7","name":"UTC-7"},{"value":"-6.5","name":"UTC-6:30"},{"value":"-6","name":"UTC-6"},{"value":"-5.5","name":"UTC-5:30"},{"value":"-5","name":"UTC-5"},{"value":"-4.5","name":"UTC-4:30"},{"value":"-4","name":"UTC-4"},{"value":"-3.5","name":"UTC-3:30"},{"value":"-3","name":"UTC-3"},{"value":"-2.5","name":"UTC-2:30"},{"value":"-2","name":"UTC-2"},{"value":"-1.5","name":"UTC-1:30"},{"value":"-1","name":"UTC-1"},{"value":"-0.5","name":"UTC-0:30"},{"value":"+0","name":"UTC+0"},{"value":"+0.5","name":"UTC+0:30"},{"value":"+1","name":"UTC+1"},{"value":"+1.5","name":"UTC+1:30"},{"value":"+2","name":"UTC+2"},{"value":"+2.5","name":"UTC+2:30"},{"value":"+3","name":"UTC+3"},{"value":"+3.5","name":"UTC+3:30"},{"value":"+4","name":"UTC+4"},{"value":"+4.5","name":"UTC+4:30"},{"value":"+5","name":"UTC+5"},{"value":"+5.5","name":"UTC+5:30"},{"value":"+5.75","name":"UTC+5:45"},{"value":"+6","name":"UTC+6"},{"value":"+6.5","name":"UTC+6:30"},{"value":"+7","name":"UTC+7"},{"value":"+7.5","name":"UTC+7:30"},{"value":"+8","name":"UTC+8"},{"value":"+8.5","name":"UTC+8:30"},{"value":"+8.75","name":"UTC+8:45"},{"value":"+9","name":"UTC+9"},{"value":"+9.5","name":"UTC+9:30"},{"value":"+10","name":"UTC+10"},{"value":"+10.5","name":"UTC+10:30"},{"value":"+11","name":"UTC+11"},{"value":"+11.5","name":"UTC+11:30"},{"value":"+12","name":"UTC+12"},{"value":"+12.75","name":"UTC+12:45"},{"value":"+13","name":"UTC+13"},{"value":"+13.75","name":"UTC+13:45"},{"value":"+14","name":"UTC+14"}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'timezones',
                'item_value' => '{"UTC":"+0","Africa/Abidjan":"+0","Africa/Accra":"+0","Africa/Addis_Ababa":"+3","Africa/Algiers":"+1","Africa/Asmara":"+3","Africa/Bamako":"+0","Africa/Bangui":"+1","Africa/Banjul":"+0","Africa/Bissau":"+0","Africa/Blantyre":"+2","Africa/Brazzaville":"+1","Africa/Bujumbura":"+2","Africa/Cairo":"+2","Africa/Casablanca":"+0","Africa/Ceuta":"+1","Africa/Conakry":"+0","Africa/Dakar":"+0","Africa/Dar_es_Salaam":"+3","Africa/Djibouti":"+3","Africa/Douala":"+1","Africa/El_Aaiun":"+0","Africa/Freetown":"+0","Africa/Gaborone":"+2","Africa/Harare":"+2","Africa/Johannesburg":"+2","Africa/Juba":"+2","Africa/Kampala":"+3","Africa/Khartoum":"+2","Africa/Kigali":"+2","Africa/Kinshasa":"+1","Africa/Lagos":"+1","Africa/Libreville":"+1","Africa/Lome":"+0","Africa/Luanda":"+1","Africa/Lubumbashi":"+2","Africa/Lusaka":"+2","Africa/Malabo":"+1","Africa/Maputo":"+2","Africa/Maseru":"+2","Africa/Mbabane":"+2","Africa/Mogadishu":"+3","Africa/Monrovia":"+0","Africa/Nairobi":"+3","Africa/Ndjamena":"+1","Africa/Niamey":"+1","Africa/Nouakchott":"+0","Africa/Ouagadougou":"+0","Africa/Porto-Novo":"+1","Africa/Sao_Tome":"+0","Africa/Tripoli":"+2","Africa/Tunis":"+1","Africa/Windhoek":"+1","America/Adak":"-10","America/Anchorage":"-9","America/Anguilla":"-4","America/Antigua":"-4","America/Araguaina":"-3","America/Argentina/Buenos_Aires":"-3","America/Argentina/Catamarca":"-3","America/Argentina/Cordoba":"-3","America/Argentina/Jujuy":"-3","America/Argentina/La_Rioja":"-3","America/Argentina/Mendoza":"-3","America/Argentina/Rio_Gallegos":"-3","America/Argentina/Salta":"-3","America/Argentina/San_Juan":"-3","America/Argentina/San_Luis":"-3","America/Argentina/Tucuman":"-3","America/Argentina/Ushuaia":"-3","America/Aruba":"-4","America/Asuncion":"-4","America/Atikokan":"-5","America/Bahia":"-3","America/Bahia_Banderas":"-6","America/Barbados":"-4","America/Belem":"-3","America/Belize":"-6","America/Blanc-Sablon":"-4","America/Boa_Vista":"-4","America/Bogota":"-5","America/Boise":"-7","America/Cambridge_Bay":"-7","America/Campo_Grande":"-4","America/Cancun":"-5","America/Caracas":"-4","America/Cayenne":"-3","America/Cayman":"-5","America/Chicago":"-6","America/Chihuahua":"-7","America/Costa_Rica":"-6","America/Creston":"-7","America/Cuiaba":"-4","America/Curacao":"-4","America/Danmarkshavn":"+0","America/Dawson":"-7","America/Dawson_Creek":"-7","America/Denver":"-7","America/Detroit":"-5","America/Dominica":"-4","America/Edmonton":"-7","America/Eirunepe":"-5","America/El_Salvador":"-6","America/Fort_Nelson":"-7","America/Fortaleza":"-3","America/Glace_Bay":"-4","America/Goose_Bay":"-4","America/Grand_Turk":"-5","America/Grenada":"-4","America/Guadeloupe":"-4","America/Guatemala":"-6","America/Guayaquil":"-5","America/Guyana":"-4","America/Halifax":"-4","America/Havana":"-5","America/Hermosillo":"-7","America/Indiana/Indianapolis":"-5","America/Indiana/Knox":"-6","America/Indiana/Marengo":"-5","America/Indiana/Petersburg":"-5","America/Indiana/Tell_City":"-6","America/Indiana/Vevay":"-5","America/Indiana/Vincennes":"-5","America/Indiana/Winamac":"-5","America/Inuvik":"-7","America/Iqaluit":"-5","America/Jamaica":"-5","America/Juneau":"-9","America/Kentucky/Louisville":"-5","America/Kentucky/Monticello":"-5","America/Kralendijk":"-4","America/La_Paz":"-4","America/Lima":"-5","America/Los_Angeles":"-8","America/Lower_Princes":"-4","America/Maceio":"-3","America/Managua":"-6","America/Manaus":"-4","America/Marigot":"-4","America/Martinique":"-4","America/Matamoros":"-6","America/Mazatlan":"-7","America/Menominee":"-6","America/Merida":"-6","America/Metlakatla":"-9","America/Mexico_City":"-6","America/Miquelon":"-3","America/Moncton":"-4","America/Monterrey":"-6","America/Montevideo":"-3","America/Montserrat":"-4","America/Nassau":"-5","America/New_York":"-5","America/Nipigon":"-5","America/Nome":"-9","America/Noronha":"-2","America/North_Dakota/Beulah":"-6","America/North_Dakota/Center":"-6","America/North_Dakota/New_Salem":"-6","America/Nuuk":"-2","America/Ojinaga":"-7","America/Panama":"-5","America/Pangnirtung":"-5","America/Paramaribo":"-3","America/Phoenix":"-7","America/Port-au-Prince":"-5","America/Port_of_Spain":"-4","America/Porto_Velho":"-4","America/Puerto_Rico":"-4","America/Punta_Arenas":"-3","America/Rainy_River":"-6","America/Rankin_Inlet":"-6","America/Recife":"-3","America/Regina":"-6","America/Resolute":"-6","America/Rio_Branco":"-5","America/Santarem":"-3","America/Santiago":"-4","America/Santo_Domingo":"-4","America/Sao_Paulo":"-3","America/Scoresbysund":"-1","America/Sitka":"-9","America/St_Barthelemy":"-4","America/St_Johns":"-3.5","America/St_Kitts":"-4","America/St_Lucia":"-4","America/St_Thomas":"-4","America/St_Vincent":"-4","America/Swift_Current":"-6","America/Tegucigalpa":"-6","America/Thule":"-4","America/Thunder_Bay":"-5","America/Tijuana":"-8","America/Toronto":"-5","America/Tortola":"-4","America/Vancouver":"-8","America/Whitehorse":"-7","America/Winnipeg":"-6","America/Yakutat":"-9","America/Yellowknife":"-7","Antarctica/Casey":"+11","Antarctica/Davis":"+7","Antarctica/DumontDUrville":"+10","Antarctica/Macquarie":"+10","Antarctica/Mawson":"+5","Antarctica/McMurdo":"+12","Antarctica/Palmer":"-3","Antarctica/Rothera":"-3","Antarctica/Syowa":"+3","Antarctica/Troll":"+0","Antarctica/Vostok":"+6","Arctic/Longyearbyen":"+1","Asia/Aden":"+3","Asia/Almaty":"+6","Asia/Amman":"+2","Asia/Anadyr":"+12","Asia/Aqtau":"+5","Asia/Aqtobe":"+5","Asia/Ashgabat":"+5","Asia/Atyrau":"+5","Asia/Baghdad":"+3","Asia/Bahrain":"+3","Asia/Baku":"+4","Asia/Bangkok":"+7","Asia/Barnaul":"+7","Asia/Beirut":"+2","Asia/Bishkek":"+6","Asia/Brunei":"+8","Asia/Chita":"+9","Asia/Choibalsan":"+8","Asia/Colombo":"+5.5","Asia/Damascus":"+2","Asia/Dhaka":"+6","Asia/Dili":"+9","Asia/Dubai":"+4","Asia/Dushanbe":"+5","Asia/Famagusta":"+2","Asia/Gaza":"+2","Asia/Hebron":"+2","Asia/Ho_Chi_Minh":"+7","Asia/Hong_Kong":"+8","Asia/Hovd":"+7","Asia/Irkutsk":"+8","Asia/Jakarta":"+7","Asia/Jayapura":"+9","Asia/Jerusalem":"+2","Asia/Kabul":"+4.5","Asia/Kamchatka":"+12","Asia/Karachi":"+5","Asia/Kathmandu":"+5.75","Asia/Khandyga":"+9","Asia/Kolkata":"+5.5","Asia/Krasnoyarsk":"+7","Asia/Kuala_Lumpur":"+8","Asia/Kuching":"+8","Asia/Kuwait":"+3","Asia/Macau":"+8","Asia/Magadan":"+11","Asia/Makassar":"+8","Asia/Manila":"+8","Asia/Muscat":"+4","Asia/Nicosia":"+2","Asia/Novokuznetsk":"+7","Asia/Novosibirsk":"+7","Asia/Omsk":"+6","Asia/Oral":"+5","Asia/Phnom_Penh":"+7","Asia/Pontianak":"+7","Asia/Pyongyang":"+9","Asia/Qatar":"+3","Asia/Qostanay":"+6","Asia/Qyzylorda":"+5","Asia/Riyadh":"+3","Asia/Sakhalin":"+11","Asia/Samarkand":"+5","Asia/Seoul":"+9","Asia/Shanghai":"+8","Asia/Singapore":"+8","Asia/Srednekolymsk":"+11","Asia/Taipei":"+8","Asia/Tashkent":"+5","Asia/Tbilisi":"+4","Asia/Tehran":"+3.5","Asia/Thimphu":"+6","Asia/Tokyo":"+9","Asia/Tomsk":"+7","Asia/Ulaanbaatar":"+8","Asia/Urumqi":"+6","Asia/Ust-Nera":"+10","Asia/Vientiane":"+7","Asia/Vladivostok":"+10","Asia/Yakutsk":"+9","Asia/Yangon":"+6.5","Asia/Yekaterinburg":"+5","Asia/Yerevan":"+4","Atlantic/Azores":"-1","Atlantic/Bermuda":"-4","Atlantic/Canary":"+0","Atlantic/Cape_Verde":"-1","Atlantic/Faroe":"+0","Atlantic/Madeira":"+0","Atlantic/Reykjavik":"+0","Atlantic/South_Georgia":"-2","Atlantic/St_Helena":"+0","Atlantic/Stanley":"-3","Australia/Adelaide":"+9.5","Australia/Brisbane":"+10","Australia/Broken_Hill":"+9.5","Australia/Darwin":"+9.5","Australia/Eucla":"+8.75","Australia/Hobart":"+10","Australia/Lindeman":"+10","Australia/Lord_Howe":"+10.5","Australia/Melbourne":"+10","Australia/Perth":"+8","Australia/Sydney":"+10","Europe/Amsterdam":"+1","Europe/Andorra":"+1","Europe/Astrakhan":"+4","Europe/Athens":"+2","Europe/Belgrade":"+1","Europe/Berlin":"+1","Europe/Bratislava":"+1","Europe/Brussels":"+1","Europe/Bucharest":"+2","Europe/Budapest":"+1","Europe/Busingen":"+2","Europe/Chisinau":"+2","Europe/Copenhagen":"+1","Europe/Dublin":"+0","Europe/Gibraltar":"+1","Europe/Guernsey":"+0","Europe/Helsinki":"+2","Europe/Isle_of_Man":"+0","Europe/Istanbul":"+3","Europe/Jersey":"+0","Europe/Kaliningrad":"+2","Europe/Kiev":"+2","Europe/Kirov":"+3","Europe/Lisbon":"+0","Europe/Ljubljana":"+1","Europe/London":"+0","Europe/Luxembourg":"+1","Europe/Madrid":"+1","Europe/Malta":"+1","Europe/Mariehamn":"+2","Europe/Minsk":"+3","Europe/Monaco":"+1","Europe/Moscow":"+3","Europe/Oslo":"+1","Europe/Paris":"+1","Europe/Podgorica":"+1","Europe/Prague":"+1","Europe/Riga":"+2","Europe/Rome":"+1","Europe/Samara":"+4","Europe/San_Marino":"+1","Europe/Sarajevo":"+1","Europe/Saratov":"+4","Europe/Simferopol":"+3","Europe/Skopje":"+1","Europe/Sofia":"+2","Europe/Stockholm":"+1","Europe/Tallinn":"+2","Europe/Tirane":"+1","Europe/Ulyanovsk":"+4","Europe/Uzhgorod":"+2","Europe/Vaduz":"+1","Europe/Vatican":"+1","Europe/Vienna":"+1","Europe/Vilnius":"+2","Europe/Volgograd":"+3","Europe/Warsaw":"+1","Europe/Zagreb":"+1","Europe/Zaporozhye":"+2","Europe/Zurich":"+1","Indian/Antananarivo":"+3","Indian/Chagos":"+6","Indian/Christmas":"+7","Indian/Cocos":"+6.5","Indian/Comoro":"+3","Indian/Kerguelen":"+5","Indian/Mahe":"+4","Indian/Maldives":"+5","Indian/Mauritius":"+4","Indian/Mayotte":"+3","Indian/Reunion":"+4","Pacific/Apia":"+13","Pacific/Auckland":"+12","Pacific/Bougainville":"+11","Pacific/Chatham":"+12.75","Pacific/Chuuk":"+10","Pacific/Easter":"-6","Pacific/Efate":"+11","Pacific/Fakaofo":"+13","Pacific/Fiji":"+12","Pacific/Funafuti":"+12","Pacific/Galapagos":"-6","Pacific/Gambier":"-9","Pacific/Guadalcanal":"+11","Pacific/Guam":"+10","Pacific/Honolulu":"-10","Pacific/Kanton":"+13","Pacific/Kiritimati":"+14","Pacific/Kosrae":"+11","Pacific/Kwajalein":"+12","Pacific/Majuro":"+12","Pacific/Marquesas":"-9.5","Pacific/Midway":"-11","Pacific/Nauru":"+12","Pacific/Niue":"-11","Pacific/Norfolk":"+11","Pacific/Noumea":"+11","Pacific/Pago_Pago":"-11","Pacific/Palau":"+9","Pacific/Pitcairn":"-8","Pacific/Pohnpei":"+11","Pacific/Port_Moresby":"+10","Pacific/Rarotonga":"-10","Pacific/Saipan":"+10","Pacific/Tahiti":"-10","Pacific/Tarawa":"+12","Pacific/Tongatapu":"+13","Pacific/Wake":"+12","Pacific/Wallis":"+12"}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'timezone_abbreviations',
                'item_value' => '{"acdt":"+10.5","acst":"+9.5","act":"-5","acwst":"+8.75","adt":"-3","aedt":"+11","aest":"+10","aft":"+4.5","akdt":"-8","akst":"-9","amst":"-3","amt":"-4","art":"-3","ast":"-4","awst":"+8","azost":"+0","azot":"-1","azt":"+4","bdt":"+8","bnt":"+8","bot":"-4","brst":"-2","brt":"-3","bst":"+1","btt":"+6","cat":"+2","cct":"+6.5","cdt":"-5","cest":"+2","cet":"+1","chadt":"+13.75","chast":"+12.75","chost":"+9","chot":"+8","chst":"+10","chut":"+10","cit":"+8","ckt":"-10","clst":"-3","clt":"-4","cost":"-4","cot":"-5","cst":"-6","cvt":"-1","cxt":"+7","davt":"+7","ddut":"+10","easst":"-5","east":"-6","eat":"+3","ect":"-5","edt":"-4","eest":"+3","eet":"+2","egst":"+0","egt":"-1","eit":"+9","est":"-5","fet":"+3","fjt":"+12","fkst":"-3","fkt":"-4","fnt":"-2","galt":"-6","gamt":"-9","get":"+4","gft":"-3","gilt":"+12","git":"-9","gmt":"+0","gst":"+4","gyt":"-4","hadt":"-9","hast":"-10","hkt":"+8","hovst":"+8","hovt":"+7","ict":"+7","idt":"+3","irdt":"+4.5","irkt":"+8","irst":"+3.5","ist":"+5.5","jst":"+9","kgt":"+6","kost":"+11","krat":"+7","kst":"+9","lhdt":"+11","lhst":"+10.5","lint":"+14","magt":"+11","mart":"-9.5","mawt":"+5","mdt":"-6","mht":"+12","mist":"+11","mit":"-9.5","mmt":"+6.5","msk":"+3","mst":"-7","mut":"+4","mvt":"+5","myt":"+8","nct":"+11","ndt":"-2.5","nft":"+11","npt":"+5.75","nrt":"+12","nst":"-3.5","nt":"-3.5","nut":"-11","nzdt":"+13","nzst":"+12","omst":"+6","orat":"+5","pdt":"-7","pet":"-5","pett":"+12","pgt":"+10","phot":"+13","phst":"+8","pht":"+8","pkt":"+5","pmdt":"-2","pmst":"-3","pont":"+11","pst":"-8","pwt":"+9","pyst":"-3","pyt":"-4","ret":"+4","rott":"-3","sakt":"+11","samt":"+4","sast":"+2","sbt":"+11","sct":"+4","sgt":"+8","slst":"+5.5","srt":"-3","sst":"-11","syot":"+3","taht":"-10","tft":"+5","tha":"+7","tjt":"+5","tkt":"+13","tlt":"+9","tmt":"+5","tot":"+13","trt":"+3","tvt":"+12","ulast":"+9","ulat":"+8","usz1":"+2","uyst":"-2","uyt":"-3","uzt":"+5","vet":"-4","vlat":"+10","volt":"+4","vost":"+6","vut":"+11","wakt":"+12","wast":"+2","wat":"+1","west":"+1","wet":"+0","wft":"+12","wgst":"-2","wib":"+7","wit":"+9","yakt":"+9","yekt":"+5"}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'bulletin_name',
                'item_value' => '{"en":"Fresns Bulletin","zh-Hans":"系统公告","zh-Hant":"系統公告"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'bulletin_contents',
                'item_value' => '{"en":[{"date":"10/18/2022","title":"Fresns Features","titleColor":"#f40","description":"Introduction of 16 excellent features of Fresns product","descriptionColor":null,"buttonName":"Learn more","buttonLink":"https://fresns.org/intro/features.html"}],"zh-Hans":[{"date":"2022-10-18","title":"Fresns 功能特征","titleColor":"#f40","description":"Fresns 产品的 16 个优秀功能特点介绍","descriptionColor":null,"buttonName":"了解更多","buttonLink":"https://fresns.org/zh-hans/intro/features.html"}],"zh-Hant":[{"date":"2022-10-18","title":"Fresns 功能特點","titleColor":"#f40","description":"Fresns 產品的 16 個優秀功能特點介紹","descriptionColor":null,"buttonName":"了解更多","buttonLink":"https://fresns.org/zh-hans/intro/features.html"}]}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'language_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'language_menus',
                'item_value' => '[{"order":1,"langCode":"en","langName":"English","areaStatus":false,"areaCode":"","areaName":"","langTag":"en","writingDirection":"ltr","lengthUnit":"mi","dateFormat":"m/d/Y","timeFormatMinute":"{n} minute ago","timeFormatHour":"{n} hour ago","timeFormatDay":"{n} day ago","timeFormatMonth":"{n} month ago","timeFormatYear":"{n} year ago","packVersion":1,"isEnabled":true},{"order":2,"langCode":"zh-Hans","langName":"简体中文","areaStatus":false,"areaCode":"","areaName":"","langTag":"zh-Hans","writingDirection":"ltr","lengthUnit":"km","dateFormat":"Y-m-d","timeFormatMinute":"{n} 分钟前","timeFormatHour":"{n} 小时前","timeFormatDay":"{n} 天前","timeFormatMonth":"{n} 个月前","timeFormatYear":"{n} 年前","packVersion":1,"isEnabled":true},{"order":3,"langCode":"zh-Hant","langName":"繁體中文","areaStatus":false,"areaCode":"","areaName":"","langTag":"zh-Hant","writingDirection":"ltr","lengthUnit":"km","dateFormat":"Y-m-d","timeFormatMinute":"{n} 分鐘前","timeFormatHour":"{n} 小時前","timeFormatDay":"{n} 天前","timeFormatMonth":"{n} 個月前","timeFormatYear":"{n} 年前","packVersion":1,"isEnabled":true}]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'default_language',
                'item_value' => 'en',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_url',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_name',
                'item_value' => '{"en":"Fresns","zh-Hans":"Fresns 中文网","zh-Hant":"Fresns 中文網"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_desc',
                'item_value' => '{"en":"Fresns is a free and open source social network service software, a general-purpose community product designed for cross-platform, and supports flexible and diverse content forms. It conforms to the trend of the times, satisfies a variety of operating scenarios, is more open and easier to re-development.","zh-Hans":"Fresns 是一款免费开源的社交网络服务软件，专为跨平台而打造的通用型社区产品，支持灵活多样的内容形态，可以满足多种运营场景，符合时代潮流，更开放且更易于二次开发。","zh-Hant":"Fresns 是一款免費開源的社交網絡服務軟件，專為跨平台而打造的通用型社區產品，支持靈活多樣的內容形態，可以滿足多種運營場景，符合時代潮流，更開放且更易於二次開發。"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_intro',
                'item_value' => '{"en":"# About Us\r\n\r\nTo be edited\r\n\r\nPanel->Systems->General->Site Intro","zh-Hans":"# 关于我们\r\n\r\n待编辑\r\n\r\n后台->系统->站点设置->站点介绍","zh-Hant":"# 關於我們\r\n\r\n待編輯\r\n\r\n面板->系統->站點設定->站點介紹"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_icon',
                'item_value' => '/static/images/icon.png',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_logo',
                'item_value' => '/static/images/logo.png',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_copyright_name',
                'item_value' => 'Fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_copyright_years',
                'item_value' => '2021-Present',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_email',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_mode',
                'item_value' => 'public',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_private_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_private_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_private_end_after',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_private_whitelist_roles',
                'item_value' => null,
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_terms_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_privacy_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_cookie_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_delete_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'delete_account_type',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'delete_account_todo',
                'item_value' => '7',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_terms_policy',
                'item_value' => '{"en":"# Terms of Service\r\n\r\nTo be edite\r\n\r\nPanel->Systems->Policy->Contents","zh-Hans":"# 服务条款\r\n\r\n待编辑\r\n\r\n后台->系统->政策设置->政策内容","zh-Hant":"# 服務條款\r\n\r\n待編輯\r\n\r\n面板->系統->政策設定->政策內容"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_privacy_policy',
                'item_value' => '{"en":"# Privacy Policy\r\n\r\nTo be edite\r\n\r\nPanel->Systems->Policy->Contents","zh-Hans":"# 隐私权政策\r\n\r\n待编辑\r\n\r\n后台->系统->政策设置->政策内容","zh-Hant":"# 隱私權政策\r\n\r\n待編輯\r\n\r\n面板->系統->政策設定->政策內容"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_cookie_policy',
                'item_value' => '{"en":"# Cookie Policy\r\n\r\nTo be edite\r\n\r\nPanel->Systems->Policy->Contents","zh-Hans":"# Cookie 政策\r\n\r\n待编辑\r\n\r\n后台->系统->政策设置->政策内容","zh-Hant":"# Cookie 政策\r\n\r\n待編輯\r\n\r\n面板->系統->政策設定->政策內容"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_delete_policy',
                'item_value' => '{"en":"# Deactivating or deleting your Fresns account\r\n\r\nTo be edite\r\n\r\nPanel->Systems->Policy->Contents","zh-Hans":"# 注销说明\r\n\r\n待编辑\r\n\r\n后台->系统->政策设置->政策内容","zh-Hant":"# 註銷說明\r\n\r\n待編輯\r\n\r\n面板->系統->政策設定->政策內容"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'send_email_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'send_sms_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'send_sms_default_code',
                'item_value' => '65',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'send_sms_supported_codes',
                'item_value' => '["65"]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'ios_notifications_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'android_notifications_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'desktop_notifications_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template1',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>{name}</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>{name}</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>{name}</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template2',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>{name}</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>{name}</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>{name}</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template3',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>Modify {name} account information</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>修改 {name} 账号资料</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>修改 {name} 賬號資料</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template4',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>Change {name} Phone Number</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>更换 {name} 手机号</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>更換 {name} 手機號</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template5',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>Reset Login Password</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>重置登录密码</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>重置登入密碼</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template6',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>Reset Payment Password</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>重置支付密码</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>重置支付密碼</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template7',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>Login with verification code</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>使用验证码登录</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>使用驗證碼登入</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'verifycode_template8',
                'item_value' => '{"email":{"status":true,"templates":{"en":{"title":"[{name}] Your verify code","content":"<div>Deleting an account using verification code</div><div><br></div><div>&nbsp;&nbsp;&nbsp; Your verify code: {code}</div><div><br></div><div>{time}</div>"},"zh-Hans":{"title":"【{name}】您的验证码","content":"<div>使用验证码删除账户</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的验证码： {code}</div><div><br></div><div>{time}</div>"},"zh-Hant":{"title":"【{name}】您的驗證碼","content":"<div>使用驗證碼刪除賬戶</div><div><br></div><div>&nbsp;&nbsp;&nbsp; 您的驗證碼： {code}</div><div><br></div><div>{time}</div>"}}},"sms":{"status":false,"templates":{}}}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_center_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_center_captcha',
                'item_value' => '{"type":"","siteKey":"","secretKey":""}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_age_verification',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_age_min_required',
                'item_value' => '13',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_register_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_register_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_email_register',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_phone_register',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_login_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_email_login',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_phone_login',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_login_with_code',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_login_or_register',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'password_length',
                'item_value' => '8',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'password_strength',
                'item_value' => '["number","lowercase"]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_connect_services',
                'item_value' => null,
                'item_type' => 'plugins',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_kyc_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'account_users_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_currency_code',
                'item_value' => 'USD',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_currency_name',
                'item_value' => '{"en":"Dollar","zh-Hans":"美元","zh-Hant":"美元"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_currency_unit',
                'item_value' => '{"en":"$","zh-Hans":"元","zh-Hant":"元"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_currency_precision',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_review',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_check_kyc',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_interval_time',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_rate',
                'item_value' => '5',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_min_sum',
                'item_value' => '100',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_max_sum',
                'item_value' => '1000',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'wallet_withdraw_sum_limit',
                'item_value' => '30000',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_secret_id',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_secret_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_bucket_name',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_bucket_region',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_bucket_endpoint',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_access_domain',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_filesystem_disk',
                'item_value' => 'local',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_extension_names',
                'item_value' => 'png,gif,jpg,jpeg,bmp,heic',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_max_size',
                'item_value' => '5',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_temporary_url_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_temporary_url_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_temporary_url_expiration',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_handle_position',
                'item_value' => 'end',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_thumb_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_thumb_ratio',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_thumb_square',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_thumb_big',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_secret_id',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_secret_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_bucket_name',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_bucket_region',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_bucket_endpoint',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_access_domain',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_filesystem_disk',
                'item_value' => 'local',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_extension_names',
                'item_value' => 'wmv,rm,mov,mpeg,mp4,3gp,flv,avi,rmvb',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_max_size',
                'item_value' => '50',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_max_duration',
                'item_value' => '30',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_temporary_url_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_temporary_url_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_temporary_url_expiration',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_transcode_parameter',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_transcode_handle_position',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_poster_parameter',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_poster_handle_position',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_secret_id',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_secret_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_bucket_name',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_bucket_region',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_bucket_endpoint',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_access_domain',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_filesystem_disk',
                'item_value' => 'local',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_extension_names',
                'item_value' => 'mp3,wav,m4a',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_max_size',
                'item_value' => '50',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_max_duration',
                'item_value' => '60',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_temporary_url_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_temporary_url_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_temporary_url_expiration',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_transcode_parameter',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_transcode_handle_position',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_secret_id',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_secret_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_bucket_name',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_bucket_region',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_bucket_endpoint',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_access_domain',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_filesystem_disk',
                'item_value' => 'local',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_extension_names',
                'item_value' => 'doc,docx,xls,xlsx,csv,ppt,pptx,pps,ppts,pdf,txt,md,markdown,rar,zip,7z,epub,mobi',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_max_size',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_temporary_url_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_temporary_url_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_temporary_url_expiration',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_preview_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_preview_extension_names',
                'item_value' => 'doc,docx,xls,xlsx,csv,ppt,pptx,pps,ppts,pdf',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'image_substitution',
                'item_value' => '/static/images/substitution-image.jpg',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'video_substitution',
                'item_value' => '/static/images/substitution-video.jpg',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'audio_substitution',
                'item_value' => '/static/images/substitution-audio.jpg',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'document_substitution',
                'item_value' => '/static/images/substitution-document.jpg',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_name',
                'item_value' => '{"en":"User","zh-Hans":"用户","zh-Hant":"使用者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_uid_name',
                'item_value' => '{"en":"UID","zh-Hans":"用户号","zh-Hant":"用戶號"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_username_name',
                'item_value' => '{"en":"Username","zh-Hans":"用户名","zh-Hant":"使用者名稱"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_nickname_name',
                'item_value' => '{"en":"Nickname","zh-Hans":"昵称","zh-Hant":"暱稱"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_role_name',
                'item_value' => '{"en":"Role","zh-Hans":"角色","zh-Hant":"角色"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_bio_name',
                'item_value' => '{"en":"Bio","zh-Hans":"简介","zh-Hant":"介紹"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'default_role',
                'item_value' => '4',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'default_avatar',
                'item_value' => '/static/images/default-avatar.png',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'anonymous_avatar',
                'item_value' => '/static/images/anonymous-avatar.png',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'deactivate_avatar',
                'item_value' => '/static/images/deactivate-avatar.png',
                'item_type' => 'file',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_identifier',
                'item_value' => 'username',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_uid_digit',
                'item_value' => '5',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_default_homepage',
                'item_value' => 'posts',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'username_min',
                'item_value' => '5',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'username_max',
                'item_value' => '16',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'username_edit',
                'item_value' => '30',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'nickname_min',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'nickname_max',
                'item_value' => '20',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'nickname_edit',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'nickname_unique',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_ban_names',
                'item_value' => '["fresns","system","systems","admin","administrator","manager"]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'bio_length',
                'item_value' => '128',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'bio_support_mention',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'bio_support_link',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'bio_support_hashtag',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits1_name',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits1_unit',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits1_state',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits2_name',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits2_unit',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits2_state',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits3_name',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits3_unit',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits3_state',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits4_name',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits4_unit',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits4_state',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits5_name',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits5_unit',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'extcredits5_state',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'conversation_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'conversation_files',
                'item_value' => '["image"]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'conversation_file_upload_method',
                'item_value' => '{"image":"api","video":"sdk","audio":"sdk","document":"sdk"}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_name',
                'item_value' => '{"en":"Group","zh-Hans":"小组","zh-Hant":"社團"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_name',
                'item_value' => '{"en":"Hashtag","zh-Hans":"话题","zh-Hant":"話題"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_name',
                'item_value' => '{"en":"Geotag","zh-Hans":"地理","zh-Hant":"地理"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_name',
                'item_value' => '{"en":"Post","zh-Hans":"帖子","zh-Hant":"貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_name',
                'item_value' => '{"en":"Comment","zh-Hans":"评论","zh-Hant":"留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'publish_post_name',
                'item_value' => '{"en":"Create Post","zh-Hans":"发帖","zh-Hant":"發貼"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'publish_comment_name',
                'item_value' => '{"en":"Write a comment","zh-Hans":"回复","zh-Hant":"回覆"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'mention_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'mention_number',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_format',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_length',
                'item_value' => '20',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_number',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_regexp',
                'item_value' => '{"space":"/#[\\\\p{L}\\\\p{N}\\\\p{M}]+[^\\\\n\\\\p{P}\\\\s]/u","hash":"/#[\\\\p{L}\\\\p{N}\\\\p{M}]+[^\\\\n\\\\p{P}]#/u"}',
                'item_type' => 'object',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'nearby_length_km',
                'item_value' => '50',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'nearby_length_mi',
                'item_value' => '30',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_brief_length',
                'item_value' => '280',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_brief_length',
                'item_value' => '280',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_visibility_rule',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'preview_post_like_users',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'preview_post_comments',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'preview_post_comments_type',
                'item_value' => 'like',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'preview_post_comments_threshold',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'preview_comment_like_users',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'preview_comment_replies',
                'item_value' => '3',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'preview_comment_replies_type',
                'item_value' => 'oldest',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_edit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_edit_time_limit',
                'item_value' => '30',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_edit_sticky_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_edit_digest_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_delete',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_delete_sticky_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_delete_digest_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_edit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_edit_time_limit',
                'item_value' => '30',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_edit_sticky_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_edit_digest_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_delete',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_delete_sticky_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_delete_digest_limit',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_like_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_like_name',
                'item_value' => '{"en":"Like","zh-Hans":"喜欢","zh-Hant":"喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_like_user_title',
                'item_value' => '{"en":"Likers","zh-Hans":"喜欢者","zh-Hant":"喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_like_public_record',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_like_public_count',
                'item_value' => '3',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_dislike_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_dislike_name',
                'item_value' => '{"en":"Dislike","zh-Hans":"不喜欢","zh-Hant":"不喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_dislike_user_title',
                'item_value' => '{"en":"Dislikers","zh-Hans":"不喜欢者","zh-Hant":"不喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_dislike_public_record',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_dislike_public_count',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_follow_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_follow_name',
                'item_value' => '{"en":"Follow","zh-Hans":"关注","zh-Hant":"跟隨"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_follow_user_title',
                'item_value' => '{"en":"Followers","zh-Hans":"关注者","zh-Hant":"跟隨者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_follow_public_record',
                'item_value' => '3',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_follow_public_count',
                'item_value' => '3',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_block_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_block_name',
                'item_value' => '{"en":"Block","zh-Hans":"拉黑","zh-Hant":"封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_block_user_title',
                'item_value' => '{"en":"Blockers","zh-Hans":"黑名单","zh-Hant":"黑名單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_block_public_record',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'user_block_public_count',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_like_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_like_name',
                'item_value' => '{"en":"Like","zh-Hans":"赞","zh-Hant":"喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_like_user_title',
                'item_value' => '{"en":"Likers","zh-Hans":"喜欢者","zh-Hant":"喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_like_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_like_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_dislike_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_dislike_name',
                'item_value' => '{"en":"Dislike","zh-Hans":"不喜欢","zh-Hant":"不喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_dislike_user_title',
                'item_value' => '{"en":"Dislikers","zh-Hans":"不喜欢者","zh-Hant":"不喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_dislike_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_dislike_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_follow_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_follow_name',
                'item_value' => '{"en":"Join","zh-Hans":"加入","zh-Hant":"加入"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_follow_user_title',
                'item_value' => '{"en":"Members","zh-Hans":"成员","zh-Hant":"成員"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_follow_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_follow_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_block_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_block_name',
                'item_value' => '{"en":"Block","zh-Hans":"屏蔽","zh-Hant":"封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_block_user_title',
                'item_value' => '{"en":"Blockers","zh-Hans":"屏蔽者","zh-Hant":"封鎖名單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_block_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'group_block_public_count',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_like_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_like_name',
                'item_value' => '{"en":"Like","zh-Hans":"赞","zh-Hant":"喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_like_user_title',
                'item_value' => '{"en":"Likers","zh-Hans":"喜欢者","zh-Hant":"喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_like_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_like_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_dislike_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_dislike_name',
                'item_value' => '{"en":"Dislike","zh-Hans":"不感兴趣","zh-Hant":"不感興趣"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_dislike_user_title',
                'item_value' => '{"en":"Dislikers","zh-Hans":"不喜欢者","zh-Hant":"不喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_dislike_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_dislike_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_follow_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_follow_name',
                'item_value' => '{"en":"Watching","zh-Hans":"订阅","zh-Hant":"訂閱"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_follow_user_title',
                'item_value' => '{"en":"Subscribers","zh-Hans":"订阅者","zh-Hant":"訂閱者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_follow_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_follow_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_block_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_block_name',
                'item_value' => '{"en":"Block","zh-Hans":"屏蔽","zh-Hant":"封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_block_user_title',
                'item_value' => '{"en":"Blockers","zh-Hans":"屏蔽者","zh-Hant":"封鎖名單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_block_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'hashtag_block_public_count',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_like_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_like_name',
                'item_value' => '{"en":"Like","zh-Hans":"赞","zh-Hant":"喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_like_user_title',
                'item_value' => '{"en":"Likers","zh-Hans":"喜欢者","zh-Hant":"喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_like_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_like_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_dislike_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_dislike_name',
                'item_value' => '{"en":"Dislike","zh-Hans":"不感兴趣","zh-Hant":"不感興趣"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_dislike_user_title',
                'item_value' => '{"en":"Dislikers","zh-Hans":"不喜欢者","zh-Hant":"不喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_dislike_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_dislike_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_follow_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_follow_name',
                'item_value' => '{"en":"Watching","zh-Hans":"订阅","zh-Hant":"訂閱"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_follow_user_title',
                'item_value' => '{"en":"Subscribers","zh-Hans":"订阅者","zh-Hant":"訂閱者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_follow_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_follow_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_block_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_block_name',
                'item_value' => '{"en":"Block","zh-Hans":"屏蔽","zh-Hant":"封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_block_user_title',
                'item_value' => '{"en":"Blockers","zh-Hans":"屏蔽者","zh-Hant":"封鎖名單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_block_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'geotag_block_public_count',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_like_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_like_name',
                'item_value' => '{"en":"Like","zh-Hans":"赞","zh-Hant":"喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_like_user_title',
                'item_value' => '{"en":"Likers","zh-Hans":"喜欢者","zh-Hant":"喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_like_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_like_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_dislike_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_dislike_name',
                'item_value' => '{"en":"Dislike","zh-Hans":"不喜欢","zh-Hant":"不喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_dislike_user_title',
                'item_value' => '{"en":"Dislikers","zh-Hans":"不喜欢者","zh-Hant":"不喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_dislike_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_dislike_public_count',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_follow_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_follow_name',
                'item_value' => '{"en":"Save post","zh-Hans":"收藏","zh-Hant":"儲存"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_follow_user_title',
                'item_value' => '{"en":"Collectors","zh-Hans":"收藏者","zh-Hant":"儲存者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_follow_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_follow_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_block_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_block_name',
                'item_value' => '{"en":"Hide post","zh-Hans":"不想看到","zh-Hant":"不想看到"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_block_user_title',
                'item_value' => '{"en":"Blockers","zh-Hans":"屏蔽者","zh-Hant":"封鎖名單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_block_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_block_public_count',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_like_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_like_name',
                'item_value' => '{"en":"Like","zh-Hans":"赞","zh-Hant":"喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_like_user_title',
                'item_value' => '{"en":"Likers","zh-Hans":"喜欢者","zh-Hant":"喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_like_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_like_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_dislike_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_dislike_name',
                'item_value' => '{"en":"Dislike","zh-Hans":"不喜欢","zh-Hant":"不喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_dislike_user_title',
                'item_value' => '{"en":"Dislikers","zh-Hans":"不喜欢者","zh-Hant":"不喜歡者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_dislike_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_dislike_public_count',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_follow_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_follow_name',
                'item_value' => '{"en":"Save comment","zh-Hans":"收藏","zh-Hant":"儲存"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_follow_user_title',
                'item_value' => '{"en":"Collectors","zh-Hans":"收藏者","zh-Hant":"儲存者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_follow_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_follow_public_count',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_block_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_block_name',
                'item_value' => '{"en":"Hide comment","zh-Hans":"不想看到","zh-Hant":"不想看到"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_block_user_title',
                'item_value' => '{"en":"Blockers","zh-Hans":"屏蔽者","zh-Hant":"封鎖名單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_block_public_record',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_block_public_count',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_posts_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_comments_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likers_name',
                'item_value' => '{"en":"Likers","zh-Hans":"被喜欢","zh-Hant":"被喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikers_name',
                'item_value' => '{"en":"Dislikers","zh-Hans":"点踩他的用户","zh-Hant":"不喜歡他的使用者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_followers_name',
                'item_value' => '{"en":"Followers","zh-Hans":"粉丝","zh-Hant":"跟隨者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blockers_name',
                'item_value' => '{"en":"Blockers","zh-Hans":"被拉黑","zh-Hant":"封鎖他的使用者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_followers_you_follow_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_followers_you_follow_name',
                'item_value' => '{"en":"Followers You Know","zh-Hans":"你认识的关注者","zh-Hant":"你所認識的跟隨者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_users_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_users_name',
                'item_value' => '{"en":"They like the users","zh-Hans":"他点赞的用户","zh-Hant":"他喜歡的使用者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_groups_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_groups_name',
                'item_value' => '{"en":"They like the groups","zh-Hans":"他赞的小组","zh-Hant":"他喜歡的社團"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_hashtags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_hashtags_name',
                'item_value' => '{"en":"They like the hashtags","zh-Hans":"他赞的话题","zh-Hant":"他喜歡的話題"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_geotags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_geotags_name',
                'item_value' => '{"en":"They like the geotags","zh-Hans":"他赞的地理","zh-Hant":"他喜歡的地理"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_posts_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_posts_name',
                'item_value' => '{"en":"They like the posts","zh-Hans":"他赞的帖子","zh-Hant":"他喜歡的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_comments_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_likes_comments_name',
                'item_value' => '{"en":"They like the comments","zh-Hans":"他赞的评论","zh-Hant":"他喜歡的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_users_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_users_name',
                'item_value' => '{"en":"They dislike the users","zh-Hans":"他踩的用户","zh-Hant":"他不喜歡的使用者"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_groups_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_groups_name',
                'item_value' => '{"en":"They dislike the groups","zh-Hans":"他踩的小组","zh-Hant":"他不喜歡的社團"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_hashtags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_hashtags_name',
                'item_value' => '{"en":"They dislike the hashtags","zh-Hans":"他踩的话题","zh-Hant":"他不喜歡的話題"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_geotags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_geotags_name',
                'item_value' => '{"en":"They dislike the geotags","zh-Hans":"他踩的地理","zh-Hant":"他不喜歡的地理"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_posts_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_posts_name',
                'item_value' => '{"en":"They dislike the posts","zh-Hans":"他踩的帖子","zh-Hant":"他不喜歡的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_comments_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_dislikes_comments_name',
                'item_value' => '{"en":"They dislike the comments","zh-Hans":"他踩的评论","zh-Hant":"他不喜歡的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_users_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_users_name',
                'item_value' => '{"en":"Following","zh-Hans":"正在关注","zh-Hant":"跟隨中"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_groups_enabled',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_groups_name',
                'item_value' => '{"en":"They follow the groups","zh-Hans":"加入的小组","zh-Hant":"加入的社團"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_hashtags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_hashtags_name',
                'item_value' => '{"en":"Watching","zh-Hans":"正在订阅","zh-Hant":"訂閱中"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_geotags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_geotags_name',
                'item_value' => '{"en":"Geotag Collections","zh-Hans":"他的收藏","zh-Hant":"他的收藏"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_posts_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_posts_name',
                'item_value' => '{"en":"Collections","zh-Hans":"他的收藏","zh-Hant":"他的收藏"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_comments_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_following_comments_name',
                'item_value' => '{"en":"Comment Collections","zh-Hans":"他的收藏","zh-Hant":"他的收藏"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_users_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_users_name',
                'item_value' => '{"en":"They blacklist","zh-Hans":"他的黑名单","zh-Hant":"他的黑名單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_groups_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_groups_name',
                'item_value' => '{"en":"They block the groups","zh-Hans":"他屏蔽的小组","zh-Hant":"他封鎖的社團"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_hashtags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_hashtags_name',
                'item_value' => '{"en":"They block the hashtags","zh-Hans":"他屏蔽的话题","zh-Hant":"他封鎖的話題"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_geotags_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_geotags_name',
                'item_value' => '{"en":"They block the geotags","zh-Hans":"他屏蔽的地理","zh-Hant":"他封鎖的地理"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_posts_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_posts_name',
                'item_value' => '{"en":"They block the posts","zh-Hans":"他屏蔽的帖子","zh-Hant":"他封鎖的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_comments_enabled',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'profile_blocking_comments_name',
                'item_value' => '{"en":"They block the comments","zh-Hans":"他屏蔽的评论","zh-Hant":"他封鎖的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
        ]);
        DB::table('configs')->insert([
            [
                'item_key' => 'post_required_email',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_required_phone',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_required_kyc',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_type',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_period_start',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_period_end',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_cycle_start',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_cycle_end',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_rule',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_tip',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_limit_whitelist',
                'item_value' => '["1"]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_group',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_title',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_sticker',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_image',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_video',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_audio',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_document',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_mention',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_hashtag',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_extend',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_location',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_anonymous',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_image_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_video_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_audio_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_document_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_image_max_upload_number',
                'item_value' => '9',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_video_max_upload_number',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_audio_max_upload_number',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_document_max_upload_number',
                'item_value' => '10',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_group_required',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_title_show',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_title_required',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_title_length',
                'item_value' => '80',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_editor_content_length',
                'item_value' => '20000',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_required_email',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_required_phone',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_required_kyc',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_status',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_type',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_period_start',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_period_end',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_cycle_start',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_cycle_end',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_rule',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_tip',
                'item_value' => null,
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_limit_whitelist',
                'item_value' => '["1"]',
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_sticker',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_image',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_video',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_audio',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_document',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_mention',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_hashtag',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_extend',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_location',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_anonymous',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_image_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_video_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_audio_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_document_upload_method',
                'item_value' => 'fresns',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_image_max_upload_number',
                'item_value' => '1',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_video_max_upload_number',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_audio_max_upload_number',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_document_max_upload_number',
                'item_value' => '0',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_editor_content_length',
                'item_value' => '10000',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'ip_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'map_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'notifications_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'content_review_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_list_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_timelines_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_nearby_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'post_detail_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_list_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_timelines_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_nearby_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'comment_detail_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'search_users_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'search_groups_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'search_hashtags_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'search_geotags_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'search_posts_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'search_comments_service',
                'item_value' => null,
                'item_type' => 'plugin',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'interface_command_words',
                'item_value' => null,
                'item_type' => 'array',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'default_homepage',
                'item_value' => 'post',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_portal_name',
                'item_value' => '{"en":"Portal","zh-Hans":"门户","zh-Hant":"門戶"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_portal_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_portal_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_name',
                'item_value' => '{"en":"Users","zh-Hans":"用户主页","zh-Hant":"使用者主頁"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_list_name',
                'item_value' => '{"en":"User List","zh-Hans":"用户列表","zh-Hant":"使用者清單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_list_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_list_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_list_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_user_list_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_likes_users_name',
                'item_value' => '{"en":"My Like","zh-Hans":"我的喜欢","zh-Hant":"我的喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_dislikes_users_name',
                'item_value' => '{"en":"My Dislike","zh-Hans":"我不喜欢的","zh-Hant":"我不喜歡的"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_following_users_name',
                'item_value' => '{"en":"My Follow","zh-Hans":"我的关注","zh-Hant":"我的跟隨"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_blocking_users_name',
                'item_value' => '{"en":"Blacklist","zh-Hans":"黑名单","zh-Hant":"我的封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_name',
                'item_value' => '{"en":"Groups","zh-Hans":"小组主页","zh-Hant":"社團主頁"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_type',
                'item_value' => 'tree',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_list_name',
                'item_value' => '{"en":"Group List","zh-Hans":"小组列表","zh-Hant":"社團清單"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_list_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_list_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_list_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_list_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_group_detail_type',
                'item_value' => 'posts',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_likes_groups_name',
                'item_value' => '{"en":"My Like","zh-Hans":"我的喜欢","zh-Hant":"我的喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_dislikes_groups_name',
                'item_value' => '{"en":"My Dislike","zh-Hans":"我不喜欢的","zh-Hant":"我不喜歡的"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_following_groups_name',
                'item_value' => '{"en":"My Groups","zh-Hans":"我的小组","zh-Hant":"我的社團"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_blocking_groups_name',
                'item_value' => '{"en":"Blacklist","zh-Hans":"黑名单","zh-Hant":"我的封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_name',
                'item_value' => '{"en":"Hashtags","zh-Hans":"话题主页","zh-Hant":"話題首頁"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_list_name',
                'item_value' => '{"en":"Hashtag List","zh-Hans":"话题列表","zh-Hant":"話題列表"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_list_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_list_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_list_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_list_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_hashtag_detail_type',
                'item_value' => 'posts',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_likes_hashtags_name',
                'item_value' => '{"en":"My Like","zh-Hans":"我的喜欢","zh-Hant":"我的喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_dislikes_hashtags_name',
                'item_value' => '{"en":"My Dislike","zh-Hans":"我不喜欢的","zh-Hant":"我不喜歡的"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_following_hashtags_name',
                'item_value' => '{"en":"My Follow","zh-Hans":"我的订阅","zh-Hant":"我的訂閱"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_blocking_hashtags_name',
                'item_value' => '{"en":"Blacklist","zh-Hans":"我不感兴趣的","zh-Hant":"我不感興趣的"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_name',
                'item_value' => '{"en":"Geotags","zh-Hans":"地理主页","zh-Hant":"地理首頁"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_list_name',
                'item_value' => '{"en":"Geotag List","zh-Hans":"地理列表","zh-Hant":"地理列表"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_list_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_list_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_list_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_list_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_geotag_detail_type',
                'item_value' => 'posts',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_likes_geotags_name',
                'item_value' => '{"en":"My Like","zh-Hans":"我的喜欢","zh-Hant":"我的喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_dislikes_geotags_name',
                'item_value' => '{"en":"My Dislike","zh-Hans":"我不喜欢的","zh-Hant":"我不喜歡的"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_following_geotags_name',
                'item_value' => '{"en":"Favorites","zh-Hans":"收藏夹","zh-Hant":"收藏夾"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_blocking_geotags_name',
                'item_value' => '{"en":"Blacklist","zh-Hans":"黑名单","zh-Hant":"我的封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_name',
                'item_value' => '{"en":"Posts","zh-Hans":"帖子主页","zh-Hant":"貼文首頁"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_list_name',
                'item_value' => '{"en":"Post List","zh-Hans":"帖子列表","zh-Hant":"貼文列表"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_list_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_list_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_list_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_post_list_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_likes_posts_name',
                'item_value' => '{"en":"My Like","zh-Hans":"我的喜欢","zh-Hant":"我的喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_dislikes_posts_name',
                'item_value' => '{"en":"My Dislike","zh-Hans":"我不喜欢的","zh-Hant":"我不喜歡的"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_following_posts_name',
                'item_value' => '{"en":"Favorites","zh-Hans":"收藏夹","zh-Hant":"收藏夾"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_blocking_posts_name',
                'item_value' => '{"en":"Blacklist","zh-Hans":"黑名单","zh-Hant":"我的封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_name',
                'item_value' => '{"en":"Comments","zh-Hans":"评论主页","zh-Hant":"留言主頁"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_list_name',
                'item_value' => '{"en":"Comment List","zh-Hans":"评论列表","zh-Hant":"留言列表"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_list_seo',
                'item_value' => '{"en":{"title":"","description":"","keywords":""},"zh-Hans":{"title":"","description":"","keywords":""},"zh-Hant":{"title":"","description":"","keywords":""}}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_list_query_state',
                'item_value' => '2',
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_list_query_config',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_comment_list_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_likes_comments_name',
                'item_value' => '{"en":"My Like","zh-Hans":"我的喜欢","zh-Hant":"我的喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_dislikes_comments_name',
                'item_value' => '{"en":"My Dislike","zh-Hans":"我不喜欢的","zh-Hant":"我不喜歡的"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_following_comments_name',
                'item_value' => '{"en":"Favorites","zh-Hans":"收藏夹","zh-Hant":"收藏夾"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_blocking_comments_name',
                'item_value' => '{"en":"Blacklist","zh-Hans":"黑名单","zh-Hant":"我的封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_name',
                'item_value' => '{"en":"Following","zh-Hans":"正在关注","zh-Hant":"正在跟隨"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_type',
                'item_value' => 'posts',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_posts_name',
                'item_value' => '{"en":"Following","zh-Hans":"正在关注","zh-Hant":"正在跟隨"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_posts_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_user_posts_name',
                'item_value' => '{"en":"Following Users Posts","zh-Hans":"关注用户的帖子","zh-Hant":"跟隨用戶的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_group_posts_name',
                'item_value' => '{"en":"Following Groups Posts","zh-Hans":"关注小组的帖子","zh-Hant":"跟隨社團的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_hashtag_posts_name',
                'item_value' => '{"en":"Following Hashtags Posts","zh-Hans":"关注话题的帖子","zh-Hant":"跟隨話題的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_geotag_posts_name',
                'item_value' => '{"en":"Following Geotags Posts","zh-Hans":"关注地理的帖子","zh-Hant":"跟隨地理的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_comments_name',
                'item_value' => '{"en":"Following","zh-Hans":"正在关注","zh-Hant":"正在跟隨"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_comments_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_user_comments_name',
                'item_value' => '{"en":"Following Users Comments","zh-Hans":"关注用户的评论","zh-Hant":"跟隨用戶的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_group_comments_name',
                'item_value' => '{"en":"Following Groups Comments","zh-Hans":"关注小组的评论","zh-Hant":"跟隨社團的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_hashtag_comments_name',
                'item_value' => '{"en":"Following Hashtags Comments","zh-Hans":"关注话题的评论","zh-Hant":"跟隨話題的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_timeline_geotag_comments_name',
                'item_value' => '{"en":"Following Geotags Comments","zh-Hans":"关注地理的评论","zh-Hant":"跟隨地理的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_nearby_name',
                'item_value' => '{"en":"Nearby","zh-Hans":"附近","zh-Hant":"附近"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_nearby_type',
                'item_value' => 'posts',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_nearby_posts_name',
                'item_value' => '{"en":"Posts by Nearby","zh-Hans":"附近的帖子","zh-Hant":"附近的貼文"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_nearby_posts_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_nearby_comments_name',
                'item_value' => '{"en":"Comments by Nearby","zh-Hans":"附近的评论","zh-Hant":"附近的留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_nearby_comments_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_me_name',
                'item_value' => '{"en":"Personal Center","zh-Hans":"个人中心","zh-Hant":"個人中心"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_me_wallet_name',
                'item_value' => '{"en":"Wallet","zh-Hans":"钱包","zh-Hant":"錢包"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_me_extcredits_name',
                'item_value' => '{"en":"Extcredits","zh-Hans":"扩展分值","zh-Hant":"擴展分數"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_me_drafts_name',
                'item_value' => '{"en":"Drafts","zh-Hans":"草稿箱","zh-Hant":"草稿箱"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_me_users_name',
                'item_value' => '{"en":"Users","zh-Hans":"用户","zh-Hant":"用戶"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_me_settings_name',
                'item_value' => '{"en":"Settings","zh-Hans":"设置","zh-Hant":"設定"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_conversations_name',
                'item_value' => '{"en":"Messages","zh-Hans":"消息","zh-Hant":"訊息"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_name',
                'item_value' => '{"en":"Notifications","zh-Hans":"通知","zh-Hant":"通知"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_all_name',
                'item_value' => '{"en":"All","zh-Hans":"全部","zh-Hant":"全部"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_systems_name',
                'item_value' => '{"en":"Systems","zh-Hans":"系统","zh-Hant":"系統"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_recommends_name',
                'item_value' => '{"en":"Recommends","zh-Hans":"推荐","zh-Hant":"推薦"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_likes_name',
                'item_value' => '{"en":"Likes","zh-Hans":"赞","zh-Hant":"喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_dislikes_name',
                'item_value' => '{"en":"Dislikes","zh-Hans":"踩","zh-Hant":"不喜歡"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_follows_name',
                'item_value' => '{"en":"Follows","zh-Hans":"关注","zh-Hant":"跟隨"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_blocks_name',
                'item_value' => '{"en":"Blocks","zh-Hans":"屏蔽","zh-Hant":"封鎖"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_mentions_name',
                'item_value' => '{"en":"Mentions","zh-Hans":"提及","zh-Hant":"提及"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_comments_name',
                'item_value' => '{"en":"Comments","zh-Hans":"评论","zh-Hant":"留言"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_notifications_quotes_name',
                'item_value' => '{"en":"Quotes","zh-Hans":"引用","zh-Hant":"引用"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'channel_search_name',
                'item_value' => '{"en":"Search","zh-Hans":"搜索","zh-Hant":"搜尋"}',
                'item_type' => 'object',
                'is_multilingual' => 1,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_portal_path',
                'item_value' => 'portal',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_user_path',
                'item_value' => 'users',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_group_path',
                'item_value' => 'groups',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_hashtag_path',
                'item_value' => 'hashtags',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_geotag_path',
                'item_value' => 'geotags',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_post_path',
                'item_value' => 'posts',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_comment_path',
                'item_value' => 'comments',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_user_detail_path',
                'item_value' => 'u',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_group_detail_path',
                'item_value' => 'group',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_hashtag_detail_path',
                'item_value' => 'hashtag',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_geotag_detail_path',
                'item_value' => 'geotag',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_post_detail_path',
                'item_value' => 'post',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_comment_detail_path',
                'item_value' => 'comment',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'language_pack_version',
                'item_value' => '1.0.0',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_stat_code',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_stat_position',
                'item_value' => 'body',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'site_china_mode',
                'item_value' => 'false',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'china_icp_filing',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'china_icp_license',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'china_mps_filing',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'china_broadcasting_license',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 1,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_status',
                'item_value' => 'true',
                'item_type' => 'boolean',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_api_type',
                'item_value' => 'local',
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_api_host',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_api_app_id',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_api_app_key',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_key_id',
                'item_value' => null,
                'item_type' => 'number',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_view_desktop',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
            [
                'item_key' => 'website_engine_view_mobile',
                'item_value' => null,
                'item_type' => 'string',
                'is_multilingual' => 0,
                'is_custom' => 0,
                'is_api' => 0,
                'created_at' => '2022-10-18 10:00:00',
                'updated_at' => null,
                'deleted_at' => null,
            ],
        ]);
    }
}
