<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Painel de controle de Fresns',
    'fresns_core' => 'Núcleo de Fresns',
    // Login page
    'language' => 'Linguagem',
    'login' => 'Conecte-se',
    'account' => 'Conta',
    'password' => 'Senha',
    'enter' => 'Entrar',
    'operation' => 'Funcionamento do Painel',
    'site_home' => 'Página de Internet',
    'switch_language' => 'Mudar de língua',
    'logout' => 'Sair',
    // Header menus
    'menu_dashboard' => 'Painel',
    'menu_systems' => 'Sistemas',
    'menu_operations' => 'Operações',
    'menu_extends' => 'Se extende',
    'menu_clients' => 'Clientes',
    'menu_app_center' => 'Centro de aplicação',
    'menu_marketplace' => 'Mercado',
    // Sidebar menus
    'sidebar_home' => 'Lar',
    'sidebar_admins' => 'Admins',
    'sidebar_events' => 'Eventos',
    'sidebar_events_tab_subscribe' => 'Subscrever',
    'sidebar_events_tab_crontab' => 'Crontab',
    'sidebar_caches' => 'Caches',
    'sidebar_caches_tab_config' => 'Config Cache',
    'sidebar_caches_tab_data' => 'Cache de dados',
    'sidebar_upgrades' => 'Atualizações',
    'sidebar_settings' => 'Configurações',
    'sidebar_languages' => 'línguas',
    'sidebar_storage' => 'Armazenar',
    'sidebar_storage_tab_image' => 'Imagem',
    'sidebar_storage_tab_video' => 'Vídeo',
    'sidebar_storage_tab_audio' => 'Áudio',
    'sidebar_storage_tab_document' => 'Documento',
    'sidebar_storage_tab_substitution' => 'Substituição',
    'sidebar_general' => 'Em geral',
    'sidebar_policy' => 'Política',
    'sidebar_policy_tab_options' => 'Opções',
    'sidebar_policy_tab_contents' => 'Conteúdo',
    'sidebar_send' => 'Mandar',
    'sidebar_send_tab_services' => 'Enviar serviços',
    'sidebar_send_tab_templates' => 'Verificar modelos de código',
    'sidebar_account' => 'Conta',
    'sidebar_wallet' => 'Carteira',
    'sidebar_wallet_tab_options' => 'Opções',
    'sidebar_wallet_tab_recharge_services' => 'Recharge Services',
    'sidebar_wallet_tab_withdraw_services' => 'Retirar serviços',
    'sidebar_user' => 'Utilizador',
    'sidebar_content' => 'Conteúdo',
    'sidebar_interaction' => 'Interação',
    'sidebar_publish' => 'Publicar',
    'sidebar_publish_tab_post' => 'Publicar',
    'sidebar_publish_tab_comment' => 'Comente',
    'sidebar_roles' => 'Papéis',
    'sidebar_stickers' => 'Adesivos',
    'sidebar_groups' => 'Grupos',
    'sidebar_groups_tab_active' => 'Ativo',
    'sidebar_groups_tab_deactivate' => 'Inativo',
    'sidebar_groups_tab_recommend' => 'Ver Recomendar apenas',
    'sidebar_extend_editor' => 'editor',
    'sidebar_extend_content_type' => 'Tipo de conteúdo',
    'sidebar_extend_content_handler' => 'Gestor de conteúdos',
    'sidebar_extend_manage' => 'Gerenciar',
    'sidebar_extend_group' => 'Grupo',
    'sidebar_extend_group_filter' => 'Filtro',
    'sidebar_extend_user_feature' => 'Recurso do usuário',
    'sidebar_extend_user_profile' => 'Perfil de usuário',
    'sidebar_extend_channel' => 'Canal',
    'sidebar_extend_command_words' => 'Palavras de comando',
    'sidebar_channels' => 'Canais',
    'sidebar_paths' => 'Caminho',
    'sidebar_language_packs' => 'Pacotes de idiomas',
    'sidebar_code_messages' => 'Mensagens em código',
    'sidebar_client_basic' => 'Base',
    'sidebar_client_status' => 'Estado',
    'sidebar_plugins' => 'Plugins',
    'sidebar_plugins_tab_all' => 'Todo',
    'sidebar_plugins_tab_active' => 'Ativo',
    'sidebar_plugins_tab_inactive' => 'Inativo',
    'sidebar_themes' => 'Temas',
    'sidebar_apps' => 'Aplicações',
    'sidebar_keys' => 'Chave de aplicação',
    // Sidebar intro
    'sidebar_admins_intro' => 'Usuários que têm o direito de efetuar login no painel de controle',
    'sidebar_events_intro' => 'Ver tarefas cronometradas e eventos de subscrição no sistema',
    'sidebar_caches_intro' => 'Ao limpar toda a cache, pode aumentar a carga no servidor, por isso tente por favor evitar picos de acesso.',
    'sidebar_upgrades_intro' => 'Finalmente',
    'sidebar_settings_intro' => 'Por favor, limpar a cache quando a configuração estiver completa, ou esperar 10 minutos para que a nova cache tenha efeito.',
    'sidebar_storage_intro' => 'Quatro arquivos de recursos podem ser armazenados separadamente ou armazenados no mesmo, basta preencher as informações de configuração de armazenamento',
    'sidebar_languages_intro' => 'Multi-linguagem precisa configurar as opções de idioma aqui antes de poder inserir conteúdo multilíngue no item de configuração correspondente',
    'sidebar_general_intro' => 'Salvaguardar os itens de configuração do sistema em execução',
    'sidebar_policy_intro' => 'De acordo com os regulamentos legais de dados relevantes no país do mercado-alvo',
    'sidebar_send_intro' => 'Mensagens e outras mensagens, como correio sms e notificações do sistema',
    'sidebar_account_intro' => 'Definições de funções do centro de contas',
    'sidebar_wallet_intro' => 'A carteira é uma característica monetária real, se você precisar de uma função integral virtual, instale o plugin apropriado',
    'sidebar_wallet_tab_recharge_services_intro' => 'A configuração do provedor de serviços de recarga será renderizada na lista de funções "Wallet" para pedidos de pagamento ou recarregar a carteira',
    'sidebar_wallet_tab_withdraw_services_intro' => 'A configuração do Provedor de Serviços de Dispensação estará presente na lista de funções "Wallet", que é usada para o balanço da Wallet em dinheiro na conta especificada',
    'sidebar_user_intro' => 'Configurações de função básica do usuário',
    'sidebar_content_intro' => 'Nome do conteúdo social e configuração da função',
    'sidebar_interaction_intro' => 'A percepção do usuário sobre o serviço de um produto (senso de experiência) não depende da lógica técnica, mas da nomeação dos pontos de função.',
    'sidebar_publish_intro' => 'Essa configuração é válida para todos os membros, e a prioridade prioritária é maior que as permissões de papel do usuário',
    'sidebar_roles_intro' => 'A função pode definir configurações específicas para identidade e permissões do usuário',
    'sidebar_stickers_intro' => 'Configuração personalizada emotiva, no caso de não configurar, os usuários também podem inserir expressões emoji através do teclado do Emaok',
    'sidebar_groups_intro' => 'O grupo de uso pode realizar vários cenários de operação, como projetos BBS, círculos comunitários, classificação de conteúdo',
    'sidebar_extend_editor_intro' => 'No "Editor" do processo de liberação, por exemplo, a extensão "voto" permite ao "editor" apoiar a função de votação que acompanha o post',
    'sidebar_extend_content_type_intro' => 'O post será apresentado na página "POST", que é usado para gerar a mensagem especificada "Digite" e definir a origem de dados',
    'sidebar_extend_content_handler_intro' => 'A função é a mesma que a função de fonte de dados "Extensão do tipo de conteúdo", se a solicitação é distribuída no processamento do plugin e a lógica de dados é determinada pelo plugin',
    'sidebar_extend_manage_intro' => 'Na lista de recursos "mais" da postagem, comentário, homepage do usuário, como a extensão "Reclamação" permite que os usuários reclamem os alvos correspondentes',
    'sidebar_extend_group_intro' => 'A apresentação é apresentada na página inicial "Grupo", como "plugin de extensão de link puro" pode exibir um hiperlink na página inicial "Grupo"',
    'sidebar_extend_user_feature_intro' => 'A página "Minha" será apresentada no "centro de usuários", como a extensão "carteira", permite ao usuário mais função da carteira',
    'sidebar_extend_user_profile_intro' => 'Na lista de funções de gerenciamento "Informações do usuário", como "modificar o plugin do nome de usuário" permite que as informações de modificação suportem a modificação do nome de usuário',
    'sidebar_extend_channel_intro' => 'É apresentado no menu principal ou numa lista de páginas de canais, por exemplo, a extensão Shopping permite ao utilizador aceder ao canal Mall.',
    'sidebar_extend_command_words_intro' => 'As palavras de comando configuradas nesta lista estão disponíveis para pedidos de API.',
    'sidebar_channels_intro' => 'Configuração unificada das informações do canal individual do cliente.',
    'sidebar_paths_intro' => 'Estruturas de caminho personalizadas podem melhorar a estética, a usabilidade e a compatibilidade das suas ligações com o futuro.',
    'sidebar_language_packs_intro' => 'Configure o conteúdo multi-idioma de cada texto para clientes multi-linguagem',
    'sidebar_code_messages_intro' => 'Descrição multilingue dos códigos de estado configurados para o programa principal e plug-ins.',
    'sidebar_client_basic_intro' => 'Itens de configuração geral para a base de clientes.',
    'sidebar_client_status_intro' => 'Após a desativação, todas as páginas e acções do cliente saltarão para a página de instruções de desativação.',
    'sidebar_plugins_intro' => 'Recursos flexíveis, extensões poderosas ajudam você a jogar livremente',
    'sidebar_themes_intro' => 'Selecione diferentes tópicos para obter um estilo e interação mais personalizados',
    'sidebar_apps_intro' => 'APIs padrão, extensões poderosas, criam uma variedade de cenários operacionais e modelos de aplicação à sua vontade.',
    'sidebar_keys_intro' => 'Credenciais-chave são importantes, não os divulguem facilmente para os outros',
    // Page button
    'button_support' => 'Apoiar',
    'button_update' => 'Actualização',
    'button_search' => 'Procurar',
    'button_add' => 'Adicionar',
    'button_edit' => 'Editar',
    'button_modify' => 'Modificar',
    'button_delete' => 'Excluir',
    'button_cancel' => 'Cancelar',
    'button_close' => 'Fechar',
    'button_dismiss' => 'Indeferimento',
    'button_activate' => 'Ativar',
    'button_deactivate' => 'Desativar',
    'button_install' => 'Instalar',
    'button_uninstall' => 'Desinstalar',
    'button_setting' => 'Contexto',
    'button_config' => 'Config',
    'button_reset' => 'Redefinir',
    'button_confirm' => 'confirme',
    'button_try_again' => 'Tentar de novo',
    'button_save' => 'Salvar',
    'button_download' => 'Descarregar',
    'button_upgrade' => 'Actualização',
    'button_automatic_upgrade' => 'Actualização automática',
    'button_manual_upgrade' => 'Actualização Manual',
    'button_confirm_delete' => 'Confirmar delete',
    'button_confirm_install' => 'Confirmar Instalação',
    'button_confirm_upgrade' => 'Confirme a atualização',
    'button_confirm_download' => 'Confirmar a transferência',
    'button_confirm_uninstall' => 'Confirme desinstalação',
    'button_view' => 'Visualizar',
    'button_image_upload' => 'Carregar',
    'button_image_input' => 'Entrada',
    'button_check_upgrade' => 'Verifique a atualização',
    'button_check_status' => 'Verificar o estado',
    'button_batch_import' => 'Importar',
    'button_batch_export' => 'Exportar',
    'button_config_email_template' => 'Modelo de e-mail de configuração',
    'button_config_sms_template' => 'Config SMS Template',
    'button_config_sticker' => 'Adesivo de configuração',
    'button_config_permission' => 'Permissão de configuração',
    'button_config_language_pack' => 'CONFIG PACK',
    'button_add_admin' => 'Adicionar admin',
    'button_add_language' => 'Adicionar Lang',
    'button_add_account_connect' => 'Adicionar conta Connect',
    'button_add_service_provider' => 'Adicionar serviço',
    'button_add_sticker_group' => 'Adicione o grupo da etiqueta',
    'button_add_sticker' => 'Adicionar adesivo',
    'button_add_role' => 'Adicionar função',
    'button_add_group' => 'Adicionar grupo',
    'button_group_move' => 'Mover',
    'button_add_key' => 'Adicionar chave',
    'button_reset_key' => 'Repor a chave',
    'button_reset_secret' => 'Redefinir segredo',
    'button_clear_cache' => 'cache claro',
    'button_clear_all_cache' => 'Limpar todas as Caches',
    // Page table
    'table_order' => 'Ordem de ordenação',
    'table_recommend_order' => 'Recomendar ordem de ordenação',
    'table_position' => 'Posição',
    'table_number' => 'Número',
    'table_lang_tag' => 'Lang Tag',
    'table_lang_name' => 'Nome da LANG',
    'table_title' => 'Título',
    'table_content' => 'Contente',
    'table_platform' => 'Plataforma',
    'table_service' => 'Serviço',
    'table_app_id' => 'ID do aplicativo',
    'table_app_key' => 'Tecla do aplicativo',
    'table_app_secret' => 'Secret do App',
    'table_plugin' => 'Plugar',
    'table_command_word' => 'Palavra de Comando',
    'table_name' => 'Nome',
    'table_description' => 'Descrição',
    'table_icon' => 'Ícone',
    'table_banner' => 'Bandeira',
    'table_type' => 'Tipo',
    'table_use' => 'Usar',
    'table_support' => 'Apoiar',
    'table_data_source' => 'Fonte de dados',
    'table_scene' => 'Cena',
    'table_number_of_uses' => 'Número de usos',
    'table_scope' => 'Alcance',
    'table_scope_global' => 'Global',
    'table_scope_global_desc' => 'Pode ser restrito a funções especificadas',
    'table_scope_group_admins' => 'Administradores do Grupo',
    'table_scope_group_admins_desc' => 'Quando ativado, somente os administradores do grupo mostrarão o plugin',
    'table_authorized_roles' => 'Papéis autorizados',
    'table_authorized_roles_desc' => 'Deixe em branco para indicar que todas as funções do usuário têm direito a usar',
    'table_whitelist_rules' => 'Função de lista branca',
    'table_parameter' => 'Parâmetro',
    'table_status' => 'Status',
    'table_options' => 'Opções',
    // Config option
    'option_default' => 'Predefinição',
    'option_all' => 'Todos',
    'option_public' => 'Público',
    'option_private' => 'Privada',
    'option_visible' => 'Visível',
    'option_hidden' => 'Escondido',
    'option_open' => 'Abrir',
    'option_close' => 'Fechar',
    'option_yes' => 'sim',
    'option_no' => 'Não',
    'option_activate' => 'Ativar',
    'option_deactivate' => 'Desativar',
    'option_local' => 'Local',
    'option_remote' => 'Remoto',
    'option_required' => 'Requeridos',
    'option_not_required' => 'Não requerido',
    'option_not_set' => 'Não definido',
    'option_no_use' => 'Não adianta',
    'option_unselect' => 'Não selecionar',
    'option_optional' => 'Opcional',
    'option_email' => 'E-mail',
    'option_sms' => 'SMS',
    'option_data_close' => 'Não público',
    'option_data_private' => 'Apenas eu',
    'option_data_public' => 'Público',
    'option_type_tree' => 'Árvore',
    'option_type_list' => 'Lista',
    'option_uninstall_plugin_data' => 'Excleção simultânea dos dados do plugin',
    'option_uninstall_theme_data' => 'Exclusão simultânea dos dados do tema',
    // Commons
    'portal' => 'Portal',
    'user' => 'Do utilizador',
    'group' => 'Grupo',
    'hashtag' => 'Hashtag',
    'geotag' => 'Geotag',
    'post' => 'Publicar',
    'comment' => 'Comente',
    'file' => 'Ficheiro',
    'extend' => 'Alargar o conteúdo',
    'user_detail' => 'Página inicial do utilizador',
    'group_detail' => 'Detalhe do Grupo',
    'hashtag_detail' => 'Detalhe do Hashtag',
    'geotag_detail' => 'Detalhe do Geotag',
    'post_detail' => 'Pormenor do posto',
    'comment_detail' => 'Detalhe do Comentário',
    'like' => 'Gosto',
    'dislike' => 'Não gostar',
    'follow' => 'Seguir',
    'block' => 'Bloquear',
    'author' => 'Autor',
    'new_version' => 'Novo',
    'default_language' => 'Idioma padrão',
    'default_list' => 'Lista predefinida',
    'recommend' => 'Recomendar',
    'unit_day' => 'Dia',
    'unit_length' => 'Comprimento',
    'unit_second' => 'Segundo',
    'unit_minute' => 'Minuto',
    'unit_within_minute' => 'Em um minuto',
    'unit_character' => 'Personagem',
    'unit_number' => 'Número',
    'unit_number_of_times' => 'Número de vezes',
    'unit_kilometer' => 'Quilômetro',
    'unit_mile' => 'Milha',
    'config_default' => 'Configuração predefinida',
    'config_name' => 'Nome da configuração',
    'config_edit' => 'Editar configuração',
    'config_interaction' => 'Configuração de interação',
    'config_conversation' => 'Configuração de conversação',
    'config_hashtag' => 'Configuração de Hashtag',
    'config_list' => 'Configuração de lista',
    'config_preview' => 'Pré-visualizar Config',
    'config_manage' => 'Gerenciar configuração',
    'delete_desc' => 'Certifique-se de excluir?',
    // Dashboard-Home
    'welcome' => 'Bem-vindo a Fresns',
    'current_version' => 'A versão atual usada é',
    'overview' => 'Dados do site',
    'overview_accounts' => 'Contas',
    'overview_users' => 'Utilizadores',
    'overview_groups' => 'Grupos',
    'overview_hashtags' => 'Hashtags',
    'overview_geotags' => 'Geotags',
    'overview_posts' => 'Posts',
    'overview_comments' => 'Comentários',
    'extensions' => 'Quantidade de aplicação',
    'support' => 'Manual de ajuda',
    'support_website' => 'Site oficial de Fresns',
    'support_teams' => 'Equipe de código aberto',
    'support_sponsor' => 'Patrocinador',
    'support_join' => 'Junte-se a nós',
    'support_community' => 'Comunidade de apoio',
    'support_marketplace' => 'Mercado de aplicativos',
    'system_info' => 'Mensagem do sistema',
    'system_info_server' => 'Sistema de servidor',
    'system_info_web' => 'Ambiente de funcionamento da web',
    'system_info_php_version' => 'PHP versão',
    'system_info_php_cli_info' => 'PHP Cli info',
    'system_info_php_upload_max_filesize' => 'Carregar o tamanho máximo do ficheiro',
    'system_info_composer_info' => 'Composer info',
    'system_info_composer_version' => 'Composer versão',
    'system_info_env_timezone' => '.env Fuso horário',
    'system_info_env_timezone_name' => '.env Identificador do fuso horário',
    'system_info_env_timezone_utc' => '.env Fuso horário UTC do identificador do fuso horário',
    'system_info_env_timezone_list' => 'Identificador de fuso horário correspondente',
    'system_info_database_driver' => 'Motorista da base de dados',
    'system_info_database_version' => 'Versão do banco de dados',
    'system_info_database_timezone' => 'Fuso horário da base de dados',
    'system_info_database_engine' => 'Data Stock Engine',
    'system_info_database_collation' => 'Regras de classificação do banco de dados',
    'system_info_database_size' => 'Tamanho atual do banco de dados',
    'tips' => 'Instruções de utilização',
    'news' => 'Atividades e notícias fresns',
    // Dashboard-Events
    'event_subscribe_subject' => 'Assunto',
    'event_crontab_time' => 'Ciclo de Execução',
    'event_crontab_time_desc' => 'Laravel formato de tabela de agendamento de tarefas cron',
    // Dashboard-Caches
    'cache' => 'Cache',
    'cache_fresns_system' => 'Configuração do sistema',
    'cache_fresns_config' => 'Configuração do site',
    'cache_fresns_extend' => 'Estender Config',
    'cache_fresns_view' => 'Ver',
    'cache_fresns_route' => 'Rota',
    'cache_fresns_event' => 'Evento',
    'cache_fresns_schedule' => 'Horário',
    'cache_fresns_temporary' => 'Dados temporários',
    // Dashboard-Admins
    'admin_add_title' => 'Novo administrador do sistema',
    'admin_add_form_account' => 'conta',
    'admin_add_form_account_placeholder' => 'E-mail ou número de celular',
    'admin_add_form_account_desc' => 'O número de celular deve ser um número completo com o código de área internacional',
    'admin_add_form_account_btn' => 'Pesquisa e aumento',
    // Dashboard-Settings
    'setting_developer_options' => 'Opções do programador',
    'setting_developer_options_desc' => 'Não desactivar opções se não se tratar de um ambiente de desenvolvimento.',
    'setting_build_type' => 'Tipo de versão',
    'setting_build_type_desc' => 'A versão beta é menos estável, por isso, por favor escolha cuidadosamente.',
    'setting_build_select_tip' => 'Seleccione o tipo de versão de actualização',
    'setting_build_option_stable' => 'Versão estável (Stable Build)',
    'setting_build_option_beta' => 'Beta Build',
    'setting_system_url' => 'URL do sistema',
    'setting_system_url_desc' => 'Endereços de acesso por defeito para o API principal e plugins',
    'setting_panel_path' => 'Entrada segura',
    'setting_panel_path_desc' => 'Após a configuração, você só pode efetuar login no painel de controle especificando a entrada de segurança',
    'setting_panel_url' => 'Endereço completo de entrada',
    'setting_panel_url_desc' => 'Entrada de login do painel de controle URL completo',
    'setting_panel_url_copy' => 'cópia de',
    // System-Languages
    'language_multilingual' => 'multi Idiomas',
    'language_table_default' => 'idioma padrão',
    'language_table_langCode' => 'Código de idioma',
    'language_table_areaCode' => 'Códigos de área',
    'language_table_langName' => 'Nome da linguagem',
    'language_table_areaName' => 'Nome da região',
    'language_table_lengthUnit' => 'Unidade de comprimento',
    'language_table_writingDirection' => 'Escrevendo direção',
    'language_table_area' => 'Área da linguagem',
    'language_table_dateFormat' => 'Formato de data',
    'language_table_dateFormat_desc' => 'Aiayy disse ano, mm disse o mês, DD significa o céu',
    'language_table_timeFormat' => 'Tempo humano',
    'language_table_timeFormat_desc' => 'Nome da variável de tempo {n}',
    'language_select_langCode' => 'Selecione o código de idioma',
    'language_select_continent' => 'Continente',
    'language_select_areaCode' => 'Selecione o código regional',
    // System-General
    'site_url' => 'URL do site',
    'site_url_desc' => 'URL de acesso ao site principal',
    'site_name' => 'Nome do site',
    'site_name_desc' => 'O nome do seu site Fresns',
    'site_intro' => 'Introdução ao site',
    'site_intro_desc' => 'Introdução ao seu site de Fresns',
    'site_logo' => 'Sinal do site',
    'site_logo_desc' => 'As informações em "Configurações de armazenamento" devem ser configuradas para carregar a imagem',
    'site_copyright' => 'Informações sobre direitos autorais',
    'site_email' => 'Caixa de correio do administrador',
    'site_email_desc' => 'Ao executar um erro, mostre ao usuário para facilitar o feedback do usuário',
    'site_mode' => 'Modo de operação',
    'site_mode_public' => 'Modo de publicação',
    'site_mode_private' => 'Modo privado',
    'site_mode_private_desc' => 'Configuração do modo privado',
    'site_mode_private_join_status' => 'Está aberto para o exterior?',
    'site_mode_private_join_service' => 'Junte-se ao plugin de suporte ao canal',
    'site_mode_private_content_policy' => 'Estado expirado privado',
    'site_mode_private_content_policy_1' => 'O conteúdo do site não é visível',
    'site_mode_private_content_policy_2' => 'Conteúdo antes da expiração, o novo conteúdo é invisível',
    // System-Policy
    'policy_terms' => 'Termos de serviço',
    'policy_privacy' => 'política de Privacidade',
    'policy_cookie' => 'Política de cookie',
    'policy_delete_account' => 'Instruções de logout',
    'policy_delete_options' => 'Função de logout',
    'policy_delete_options_desc' => 'O usuário pode revogar o logout (conta de recuperação) no dia do buffer, e o processo de cancelamento será executado sem desfazer',
    'policy_delete_option_1' => 'Não ative a função de logout',
    'policy_delete_option_2' => 'Login lógico',
    'policy_delete_option_2_desc' => 'Logic Logout: Somente no banco de dados é notificado no banco de dados, ele não é verdade para excluir os dados',
    'policy_delete_option_3' => 'Cancelamento físico',
    'policy_delete_option_3_desc' => 'Logout físico: dados de exclusão física, dados do usuário e conteúdo publicado serão verdadeiramente excluídos',
    'policy_delete_crontab' => 'Ciclo de logout',
    // System-Send
    'send_email_config' => 'Configuração da caixa de correio',
    'send_sms_config' => 'Configuração do SMS',
    'send_sms_default_code' => 'Código de área internacional padrão',
    'send_sms_supported_codes' => 'Suporta mais código de área',
    'send_sms_desc' => 'Uma linha, O representante em branco só suporta um único país. Por favor, confirme o provedor de serviços Suporte a função SMS internacional antes da configuração',
    'send_app_notifications' => 'Serviço de Notificação Push',
    'send_app_ios_config' => 'Configuração do iOS',
    'send_app_ios_notifications_desc' => 'Função de notificação pop-up do sistema iOS',
    'send_app_android_config' => 'Configuração do Android',
    'send_app_android_notifications_desc' => 'Função de notificação pop-up do sistema Android',
    'send_app_desktop_config' => 'Configuração do ambiente de trabalho',
    'send_app_desktop_notifications_desc' => 'Funcionalidades de notificação do ambiente de trabalho, tais como notificações do browser.',
    'send_code_template_1' => 'Código de Verificação Geral',
    'send_code_template_2' => 'Registrar uma nova conta',
    'send_code_template_3' => 'Modificar informações da conta',
    'send_code_template_4' => 'Substitua nova vinculação',
    'send_code_template_5' => 'Redefinir senha de login',
    'send_code_template_6' => 'Redefinir senha de pagamento',
    'send_code_template_7' => 'Faça o login com um código de verificação',
    'send_code_template_8' => 'Apagar conta usando código de verificação',
    'send_code_template_table_email_desc' => 'Suporte formato HTML',
    'send_code_template_table_sms_sign' => 'Nome da assinatura SMS',
    'send_code_template_table_sms_code' => 'Parâmetros de modelo',
    'send_code_template_table_sms_code_desc' => 'Você pode configurar o ID do modelo. Para detalhes, consulte a descrição do plugin associado',
    'send_code_template_table_sms_param' => 'Nome da variável de código de verificação',
    // System-Account
    'account_center_config' => 'Config do centro de contas',
    'account_child_safety' => 'Segurança das crianças',
    'account_age_verification' => 'Verificação da idade',
    'account_age_min_required' => 'Idade mínima exigida',
    'account_register_config' => 'Registar Config',
    'account_login_config' => 'Config de login',
    'account_password_config' => 'Config da palavra-passe',
    'account_center_service' => 'Centro de contas',
    'account_center_captcha' => 'Captcha',
    'account_register_service' => 'Servizio di registrazione',
    'account_register_status' => 'Se o registro aberto',
    'account_register_type' => 'Registre o suporte da conta',
    'account_register_type_email' => 'Email',
    'account_register_type_phone' => 'Número de telefone',
    'account_login_service' => 'Servizio di accesso',
    'account_login_support' => 'Apoio ao Login',
    'account_login_type_email' => 'Email',
    'account_login_type_phone' => 'Número de telefone',
    'account_code_login' => 'Verificar código Login',
    'account_login_or_register' => 'Registo automático se não estiver disponível uma conta quando o código de verificação estiver registado',
    'account_password_length' => 'Requisitos de comprimento',
    'account_password_length_desc' => 'Requisitos de comprimento: o comprimento mínimo, 0 ou não preenchido não é limitado',
    'account_password_strength' => 'Requisitos de força',
    'account_password_strength_desc' => 'Requisitos de força: O tipo de caractere selecionado deve estar presente na senha e não é limitado',
    'account_password_strength_digital' => 'número',
    'account_password_strength_lowerLetters' => 'Letras minúsculas',
    'account_password_strength_upperLetters' => 'Letra maiúscula',
    'account_password_strength_symbols' => 'Símbolo (Divisão)',
    'account_connect_services' => 'Suporte de interconexão de terceiros',
    'account_connect_services_desc' => 'Selecione a plataforma de interconexão e os plugins associados a fazer registro rápido ou login',
    'account_kyc_service' => 'Suporte de certificação de nome real',
    'account_kyc_service_desc' => 'Depois de instalar o plugin do serviço de autenticação, o usuário pode autenticar o nome real',
    'account_users_service' => 'Gestão de vários utilizadores',
    // System-Wallet
    'wallet_functions' => 'Função de carteira',
    'wallet_functions_desc' => 'Se deve habilitar o pacote de dinheiro francês',
    'wallet_currency_code' => 'Código da moeda',
    'wallet_currency_name' => 'Nome monetário',
    'wallet_currency_unit' => 'Unidade monetária',
    'wallet_currency_precision' => 'Precisão da moeda',
    'wallet_withdraw_status' => 'Dinheiro',
    'wallet_withdraw_config' => 'Configuração de caixa',
    'wallet_withdraw_config_desc' => 'Configuração adicional relacionada precisa ser suportada, consulte o desenvolvedor do plugin',
    'wallet_withdraw_review' => 'Dinheiro',
    'wallet_withdraw_review_prove' => 'Trazendo para verificar informações do nome real',
    'wallet_withdraw_periodicity' => 'Intervalo de dinheiro',
    'wallet_withdraw_rates' => 'Taxa de retirada de dinheiro',
    'wallet_withdraw_min' => 'Quantidade mínima de extradição única',
    'wallet_withdraw_max' => 'Montante máximo de retirada única',
    'wallet_withdraw_sum_limit' => 'Tampa de retirada diária',
    // System-Storage
    'storage_service_config' => 'Configuração de armazenamento',
    'storage_service_config_desc' => 'Provedores de serviços de armazenamento podem instalar mais opções na App Store',
    'storage_function_config' => 'Configuração da função',
    'storage_function_image_config' => 'Configuração da função de processamento de imagem',
    'storage_function_image_config_desc' => 'Nomes de estilo ou parâmetros avançados podem ser configurados. Teste de compressão de imagem, zoom, marca d\'água, etc., identificador de intervalo comum "é caracteres de meia largura"! "," - "," _ ". Suporte parâmetros avançados e consulte a documentação do desenvolvedor do provedor de serviços de armazenamento',
    'storage_function_video_config' => 'Configuração de função de processamento de vídeo',
    'storage_function_video_config_desc' => 'Você pode configurar o ID do modelo. Para detalhes, consulte a descrição do plugin associado',
    'storage_function_audio_config' => 'Configuração de função de processamento de áudio',
    'storage_function_audio_config_desc' => 'Você pode configurar o ID do modelo. Para detalhes, consulte a descrição do plugin associado',
    'storage_function_document_config' => 'Configuração de visualização online',
    'storage_function_substitution_config' => 'Mapa de substituição de estado inválido',
    'storage_function_substitution_config_desc' => 'Quando o status do arquivo de recurso é "inválido", o mapa de indicação ilegítima é usado',
    'storage_function_substitution_image' => 'Imagem inválida da imagem',
    'storage_function_substitution_video' => 'Dica de vídeo inválida',
    'storage_function_substitution_audio' => 'Dica inválida de áudio',
    'storage_function_substitution_document' => 'Mapa de prompt inválido do documento',
    'storage_service_provider' => 'Provedor de serviços de armazenamento',
    'storage_filesystem_disk' => 'Disco do Sistema de Ficheiros',
    'storage_file_access_domain' => 'Domínio de acesso',
    'storage_extension_names' => 'Extensão suportada',
    'storage_max_size' => 'Tamanho máximo suportado',
    'storage_max_duration' => 'Tempo máximo suportado',
    'storage_temporary_url_status' => 'URL temporário',
    'storage_temporary_url_status_desc' => 'Se o plugin não suportar a função URL temporário, não abra, caso contrário o recurso não estará acessível',
    'storage_temporary_url_key' => 'Chave do URL temporário',
    'storage_temporary_url_expiration' => 'Expiração do URL temporário',
    'storage_image_handle_position' => 'Posição do cabo da imagem',
    'storage_image_thumb_config' => 'Mapa de configuração',
    'storage_image_thumb_avatar' => 'Avatar',
    'storage_image_thumb_ratio' => 'Miniatura isométrica',
    'storage_image_thumb_square' => 'Miniatura quadrada',
    'storage_image_thumb_big' => 'Mapa Comprimido original',
    'storage_video_transcode_parameter' => 'Parâmetros de transcodificação de vídeo',
    'storage_video_watermark' => 'Parâmetros de marca d\'água de vídeo',
    'storage_video_screenshot' => 'Parâmetros de tela de vídeo',
    'storage_video_gift' => 'Parâmetros do diagrama de rotação de vídeo',
    'storage_video_poster_parameter' => 'Parâmetro do Poster',
    'storage_video_transcode_handle_position' => 'Transcodificação de vídeo Posição de processamento de parâmetros',
    'storage_video_poster_handle_position' => 'Posição de processamento de parâmetros de cartazes',
    'storage_audio_transcode_parameter' => 'Parâmetros de transcodificação de áudio',
    'storage_audio_transcode_handle_position' => 'Transcodificador de áudio Posição de processamento de parâmetros',
    'storage_document_preview_service' => 'Serviço de pré-visualização de documentos',
    'storage_document_preview_extension_names' => 'Extensão de pré-visualização de suporte',
    // Operating-User
    'user_name' => 'Nome personalizado de identidade',
    'user_name_desc' => 'Por exemplo, "usuário", "membro", "Comissário" e outros nomeados',
    'user_uid_name' => 'Id personalizado',
    'user_uid_name_desc' => 'Por exemplo, "uid", "id", "número de membro" e outros nomeados',
    'user_username_name' => 'Nome do usuário Nome personalizado',
    'user_username_name_desc' => 'Por exemplo, "nome de usuário", "nome do membro", "conta" e outro nomeado',
    'user_nickname_name' => 'Nome personalizado do apelido',
    'user_nickname_name_desc' => 'Por exemplo, "apelido", "nome da flor", "código" e outro nomeado',
    'user_role_name' => 'Nome personalizado do papel',
    'user_role_name_desc' => 'Por exemplo, "função", "grupo de usuários", "grupo de usuários" e outros nomeados',
    'user_bio_name' => 'Nome Bio Personalizado',
    'user_bio_name_desc' => 'Exemplo: Bio ou Introdução',
    'user_default_role' => 'Função do usuário padrão',
    'user_default_role_desc' => 'Papel de usuário padrão após o registro',
    'user_default_avatar' => 'Avatar do usuário padrão',
    'user_default_avatar_desc' => 'O diagrama de avatar padrão quando o usuário não define o avatar',
    'user_default_anonymous_avatar' => 'Avatar do usuário anônimo',
    'user_default_anonymous_avatar_desc' => 'Conteúdo publicado diagrama de avatar anônimo',
    'user_default_deactivate_avatar' => 'Avatar do usuário',
    'user_default_deactivate_avatar_desc' => 'Imagem de Avatar após o logout do usuário ou desativação',
    'user_identifier' => 'Identificador do utilizador',
    'user_identifier_desc' => 'Que marcação é dominante na interacção do utilizador',
    'user_uid_digit' => 'Dígito inicial do UID do utilizador',
    'user_uid_digit_desc' => 'Número de dígitos gerados aleatoriamente durante o registo',
    'user_profile_desc' => 'Lista de conteúdos por defeito quando se visita a página inicial de um utilizador',
    'user_ban_names' => 'Nomes de banimento',
    'user_ban_names_desc' => 'Um nome por linha. A utilização destes nomes de utilizador e alcunhas é proibida.',
    'user_edit_username_length' => 'Comprimento do nome de usuário',
    'user_edit_username_length_min' => 'Comprimento mínimo',
    'user_edit_username_length_max' => 'O comprimento máximo',
    'user_edit_username_length_desc' => 'Comprimento mínimo do nome de usuário e comprimento máximo',
    'user_edit_username_periodicity' => 'Número do Intervalo de Modificação de Nome de Usuário',
    'user_edit_nickname_length' => 'Comprimento do Apelido',
    'user_edit_nickname_periodicity' => 'Número do intervalo de modificação do apelido do usuário',
    'user_edit_nickname_unique' => 'Apelido Único',
    'user_edit_bio_length' => 'Comprimento Bio',
    'user_edit_bio_support' => 'Apoio Bio',
    'user_bio_support_mention' => 'Mencionar Utilizador',
    'user_bio_support_link' => 'Ligação',
    'user_bio_support_hashtag' => 'Hashtag',
    'user_extcredits_config' => 'Extcredits Configuração',
    'user_extcredits_name' => 'Extcredits Nome',
    'user_extcredits_unit' => 'Nome da unidade',
    'user_extcredits_state_not_enabled' => 'Não activado',
    'user_extcredits_state_private' => 'Privado',
    'user_extcredits_state_public' => 'Público',
    'user_conversation_status' => 'Sessão de carta privada',
    'user_conversation_status_desc' => 'Fechar é válido para todos os membros, e está sujeito aos direitos de função do usuário após a abertura',
    'user_conversation_files' => 'Função acessória de sessão',
    'user_conversation_files_desc' => 'Se tudo não verificar, o representante suporta apenas a conversa do texto puro',
    // Operating-User-Profile
    'profile_posts' => 'Suas publicações',
    'profile_comments' => 'Seus comentários',
    'profile_likers' => 'Usuários que gostaram deles',
    'profile_dislikers' => 'Usuários que não gostaram deles',
    'profile_followers' => 'Usuários que os seguiram',
    'profile_blockers' => 'Usuários que os bloquearam',
    'profile_followers_you_follow' => 'Seguidores que você conhece',
    'profile_likes_users' => 'Eles gostam dos usuários',
    'profile_likes_groups' => 'Eles gostam dos grupos',
    'profile_likes_hashtags' => 'Eles gostam das hashtags',
    'profile_likes_geotags' => 'Eles gostam dos geotags',
    'profile_likes_posts' => 'Eles gostam das publicações',
    'profile_likes_comments' => 'Eles gostam dos comentários',
    'profile_dislikes_users' => 'Eles não gostam dos usuários',
    'profile_dislikes_groups' => 'Eles não gostam dos grupos',
    'profile_dislikes_hashtags' => 'Eles não gostam das hashtags',
    'profile_dislikes_geotags' => 'Eles não gostam dos geotags',
    'profile_dislikes_posts' => 'Eles não gostam das publicações',
    'profile_dislikes_comments' => 'Eles não gostam dos comentários',
    'profile_following_users' => 'Eles seguem os usuários',
    'profile_following_groups' => 'Eles seguem os grupos',
    'profile_following_hashtags' => 'Eles seguem as hashtags',
    'profile_following_geotags' => 'Eles seguem os geotags',
    'profile_following_posts' => 'Eles seguem as publicações',
    'profile_following_comments' => 'Eles seguem os comentários',
    'profile_blocking_users' => 'Eles bloqueiam os usuários',
    'profile_blocking_groups' => 'Eles bloqueiam os grupos',
    'profile_blocking_hashtags' => 'Eles bloqueiam as hashtags',
    'profile_blocking_geotags' => 'Eles bloqueiam os geotags',
    'profile_blocking_posts' => 'Eles bloqueiam as publicações',
    'profile_blocking_comments' => 'Eles bloqueiam os comentários',
    // Operating-Content
    'content_group_name' => 'Nome personalizado do grupo',
    'content_group_name_desc' => 'Por exemplo, "Edition", "Circle", "Classificação" e outros nomeados',
    'content_hashtag_name' => 'Nome personalizado do tópico',
    'content_hashtag_name_desc' => 'Por exemplo, "super como", "tag", "tópicos", etc',
    'content_post_name' => 'Postar o nome do conteúdo',
    'content_post_name_desc' => 'Por exemplo, "post", "dinâmica", "conversa", etc',
    'content_comment_name' => 'Nome do Conteúdo do comentário',
    'content_comment_name_desc' => 'Por exemplo, "Comentários", "Responder", "Interaction" e outros nomeados',
    'content_publish_post_name' => 'Postar um nome de comportamento pós',
    'content_publish_post_name_desc' => 'Por exemplo, "publicado", "submissão", "feedback" e outros nomeados',
    'content_publish_comment_name' => 'Postar um nome de comportamento de comentários',
    'content_publish_comment_name_desc' => 'Por exemplo, "Responder", "Responder", "Siga post" e outros nomeados',
    'content_mention_status' => 'Menção Estado',
    'content_mention_number' => 'Número de menções',
    'content_mention_number_desc' => 'O número de menções de utilizadores por conteúdo, 0 significa que não há limites.',
    'content_hashtag_status' => 'Estado do Hashtag',
    'content_hashtag_format' => 'Formato Hashtag',
    'content_hashtag_format_1' => 'Único #',
    'content_hashtag_format_2' => 'Duplo #',
    'content_hashtag_format_desc' => '<a href="#">#tópico</a> e <a href="#">#tópico#</a>',
    'content_hashtag_length' => 'Comprimento do Hashtag',
    'content_hashtag_number' => 'Número de Hashtag',
    'content_hashtag_number_desc' => 'O número de hashtags suportadas por conteúdo, 0 significa que não há limite.',
    'content_hashtag_regexp' => 'Hashtag Expressão regular',
    'content_nearby_length' => 'Intervalo predefinido de pesquisa próximo',
    'content_nearby_length_desc' => 'Âmbito da pesquisa ao visualizar conteúdos próximos',
    'content_post_brief_length' => 'Post abstrato',
    'content_post_brief_length_desc' => 'O post excede esse valor definido adotará um resumo, o número de palavras de resumo de conteúdo superdimensionadas',
    'content_comment_brief_length' => 'Resumo do comentário',
    'content_comment_brief_length_desc' => 'Comentário antes que o valor definido adote um resumo, supervisione o resumo de conteúdo de comprimento',
    'content_comment_visibility_rule' => 'Comentar as regras de visibilidade',
    'content_comment_visibility_rule_desc' => 'Os comentários serão ocultados se o post tiver sido publicado por mais de alguns dias, 0 significa não activado',
    'content_preview_post_like_users' => 'Pré-visualização dos utilizadores que gostaram de um post',
    'content_preview_post_like_users_desc' => 'Pré-visualização dos utilizadores que tenham gostado do post, o número representa o número de pré-visualizações.',
    'content_preview_post_comments' => 'Pré-visualização dos comentários do post',
    'content_preview_post_comments_desc' => 'Pré-visualização dos comentários na página da lista de correio, o número representa o número de comentários previstos.',
    'content_preview_post_comment_require' => 'Condições de pré-visualização dos comentários',
    'content_preview_post_comment_require_desc' => 'Contar o número de comentários antes de a pré-visualização ser emitida',
    'content_preview_comment_like_users' => 'Pré-visualização de comentários como utilizador',
    'content_preview_comment_replies' => 'Pré-visualização das respostas aos comentários',
    'content_post_edit_config' => 'Permissões de edição de posts',
    'content_post_delete_config' => 'Permissões de eliminação de posts',
    'content_comment_edit_config' => 'Permissões de edição de comentários',
    'content_comment_delete_config' => 'Permissões de eliminação de comentários',
    'content_edit_desc' => 'Posso editar depois de publicar?',
    'content_delete_desc' => 'Posso apagar depois de publicar?',
    // Operating-Interaction
    'interaction_function_status' => 'Estado da função',
    'interaction_operation_name' => 'Nome da operação',
    'interaction_user_title' => 'Título do utilizador',
    'interaction_public_record' => 'Registo Público',
    'interaction_public_count' => 'Contagem pública',
    'interaction_column_name' => 'Nome da coluna',
    // Operating-Sticker
    'sticker_group' => 'Grupo de expressão',
    'sticker_table_group_name' => 'Nome do grupo de emoção',
    'sticker_table_group_image' => 'Ícone do grupo de emoção',
    'sticker_table_group_code' => 'Logotipo do grupo de emoção',
    'sticker_table_quantity' => 'Número de expressões',
    'sticker_manage' => 'Gerenciamento de expressão',
    'sticker_table_image' => 'Gráfico de expressão',
    'sticker_table_code' => 'Emoticons',
    // Operating-Editor
    'editor_group' => 'grupo',
    'editor_title' => 'título',
    'editor_sticker' => 'expressão',
    'editor_image' => 'foto',
    'editor_video' => 'vídeo',
    'editor_audio' => 'Áudio',
    'editor_document' => 'Documentação',
    'editor_mention' => 'Aite',
    'editor_hashtag' => 'tema',
    'editor_extend' => 'extensões',
    'editor_location' => 'posição',
    'editor_anonymous' => 'anônimo',
    'editor_upload_image_type' => 'Formulário de Upload de Imagem',
    'editor_upload_video_type' => 'Formulário de Carregamento de Vídeo',
    'editor_upload_audio_type' => 'Formulário de Audio Upload',
    'editor_upload_document_type' => 'Formulário de Carregamento de Documentos',
    'editor_upload_image_number' => 'Número máximo de imagens carregadas',
    'editor_upload_video_number' => 'Número máximo de vídeos carregados',
    'editor_upload_audio_number' => 'Número máximo de upload de áudio',
    'editor_upload_document_number' => 'Número máximo de upload de documento',
    // Operating-Publish
    'publish_editor_config' => 'Seleção do Editor',
    'publish_editor_function_status' => 'Função do editor',
    'publish_editor_function_options' => 'Configuração da função do editor',
    'publish_post_verify_config' => 'Postar uma solicitação de postagem',
    'publish_comment_verify_config' => 'Postar um pedido de comentário',
    'publish_post_rules_config' => 'Postar uma regra especial',
    'publish_comment_rules_config' => 'Publicar uma regra especial de revisão',
    'publish_editor_desc' => 'Editor publicado',
    'publish_verify_desc' => 'As contas devem ser completadas com as informações seleccionadas para serem publicadas',
    'publish_rules_desc' => 'Todos os funcionários são válidos, a prioridade é maior que as regras de papel',
    'publish_rule_type' => 'Tipo de regra',
    'publish_rule_datetime' => 'Revendedor de datas',
    'publish_rule_time' => 'Limite de tempo',
    'publish_rule_timezone' => 'Fuso horário padrão',
    'publish_rule_rule' => 'Requisitos de regra',
    'publish_rule_tip' => 'Prompt de regra',
    'publish_edit_time_limit' => 'Quanto tempo você pode editar?',
    'publish_edit_sticky_limit' => 'Depois do Sticky',
    'publish_edit_digest_limit' => 'Depois do Digest',
    'publish_editor_group_required' => 'Se o grupo é necessário',
    'publish_editor_group_required_desc' => 'Ao postar posts, você tem que escolher',
    'publish_editor_title_input_box' => 'Exibição da caixa de entrada do título',
    'publish_editor_title_input_box_desc' => 'Display fraco requer que o usuário selecione manualmente a caixa de entrada do título',
    'publish_editor_title_required' => 'Se o título deve ser preenchido',
    'publish_editor_title_required_desc' => 'Ao postar postar, o título deve ser preenchido',
    'publish_editor_title_length' => 'Limite de palavra de título',
    'publish_editor_title_length_desc' => 'O número de títulos não deve exceder o número de configurações, o limite máximo de limite superior 255',
    'publish_editor_post_content_length' => 'Postar limite de palavras',
    'publish_editor_post_content_length_desc' => 'O número de postagens não excederá o número de configurações, limite superior mínimo de 140 caracteres',
    'publish_editor_comment_content_length' => 'Limite de palavras de comentários',
    'publish_editor_comment_content_length_desc' => 'O número de comentários não deve exceder o número de configurações, limite máximo de limite superior 140',
    // Operating-Permission
    'permission_option_email' => 'Email requerido',
    'permission_option_phone' => 'Telefone necessário',
    'permission_option_kyc' => 'KYC Necessário',
    'permission_option_rule_datetime' => 'Eficaz dentro do intervalo de datas especificado',
    'permission_option_rule_time' => 'Especifique um ciclo de tempo dentro do período de tempo especificado',
    'permission_option_review_publish' => 'Pode ser publicado, mas precisa rever',
    'permission_option_close_publish' => 'Proibir a publicação',
    'permission_option_can_be_edited' => 'Pode ser editado',
    'permission_option_cannot_be_edited' => 'Não pode ser editado',
    'permission_option_can_be_deleted' => 'Pode ser apagado',
    'permission_option_cannot_be_deleted' => 'Não pode ser apagado',
    'permission_option_direct_release' => 'Passar diretamente',
    'permission_option_required_review' => 'Precisa rever',
    'permission_option_title_optional_display' => 'Exibição fraca',
    'permission_option_title_direct_display' => 'Display forte',
    // Operating-Roles
    'role_table_display' => 'Exibir logotipo',
    'role_table_nickname_color' => 'Cor do apelido',
    'role_option_display_icon' => 'Ícone de exibição',
    'role_option_display_text' => 'Texto',
    'role_option_close_nickname_color' => 'Não use cores',
    'role_current' => 'Função atual',
    'role_target' => 'Função alvo',
    'role_target_desc' => 'Depois que a função é excluída, o usuário mescla para o nome da função de destino selecionado sob a função',
    'role_perm_basic_config' => 'Configurações básicas',
    'role_perm_post_config' => 'Postar uma configuração de postagem',
    'role_perm_comment_config' => 'Postar uma configuração de comentário',
    'role_perm_upload_config' => 'Configuração de upload',
    'role_perm_interaction_config' => 'Definições interactivas',
    'role_perm_customize_config' => 'Configuração personalizada',
    'role_perm_content_view' => 'Procurar permissão',
    'role_perm_conversation' => 'Permissão de sessão',
    'role_perm_content_link_handle' => 'Manuseamento de links para conteúdos publicados',
    'role_perm_content_link_handle_1' => 'Não resolver e mascarar nome de domínio',
    'role_perm_content_link_handle_2' => 'Não-resolvido mas apresentado como texto',
    'role_perm_content_link_handle_3' => 'Análise normal',
    'role_perm_post_publish' => 'Postar uma permissão de postagem',
    'role_perm_post_verify' => 'Postar uma solicitação de postagem',
    'role_perm_post_review' => 'Postar uma regra de postagem',
    'role_perm_post_rules' => 'Postar uma regra especial',
    'role_perm_post_time_interval' => 'Intervalo de tempo posterior',
    'role_perm_post_daily_count' => 'Limite Diário Pós-Diário',
    'role_perm_post_draft_count' => 'Limite do número de Post Draft',
    'role_perm_comment_publish' => 'Publicar privilégios de comentários',
    'role_perm_comment_verify' => 'Postar um pedido de comentário',
    'role_perm_comment_review' => 'Postar uma regra de comentário',
    'role_perm_comment_rules' => 'Publicar uma regra especial de revisão',
    'role_perm_comment_time_interval' => 'Comentário Intervalo de tempo',
    'role_perm_comment_daily_count' => 'Comentário Limite Diário',
    'role_perm_comment_draft_count' => 'Comente o rascunho de limite de número',
    'role_perm_upload_image' => 'Enviar Imagem',
    'role_perm_upload_video' => 'Envio vídeo',
    'role_perm_upload_audio' => 'Carregar áudio',
    'role_perm_upload_document' => 'Upload Documento',
    'role_perm_upload_file_desc' => 'Verificar o representante tem o direito de fazer upload, a caixa de entrada deixa em branco usa a "Configuração de armazenamento" como o parâmetro padrão',
    'role_perm_follow_user_max_count' => 'Seguir a contagem máxima de utilizadores',
    'role_perm_block_user_max_count' => 'Contagem máxima de utilizadores do bloco',
    'role_perm_download_file_count' => 'Baixe o limite superior dentro de 24 horas',
    'role_perm_table_name' => 'Nome da autoridade',
    'role_perm_table_value' => 'Valor de permissão',
    // Operating-Groups
    'group_table_parent_group' => 'Grupo principal',
    'group_table_subgroup' => 'Subgrupo',
    'group_table_privacy' => 'Privacidade',
    'group_table_visibility' => 'Visibilidade',
    'group_table_follow_method' => 'Seguir o método',
    'group_table_recommend' => 'É recomendado?',
    'group_table_admins' => 'Administrador do grupo',
    'group_table_can_publish' => 'Pode publicar',
    'group_table_post_permissions' => 'Permissões de publicação',
    'group_table_comment_permissions' => 'Permissões de comentário',
    'group_table_publish_perm_role' => 'Papel com o direito de publicar',
    'group_table_publish_perm_review' => 'Você precisa de uma auditoria?',
    'group_table_publish_perm_review_desc' => 'Administradores de grupo não são restritos',
    'group_public_desc' => 'Aberto (qualquer um pode ver o post dentro do grupo)',
    'group_private_desc' => 'Não público (somente os membros podem ver os posts dentro do grupo)',
    'group_visible_desc' => 'Pode ser encontrado (qualquer um pode encontrar este grupo)',
    'group_hidden_desc' => 'Não encontre (somente os membros podem encontrar este grupo)',
    'group_publish_option_all' => 'Todos',
    'group_publish_option_members' => 'Apenas pagando apenas o grupo de usuários',
    'group_publish_option_roles' => 'Somente usuários especificados',
    'group_publish_option_admins' => 'Apenas administradores de grupo',
    'group_can_publish_desc' => 'As permissões de publicação de encerramento podem ser utilizadas como uma categorização de grupo',
    'group_current' => 'Grupo atual',
    'group_target' => 'Grupo alvo',
    'group_target_desc' => 'Após a fusão, o grupo antigo será excluído, e o conteúdo do grupo antigo será migrado para o nome da equipe de destino selecionado',
    // Extends
    'extend_editor_menus' => 'Menus',
    'extend_editor_toolbar' => 'Barra de ferramentas',
    'extend_editor_number_of_uses_desc' => 'Exemplos de plugins "votantes", o número é 2, representando um único post, 2 votos podem ser incluídos',
    'extend_content_service' => 'Serviço de Conteúdo',
    'extend_content_list' => 'Lista de conteúdos',
    'extend_content_detail' => 'Detalhes do conteúdo',
    'extend_content_search' => 'Pesquisa de conteúdo',
    'extend_content_list_desc' => 'Esta configuração tem uma prioridade maior do que a configuração do tipo de conteúdo, e quando configurada, a fonte de dados especificada pelo tipo de conteúdo será substituída.',
    'extend_content_ip' => 'Serviço IP',
    'extend_content_map' => 'Serviço de mapas',
    'extend_content_notifications_service' => 'Serviço de Notificação',
    'extend_content_review' => 'Serviço de revisão',
    'extend_content_list_by_all' => 'Todos os Posts ou Comentários',
    'extend_content_list_by_timelines' => 'Cronogramas de mensagens ou comentários',
    'extend_content_list_by_nearby' => 'Mensagens ou comentários próximos',
    'extend_content_by_detail' => 'Pormenor do anúncio ou comentário',
    'extend_content_search_users' => 'Pesquisar Utilizadores',
    'extend_content_search_groups' => 'Grupos de Pesquisa',
    'extend_content_search_hashtags' => 'Pesquisar Hashtags',
    'extend_content_search_geotags' => 'Pesquisar etiquetas geográficas',
    'extend_content_search_posts' => 'Pesquisar Posts',
    'extend_content_search_comments' => 'Pesquisar Comentários',
    // Client-Channels
    'channel_default_homepage' => 'Página inicial predefinida',
    'channel_table_channel' => 'Canal',
    'channel_table_page' => 'Página',
    'channel_table_page_home' => 'Página inicial',
    'channel_table_page_list' => 'Lista',
    'channel_table_page_detail' => 'Detalhes',
    'channel_table_page_interaction' => 'Interação',
    'channel_table_path' => 'Caminho',
    'channel_table_seo' => 'Informação SEO',
    'channel_table_seo_title' => 'Título de SEO',
    'channel_table_seo_description' => 'Descrição de SEO',
    'channel_table_seo_keywords' => 'SEO palavra-chave',
    'channel_table_query_state' => 'Passagem do lado do cliente',
    'channel_table_query_state_desc' => 'Aceitar ou não passes do lado do cliente, quando desligado só serão suportados os valores padrão dos parâmetros',
    'channel_table_query_config' => 'Parâmetros padrão',
    'channel_table_query_config_desc' => 'Consultar os parâmetros da API Query desta interface',
    'channel_query_state_1' => 'Não são aceites parâmetros de clientes',
    'channel_query_state_2' => 'Aceitar apenas parâmetros de paginação de clientes',
    'channel_query_state_3' => 'Aceitar todos os parâmetros',
    // Client-Columns
    'channel_timeline' => 'Linha de tempo',
    'channel_timeline_all_posts' => 'Todas as mensagens seguidas',
    'channel_timeline_user_posts' => 'Eu sigo publicações de utilizadores',
    'channel_timeline_group_posts' => 'Eu sigo publicações de grupos',
    'channel_timeline_hashtag_posts' => 'Eu sigo publicações com hashtags',
    'channel_timeline_geotag_posts' => 'Sigo publicações com geotags',
    'channel_timeline_all_comments' => 'Todos os comentários seguidos',
    'channel_timeline_user_comments' => 'Eu sigo os comentários dos utilizadores',
    'channel_timeline_group_comments' => 'Eu sigo comentários de grupos',
    'channel_timeline_hashtag_comments' => 'Eu sigo comentários de hashtags',
    'channel_timeline_geotag_comments' => 'Eu sigo comentários de geotags',
    'channel_nearby' => 'Perto de mim',
    'channel_nearby_posts' => 'Mensagens por Perto',
    'channel_nearby_comments' => 'Comentários por Nearby',
    'channel_me' => 'Centro pessoal',
    'channel_me_extcredits' => 'Extcredits',
    'channel_me_wallet' => 'Carteira',
    'channel_me_drafts' => 'Rascunhos',
    'channel_me_users' => 'Utilizadores',
    'channel_me_settings' => 'Definições',
    'channel_messages' => 'Mensagens',
    'channel_conversations' => 'Conversas',
    'channel_notifications' => 'Notificações',
    'channel_notifications_all' => 'Notificar-em formação',
    'channel_notifications_systems' => 'Notificar-Sistemas',
    'channel_notifications_recommends' => 'Notificar-Recomenda',
    'channel_notifications_likes' => 'Notificar-Gosta',
    'channel_notifications_dislikes' => 'Notificar-Não gosta',
    'channel_notifications_follows' => 'Notificar-Segue',
    'channel_notifications_blocks' => 'Notificar-Blocos',
    'channel_notifications_mentions' => 'Notificar-Menções',
    'channel_notifications_comments' => 'Notificar-Comentários',
    'channel_notifications_quotes' => 'Notificar-Citação',
    'channel_search' => 'procurar',
    // Client-Keys
    'key_table_read_only' => 'Apenas leitura',
    'key_select_platform' => 'Selecione a plataforma de aplicativos chave',
    'key_option_main_api' => 'API principal',
    'key_option_manage_api' => 'API de gerenciamento',
    'key_option_plugin_api' => 'API do plugin',
    'key_option_plugin_api_select' => 'Selecione qual plugin para uso',
    'key_option_plugin_api_select_desc' => 'Esta chave só pode solicitar a API do plugin associado',
    // Client-Basic
    'website_stat_code' => 'Código Estatístico do Sítio',
    'website_stat_code_desc' => 'A utilização de código estatístico contendo document.write não é suportada.',
    'website_stat_position' => 'Localização do código estatístico',
    'website_stat_position_desc' => 'Onde o código estatístico é carregado no HTML.',
    'china_mode' => 'Modo China',
    'china_mode_desc' => 'Informação necessária quando o servidor do site é implantado na China.',
    'china_mode_config' => 'Configuração do servidor continental da China (campo não requerido)',
    'china_icp_filing' => 'Arquivo de fornecedores de conteúdo da Internet',
    'china_icp_license' => 'Licença de Provedor de Conteúdo de Internet',
    'china_mps_filing' => 'Arquivo do Gabinete de Segurança Pública',
    'china_broadcasting_license' => 'Licença de Radiodifusão',
    // Client-Status
    'client_status_desc' => 'Configuração do estado do pedido do cliente a cada 10 minutos',
    // App-Center-Themes
    'website_engine_config' => 'Configuração do motor',
    'website_engine_api_config' => 'Configuração da API',
    'website_engine_status' => 'Status do Motor',
    'website_engine_api_type' => 'Tipo de motor API',
    'website_engine_key_id' => 'Seleccionar chave de aplicação',
    'website_engine_view_desktop' => 'Computador',
    'website_engine_view_mobile' => 'Celular',
    // App-Center-Install
    'install_website_engine' => 'Instalar o motor do sítio Web',
    'install_plugin' => 'Instalar o plugin',
    'install_application' => 'Instalar a aplicação',
    'install_mode' => 'Modo de instalação',
    'install_mode_fskey' => 'Chave de entrada Fresns',
    'install_mode_upload' => 'Carregar Pacote Zip',
    'install_mode_directory' => 'Caminho do directório de entrada',
    'download_application' => 'Descarregar a aplicação',
];
