<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Panneau de commande Fresns',
    'fresns_core' => 'Fresns noyau',
    // Login page
    'language' => 'Langue',
    'login' => 'Connexion',
    'account' => 'Compte',
    'password' => 'Mot de passe',
    'enter' => 'Entrer',
    'operation' => 'Fonctionnement du panneau',
    'site_home' => 'Accueil du site web',
    'switch_language' => 'Langue du commutateur',
    'logout' => 'Se déconnecter',
    // Header menus
    'menu_dashboard' => 'Tableau de bord',
    'menu_systems' => 'Systèmes',
    'menu_operations' => 'Exploitation',
    'menu_extends' => 'Se développe',
    'menu_clients' => 'Clients',
    'menu_app_center' => 'Centre d\'applications',
    'menu_marketplace' => 'Marché',
    // Sidebar menus
    'sidebar_home' => 'Maison',
    'sidebar_admins' => 'Administrateur',
    'sidebar_events' => 'Événements',
    'sidebar_events_tab_subscribe' => 'S\'abonner à',
    'sidebar_events_tab_crontab' => 'Crontab',
    'sidebar_caches' => 'Caches',
    'sidebar_caches_tab_config' => 'Cache de configuration',
    'sidebar_caches_tab_data' => 'Cache de données',
    'sidebar_upgrades' => 'Mises à niveau',
    'sidebar_settings' => 'Réglages',
    'sidebar_languages' => 'Langues',
    'sidebar_storage' => 'Espace de rangement',
    'sidebar_storage_tab_image' => 'Image',
    'sidebar_storage_tab_video' => 'Vidéo',
    'sidebar_storage_tab_audio' => 'l\'audio',
    'sidebar_storage_tab_document' => 'Document',
    'sidebar_storage_tab_substitution' => 'Substitution',
    'sidebar_general' => 'Général',
    'sidebar_policy' => 'Politique',
    'sidebar_policy_tab_options' => 'Option',
    'sidebar_policy_tab_contents' => 'Contenu',
    'sidebar_send' => 'Envoyer',
    'sidebar_send_tab_services' => 'Envoyer des services',
    'sidebar_send_tab_templates' => 'Vérifier les modèles de code',
    'sidebar_account' => 'Compte',
    'sidebar_wallet' => 'Portefeuille',
    'sidebar_wallet_tab_options' => 'Option',
    'sidebar_wallet_tab_recharge_services' => 'Services de recharge',
    'sidebar_wallet_tab_withdraw_services' => 'Retirer des services',
    'sidebar_user' => 'Utilisateur',
    'sidebar_content' => 'Contenu',
    'sidebar_interaction' => 'Interaction',
    'sidebar_publish' => 'Publier',
    'sidebar_publish_tab_post' => 'Poster',
    'sidebar_publish_tab_comment' => 'Commenter',
    'sidebar_roles' => 'Les rôles',
    'sidebar_stickers' => 'Autocollants',
    'sidebar_groups' => 'Groupes',
    'sidebar_groups_tab_active' => 'actif',
    'sidebar_groups_tab_deactivate' => 'Inactif',
    'sidebar_groups_tab_recommend' => 'Voir recommander seulement',
    'sidebar_extend_editor' => 'Éditeur',
    'sidebar_extend_content_type' => 'Type de contenu',
    'sidebar_extend_content_handler' => 'Gestionnaire de contenu',
    'sidebar_extend_manage' => 'Faire en sorte',
    'sidebar_extend_group' => 'Grouper',
    'sidebar_extend_group_filter' => 'Filtre',
    'sidebar_extend_user_feature' => 'Fonctionnalité utilisateur',
    'sidebar_extend_user_profile' => 'Profil de l\'utilisateur',
    'sidebar_extend_channel' => 'Canal',
    'sidebar_extend_command_words' => 'Mots de commande',
    'sidebar_channels' => 'Canaux',
    'sidebar_paths' => 'Chemin d\'accès',
    'sidebar_language_packs' => 'Packs de langue',
    'sidebar_code_messages' => 'Messages du code',
    'sidebar_client_basic' => 'Base',
    'sidebar_client_status' => 'Statut',
    'sidebar_plugins' => 'Plugins',
    'sidebar_plugins_tab_all' => 'Tous',
    'sidebar_plugins_tab_active' => 'actif',
    'sidebar_plugins_tab_inactive' => 'Inactif',
    'sidebar_themes' => 'Thèmes',
    'sidebar_apps' => 'Applications',
    'sidebar_keys' => 'Clés d\'application',
    // Sidebar intro
    'sidebar_admins_intro' => 'Les utilisateurs qui ont le droit de se connecter au panneau de commande',
    'sidebar_events_intro' => 'Visualiser les tâches programmées et les événements d\'abonnement sur le système',
    'sidebar_caches_intro' => 'L\'effacement de la totalité de la mémoire cache peut augmenter la charge du serveur. Veuillez donc essayer d\'éviter les heures de pointe.',
    'sidebar_upgrades_intro' => 'finalement',
    'sidebar_settings_intro' => 'Veuillez effacer le cache lorsque la configuration est terminée, ou attendre 10 minutes pour que le nouveau cache prenne effet.',
    'sidebar_languages_intro' => 'Multi-linguistique doit configurer des options de langue ici avant de pouvoir entrer un contenu multilingue dans l\'élément de configuration correspondant',
    'sidebar_storage_intro' => 'Quatre fichiers de ressources peuvent être stockés séparément, ou stockés simultanément, il suffit de remplir les informations de configuration de stockage',
    'sidebar_general_intro' => 'Protégez les éléments de réglage du système en cours d\'exécution',
    'sidebar_policy_intro' => 'Selon les réglementations juridiques de données pertinentes sur le pays du marché cible',
    'sidebar_send_intro' => 'Messagerie et autres messages tels que Mail SMS et notifications système',
    'sidebar_account_intro' => 'Paramètres des fonctions du centre de compte',
    'sidebar_wallet_intro' => 'Le portefeuille est une fonctionnalité monétaire réelle, si vous avez besoin d\'une fonction intégrale virtuelle, veuillez installer le plugin approprié',
    'sidebar_wallet_tab_recharge_services_intro' => 'La configuration du fournisseur de services de recharge sera rendue dans la liste de fonctions "Portefeuille" pour les commandes de paiement ou rechargez le portefeuille',
    'sidebar_wallet_tab_withdraw_services_intro' => 'La configuration de fournisseur de services de distribution sera présente dans la liste de fonctions "Portefeuille", utilisée pour l\'équilibre de portefeuille pour encaisser le compte spécifié',
    'sidebar_user_intro' => 'Paramètres de fonction utilisateur utilisateur',
    'sidebar_content_intro' => 'Nom du contenu social et configuration de la fonction',
    'sidebar_interaction_intro' => 'La perception de l\'utilisateur du service d\'un produit (sens de l\'expérience) ne dépend pas de la logique technique, mais du nommage des points de fonction.',
    'sidebar_publish_intro' => 'Cette configuration est valable pour tous les membres et la priorité de priorité est supérieure aux autorisations de rôle d\'utilisateur',
    'sidebar_roles_intro' => 'Le rôle peut définir des paramètres spécifiques pour l\'identité et les autorisations de l\'utilisateur',
    'sidebar_stickers_intro' => 'Configuration personnalisée Emotive, dans le cas de la configuration non configurée, les utilisateurs peuvent également entrer des expressions Emoji via le clavier Emoker',
    'sidebar_groups_intro' => 'Le groupe d\'utilisation peut réaliser divers scénarios d\'exploitation tels que des projets BBS, des cercles communautaires, une classification de contenu',
    'sidebar_extend_editor_intro' => 'Dans "l\'éditeur" du processus de version, par exemple "Vote" l\'extension permet à "l\'éditeur" de prendre en charge la fonction de vote accompagnant le poste',
    'sidebar_extend_content_type_intro' => 'Le message sera présenté dans la page de liste "Post", qui permet de diffuser le message spécifié "Type" et de définir la source de données',
    'sidebar_extend_content_handler_intro' => 'La fonction est la même que la fonction de source de données "Type de contenu", si la demande est distribuée au traitement du plugin et la logique de données est déterminée par le plugin',
    'sidebar_extend_manage_intro' => 'Dans la liste de fonctions "Plus" du poste, le commentaire, la page d\'accueil des utilisateurs, telle que "la plainte", l\'extension permet aux utilisateurs de se plaindre des objectifs correspondants',
    'sidebar_extend_group_intro' => 'La présentation est présentée dans la page d\'accueil "Groupe", telle que "Plugin d\'extension Pure Link" peut afficher un lien hypertexte dans la page d\'accueil "Groupe"',
    'sidebar_extend_user_feature_intro' => 'La page "My" sera présentée dans le "Centre utilisateur", telle que "portefeuille", permet à l\'utilisateur d\'accroître la fonction de portefeuille',
    'sidebar_extend_user_profile_intro' => 'Dans la liste des fonctions de gestion "Informations utilisateur", telles que "Modifier le plugin Nom d\'utilisateur", permet aux informations de modification de la modification du nom d\'utilisateur',
    'sidebar_extend_channel_intro' => 'Il est affiché dans le menu principal ou dans une liste de pages de canaux, par exemple l\'extension Shopping permet à l\'utilisateur d\'accéder au canal Mall.',
    'sidebar_extend_command_words_intro' => 'Les mots de commande configurés dans cette liste sont disponibles pour les requêtes API.',
    'sidebar_channels_intro' => 'Configuration unifiée des informations sur les canaux individuels du client.',
    'sidebar_paths_intro' => 'Les structures de chemin d\'accès personnalisées peuvent améliorer l\'esthétique, la convivialité et la compatibilité avec l\'avenir de vos liens.',
    'sidebar_language_packs_intro' => 'Configurez le contenu multilingue de chaque texte pour les clients multilingues',
    'sidebar_code_messages_intro' => 'Description multilingue des codes d\'état configurés pour le programme principal et les plugins.',
    'sidebar_client_basic_intro' => 'Éléments de configuration générale pour la base du client.',
    'sidebar_client_status_intro' => 'Après la désactivation, toutes les pages et actions du client renvoient à la page des instructions de désactivation.',
    'sidebar_plugins_intro' => 'Caractéristiques flexibles, des extensions puissantes vous aident à jouer librement',
    'sidebar_themes_intro' => 'Sélectionnez différents sujets pour obtenir un style et une interaction plus personnalisés',
    'sidebar_apps_intro' => 'API standard, extensions puissantes, créez à loisir une variété de scénarios opérationnels et de modèles d\'application.',
    'sidebar_keys_intro' => 'Les identifiants clés sont importants, ne les divulguez pas facilement à d\'autres',
    // Page button
    'button_support' => 'Support',
    'button_update' => 'Mise à jour',
    'button_search' => 'Rechercher',
    'button_add' => 'Ajouter',
    'button_edit' => 'Éditer',
    'button_modify' => 'Modifier',
    'button_delete' => 'Supprimer',
    'button_cancel' => 'Annuler',
    'button_close' => 'Fermer',
    'button_dismiss' => 'Rejeter',
    'button_activate' => 'Activer',
    'button_deactivate' => 'Désactiver',
    'button_install' => 'Installer',
    'button_uninstall' => 'Désinstaller',
    'button_setting' => 'Réglage',
    'button_config' => 'Config',
    'button_reset' => 'Réinitialiser',
    'button_confirm' => 'Confirmer',
    'button_try_again' => 'Recommencer',
    'button_save' => 'sauvegarder',
    'button_download' => 'Télécharger',
    'button_upgrade' => 'Mise à jour',
    'button_automatic_upgrade' => 'Mise à jour automatique',
    'button_manual_upgrade' => 'Mise à niveau manuelle',
    'button_confirm_delete' => 'Confirmation de la suppression',
    'button_confirm_install' => 'Confirmer l\'installation',
    'button_confirm_upgrade' => 'Confirmer la mise à niveau',
    'button_confirm_download' => 'Confirmer le téléchargement',
    'button_confirm_uninstall' => 'Confirmer la désinstallation',
    'button_view' => 'Voir',
    'button_image_upload' => 'Télécharger',
    'button_image_input' => 'Contribution',
    'button_check_upgrade' => 'Vérifier la mise à niveau',
    'button_check_status' => 'Vérifier l\'état',
    'button_batch_import' => 'Importer',
    'button_batch_export' => 'Exportation',
    'button_config_email_template' => 'Modèle de messagerie de configuration',
    'button_config_sms_template' => 'Modèle de configuration SMS',
    'button_config_sticker' => 'Autocollant de configuration',
    'button_config_permission' => 'Permission de configuration',
    'button_config_language_pack' => 'Pack de configuration',
    'button_add_admin' => 'Ajouter admin',
    'button_add_language' => 'Ajouter Lang',
    'button_add_account_connect' => 'Ajouter un compte Connect',
    'button_add_service_provider' => 'Ajouter un service',
    'button_add_sticker_group' => 'Ajouter un groupe d\'autocollants',
    'button_add_sticker' => 'Ajouter un autocollant',
    'button_add_role' => 'Faire un rôle supplémentaire',
    'button_add_group' => 'Ajouter un groupe',
    'button_group_move' => 'Bouge toi',
    'button_add_key' => 'Touche Ajouter une clé',
    'button_reset_key' => 'Réinitialiser la clé',
    'button_reset_secret' => 'Réinitialiser le secret',
    'button_clear_cache' => 'effacer le cache',
    'button_clear_all_cache' => 'Effacer tout le cache',
    // Page table
    'table_order' => 'Ordre de tri',
    'table_recommend_order' => 'Recommander l\'ordre de tri',
    'table_position' => 'Position',
    'table_number' => 'Nombre',
    'table_lang_tag' => 'Tag Lang',
    'table_lang_name' => 'Nom de Lang',
    'table_title' => 'Titre',
    'table_content' => 'Contenu',
    'table_platform' => 'Plate-forme',
    'table_service' => 'Service',
    'table_app_id' => 'ID de l\'application',
    'table_app_key' => 'Clé d\'application',
    'table_app_secret' => 'Secret secret',
    'table_plugin' => 'Brancher',
    'table_command_word' => 'Mot de commande',
    'table_name' => 'Nom',
    'table_description' => 'La description',
    'table_icon' => 'Icône',
    'table_banner' => 'Bannière',
    'table_type' => 'Taper',
    'table_use' => 'Utiliser',
    'table_support' => 'Support',
    'table_data_source' => 'La source de données',
    'table_scene' => 'Scène',
    'table_number_of_uses' => 'Nombre d\'utilisations',
    'table_scope' => 'Portée',
    'table_scope_global' => 'Global',
    'table_scope_global_desc' => 'Peut être limité aux rôles spécifiés',
    'table_scope_group_admins' => 'Administrations de groupe',
    'table_scope_group_admins_desc' => 'Lorsqu\'il est activé, seuls les administrateurs de groupe montreront le plugin',
    'table_authorized_roles' => 'Rôles autorisés',
    'table_authorized_roles_desc' => 'Laisser vide pour indiquer que tous les rôles d\'utilisateur sont habilités à utiliser',
    'table_whitelist_rules' => 'Rôle de liste blanche',
    'table_parameter' => 'Paramètre',
    'table_status' => 'Statut',
    'table_options' => 'Option',
    // Config option
    'option_default' => 'Défaut',
    'option_all' => 'Tous',
    'option_public' => 'Public',
    'option_private' => 'Privé',
    'option_visible' => 'Visible',
    'option_hidden' => 'Caché',
    'option_open' => 'Ouvrir',
    'option_close' => 'Fermer',
    'option_yes' => 'Oui',
    'option_no' => 'Non',
    'option_activate' => 'Activer',
    'option_deactivate' => 'Désactiver',
    'option_local' => 'Local',
    'option_remote' => 'A distance',
    'option_required' => 'Obligatoire',
    'option_not_required' => 'Non requis',
    'option_not_set' => 'Non défini',
    'option_no_use' => 'Pas d\'utilisation',
    'option_unselect' => 'Désélectionner',
    'option_optional' => 'Optionnel',
    'option_email' => 'E-mail',
    'option_sms' => 'SMS',
    'option_data_close' => 'Non public',
    'option_data_private' => 'Privé',
    'option_data_public' => 'Public',
    'option_type_tree' => 'Arbre',
    'option_type_list' => 'Liste',
    'option_uninstall_plugin_data' => 'Suppression simultanée des données du plugin',
    'option_uninstall_theme_data' => 'Suppression simultanée des données de thème',
    // Commons
    'portal' => 'Portail',
    'user' => 'Utilisateur',
    'group' => 'Grouper',
    'hashtag' => 'Hashtag',
    'geotag' => 'Géotag',
    'post' => 'Poster',
    'comment' => 'Commenter',
    'file' => 'Fichier',
    'extend' => 'Étendre le contenu',
    'user_detail' => 'Accueil utilisateur',
    'group_detail' => 'Détail du groupe',
    'hashtag_detail' => 'Détail Hashtag',
    'geotag_detail' => 'Détail de la géolocalisation',
    'post_detail' => 'Détail du message',
    'comment_detail' => 'Détail du commentaire',
    'like' => 'J\'aime',
    'dislike' => 'N\'aime pas',
    'follow' => 'Suivre',
    'block' => 'Bloquer',
    'author' => 'Auteur',
    'new_version' => 'Nouvelle',
    'default_language' => 'Langage par défaut',
    'default_list' => 'Liste par défaut',
    'recommend' => 'Recommander',
    'unit_day' => 'Jour',
    'unit_length' => 'Longueur',
    'unit_second' => 'Seconde',
    'unit_minute' => 'Minute',
    'unit_within_minute' => 'En minutes',
    'unit_character' => 'Personnage',
    'unit_number' => 'Numéro',
    'unit_number_of_times' => 'Nombre de fois',
    'unit_kilometer' => 'Kilomètre',
    'unit_mile' => 'Mile',
    'config_default' => 'Config par défaut',
    'config_name' => 'Nom Config',
    'config_edit' => 'Edit Config',
    'config_interaction' => 'Config Interaction',
    'config_conversation' => 'Configuration de la conversation',
    'config_hashtag' => 'Config Hashtag',
    'config_list' => 'Config Liste',
    'config_preview' => 'Configuration de la prévisualisation',
    'config_manage' => 'Config Gérer',
    'delete_desc' => 'Assurez-vous de supprimer?',
    // Dashboard-Home
    'welcome' => 'Bienvenue à Fresns',
    'current_version' => 'La version actuelle utilisée est',
    'overview' => 'Données du site',
    'overview_accounts' => 'Comptes',
    'overview_users' => 'Utilisateurs',
    'overview_groups' => 'Groupes',
    'overview_hashtags' => 'Hashtags',
    'overview_geotags' => 'Géotags',
    'overview_posts' => 'Messages',
    'overview_comments' => 'Commentaires',
    'extensions' => 'Quantité d\'application',
    'support' => 'Manuel d\'aide',
    'support_website' => 'Site officiel Fresns',
    'support_teams' => 'Équipe Open Source',
    'support_sponsor' => 'Sponsor',
    'support_join' => 'Rejoignez-nous',
    'support_community' => 'Communauté de soutien',
    'support_marketplace' => 'Marché des applications',
    'system_info' => 'Message système',
    'system_info_server' => 'Système de serveur',
    'system_info_web' => 'Environnement de fonctionnement Web',
    'system_info_php_version' => 'PHP version',
    'system_info_php_cli_info' => 'PHP Cli info',
    'system_info_php_upload_max_filesize' => 'Télécharger la taille maximale du fichier',
    'system_info_composer_info' => 'Composer info',
    'system_info_composer_version' => 'Composer version',
    'system_info_env_timezone' => '.env zona waktu',
    'system_info_env_timezone_name' => '.env Identifiant du fuseau horaire',
    'system_info_env_timezone_utc' => '.env Fuseau horaire UTC de l\'identifiant de fuseau horaire',
    'system_info_env_timezone_list' => 'Identificateur de fuseau horaire correspondant',
    'system_info_database_driver' => 'Pilote de base de données',
    'system_info_database_version' => 'Version de la base de données',
    'system_info_database_timezone' => 'Fuseau horaire de la base de données',
    'system_info_database_engine' => 'Moteur de stockage de données',
    'system_info_database_collation' => 'Règles de tri de la base de données',
    'system_info_database_size' => 'Taille de la base de données actuelle',
    'tips' => 'Mode d\'emploi',
    'news' => 'Fresns Activités et nouvelles',
    // Dashboard-Events
    'event_subscribe_subject' => 'Sujet',
    'event_crontab_time' => 'Cycle d\'exécution',
    'event_crontab_time_desc' => 'Format du tableau cron de planification des tâches de Laravel',
    // Dashboard-Caches
    'cache' => 'Cache',
    'cache_fresns_system' => 'Configuration du système',
    'cache_fresns_config' => 'Site Config',
    'cache_fresns_extend' => 'Étendre la configuration',
    'cache_fresns_view' => 'Afficher',
    'cache_fresns_route' => 'Route',
    'cache_fresns_event' => 'Événement',
    'cache_fresns_schedule' => 'Programme',
    'cache_fresns_temporary' => 'Données temporaires',
    // Dashboard-Admins
    'admin_add_title' => 'Nouvel administrateur système',
    'admin_add_form_account' => 'Compte',
    'admin_add_form_account_placeholder' => 'Numéro de courrier électronique ou mobile',
    'admin_add_form_account_desc' => 'Le numéro de téléphone mobile doit être un numéro complet avec l\'indicatif régional international',
    'admin_add_form_account_btn' => 'Recherche et augmentation',
    // Dashboard-Settings
    'setting_developer_options' => 'Options pour les développeurs',
    'setting_developer_options_desc' => 'Ne désactivez pas les options s\'il ne s\'agit pas d\'un environnement de développement.',
    'setting_build_type' => 'Version Type',
    'setting_build_type_desc' => 'La version bêta est moins stable, veuillez donc choisir avec soin.',
    'setting_build_select_tip' => 'Sélectionnez le type de version de mise à niveau',
    'setting_build_option_stable' => 'Stable Build',
    'setting_build_option_beta' => 'Bêta Build',
    'setting_system_url' => 'URL du système',
    'setting_system_url_desc' => 'Adresses d\'accès par défaut pour l\'API principale et les plugins',
    'setting_panel_path' => 'Entrée en sécurité',
    'setting_panel_path_desc' => 'Après réglage, vous ne pouvez vous connecter que sur le panneau de commande en spécifiant l\'entrée de sécurité',
    'setting_panel_url' => 'Adresse complète d\'entrée',
    'setting_panel_url_desc' => 'Panneau de configuration Entrée de connexion URL complète',
    'setting_panel_url_copy' => 'copie',
    // System-Languages
    'language_multilingual' => 'multilingue',
    'language_table_default' => 'langage par défaut',
    'language_table_langCode' => 'Code de langue',
    'language_table_areaCode' => 'Codes de zone',
    'language_table_langName' => 'Nom de la langue',
    'language_table_areaName' => 'Nom de la région',
    'language_table_lengthUnit' => 'Unité de longueur',
    'language_table_writingDirection' => 'Direction de l\'écriture',
    'language_table_area' => 'Zone linguistique',
    'language_table_dateFormat' => 'Format de date',
    'language_table_dateFormat_desc' => 'Yyyy a dit année, a dit MM le mois, DD signifie le ciel',
    'language_table_timeFormat' => 'Temps humain',
    'language_table_timeFormat_desc' => 'Nom de la variable de temps {n}',
    'language_select_langCode' => 'Sélectionner le code de langue',
    'language_select_continent' => 'Continent',
    'language_select_areaCode' => 'Sélectionnez Code régional',
    // System-General
    'site_url' => 'URL du site',
    'site_url_desc' => 'URL d\'accès au site principal',
    'site_name' => 'Nom du site',
    'site_name_desc' => 'Le nom de votre site Fresns',
    'site_intro' => 'Introduction du site',
    'site_intro_desc' => 'Introduction à votre site Fresns',
    'site_logo' => 'Signe de site',
    'site_logo_desc' => 'Les informations dans "Paramètres de stockage" doivent être configurées pour télécharger l\'image',
    'site_copyright' => 'Informations sur le droit d\'auteur',
    'site_email' => 'Boîte aux lettres administratrice',
    'site_email_desc' => 'Lorsque vous exécutez une erreur, indiquez l\'utilisateur pour faciliter les commentaires de l\'utilisateur',
    'site_mode' => 'Mode de fonctionnement',
    'site_mode_public' => 'Mode de publication',
    'site_mode_private' => 'Mode privé',
    'site_mode_private_desc' => 'Configuration du mode privé',
    'site_mode_private_join_status' => 'Est-il ouvert à l\'extérieur?',
    'site_mode_private_join_service' => 'Rejoignez le plugin de support de canal',
    'site_mode_private_content_policy' => 'Etat privé expiré',
    'site_mode_private_content_policy_1' => 'Le contenu du site n\'est pas visible',
    'site_mode_private_content_policy_2' => 'Contenu avant l\'expiration, le nouveau contenu est invisible',
    // System-Policy
    'policy_terms' => 'Conditions d\'utilisation',
    'policy_privacy' => 'politique de confidentialité',
    'policy_cookie' => 'Politique de cookie',
    'policy_delete_account' => 'Instructions de déconnexion',
    'policy_delete_options' => 'Fonction de déconnexion',
    'policy_delete_options_desc' => 'l\'utilisateur peut révoquer la déconnexion (compte de récupération) dans la journée du tampon et le processus d\'annulation sera exécuté sans défaut',
    'policy_delete_option_1' => 'Ne pas activer la fonction de déconnexion',
    'policy_delete_option_2' => 'Connexion logique',
    'policy_delete_option_2_desc' => 'Déconnexion logique: uniquement dans la base de données est notifiée dans la base de données, il n\'est pas vrai de supprimer les données',
    'policy_delete_option_3' => 'Annulation physique',
    'policy_delete_option_3_desc' => 'Décornement physique: Les données de suppression physique, les données utilisateur et le contenu publié seront vraiment supprimés',
    'policy_delete_crontab' => 'Cycle de déconnexion',
    // System-Send
    'send_email_config' => 'Configuration de la boîte aux lettres',
    'send_sms_config' => 'Configuration SMS',
    'send_sms_default_code' => 'Code régional international par défaut',
    'send_sms_supported_codes' => 'Soutenir plus d\'indicatif régional',
    'send_sms_desc' => 'Une ligne, Le représentant vide ne prend en charge qu\'un seul pays. Veuillez confirmer que le fournisseur de service prend en charge la fonction SMS internationale avant la configuration',
    'send_app_notifications' => 'Service de notification push',
    'send_app_ios_config' => 'Configuration iOS',
    'send_app_ios_notifications_desc' => 'Fonction de notification contextuelle du système iOS',
    'send_app_android_config' => 'Configuration Android',
    'send_app_android_notifications_desc' => 'Fonction de notification contextuelle du système Android',
    'send_app_desktop_config' => 'Configuration du bureau',
    'send_app_desktop_notifications_desc' => 'Fonctionnalités de notification du bureau, telles que les notifications du navigateur.',
    'send_code_template_1' => 'Code de vérification générale',
    'send_code_template_2' => 'Enregistrer un nouveau compte',
    'send_code_template_3' => 'Modifier les informations de compte',
    'send_code_template_4' => 'Remplacer la nouvelle liaison',
    'send_code_template_5' => 'Réinitialiser le mot de passe de connexion',
    'send_code_template_6' => 'Réinitialiser le mot de passe de paiement',
    'send_code_template_7' => 'Connectez-vous avec un code de vérification',
    'send_code_template_8' => 'Supprimer le compte en utilisant le code de vérification',
    'send_code_template_table_email_desc' => 'Supporte le format HTMl',
    'send_code_template_table_sms_sign' => 'Nom SMS Signature',
    'send_code_template_table_sms_code' => 'Paramètres de modèle',
    'send_code_template_table_sms_code_desc' => 'Vous pouvez configurer l\'ID de modèle. Pour plus de détails, veuillez vous reporter à la description du plugin associé',
    'send_code_template_table_sms_param' => 'Nom de la variable de code de vérification',
    // System-Account
    'account_center_config' => 'Centre de compte Config',
    'account_child_safety' => 'Sécurité des enfants',
    'account_age_verification' => 'Vérification de l\'âge',
    'account_age_min_required' => 'Âge minimum requis',
    'account_register_config' => 'Config de l\'enregistrement',
    'account_login_config' => 'Config Connexion',
    'account_password_config' => 'Config mot de passe',
    'account_center_service' => 'Centre de compte',
    'account_center_captcha' => 'Captcha',
    'account_register_service' => 'Service d\'inscription',
    'account_register_status' => 'Si l\'enregistrement ouvert',
    'account_register_type' => 'Enregistrer le support de compte',
    'account_register_type_email' => 'Courriel',
    'account_register_type_phone' => 'Numéro de téléphone',
    'account_login_service' => 'Service de connexion',
    'account_login_support' => 'Assistance à la connexion',
    'account_login_type_email' => 'Courriel',
    'account_login_type_phone' => 'Numéro de téléphone',
    'account_code_login' => 'Code de vérification Login',
    'account_login_or_register' => 'Enregistrement automatique si aucun compte n\'est disponible lors de la connexion du code de vérification',
    'account_password_length' => 'Exigences de longueur',
    'account_password_length_desc' => 'Exigences de longueur: la longueur minimale, 0 ou non remplie n\'est pas limitée',
    'account_password_strength' => 'Exigences de force',
    'account_password_strength_desc' => 'Exigences de force: le type de caractères sélectionné doit être présent dans le mot de passe et il n\'est pas limité',
    'account_password_strength_digital' => 'numéro',
    'account_password_strength_lowerLetters' => 'Minuscules',
    'account_password_strength_upperLetters' => 'lettre majuscule',
    'account_password_strength_symbols' => 'Symbole (division)',
    'account_connect_services' => 'Support d\'interconnexion tiers',
    'account_connect_services_desc' => 'Sélectionnez la plate-forme d\'interconnexion et associez des plugins pour créer une inscription rapide ou une connexion',
    'account_kyc_service' => 'Support de certification de nom réel',
    'account_kyc_service_desc' => 'Après avoir installé le plugin de service d\'authentification, l\'utilisateur peut authentifier le nom réel',
    'account_users_service' => 'Gestion multi-utilisateurs',
    // System-Wallet
    'wallet_functions' => 'Fonction de portefeuille',
    'wallet_functions_desc' => 'Que ce soit pour activer le forfait d\'argent français',
    'wallet_currency_code' => 'Code de devise',
    'wallet_currency_name' => 'Nom monétaire',
    'wallet_currency_unit' => 'Unité monétaire',
    'wallet_currency_precision' => 'Précision monnaie',
    'wallet_withdraw_status' => 'En espèces',
    'wallet_withdraw_config' => 'Configuration de l\'argent',
    'wallet_withdraw_config_desc' => 'Une configuration supplémentaire associée doit être prise en charge, veuillez consulter le développeur du plugin',
    'wallet_withdraw_review' => 'En espèces',
    'wallet_withdraw_review_prove' => 'Apporter pour vérifier les informations de nom réelle',
    'wallet_withdraw_periodicity' => 'Intervalle de trésorerie',
    'wallet_withdraw_rates' => 'Frais de retrait de trésorerie',
    'wallet_withdraw_min' => 'Montant minimum d\'extradition unique',
    'wallet_withdraw_max' => 'Montant maximum de retrait unique',
    'wallet_withdraw_sum_limit' => 'Casquette de retrait quotidien',
    // System-Storage
    'storage_service_config' => 'Configuration de stockage',
    'storage_service_config_desc' => 'Les fournisseurs de services de stockage peuvent installer plus de choix dans l\'App Store',
    'storage_function_config' => 'Configuration de la fonction',
    'storage_function_image_config' => 'Configuration de la fonction de traitement d\'image',
    'storage_function_image_config_desc' => 'Les noms de style ou les paramètres avancés peuvent être configurés. Testez la compression d\'image, le zoom, le filigrane, etc., le "identifiant d\'intervalle" commun est des caractères à moitié largeur "!" - "-", "_". Assistance aux paramètres avancés et voir la documentation du développeur du fournisseur de services de stockage',
    'storage_function_video_config' => 'Configuration de la fonction de traitement vidéo',
    'storage_function_video_config_desc' => 'Vous pouvez configurer l\'ID de modèle. Pour plus de détails, veuillez vous reporter à la description du plugin associé',
    'storage_function_audio_config' => 'Configuration de la fonction de traitement audio',
    'storage_function_audio_config_desc' => 'Vous pouvez configurer l\'ID de modèle. Pour plus de détails, veuillez vous reporter à la description du plugin associé',
    'storage_function_document_config' => 'Configuration de la prévisualisation en ligne',
    'storage_function_substitution_config' => 'Carte de remplacement d\'état non valide',
    'storage_function_substitution_config_desc' => 'Lorsque l\'état du fichier de ressources est "invalide", la carte d\'indication illégitime est utilisée',
    'storage_function_substitution_image' => 'Image indique invalide',
    'storage_function_substitution_video' => 'Indicateur vidéo invalide',
    'storage_function_substitution_audio' => 'Astuce audio non valide',
    'storage_function_substitution_document' => 'Document Carte rapide invalide',
    'storage_service_provider' => 'Fournisseur de service de stockage',
    'storage_filesystem_disk' => 'Disque du système de fichiers',
    'storage_file_access_domain' => 'Domaine d\'accès',
    'storage_extension_names' => 'Extension prise en charge',
    'storage_max_size' => 'Taille maximale supportée',
    'storage_max_duration' => 'Temps maximum pris en charge',
    'storage_temporary_url_status' => 'URL temporaire',
    'storage_temporary_url_status_desc' => 'Si le plugin ne supporte pas la fonction Temporary URL, veuillez ne pas l\'ouvrir, sinon la ressource ne sera pas accessible.',
    'storage_temporary_url_key' => 'Clé de l\'URL temporaire',
    'storage_temporary_url_expiration' => 'Expiration de l\'URL temporaire',
    'storage_image_handle_position' => 'Position de la poignée d\'image',
    'storage_image_thumb_config' => 'Carte de configuration',
    'storage_image_thumb_avatar' => 'Avatar',
    'storage_image_thumb_ratio' => 'Thumbnail isométrique',
    'storage_image_thumb_square' => 'Thumbnail carré',
    'storage_image_thumb_big' => 'Carte compressée originale',
    'storage_video_transcode_parameter' => 'Paramètres de transcodage vidéo',
    'storage_video_watermark' => 'Paramètres de filigrane vidéo',
    'storage_video_screenshot' => 'Paramètres de capture d\'écran vidéo',
    'storage_video_gift' => 'Paramètres de diagramme de rotation vidéo',
    'storage_video_poster_parameter' => 'Paramètre de l\'affiche',
    'storage_video_transcode_handle_position' => 'Video Transcode Parameter Processing Position',
    'storage_video_poster_handle_position' => 'Poster Parameter Processing Position',
    'storage_audio_transcode_parameter' => 'Paramètres de transcodage audio',
    'storage_audio_transcode_handle_position' => 'Position de traitement des paramètres de transcodage audio',
    'storage_document_preview_service' => 'Service de prévisualisation des documents',
    'storage_document_preview_extension_names' => 'Principation d\'aperçu de la prise en charge',
    // Operating-User
    'user_name' => 'Nom personnalisé d\'identité',
    'user_name_desc' => 'Par exemple, "utilisateur", "membre", "commissaire" et autre nommé',
    'user_uid_name' => 'ID Nom personnalisé',
    'user_uid_name_desc' => 'Par exemple, "UID", "ID", "numéro de membre" et autres nommés',
    'user_username_name' => 'Nom d\'utilisateur Nom personnalisé',
    'user_username_name_desc' => 'Par exemple, "nom d\'utilisateur", "nom de membre", "compte" et autre nommé',
    'user_nickname_name' => 'Nom surnom Nom personnalisé',
    'user_nickname_name_desc' => 'Par exemple, "surnom", "nom de fleur", "code" et autre nommé',
    'user_role_name' => 'Rôle Nom personnalisé',
    'user_role_name_desc' => 'Par exemple, "rôle", "groupe d\'utilisateurs", "groupe d\'utilisateurs" et autres nommés',
    'user_bio_name' => 'Nom personnalisé Bio',
    'user_bio_name_desc' => 'Exemple : Bio ou introduction',
    'user_default_role' => 'Rôle d\'utilisateur par défaut',
    'user_default_role_desc' => 'Rôle d\'utilisateur par défaut après l\'inscription',
    'user_default_avatar' => 'Avatar utilisateur par défaut',
    'user_default_avatar_desc' => 'Le diagramme d\'avatar par défaut lorsque l\'utilisateur ne définit pas l\'avatar',
    'user_default_anonymous_avatar' => 'Avatar utilisateur anonyme',
    'user_default_anonymous_avatar_desc' => 'Contenu Diagramme Avatar anonyme publié',
    'user_default_deactivate_avatar' => 'Avatar utilisateur',
    'user_default_deactivate_avatar_desc' => 'Image d\'avatar après la déconnexion ou la désactivation de l\'utilisateur',
    'user_identifier' => 'Identifiant de l\'utilisateur',
    'user_identifier_desc' => 'Quel marquage est dominant dans l\'interaction de l\'utilisateur',
    'user_uid_digit' => 'UID de l\'utilisateur Chiffre de départ',
    'user_uid_digit_desc' => 'Nombre de chiffres générés aléatoirement lors de l\'enregistrement',
    'user_profile_desc' => 'Liste de contenu par défaut lors de la visite de la page d\'accueil d\'un utilisateur',
    'user_ban_names' => 'Noms de bannissement',
    'user_ban_names_desc' => 'Un nom par ligne. L\'utilisation de ces noms d\'utilisateur et surnoms est interdite.',
    'user_edit_username_length' => 'Longueur du nom d\'utilisateur',
    'user_edit_username_length_min' => 'Longueur minimale',
    'user_edit_username_length_max' => 'La longueur maximale',
    'user_edit_username_length_desc' => 'Nom d\'utilisateur Longueur minimale et longueur maximale',
    'user_edit_username_periodicity' => 'Nom de modification du nom d\'utilisateur Numéro d\'intervalle',
    'user_edit_nickname_length' => 'Longueur du pseudo',
    'user_edit_nickname_periodicity' => 'Numéro d\'intervalle de modification de surnom d\'utilisateur',
    'user_edit_nickname_unique' => 'Surnom Unique',
    'user_edit_bio_length' => 'Bio Length',
    'user_edit_bio_support' => 'Support de la bio',
    'user_bio_support_mention' => 'Mention de l\'utilisateur',
    'user_bio_support_link' => 'Lien',
    'user_bio_support_hashtag' => 'Hashtag',
    'user_extcredits_config' => 'Extcredits Configuration',
    'user_extcredits_name' => 'Extcredits Nom',
    'user_extcredits_unit' => 'Nom de l\'unité',
    'user_extcredits_state_not_enabled' => 'Non activé',
    'user_extcredits_state_private' => 'Privé',
    'user_extcredits_state_public' => 'Public',
    'user_conversation_status' => 'Séance de lettre privée',
    'user_conversation_status_desc' => 'Fermer est valable pour tous les membres et est soumis aux droits d\'utilisateur après ouverture',
    'user_conversation_files' => 'Fonction d\'accessoire de session',
    'user_conversation_files_desc' => 'Si tout ne vérifie pas, le représentant ne prend en charge que la conversation de texte pur',
    // Operating-User-Profile
    'profile_posts' => 'Leurs publications',
    'profile_comments' => 'Leurs commentaires',
    'profile_likers' => 'Utilisateurs qui les ont aimés',
    'profile_dislikers' => 'Utilisateurs qui ne les ont pas aimés',
    'profile_followers' => 'Utilisateurs qui les ont suivis',
    'profile_blockers' => 'Utilisateurs qui les ont bloqués',
    'profile_followers_you_follow' => 'Abonnés que vous connaissez',
    'profile_likes_users' => 'Ils aiment les utilisateurs',
    'profile_likes_groups' => 'Ils aiment les groupes',
    'profile_likes_hashtags' => 'Ils aiment les hashtags',
    'profile_likes_geotags' => 'Ils aiment les géotags',
    'profile_likes_posts' => 'Ils aiment les publications',
    'profile_likes_comments' => 'Ils aiment les commentaires',
    'profile_dislikes_users' => 'Ils n\'aiment pas les utilisateurs',
    'profile_dislikes_groups' => 'Ils n\'aiment pas les groupes',
    'profile_dislikes_hashtags' => 'Ils n\'aiment pas les hashtags',
    'profile_dislikes_geotags' => 'Ils n\'aiment pas les géotags',
    'profile_dislikes_posts' => 'Ils n\'aiment pas les publications',
    'profile_dislikes_comments' => 'Ils n\'aiment pas les commentaires',
    'profile_following_users' => 'Ils suivent les utilisateurs',
    'profile_following_groups' => 'Ils suivent les groupes',
    'profile_following_hashtags' => 'Ils suivent les hashtags',
    'profile_following_geotags' => 'Ils suivent les géotags',
    'profile_following_posts' => 'Ils suivent les publications',
    'profile_following_comments' => 'Ils suivent les commentaires',
    'profile_blocking_users' => 'Ils bloquent les utilisateurs',
    'profile_blocking_groups' => 'Ils bloquent les groupes',
    'profile_blocking_hashtags' => 'Ils bloquent les hashtags',
    'profile_blocking_geotags' => 'Ils bloquent les géotags',
    'profile_blocking_posts' => 'Ils bloquent les publications',
    'profile_blocking_comments' => 'Ils bloquent les commentaires',
    // Operating-Content
    'content_group_name' => 'Nom personnalisé du groupe',
    'content_group_name_desc' => 'Par exemple, "édition", "cercle", "classification" et autre nommé',
    'content_hashtag_name' => 'Topic Nom personnalisé',
    'content_hashtag_name_desc' => 'Par exemple, "super comme", "tag", "sujets", etc',
    'content_post_name' => 'Nom du contenu post',
    'content_post_name_desc' => 'Par exemple, "Post", "Dynamics", "Talk", etc',
    'content_comment_name' => 'Nom du contenu de commentaire',
    'content_comment_name_desc' => 'Par exemple, "Commentaires", "Répondre", "Interaction" et autres nommés',
    'content_publish_post_name' => 'Poster un nom de comportement post',
    'content_publish_post_name_desc' => 'Par exemple, "publié", "soumission", "commentaires" et autres nommés',
    'content_publish_comment_name' => 'Publier un commentaire Nom de comportement',
    'content_publish_comment_name_desc' => 'Par exemple, "Répondre", "Répondre", "Suivre la poste" et d\'autres nommés',
    'content_mention_status' => 'Statut de la mention',
    'content_mention_number' => 'Nombre de mentions',
    'content_mention_number_desc' => 'Le nombre de mentions d\'utilisateurs par élément de contenu, 0 signifie aucune limitation.',
    'content_hashtag_status' => 'Statut du hashtag',
    'content_hashtag_format' => 'Format du hashtag',
    'content_hashtag_format_1' => 'Single #',
    'content_hashtag_format_2' => 'Double #',
    'content_hashtag_format_desc' => '<a href="#">#sujet</a> et <a href="#">#sujet#</a>',
    'content_hashtag_length' => 'Longueur du hashtag',
    'content_hashtag_number' => 'Nombre de Hashtag',
    'content_hashtag_number_desc' => 'Le nombre de hashtags pris en charge par élément de contenu, 0 signifie aucune limitation.',
    'content_hashtag_regexp' => 'Expression régulière du hashtag',
    'content_nearby_length' => 'Portée par défaut de la recherche à proximité',
    'content_nearby_length_desc' => 'Portée de la recherche lors de l\'affichage du contenu à proximité',
    'content_post_brief_length' => 'Post-résumé',
    'content_post_brief_length_desc' => 'Le poste dépasse cette valeur définie adoptera un résumé, le nombre de mots de résumé de contenu surdimensionné',
    'content_comment_brief_length' => 'Résumé des commentaires',
    'content_comment_brief_length_desc' => 'Commentaire Avant que la valeur définie adoptera un résumé du contenu de la longueur de la longueur de la supervision',
    'content_comment_visibility_rule' => 'Règles de visibilité des commentaires',
    'content_comment_visibility_rule_desc' => 'Les commentaires seront masqués si l\'article a été publié depuis plus de quelques jours, 0 signifie non activé.',
    'content_preview_post_like_users' => 'Aperçu des utilisateurs qui ont aimé un article',
    'content_preview_post_like_users_desc' => 'Aperçu des utilisateurs qui ont aimé le message, le nombre représente le nombre d\'aperçus.',
    'content_preview_post_comments' => 'Prévisualisation des commentaires',
    'content_preview_post_comments_desc' => 'Prévisualisation des commentaires sur la page de la liste des articles, le nombre représente le nombre de commentaires prévisualisés.',
    'content_preview_post_comment_require' => 'Conditions de prévisualisation des commentaires',
    'content_preview_post_comment_require_desc' => 'Comptez le nombre de commentaires avant la sortie de l\'aperçu.',
    'content_preview_comment_like_users' => 'Aperçu du commentaire comme utilisateur',
    'content_preview_comment_replies' => 'Aperçu des réponses aux commentaires',
    'content_post_edit_config' => 'Permissions d\'édition des messages',
    'content_post_delete_config' => 'Permissions de suppression des messages',
    'content_comment_edit_config' => 'Permissions d\'édition des commentaires',
    'content_comment_delete_config' => 'Permissions de suppression des commentaires',
    'content_edit_desc' => 'Puis-je modifier après la publication?',
    'content_delete_desc' => 'Puis-je supprimer un document après sa publication?',
    // Operating-Interaction
    'interaction_function_status' => 'Statut de la fonction',
    'interaction_operation_name' => 'Nom de l\'opération',
    'interaction_user_title' => 'Titre de l\'utilisateur',
    'interaction_public_record' => 'Enregistrement public',
    'interaction_public_count' => 'Compte public',
    'interaction_column_name' => 'Nom de la colonne',
    // Operating-Sticker
    'sticker_group' => 'Groupe d\'expression',
    'sticker_table_group_name' => 'Nom du groupe d\'émotion',
    'sticker_table_group_image' => 'Icône de groupe d\'émotion',
    'sticker_table_group_code' => 'Logo du groupe d\'émotion',
    'sticker_table_quantity' => 'Nombre d\'expressions',
    'sticker_manage' => 'Gestion d\'expression',
    'sticker_table_image' => 'Tableau d\'expression',
    'sticker_table_code' => 'Émoticônes',
    // Operating-Editor
    'editor_group' => 'grouper',
    'editor_title' => 'Titre',
    'editor_sticker' => 'expression',
    'editor_image' => 'image',
    'editor_video' => 'vidéo',
    'editor_audio' => 'l\'audio',
    'editor_document' => 'Documentation',
    'editor_mention' => 'Aètes',
    'editor_hashtag' => 'sujet',
    'editor_extend' => 'extensions',
    'editor_location' => 'position',
    'editor_anonymous' => 'anonyme',
    'editor_upload_image_type' => 'Formulaire de téléchargement d\'images',
    'editor_upload_video_type' => 'Formulaire de téléchargement de vidéo',
    'editor_upload_audio_type' => 'Formulaire de téléchargement de fichiers audio',
    'editor_upload_document_type' => 'Formulaire de téléchargement de documents',
    'editor_upload_image_number' => 'Nombre maximum d\'images à télécharger',
    'editor_upload_video_number' => 'Nombre maximum de vidéos à télécharger',
    'editor_upload_audio_number' => 'Nombre maximum de téléchargements d\'audio',
    'editor_upload_document_number' => 'Nombre maximal de téléchargements de documents',
    // Operating-Publish
    'publish_editor_config' => 'Sélection de l\'éditeur',
    'publish_editor_function_status' => 'Fonction de l\'éditeur',
    'publish_editor_function_options' => 'Configuration de la fonction Editeur',
    'publish_post_verify_config' => 'Poster une demande postale',
    'publish_comment_verify_config' => 'Poster une demande de commentaire',
    'publish_post_rules_config' => 'Poster une règle post-spéciale',
    'publish_comment_rules_config' => 'Publier une règle spéciale d\'examen',
    'publish_editor_desc' => 'Editeur publié',
    'publish_verify_desc' => 'Les comptes doivent être complétés avec les informations sélectionnées pour être publiées.',
    'publish_rules_desc' => 'Tous les employés sont valables, la priorité est supérieure aux règles de rôles',
    'publish_rule_type' => 'Type de règle',
    'publish_rule_datetime' => 'Gamme de dates',
    'publish_rule_time' => 'limite de temps',
    'publish_rule_timezone' => 'Fuseau horaire standard',
    'publish_rule_rule' => 'Exigences de la règle',
    'publish_rule_tip' => 'Invite de règle',
    'publish_edit_time_limit' => 'Combien de temps pouvez-vous modifier?',
    'publish_edit_sticky_limit' => 'Après Sticky',
    'publish_edit_digest_limit' => 'Après Digest',
    'publish_editor_group_required' => 'Si le groupe est requis',
    'publish_editor_group_required_desc' => 'Lorsque vous postez des messages, devez-vous choisir',
    'publish_editor_title_input_box' => 'Affichage de la boîte d\'entrée de titre',
    'publish_editor_title_input_box_desc' => 'l\'affichage faible nécessite que l\'utilisateur sélectionne manuellement la zone de saisie du titre',
    'publish_editor_title_required' => 'Si le titre doit être rempli',
    'publish_editor_title_required_desc' => 'Lors de l\'affichage post, le titre doit être rempli',
    'publish_editor_title_length' => 'Limite de mot de titre',
    'publish_editor_title_length_desc' => 'Le nombre de titres ne doit pas dépasser le nombre de paramètres, la limite supérieure maximale de 255 caractères',
    'publish_editor_post_content_length' => 'Limite d\'affichage',
    'publish_editor_post_content_length_desc' => 'Le nombre de postes ne dépassera pas le nombre de réglages, une limite supérieure minimale de 140 caractères',
    'publish_editor_comment_content_length' => 'Limite de mot de commentaire',
    'publish_editor_comment_content_length_desc' => 'Le nombre de commentaires ne doit pas dépasser le nombre de paramètres, minimum limite supérieure de 140 caractères',
    // Operating-Permission
    'permission_option_email' => 'Courriel requis',
    'permission_option_phone' => 'Téléphone requis',
    'permission_option_kyc' => 'KYC requis',
    'permission_option_rule_datetime' => 'Efficace dans la plage de dates spécifiée',
    'permission_option_rule_time' => 'Spécifiez un cycle de temps dans la période spécifiée',
    'permission_option_review_publish' => 'Peut être publié, mais besoin de revoir',
    'permission_option_close_publish' => 'Interdire la publication',
    'permission_option_can_be_edited' => 'Peut être édité',
    'permission_option_cannot_be_edited' => 'Ne peut pas être édité',
    'permission_option_can_be_deleted' => 'Peut être supprimé',
    'permission_option_cannot_be_deleted' => 'Ne peut être supprimé',
    'permission_option_direct_release' => 'Passer directement',
    'permission_option_required_review' => 'Besoin de revoir',
    'permission_option_title_optional_display' => 'Affichage faible',
    'permission_option_title_direct_display' => 'Affichage fort',
    // Operating-Roles
    'role_table_display' => 'Logo d\'affichage',
    'role_table_nickname_color' => 'Couleur de surnom',
    'role_option_display_icon' => 'Icône d\'affichage',
    'role_option_display_text' => 'Texte',
    'role_option_close_nickname_color' => 'Ne pas utiliser les couleurs',
    'role_current' => 'Rôle actuel',
    'role_target' => 'Rôle cible',
    'role_target_desc' => 'Une fois que le rôle est supprimé, l\'utilisateur se fusionne au nom de rôle cible sélectionné sous le rôle',
    'role_perm_basic_config' => 'Paramètres de base',
    'role_perm_post_config' => 'Publier un post',
    'role_perm_comment_config' => 'Publier un commentaire',
    'role_perm_upload_config' => 'Réglage de téléchargement',
    'role_perm_interaction_config' => 'Paramètres interactifs',
    'role_perm_customize_config' => 'Paramètre personnalisé',
    'role_perm_content_view' => 'Parcourir la permission',
    'role_perm_conversation' => 'Autorisation de session',
    'role_perm_content_link_handle' => 'Gestion des liens pour le contenu publié',
    'role_perm_content_link_handle_1' => 'Ne pas résoudre et masquer le nom de domaine',
    'role_perm_content_link_handle_2' => 'Ne se résout pas mais s\'affiche en tant que texte',
    'role_perm_content_link_handle_3' => 'Analyse syntaxique normale',
    'role_perm_post_publish' => 'Poster une autorisation postale',
    'role_perm_post_verify' => 'Poster une demande postale',
    'role_perm_post_review' => 'Poster une règle postale',
    'role_perm_post_rules' => 'Poster une règle post-spéciale',
    'role_perm_post_time_interval' => 'Intervalle de temps de la poste',
    'role_perm_post_daily_count' => 'Limite quotidienne de publication',
    'role_perm_post_draft_count' => 'Limite du nombre d\'ébauches de messages',
    'role_perm_comment_publish' => 'Publier des privilèges de commentaire',
    'role_perm_comment_verify' => 'Poster une demande de commentaire',
    'role_perm_comment_review' => 'Publier une règle de commentaire',
    'role_perm_comment_rules' => 'Publier une règle spéciale d\'examen',
    'role_perm_comment_time_interval' => 'Intervalle de temps pour les commentaires',
    'role_perm_comment_daily_count' => 'Limite journalière des commentaires',
    'role_perm_comment_draft_count' => 'Limite du nombre de projets de commentaires',
    'role_perm_upload_image' => 'Télécharger une image',
    'role_perm_upload_video' => 'Télécharger une video',
    'role_perm_upload_audio' => 'Télécharger audio',
    'role_perm_upload_document' => 'Document de téléchargement',
    'role_perm_upload_file_desc' => 'Vérification du représentant a le droit de télécharger, la boîte de saisie quitte Blank utilise la "Configuration de stockage" comme paramètre par défaut',
    'role_perm_follow_user_max_count' => 'Suivre l\'utilisateur Max Count',
    'role_perm_block_user_max_count' => 'Bloquer l\'utilisateur Max Count',
    'role_perm_download_file_count' => 'Téléchargez la limite supérieure dans les 24 heures',
    'role_perm_table_name' => 'Nom de l\'autorité',
    'role_perm_table_value' => 'Valeur de permission',
    // Operating-Groups
    'group_table_parent_group' => 'Groupe parent',
    'group_table_subgroup' => 'Sous-groupe',
    'group_table_privacy' => 'Confidentialité',
    'group_table_visibility' => 'Visibilité',
    'group_table_follow_method' => 'Suivre la méthode',
    'group_table_recommend' => 'Est-il recommandé?',
    'group_table_admins' => 'Administrateur de groupe',
    'group_table_can_publish' => 'Peut publier',
    'group_table_post_permissions' => 'Permissions de publication',
    'group_table_comment_permissions' => 'Autorisations pour les commentaires',
    'group_table_publish_perm_role' => 'Rôle avec le droit de publier',
    'group_table_publish_perm_review' => 'Avez-vous besoin d\'un audit?',
    'group_table_publish_perm_review_desc' => 'Les administrateurs de groupe ne sont pas restreints',
    'group_public_desc' => 'Ouvert (tout le monde peut voir le poste au sein du groupe)',
    'group_private_desc' => 'Non public (seuls les membres peuvent voir les postes au sein du groupe)',
    'group_visible_desc' => 'On peut trouver (tout le monde peut trouver ce groupe)',
    'group_hidden_desc' => 'Ne trouvez pas (seuls les membres peuvent trouver ce groupe)',
    'group_publish_option_all' => 'Toutes les personnes',
    'group_publish_option_members' => 'Ne payant que le groupe d\'utilisateurs',
    'group_publish_option_roles' => 'Utilisateurs de rôle spécifiés uniquement',
    'group_publish_option_admins' => 'Administrateurs de groupe uniquement',
    'group_can_publish_desc' => 'La clôture des autorisations de publication peut être utilisée pour catégoriser les groupes.',
    'group_current' => 'Groupe actuel',
    'group_target' => 'Groupe ciblé',
    'group_target_desc' => 'Après la fusion, l\'ancien groupe sera supprimé et le contenu de l\'ancien groupe sera migré vers le nom de l\'équipe cible sélectionnée',
    // Extends
    'extend_editor_menus' => 'Menus',
    'extend_editor_toolbar' => 'Barre d\'outils',
    'extend_editor_number_of_uses_desc' => 'Exemples de plugins "votants", le nombre est 2, représentant un seul poste, 2 votes peuvent être inclus',
    'extend_content_service' => 'Service de contenu',
    'extend_content_list' => 'Liste de contenu',
    'extend_content_detail' => 'Détails du contenu',
    'extend_content_search' => 'Recherche de contenu',
    'extend_content_list_desc' => 'Cette configuration a une priorité plus élevée que la configuration du type de contenu. Une fois configurée, la source de données spécifiée par le type de contenu sera remplacée.',
    'extend_content_ip' => 'Service IP',
    'extend_content_map' => 'Service de cartographie',
    'extend_content_notifications_service' => 'Notifier le Service',
    'extend_content_review' => 'Service de révision',
    'extend_content_list_by_all' => 'Tous les messages ou commentaires',
    'extend_content_list_by_timelines' => 'Chronologie des messages ou des commentaires',
    'extend_content_list_by_nearby' => 'Postes ou commentaires à proximité',
    'extend_content_by_detail' => 'Détail du message ou du commentaire',
    'extend_content_search_users' => 'Recherche d\'utilisateurs',
    'extend_content_search_groups' => 'Recherche de groupes',
    'extend_content_search_hashtags' => 'Recherche de hashtags',
    'extend_content_search_geotags' => 'Recherche de géotags',
    'extend_content_search_posts' => 'Recherche de messages',
    'extend_content_search_comments' => 'Recherche de commentaires',
    // Client-Channels
    'channel_default_homepage' => 'Page d\'accueil par défaut',
    'channel_table_channel' => 'Canal',
    'channel_table_page' => 'Page d\'accueil',
    'channel_table_page_home' => 'Accueil',
    'channel_table_page_list' => 'Liste des canaux',
    'channel_table_page_detail' => 'Détail',
    'channel_table_page_interaction' => 'Interaction',
    'channel_table_path' => 'Chemin d\'accès',
    'channel_table_seo' => 'Informations sur le référencement',
    'channel_table_seo_title' => 'Titre de référencement',
    'channel_table_seo_description' => 'Description du référencement',
    'channel_table_seo_keywords' => 'Mot-clé',
    'channel_table_query_state' => 'Passages côté client',
    'channel_table_query_state_desc' => 'Accepter ou non les passes côté client ; si elle est désactivée, seules les valeurs par défaut des paramètres seront prises en charge.',
    'channel_table_query_config' => 'Paramètres par défaut',
    'channel_table_query_config_desc' => 'Se référer aux paramètres de requête de l\'API de cette interface.',
    'channel_query_state_1' => 'Aucun paramètre client accepté',
    'channel_query_state_2' => 'Accepte uniquement les paramètres de pagination du client',
    'channel_query_state_3' => 'Accepter tous les paramètres',
    // Client-Columns
    'channel_timeline' => 'Chronologie',
    'channel_timeline_all_posts' => 'Tous les messages suivis',
    'channel_timeline_user_posts' => 'Je suis les messages des utilisateurs',
    'channel_timeline_group_posts' => 'Je suis les messages des groupes',
    'channel_timeline_hashtag_posts' => 'Je suis les posts de hashtags',
    'channel_timeline_geotag_posts' => 'Je suis les posts géotags',
    'channel_timeline_all_comments' => 'Tous les commentaires suivis',
    'channel_timeline_user_comments' => 'Je suis les commentaires des utilisateurs',
    'channel_timeline_group_comments' => 'Je suis les commentaires des groupes',
    'channel_timeline_hashtag_comments' => 'Je suis les commentaires des hashtags',
    'channel_timeline_geotag_comments' => 'Je suis les commentaires des géotags',
    'channel_nearby' => 'A proximité',
    'channel_nearby_posts' => 'Messages de Nearby',
    'channel_nearby_comments' => 'Commentaires de Nearby',
    'channel_me' => 'Centre personnel',
    'channel_me_extcredits' => 'Extcredits',
    'channel_me_wallet' => 'Portefeuille',
    'channel_me_drafts' => 'Brouillons',
    'channel_me_users' => 'Utilisateurs',
    'channel_me_settings' => 'Paramètres',
    'channel_messages' => 'Messages',
    'channel_conversations' => 'Conversations',
    'channel_notifications' => 'Notifications',
    'channel_notifications_all' => 'Notifications-Tous',
    'channel_notifications_systems' => 'Notifications-Systems',
    'channel_notifications_recommends' => 'Notifications-Recommende',
    'channel_notifications_likes' => 'Notifications-Likes',
    'channel_notifications_dislikes' => 'Notifications-Désapprouver',
    'channel_notifications_follows' => 'Notifications-Follows',
    'channel_notifications_blocks' => 'Notifications-les blocages',
    'channel_notifications_mentions' => 'Notifications-Mentions',
    'channel_notifications_comments' => 'Notifications-les commentaires',
    'channel_notifications_quotes' => 'Notifications-Citation',
    'channel_search' => 'chercher',
    // Client-Keys
    'key_table_read_only' => 'Lecture seule',
    'key_select_platform' => 'Sélectionnez la plate-forme d\'application clé',
    'key_option_main_api' => 'API principale',
    'key_option_manage_api' => 'API de gestion',
    'key_option_plugin_api' => 'API de plugin',
    'key_option_plugin_api_select' => 'Sélectionnez le plugin à utiliser',
    'key_option_plugin_api_select_desc' => 'Cette clé ne peut que demander l\'API du plugin associé',
    // Client-Basic
    'website_stat_code' => 'Code statistique du site',
    'website_stat_code_desc' => 'L\'utilisation de code statistique contenant document.write n\'est pas supportée.',
    'website_stat_position' => 'Emplacement du code statistique',
    'website_stat_position_desc' => 'Emplacement où le code statistique est chargé dans le HTML.',
    'china_mode' => 'Mode Chine',
    'china_mode_desc' => 'Informations requises lorsque le serveur du site est déployé en Chine.',
    'china_mode_config' => 'Configuration du serveur en Chine continentale (champ non obligatoire)',
    'china_icp_filing' => 'Dépôt du fournisseur de contenu Internet',
    'china_icp_license' => 'Licence de fournisseur de contenu Internet',
    'china_mps_filing' => 'Dépôt auprès du Bureau de la sécurité publique',
    'china_broadcasting_license' => 'Licence de radiodiffusion',
    // Client-Status
    'client_status_desc' => 'Le client demande la configuration de l\'état toutes les 10 minutes',
    // App-Center-Themes
    'website_engine_config' => 'Configuration du moteur',
    'website_engine_api_config' => 'Configuration de l\'API',
    'website_engine_status' => 'Statut du moteur',
    'website_engine_api_type' => 'Type d\'API du moteur',
    'website_engine_key_id' => 'Sélectionner la clé d\'application',
    'website_engine_view_desktop' => 'Ordinateur',
    'website_engine_view_mobile' => 'Mobile',
    // App-Center-Install
    'install_website_engine' => 'Installer le moteur de site web',
    'install_plugin' => 'Installer le plugin',
    'install_application' => 'Installer l\'application',
    'install_mode' => 'Mode d\'installation',
    'install_mode_fskey' => 'Entrer la clé Fresns',
    'install_mode_upload' => 'Télécharger le paquet Zip',
    'install_mode_directory' => 'Chemin du répertoire d\'entrée',
    'download_application' => 'Télécharger l\'application',
];
