<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Fresns Control Panel',
    'fresns_core' => 'Fresns Core',
    // Login page
    'language' => 'Language',
    'login' => 'Login',
    'account' => 'Account',
    'password' => 'Password',
    'enter' => 'Enter',
    'operation' => 'Panel Operation',
    'site_home' => 'Website Home',
    'switch_language' => 'Switch Language',
    'logout' => 'Logout',
    // Header menus
    'menu_dashboard' => 'Dashboard',
    'menu_systems' => 'Systems',
    'menu_operations' => 'Operations',
    'menu_extends' => 'Extends',
    'menu_clients' => 'Clients',
    'menu_app_center' => 'App Center',
    'menu_marketplace' => 'Marketplace',
    // Sidebar menus
    'sidebar_home' => 'Home',
    'sidebar_admins' => 'Admins',
    'sidebar_events' => 'Events',
    'sidebar_events_tab_subscribe' => 'Subscribe',
    'sidebar_events_tab_crontab' => 'Crontab',
    'sidebar_caches' => 'Caches',
    'sidebar_caches_tab_config' => 'Config Cache',
    'sidebar_caches_tab_data' => 'Data Cache',
    'sidebar_upgrades' => 'Upgrades',
    'sidebar_settings' => 'Settings',
    'sidebar_languages' => 'Languages',
    'sidebar_storage' => 'Storage',
    'sidebar_storage_tab_image' => 'Image',
    'sidebar_storage_tab_video' => 'Video',
    'sidebar_storage_tab_audio' => 'Audio',
    'sidebar_storage_tab_document' => 'Document',
    'sidebar_storage_tab_substitution' => 'Substitution',
    'sidebar_general' => 'General',
    'sidebar_policy' => 'Policy',
    'sidebar_policy_tab_options' => 'Options',
    'sidebar_policy_tab_contents' => 'Contents',
    'sidebar_send' => 'Send',
    'sidebar_send_tab_services' => 'Send Services',
    'sidebar_send_tab_templates' => 'Verify Code Templates',
    'sidebar_account' => 'Account',
    'sidebar_wallet' => 'Wallet',
    'sidebar_wallet_tab_options' => 'Options',
    'sidebar_wallet_tab_recharge_services' => 'Recharge Services',
    'sidebar_wallet_tab_withdraw_services' => 'Withdraw Services',
    'sidebar_user' => 'User',
    'sidebar_content' => 'Content',
    'sidebar_interaction' => 'Interaction',
    'sidebar_publish' => 'Publish',
    'sidebar_publish_tab_post' => 'Post',
    'sidebar_publish_tab_comment' => 'Comment',
    'sidebar_roles' => 'Roles',
    'sidebar_stickers' => 'Stickers',
    'sidebar_groups' => 'Groups',
    'sidebar_groups_tab_active' => 'Active',
    'sidebar_groups_tab_deactivate' => 'Inactive',
    'sidebar_groups_tab_recommend' => 'View recommend only',
    'sidebar_extend_editor' => 'Editor',
    'sidebar_extend_content_type' => 'Content Type',
    'sidebar_extend_content_handler' => 'Content Handler',
    'sidebar_extend_manage' => 'Manage',
    'sidebar_extend_group' => 'Group',
    'sidebar_extend_group_filter' => 'Filter',
    'sidebar_extend_user_feature' => 'User Feature',
    'sidebar_extend_user_profile' => 'User Profile',
    'sidebar_extend_channel' => 'Channel',
    'sidebar_extend_command_words' => 'Command Words',
    'sidebar_channels' => 'Channels',
    'sidebar_paths' => 'Paths',
    'sidebar_language_packs' => 'Language Packs',
    'sidebar_code_messages' => 'Code Messages',
    'sidebar_client_basic' => 'Basic',
    'sidebar_client_status' => 'Status',
    'sidebar_plugins' => 'Plugins',
    'sidebar_plugins_tab_all' => 'All',
    'sidebar_plugins_tab_active' => 'Active',
    'sidebar_plugins_tab_inactive' => 'Inactive',
    'sidebar_themes' => 'Themes',
    'sidebar_apps' => 'Apps',
    'sidebar_keys' => 'App Keys',
    // Sidebar intro
    'sidebar_admins_intro' => 'Users who have access to the control panel',
    'sidebar_events_intro' => 'View timed tasks and subscription events in the system',
    'sidebar_caches_intro' => 'When clearing all cache, the server load may increase, please try to avoid the peak access time',
    'sidebar_upgrades_intro' => 'Last checked on',
    'sidebar_settings_intro' => 'Please clear the cache after configuration, or wait 10 minutes for the new cache to take effect.',
    'sidebar_languages_intro' => 'You need to configure the language options here before you can enter multilingual content in the corresponding config items',
    'sidebar_storage_intro' => 'The four types of resource files can be stored separately or in the same place, just fill in the storage configuration information consistently',
    'sidebar_general_intro' => 'The setting items that guarantee the proper operation of the system',
    'sidebar_policy_intro' => 'Configure functions according to the relevant data legal regulations of the country where the target marketplace is located',
    'sidebar_send_intro' => 'Message sending settings such as email SMS and system notifications',
    'sidebar_account_intro' => 'Account center function settings',
    'sidebar_wallet_intro' => 'The wallet is a fiat currency feature, if you need the virtual points feature please install the appropriate plugin',
    'sidebar_wallet_tab_recharge_services_intro' => 'The recharge service provider configuration will be presented in the "Wallet" function list for paying orders or recharging your wallet',
    'sidebar_wallet_tab_withdraw_services_intro' => 'The withdrawal service provider configuration will be presented in the "Wallet" function list for withdrawing the wallet balance to the specified account',
    'sidebar_user_intro' => 'User base function settings',
    'sidebar_content_intro' => 'Social content name and function configuration',
    'sidebar_interaction_intro' => 'The user’s perception of a product’s service (sense of experience) does not depend on the technical logic, but on the naming of function points.',
    'sidebar_publish_intro' => 'This configuration is valid for all users, and the permission priority is greater than the user role permission',
    'sidebar_roles_intro' => 'Roles can have specific settings for user identity and permissions',
    'sidebar_stickers_intro' => 'Custom configuration of emoji images, without configuration, users can also enter Emoji through the emoji keyboard',
    'sidebar_groups_intro' => 'The group can be used to realize various operation scenarios such as BBS forum, community circle, and content categories',
    'sidebar_extend_editor_intro' => 'will be presented in the Editor of the posting process. For example, the "Voting" extension allows the Editor to support voting functionality for posts',
    'sidebar_extend_content_type_intro' => 'Will be presented in the Posts list page for outputting posts of the specified "type" and defining the source of the data results',
    'sidebar_extend_content_handler_intro' => 'The function is the same as the "Content Type Extension" data source function, whether the request is distributed to the plugin for processing is up to the plugin to determine the data logic',
    'sidebar_extend_manage_intro' => 'It will be presented in the "More" feature list of posts, comments, and user home pages. For example, the "Complaints" extension allows users to make complaints about the corresponding targets',
    'sidebar_extend_group_intro' => 'It will be presented in the "Group" homepage, for example, the "Link-only Extension Plugin" can display a hyperlink in the "Group" homepage',
    'sidebar_extend_user_feature_intro' => 'It will be presented in the "My" page of "User Center", for example, the "Wallet" extension allows for an additional wallet function in the User Center',
    'sidebar_extend_user_profile_intro' => 'It will be presented in the list of "User Profile" management functions, for example, "Modify Username Plugin" allows the Modify Profile function to support modifying the username',
    'sidebar_extend_channel_intro' => 'It is displayed in the main menu or in a list of channel pages, e.g. the Shopping extension allows the user to access the Mall channel.',
    'sidebar_extend_command_words_intro' => 'Command words configured in this list are available for API requests.',
    'sidebar_channels_intro' => 'Unify the configuration of the client\'s individual channel information.',
    'sidebar_paths_intro' => 'Custom path structures can improve the aesthetics, usability, and forward-compatibility of your links.',
    'sidebar_language_packs_intro' => 'Configure the multilingual content of each text for the multilingual client',
    'sidebar_code_messages_intro' => 'Configure multilingual descriptions of status codes for the main program and plugins.',
    'sidebar_client_basic_intro' => 'A generic configuration item for the client base.',
    'sidebar_client_status_intro' => 'Once deactivated, all client pages and actions will jump to the Deactivation Instructions page.',
    'sidebar_plugins_intro' => 'Powerful features, and the freedom to build anything you want',
    'sidebar_themes_intro' => 'Choose a different theme for more personalized style and interaction',
    'sidebar_apps_intro' => 'Standard APIs, powerful extensions, create diverse operation scenarios and application models at will.',
    'sidebar_keys_intro' => 'Key credentials are important, please do not disclose them to others easily',
    // Page button
    'button_support' => 'Support',
    'button_update' => 'Update',
    'button_search' => 'Search',
    'button_add' => 'Add',
    'button_edit' => 'Edit',
    'button_modify' => 'Modify',
    'button_delete' => 'Delete',
    'button_cancel' => 'Cancel',
    'button_close' => 'Close',
    'button_dismiss' => 'Dismiss',
    'button_activate' => 'Activate',
    'button_deactivate' => 'Deactivate',
    'button_install' => 'Install',
    'button_uninstall' => 'Uninstall',
    'button_setting' => 'Setting',
    'button_config' => 'Config',
    'button_reset' => 'Reset',
    'button_confirm' => 'Confirm',
    'button_try_again' => 'Try Again',
    'button_save' => 'Save',
    'button_download' => 'Download',
    'button_upgrade' => 'Upgrade',
    'button_automatic_upgrade' => 'Auto Upgrade',
    'button_manual_upgrade' => 'Manual Upgrade',
    'button_confirm_delete' => 'Confirm Delete',
    'button_confirm_install' => 'Confirm Install',
    'button_confirm_upgrade' => 'Confirm Upgrade',
    'button_confirm_download' => 'Confirm Download',
    'button_confirm_uninstall' => 'Confirm Uninstall',
    'button_view' => 'View',
    'button_image_upload' => 'Upload',
    'button_image_input' => 'Input',
    'button_check_upgrade' => 'Check Upgrade',
    'button_check_status' => 'Check Status',
    'button_batch_import' => 'Import',
    'button_batch_export' => 'Export',
    'button_config_email_template' => 'Config Email Template',
    'button_config_sms_template' => 'Config SMS Template',
    'button_config_sticker' => 'Config Sticker',
    'button_config_permission' => 'Config Permission',
    'button_config_language_pack' => 'Config Pack',
    'button_add_admin' => 'Add Admin',
    'button_add_language' => 'Add Lang',
    'button_add_account_connect' => 'Add Account Connect',
    'button_add_service_provider' => 'Add Service',
    'button_add_sticker_group' => 'Add Sticker Group',
    'button_add_sticker' => 'Add Sticker',
    'button_add_role' => 'Add Role',
    'button_add_group' => 'Add Group',
    'button_group_move' => 'Move',
    'button_add_key' => 'Add Key',
    'button_reset_key' => 'Reset Key',
    'button_reset_secret' => 'Reset Secret',
    'button_clear_cache' => 'Clear Cache',
    'button_clear_all_cache' => 'Clear All Cache',
    // Page table
    'table_order' => 'Order',
    'table_recommend_order' => 'Recommend Order',
    'table_position' => 'Position',
    'table_number' => 'Number',
    'table_lang_tag' => 'Lang Tag',
    'table_lang_name' => 'Lang Name',
    'table_title' => 'Title',
    'table_content' => 'Content',
    'table_platform' => 'Platform',
    'table_service' => 'Service',
    'table_app_id' => 'App ID',
    'table_app_key' => 'App Key',
    'table_app_secret' => 'App Secret',
    'table_plugin' => 'Plugin',
    'table_command_word' => 'Command Word',
    'table_name' => 'Name',
    'table_description' => 'Description',
    'table_icon' => 'Icon',
    'table_banner' => 'Banner',
    'table_type' => 'Type',
    'table_use' => 'Use',
    'table_support' => 'Support',
    'table_data_source' => 'Data Source',
    'table_scene' => 'Scene',
    'table_number_of_uses' => 'Number of uses',
    'table_scope' => 'Scope',
    'table_scope_global' => 'Global',
    'table_scope_global_desc' => 'Can be restricted to specified roles',
    'table_scope_group_admins' => 'Group Admins',
    'table_scope_group_admins_desc' => 'When enabled, only group administrators will show the plugin',
    'table_authorized_roles' => 'Authorized Roles',
    'table_authorized_roles_desc' => 'Leave blank to indicate that all user roles are entitled to use',
    'table_whitelist_rules' => 'Whitelist Roles',
    'table_parameter' => 'Parameter',
    'table_status' => 'Status',
    'table_options' => 'Options',
    // Config option
    'option_default' => 'Default',
    'option_all' => 'All',
    'option_public' => 'Public',
    'option_private' => 'Private',
    'option_visible' => 'Visible',
    'option_hidden' => 'Hidden',
    'option_open' => 'Open',
    'option_close' => 'Close',
    'option_yes' => 'Yes',
    'option_no' => 'No',
    'option_activate' => 'Activate',
    'option_deactivate' => 'Deactivate',
    'option_local' => 'Local',
    'option_remote' => 'Remote',
    'option_required' => 'Required',
    'option_not_required' => 'Not Required',
    'option_not_set' => 'Not set',
    'option_no_use' => 'No use',
    'option_unselect' => 'Unselect',
    'option_optional' => 'Optional',
    'option_email' => 'Email',
    'option_sms' => 'SMS',
    'option_data_close' => 'Not Public',
    'option_data_private' => 'Only Me',
    'option_data_public' => 'Public',
    'option_type_tree' => 'Tree',
    'option_type_list' => 'List',
    'option_uninstall_plugin_data' => 'Simultaneous deletion of the plugin data',
    'option_uninstall_theme_data' => 'Simultaneous deletion of the theme data',
    // Commons
    'portal' => 'Portal',
    'user' => 'User',
    'group' => 'Group',
    'hashtag' => 'Hashtag',
    'geotag' => 'Geotag',
    'post' => 'Post',
    'comment' => 'Comment',
    'file' => 'File',
    'extend' => 'Extend Content',
    'user_detail' => 'User Home',
    'group_detail' => 'Group Detail',
    'hashtag_detail' => 'Hashtag Detail',
    'geotag_detail' => 'Geotag Detail',
    'post_detail' => 'Post Detail',
    'comment_detail' => 'Comment Detail',
    'like' => 'Like',
    'dislike' => 'Dislike',
    'follow' => 'Follow',
    'block' => 'Block',
    'author' => 'Author',
    'new_version' => 'New',
    'default_language' => 'Default Language',
    'default_list' => 'Default List',
    'recommend' => 'Recommend',
    'unit_day' => 'Day',
    'unit_length' => 'Length',
    'unit_second' => 'Second',
    'unit_minute' => 'Minute',
    'unit_within_minute' => 'Within Minute',
    'unit_character' => 'Character',
    'unit_number' => 'Number',
    'unit_number_of_times' => 'Number of times',
    'unit_kilometer' => 'Kilometer',
    'unit_mile' => 'Mile',
    'config_default' => 'Default Config',
    'config_name' => 'Name Config',
    'config_edit' => 'Edit Config',
    'config_interaction' => 'Interaction Config',
    'config_conversation' => 'Conversation Config',
    'config_hashtag' => 'Hashtag Config',
    'config_list' => 'List Config',
    'config_preview' => 'Preview Config',
    'config_manage' => 'Manage Config',
    'delete_desc' => 'Sure to delete?',
    // Dashboard-Home
    'welcome' => 'Welcome to Fresns',
    'current_version' => 'Current version:',
    'overview' => 'At a Glance',
    'overview_accounts' => 'Accounts',
    'overview_users' => 'Users',
    'overview_groups' => 'Groups',
    'overview_hashtags' => 'Hashtags',
    'overview_geotags' => 'Geotags',
    'overview_posts' => 'Posts',
    'overview_comments' => 'Comments',
    'extensions' => 'Extensions',
    'support' => 'Support',
    'support_website' => 'Fresns Website',
    'support_teams' => 'Teams',
    'support_sponsor' => 'Sponsor',
    'support_join' => 'Join Fresns',
    'support_community' => 'Community',
    'support_marketplace' => 'Marketplace',
    'system_info' => 'System Info',
    'system_info_server' => 'Server architecture',
    'system_info_web' => 'Web server',
    'system_info_php_version' => 'PHP version',
    'system_info_php_cli_info' => 'PHP Cli info',
    'system_info_php_upload_max_filesize' => 'Upload max file size',
    'system_info_composer_info' => 'Composer info',
    'system_info_composer_version' => 'Composer version',
    'system_info_env_timezone' => '.env Timezone',
    'system_info_env_timezone_name' => '.env Timezone identifier',
    'system_info_env_timezone_utc' => '.env UTC timezone of the timezone identifier',
    'system_info_env_timezone_list' => 'Matching timezone identifier',
    'system_info_database_driver' => 'Database driver',
    'system_info_database_version' => 'Database version',
    'system_info_database_timezone' => 'Database timezone',
    'system_info_database_engine' => 'Database engine',
    'system_info_database_collation' => 'Database collation',
    'system_info_database_size' => 'Database size',
    'tips' => 'Tips',
    'news' => 'Fresns Events and News',
    // Dashboard-Events
    'event_subscribe_subject' => 'Subject',
    'event_crontab_time' => 'Execution Cycle',
    'event_crontab_time_desc' => 'Laravel task scheduling cron table format',
    // Dashboard-Caches
    'cache' => 'Cache',
    'cache_fresns_system' => 'System Config',
    'cache_fresns_config' => 'Site Config',
    'cache_fresns_extend' => 'Extend Config',
    'cache_fresns_view' => 'View',
    'cache_fresns_route' => 'Route',
    'cache_fresns_event' => 'Event',
    'cache_fresns_schedule' => 'Schedule',
    'cache_fresns_temporary' => 'Temporary Data',
    // Dashboard-Admins
    'admin_add_title' => 'New System Administrator',
    'admin_add_form_account' => 'Account',
    'admin_add_form_account_placeholder' => 'email or phone number',
    'admin_add_form_account_desc' => 'Phone number must be a complete number with international area code',
    'admin_add_form_account_btn' => 'Search and add',
    // Dashboard-Settings
    'setting_developer_options' => 'Developer Options',
    'setting_developer_options_desc' => 'Do not deactivate options if it is not a development environment.',
    'setting_build_type' => 'Build Type',
    'setting_build_type_desc' => 'The beta version is less stable, so please choose carefully.',
    'setting_build_select_tip' => 'Select upgrade version type',
    'setting_build_option_stable' => 'Stable Build',
    'setting_build_option_beta' => 'Beta Build',
    'setting_system_url' => 'System URL',
    'setting_system_url_desc' => 'Default access address for main program API and plugins',
    'setting_panel_path' => 'Panel Path',
    'setting_panel_path_desc' => 'After setting, you can only log in to the control panel through the designated security portal',
    'setting_panel_url' => 'Panel URL',
    'setting_panel_url_desc' => 'Control panel login page full URL',
    'setting_panel_url_copy' => 'Copy URL',
    // System-Languages
    'language_multilingual' => 'Multilingual',
    'language_table_default' => 'Default Language',
    'language_table_langCode' => 'Lang Code',
    'language_table_areaCode' => 'Area Code',
    'language_table_langName' => 'Lang Name',
    'language_table_areaName' => 'Area Name',
    'language_table_lengthUnit' => 'Unit of length',
    'language_table_writingDirection' => 'Writing Direction',
    'language_table_area' => 'Language Area',
    'language_table_dateFormat' => 'Date Format',
    'language_table_dateFormat_desc' => 'yyyy means year, mm means month, and dd means day',
    'language_table_timeFormat' => 'Humanized time',
    'language_table_timeFormat_desc' => 'Time variable name: {n}',
    'language_select_langCode' => 'Please select the language code',
    'language_select_continent' => 'Please select continent',
    'language_select_areaCode' => 'Please select the area code',
    // System-General
    'site_url' => 'Site URL',
    'site_url_desc' => 'Main site access URL',
    'site_name' => 'Site Name',
    'site_name_desc' => 'The name of your Fresns site',
    'site_intro' => 'Site Intro',
    'site_intro_desc' => 'The introduction to your Fresns site',
    'site_logo' => 'Site Logo',
    'site_logo_desc' => 'The information in the "Storage settings" must be configured in order to upload images',
    'site_copyright' => 'Copyright Info',
    'site_email' => 'Admin Email',
    'site_email_desc' => 'When running with errors, show to the user for easy feedback on the problem',
    'site_mode' => 'Operation mode',
    'site_mode_public' => 'Public',
    'site_mode_private' => 'Private',
    'site_mode_private_desc' => 'Private Mode Config',
    'site_mode_private_join_status' => 'Whether open to the public',
    'site_mode_private_join_service' => 'Add support plugin',
    'site_mode_private_content_policy' => 'Status after private expiration',
    'site_mode_private_content_policy_1' => 'All site content is not visible',
    'site_mode_private_content_policy_2' => 'Pre-expiration content visible, new content not visible',
    // System-Policy
    'policy_terms' => 'Terms',
    'policy_privacy' => 'Privacy',
    'policy_cookie' => 'Cookie',
    'policy_delete_account' => 'Delete Account',
    'policy_delete_options' => 'Delete Options',
    'policy_delete_options_desc' => 'The user can revoke delete (restore the account) within the buffer days, and the delete process will be executed when the expiration date is not revoked',
    'policy_delete_option_1' => 'Deactivate',
    'policy_delete_option_2' => 'Logical Deletion',
    'policy_delete_option_2_desc' => 'Logical Deletion: Only mark the account number as delete in the database, and do not really delete the data',
    'policy_delete_option_3' => 'Physical Deletion',
    'policy_delete_option_3_desc' => 'Physical Deletion: User profiles and published content will be deleted for real',
    'policy_delete_crontab' => 'Delete buffer days',
    // System-Send
    'send_email_config' => 'Email Config',
    'send_sms_config' => 'SMS Config',
    'send_sms_default_code' => 'Default Country Calling Code',
    'send_sms_supported_codes' => 'Country Calling Code Supported',
    'send_sms_desc' => 'One in a row. Code without + symbol. Leave blank means only single country is supported. Please make sure the service provider supports international SMS function before configuration',
    'send_app_notifications' => 'Push Notification Service',
    'send_app_ios_config' => 'iOS Config',
    'send_app_ios_notifications_desc' => 'The iOS pop-up notification feature',
    'send_app_android_config' => 'Android Config',
    'send_app_android_notifications_desc' => 'Android pop-up notification function',
    'send_app_desktop_config' => 'Desktop Config',
    'send_app_desktop_notifications_desc' => 'Desktop notification features, such as browser notifications.',
    'send_code_template_1' => 'Universal verify code',
    'send_code_template_2' => 'Register a new account',
    'send_code_template_3' => 'Modify account information',
    'send_code_template_4' => 'Change to new email or phone',
    'send_code_template_5' => 'Reset login password',
    'send_code_template_6' => 'Reset payment password',
    'send_code_template_7' => 'Login with verify code',
    'send_code_template_8' => 'Delete account using verify code',
    'send_code_template_table_email_desc' => 'HTML format support',
    'send_code_template_table_sms_sign' => 'Sign Name',
    'send_code_template_table_sms_code' => 'Code Info',
    'send_code_template_table_sms_code_desc' => 'For config tutorials, please refer to the guide of the associated plugin',
    'send_code_template_table_sms_param' => 'Code Param',
    // System-Account
    'account_center_config' => 'Account Center Config',
    'account_child_safety' => 'Child Safety',
    'account_age_verification' => 'Age Verification',
    'account_age_min_required' => 'Age Minimum Required',
    'account_register_config' => 'Register Config',
    'account_login_config' => 'Login Config',
    'account_password_config' => 'Password Config',
    'account_center_service' => 'Account Center',
    'account_center_captcha' => 'Captcha',
    'account_register_service' => 'Sign-up Service',
    'account_register_status' => 'Whether to open register',
    'account_register_type' => 'Register account support',
    'account_register_type_email' => 'Email',
    'account_register_type_phone' => 'Phone Number',
    'account_login_service' => 'Login Service',
    'account_login_support' => 'Login Support',
    'account_login_type_email' => 'Email',
    'account_login_type_phone' => 'Phone Number',
    'account_code_login' => 'Verify Code Login',
    'account_login_or_register' => 'No account will be registered automatically when the verify code is logged in',
    'account_password_length' => 'Length Request',
    'account_password_length_desc' => 'Length Request: The minimum length of the password. 0 or not filled for no limit',
    'account_password_strength' => 'Strength Request',
    'account_password_strength_desc' => 'Strength Request: The selected character type must be present in the password; unchecked is unrestricted',
    'account_password_strength_digital' => 'Digital',
    'account_password_strength_lowerLetters' => 'Lower Letters',
    'account_password_strength_upperLetters' => 'Upper Letters',
    'account_password_strength_symbols' => 'Symbols',
    'account_connect_services' => 'Connect Services',
    'account_connect_services_desc' => 'Select the connect platform and associate the plugin to enable quick registration or login',
    'account_kyc_service' => 'KYC Support',
    'account_kyc_service_desc' => 'After installing the auth service plugin, users can auth in their real identity',
    'account_users_service' => 'Multi-User Management',
    // System-Wallet
    'wallet_functions' => 'Wallet Functions',
    'wallet_functions_desc' => 'Whether to enable the fiat wallet function',
    'wallet_currency_code' => 'Currency Code',
    'wallet_currency_name' => 'Currency Name',
    'wallet_currency_unit' => 'Currency Unit',
    'wallet_currency_precision' => 'Currency Precision',
    'wallet_withdraw_status' => 'Withdraw Status',
    'wallet_withdraw_config' => 'Withdraw Config',
    'wallet_withdraw_config_desc' => 'Withdraw-related configuration requires plugin support, please read the plugin docs for details',
    'wallet_withdraw_review' => 'Withdraw Review',
    'wallet_withdraw_review_prove' => 'Withdraw Review Prove',
    'wallet_withdraw_periodicity' => 'Withdraw Periodicity',
    'wallet_withdraw_rates' => 'Withdraw Rates',
    'wallet_withdraw_min' => 'Min Single Withdraw Amount',
    'wallet_withdraw_max' => 'Max Single Withdraw Amount',
    'wallet_withdraw_sum_limit' => 'Total Daily Withdraw Limit',
    // System-Storage
    'storage_service_config' => 'Service Config',
    'storage_service_config_desc' => 'Storage service providers can install more plugin options in the fresns marketplace',
    'storage_function_config' => 'Function Config',
    'storage_function_image_config' => 'Image Function',
    'storage_function_image_config_desc' => 'Style names or advanced parameters can be configured. The common "interval identifier" is the half-angle character "!" , "-", "_" three kinds. Advanced parameters are supported, see the developer documentation of the storage provider',
    'storage_function_video_config' => 'Video Function',
    'storage_function_video_config_desc' => 'For config tutorials, please refer to the guide of the associated plugin',
    'storage_function_audio_config' => 'Audio Function',
    'storage_function_audio_config_desc' => 'For config tutorials, please refer to the guide of the associated plugin',
    'storage_function_document_config' => 'Document Function',
    'storage_function_substitution_config' => 'Substitution Config',
    'storage_function_substitution_config_desc' => 'Substitution hint usage image output when the status of the resource file is "invalid"',
    'storage_function_substitution_image' => 'Substitution Image',
    'storage_function_substitution_video' => 'Substitution Video',
    'storage_function_substitution_audio' => 'Substitution Audio',
    'storage_function_substitution_document' => 'Substitution Document',
    'storage_service_provider' => 'Service Provider',
    'storage_filesystem_disk' => 'Filesystem Disk',
    'storage_file_access_domain' => 'Access Domain',
    'storage_extension_names' => 'Supported extensions',
    'storage_max_size' => 'Max size supported',
    'storage_max_duration' => 'Max duration supported',
    'storage_temporary_url_status' => 'Temporary URL',
    'storage_temporary_url_status_desc' => 'If the plugin does not support the Temporary URL function, please do not open, otherwise the resource will not be accessible',
    'storage_temporary_url_key' => 'Temporary URL Key',
    'storage_temporary_url_expiration' => 'Temporary URL Expiration',
    'storage_image_handle_position' => 'Image Handle Position',
    'storage_image_thumb_config' => 'Config Image',
    'storage_image_thumb_avatar' => 'Avatar Image',
    'storage_image_thumb_ratio' => 'Ratio Image',
    'storage_image_thumb_square' => 'Square Image',
    'storage_image_thumb_big' => 'Big Image',
    'storage_video_transcode_parameter' => 'Transcode Parameter',
    'storage_video_watermark' => 'Watermark Parameter',
    'storage_video_screenshot' => 'Screenshot Parameter',
    'storage_video_gift' => 'Gift Parameter',
    'storage_video_poster_parameter' => 'Poster Parameter',
    'storage_video_transcode_handle_position' => 'Transcode Parameter Handle Position',
    'storage_video_poster_handle_position' => 'Poster Parameter Handle Position',
    'storage_audio_transcode_parameter' => 'Transcode Parameter',
    'storage_audio_transcode_handle_position' => 'Transcode Parameter Handle Position',
    'storage_document_preview_service' => 'Document Preview Service',
    'storage_document_preview_extension_names' => 'Extensions that support preview',
    // Operating-User
    'user_name' => 'Identity Custom Name',
    'user_name_desc' => 'Example: User or Member',
    'user_uid_name' => 'ID Custom Name',
    'user_uid_name_desc' => 'Example: UID or User Number',
    'user_username_name' => 'Username Custom Name',
    'user_username_name_desc' => 'Example: Username or Account Number',
    'user_nickname_name' => 'Nickname Custom Name',
    'user_nickname_name_desc' => 'Example: Nickname or Codename',
    'user_role_name' => 'Role Custom Name',
    'user_role_name_desc' => 'Example: Role or User Group',
    'user_bio_name' => 'Bio Custom Name',
    'user_bio_name_desc' => 'Example: Bio or Introduction',
    'user_default_role' => 'Default Role',
    'user_default_role_desc' => 'Default role after register',
    'user_default_avatar' => 'Default Avatar',
    'user_default_avatar_desc' => 'The default avatar image when the user does not set an avatar',
    'user_default_anonymous_avatar' => 'Anonymous Avatar',
    'user_default_anonymous_avatar_desc' => 'Content published by Anonymous avatar picture',
    'user_default_deactivate_avatar' => 'Deactivate Avatar',
    'user_default_deactivate_avatar_desc' => 'Avatar after user delete or deactivation',
    'user_identifier' => 'User Identifier',
    'user_identifier_desc' => 'Which marking is dominant in user interaction',
    'user_uid_digit' => 'User UID Starting digit',
    'user_uid_digit_desc' => 'Number of digits randomly generated during registration',
    'user_profile_desc' => 'Default content list when visiting user home page',
    'user_ban_names' => 'Ban Names',
    'user_ban_names_desc' => 'One name per line. Use of these usernames and nicknames is ban.',
    'user_edit_username_length' => 'Username Length',
    'user_edit_username_length_min' => 'Length Min',
    'user_edit_username_length_max' => 'Length Max',
    'user_edit_username_length_desc' => 'Minimum and maximum length of username',
    'user_edit_username_periodicity' => 'Number of days between username changes',
    'user_edit_nickname_length' => 'Nickname Length',
    'user_edit_nickname_periodicity' => 'Number of days between nickname changes',
    'user_edit_nickname_unique' => 'Nickname Unique',
    'user_edit_bio_length' => 'Bio Length',
    'user_edit_bio_support' => 'Bio Support',
    'user_bio_support_mention' => 'Mention User',
    'user_bio_support_link' => 'Link',
    'user_bio_support_hashtag' => 'Hashtag',
    'user_extcredits_config' => 'Extcredits Config',
    'user_extcredits_name' => 'Extcredits Name',
    'user_extcredits_unit' => 'Unit Name',
    'user_extcredits_state_not_enabled' => 'Not Enabled',
    'user_extcredits_state_private' => 'Private',
    'user_extcredits_state_public' => 'Public',
    'user_conversation_status' => 'User Conversation',
    'user_conversation_status_desc' => 'Close is valid for all users, open is subject to user role permissions',
    'user_conversation_files' => 'Attachment Features',
    'user_conversation_files_desc' => 'If all are unchecked, it means that only text-only conversations are supported',
    // Operating-User-Profile
    'profile_posts' => 'They posts',
    'profile_comments' => 'They comments',
    'profile_likers' => 'Users who liked them',
    'profile_dislikers' => 'Users who disliked them',
    'profile_followers' => 'Users who followed them',
    'profile_blockers' => 'Users who blocked them',
    'profile_followers_you_follow' => 'Followers You Know',
    'profile_likes_users' => 'They like the users',
    'profile_likes_groups' => 'They like the groups',
    'profile_likes_hashtags' => 'They like the hashtags',
    'profile_likes_geotags' => 'They like the geotags',
    'profile_likes_posts' => 'They like the posts',
    'profile_likes_comments' => 'They like the comments',
    'profile_dislikes_users' => 'They dislike the users',
    'profile_dislikes_groups' => 'They dislike the groups',
    'profile_dislikes_hashtags' => 'They dislike the hashtags',
    'profile_dislikes_geotags' => 'They dislike the geotags',
    'profile_dislikes_posts' => 'They dislike the posts',
    'profile_dislikes_comments' => 'They dislike the comments',
    'profile_following_users' => 'They follow the users',
    'profile_following_groups' => 'They follow the groups',
    'profile_following_hashtags' => 'They follow the hashtags',
    'profile_following_geotags' => 'They follow the geotags',
    'profile_following_posts' => 'They follow the posts',
    'profile_following_comments' => 'They follow the comments',
    'profile_blocking_users' => 'They block the users',
    'profile_blocking_groups' => 'They block the groups',
    'profile_blocking_hashtags' => 'They block the hashtags',
    'profile_blocking_geotags' => 'They block the geotags',
    'profile_blocking_posts' => 'They block the posts',
    'profile_blocking_comments' => 'They block the comments',
    // Operating-Content
    'content_group_name' => 'Group Custom Name',
    'content_group_name_desc' => 'Example: Group or Forum',
    'content_hashtag_name' => 'Hashtag Custom Name',
    'content_hashtag_name_desc' => 'Example: Topic or Tag',
    'content_post_name' => 'Post Custom Name',
    'content_post_name_desc' => 'Example: Post or Dynamic',
    'content_comment_name' => 'Comment Custom Name',
    'content_comment_name_desc' => 'Example: Comment or Reply',
    'content_publish_post_name' => 'Publish Post Custom Name',
    'content_publish_post_name_desc' => 'Example: Create or Feedback',
    'content_publish_comment_name' => 'Publish Comment Custom Name',
    'content_publish_comment_name_desc' => 'Example: Comment or Reply',
    'content_mention_status' => 'Mention Status',
    'content_mention_number' => 'Number of Mention',
    'content_mention_number_desc' => 'The number of user mentions per piece of content, 0 means no limitation.',
    'content_hashtag_status' => 'Hashtag Status',
    'content_hashtag_format' => 'Hashtag Format',
    'content_hashtag_format_1' => 'Single #',
    'content_hashtag_format_2' => 'Double #',
    'content_hashtag_format_desc' => 'The difference between <a href="#">#Hashtag</a> and <a href="#">#Hashtag#</a>',
    'content_hashtag_length' => 'Hashtag Length',
    'content_hashtag_number' => 'Number of Hashtag',
    'content_hashtag_number_desc' => 'The number of hashtags supported per piece of content, 0 means unlimited.',
    'content_hashtag_regexp' => 'Hashtag Regular Expression',
    'content_nearby_length' => 'Nearby search default range',
    'content_nearby_length_desc' => 'Search scope when viewing nearby content',
    'content_post_brief_length' => 'Post Brief Word Limit',
    'content_post_brief_length_desc' => 'Posts exceeding this set value will use the summary, the number of words in the summary of extra-long content',
    'content_comment_brief_length' => 'Comment Brief Word Limit',
    'content_comment_brief_length_desc' => 'Comments exceeding this set value will be used to summarize, the number of words in the summary of extra-long content',
    'content_comment_visibility_rule' => 'Comment visibility rule',
    'content_comment_visibility_rule_desc' => 'Post publication time greater than the number of days, comments will be hidden, 0 means not enabled',
    'content_preview_post_like_users' => 'Post like user preview',
    'content_preview_post_like_users_desc' => 'Preview users who have liked the post, the number represents the number of previews.',
    'content_preview_post_comments' => 'Post comment preview',
    'content_preview_post_comments_desc' => 'Preview comments on the post list page, the number represents the preview quantity.',
    'content_preview_post_comment_require' => 'Post comment preview conditions',
    'content_preview_post_comment_require_desc' => 'Count the number to reach before outputting the preview',
    'content_preview_comment_like_users' => 'Comment like user preview',
    'content_preview_comment_replies' => 'Comment replies preview',
    'content_post_edit_config' => 'Post Editing Permissions',
    'content_post_delete_config' => 'Post Deletion Permissions',
    'content_comment_edit_config' => 'Comment Editing Permissions',
    'content_comment_delete_config' => 'Comment Deletion Permissions',
    'content_edit_desc' => 'Can I edit after publishg?',
    'content_delete_desc' => 'Can I delete after publish?',
    // Operating-Interaction
    'interaction_function_status' => 'Function Status',
    'interaction_operation_name' => 'Operation Name',
    'interaction_user_title' => 'User Title',
    'interaction_public_record' => 'Public Record',
    'interaction_public_count' => 'Public Count',
    'interaction_column_name' => 'Column Name',
    // Operating-Sticker
    'sticker_group' => 'Sticker Group',
    'sticker_table_group_name' => 'Group Name',
    'sticker_table_group_image' => 'Group Image',
    'sticker_table_group_code' => 'Group Code',
    'sticker_table_quantity' => 'Sticker Quantity',
    'sticker_manage' => 'Sticker Manage',
    'sticker_table_image' => 'Sticker Image',
    'sticker_table_code' => 'Sticker Code',
    // Operating-Editor
    'editor_group' => 'Group',
    'editor_title' => 'Title',
    'editor_sticker' => 'Sticker',
    'editor_image' => 'Image',
    'editor_video' => 'Video',
    'editor_audio' => 'Audio',
    'editor_document' => 'Document',
    'editor_mention' => 'Mention',
    'editor_hashtag' => 'Hashtag',
    'editor_extend' => 'Extend',
    'editor_location' => 'Location',
    'editor_anonymous' => 'Anonymous',
    'editor_upload_image_type' => 'Image Upload Form',
    'editor_upload_video_type' => 'Video Upload Form',
    'editor_upload_audio_type' => 'Audio Upload Form',
    'editor_upload_document_type' => 'Document Upload Form',
    'editor_upload_image_number' => 'Max number of upload image',
    'editor_upload_video_number' => 'Max number of upload video',
    'editor_upload_audio_number' => 'Max number of upload audio',
    'editor_upload_document_number' => 'Max number of upload document',
    // Operating-Publish
    'publish_editor_config' => 'Editor Config',
    'publish_editor_function_status' => 'Editor Function Status',
    'publish_editor_function_options' => 'Editor Function Options',
    'publish_post_verify_config' => 'Publish Post Request',
    'publish_comment_verify_config' => 'Publish Comment Request',
    'publish_post_rules_config' => 'Publish Post Rules',
    'publish_comment_rules_config' => 'Publish Comment Rules',
    'publish_editor_desc' => 'Editor for published content',
    'publish_verify_desc' => 'Accounts must be completed with the selected information to be published',
    'publish_rules_desc' => 'All users are valid, priority is greater than the role rule requirements',
    'publish_rule_type' => 'Rule Type',
    'publish_rule_datetime' => 'Date Range',
    'publish_rule_time' => 'Time Range',
    'publish_rule_timezone' => 'Timezone Standard',
    'publish_rule_rule' => 'Rule Request',
    'publish_rule_tip' => 'Rule Tip',
    'publish_edit_time_limit' => 'How Long Can Edit',
    'publish_edit_sticky_limit' => 'After Sticky',
    'publish_edit_digest_limit' => 'After Digest',
    'publish_editor_group_required' => 'Group Required',
    'publish_editor_group_required_desc' => 'When posting, does the group have to select',
    'publish_editor_title_input_box' => 'Title Input Box Display',
    'publish_editor_title_input_box_desc' => 'Optional display requires manual selection by the user before the title input box will be displayed',
    'publish_editor_title_required' => 'Title Required',
    'publish_editor_title_required_desc' => 'When posting, is the title required',
    'publish_editor_title_length' => 'Title Word Limit',
    'publish_editor_title_length_desc' => 'The number of characters in the title must not exceed the set number, with a maximum limit of 255 characters',
    'publish_editor_post_content_length' => 'Post Word Limit',
    'publish_editor_post_content_length_desc' => 'The number of words in the post must not exceed the set number, the minimum upper limit of 140 characters',
    'publish_editor_comment_content_length' => 'Comment Word Limit',
    'publish_editor_comment_content_length_desc' => 'The number of characters in the comment must not exceed the set number, with a minimum limit of 140 characters',
    // Operating-Permission
    'permission_option_email' => 'Email Required',
    'permission_option_phone' => 'Phone Required',
    'permission_option_kyc' => 'KYC Required',
    'permission_option_rule_datetime' => 'Effective within the specified date range',
    'permission_option_rule_time' => 'Recurring daily within a specified time frame',
    'permission_option_review_publish' => 'Can be published, but requires review',
    'permission_option_close_publish' => 'Prohibit publish',
    'permission_option_can_be_edited' => 'Can be edited',
    'permission_option_cannot_be_edited' => 'Cannot be edited',
    'permission_option_can_be_deleted' => 'Can be deleted',
    'permission_option_cannot_be_deleted' => 'Cannot be deleted',
    'permission_option_direct_release' => 'Directly through',
    'permission_option_required_review' => 'Need to review',
    'permission_option_title_optional_display' => 'Optional display',
    'permission_option_title_direct_display' => 'Direct display',
    // Operating-Roles
    'role_table_display' => 'Marking',
    'role_table_nickname_color' => 'Nickname color',
    'role_option_display_icon' => 'Show Icon',
    'role_option_display_text' => 'Show Text',
    'role_option_close_nickname_color' => 'No color used',
    'role_current' => 'Current Role',
    'role_target' => 'Target Role',
    'role_target_desc' => 'After the role is deleted, the users to which the role belongs are merged to the selected target role',
    'role_perm_basic_config' => 'Basic settings',
    'role_perm_post_config' => 'Post Settings',
    'role_perm_comment_config' => 'Comment Settings',
    'role_perm_upload_config' => 'Upload Settings',
    'role_perm_interaction_config' => 'Interaction Settings',
    'role_perm_customize_config' => 'Customized Settings',
    'role_perm_content_view' => 'Browse',
    'role_perm_conversation' => 'Conversation',
    'role_perm_content_link_handle' => 'Link handling for published content',
    'role_perm_content_link_handle_1' => 'Do not resolve and mask domain name',
    'role_perm_content_link_handle_2' => 'Does not resolve but displays as text',
    'role_perm_content_link_handle_3' => 'Normal parsing',
    'role_perm_post_publish' => 'Post Publish',
    'role_perm_post_verify' => 'Post Verify',
    'role_perm_post_review' => 'Post Review',
    'role_perm_post_rules' => 'Post Rules',
    'role_perm_post_time_interval' => 'Post Time Interval',
    'role_perm_post_daily_count' => 'Post Daily Limit',
    'role_perm_post_draft_count' => 'Post Draft Number Limit',
    'role_perm_comment_publish' => 'Comment Publish',
    'role_perm_comment_verify' => 'Comment Verify',
    'role_perm_comment_review' => 'Comment Review',
    'role_perm_comment_rules' => 'Comment Rules',
    'role_perm_comment_time_interval' => 'Comment Time Interval',
    'role_perm_comment_daily_count' => 'Comment Daily Limit',
    'role_perm_comment_draft_count' => 'Comment Draft Number Limit',
    'role_perm_upload_image' => 'Upload Image',
    'role_perm_upload_video' => 'Upload Video',
    'role_perm_upload_audio' => 'Upload Audio',
    'role_perm_upload_document' => 'Upload Document',
    'role_perm_upload_file_desc' => 'Checking the box means that you have the right to upload, leaving the input box blank uses the set value of the storage configuration as the default parameter',
    'role_perm_follow_user_max_count' => 'Follow User Max Count',
    'role_perm_block_user_max_count' => 'Block User Max Count',
    'role_perm_download_file_count' => 'Download limit within 24 hours',
    'role_perm_table_name' => 'Permission Key',
    'role_perm_table_value' => 'Permission Value',
    // Operating-Groups
    'group_table_parent_group' => 'Parent Group',
    'group_table_subgroup' => 'Subgroup',
    'group_table_privacy' => 'Privacy',
    'group_table_visibility' => 'Visibility',
    'group_table_follow_method' => 'Follow Method',
    'group_table_recommend' => 'Recommend',
    'group_table_admins' => 'Group Admins',
    'group_table_can_publish' => 'Can Publish',
    'group_table_post_permissions' => 'Post Permissions',
    'group_table_comment_permissions' => 'Comment Permissions',
    'group_table_publish_perm_role' => 'Empowered Roles',
    'group_table_publish_perm_review' => 'Review Required',
    'group_table_publish_perm_review_desc' => 'No restrictions on group administrators',
    'group_public_desc' => 'Public (Anyone can see who\'s in the group and what they post.)',
    'group_private_desc' => 'Private (Only members can see who\'s in the group and what they post.)',
    'group_visible_desc' => 'Visible (Anyone can find this group.)',
    'group_hidden_desc' => 'Hidden (Only members can find this group.)',
    'group_publish_option_all' => 'Everyone',
    'group_publish_option_members' => 'Only members of the group',
    'group_publish_option_roles' => 'Assigned role users only',
    'group_publish_option_admins' => 'Group administrators only',
    'group_can_publish_desc' => 'Closing publishing permissions can be used as a group categorization',
    'group_current' => 'Current Group',
    'group_target' => 'Target Group',
    'group_target_desc' => 'After the merger the old group will be deleted and the content belonging to the old group will be migrated to the selected target group',
    // Extends
    'extend_editor_menus' => 'Menus',
    'extend_editor_toolbar' => 'Toolbar',
    'extend_editor_number_of_uses_desc' => 'Take the "Voting" plugin for example, the number of 2 means that a post can be accompanied by 2 voting',
    'extend_content_service' => 'Content Service',
    'extend_content_list' => 'Content List',
    'extend_content_detail' => 'Content Details',
    'extend_content_search' => 'Content Search',
    'extend_content_list_desc' => 'This configuration has a higher priority than the content type configuration, and when configured, the data source specified by the content type will be replaced.',
    'extend_content_ip' => 'IP Service',
    'extend_content_map' => 'Map Service',
    'extend_content_notifications_service' => 'Notifications Service',
    'extend_content_review' => 'Review Service',
    'extend_content_list_by_all' => 'All Posts or Comments',
    'extend_content_list_by_timelines' => 'Timelines posts or comments',
    'extend_content_list_by_nearby' => 'Nearby posts or comments',
    'extend_content_by_detail' => 'Post or Comment Detail',
    'extend_content_search_users' => 'Search Users',
    'extend_content_search_groups' => 'Search Groups',
    'extend_content_search_hashtags' => 'Search Hashtags',
    'extend_content_search_geotags' => 'Search Geotags',
    'extend_content_search_posts' => 'Search Posts',
    'extend_content_search_comments' => 'Search Comments',
    // Client-Channels
    'channel_default_homepage' => 'Default Homepage',
    'channel_table_channel' => 'Channel',
    'channel_table_page' => 'Page',
    'channel_table_page_home' => 'Home',
    'channel_table_page_list' => 'List',
    'channel_table_page_detail' => 'Detail',
    'channel_table_page_interaction' => 'Interaction',
    'channel_table_path' => 'Path',
    'channel_table_seo' => 'SEO Info',
    'channel_table_seo_title' => 'SEO Title',
    'channel_table_seo_description' => 'SEO Description',
    'channel_table_seo_keywords' => 'SEO Keywords',
    'channel_table_query_state' => 'Client Query Param',
    'channel_table_query_state_desc' => 'Whether or not to accept client-side passes, when turned off only the default parameter values will be supported',
    'channel_table_query_config' => 'Default Parameter',
    'channel_table_query_config_desc' => 'Refer to the API Query parameters of this interface',
    'channel_query_state_1' => 'No client parameters accepted',
    'channel_query_state_2' => 'Accept client paging parameters only',
    'channel_query_state_3' => 'Accept all parameters',
    // Client-Columns
    'channel_timeline' => 'Timeline',
    'channel_timeline_all_posts' => 'All Followed Posts ',
    'channel_timeline_user_posts' => 'I follow users posts',
    'channel_timeline_group_posts' => 'I follow groups posts',
    'channel_timeline_hashtag_posts' => 'I follow hashtags posts',
    'channel_timeline_geotag_posts' => 'I follow geotags posts',
    'channel_timeline_all_comments' => 'All followed comments',
    'channel_timeline_user_comments' => 'I follow users comments',
    'channel_timeline_group_comments' => 'I follow groups comments',
    'channel_timeline_hashtag_comments' => 'I follow hashtags comments',
    'channel_timeline_geotag_comments' => 'I follow geotags comments',
    'channel_nearby' => 'Nearby',
    'channel_nearby_posts' => 'Posts by Nearby',
    'channel_nearby_comments' => 'Comments by Nearby',
    'channel_me' => 'Personal Center',
    'channel_me_extcredits' => 'Extcredits',
    'channel_me_wallet' => 'Wallet',
    'channel_me_drafts' => 'Drafts',
    'channel_me_users' => 'Users',
    'channel_me_settings' => 'Settings',
    'channel_messages' => 'Messages',
    'channel_conversations' => 'Conversations',
    'channel_notifications' => 'Notifications',
    'channel_notifications_all' => 'Notifications-All',
    'channel_notifications_systems' => 'Notifications-Systems',
    'channel_notifications_recommends' => 'Notifications-Recommends',
    'channel_notifications_likes' => 'Notifications-Likes',
    'channel_notifications_dislikes' => 'Notifications-Dislikes',
    'channel_notifications_follows' => 'Notifications-Follows',
    'channel_notifications_blocks' => 'Notifications-Blocks',
    'channel_notifications_mentions' => 'Notifications-Mentions',
    'channel_notifications_comments' => 'Notifications-Comments',
    'channel_notifications_quotes' => 'Notifications-Quotes',
    'channel_search' => 'Search',
    // Client-Keys
    'key_table_read_only' => 'Read Only',
    'key_select_platform' => 'Select a key application platform',
    'key_option_main_api' => 'Main API',
    'key_option_manage_api' => 'Manage API',
    'key_option_plugin_api' => 'Plugin API',
    'key_option_plugin_api_select' => 'Select the key for which plugin',
    'key_option_plugin_api_select_desc' => 'This key can only request the API of the associated plugin',
    // Client-Basic
    'website_stat_code' => 'Site Stat Code',
    'website_stat_code_desc' => 'The use of statistical code containing document.write is not supported.',
    'website_stat_position' => 'Stat code location',
    'website_stat_position_desc' => 'Where the stat code is loaded into the HTML.',
    'china_mode' => 'China Mode',
    'china_mode_desc' => 'Required information when the site server is deployed in China.',
    'china_mode_config' => 'China Server Configuration (not required)',
    'china_icp_filing' => 'Internet Content Provider Filing',
    'china_icp_license' => 'Internet Content Provider License',
    'china_mps_filing' => 'Public Security Bureau Filing',
    'china_broadcasting_license' => 'Broadcasting License',
    // Client-Status
    'client_status_desc' => 'Client request status configuration every 10 minutes',
    // App-Center-Themes
    'website_engine_config' => 'Engine Config',
    'website_engine_api_config' => 'API Config',
    'website_engine_status' => 'Engine Status',
    'website_engine_api_type' => 'Engine API Type',
    'website_engine_key_id' => 'Select App Key',
    'website_engine_view_desktop' => 'Desktop',
    'website_engine_view_mobile' => 'Mobile',
    // App-Center-Install
    'install_website_engine' => 'Install Website Engine',
    'install_plugin' => 'Install Plugin',
    'install_application' => 'Install App',
    'install_mode' => 'Install Mode',
    'install_mode_fskey' => 'Input Fresns Key',
    'install_mode_upload' => 'Upload Zip Package',
    'install_mode_directory' => 'Input Directory Path',
    'download_application' => 'Download App',
];
