<?php

/*
 * Fresns (https://fresns.org)
 * Copyright (C) 2021-Present Jevan Tang
 * Released under the Apache-2.0 License.
 */

return [

    /*
    |--------------------------------------------------------------------------
    | Fresns Panel Language Lines
    |--------------------------------------------------------------------------
    */

    'fresns_panel' => 'Fresns-Bedienfeld',
    'fresns_core' => 'Fresns Core',
    // Login page
    'language' => 'Sprache',
    'login' => 'Anmeldung',
    'account' => 'Konto',
    'password' => 'Passwort',
    'enter' => 'Eingeben',
    'operation' => 'Bedienung des Bedienfelds',
    'site_home' => 'Website Startseite',
    'switch_language' => 'Schalter Sprache',
    'logout' => 'Ausloggen',
    // Header menus
    'menu_dashboard' => 'Armaturenbrett',
    'menu_systems' => 'Systeme',
    'menu_operations' => 'Operationen',
    'menu_extends' => 'Erweitert',
    'menu_clients' => 'Kunden',
    'menu_app_center' => 'App-Zentrum',
    'menu_marketplace' => 'Marketplace',
    // Sidebar menus
    'sidebar_home' => 'Zuhause',
    'sidebar_admins' => 'Admins',
    'sidebar_events' => 'Veranstaltungen',
    'sidebar_events_tab_subscribe' => 'Abonnieren',
    'sidebar_events_tab_crontab' => 'Crontab',
    'sidebar_caches' => 'Caches',
    'sidebar_caches_tab_config' => 'Konfigurations-Cache',
    'sidebar_caches_tab_data' => 'Daten-Cache',
    'sidebar_upgrades' => 'Upgrades',
    'sidebar_settings' => 'Einstellungen',
    'sidebar_languages' => 'Sprachen',
    'sidebar_storage' => 'Lager',
    'sidebar_storage_tab_image' => 'Bild',
    'sidebar_storage_tab_video' => 'Video',
    'sidebar_storage_tab_audio' => 'Audio',
    'sidebar_storage_tab_document' => 'Dokumentieren',
    'sidebar_storage_tab_substitution' => 'Auswechslung',
    'sidebar_general' => 'Allgemein',
    'sidebar_policy' => 'Politik',
    'sidebar_policy_tab_options' => 'Optionen',
    'sidebar_policy_tab_contents' => 'Inhalt',
    'sidebar_send' => 'Schicken',
    'sidebar_send_tab_services' => 'Dienstleistungen senden',
    'sidebar_send_tab_templates' => 'Überprüfen Sie Codevorlagen',
    'sidebar_account' => 'Konto',
    'sidebar_wallet' => 'Brieftasche',
    'sidebar_wallet_tab_options' => 'Optionen',
    'sidebar_wallet_tab_recharge_services' => 'Aufladungsdienste',
    'sidebar_wallet_tab_withdraw_services' => 'Dienstleistungen abheben',
    'sidebar_user' => 'Benutzer',
    'sidebar_content' => 'Inhalt',
    'sidebar_interaction' => 'Interaktion',
    'sidebar_publish' => 'Veröffentlichen',
    'sidebar_publish_tab_post' => 'Post',
    'sidebar_publish_tab_comment' => 'Kommentar',
    'sidebar_roles' => 'Rollen',
    'sidebar_stickers' => 'Aufkleber',
    'sidebar_groups' => 'Gruppen',
    'sidebar_groups_tab_active' => 'Aktiv',
    'sidebar_groups_tab_deactivate' => 'Inaktiv',
    'sidebar_groups_tab_recommend' => 'Nur empfohlene Ansicht anzeigen',
    'sidebar_extend_editor' => 'Editor',
    'sidebar_extend_content_type' => 'Inhaltstyp',
    'sidebar_extend_content_handler' => 'Content Handler',
    'sidebar_extend_manage' => 'Verwalten',
    'sidebar_extend_group' => 'Gruppe',
    'sidebar_extend_group_filter' => 'Filter',
    'sidebar_extend_user_feature' => 'Benutzerfunktion',
    'sidebar_extend_user_profile' => 'Benutzerprofil',
    'sidebar_extend_channel' => 'Kanal',
    'sidebar_extend_command_words' => 'Befehlswörter',
    'sidebar_channels' => 'Kanäle',
    'sidebar_paths' => 'Pfad',
    'sidebar_language_packs' => 'Sprachpakete',
    'sidebar_code_messages' => 'Code-Meldungen',
    'sidebar_client_basic' => 'Basic',
    'sidebar_client_status' => 'Status',
    'sidebar_plugins' => 'Plugins',
    'sidebar_plugins_tab_all' => 'Alle',
    'sidebar_plugins_tab_active' => 'Aktiv',
    'sidebar_plugins_tab_inactive' => 'Inaktiv',
    'sidebar_themes' => 'Themen',
    'sidebar_apps' => 'Apps',
    'sidebar_keys' => 'App-Tasten',
    // Sidebar intro
    'sidebar_admins_intro' => 'Benutzer, die das Recht haben, sich bei der Systemsteuerung anzumelden',
    'sidebar_events_intro' => 'Zeitgesteuerte Aufgaben und Abonnement-Ereignisse auf dem System anzeigen',
    'sidebar_caches_intro' => 'Wenn Sie den gesamten Cache löschen, kann dies zu einer höheren Belastung des Servers führen, daher sollten Sie Stoßzeiten vermeiden.',
    'sidebar_upgrades_intro' => 'Endlich',
    'sidebar_settings_intro' => 'Bitte löschen Sie den Cache, wenn die Konfiguration abgeschlossen ist, oder warten Sie 10 Minuten, bis der neue Cache wirksam wird.',
    'sidebar_languages_intro' => 'Multi-Sprache muss hier Sprachoptionen konfigurieren, bevor Sie mehrsprachige Inhalte in das entsprechende Konfigurationselement eingeben können',
    'sidebar_storage_intro' => 'Vier Ressourcendateien können separat gespeichert oder gleich gespeichert werden, füllen Sie einfach die Speicherkonfigurationsinformationen aus',
    'sidebar_general_intro' => 'Sichern Sie die Einstellungselemente des laufenden Systems',
    'sidebar_policy_intro' => 'Entsprechend den relevanten Daten gesetzlichen Bestimmungen im Land des Zielmarktes',
    'sidebar_send_intro' => 'Messaging und andere Nachrichten wie E-Mail-SMS und Systembenachrichtigungen',
    'sidebar_account_intro' => 'Einstellungen der Kontocenterfunktion',
    'sidebar_wallet_intro' => 'Die Brieftasche ist eine echte monetäre Funktion, wenn Sie eine virtuelle integrierte Funktion benötigen, installieren Sie das entsprechende Plugin',
    'sidebar_wallet_tab_recharge_services_intro' => 'Die Aufladungsdienstanbieterkonfiguration wird in der Funktion "Geldbörse" für Zahlungsaufträge gerendert oder die Geldbörse aufladen',
    'sidebar_wallet_tab_withdraw_services_intro' => 'Die Dispense-Service Provider-Konfiguration ist in der Funktion "Geldbörsen" vorhanden, die für den Wallet-Kontostand verwendet wird, um das angegebene Konto in Rechnung zu stellen',
    'sidebar_user_intro' => 'Benutzer grundlegende Funktionseinstellungen',
    'sidebar_content_intro' => 'Konfiguration von Namen und Funktionen für soziale Inhalte',
    'sidebar_interaction_intro' => 'Die Wahrnehmung des Benutzers von der Dienstleistung eines Produktes (Gefühl der Erfahrung) hängt nicht von der technischen Logik ab, sondern von der Benennung der Funktionspunkte.',
    'sidebar_publish_intro' => 'Diese Konfiguration gilt für alle Mitglieder, und die Prioritätspriorität ist größer als Benutzerrollenberechtigungen',
    'sidebar_roles_intro' => 'Die Rolle kann bestimmte Einstellungen für Benutzeridentität und Berechtigungen festlegen',
    'sidebar_stickers_intro' => 'Benutzerdefinierte Konfiguration Emotivieren, im Falle der Konfiguration können Benutzer auch EMOJI-Ausdrücke über die EMOKER-Tastatur eingeben',
    'sidebar_groups_intro' => 'Die Anwendungsgruppe kann verschiedene Betriebsszenarien wie BBS-Projekte, Gemeinschaftskreise, Inhaltsklassifizierung realisieren',
    'sidebar_extend_editor_intro' => 'Im "Editor" des Release-Prozesses ermöglicht beispielsweise die Erweiterung "Abstimmung" dem "Editor", um die Abstimmungsfunktion zu unterstützen, die den Beitrag begleitet',
    'sidebar_extend_content_type_intro' => 'Der Beitrag wird in der Liste "Post" dargestellt, die verwendet wird, um die angegebene Nachricht "Typ" auszugeben und die Datenquelle zu definieren',
    'sidebar_extend_content_handler_intro' => 'Die Funktion ist derselbe wie die Datenquellenfunktion "Inhaltstypverlängerung", unabhängig davon, ob die Anforderung an die Plugin-Verarbeitung verteilt ist, und die Datenlogik wird vom Plugin bestimmt',
    'sidebar_extend_manage_intro' => 'In der "mehr" -Funktionsliste des Beitrags, der Kommentare, der Benutzerhomepage, z. B. die Erweiterung "Beschwerde", können Benutzer die entsprechenden Ziele beschweren',
    'sidebar_extend_group_intro' => 'Die Präsentation wird auf der Startseite "Gruppen", z. B. "Pure Link Extension Plugin", einen Hyperlink in der Startseite "Group" anzeigen',
    'sidebar_extend_user_feature_intro' => 'Die Seite "Meine" wird im "User Center" angezeigt, z. B. "Wallet" -Unternehmen, ermöglicht dem Benutzer mehr Geldbörsenfunktion',
    'sidebar_extend_user_profile_intro' => 'In der Liste der Verwaltungsfunktionen "Benutzerinformationen", z. B. "MODIFY-Benutzername-Plug-In", können die Änderungsinformationen die Änderung des Benutzernamens unterstützen',
    'sidebar_extend_channel_intro' => 'Er wird im Hauptmenü oder in einer Liste von Kanalseiten angezeigt, z. B. ermöglicht die Erweiterung Shopping dem Benutzer den Zugriff auf den Kanal Mall.',
    'sidebar_extend_command_words_intro' => 'Die in dieser Liste konfigurierten Befehlswörter sind für API-Anfragen verfügbar.',
    'sidebar_channels_intro' => 'Einheitliche Konfiguration der individuellen Kanalinformationen des Kunden.',
    'sidebar_paths_intro' => 'Benutzerdefinierte Pfadstrukturen können die Ästhetik, Benutzerfreundlichkeit und Vorwärtskompatibilität Ihrer Links verbessern.',
    'sidebar_language_packs_intro' => 'Konfigurieren Sie mehrsprachige Inhalte jedes Textes für mehrsprachige Clients',
    'sidebar_code_messages_intro' => 'Mehrsprachige Beschreibung der für das Hauptprogramm und die Plug-ins konfigurierten Statuscodes.',
    'sidebar_client_basic_intro' => 'Allgemeine Konfigurationselemente für die Kundenbasis.',
    'sidebar_client_status_intro' => 'Nach der Deaktivierung werden alle Seiten und Aktionen des Clients auf die Seite mit den Deaktivierungsanweisungen umgeleitet.',
    'sidebar_plugins_intro' => 'Flexible Funktionen, leistungsstarke Erweiterungen helfen Ihnen, frei zu spielen',
    'sidebar_themes_intro' => 'Wählen Sie verschiedene Themen aus, um mehr personalisierte Stil und Interaktion zu erzielen',
    'sidebar_apps_intro' => 'Standard-APIs, leistungsstarke Erweiterungen, Erstellung einer Vielzahl von Betriebsszenarien und Anwendungsmodellen nach Belieben.',
    'sidebar_keys_intro' => 'Die wichtigsten Anmeldeinformationen sind wichtig, offenbaren sie nicht leicht an andere',
    // Page button
    'button_support' => 'Unterstützung',
    'button_update' => 'Aktualisieren',
    'button_search' => 'Suche',
    'button_add' => 'Addieren',
    'button_edit' => 'Bearbeiten',
    'button_modify' => 'Ändern',
    'button_delete' => 'Löschen',
    'button_cancel' => 'Stornieren',
    'button_close' => 'Schließen',
    'button_dismiss' => 'Entlassen',
    'button_activate' => 'aktivieren Sie',
    'button_deactivate' => 'Deaktivieren',
    'button_install' => 'Installieren',
    'button_uninstall' => 'Deinstallieren',
    'button_setting' => 'Einstellung',
    'button_config' => 'Konfigurieren Sie',
    'button_reset' => 'Zurücksetzen',
    'button_confirm' => 'Bestätigen Sie',
    'button_try_again' => 'Erneut versuchen',
    'button_save' => 'Speichern',
    'button_download' => 'Herunterladen',
    'button_upgrade' => 'Aktualisieren',
    'button_automatic_upgrade' => 'Auto Upgrade',
    'button_manual_upgrade' => 'Manuelles Upgrade',
    'button_confirm_delete' => 'Löschen bestätigen',
    'button_confirm_install' => 'Bestätigen Sie die Installation',
    'button_confirm_upgrade' => 'Aktualisierung bestätigen',
    'button_confirm_download' => 'Bestätigen Sie den Download',
    'button_confirm_uninstall' => 'Deinstallation bestätigen',
    'button_view' => 'Sicht',
    'button_image_upload' => 'Hochladen',
    'button_image_input' => 'Eingang',
    'button_check_upgrade' => 'Überprüfen Sie das Upgrade',
    'button_check_status' => 'Status prüfen',
    'button_batch_import' => 'Importieren',
    'button_batch_export' => 'Export',
    'button_config_email_template' => 'E-Mail-Vorlage konfigurieren',
    'button_config_sms_template' => 'SMS-Vorlage config',
    'button_config_sticker' => 'Config-Aufkleber',
    'button_config_permission' => 'Konfigurationsberechtigung',
    'button_config_language_pack' => 'Konfigurationspaket',
    'button_add_admin' => 'Addin addieren',
    'button_add_language' => 'Lang hinzufügen',
    'button_add_account_connect' => 'Konto hinzufügen Connect',
    'button_add_service_provider' => 'Service hinzufügen',
    'button_add_sticker_group' => 'Aufklebergruppe hinzufügen',
    'button_add_sticker' => 'Aufkleber hinzufügen',
    'button_add_role' => 'Rolle hinzufügen',
    'button_add_group' => 'Gruppe hinzufügen',
    'button_group_move' => 'Umzug',
    'button_add_key' => 'Schlüssel hinzufügen',
    'button_reset_key' => 'Taste zurücksetzen',
    'button_reset_secret' => 'Sensibles zurücksetzen',
    'button_clear_cache' => 'Cache löschen',
    'button_clear_all_cache' => 'Alle Caches löschen',
    // Page table
    'table_order' => 'Reihenfolge Sortieren',
    'table_recommend_order' => 'Empfehlen Sortierung',
    'table_position' => 'Standort',
    'table_number' => 'Anzahl',
    'table_lang_tag' => 'Lang Tag',
    'table_lang_name' => 'Lang Name',
    'table_title' => 'Titel',
    'table_content' => 'Inhalt',
    'table_platform' => 'Plattform',
    'table_service' => 'Bedienung',
    'table_app_id' => 'App-ID',
    'table_app_key' => 'App-Key',
    'table_app_secret' => 'App Secret',
    'table_plugin' => 'Plugin',
    'table_command_word' => 'Befehlswort',
    'table_name' => 'Name',
    'table_description' => 'Beschreibung',
    'table_icon' => 'Symbol',
    'table_banner' => 'Banner',
    'table_type' => 'Art',
    'table_use' => 'Verwenden',
    'table_support' => 'Unterstützung',
    'table_data_source' => 'Datenquelle',
    'table_scene' => 'Szene',
    'table_number_of_uses' => 'Anzahl der Anwendungen',
    'table_scope' => 'Zielfernrohr',
    'table_scope_global' => 'Global',
    'table_scope_global_desc' => 'Kann auf bestimmte Rollen beschränkt sein',
    'table_scope_group_admins' => 'Gruppen-Admins',
    'table_scope_group_admins_desc' => 'Wenn aktiviert, werden nur Gruppenadministratoren das Plugin angezeigt',
    'table_authorized_roles' => 'Autorisierte Rollen',
    'table_authorized_roles_desc' => 'Lassen Sie leer, um anzuzeigen, dass alle Benutzerrollen berechtigt sind',
    'table_whitelist_rules' => 'Weiße Listenrolle',
    'table_parameter' => 'Parameter',
    'table_status' => 'Status',
    'table_options' => 'Optionen',
    // Config option
    'option_default' => 'Standard',
    'option_all' => 'Alle',
    'option_public' => 'Öffentlich',
    'option_private' => 'Privat',
    'option_visible' => 'Sichtbar',
    'option_hidden' => 'Versteckt',
    'option_open' => 'Offen',
    'option_close' => 'Nah dran',
    'option_yes' => 'Jawohl',
    'option_no' => 'Nein',
    'option_activate' => 'aktivieren Sie',
    'option_deactivate' => 'Deaktivieren',
    'option_local' => 'Lokal',
    'option_remote' => 'Fern',
    'option_required' => 'Erforderlich',
    'option_not_required' => 'Nicht benötigt',
    'option_not_set' => 'Nicht eingestellt',
    'option_no_use' => 'Keine Verwendung',
    'option_unselect' => 'abwählen',
    'option_optional' => 'Optional',
    'option_email' => 'Email',
    'option_sms' => 'SMS',
    'option_data_close' => 'Nicht öffentlich',
    'option_data_private' => 'Nur ich',
    'option_data_public' => 'Öffentlich',
    'option_type_tree' => 'Baum',
    'option_type_list' => 'Liste',
    'option_uninstall_plugin_data' => 'Gleichzeitige Löschung der Plugin-Daten',
    'option_uninstall_theme_data' => 'Gleichzeitige Löschung der Themendaten',
    // Commons
    'portal' => 'Portal',
    'user' => 'Benutzer',
    'group' => 'Gruppe',
    'hashtag' => 'Hashtag',
    'geotag' => 'Geotag',
    'post' => 'Post',
    'comment' => 'Kommentar',
    'file' => 'Datei',
    'extend' => 'Inhalt erweitern',
    'user_detail' => 'Benutzer Home',
    'group_detail' => 'Gruppe Detail',
    'hashtag_detail' => 'Hashtag Detail',
    'geotag_detail' => 'Geotag Detail',
    'post_detail' => 'Beitrag Detail',
    'comment_detail' => 'Kommentar Detail',
    'like' => 'Wie',
    'dislike' => 'Ablehnen',
    'follow' => 'Folgen',
    'block' => 'Blockieren',
    'author' => 'Autor',
    'new_version' => 'Neu',
    'default_language' => 'Standardsprache',
    'default_list' => 'Standard-Liste',
    'recommend' => 'Weiterempfehlen',
    'unit_day' => 'Tag',
    'unit_length' => 'Länge',
    'unit_second' => 'Sekunde',
    'unit_minute' => 'Minute',
    'unit_within_minute' => 'Innerhalb Minute',
    'unit_character' => 'Charakter',
    'unit_number' => 'Nummer',
    'unit_number_of_times' => 'Anzahl der Male',
    'unit_kilometer' => 'Kilometer',
    'unit_mile' => 'Meile',
    'config_default' => 'Standard-Konfiguration',
    'config_name' => 'Name Konfig',
    'config_edit' => 'Konfig bearbeiten',
    'config_interaction' => 'Interaktion Konfig',
    'config_conversation' => 'Konversations-Konfiguration',
    'config_hashtag' => 'Hashtag-Konfiguration',
    'config_list' => 'Liste Konfig',
    'config_preview' => 'Vorschau Konfig.',
    'config_manage' => 'Verwalten Konfig',
    'delete_desc' => 'Sicher zu löschen?',
    // Dashboard-Home
    'welcome' => 'Willkommen bei Fresns',
    'current_version' => 'Die aktuelle Version ist',
    'overview' => 'Standortdaten',
    'overview_accounts' => 'Konten',
    'overview_users' => 'Benutzer',
    'overview_groups' => 'Gruppen',
    'overview_hashtags' => 'Hashtags',
    'overview_geotags' => 'Geotags',
    'overview_posts' => 'Beiträge',
    'overview_comments' => 'Kommentare',
    'extensions' => 'Antragsmenge',
    'support' => 'Hilfehandbuch',
    'support_website' => 'Fresns offizielle Website',
    'support_teams' => 'Open Source Team',
    'support_sponsor' => 'Förderer',
    'support_join' => 'begleiten Sie uns',
    'support_community' => 'Unterstützungsgemeinschaft',
    'support_marketplace' => 'Anwendungsmarkt',
    'system_info' => 'Systemnachricht',
    'system_info_server' => 'Serversystem',
    'system_info_web' => 'Netzlaufumgebung',
    'system_info_php_version' => 'PHP version',
    'system_info_php_cli_info' => 'PHP Cli infos',
    'system_info_php_upload_max_filesize' => 'Maximale Dateigröße hochladen',
    'system_info_composer_info' => 'Composer infos',
    'system_info_composer_version' => 'Composer version',
    'system_info_env_timezone' => '.env Zeitzone',
    'system_info_env_timezone_name' => '.env Zeitzonenbezeichner',
    'system_info_env_timezone_utc' => '.env UTC-Zeitzone des Zeitzonenbezeichners',
    'system_info_env_timezone_list' => 'Identifikator der übereinstimmenden Zeitzone',
    'system_info_database_driver' => 'Datenbank-Treiber',
    'system_info_database_version' => 'Datenbankversion',
    'system_info_database_timezone' => 'Datenbank Zeitzone',
    'system_info_database_engine' => 'Datenbestandmotor',
    'system_info_database_collation' => 'Datenbanksortierregeln',
    'system_info_database_size' => 'Aktuelle Datenbankgröße',
    'tips' => 'Anweisungen für den Gebrauch',
    'news' => 'Fresns-Aktivitäten und Nachrichten',
    // Dashboard-Events
    'event_subscribe_subject' => 'Thema',
    'event_crontab_time' => 'Zyklus der Ausführung',
    'event_crontab_time_desc' => 'Laravel-Aufgabenplanung Cron-Tabellenformat',
    // Dashboard-Caches
    'cache' => 'Cache',
    'cache_fresns_system' => 'System-Konfiguration',
    'cache_fresns_config' => 'Standort-Konfiguration',
    'cache_fresns_extend' => 'Konfig. erweitern',
    'cache_fresns_view' => 'Ansicht',
    'cache_fresns_route' => 'Weiterleitung',
    'cache_fresns_event' => 'Ereignis',
    'cache_fresns_schedule' => 'Zeitplan',
    'cache_fresns_temporary' => 'Vorläufige Daten',
    // Dashboard-Admins
    'admin_add_title' => 'Neuer Systemadministrator',
    'admin_add_form_account' => 'Konto',
    'admin_add_form_account_placeholder' => 'E-Mail oder Handynummer',
    'admin_add_form_account_desc' => 'Die Mobiltelefonnummer muss eine vollständige Nummer mit dem internationalen Vorwahl sein',
    'admin_add_form_account_btn' => 'Suche und Erhöhung',
    // Dashboard-Settings
    'setting_developer_options' => 'Optionen für Entwickler',
    'setting_developer_options_desc' => 'Deaktivieren Sie die Optionen nicht, wenn es sich nicht um eine Entwicklungsumgebung handelt.',
    'setting_build_type' => 'Version Typ',
    'setting_build_type_desc' => 'Die Beta-Version ist weniger stabil, bitte wählen Sie sie daher mit Bedacht aus.',
    'setting_build_select_tip' => 'Wählen Sie den Typ der Upgrade-Version',
    'setting_build_option_stable' => 'Stable Build',
    'setting_build_option_beta' => 'Beta Build',
    'setting_system_url' => 'System URL',
    'setting_system_url_desc' => 'Standard-Zugangsadressen für die Haupt-API und Plugins',
    'setting_panel_path' => 'Sichere Einreise',
    'setting_panel_path_desc' => 'Nach dem Einstellen können Sie sich nur an der Systemsteuerung anmelden, indem Sie den Sicherheitseintrag angeben',
    'setting_panel_url' => 'Eingang vollständige Adresse',
    'setting_panel_url_desc' => 'Control Panel Anmeldeeintrag Complete URL',
    'setting_panel_url_copy' => 'Kopieren',
    // System-Languages
    'language_multilingual' => 'mehrsprachig',
    'language_table_default' => 'Standardsprache',
    'language_table_langCode' => 'Sprachcode',
    'language_table_areaCode' => 'Bereichscodes',
    'language_table_langName' => 'Sprache Name',
    'language_table_areaName' => 'Name des Regionen',
    'language_table_lengthUnit' => 'Längeneinheit',
    'language_table_writingDirection' => 'Schreibrichtung',
    'language_table_area' => 'Sprachgebiet',
    'language_table_dateFormat' => 'Datumsformat',
    'language_table_dateFormat_desc' => 'JJJJ, JAHR, MM Der Monat sagte, dd bedeutet den Himmel',
    'language_table_timeFormat' => 'Menschliche Zeit',
    'language_table_timeFormat_desc' => 'Zeitvariablenname {n}',
    'language_select_langCode' => 'Sprachcode auswählen',
    'language_select_continent' => 'Kontinent',
    'language_select_areaCode' => 'Wählen Sie den regionalen Code aus',
    // System-General
    'site_url' => 'Seiten-URL',
    'site_url_desc' => 'Haupt-URL der Website',
    'site_name' => 'Site-Name',
    'site_name_desc' => 'Der Name Ihrer Fresns-Site',
    'site_intro' => 'Site-Einführung',
    'site_intro_desc' => 'Einführung in Ihre Fresns-Site',
    'site_logo' => 'Standortschild',
    'site_logo_desc' => 'Die Informationen in "Speichereinstellungen" müssen konfiguriert sein, um das Bild hochzuladen',
    'site_copyright' => 'Urheberrechtsinformation',
    'site_email' => 'Administrator-Postfach',
    'site_email_desc' => 'Wenn Sie einen Fehler ausführen, zeigen Sie den Benutzer, um das Feedback des Benutzers zu erleichtern',
    'site_mode' => 'Betriebsmodus',
    'site_mode_public' => 'Veröffentlichungsmodus',
    'site_mode_private' => 'Privater Modus',
    'site_mode_private_desc' => 'Privatmodus-Konfiguration',
    'site_mode_private_join_status' => 'Ist es offen nach außen?',
    'site_mode_private_join_service' => 'Verbinden Sie dem Kanal-Support-Plugin',
    'site_mode_private_content_policy' => 'Privat abgelaufener Zustand',
    'site_mode_private_content_policy_1' => 'Standortinhalt ist nicht sichtbar',
    'site_mode_private_content_policy_2' => 'Inhalt Vor dem Ablauf ist der neue Inhalt unsichtbar',
    // System-Policy
    'policy_terms' => 'Nutzungsbedingungen',
    'policy_privacy' => 'Datenschutz-Bestimmungen',
    'policy_cookie' => 'Cookie-Politik',
    'policy_delete_account' => 'Anweisungen des Logouts',
    'policy_delete_options' => 'Logout-Funktion',
    'policy_delete_options_desc' => 'Der Benutzer kann das Logout (Wiederherstellungskonto) innerhalb des Puffertags widerrufen, und der Stornierungsvorgang wird ohne Rückgängigmachen ausgeführt',
    'policy_delete_option_1' => 'Aktivieren Sie die Logout-Funktion nicht',
    'policy_delete_option_2' => 'Logisches Login',
    'policy_delete_option_2_desc' => 'Logic-Logout: Nur in der Datenbank wird in der Datenbank benachrichtigt, trifft dies nicht zu, um die Daten zu löschen',
    'policy_delete_option_3' => 'Körperliche Stornierung',
    'policy_delete_option_3_desc' => 'Physikalisches Logout: Physikalische Löschdaten, Benutzerdaten und veröffentlichte Inhalte werden wirklich gelöscht',
    'policy_delete_crontab' => 'Logout-Zyklus',
    // System-Send
    'send_email_config' => 'Postfach-Konfiguration',
    'send_sms_config' => 'SMS-Konfiguration',
    'send_sms_default_code' => 'Standard-Internationaler Vorwahl',
    'send_sms_supported_codes' => 'Unterstützen Sie mehr Vorwahlcode',
    'send_sms_desc' => 'Eine Zeile, Der leere Vertreter unterstützt nur ein einziges Land. Bitte bestätigen Sie den Dienstanbieter unterstützen die internationale SMS-Funktion vor der Konfiguration',
    'send_app_notifications' => 'Push-Benachrichtigungsdienst',
    'send_app_ios_config' => 'iOS-Konfiguration',
    'send_app_ios_notifications_desc' => 'IOS-System-Popup-Benachrichtigungsfunktion',
    'send_app_android_config' => 'Android-Konfiguration',
    'send_app_android_notifications_desc' => 'Android-System-Popup-Benachrichtigungsfunktion',
    'send_app_desktop_config' => 'Desktop-Konfiguration',
    'send_app_desktop_notifications_desc' => 'Desktop-Benachrichtigungsfunktionen, wie z. B. Browser-Benachrichtigungen.',
    'send_code_template_1' => 'Allgemeine Bestätigungscode',
    'send_code_template_2' => 'Ein neues Konto eröffnen',
    'send_code_template_3' => 'Kontoinformationen ändern',
    'send_code_template_4' => 'Neue Bindung ersetzen',
    'send_code_template_5' => 'Login-Passwort zurücksetzen',
    'send_code_template_6' => 'Zahlungskennwort zurücksetzen',
    'send_code_template_7' => 'Melden Sie sich mit einem Bestätigungscode an',
    'send_code_template_8' => 'Konto mit Verifizierungscode löschen',
    'send_code_template_table_email_desc' => 'HTML-Format unterstützen',
    'send_code_template_table_sms_sign' => 'Name des SMS',
    'send_code_template_table_sms_code' => 'Vorlagenparameter',
    'send_code_template_table_sms_code_desc' => 'Sie können die Vorlagen-ID konfigurieren. Einzelheiten finden Sie in der Beschreibung des zugehörigen Plugins',
    'send_code_template_table_sms_param' => 'Überprüfungscode Variablenname',
    // System-Account
    'account_center_config' => 'Konto-Center-Konfiguration',
    'account_child_safety' => 'Sicherheit für Kinder',
    'account_age_verification' => 'Altersüberprüfung',
    'account_age_min_required' => 'Erforderliches Mindestalter',
    'account_register_config' => 'Registrieren Konfig',
    'account_login_config' => 'Anmeldung konfigurieren',
    'account_password_config' => 'Passwort-Konfiguration',
    'account_center_service' => 'Kontocenter',
    'account_center_captcha' => 'Captcha',
    'account_register_service' => 'Anmeldungs-Service',
    'account_register_status' => 'Ob offene Registrierung',
    'account_register_type' => 'Konto-Unterstützung registrieren',
    'account_register_type_email' => 'E-Mail',
    'account_register_type_phone' => 'Telefon Nummer',
    'account_login_service' => 'Login-Dienst',
    'account_login_support' => 'Login-Unterstützung',
    'account_login_type_email' => 'E-Mail',
    'account_login_type_phone' => 'Telefon Nummer',
    'account_code_login' => 'Code verifizieren Anmeldung',
    'account_login_or_register' => 'Automatische Registrierung, wenn kein Konto vorhanden ist, wenn der Verifizierungscode eingeloggt wird',
    'account_password_length' => 'Längenanforderungen',
    'account_password_length_desc' => 'Länge Anforderungen: Die minimale Länge, 0 oder nicht gefüllt ist nicht begrenzt',
    'account_password_strength' => 'Festigkeitsanforderungen',
    'account_password_strength_desc' => 'Festigkeitsanforderungen: Der ausgewählte Zeichenart muss im Kennwort vorhanden sein, und es ist nicht begrenzt',
    'account_password_strength_digital' => 'Anzahl',
    'account_password_strength_lowerLetters' => 'Kleinbuchstaben',
    'account_password_strength_upperLetters' => 'Großbuchstabe',
    'account_password_strength_symbols' => 'Symbol (Division)',
    'account_connect_services' => 'Unterstützung von Drittanbietern',
    'account_connect_services_desc' => 'Wählen Sie die Verbindungsplattform und assoziierte Plugins, um eine schnelle Registrierung oder Anmeldung zu erstellen',
    'account_kyc_service' => 'Real Name-Zertifizierungsunterstützung',
    'account_kyc_service_desc' => 'Nach der Installation des Authentifizierungsdienst-Plug-Ins kann der Benutzer den echten Namen authentifizieren',
    'account_users_service' => 'Multi-User-Management',
    // System-Wallet
    'wallet_functions' => 'Geldbörsenfunktion',
    'wallet_functions_desc' => 'Ob das französische Geldpaket aktivieren soll',
    'wallet_currency_code' => 'Währungscode',
    'wallet_currency_name' => 'Monetärer Name',
    'wallet_currency_unit' => 'Währungseinheit',
    'wallet_currency_precision' => 'Währungsgenauigkeit',
    'wallet_withdraw_status' => 'Kasse',
    'wallet_withdraw_config' => 'Kassenkonfiguration',
    'wallet_withdraw_config_desc' => 'Zusätzliche Zugehörige Konfiguration muss unterstützt werden, wenden Sie sich an den Plugin-Entwickler',
    'wallet_withdraw_review' => 'Kasse',
    'wallet_withdraw_review_prove' => 'Überprüfen, um reelle Namensinformationen zu überprüfen',
    'wallet_withdraw_periodicity' => 'Bargeldintervall',
    'wallet_withdraw_rates' => 'Barabhebungsgebühr',
    'wallet_withdraw_min' => 'Single ExtraDition Mindestbetrag',
    'wallet_withdraw_max' => 'Einzelabzugsmenge',
    'wallet_withdraw_sum_limit' => 'Tägliche Auszahlungskappe',
    // System-Storage
    'storage_service_config' => 'Speicherkonfiguration',
    'storage_service_config_desc' => 'Speicherdienstleister können mehr Auswahlmöglichkeiten im App Store installieren',
    'storage_function_config' => 'Funktionskonfiguration',
    'storage_function_image_config' => 'Bildverarbeitungsfunktionskonfiguration',
    'storage_function_image_config_desc' => 'Stilnamen oder erweiterte Parameter können konfiguriert werden. Testbildkomprimierung, Zoom, Zoom, Wasserzeichen usw., gemeinsame "Intervallidentifier" ist halbbreiten Zeichen "!", "-", "_". Unterstützen Sie erweiterte Parameter und sehen Sie die Entwicklerdokumentation des Speicherdienstleisters',
    'storage_function_video_config' => 'Video-Verarbeitungsfunktionskonfiguration',
    'storage_function_video_config_desc' => 'Sie können die Vorlagen-ID konfigurieren. Einzelheiten finden Sie in der Beschreibung des zugehörigen Plugins',
    'storage_function_audio_config' => 'Audioverarbeitungsfunktionskonfiguration',
    'storage_function_audio_config_desc' => 'Sie können die Vorlagen-ID konfigurieren. Einzelheiten finden Sie in der Beschreibung des zugehörigen Plugins',
    'storage_function_document_config' => 'Online-Vorschau-Konfiguration',
    'storage_function_substitution_config' => 'Ungültige Status-Ersatzkarte',
    'storage_function_substitution_config_desc' => 'Wenn der Status der Ressourcendatei "ungültig" ist, wird die illegative Anzeigenkarte verwendet',
    'storage_function_substitution_image' => 'Bild ungültiger Hinweis',
    'storage_function_substitution_video' => 'Video Ungültiger Hinweis',
    'storage_function_substitution_audio' => 'Audio-ungültiger Hinweis',
    'storage_function_substitution_document' => 'Dokument Ungültige Eingabeaufforderungskarte',
    'storage_service_provider' => 'Speicherdienstleister',
    'storage_filesystem_disk' => 'Dateisystem Diskette',
    'storage_file_access_domain' => 'Zugriffsbereich',
    'storage_extension_names' => 'Unterstützte Verlängerung',
    'storage_max_size' => 'Unterstützte maximale Größe',
    'storage_max_duration' => 'Unterstützte maximale Zeit',
    'storage_temporary_url_status' => 'Temporäre URL',
    'storage_temporary_url_status_desc' => 'Wenn das Plugin die Funktion "Temporäre URL" nicht unterstützt, öffnen Sie es bitte nicht, da die Ressource sonst nicht zugänglich ist.',
    'storage_temporary_url_key' => 'Temporäre URL Schlüssel',
    'storage_temporary_url_expiration' => 'Ablauf der temporären URL',
    'storage_image_handle_position' => 'Bild Handgriff Position',
    'storage_image_thumb_config' => 'Konfigurationskarte',
    'storage_image_thumb_avatar' => 'Benutzerbild',
    'storage_image_thumb_ratio' => 'Isometrische thumbnail',
    'storage_image_thumb_square' => 'Quadratisches Miniaturbild',
    'storage_image_thumb_big' => 'Original-komprimierte Karte',
    'storage_video_transcode_parameter' => 'Video-Transcoding-Parameter',
    'storage_video_watermark' => 'Video-Wasserzeichen-Parameter',
    'storage_video_screenshot' => 'Video-Screenshot-Parameter',
    'storage_video_gift' => 'Video-Rotationsdiagrammparameter',
    'storage_video_poster_parameter' => 'Poster-Parameter',
    'storage_video_transcode_handle_position' => 'Video Transcode Parameter Verarbeitungsposition',
    'storage_video_poster_handle_position' => 'Poster Parameter Verarbeitungsposition',
    'storage_audio_transcode_parameter' => 'Audio-Transcoding-Parameter',
    'storage_audio_transcode_handle_position' => 'Audio Transcode Parameter Verarbeitungsposition',
    'storage_document_preview_service' => 'Dokumentvorschau-Service',
    'storage_document_preview_extension_names' => 'Support-Vorschau-Erweiterung',
    // Operating-User
    'user_name' => 'Identität benutzerdefinierte Name',
    'user_name_desc' => 'Beispielsweise, "Benutzer", "Mitglied", "Kommissar" und andere benannte',
    'user_uid_name' => 'ID benutzerdefinierter Name',
    'user_uid_name_desc' => 'Zum Beispiel "UID", "ID", "Mitgliedsnummer" und andere benannte',
    'user_username_name' => 'Benutzername benutzerdefinierter Name',
    'user_username_name_desc' => 'Zum Beispiel "Benutzername", "Mitgliedsname", "Konto" und andere benannte',
    'user_nickname_name' => 'Nickname benutzerdefinierter Name',
    'user_nickname_name_desc' => 'Zum Beispiel "Spitzname", "Blumenname", "Code" und andere benannt',
    'user_role_name' => 'Rollen benutzerdefinierter Name',
    'user_role_name_desc' => 'Zum Beispiel "Rolle", "Benutzergruppe", "Benutzergruppe" und andere benannte',
    'user_bio_name' => 'Bio benutzerdefinierter Name',
    'user_bio_name_desc' => 'Beispiel: Bio oder Einleitung',
    'user_default_role' => 'Standardbenutzerrolle',
    'user_default_role_desc' => 'Standardbenutzerrolle nach der Registrierung',
    'user_default_avatar' => 'Standardbenutzer-Avatar',
    'user_default_avatar_desc' => 'Das Standard-Avatar-Diagramm, wenn der Benutzer den Avatar nicht einstellt',
    'user_default_anonymous_avatar' => 'Anonymer Benutzer Avatar',
    'user_default_anonymous_avatar_desc' => 'Inhalt veröffentlicht anonymer Avatar-Diagramm',
    'user_default_deactivate_avatar' => 'Benutzer-Avatar',
    'user_default_deactivate_avatar_desc' => 'Avatar-Bild nach Benutzerabmelden oder Deaktivierung',
    'user_identifier' => 'Benutzer-Identifikator',
    'user_identifier_desc' => 'Welche Kennzeichnung ist bei der Benutzerinteraktion vorherrschend?',
    'user_uid_digit' => 'Benutzer-UID Anfangsziffer',
    'user_uid_digit_desc' => 'Anzahl der bei der Registrierung zufällig generierten Ziffern',
    'user_profile_desc' => 'Standard-Inhaltsliste beim Besuch der Startseite eines Benutzers',
    'user_ban_names' => 'Namen verbieten',
    'user_ban_names_desc' => 'Ein Name pro Zeile. Die Verwendung dieser Benutzernamen und Spitznamen ist verboten.',
    'user_edit_username_length' => 'Benutzername-Länge',
    'user_edit_username_length_min' => 'Minimale Länge',
    'user_edit_username_length_max' => 'Die maximale Länge',
    'user_edit_username_length_desc' => 'Benutzername Mindestlänge und maximale Länge',
    'user_edit_username_periodicity' => 'Benutzername-Modifikationsintervallnummer',
    'user_edit_nickname_length' => 'Nickname Länge',
    'user_edit_nickname_periodicity' => 'Benutzer-Nickname-Modifikationsintervallnummer',
    'user_edit_nickname_unique' => 'Spitzname Einzigartig',
    'user_edit_bio_length' => 'Bio Länge',
    'user_edit_bio_support' => 'Bio-Unterstützung',
    'user_bio_support_mention' => 'Benutzer erwähnen',
    'user_bio_support_link' => 'Link',
    'user_bio_support_hashtag' => 'Hashtag',
    'user_extcredits_config' => 'Extcredits Konfiguration',
    'user_extcredits_name' => 'Extcredits Name',
    'user_extcredits_unit' => 'Name der Einheit',
    'user_extcredits_state_not_enabled' => 'Nicht aktiviert',
    'user_extcredits_state_private' => 'Privat',
    'user_extcredits_state_public' => 'Öffentlich',
    'user_conversation_status' => 'Private Briefsitzung',
    'user_conversation_status_desc' => 'Die Nähe ist für alle Mitglieder gültig und unterliegt den Benutzerrollenrechten nach der Eröffnung',
    'user_conversation_files' => 'Sitzungszubehörfunktion',
    'user_conversation_files_desc' => 'Wenn alles nicht prüfen, unterstützt der Vertreter nur das Gespräch des reinen Textes',
    // Operating-User-Profile
    'profile_posts' => 'Ihre Beiträge',
    'profile_comments' => 'Ihre Kommentare',
    'profile_likers' => 'Benutzer, die ihnen gefallen',
    'profile_dislikers' => 'Benutzer, die ihnen nicht gefallen',
    'profile_followers' => 'Benutzer, die ihnen folgen',
    'profile_blockers' => 'Benutzer, die sie blockieren',
    'profile_followers_you_follow' => 'Follower, die Sie kennen',
    'profile_likes_users' => 'Sie mögen die Benutzer',
    'profile_likes_groups' => 'Sie mögen die Gruppen',
    'profile_likes_hashtags' => 'Sie mögen die Hashtags',
    'profile_likes_geotags' => 'Sie mögen die Geotags',
    'profile_likes_posts' => 'Sie mögen die Beiträge',
    'profile_likes_comments' => 'Sie mögen die Kommentare',
    'profile_dislikes_users' => 'Sie mögen die Benutzer nicht',
    'profile_dislikes_groups' => 'Sie mögen die Gruppen nicht',
    'profile_dislikes_hashtags' => 'Sie mögen die Hashtags nicht',
    'profile_dislikes_geotags' => 'Sie mögen die Geotags nicht',
    'profile_dislikes_posts' => 'Sie mögen die Beiträge nicht',
    'profile_dislikes_comments' => 'Sie mögen die Kommentare nicht',
    'profile_following_users' => 'Sie folgen den Benutzern',
    'profile_following_groups' => 'Sie folgen den Gruppen',
    'profile_following_hashtags' => 'Sie folgen den Hashtags',
    'profile_following_geotags' => 'Sie folgen den Geotags',
    'profile_following_posts' => 'Sie folgen den Beiträgen',
    'profile_following_comments' => 'Sie folgen den Kommentaren',
    'profile_blocking_users' => 'Sie blockieren die Benutzer',
    'profile_blocking_groups' => 'Sie blockieren die Gruppen',
    'profile_blocking_hashtags' => 'Sie blockieren die Hashtags',
    'profile_blocking_geotags' => 'Sie blockieren die Geotags',
    'profile_blocking_posts' => 'Sie blockieren die Beiträge',
    'profile_blocking_comments' => 'Sie blockieren die Kommentare',
    // Operating-Content
    'content_group_name' => 'Gruppen-benutzerdefinierter Name',
    'content_group_name_desc' => 'Zum Beispiel "Edition", "Kreis", "Klassifizierung" und andere benannte',
    'content_hashtag_name' => 'Thema benutzerdefinierter Name',
    'content_hashtag_name_desc' => 'Zum Beispiel "Super Like", "Tag", "Themen" usw',
    'content_post_name' => 'Name des Inhalts',
    'content_post_name_desc' => 'Zum Beispiel "Post", "Dynamics", "Talk" usw',
    'content_comment_name' => 'Name des Kommentarinhalts',
    'content_comment_name_desc' => 'Zum Beispiel "Kommentare", "Antwort", "Interaktion" und andere benannte',
    'content_publish_post_name' => 'Posten Sie einen Namen des Postverhaltens',
    'content_publish_post_name_desc' => 'Beispielsweise, "veröffentlicht", "Einreichung", "Feedback" und andere benannte',
    'content_publish_comment_name' => 'Posten Sie einen Kommentarverhaltensnamen',
    'content_publish_comment_name_desc' => 'Zum Beispiel "Antwort", "Antwort", "Follow Post" und andere benannt',
    'content_mention_status' => 'Status erwähnen',
    'content_mention_number' => 'Anzahl der Erwähnungen',
    'content_mention_number_desc' => 'Die Anzahl der Nutzererwähnungen pro Inhalt, 0 bedeutet keine Begrenzung.',
    'content_hashtag_status' => 'Hashtag-Status',
    'content_hashtag_format' => 'Hashtag-Format',
    'content_hashtag_format_1' => 'Single #',
    'content_hashtag_format_2' => 'Doppelt #',
    'content_hashtag_format_desc' => '<a href="#">#thema</a> und <a href="#">#thema#</a>',
    'content_hashtag_length' => 'Hashtag-Länge',
    'content_hashtag_number' => 'Anzahl von Hashtags',
    'content_hashtag_number_desc' => 'Die Anzahl der unterstützten Hashtags pro Inhalt, 0 bedeutet keine Begrenzung.',
    'content_hashtag_regexp' => 'Regulärer Hashtag-Ausdruck',
    'content_nearby_length' => 'Standardbereich für die Suche in der Nähe',
    'content_nearby_length_desc' => 'Suchbereich bei der Anzeige von Inhalten in der Nähe',
    'content_post_brief_length' => 'Post abstrakt',
    'content_post_brief_length_desc' => 'Der Beitrag übertrifft diesen eingestellten Wert übernimmt eine Zusammenfassung, die Anzahl der übergroßen Inhaltszusammenfassungswörter',
    'content_comment_brief_length' => 'Kommentarübersicht',
    'content_comment_brief_length_desc' => 'Kommentar, bevor der eingestellte Wert eine Zusammenfassung übernimmt, überwacht die Zusammenfassung der langen Inhalte',
    'content_comment_visibility_rule' => 'Regeln für die Sichtbarkeit von Kommentaren',
    'content_comment_visibility_rule_desc' => 'Kommentare werden ausgeblendet, wenn der Beitrag schon länger als ein paar Tage veröffentlicht ist, 0 bedeutet nicht aktiviert',
    'content_preview_post_like_users' => 'Vorschau der Benutzer, die einen Beitrag geliked haben',
    'content_preview_post_like_users_desc' => 'Vorschau der Nutzer, denen der Beitrag gefallen hat, die Zahl steht für die Anzahl der Vorschauen.',
    'content_preview_post_comments' => 'Vorschau auf Kommentare veröffentlichen',
    'content_preview_post_comments_desc' => 'Vorschau der Kommentare auf der Seite mit der Beitragsliste; die Zahl gibt die Anzahl der angezeigten Kommentare an.',
    'content_preview_post_comment_require' => 'Bedingungen für die Kommentarvorschau',
    'content_preview_post_comment_require_desc' => 'Zählt die Anzahl der Kommentare, bevor die Vorschau ausgegeben wird',
    'content_preview_comment_like_users' => 'Kommentar wie Benutzer Vorschau',
    'content_preview_comment_replies' => 'Vorschau der Kommentarantworten',
    'content_post_edit_config' => 'Berechtigungen zum Bearbeiten von Beiträgen',
    'content_post_delete_config' => 'Berechtigungen zum Löschen von Beiträgen',
    'content_comment_edit_config' => 'Berechtigungen zum Bearbeiten von Kommentaren',
    'content_comment_delete_config' => 'Berechtigungen zum Löschen von Kommentaren',
    'content_edit_desc' => 'Kann ich nach der Veröffentlichung bearbeiten?',
    'content_delete_desc' => 'Kann ich nach der Veröffentlichung löschen?',
    // Operating-Interaction
    'interaction_function_status' => 'Funktion Status',
    'interaction_operation_name' => 'Name der Operation',
    'interaction_user_title' => 'Benutzer-Titel',
    'interaction_public_record' => 'Öffentlicher Datensatz',
    'interaction_public_count' => 'Öffentliche Zählung',
    'interaction_column_name' => 'Name der Spalte',
    // Operating-Sticker
    'sticker_group' => 'Ausdrucksgruppe',
    'sticker_table_group_name' => 'Name der Emotionengruppe',
    'sticker_table_group_image' => 'Emotionsgruppensymbol',
    'sticker_table_group_code' => 'Emotion Group Logo',
    'sticker_table_quantity' => 'Anzahl der Ausdrücke',
    'sticker_manage' => 'Expressionsmanagement',
    'sticker_table_image' => 'Ausdrucksdiagramm',
    'sticker_table_code' => 'Emoticons',
    // Operating-Editor
    'editor_group' => 'Gruppe',
    'editor_title' => 'Titel',
    'editor_sticker' => 'Ausdruck',
    'editor_image' => 'Bild',
    'editor_video' => 'Video',
    'editor_audio' => 'Audio',
    'editor_document' => 'Dokumentation',
    'editor_mention' => 'Einit',
    'editor_hashtag' => 'Thema',
    'editor_extend' => 'Erweiterungen',
    'editor_location' => 'Position',
    'editor_anonymous' => 'anonym',
    'editor_upload_image_type' => 'Bild-Upload-Formular',
    'editor_upload_video_type' => 'Video-Upload-Formular',
    'editor_upload_audio_type' => 'Audio-Upload-Formular',
    'editor_upload_document_type' => 'Dokument-Upload-Formular',
    'editor_upload_image_number' => 'Maximale Anzahl der hochzuladenden Bilder',
    'editor_upload_video_number' => 'Maximale Anzahl von Video-Uploads',
    'editor_upload_audio_number' => 'Maximale Anzahl von Audio-Uploads',
    'editor_upload_document_number' => 'Maximale Anzahl von Upload-Dokumenten',
    // Operating-Publish
    'publish_editor_config' => 'Editorauswahl',
    'publish_editor_function_status' => 'Editor-Funktion',
    'publish_editor_function_options' => 'Editor-Funktionskonfiguration',
    'publish_post_verify_config' => 'Postanfrage posten',
    'publish_comment_verify_config' => 'Veröffentlichen Sie eine Kommentaranfrage',
    'publish_post_rules_config' => 'Poste eine Post-Sonderregel',
    'publish_comment_rules_config' => 'Veröffentlichen Sie eine Überprüfung Sonderregel',
    'publish_editor_desc' => 'Herausgeber veröffentlicht',
    'publish_verify_desc' => 'Die Konten müssen mit den ausgewählten Informationen ausgefüllt werden, um veröffentlicht zu werden',
    'publish_rules_desc' => 'Alle Mitarbeiter sind gültig, Priorität ist größer als Rollenregeln',
    'publish_rule_type' => 'Regeltyp',
    'publish_rule_datetime' => 'Datumsbereich',
    'publish_rule_time' => 'Zeitlimit',
    'publish_rule_timezone' => 'Zeitzone Standard',
    'publish_rule_rule' => 'Regelanforderungen',
    'publish_rule_tip' => 'Regelaufforderung',
    'publish_edit_time_limit' => 'Wie lange kannst du bearbeiten?',
    'publish_edit_sticky_limit' => 'Nach Sticky',
    'publish_edit_digest_limit' => 'Nach Digest',
    'publish_editor_group_required' => 'Ob die Gruppe erforderlich ist',
    'publish_editor_group_required_desc' => 'Wenn Sie Beiträge posten, müssen Sie wählen',
    'publish_editor_title_input_box' => 'Titel-Eingabefeldanzeige',
    'publish_editor_title_input_box_desc' => 'Schwaches Display erfordert, dass der Benutzer das Titeleingabefeld manuell auswählt',
    'publish_editor_title_required' => 'Ob der Titel gefüllt sein muss',
    'publish_editor_title_required_desc' => 'Beim Buchung muss der Titel gefüllt sein',
    'publish_editor_title_length' => 'Titelwortlimit',
    'publish_editor_title_length_desc' => 'Die Anzahl der Titel darf die Anzahl der Einstellungen nicht überschreiten, wobei die maximale Anzahl der oberen Grenze 255',
    'publish_editor_post_content_length' => 'Wortlimit posten',
    'publish_editor_post_content_length_desc' => 'Die Anzahl der Beiträge überschreitet nicht die Anzahl der Einstellungen, minimale 140 Zeichen der oberen Grenze',
    'publish_editor_comment_content_length' => 'Kommentarwortlimit',
    'publish_editor_comment_content_length_desc' => 'Die Anzahl der Kommentare darf die Anzahl der Einstellungen nicht überschreiten, wobei die Mindestlimit der oberen Grenze 140',
    // Operating-Permission
    'permission_option_email' => 'E-Mail erforderlich',
    'permission_option_phone' => 'Telefon Erforderlich',
    'permission_option_kyc' => 'KYC Erforderlich',
    'permission_option_rule_datetime' => 'Effektiv innerhalb des angegebenen Datumsbereichs',
    'permission_option_rule_time' => 'Geben Sie einen Zyklus der Zeit innerhalb des angegebenen Zeitraums an',
    'permission_option_review_publish' => 'Kann veröffentlicht werden, muss aber überprüfen',
    'permission_option_close_publish' => 'Verbot der Publishing',
    'permission_option_can_be_edited' => 'Kann bearbeitet werden',
    'permission_option_cannot_be_edited' => 'Kann nicht bearbeitet werden',
    'permission_option_can_be_deleted' => 'Kann gelöscht werden',
    'permission_option_cannot_be_deleted' => 'Kann nicht gelöscht werden',
    'permission_option_direct_release' => 'Direkt passieren',
    'permission_option_required_review' => 'Müssen überprüft werden',
    'permission_option_title_optional_display' => 'Schwaches Display',
    'permission_option_title_direct_display' => 'Starkes Display',
    // Operating-Roles
    'role_table_display' => 'Logo anzeigen',
    'role_table_nickname_color' => 'Spitznamefarbe',
    'role_option_display_icon' => 'Bildschirmsymbol',
    'role_option_display_text' => 'Text',
    'role_option_close_nickname_color' => 'Verwenden Sie keine Farben',
    'role_current' => 'Momentane Rolle',
    'role_target' => 'Zielrolle',
    'role_target_desc' => 'Nachdem die Rolle gelöscht wurde, geht der Benutzer auf den ausgewählten Zielzählungsnamen unter der Rolle zusammen',
    'role_perm_basic_config' => 'Grundeinstellungen',
    'role_perm_post_config' => 'Posten Sie eine Posteinstellung',
    'role_perm_comment_config' => 'Veröffentlichen Sie eine Kommentareinstellung',
    'role_perm_upload_config' => 'Upload-Einstellung',
    'role_perm_interaction_config' => 'Interaktive Einstellungen',
    'role_perm_customize_config' => 'Benutzerdefinierte Einstellung',
    'role_perm_content_view' => 'Erlaubnis durchsuchen',
    'role_perm_conversation' => 'Sitzungsberechtigung',
    'role_perm_content_link_handle' => 'Linkbehandlung für veröffentlichte Inhalte',
    'role_perm_content_link_handle_1' => 'Domänenname nicht auflösen und maskieren',
    'role_perm_content_link_handle_2' => 'Wird nicht aufgelöst, sondern als Text angezeigt',
    'role_perm_content_link_handle_3' => 'Normales Parsing',
    'role_perm_post_publish' => 'Posten Sie eine Post-Erlaubnis',
    'role_perm_post_verify' => 'Postanfrage posten',
    'role_perm_post_review' => 'Post eine Postregel',
    'role_perm_post_rules' => 'Poste eine Post-Sonderregel',
    'role_perm_post_time_interval' => 'Zeitintervall buchen',
    'role_perm_post_daily_count' => 'Tageslimit für Beiträge',
    'role_perm_post_draft_count' => 'Anzahl der Entwürfe begrenzen',
    'role_perm_comment_publish' => 'Kommentarberechtigungen veröffentlichen',
    'role_perm_comment_verify' => 'Veröffentlichen Sie eine Kommentaranfrage',
    'role_perm_comment_review' => 'Eine Kommentarregel posten',
    'role_perm_comment_rules' => 'Veröffentlichen Sie eine Überprüfung Sonderregel',
    'role_perm_comment_time_interval' => 'Zeitintervall für Kommentare',
    'role_perm_comment_daily_count' => 'Tägliches Limit für Kommentare',
    'role_perm_comment_draft_count' => 'Anzahl der Kommentarentwürfe',
    'role_perm_upload_image' => 'Bild hochladen',
    'role_perm_upload_video' => 'Video hochladen',
    'role_perm_upload_audio' => 'Audio hochladen',
    'role_perm_upload_document' => 'Dokument hochladen',
    'role_perm_upload_file_desc' => 'Die Überprüfung des Vertreters hat das Hochladen des Eingangsfelds, wobei der Eingabefeld leer ist, verwendet die "Speicherkonfiguration" als Standardparameter',
    'role_perm_follow_user_max_count' => 'Benutzer Max Count folgen',
    'role_perm_block_user_max_count' => 'Maximalzahl der Benutzer blockieren',
    'role_perm_download_file_count' => 'Laden Sie die obere Grenze innerhalb von 24 Stunden herunter',
    'role_perm_table_name' => 'Name des Autorität',
    'role_perm_table_value' => 'Berechtigungswert',
    // Operating-Groups
    'group_table_parent_group' => 'Übergeordnete Gruppe',
    'group_table_subgroup' => 'Untergruppe',
    'group_table_privacy' => 'Datenschutz',
    'group_table_visibility' => 'Sichtbarkeit',
    'group_table_follow_method' => 'Methode folgen',
    'group_table_recommend' => 'Ist es empfohlen?',
    'group_table_admins' => 'Gruppenadministrator',
    'group_table_can_publish' => 'Kann veröffentlichen',
    'group_table_post_permissions' => 'Berechtigungen zum Posten',
    'group_table_comment_permissions' => 'Kommentar Berechtigungen',
    'group_table_publish_perm_role' => 'Rolle mit dem Recht zu veröffentlichen',
    'group_table_publish_perm_review' => 'Benötigen Sie eine Prüfung?',
    'group_table_publish_perm_review_desc' => 'Gruppenadministratoren sind nicht eingeschränkt',
    'group_public_desc' => 'Offen (jeder kann den Beitrag innerhalb der Gruppe anzeigen)',
    'group_private_desc' => 'Nicht-Öffentliche (nur Mitglieder können die Beiträge innerhalb der Gruppe anzeigen)',
    'group_visible_desc' => 'Es kann gefunden werden (jeder kann diese Gruppe finden)',
    'group_hidden_desc' => 'Nicht finden (nur Mitglieder finden diese Gruppe)',
    'group_publish_option_all' => 'Jeder',
    'group_publish_option_members' => 'Nur die Gruppe der Benutzer zahlen',
    'group_publish_option_roles' => 'Nur angegebene Rollenbenutzer',
    'group_publish_option_admins' => 'Nur Gruppenadministratoren',
    'group_can_publish_desc' => 'Das Schließen von Veröffentlichungsberechtigungen kann als Gruppenkategorisierung verwendet werden',
    'group_current' => 'Aktuelle Gruppe',
    'group_target' => 'Zielgruppe',
    'group_target_desc' => 'Nach der Fusion wird die alte Gruppe gelöscht, und der Inhalt der alten Gruppe wird zum ausgewählten Target-Teamnamen migriert',
    // Extends
    'extend_editor_menus' => 'Menüs',
    'extend_editor_toolbar' => 'Symbolleiste',
    'extend_editor_number_of_uses_desc' => 'Beispiele für "Abstimmungs-Plugins, die Nummer ist 2, was einen einzelnen Beitrag darstellt, 2 Stimmen können enthalten sein',
    'extend_content_service' => 'Inhaltlicher Dienst',
    'extend_content_list' => 'Inhalt Liste',
    'extend_content_detail' => 'Inhalt Details',
    'extend_content_search' => 'Inhaltssuche',
    'extend_content_list_desc' => 'Diese Konfiguration hat eine höhere Priorität als die Konfiguration des Inhaltstyps, und wenn sie konfiguriert ist, wird die durch den Inhaltstyp angegebene Datenquelle ersetzt.',
    'extend_content_ip' => 'IP-Dienst',
    'extend_content_map' => 'Kartendienst',
    'extend_content_notifications_service' => 'Dienst benachrichtigen',
    'extend_content_review' => 'Überprüfungsdienst',
    'extend_content_list_by_all' => 'Alle Beiträge oder Kommentare',
    'extend_content_list_by_timelines' => 'Timelines Beiträge oder Kommentare',
    'extend_content_list_by_nearby' => 'Nahegelegene Beiträge oder Kommentare',
    'extend_content_by_detail' => 'Beitrag oder Kommentar Detail',
    'extend_content_search_users' => 'Benutzer suchen',
    'extend_content_search_groups' => 'Gruppen suchen',
    'extend_content_search_hashtags' => 'Hashtags suchen',
    'extend_content_search_geotags' => 'Geotags suchen',
    'extend_content_search_posts' => 'Beiträge suchen',
    'extend_content_search_comments' => 'Kommentare suchen',
    // Client-Channels
    'channel_default_homepage' => 'Standard-Homepage',
    'channel_table_channel' => 'Kanal',
    'channel_table_page' => 'Seite',
    'channel_table_page_home' => 'Startseite',
    'channel_table_page_list' => 'Liste',
    'channel_table_page_detail' => 'Einzelheiten',
    'channel_table_page_interaction' => 'Interaktion',
    'channel_table_path' => 'Pfad',
    'channel_table_seo' => 'SEO-Informationen',
    'channel_table_seo_title' => 'SEO-Titel',
    'channel_table_seo_description' => 'SEO-Beschreibung',
    'channel_table_seo_keywords' => 'SEO-Keyword',
    'channel_table_query_state' => 'Client-seitige Übergabe',
    'channel_table_query_state_desc' => 'Ob clientseitige Übergaben akzeptiert werden sollen oder nicht. Wenn diese Option deaktiviert ist, werden nur die Standardparameterwerte unterstützt.',
    'channel_table_query_config' => 'Standardparameter',
    'channel_table_query_config_desc' => 'Siehe die API-Abfrageparameter dieser Schnittstelle',
    'channel_query_state_1' => 'Keine Client-Parameter akzeptiert',
    'channel_query_state_2' => 'Nur Client-Paging-Parameter akzeptieren',
    'channel_query_state_3' => 'Alle Parameter akzeptieren',
    // Client-Columns
    'channel_timeline' => 'Zeitleiste',
    'channel_timeline_all_posts' => 'Alle verfolgten Beiträge',
    'channel_timeline_user_posts' => 'Ich folge den Beiträgen von Benutzern',
    'channel_timeline_group_posts' => 'Ich folge den Beiträgen von Gruppen',
    'channel_timeline_hashtag_posts' => 'Ich folge Beiträgen mit Hashtags',
    'channel_timeline_geotag_posts' => 'Ich folge Geotags-Beiträgen',
    'channel_timeline_all_comments' => 'Alle verfolgten Kommentare',
    'channel_timeline_user_comments' => 'Ich folge den Kommentaren der Benutzer',
    'channel_timeline_group_comments' => 'Ich folge den Kommentaren von Gruppen',
    'channel_timeline_hashtag_comments' => 'Ich folge Hashtags-Kommentaren',
    'channel_timeline_geotag_comments' => 'Ich folge Geotags-Kommentaren',
    'channel_nearby' => 'In der Nähe',
    'channel_nearby_posts' => 'Beiträge von Nearby',
    'channel_nearby_comments' => 'Kommentare von Nearby',
    'channel_me' => 'Persönliches Zentrum',
    'channel_me_extcredits' => 'Extcredits',
    'channel_me_wallet' => 'Brieftasche',
    'channel_me_drafts' => 'Entwürfe',
    'channel_me_users' => 'Benutzer',
    'channel_me_settings' => 'Einstellungen',
    'channel_messages' => 'Nachrichten',
    'channel_conversations' => 'Unterhaltungen',
    'channel_notifications' => 'Benachrichtigungen',
    'channel_notifications_all' => 'Benachrichtigen-Alle',
    'channel_notifications_systems' => 'Benachrichtigen-Systeme',
    'channel_notifications_recommends' => 'Benachrichtigen-Empfiehlt',
    'channel_notifications_likes' => 'Benachrichtigen-Mag',
    'channel_notifications_dislikes' => 'Benachrichtigen-Abneigungen',
    'channel_notifications_follows' => 'Benachrichtigen-Folgt',
    'channel_notifications_blocks' => 'Benachrichtigen-Blockiert',
    'channel_notifications_mentions' => 'Benachrichtigen-Erwähnungen',
    'channel_notifications_comments' => 'Benachrichtigen-Kommentare',
    'channel_notifications_quotes' => 'Benachrichtigen-Zitat',
    'channel_search' => 'Suche',
    // Client-Keys
    'key_table_read_only' => 'Nur lesen',
    'key_select_platform' => 'Wählen Sie die wichtigste Anwendungsplattform aus',
    'key_option_main_api' => 'Haupt-API',
    'key_option_manage_api' => 'Management-API',
    'key_option_plugin_api' => 'Plugin-API',
    'key_option_plugin_api_select' => 'Wählen Sie aus, welches Plugin zur Verwendung verwendet wird',
    'key_option_plugin_api_select_desc' => 'Dieser Schlüssel kann nur die API des zugehörigen Plugins anfordern',
    // Client-Basic
    'website_stat_code' => 'Website-Statistik-Code',
    'website_stat_code_desc' => 'Die Verwendung von statistischem Code, der document.write enthält, wird nicht unterstützt.',
    'website_stat_position' => 'Ort des Statistikcodes',
    'website_stat_position_desc' => 'Wo der Statistikcode in den HTML-Code geladen wird.',
    'china_mode' => 'China-Modus',
    'china_mode_desc' => 'Erforderliche Informationen, wenn der Site-Server in China eingesetzt wird.',
    'china_mode_config' => 'Serverkonfiguration für das chinesische Festland (nicht erforderliches Feld)',
    'china_icp_filing' => 'Internet Content Provider Einreichung',
    'china_icp_license' => 'Lizenz für Anbieter von Internetinhalten',
    'china_mps_filing' => 'Büro für öffentliche Sicherheit Einreichung',
    'china_broadcasting_license' => 'Rundfunklizenz',
    // Client-Status
    'client_status_desc' => 'Client-Anforderung der Statuskonfiguration alle 10 Minuten',
    // App-Center-Themes
    'website_engine_config' => 'Motor-Konfiguration',
    'website_engine_api_config' => 'API-Konfiguration',
    'website_engine_status' => 'Motorstatus',
    'website_engine_api_type' => 'Motor-API-Typ',
    'website_engine_key_id' => 'Anwendungsschlüssel auswählen',
    'website_engine_view_desktop' => 'Desktop',
    'website_engine_view_mobile' => 'Mobile',
    // App-Center-Install
    'install_website_engine' => 'Website-Engine installieren',
    'install_plugin' => 'Plugin installieren',
    'install_application' => 'App installieren',
    'install_mode' => 'Installieren Modus',
    'install_mode_fskey' => 'Fresns-Schlüssel eingeben',
    'install_mode_upload' => 'Zip-Paket hochladen',
    'install_mode_directory' => 'Eingabeverzeichnis Pfad',
    'download_application' => 'App herunterladen',
];
