# 💎 4C style guide

## Introduction

This document is a guide to the 4C style guide. It contains all the information you need to know about the 4C brand, colors, typography, and more.

## About 4C

4C is a community of creators, where you can connect with other like-minded creators, collaborate on ideas, and motivate each other to create and publish!

Our community is focused on supporting content creators in general across all social media platforms. We are a community of creators, by creators, for creators.

Our goal is to create a  decentralized community, where everyone contributes to its growth, and that growth echoes back positively to every individual creator in the community.


## Assets

### 4C Logo

![4C Logo](https://raw.githubusercontent.com/FrancescoXX/4c-site/main/src/assets/logo.png)

#### Square Variation

![4C Logo](https://raw.githubusercontent.com/FrancescoXX/4c-site/main/src/assets/logo-square.jpg)

### Banner

![4C Banner](https://raw.githubusercontent.com/FrancescoXX/4c-site/main/src/assets/banner.jpg)

## Typography

Font Family: `Poppins`

| Name                 | Weight    |
| -------------------- | --------- |
| `Headings(h1,h2)`    | `Bold`    |
| `Subheadings(h3,h4)` | `Medium`  |
| `Body Text`          | `Regular` |

Type scale: Following Tailwind CSS type scale system

## Colors

### 4C Brand Colors

<table>
    <tr>
        <td><img src="http://placehold.jp/030e2c/ffffff/80x80.png?text=%20"> <br>#030e2c</td>
        <td><img src="http://placehold.jp/718fe9/ffffff/80x80.png?text=%20"> <br>#718fe9</td>
        <td><img src="http://placehold.jp/5fbec4/ffffff/80x80.png?text=%20"> <br>#5fbec4</td>
        <td><img src="http://placehold.jp/49127b/ffffff/80x80.png?text=%20"> <br>#49127b</td>
        <td><img src="http://placehold.jp/708fe6/ffffff/80x80.png?text=%20"> <br>#708fe6</td>
    </tr>
</table>

### 4C Gradient CSS code

```css
linear-gradient( 34deg, rgba(68, 18, 115, 1) 0%, rgba(5, 30, 75, 1) 21%, rgba(52, 79, 141, 1) 58%, rgba(106, 137, 223, 1) 80%, rgba(145, 227, 226, 1) 99% );
```

<img src="https://ik.imagekit.io/u33i3sss0/4c/4c_gradient_iEc5YnyaL.png?ik-sdk-version=javascript-1.4.3&updatedAt=1669915186734" alt="4C gradient">

## Buttons

### Call to Action Buttons

<img src="https://ik.imagekit.io/u33i3sss0/4c/Screenshot_2022-12-01_at_12-46-50_4C_-_Creator_Community_RFydcD8tX.png?ik-sdk-version=javascript-1.4.3&updatedAt=1669916827713" alt="4C cta button">

### Call to Action Guidelines

| Style                       | Values                                 |
| --------------------------- | -------------------------------------- |
| `padding-left`              | `2rem`                                 |
| `padding-right`             | `2rem`                                 |
| `padding-top`               | `0.75rem`                              |
| `display`                   | `inline-flex`                          |
| `align-items`               | `center`                               |
| `justify-content`           | `center`                               |
| `gap`                       | `0.5rem`                               |
| `background-color`          | `rgb(17 24 39 / var(--tw-bg-opacity))` |
| `font-weight`               | `500`                                  |
| `border-radius`             | `9999px`                               |
| `border-bottom-left-radius` | `0px`                                  |

### NavBar Buttons

<img src="https://ik.imagekit.io/u33i3sss0/4c/Screenshot_2022-12-01_at_14-42-11_4C_-_Creator_Community_is2hpLuyR.png?ik-sdk-version=javascript-1.4.3&updatedAt=1669923773411" alt="4C cta button">

### NavBar Button Guidelines

| Style              | Values   |
| ------------------ | -------- |
| `padding-left`     | `1rem`   |
| `padding-right`    | `1rem`   |
| `padding-top`      | `0.5rem` |
| `padding-bottom`   | `0.5rem` |
| `background-color` | `white`  |
| `font-weight`      | `bold`   |
| `color`            | `black`  |

## Effects

### Shadows

```css
box-shadow: var(--tw-ring-offset-shadow, 0 0 #0000), var(
    --tw-ring-shadow,
    0 0 #0000
  ), var(--tw-shadow);
```

### Transitions

```css
transition: PROPERTY_ANIMATING 150ms ease-out;
```
