package fonthx.opentype.postscript;

// hmmm …
class StandardVector
{
	private static var unicode:Array<Int>;
	private static var psNames:Array<String>;
	private static var ready:Bool = false;

	private static function init() {
		var codes:Array<String> = [
            "0",".notdef",
			"0",".null",
			"0","nonmarkingreturn",
			"32","space",
			"33","exclam",
			"34","quotedbl",
			"35","numbersign",
			"36","dollar",
			"37","percent",
			"38","ampersand",
			"39","quotesingle",
			"40","parenleft",
			"41","parenright",
			"42","asterisk",
			"43","plus",
			"44","comma",
			"45","hyphen",
			"46","period",
			"47","slash",
			"48","zero",
			"49","one",
			"50","two",
			"51","three",
			"52","four",
			"53","five",
			"54","six",
			"55","seven",
			"56","eight",
			"57","nine",
			"58","colon",
			"59","semicolon",
			"60","less",
			"61","equal",
			"62","greater",
			"63","question",
			"64","at",
			"65","A",
			"66","B",
			"67","C",
			"68","D",
			"69","E",
			"70","F",
			"71","G",
			"72","H",
			"73","I",
			"74","J",
			"75","K",
			"76","L",
			"77","M",
			"78","N",
			"79","O",
			"80","P",
			"81","Q",
			"82","R",
			"83","S",
			"84","T",
			"85","U",
			"86","V",
			"87","W",
			"88","X",
			"89","Y",
			"90","Z",
			"91","bracketleft",
			"92","backslash",
			"93","bracketright",
			"94","asciicircum",
			"95","underscore",
			"96","grave",
			"97","a",
			"98","b",
			"99","c",
			"100","d",
			"101","e",
			"102","f",
			"103","g",
			"104","h",
			"105","i",
			"106","j",
			"107","k",
			"108","l",
			"109","m",
			"110","n",
			"111","o",
			"112","p",
			"113","q",
			"114","r",
			"115","s",
			"116","t",
			"117","u",
			"118","v",
			"119","w",
			"120","x",
			"121","y",
			"122","z",
			"123","braceleft",
			"124","bar",
			"125","braceright ",
			"126","asciitilde",
			"196","Adieresis",
			"197","Aring",
			"199","Ccedilla",
			"201","Eacute",
			"209","Ntilde",
			"214","Odieresis",
			"220","Udieresis",
			"225","aacute",
			"224","agrave",
			"226","acircumflex",
			"228","adieresis",
			"227","atilde",
			"229","aring",
			"231","ccedilla",
			"233","eacute",
			"232","egrave",
			"234","ecircumflex",
			"235","edieresis",
			"237","iacute",
			"236","igrave",
			"238","icircumflex",
			"239","idieresis",
			"241","ntilde",
			"243","oacute",
			"242","ograve",
			"244","ocircumflex",
			"246","odieresis",
			"245","otilde",
			"250","uacute",
			"249","ugrave",
			"251","ucircumflex",
			"252","udieresis",
			"134","dagger",
			"176","degree",
			"162","cent",
			"163","sterling",
			"167","section",
			"149","bullet",
			"182","paragraph",
			"223","germandbls",
			"174","registered",
			"169","copyright",
			"8482","trademark",
			"180","acute",
			"168","dieresis",
			"8800","notequal",
			"198","AE",
			"216","Oslash",
			"8734","infinity",
			"177","plusminus",
			"8804","lessequal",
			"8805","greaterequal",
			"165","yen",
			"181","mu",
			"8706","partialdiff",
			"8721","summation",
			"215","product",
			"960","pi",
			"8747","integral",
			"170","ordfeminine",
			"186","ordmasculine",
			"937","Omega",
			"230","ae",
			"248","oslash",
			"191","questiondown",
			"161","exclamdown",
			"172","logicalnot",
			"8730","radical",
			"402","florin",
			"8776","approxequal",
			"8710","Delta",
			"171","guillemotleft",
			"187","guillemotright",
			"8230","ellipsis",
			"160","nonbreakingspace",
			"192","Agrave",
			"195","Atilde",
			"213","Otilde",
			"140","OE",
			"156","oe",
			"8211","endash",
			"8212","emdash",
			"147","quotedblleft",
			"148","quotedblright",
			"145","quoteleft",
			"146","quoteright",
			"247","divide",
			"9674","lozenge",
			"255","ydieresis",
			"159","Ydieresis",
			"8260","fraction",
			"164","currency",
			"139","guilsinglleft",
			"155","guilsinglright",
			"64257","fi",
			"64258","fl",
			"8225","daggerdbl",
			"183","periodcentered",
			"8218","quotesinglbase",
			"8222","quotedblbase",
			"137","perthousand",
			"194","Acircumflex",
			"202","Ecircumflex",
			"193","Aacute",
			"203","Edieresis",
			"200","Egrave",
			"205","Iacute",
			"206","Icircumflex",
			"207","Idieresis",
			"204","Igrave",
			"211","Oacute",
			"212","Ocircumflex",
			"0","apple",
			"210","Ograve",
			"218","Uacute",
			"219","Ucircumflex",
			"217","Ugrave",
			"305","dotlessi",
			"136","circumflex",
			"126","tilde",
			"175","macron",
			"728","breve",
			"729","dotaccent",
			"730","ring",
			"184","cedilla",
			"733","hungarumlaut",
			"731","ogonek",
			"711","caron",
			"321","Lslash",
			"322","lslash",
			"352","Scaron",
			"353","scaron",
			"381","Zcaron",
			"382","zcaron",
			"166","brokenbar",
			"208","Eth",
			"240","eth",
			"221","Yacute",
			"253","yacute",
			"222","Thorn",
			"254","thorn",
			"8722","minus",
			"215","multiply",
			"185","onesuperior",
			"178","twosuperior",
			"179","threesuperior",
			"189","onehalf",
			"188","onequarter",
			"190","threequarters",
			"8355","franc",
			"286","Gbreve",
			"287","gbreve",
			"304","Idotaccent",
			"350","Scedilla",
			"351","scedilla",
			"262","Cacute",
			"263","cacute",
			"268","Ccaron",
			"269","ccaron",
			"273","dcroat"
		]
		;
		unicode = new Array<Int>();
		psNames = new Array<String>();
        var i = 0;
        while (i < codes.length) {
            unicode.push(Std.parseInt(codes[i]));
            psNames.push(codes[i + 1]);
            i += 2;
        }
		ready = true;
	}

	public static function getMac258ForUnicode(maccode:Int):Int {
		if (!ready)
			init();
		for (i in 0...unicode.length) {
			if (unicode[i] == maccode)
				return i;
		}
		return 0;
	}


}

