package fonthx.model.font.features;

/**
* @see https://docs.microsoft.com/en-us/typography/opentype/spec/scripttags
**/

@:enum
abstract ScriptTag(String) {

    public var LATIN = 'latn';
    public var ADLAM = 'adlm';
    public var AHOM = 'ahom';
    public var ANATOLIANHIEROGLYPHS = 'hluw';
    public var ARABIC = 'arab';
    public var ARMENIAN = 'armn';
    public var AVESTAN = 'avst';
    public var BALINESE = 'bali';
    public var BAMUM = 'bamu';
    public var BASSAVAH = 'bass';
    public var BATAK = 'batk';
    public var BENGALI = 'beng';
    public var BENGALI2 = 'bng2';
    public var BHAIKSUKI = 'bhks';
    public var BOPOMOFO = 'bopo';
    public var BRAHMI = 'brah';
    public var BRAILLE = 'brai';
    public var BUGINESE = 'bugi';
    public var BUHID = 'buhd';
    public var BYZANTINEMUSIC = 'byzm';
    public var CANADIANSYLLABICS = 'cans';
    public var CARIAN = 'cari';
    public var CAUCASIANALBANIAN = 'aghb';
    public var CHAKMA = 'cakm';
    public var CHAM = 'cham';
    public var CHEROKEE = 'cher';
    public var CJKIDEOGRAPHIC = 'hani';
    public var COPTIC = 'copt';
    public var CYPRIOTSYLLABARY = 'cprt';
    public var CYRILLIC = 'cyrl';
    public var DEFAULT = 'DFLT';
    public var DESERET = 'dsrt';
    public var DEVANAGARI = 'deva';
    public var DEVANAGARI2 = 'dev2';
    public var DOGRA = 'dogr';
    public var DUPLOYAN = 'dupl';
    public var EGYPTIANHIEROGLYPHS = 'egyp';
    public var ELBASAN = 'elba';
    public var ETHIOPIC = 'ethi';
    public var GEORGIAN = 'geor';
    public var GLAGOLITIC = 'glag';
    public var GOTHIC = 'goth';
    public var GRANTHA = 'gran';
    public var GREEK = 'grek';
    public var GUJARATI = 'gujr';
    public var GUJARATI2 = 'gjr2';
    public var GUNJALAGONDI = 'gong';
    public var GURMUKHI = 'guru';
    public var GURMUKHI2 = 'gur2';
    public var HANGUL = 'hang';
    public var HANGULJAMO = 'jamo';
    public var HANIFIROHINGYA = 'rohg';
    public var HANUNOO = 'hano';
    public var HATRAN = 'hatr';
    public var HEBREW = 'hebr';
    public var HIRAGANA = 'kana';
    public var IMPERIALARAMAIC = 'armi';
    public var INSCRIPTIONALPAHLAVI = 'phli';
    public var INSCRIPTIONALPARTHIAN = 'prti';
    public var JAVANESE = 'java';
    public var KAITHI = 'kthi';
    public var KANNADA = 'knda';
    public var KANNADA2 = 'knd2';
    public var KATAKANA = 'kana';
    public var KAYAHLI = 'kali';
    public var KHAROSTHI = 'khar';
    public var KHMER = 'khmr';
    public var KHOJKI = 'khoj';
    public var KHUDAWADI = 'sind';
    public var LAO = 'lao ';
    public var LEPCHA = 'lepc';
    public var LIMBU = 'limb';
    public var LINEARA = 'lina';
    public var LINEARB = 'linb';
    public var LISUFRASER = 'lisu';
    public var LYCIAN = 'lyci';
    public var LYDIAN = 'lydi';
    public var MAHAJANI = 'mahj';
    public var MAKASAR = 'maka';
    public var MALAYALAM = 'mlym';
    public var MALAYALAM2 = 'mlm2';
    public var MANDAICMANDAEAN = 'mand';
    public var MANICHAEAN = 'mani';
    public var MARCHEN = 'marc';
    public var MASARAMGONDI = 'gonm';
    public var MATHEMATICALALPHANUMERICSYMBOLS = 'math';
    public var MEDEFAIDRINX = 'medf';
    public var MEITEIMAYEK = 'mtei';
    public var MENDEKIKAKUI = 'mend';
    public var MEROITICCURSIVE = 'merc';
    public var MEROITICHIEROGLYPHS = 'mero';
    public var MIAO = 'plrd';
    public var MODI = 'modi';
    public var MONGOLIAN = 'mong';
    public var MRO = 'mroo';
    public var MULTANI = 'mult';
    public var MUSICALSYMBOLS = 'musc';
    public var MYANMAR = 'mymr';
    public var MYANMAR2 = 'mym2';
    public var NABATAEAN = 'nbat';
    public var NEWA = 'newa';
    public var NEWTAILUE = 'talu';
    public var NKO = 'nko ';
    public var NUESHU = 'nshu';
    public var ODIA = 'orya';
    public var ODIA2 = 'ory2';
    public var OGHAM = 'ogam';
    public var OLCHIKI = 'olck';
    public var OLDITALIC = 'ital';
    public var OLDHUNGARIAN = 'hung';
    public var OLDNORTHARABIAN = 'narb';
    public var OLDPERMIC = 'perm';
    public var OLDPERSIANCUNEIFORM = 'xpeo';
    public var OLDSOGDIAN = 'sogo';
    public var OLDSOUTHARABIAN = 'sarb';
    public var OLDTURKICORKHONRUNIC = 'orkh';
    public var OSAGE = 'osge';
    public var OSMANYA = 'osma';
    public var PAHAWHHMONG = 'hmng';
    public var PALMYRENE = 'palm';
    public var PAUCINHAU = 'pauc';
    public var PHAGSPA = 'phag';
    public var PHOENICIAN = 'phnx';
    public var PSALTEPAHLAVI = 'phlp';
    public var REJANG = 'rjng';
    public var RUNIC = 'runr';
    public var SAMARITAN = 'samr';
    public var SAURASHTRA = 'saur';
    public var SHARADA = 'shrd';
    public var SHAVIAN = 'shaw';
    public var SIDDHAM = 'sidd';
    public var SIGNWRITING = 'sgnw';
    public var SINHALA = 'sinh';
    public var SOGDIAN = 'sogd';
    public var SORASOMPENG = 'sora';
    public var SOYOMBO = 'soyo';
    public var SUMEROAKKADIANCUNEIFORM = 'xsux';
    public var SUNDANESE = 'sund';
    public var SYLOTINAGRI = 'sylo';
    public var SYRIAC = 'syrc';
    public var TAGALOG = 'tglg';
    public var TAGBANWA = 'tagb';
    public var TAILE = 'tale';
    public var TAITHAM = 'lana';
    public var TAIVIET = 'tavt';
    public var TAKRI = 'takr';
    public var TAMIL = 'taml';
    public var TAMIL2 = 'tml2';
    public var TANGUT = 'tang';
    public var TELUGU = 'telu';
    public var TELUGU2 = 'tel2';
    public var THAANA = 'thaa';
    public var THAI = 'thai';
    public var TIBETAN = 'tibt';
    public var TIFINAGH = 'tfng';
    public var TIRHUTA = 'tirh';
    public var UGARITICCUNEIFORM = 'ugar';
    public var VAI = 'vai ';
    public var WARANGCITI = 'wara';
    public var YI = 'yi ';
    public var ZANABAZARSQUARE = 'zanb' ;

    @:to
    public function toString():String {
        return this;
    }

}
