package fonthx.model.font.features;

/**
* @see https://docs.microsoft.com/en-us/typography/opentype/spec/languagetags
**/

@:enum
abstract LanguageTag(String) {

    public var DEFAULT = 'DFLT';

    public var ABAZA = 'ABA ';
    public var ABKHAZIAN = 'ABK ';
    public var ACHOLI = 'ACH ';
    public var ACHI = 'ACR ';
    public var ADYGHE = 'ADY ';
    public var AFRIKAANS = 'AFK ';
    public var AFAR = 'AFR ';
    public var AGAW = 'AGW ';
    public var AITON = 'AIO ';
    public var AKAN = 'AKA ';
    public var ALSATIAN = 'ALS ';
    public var ALTAI = 'ALT ';
    public var AMHARIC = 'AMH ';
    public var ANGLOSAXON = 'ANG ';
    public var ARABIC = 'ARA ';
    public var ARAGONESE = 'ARG ';
    public var AARI = 'ARI ';
    public var RAKHINE = 'ARK ';
    public var ASSAMESE = 'ASM ';
    public var ASTURIAN = 'AST ';
    public var ATHAPASKAN = 'ATH ';
    public var AVAR = 'AVR ';
    public var AWADHI = 'AWA ';
    public var AYMARA = 'AYM ';
    public var TORKI = 'AZB ';
    public var AZERBAIJANI = 'AZE ';
    public var BADAGA = 'BAD ';
    public var BAGHELKHANDI = 'BAG ';
    public var BALKAR = 'BAL ';
    public var BALINESE = 'BAN ';
    public var BAVARIAN = 'BAR ';
    public var BAULE = 'BAU ';
    public var BATAKTOBA = 'BBC ';
    public var BERBER = 'BBR ';
    public var BENCH = 'BCH ';
    public var BIBLESCREE = 'BCR ';
    public var BANDJALANG = 'BDY ';
    public var BELARUSSIAN = 'BEL ';
    public var BEMBA = 'BEM ';
    public var BENGALI = 'BEN ';
    public var HARYANVI = 'BGC ';
    public var BAGRI = 'BGQ ';
    public var BULGARIAN = 'BGR ';
    public var BHILI = 'BHI ';
    public var BHOJPURI = 'BHO ';
    public var BIKOL = 'BIK ';
    public var BILEN = 'BIL ';
    public var BISLAMA = 'BIS ';
    public var KANAUJI = 'BJJ ';
    public var BLACKFOOT = 'BKF ';
    public var BALUCHI = 'BLI ';
    public var PAOKAREN = 'BLK ';
    public var BALANTE = 'BLN ';
    public var BALTI = 'BLT ';
    public var BAMBARA = 'BMB ';
    public var BAMILEKE = 'BML ';
    public var BOSNIAN = 'BOS ';
    public var BISHNUPRIYAMANIPURI = 'BPY ';
    public var BRETON = 'BRE ';
    public var BRAHUI = 'BRH ';
    public var BRAJBHASHA = 'BRI ';
    public var BURMESE = 'BRM ';
    public var BODO = 'BRX ';
    public var BASHKIR = 'BSH ';
    public var BURUSHASKI = 'BSK ';
    public var BETI = 'BTI ';
    public var BATAKSIMALUNGUN = 'BTS ';
    public var BUGIS = 'BUG ';
    public var MEDUMBA = 'BYV ';
    public var KAQCHIKEL = 'CAK ';
    public var CATALAN = 'CAT ';
    public var ZAMBOANGACHAVACANO = 'CBK ';
    public var CEBUANO = 'CEB ';
    public var CHECHEN = 'CHE ';
    public var CHAHAGURAGE = 'CHG ';
    public var CHATTISGARHI = 'CHH ';
    public var CHICHEWA = 'CHI ';
    public var CHUKCHI = 'CHK ';
    public var CHOCTAW = 'CHO ';
    public var CHIPEWYAN = 'CHP ';
    public var CHEROKEE = 'CHR ';
    public var CHAMORRO = 'CHA ';
    public var CHUVASH = 'CHU ';
    public var CHEYENNE = 'CHY ';
    public var CHIGA = 'CGG ';
    public var WESTERNCHAM = 'CJA ';
    public var EASTERNCHAM = 'CJM ';
    public var COMORIAN = 'CMR ';
    public var COPTIC = 'COP ';
    public var CORNISH = 'COR ';
    public var CORSICAN = 'COS ';
    public var CREOLES = 'CPP ';
    public var CREE = 'CRE ';
    public var CARRIER = 'CRR ';
    public var CRIMEANTATAR = 'CRT ';
    public var KASHUBIAN = 'CSB ';
    public var CHURCHSLAVONIC = 'CSL ';
    public var CZECH = 'CSY ';
    public var CHITTAGONIAN = 'CTG ';
    public var SANBLASKUNA = 'CUK ';
    public var DANISH = 'DAN ';
    public var DARGWA = 'DAR ';
    public var DAYI = 'DAX ';
    public var WOODSCREE = 'DCR ';
    public var GERMAN = 'DEU ';
    public var DOGRI = 'DGO ';
    public var DOGRI2 = 'DGR ';
    public var DHANGU = 'DHG ';
    public var DIVEHI = 'DHV ';
    public var DIMLI = 'DIQ ';
    public var ZARMA = 'DJR ';
    public var DANGME = 'DNG ';
    public var DAN = 'DNJ ';
    public var DINKA = 'DNK ';
    public var DARI = 'DRI ';
    public var DHUWAL = 'DUJ ';
    public var DUNGAN = 'DUN ';
    public var DZONGKHA = 'DZN ';
    public var EBIRA = 'EBI ';
    public var EASTERNCREE = 'ECR ';
    public var EDO = 'EDO ';
    public var EFIK = 'EFI ';
    public var GREEK = 'ELL ';
    public var EASTERNMANINKAKAN = 'EMK ';
    public var ENGLISH = 'ENG ';
    public var ERZYA = 'ERZ ';
    public var SPANISH = 'ESP ';
    public var CENTRALYUPIK = 'ESU ';
    public var ESTONIAN = 'ETI ';
    public var BASQUE = 'EUQ ';
    public var EVENKI = 'EVK ';
    public var EVEN = 'EVN ';
    public var EWE = 'EWE ';
    public var FRENCHANTILLEAN = 'FAN ';
    public var PERSIAN = 'FAR ';
    public var FANTI = 'FAT ';
    public var FINNISH = 'FIN ';
    public var FIJIAN = 'FJI ';
    public var FLEMISH = 'FLE ';
    public var FEFE = 'FMP ';
    public var FORESTNENETS = 'FNE ';
    public var FON = 'FON ';
    public var FAROESE = 'FOS ';
    public var FRENCH = 'FRA ';
    public var CAJUNFRENCH = 'FRC ';
    public var FRISIAN = 'FRI ';
    public var FRIULIAN = 'FRL ';
    public var ARPITAN = 'FRP ';
    public var FUTA = 'FTA ';
    public var FULAH = 'FUL ';
    public var NIGERIANFULFULDE = 'FUV ';
    public var GA = 'GAD ';
    public var SCOTTISHGAELI = 'GAE ';
    public var GAGAUZ = 'GAG ';
    public var GALICIAN = 'GAL ';
    public var GARSHUNI = 'GAR ';
    public var GARHWALI = 'GAW ';
    public var GEEZ = 'GEZ ';
    public var GITHABUL = 'GIH ';
    public var GILYAK = 'GIL ';
    public var KPELLEGUINEA = 'GKP ';
    public var GILAKI = 'GLK ';
    public var GUMUZ = 'GMZ ';
    public var GUMATJ = 'GNN ';
    public var GOGO = 'GOG ';
    public var GONDI = 'GON ';
    public var GREENLANDIC = 'GRN ';
    public var GARO = 'GRO ';
    public var GUARANI = 'GUA ';
    public var WAYUU = 'GUC ';
    public var GUPAPUYNGU = 'GUF ';
    public var GUJARATI = 'GUJ ';
    public var GUSII = 'GUZ ';
    public var HAITIAN = 'HAI ';
    public var HALAM = 'HAL ';
    public var HARAUTI = 'HAR ';
    public var HAUSA = 'HAU ';
    public var HAWAIIAN = 'HAW ';
    public var HAYA = 'HAY ';
    public var HAZARAGI = 'HAZ ';
    public var HAMMERBANNA = 'HBN ';
    public var HERERO = 'HER ';
    public var HILIGAYNON = 'HIL ';
    public var HINDI = 'HIN ';
    public var HIGHMARI = 'HMA ';
    public var HMONG = 'HMN ';
    public var HIRIMOTU = 'HMO ';
    public var HINDKO = 'HND ';
    public var HARARI = 'HRI ';
    public var CROATIAN = 'HRV ';
    public var HUNGARIAN = 'HUN ';
    public var ARMENIAN = 'HYE ';
    public var IBAN = 'IBA ';
    public var IBIBIO = 'IBB ';
    public var IGBO = 'IBO ';
    public var IJOLANGUAGES = 'IJO ';
    public var IDO = 'IDO ';
    public var INTERLINGUE = 'ILE ';
    public var ILOKANO = 'ILO ';
    public var INTERLINGUA = 'INA ';
    public var INDONESIAN = 'IND ';
    public var INGUSH = 'ING ';
    public var INUKTITUT = 'INU ';
    public var INUPIAT = 'IPK ';
    public var IRISH = 'IRI ';
    public var IRISHTRADITIONAL = 'IRT ';
    public var ICELANDIC = 'ISL ';
    public var INARISAMI = 'ISM ';
    public var ITALIAN = 'ITA ';
    public var HEBREW = 'IWR ';
    public var JAMAICANCREOLE = 'JAM ';
    public var JAPANESE = 'JAN ';
    public var JAVANESE = 'JAV ';
    public var LOJBAN = 'JBO ';
    public var KRYMCHAK = 'JCT ';
    public var YIDDISH = 'JII ';
    public var LADINO = 'JUD ';
    public var JULA = 'JUL ';
    public var KABARDIAN = 'KAB ';
    public var KACHCHI = 'KAC ';
    public var KALENJIN = 'KAL ';
    public var KANNADA = 'KAN ';
    public var KARACHAY = 'KAR ';
    public var GEORGIAN = 'KAT ';
    public var KAZAKH = 'KAZ ';
    public var MAKONDE = 'KDE ';
    public var KABUVERDIANUCRIOULO = 'KEA ';
    public var KEBENA = 'KEB ';
    public var KEKCHI = 'KEK ';
    public var KHUTSURIGEORGIAN = 'KGE ';
    public var KHAKASS = 'KHA ';
    public var KHANTYKAZIM = 'KHK ';
    public var KHMER = 'KHM ';
    public var KHANTYSHURISHKAR = 'KHS ';
    public var KHAMTISHAN = 'KHT ';
    public var KHANTYVAKHI = 'KHV ';
    public var KHOWAR = 'KHW ';
    public var KIKUYUGIKUYU = 'KIK ';
    public var KIRGHIZKYRGYZ = 'KIR ';
    public var KISII = 'KIS ';
    public var KIRMANJKI = 'KIU ';
    public var SOUTHERNKIWAI = 'KJD ';
    public var EASTERNPWOKAREN = 'KJP ';
    public var BUMTHANGKHA = 'KJZ ';
    public var KOKNI = 'KKN ';
    public var KALMYK = 'KLM ';
    public var KAMBA = 'KMB ';
    public var KUMAONI = 'KMN ';
    public var KOMO = 'KMO ';
    public var KOMSO = 'KMS ';
    public var KHORASANITURKIC = 'KMZ ';
    public var KANURI = 'KNR ';
    public var KODAGU = 'KOD ';
    public var KOREANOLDHANGUL = 'KOH ';
    public var KONKANI = 'KOK ';
    public var KIKONGO = 'KON ';
    public var KOMI = 'KOM ';
    public var KOMIPERMYAK = 'KOP ';
    public var KOREAN = 'KOR ';
    public var KOSRAEAN = 'KOS ';
    public var KOMIZYRIAN = 'KOZ ';
    public var KPELLE = 'KPL ';
    public var KRIO = 'KRI ';
    public var KARAKALPAK = 'KRK ';
    public var KARELIAN = 'KRL ';
    public var KARAIM = 'KRM ';
    public var KAREN = 'KRN ';
    public var KOORETE = 'KRT ';
    public var KASHMIRI = 'KSH ';
    public var KHASI = 'KSI ';
    public var KILDINSAMI = 'KSM ';
    public var SGAWKAREN = 'KSW ';
    public var KUANYAMA = 'KUA ';
    public var KUI = 'KUI ';
    public var KULVI = 'KUL ';
    public var KUMYK = 'KUM ';
    public var KURDISH = 'KUR ';
    public var KURUKH = 'KUU ';
    public var KUY = 'KUY ';
    public var KORYAK = 'KYK ';
    public var WESTERNKAYAH = 'KYU ';
    public var LADIN = 'LAD ';
    public var LAHULI = 'LAH ';
    public var LAK = 'LAK ';
    public var LAMBANI = 'LAM ';
    public var LAO = 'LAO ';
    public var LATIN = 'LAT ';
    public var LAZ = 'LAZ ';
    public var LCREE = 'LCR ';
    public var LADAKHI = 'LDK ';
    public var LEZGI = 'LEZ ';
    public var LIGURIAN = 'LIJ ';
    public var LIMBURGISH = 'LIM ';
    public var LINGALA = 'LIN ';
    public var LISU = 'LIS ';
    public var LAMPUNG = 'LJP ';
    public var LAKI = 'LKI ';
    public var LOWMARI = 'LMA ';
    public var LIMBU = 'LMB ';
    public var LOMBARD = 'LMO ';
    public var LOMWE = 'LMW ';
    public var LOMA = 'LOM ';
    public var LURI = 'LRC ';
    public var LOWERSORBIAN = 'LSB ';
    public var LULESAMI = 'LSM ';
    public var LITHUANIAN = 'LTH ';
    public var LUXEMBOURGISH = 'LTZ ';
    public var LUBALULUA = 'LUA ';
    public var LUBAKATANGA = 'LUB ';
    public var GANDA = 'LUG ';
    public var LUYIA = 'LUH ';
    public var LUO = 'LUO ';
    public var LATVIAN = 'LVI ';
    public var MADURA = 'MAD ';
    public var MAGAHI = 'MAG ';
    public var MARSHALLESE = 'MAH ';
    public var MAJANG = 'MAJ ';
    public var MAKHUWA = 'MAK ';
    public var MALAYALAM = 'MAL ';
    public var MAM = 'MAM ';
    public var MANSI = 'MAN ';
    public var MAPUDUNGUN = 'MAP ';
    public var MARATHI = 'MAR ';
    public var MARWARI = 'MAW ';
    public var MBUNDU = 'MBN ';
    public var MBO = 'MBO ';
    public var MANCHU = 'MCH ';
    public var MOOSECREE = 'MCR ';
    public var MENDE = 'MDE ';
    public var MANDAR = 'MDR ';
    public var MEEN = 'MEN ';
    public var MERU = 'MER ';
    public var PATTANIMALAY = 'MFA ';
    public var MORISYEN = 'MFE ';
    public var MINANGKABAU = 'MIN ';
    public var MIZO = 'MIZ ';
    public var MACEDONIAN = 'MKD ';
    public var MAKASAR = 'MKR ';
    public var KITUBA = 'MKW ';
    public var MALE = 'MLE ';
    public var MALAGASY = 'MLG ';
    public var MALINKE = 'MLN ';
    public var MALAYALAMREFORMED = 'MLR ';
    public var MALAY = 'MLY ';
    public var MANDINKA = 'MND ';
    public var MONGOLIAN = 'MNG ';
    public var MANIPURI = 'MNI ';
    public var MANINKA = 'MNK ';
    public var MANX = 'MNX ';
    public var MOHAWK = 'MOH ';
    public var MOKSHA = 'MOK ';
    public var MOLDAVIAN = 'MOL ';
    public var MON = 'MON ';
    public var MOROCCAN = 'MOR ';
    public var MOSSI = 'MOS ';
    public var MAORI = 'MRI ';
    public var MAITHILI = 'MTH ';
    public var MALTESE = 'MTS ';
    public var MUNDARI = 'MUN ';
    public var MUSCOGEE = 'MUS ';
    public var MIRANDESE = 'MWL ';
    public var HMONGDAW = 'MWW ';
    public var MAYAN = 'MYN ';
    public var MAZANDERANI = 'MZN ';
    public var NAGAASSAMESE = 'NAG ';
    public var NAHUATL = 'NAH ';
    public var NANAI = 'NAN ';
    public var NEAPOLITAN = 'NAP ';
    public var NASKAPI = 'NAS ';
    public var NAURUAN = 'NAU ';
    public var NAVAJO = 'NAV ';
    public var NCREE = 'NCR ';
    public var NDEBELE = 'NDB ';
    public var NDAU = 'NDC ';
    public var NDONGA = 'NDG ';
    public var LOSAXON = 'NDS ';
    public var NEPALI = 'NEP ';
    public var NEWARI = 'NEW ';
    public var NGBAKA = 'NGA ';
    public var NAGARI = 'NGR ';
    public var NORWAYHOUSECREE = 'NHC ';
    public var NISI = 'NIS ';
    public var NIUEAN = 'NIU ';
    public var NYANKOLE = 'NKL ';
    public var NKO = 'NKO ';
    public var DUTCH = 'NLD ';
    public var NIMADI = 'NOE ';
    public var NOGAI = 'NOG ';
    public var NORWEGIAN = 'NOR ';
    public var NOVIAL = 'NOV ';
    public var NORTHERNSAMI = 'NSM ';
    public var SOTHONORTHERN = 'NSO ';
    public var NORTHERNTAI = 'NTA ';
    public var ESPERANTO = 'NTO ';
    public var NYAMWEZI = 'NYM ';
    public var NORWEGIANNYNORSK = 'NYN ';
    public var MBEMBETIGON = 'NZA ';
    public var OCCITAN = 'OCI ';
    public var OJICREE = 'OCR ';
    public var OJIBWAY = 'OJB ';
    public var ODIA = 'ORI ';
    public var OROMO = 'ORO ';
    public var OSSETIAN = 'OSS ';
    public var PALESTINIANARAMAIC = 'PAA ';
    public var PANGASINAN = 'PAG ';
    public var PALI = 'PAL ';
    public var PAMPANGAN = 'PAM ';
    public var PUNJABI = 'PAN ';
    public var PALPA = 'PAP ';
    public var PASHTO = 'PAS ';
    public var PALAUAN = 'PAU ';
    public var BOUYEI = 'PCC ';
    public var PICARD = 'PCD ';
    public var PENNSYLVANIAGERMAN = 'PDC ';
    public var POLYTONICGREEK = 'PGR ';
    public var PHAKE = 'PHK ';
    public var NORFOLK = 'PIH ';
    public var FILIPINO = 'PIL ';
    public var PALAUNG = 'PLG ';
    public var POLISH = 'PLK ';
    public var PIEMONTESE = 'PMS ';
    public var WESTERNPANJABI = 'PNB ';
    public var POCOMCHI = 'POH ';
    public var POHNPEIAN = 'PON ';
    public var PROVENCAL = 'PRO ';
    public var PORTUGUESE = 'PTG ';
    public var WESTERNPWOKAREN = 'PWO ';
    public var CHIN = 'QIN ';
    public var KICHE = 'QUC ';
    public var QUECHUABOLIVIA = 'QUH ';
    public var QUECHUA = 'QUZ ';
    public var QUECHUAECUADOR = 'QVI ';
    public var QUECHUAPERU = 'QWH ';
    public var RAJASTHANI = 'RAJ ';
    public var RAROTONGAN = 'RAR ';
    public var RUSSIANBURIAT = 'RBU ';
    public var RCREE = 'RCR ';
    public var REJANG = 'REJ ';
    public var RIANG = 'RIA ';
    public var TARIFIT = 'RIF ';
    public var RITARUNGO = 'RIT ';
    public var ARAKWAL = 'RKW ';
    public var ROMANSH = 'RMS ';
    public var VLAXROMANI = 'RMY ';
    public var ROMANIAN = 'ROM ';
    public var ROMANY = 'ROY ';
    public var RUSYN = 'RSY ';
    public var ROTUMAN = 'RTM ';
    public var KINYARWANDA = 'RUA ';
    public var RUNDI = 'RUN ';
    public var AROMANIAN = 'RUP ';
    public var RUSSIAN = 'RUS ';
    public var SADRI = 'SAD ';
    public var SANSKRIT = 'SAN ';
    public var SASAK = 'SAS ';
    public var SANTALI = 'SAT ';
    public var SAYISI = 'SAY ';
    public var SICILIAN = 'SCN ';
    public var SCOTS = 'SCO ';
    public var SEKOTA = 'SEK ';
    public var SELKUP = 'SEL ';
    public var OLDIRISH = 'SGA ';
    public var SANGO = 'SGO ';
    public var SAMOGITIAN = 'SGS ';
    public var TACHELHIT = 'SHI ';
    public var SHAN = 'SHN ';
    public var SIBE = 'SIB ';
    public var SIDAMO = 'SID ';
    public var SILTEGURAGE = 'SIG ';
    public var SKOLTSAMI = 'SKS ';
    public var SLOVAK = 'SKY ';
    public var NORTHSLAVEY = 'SCS ';
    public var SLAVEY = 'SLA ';
    public var SLOVENIAN = 'SLV ';
    public var SOMALI = 'SML ';
    public var SAMOAN = 'SMO ';
    public var SENA = 'SNA ';
    public var SINDHI = 'SND ';
    public var SINHALASINHALESE = 'SNH ';
    public var SONINKE = 'SNK ';
    public var SODOGURAGE = 'SOG ';
    public var SONGE = 'SOP ';
    public var SOTHOSOUTHERN = 'SOT ';
    public var ALBANIAN = 'SQI ';
    public var SERBIAN = 'SRB ';
    public var SARDINIAN = 'SRD ';
    public var SARAIKI = 'SRK ';
    public var SERER = 'SRR ';
    public var SOUTHSLAVEY = 'SSL ';
    public var SOUTHERNSAMI = 'SSM ';
    public var SATERLANDFRISIAN = 'STQ ';
    public var SUKUMA = 'SUK ';
    public var SUNDANESE = 'SUN ';
    public var SURI = 'SUR ';
    public var SVAN = 'SVA ';
    public var SWEDISH = 'SVE ';
    public var SWADAYAARAMAIC = 'SWA ';
    public var SWAHILI = 'SWK ';
    public var SWATI = 'SWZ ';
    public var SUTU = 'SXT ';
    public var UPPERSAXON = 'SXU ';
    public var SYLHETI = 'SYL ';
    public var SYRIAC = 'SYR ';
    public var SYRIACESTRANGELA = 'Syre';
    public var SYRIACWESTERN = 'Syrj';
    public var SYRIACEASTERN = 'Syrn';
    public var SILESIAN = 'SZL ';
    public var TABASARAN = 'TAB ';
    public var TAJIKI = 'TAJ ';
    public var TAMIL = 'TAM ';
    public var TATAR = 'TAT ';
    public var THCREE = 'TCR ';
    public var DEHONDAI = 'TDD ';
    public var TELUGU = 'TEL ';
    public var TETUM = 'TET ';
    public var TAGALOG = 'TGL ';
    public var TONGAN = 'TGN ';
    public var TIGRE = 'TGR ';
    public var TIGRINYA = 'TGY ';
    public var THAI = 'THA ';
    public var TAHITIAN = 'THT ';
    public var TIBETAN = 'TIB ';
    public var TIV = 'TIV ';
    public var TURKMEN = 'TKM ';
    public var TAMASHEK = 'TMH ';
    public var TEMNE = 'TMN ';
    public var TSWANA = 'TNA ';
    public var TUNDRANENETS = 'TNE ';
    public var TONGA = 'TNG ';
    public var TODO = 'TOD ';
    public var TOKPISIN = 'TPI ';
    public var TURKISH = 'TRK ';
    public var TSONGA = 'TSG ';
    public var TSHANGLA = 'TSJ ';
    public var TUROYOARAMAIC = 'TUA ';
    public var TULU = 'TUM ';
    public var TUMBUKA = 'TUL ';
    public var TUVIN = 'TUV ';
    public var TUVALU = 'TVL ';
    public var TWI = 'TWI ';
    public var TAY = 'TYZ ';
    public var TAMAZIGHT = 'TZM ';
    public var TZOTZIL = 'TZO ';
    public var UDMURT = 'UDM ';
    public var UKRAINIAN = 'UKR ';
    public var UMBUNDU = 'UMB ';
    public var URDU = 'URD ';
    public var UPPERSORBIAN = 'USB ';
    public var UYGHUR = 'UYG ';
    public var UZBEK = 'UZB ';
    public var VENETIAN = 'VEC ';
    public var VENDA = 'VEN ';
    public var VIETNAMESE = 'VIT ';
    public var VOLAPUEK = 'VOL ';
    public var VOERO = 'VRO ';
    public var WAGDI = 'WAG ';
    public var WARAYWARAY = 'WAR ';
    public var WESTCREE = 'WCR ';
    public var WELSH = 'WEL ';
    public var WALLOON = 'WLN ';
    public var WOLOF = 'WLF ';
    public var MEWATI = 'WTM ';
    public var LUE = 'XBD ';
    public var KHENGKHA = 'XKF ';
    public var XHOSA = 'XHS ';
    public var MINJANGBAL = 'XJB ';
    public var SOGA = 'XOG ';
    public var KPELLELIBERIA = 'XPE ';
    public var SAKHA = 'YAK ';
    public var YAO = 'YAO ';
    public var YAPESE = 'YAP ';
    public var YORUBA = 'YBA ';
    public var YCREE = 'YCR ';
    public var YICLASSIC = 'YIC ';
    public var YIMODERN = 'YIM ';
    public var ZEALANDIC = 'ZEA ';
    public var STANDARDMOROCCANTAMAZIGHT = 'ZGH ';
    public var ZHUANG = 'ZHA ';
    public var CHINESEHONGKONGSAR = 'ZHH ';
    public var CHINESEPHONETIC = 'ZHP ';
    public var CHINESESIMPLIFIED = 'ZHS ';
    public var CHINESETRADITIONAL = 'ZHT ';
    public var ZANDE = 'ZND ';
    public var ZULU = 'ZUL ';
    public var ZAZAKI = 'ZZA ';

    @:to
    public function toString():String {
        return this;
    }

}
