# Contributing to fonthx

Thanks for your interest in contributing to fonthx.

## Before contributing 

Please note the following principles which inform the development of fonthx:

* fonthx was created as a **font-file generation** library and that remains its **sole** focus. 
* fonthx was created primarily for font-generation at FontStruct.com and is still used by that project.

Please submit bug fixes and small improvements/enhancements as pull requests. Ideally including any relevant specs (tests).

## Before working on and/or creating pull requests for larger feature additions
 
Please discuss them with the repo maintainer, for example in an issue.

## Code Style

Please keep any code contributions consistent with the style found elsewhere in the repository.

## If you have not contributed to open source projects before

* Create a personal fork of the project on Github.
* Clone the fork on your local machine. Your remote repo on Github is called origin.
* Add the original repository as a remote called upstream.
* If you created your fork a while ago be sure to pull upstream changes into your local repository.
* Create a new branch to work on! Branch from develop if it exists, else from master.
* Implement/fix your feature.
* Run the project tests.
* Write or adapt tests as needed.
* Add or change the documentation as needed.
* Squash your commits into a single commit with git's interactive rebase. Create a new branch if necessary.
* Push your branch to your fork on Github, the remote origin.
* From your fork open a pull request in the dev branch.



