/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.google.android.gms.auth.api.credentials.CredentialPickerConfig;
import com.google.android.gms.auth.api.credentials.zzi;
import com.google.android.gms.auth.api.credentials.zzj;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;

@SafeParcelable.Class(creator="HintRequestCreator")
public final class HintRequest
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final Parcelable.Creator<HintRequest> CREATOR = new zzj();
    @SafeParcelable.Field(id=1000)
    private final int zzu;
    @SafeParcelable.Field(id=1, getter="getHintPickerConfig")
    private final CredentialPickerConfig zzah;
    @SafeParcelable.Field(id=2, getter="isEmailAddressIdentifierSupported")
    private final boolean zzai;
    @SafeParcelable.Field(id=3, getter="isPhoneNumberIdentifierSupported")
    private final boolean zzaj;
    @SafeParcelable.Field(id=4, getter="getAccountTypes")
    private final String[] zzaa;
    @SafeParcelable.Field(id=5, getter="isIdTokenRequested")
    private final boolean zzad;
    @SafeParcelable.Field(id=6, getter="getServerClientId")
    private final String zzae;
    @SafeParcelable.Field(id=7, getter="getIdTokenNonce")
    private final String zzaf;

    @SafeParcelable.Constructor
    HintRequest(@SafeParcelable.Param(id=1000) int n, @SafeParcelable.Param(id=1) CredentialPickerConfig credentialPickerConfig, @SafeParcelable.Param(id=2) boolean bl, @SafeParcelable.Param(id=3) boolean bl2, @SafeParcelable.Param(id=4) String[] stringArray, @SafeParcelable.Param(id=5) boolean bl3, @SafeParcelable.Param(id=6) String string, @SafeParcelable.Param(id=7) String string2) {
        this.zzu = n;
        this.zzah = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)((Object)credentialPickerConfig)));
        this.zzai = bl;
        this.zzaj = bl2;
        this.zzaa = (String[])Preconditions.checkNotNull((Object)stringArray);
        if (this.zzu < 2) {
            this.zzad = true;
            this.zzae = null;
            this.zzaf = null;
            return;
        }
        this.zzad = bl3;
        this.zzae = string;
        this.zzaf = string2;
    }

    private HintRequest(Builder builder) {
        this(2, builder.zzah, builder.zzai, builder.zzaj, builder.zzaa, builder.zzad, builder.zzae, builder.zzaf);
    }

    @NonNull
    public final CredentialPickerConfig getHintPickerConfig() {
        return this.zzah;
    }

    public final boolean isEmailAddressIdentifierSupported() {
        return this.zzai;
    }

    @NonNull
    public final String[] getAccountTypes() {
        return this.zzaa;
    }

    public final boolean isIdTokenRequested() {
        return this.zzad;
    }

    @Nullable
    public final String getServerClientId() {
        return this.zzae;
    }

    @Nullable
    public final String getIdTokenNonce() {
        return this.zzaf;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        HintRequest hintRequest = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)1, (Parcelable)hintRequest.getHintPickerConfig(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)2, (boolean)hintRequest.isEmailAddressIdentifierSupported());
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)3, (boolean)hintRequest.zzaj);
        SafeParcelWriter.writeStringArray((Parcel)parcel2, (int)4, (String[])hintRequest.getAccountTypes(), (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)5, (boolean)hintRequest.isIdTokenRequested());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)hintRequest.getServerClientId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)hintRequest.getIdTokenNonce(), (boolean)false);
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)1000, (int)hintRequest.zzu);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    /* synthetic */ HintRequest(Builder builder, zzi zzi2) {
        this(builder);
    }

    public static final class Builder {
        private boolean zzai;
        private boolean zzaj;
        private String[] zzaa;
        private CredentialPickerConfig zzah = new CredentialPickerConfig.Builder().build();
        private boolean zzad = false;
        private String zzae;
        private String zzaf;

        public Builder() {
        }

        public final Builder setEmailAddressIdentifierSupported(boolean bl) {
            this.zzai = bl;
            return this;
        }

        public final Builder setPhoneNumberIdentifierSupported(boolean bl) {
            this.zzaj = bl;
            return this;
        }

        public final Builder setAccountTypes(String ... stringArray) {
            if (stringArray == null) {
                stringArray = new String[]{};
            }
            this.zzaa = stringArray;
            return this;
        }

        public final Builder setHintPickerConfig(@NonNull CredentialPickerConfig credentialPickerConfig) {
            this.zzah = (CredentialPickerConfig)((Object)Preconditions.checkNotNull((Object)((Object)credentialPickerConfig)));
            return this;
        }

        public final Builder setIdTokenRequested(boolean bl) {
            this.zzad = bl;
            return this;
        }

        public final Builder setServerClientId(@Nullable String string) {
            this.zzae = string;
            return this;
        }

        public final Builder setIdTokenNonce(@Nullable String string) {
            this.zzaf = string;
            return this;
        }

        public final HintRequest build() {
            if (this.zzaa == null) {
                this.zzaa = new String[0];
            }
            if (!this.zzai && !this.zzaj && this.zzaa.length == 0) {
                throw new IllegalStateException("At least one authentication method must be specified");
            }
            return new HintRequest(this, null);
        }
    }
}

