/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.auth.api.credentials;

import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import com.google.android.gms.auth.api.credentials.IdToken;
import com.google.android.gms.auth.api.credentials.zzc;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

@SafeParcelable.Reserved(value={1000})
@SafeParcelable.Class(creator="CredentialCreator")
public class Credential
extends AbstractSafeParcelable
implements ReflectedParcelable {
    public static final String EXTRA_KEY = "com.google.android.gms.credentials.Credential";
    public static final Parcelable.Creator<Credential> CREATOR = new zzc();
    @Nonnull
    @SafeParcelable.Field(id=1, getter="getId")
    private final String mId;
    @SafeParcelable.Field(id=2, getter="getName")
    @Nullable
    private final String mName;
    @SafeParcelable.Field(id=3, getter="getProfilePictureUri")
    @Nullable
    private final Uri zzo;
    @Nonnull
    @SafeParcelable.Field(id=4, getter="getIdTokens")
    private final List<IdToken> zzp;
    @SafeParcelable.Field(id=5, getter="getPassword")
    @Nullable
    private final String zzq;
    @SafeParcelable.Field(id=6, getter="getAccountType")
    @Nullable
    private final String zzr;
    @SafeParcelable.Field(id=9, getter="getGivenName")
    @Nullable
    private final String zzs;
    @SafeParcelable.Field(id=10, getter="getFamilyName")
    @Nullable
    private final String zzt;

    /*
     * Unable to fully structure code
     */
    @SafeParcelable.Constructor
    Credential(@SafeParcelable.Param(id=1) String var1_1, @SafeParcelable.Param(id=2) String var2_2, @SafeParcelable.Param(id=3) Uri var3_3, @SafeParcelable.Param(id=4) List<IdToken> var4_4, @SafeParcelable.Param(id=5) String var5_5, @SafeParcelable.Param(id=6) String var6_6, @SafeParcelable.Param(id=9) String var7_7, @SafeParcelable.Param(id=10) String var8_8) {
        block8: {
            super();
            var9_9 = ((String)Preconditions.checkNotNull((Object)var1_1, (Object)"credential identifier cannot be null")).trim();
            Preconditions.checkNotEmpty((String)var9_9, (Object)"credential identifier cannot be empty");
            if (var5_5 != null && TextUtils.isEmpty((CharSequence)var5_5)) {
                throw new IllegalArgumentException("Password must not be empty if set");
            }
            if (var6_6 == null) break block8;
            var10_10 = var6_6;
            if (TextUtils.isEmpty((CharSequence)var10_10)) ** GOTO lbl-1000
            var11_11 = Uri.parse((String)var10_10);
            if (!var11_11.isAbsolute() || !var11_11.isHierarchical() || TextUtils.isEmpty((CharSequence)var11_11.getScheme()) || TextUtils.isEmpty((CharSequence)var11_11.getAuthority())) {
                v0 = false;
            } else if ("http".equalsIgnoreCase(var11_11.getScheme()) || "https".equalsIgnoreCase(var11_11.getScheme())) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            if (!Boolean.valueOf(v0).booleanValue()) {
                throw new IllegalArgumentException("Account type must be a valid Http/Https URI");
            }
        }
        if (!TextUtils.isEmpty((CharSequence)var6_6) && !TextUtils.isEmpty((CharSequence)var5_5)) {
            throw new IllegalArgumentException("Password and AccountType are mutually exclusive");
        }
        if (var2_2 != null && TextUtils.isEmpty((CharSequence)var2_2.trim())) {
            var2_2 = null;
        }
        this.mName = var2_2;
        this.zzo = var3_3;
        this.zzp = var4_4 == null ? Collections.emptyList() : Collections.unmodifiableList(var4_4);
        this.mId = var9_9;
        this.zzq = var5_5;
        this.zzr = var6_6;
        this.zzs = var7_7;
        this.zzt = var8_8;
    }

    @Nonnull
    public String getId() {
        return this.mId;
    }

    @Nullable
    public String getName() {
        return this.mName;
    }

    @Nullable
    public Uri getProfilePictureUri() {
        return this.zzo;
    }

    @Nonnull
    public List<IdToken> getIdTokens() {
        return this.zzp;
    }

    @Nullable
    public String getPassword() {
        return this.zzq;
    }

    @Nullable
    public String getAccountType() {
        return this.zzr;
    }

    @Nullable
    public String getGivenName() {
        return this.zzs;
    }

    @Nullable
    public String getFamilyName() {
        return this.zzt;
    }

    public void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        Credential credential = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)credential.getId(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)2, (String)credential.getName(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)3, (Parcelable)credential.getProfilePictureUri(), (int)n, (boolean)false);
        SafeParcelWriter.writeTypedList((Parcel)parcel2, (int)4, credential.getIdTokens(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)5, (String)credential.getPassword(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)6, (String)credential.getAccountType(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)9, (String)credential.getGivenName(), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)10, (String)credential.getFamilyName(), (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Credential)) {
            return false;
        }
        Credential credential = (Credential)((Object)object);
        return TextUtils.equals((CharSequence)this.mId, (CharSequence)credential.mId) && TextUtils.equals((CharSequence)this.mName, (CharSequence)credential.mName) && Objects.equal((Object)this.zzo, (Object)credential.zzo) && TextUtils.equals((CharSequence)this.zzq, (CharSequence)credential.zzq) && TextUtils.equals((CharSequence)this.zzr, (CharSequence)credential.zzr);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.mId, this.mName, this.zzo, this.zzq, this.zzr});
    }

    public static class Builder {
        private final String mId;
        private String mName;
        private Uri zzo;
        private List<IdToken> zzp;
        private String zzq;
        private String zzr;
        private String zzs;
        private String zzt;

        public Builder(String string) {
            this.mId = string;
        }

        public Builder(Credential credential) {
            this.mId = credential.mId;
            this.mName = credential.mName;
            this.zzo = credential.zzo;
            this.zzp = credential.zzp;
            this.zzq = credential.zzq;
            this.zzr = credential.zzr;
            this.zzs = credential.zzs;
            this.zzt = credential.zzt;
        }

        public Builder setName(String string) {
            this.mName = string;
            return this;
        }

        public Builder setProfilePictureUri(Uri uri) {
            this.zzo = uri;
            return this;
        }

        public Builder setPassword(String string) {
            this.zzq = string;
            return this;
        }

        public Builder setAccountType(String string) {
            this.zzr = string;
            return this;
        }

        public Credential build() {
            return new Credential(this.mId, this.mName, this.zzo, this.zzp, this.zzq, this.zzr, this.zzs, this.zzt);
        }
    }
}

