/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.internal;

import android.content.Context;
import android.content.res.ColorStateList;
import android.content.res.Resources;
import android.graphics.PorterDuff;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.support.v4.graphics.drawable.DrawableCompat;
import android.util.AttributeSet;
import android.widget.Button;
import com.google.android.gms.base.R;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.internal.SignInButtonConfig;
import com.google.android.gms.common.util.DeviceProperties;

public final class SignInButtonImpl
extends Button {
    public SignInButtonImpl(Context context) {
        this(context, null);
    }

    public SignInButtonImpl(Context context, AttributeSet attributeSet) {
        super(context, attributeSet, 16842824);
    }

    public final void configure(Resources resources, SignInButtonConfig signInButtonConfig) {
        this.configure(resources, signInButtonConfig.getButtonSize(), signInButtonConfig.getColorScheme());
    }

    public final void configure(Resources resources, int n, int n2) {
        int n3;
        Resources resources2 = resources;
        SignInButtonImpl signInButtonImpl = this;
        signInButtonImpl.setTypeface(Typeface.DEFAULT_BOLD);
        signInButtonImpl.setTextSize(14.0f);
        float f = resources2.getDisplayMetrics().density;
        signInButtonImpl.setMinHeight((int)(f * 48.0f + 0.5f));
        signInButtonImpl.setMinWidth((int)(f * 48.0f + 0.5f));
        resources2 = resources;
        signInButtonImpl = this;
        int n4 = SignInButtonImpl.zaa(n2, R.drawable.common_google_signin_btn_text_dark, R.drawable.common_google_signin_btn_text_light, R.drawable.common_google_signin_btn_text_light);
        int n5 = SignInButtonImpl.zaa(n2, R.drawable.common_google_signin_btn_icon_dark, R.drawable.common_google_signin_btn_icon_light, R.drawable.common_google_signin_btn_icon_light);
        switch (n) {
            case 0: 
            case 1: {
                n3 = n4;
                break;
            }
            case 2: {
                n3 = n5;
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(32).append("Unknown button size: ").append(n).toString());
            }
        }
        int n6 = n3;
        Drawable drawable2 = DrawableCompat.wrap((Drawable)resources2.getDrawable(n6));
        DrawableCompat.setTintList((Drawable)drawable2, (ColorStateList)resources2.getColorStateList(R.color.common_google_signin_btn_tint));
        DrawableCompat.setTintMode((Drawable)drawable2, (PorterDuff.Mode)PorterDuff.Mode.SRC_ATOP);
        signInButtonImpl.setBackgroundDrawable(drawable2);
        resources2 = resources;
        signInButtonImpl = this;
        n6 = SignInButtonImpl.zaa(n2, R.color.common_google_signin_btn_text_dark, R.color.common_google_signin_btn_text_light, R.color.common_google_signin_btn_text_light);
        signInButtonImpl.setTextColor((ColorStateList)Preconditions.checkNotNull((Object)resources2.getColorStateList(n6)));
        switch (n) {
            case 0: {
                signInButtonImpl.setText(resources2.getString(R.string.common_signin_button_text));
                break;
            }
            case 1: {
                signInButtonImpl.setText(resources2.getString(R.string.common_signin_button_text_long));
                break;
            }
            case 2: {
                signInButtonImpl.setText(null);
                break;
            }
            default: {
                throw new IllegalStateException(new StringBuilder(32).append("Unknown button size: ").append(n).toString());
            }
        }
        signInButtonImpl.setTransformationMethod(null);
        if (DeviceProperties.isWearable((Context)signInButtonImpl.getContext())) {
            signInButtonImpl.setGravity(19);
        }
    }

    private static int zaa(int n, int n2, int n3, int n4) {
        switch (n) {
            case 0: {
                return n2;
            }
            case 1: {
                return n3;
            }
            case 2: {
                return n4;
            }
        }
        throw new IllegalStateException(new StringBuilder(33).append("Unknown color scheme: ").append(n).toString());
    }
}

