/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.android.gms.internal.firebase_auth.zzfu;
import com.google.android.gms.internal.firebase_auth.zzga;
import com.google.android.gms.internal.firebase_auth.zzhm;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgp
extends zzed<Long>
implements zzga<Long>,
zzhm,
RandomAccess {
    private static final zzgp zzyx = new zzgp();
    private long[] zzyy;
    private int size;

    zzgp() {
        this(new long[10], 0);
    }

    private zzgp(long[] lArray, int n) {
        this.zzyy = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzew();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyy, n2, this.zzyy, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgp)) {
            return super.equals(object);
        }
        zzgp zzgp2 = (zzgp)object;
        if (this.size != zzgp2.size) {
            return false;
        }
        long[] lArray = zzgp2.zzyy;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyy[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzfu.zzk(this.zzyy[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzh(n);
        return this.zzyy[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzl(long l) {
        this.zzk(this.size, l);
    }

    private final void zzk(int n, long l) {
        this.zzew();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzyy.length) {
            System.arraycopy(this.zzyy, n, this.zzyy, n + 1, this.size - n);
        } else {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyy, 0, lArray, 0, n);
            System.arraycopy(this.zzyy, n, lArray, n + 1, this.size - n);
            this.zzyy = lArray;
        }
        this.zzyy[n] = l;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzew();
        zzfu.checkNotNull(collection);
        if (!(collection instanceof zzgp)) {
            return super.addAll(collection);
        }
        zzgp zzgp2 = (zzgp)collection;
        if (zzgp2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgp2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgp2.size;
        if (n > this.zzyy.length) {
            this.zzyy = Arrays.copyOf(this.zzyy, n);
        }
        System.arraycopy(zzgp2.zzyy, 0, this.zzyy, this.size, zzgp2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzew();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyy[i])) continue;
            System.arraycopy(this.zzyy, i + 1, this.zzyy, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzgp zzgp2 = this;
        zzgp2.zzew();
        zzgp2.zzh(n);
        long l3 = zzgp2.zzyy[n];
        zzgp2.zzyy[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgp zzgp2 = this;
        zzgp2.zzew();
        zzgp2.zzh(n);
        long l = zzgp2.zzyy[n];
        if (n < zzgp2.size - 1) {
            System.arraycopy(zzgp2.zzyy, n + 1, zzgp2.zzyy, n, zzgp2.size - n);
        }
        --zzgp2.size;
        ++zzgp2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        this.zzk(n, l);
    }

    @Override
    public final /* synthetic */ zzga zzj(int n) {
        int n2 = n;
        zzgp zzgp2 = this;
        if (n2 < zzgp2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgp(Arrays.copyOf(zzgp2.zzyy, n2), zzgp2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzyx.zzev();
    }
}

