/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.android.gms.internal.firebase_auth.zzfu;
import com.google.android.gms.internal.firebase_auth.zzfy;
import com.google.android.gms.internal.firebase_auth.zzga;
import com.google.android.gms.internal.firebase_auth.zzhm;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzft
extends zzed<Integer>
implements zzfy,
zzhm,
RandomAccess {
    private static final zzft zzxt = new zzft();
    private int[] zzxu;
    private int size;

    public static zzft zzho() {
        return zzxt;
    }

    zzft() {
        this(new int[10], 0);
    }

    private zzft(int[] nArray, int n) {
        this.zzxu = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzew();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzxu, n2, this.zzxu, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzft)) {
            return super.equals(object);
        }
        zzft zzft2 = (zzft)object;
        if (this.size != zzft2.size) {
            return false;
        }
        int[] nArray = zzft2.zzxu;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzxu[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzxu[i];
        }
        return n;
    }

    @Override
    public final zzfy zzaq(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzft(Arrays.copyOf(this.zzxu, n), this.size);
    }

    public final int getInt(int n) {
        this.zzh(n);
        return this.zzxu[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzar(int n) {
        this.zzs(this.size, n);
    }

    private final void zzs(int n, int n2) {
        this.zzew();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzxu.length) {
            System.arraycopy(this.zzxu, n, this.zzxu, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzxu, 0, nArray, 0, n);
            System.arraycopy(this.zzxu, n, nArray, n + 1, this.size - n);
            this.zzxu = nArray;
        }
        this.zzxu[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzew();
        zzfu.checkNotNull(collection);
        if (!(collection instanceof zzft)) {
            return super.addAll(collection);
        }
        zzft zzft2 = (zzft)collection;
        if (zzft2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzft2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzft2.size;
        if (n > this.zzxu.length) {
            this.zzxu = Arrays.copyOf(this.zzxu, n);
        }
        System.arraycopy(zzft2.zzxu, 0, this.zzxu, this.size, zzft2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzew();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzxu[i])) continue;
            System.arraycopy(this.zzxu, i + 1, this.zzxu, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzft zzft2 = this;
        zzft2.zzew();
        zzft2.zzh(n);
        int n4 = zzft2.zzxu[n];
        zzft2.zzxu[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzft zzft2 = this;
        zzft2.zzew();
        zzft2.zzh(n);
        int n2 = zzft2.zzxu[n];
        if (n < zzft2.size - 1) {
            System.arraycopy(zzft2.zzxu, n + 1, zzft2.zzxu, n, zzft2.size - n);
        }
        --zzft2.size;
        ++zzft2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzs(n, n2);
    }

    @Override
    public final /* synthetic */ zzga zzj(int n) {
        return this.zzaq(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzxt.zzev();
    }
}

