/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.firebase_auth;

import com.google.android.gms.internal.firebase_auth.zzed;
import com.google.android.gms.internal.firebase_auth.zzfu;
import com.google.android.gms.internal.firebase_auth.zzga;
import com.google.android.gms.internal.firebase_auth.zzhm;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfc
extends zzed<Double>
implements zzga<Double>,
zzhm,
RandomAccess {
    private static final zzfc zztr = new zzfc();
    private double[] zzts;
    private int size;

    zzfc() {
        this(new double[10], 0);
    }

    private zzfc(double[] dArray, int n) {
        this.zzts = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzew();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzts, n2, this.zzts, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfc)) {
            return super.equals(object);
        }
        zzfc zzfc2 = (zzfc)object;
        if (this.size != zzfc2.size) {
            return false;
        }
        double[] dArray = zzfc2.zzts;
        for (int i = 0; i < this.size; ++i) {
            if (Double.doubleToLongBits(this.zzts[i]) == Double.doubleToLongBits(dArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzts[i]);
            n = n * 31 + zzfu.zzk(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzc(double d) {
        this.zzc(this.size, d);
    }

    private final void zzc(int n, double d) {
        this.zzew();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
        if (this.size < this.zzts.length) {
            System.arraycopy(this.zzts, n, this.zzts, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzts, 0, dArray, 0, n);
            System.arraycopy(this.zzts, n, dArray, n + 1, this.size - n);
            this.zzts = dArray;
        }
        this.zzts[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzew();
        zzfu.checkNotNull(collection);
        if (!(collection instanceof zzfc)) {
            return super.addAll(collection);
        }
        zzfc zzfc2 = (zzfc)collection;
        if (zzfc2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfc2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfc2.size;
        if (n > this.zzts.length) {
            this.zzts = Arrays.copyOf(this.zzts, n);
        }
        System.arraycopy(zzfc2.zzts, 0, this.zzts, this.size, zzfc2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzew();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzts[i])) continue;
            System.arraycopy(this.zzts, i + 1, this.zzts, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzh(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzi(n));
        }
    }

    private final String zzi(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzfc zzfc2 = this;
        zzfc2.zzew();
        zzfc2.zzh(n);
        double d3 = zzfc2.zzts[n];
        zzfc2.zzts[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfc zzfc2 = this;
        zzfc2.zzew();
        zzfc2.zzh(n);
        double d = zzfc2.zzts[n];
        if (n < zzfc2.size - 1) {
            System.arraycopy(zzfc2.zzts, n + 1, zzfc2.zzts, n, zzfc2.size - n);
        }
        --zzfc2.size;
        ++zzfc2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzc(n, d);
    }

    @Override
    public final /* synthetic */ zzga zzj(int n) {
        int n2 = n;
        zzfc zzfc2 = this;
        if (n2 < zzfc2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfc(Arrays.copyOf(zzfc2.zzts, n2), zzfc2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfc zzfc2 = this;
        zzfc2.zzh(n);
        return zzfc2.zzts[n];
    }

    static {
        zztr.zzev();
    }
}

