/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.common.api.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.ArrayMap;
import android.util.Log;
import com.google.android.gms.common.ConnectionResult;
import com.google.android.gms.common.GoogleApiAvailabilityLight;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.api.internal.SignInConnectionListener;
import com.google.android.gms.common.api.internal.zaaw;
import com.google.android.gms.common.api.internal.zabe;
import com.google.android.gms.common.api.internal.zabs;
import com.google.android.gms.common.api.internal.zaq;
import com.google.android.gms.common.api.internal.zat;
import com.google.android.gms.common.api.internal.zau;
import com.google.android.gms.common.api.internal.zav;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.base.zap;
import com.google.android.gms.signin.SignInOptions;
import com.google.android.gms.signin.zad;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import javax.annotation.concurrent.GuardedBy;

final class zas
implements zabs {
    private final Context mContext;
    private final zaaw zaee;
    private final Looper zabj;
    private final zabe zaef;
    private final zabe zaeg;
    private final Map<Api.AnyClientKey<?>, zabe> zaeh;
    private final Set<SignInConnectionListener> zaei = Collections.newSetFromMap(new WeakHashMap());
    private final Api.Client zaej;
    private Bundle zaek;
    private ConnectionResult zael = null;
    private ConnectionResult zaem = null;
    private boolean zaen = false;
    private final Lock zaeo;
    @GuardedBy(value="mLock")
    private int zaep = 0;

    public static zas zaa(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, ClientSettings clientSettings, Map<Api<?>, Boolean> map2, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, ArrayList<zaq> arrayList) {
        Object object;
        Api.Client client = null;
        ArrayMap arrayMap2 = new ArrayMap();
        ArrayMap arrayMap3 = new ArrayMap();
        for (Map.Entry<Api.AnyClientKey<?>, Api.Client> arrayMap4 : map.entrySet()) {
            object = arrayMap4.getValue();
            if (object.providesSignIn()) {
                client = object;
            }
            if (object.requiresSignIn()) {
                arrayMap2.put(arrayMap4.getKey(), object);
                continue;
            }
            arrayMap3.put(arrayMap4.getKey(), object);
        }
        Preconditions.checkState((!arrayMap2.isEmpty() ? 1 : 0) != 0, (Object)"CompositeGoogleApiClient should not be used without any APIs that require sign-in.");
        ArrayMap arrayMap5 = new ArrayMap();
        ArrayMap arrayMap = new ArrayMap();
        for (Api api : map2.keySet()) {
            Api.AnyClientKey<?> anyClientKey = api.getClientKey();
            if (arrayMap2.containsKey(anyClientKey)) {
                arrayMap5.put(api, map2.get(api));
                continue;
            }
            if (arrayMap3.containsKey(anyClientKey)) {
                arrayMap.put(api, map2.get(api));
                continue;
            }
            throw new IllegalStateException("Each API in the isOptionalMap must have a corresponding client in the clients map.");
        }
        object = new ArrayList<zaq>();
        ArrayList<zaq> arrayList2 = new ArrayList<zaq>();
        ArrayList<zaq> arrayList3 = arrayList;
        int n = arrayList3.size();
        for (int i = 0; i < n; ++i) {
            zaq zaq2 = arrayList3.get(i);
            zaq zaq3 = zaq2;
            if (arrayMap5.containsKey(zaq3.mApi)) {
                ((ArrayList)object).add(zaq3);
                continue;
            }
            if (arrayMap.containsKey(zaq3.mApi)) {
                arrayList2.add(zaq3);
                continue;
            }
            throw new IllegalStateException("Each ClientCallbacks must have a corresponding API in the isOptionalMap");
        }
        return new zas(context, zaaw2, lock, looper, googleApiAvailabilityLight, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap2, (Map<Api.AnyClientKey<?>, Api.Client>)arrayMap3, clientSettings, abstractClientBuilder, client, (ArrayList<zaq>)object, arrayList2, (Map<Api<?>, Boolean>)arrayMap5, (Map<Api<?>, Boolean>)arrayMap);
    }

    private zas(Context context, zaaw zaaw2, Lock lock, Looper looper, GoogleApiAvailabilityLight googleApiAvailabilityLight, Map<Api.AnyClientKey<?>, Api.Client> map, Map<Api.AnyClientKey<?>, Api.Client> map2, ClientSettings clientSettings, Api.AbstractClientBuilder<? extends zad, SignInOptions> abstractClientBuilder, Api.Client client, ArrayList<zaq> arrayList, ArrayList<zaq> arrayList2, Map<Api<?>, Boolean> map3, Map<Api<?>, Boolean> map4) {
        this.mContext = context;
        this.zaee = zaaw2;
        this.zaeo = lock;
        this.zabj = looper;
        this.zaej = client;
        this.zaef = new zabe(context, this.zaee, lock, looper, googleApiAvailabilityLight, map2, null, map4, null, arrayList2, new zau(this, null));
        this.zaeg = new zabe(context, this.zaee, lock, looper, googleApiAvailabilityLight, map, clientSettings, map3, abstractClientBuilder, arrayList, new zav(this, null));
        ArrayMap arrayMap = new ArrayMap();
        for (Api.AnyClientKey<?> anyClientKey : map2.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zaef);
        }
        for (Api.AnyClientKey<?> anyClientKey : map.keySet()) {
            arrayMap.put(anyClientKey, (Object)this.zaeg);
        }
        this.zaeh = Collections.unmodifiableMap(arrayMap);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, R extends Result, T extends BaseImplementation.ApiMethodImpl<R, A>> T enqueue(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zaz()) {
                t.setFailedResult(new Status(4, null, this.zaaa()));
                return t;
            }
            return this.zaeg.enqueue(t);
        }
        return this.zaef.enqueue(t);
    }

    @Override
    @GuardedBy(value="mLock")
    public final <A extends Api.AnyClient, T extends BaseImplementation.ApiMethodImpl<? extends Result, A>> T execute(@NonNull T t) {
        if (this.zaa(t)) {
            if (this.zaz()) {
                t.setFailedResult(new Status(4, null, this.zaaa()));
                return t;
            }
            return this.zaeg.execute(t);
        }
        return this.zaef.execute(t);
    }

    @Override
    @GuardedBy(value="mLock")
    @Nullable
    public final ConnectionResult getConnectionResult(@NonNull Api<?> api) {
        if (this.zaeh.get(api.getClientKey()).equals(this.zaeg)) {
            if (this.zaz()) {
                return new ConnectionResult(4, this.zaaa());
            }
            return this.zaeg.getConnectionResult(api);
        }
        return this.zaef.getConnectionResult(api);
    }

    @Override
    @GuardedBy(value="mLock")
    public final void connect() {
        this.zaep = 2;
        this.zaen = false;
        zas zas2 = this;
        this.zaem = null;
        zas2.zael = null;
        zas2.zaef.connect();
        zas2.zaeg.connect();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect() {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final ConnectionResult blockingConnect(long l, @NonNull TimeUnit timeUnit) {
        throw new UnsupportedOperationException();
    }

    @Override
    @GuardedBy(value="mLock")
    public final void disconnect() {
        this.zaem = null;
        this.zael = null;
        this.zaep = 0;
        this.zaef.disconnect();
        this.zaeg.disconnect();
        this.zay();
    }

    @Override
    public final boolean isConnected() {
        this.zaeo.lock();
        try {
            boolean bl = this.zaef.isConnected() && (this.zaeg.isConnected() || this.zaz() || this.zaep == 1);
            return bl;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final boolean isConnecting() {
        this.zaeo.lock();
        try {
            boolean bl = this.zaep == 2;
            return bl;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @Override
    public final boolean maybeSignIn(SignInConnectionListener signInConnectionListener) {
        this.zaeo.lock();
        try {
            if ((this.isConnecting() || this.isConnected()) && !this.zaeg.isConnected()) {
                this.zaei.add(signInConnectionListener);
                if (this.zaep == 0) {
                    this.zaep = 1;
                }
                this.zaem = null;
                this.zaeg.connect();
                return true;
            }
        }
        finally {
            this.zaeo.unlock();
        }
        return false;
    }

    @Override
    @GuardedBy(value="mLock")
    public final void zaw() {
        this.zaef.zaw();
        this.zaeg.zaw();
    }

    @Override
    public final void maybeSignOut() {
        this.zaeo.lock();
        try {
            boolean bl = this.isConnecting();
            this.zaeg.disconnect();
            this.zaem = new ConnectionResult(4);
            if (bl) {
                new zap(this.zabj).post(new zat(this));
            } else {
                this.zay();
            }
            return;
        }
        finally {
            this.zaeo.unlock();
        }
    }

    @GuardedBy(value="mLock")
    private final void zax() {
        if (zas.zab(this.zael)) {
            if (zas.zab(this.zaem) || this.zaz()) {
                zas zas2 = this;
                switch (zas2.zaep) {
                    case 2: {
                        zas2.zaee.zab(zas2.zaek);
                    }
                    case 1: {
                        zas2.zay();
                        break;
                    }
                    default: {
                        Log.wtf((String)"CompositeGAC", (String)"Attempted to call success callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)((Object)new AssertionError()));
                    }
                }
                zas2.zaep = 0;
                return;
            }
            if (this.zaem != null) {
                if (this.zaep == 1) {
                    this.zay();
                    return;
                }
                this.zaa(this.zaem);
                this.zaef.disconnect();
                return;
            }
        } else {
            if (this.zael != null && zas.zab(this.zaem)) {
                this.zaeg.disconnect();
                this.zaa(this.zael);
                return;
            }
            if (this.zael != null && this.zaem != null) {
                ConnectionResult connectionResult = this.zael;
                if (this.zaeg.zahs < this.zaef.zahs) {
                    connectionResult = this.zaem;
                }
                this.zaa(connectionResult);
            }
        }
    }

    @GuardedBy(value="mLock")
    private final void zaa(ConnectionResult connectionResult) {
        switch (this.zaep) {
            case 2: {
                this.zaee.zac(connectionResult);
            }
            case 1: {
                this.zay();
                break;
            }
            default: {
                Log.wtf((String)"CompositeGAC", (String)"Attempted to call failure callbacks in CONNECTION_MODE_NONE. Callbacks should be disabled via GmsClientSupervisor", (Throwable)new Exception());
            }
        }
        this.zaep = 0;
    }

    @GuardedBy(value="mLock")
    private final void zay() {
        Iterator<SignInConnectionListener> iterator = this.zaei.iterator();
        while (iterator.hasNext()) {
            iterator.next().onComplete();
        }
        this.zaei.clear();
    }

    @GuardedBy(value="mLock")
    private final void zaa(int n, boolean bl) {
        this.zaee.zab(n, bl);
        this.zaem = null;
        this.zael = null;
    }

    @GuardedBy(value="mLock")
    private final boolean zaz() {
        return this.zaem != null && this.zaem.getErrorCode() == 4;
    }

    private final boolean zaa(BaseImplementation.ApiMethodImpl<? extends Result, ? extends Api.AnyClient> apiMethodImpl) {
        Api.AnyClientKey<? extends Api.AnyClient> anyClientKey = apiMethodImpl.getClientKey();
        Preconditions.checkArgument((boolean)this.zaeh.containsKey(anyClientKey), (Object)"GoogleApiClient is not configured to use the API required for this call.");
        return this.zaeh.get(anyClientKey).equals(this.zaeg);
    }

    @Nullable
    private final PendingIntent zaaa() {
        if (this.zaej == null) {
            return null;
        }
        return PendingIntent.getActivity((Context)this.mContext, (int)System.identityHashCode(this.zaee), (Intent)this.zaej.getSignInIntent(), (int)0x8000000);
    }

    private final void zaa(Bundle bundle) {
        if (this.zaek == null) {
            this.zaek = bundle;
            return;
        }
        if (bundle != null) {
            this.zaek.putAll(bundle);
        }
    }

    private static boolean zab(ConnectionResult connectionResult) {
        return connectionResult != null && connectionResult.isSuccess();
    }

    @Override
    public final void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        printWriter.append(string2).append("authClient").println(":");
        this.zaeg.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
        printWriter.append(string2).append("anonClient").println(":");
        this.zaef.dump(String.valueOf(string2).concat("  "), fileDescriptor, printWriter, stringArray);
    }

    static /* synthetic */ Lock zaa(zas zas2) {
        return zas2.zaeo;
    }

    static /* synthetic */ void zab(zas zas2) {
        zas2.zax();
    }

    static /* synthetic */ void zaa(zas zas2, Bundle bundle) {
        zas2.zaa(bundle);
    }

    static /* synthetic */ ConnectionResult zaa(zas zas2, ConnectionResult connectionResult) {
        zas2.zael = connectionResult;
        return zas2.zael;
    }

    static /* synthetic */ boolean zac(zas zas2) {
        return zas2.zaen;
    }

    static /* synthetic */ ConnectionResult zad(zas zas2) {
        return zas2.zaem;
    }

    static /* synthetic */ boolean zaa(zas zas2, boolean bl) {
        zas2.zaen = bl;
        return zas2.zaen;
    }

    static /* synthetic */ void zaa(zas zas2, int n, boolean bl) {
        zas2.zaa(n, bl);
    }

    static /* synthetic */ zabe zae(zas zas2) {
        return zas2.zaeg;
    }

    static /* synthetic */ ConnectionResult zab(zas zas2, ConnectionResult connectionResult) {
        zas2.zaem = connectionResult;
        return zas2.zaem;
    }

    static /* synthetic */ zabe zaf(zas zas2) {
        return zas2.zaef;
    }
}

