/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase;

import android.annotation.TargetApi;
import android.app.Application;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.UiThread;
import android.support.annotation.VisibleForTesting;
import android.support.v4.content.ContextCompat;
import android.support.v4.util.ArrayMap;
import android.text.TextUtils;
import android.util.Log;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.common.api.internal.BackgroundDetector;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.Base64Utils;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.common.util.ProcessUtils;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.DataCollectionDefaultChange;
import com.google.firebase.FirebaseApiNotAvailableException;
import com.google.firebase.FirebaseAppLifecycleListener;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.annotations.PublicApi;
import com.google.firebase.auth.GetTokenResult;
import com.google.firebase.components.Component;
import com.google.firebase.components.ComponentDiscovery;
import com.google.firebase.components.ComponentRegistrar;
import com.google.firebase.components.ComponentRuntime;
import com.google.firebase.events.Event;
import com.google.firebase.events.Publisher;
import com.google.firebase.internal.DefaultIdTokenListenersCountChangedListener;
import com.google.firebase.internal.InternalTokenProvider;
import com.google.firebase.internal.InternalTokenResult;
import com.google.firebase.platforminfo.DefaultUserAgentPublisher;
import com.google.firebase.platforminfo.LibraryVersionComponent;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.concurrent.GuardedBy;

@PublicApi
public class FirebaseApp {
    private static final String LOG_TAG = "FirebaseApp";
    public static final String DEFAULT_APP_NAME = "[DEFAULT]";
    private static final String FIREBASE_APP_PREFS = "com.google.firebase.common.prefs:";
    @VisibleForTesting
    static final String DATA_COLLECTION_DEFAULT_ENABLED = "firebase_data_collection_default_enabled";
    private static final String MEASUREMENT_CLASSNAME = "com.google.android.gms.measurement.AppMeasurement";
    private static final String AUTH_CLASSNAME = "com.google.firebase.auth.FirebaseAuth";
    private static final String IID_CLASSNAME = "com.google.firebase.iid.FirebaseInstanceId";
    private static final String CRASH_CLASSNAME = "com.google.firebase.crash.FirebaseCrash";
    private static final List<String> API_INITIALIZERS = Arrays.asList("com.google.firebase.auth.FirebaseAuth", "com.google.firebase.iid.FirebaseInstanceId");
    private static final List<String> DEFAULT_APP_API_INITITALIZERS = Collections.singletonList("com.google.firebase.crash.FirebaseCrash");
    private static final List<String> DEFAULT_CONTEXT_API_INITITALIZERS = Arrays.asList("com.google.android.gms.measurement.AppMeasurement");
    private static final List<String> DIRECT_BOOT_COMPATIBLE_API_INITIALIZERS = Arrays.asList(new String[0]);
    private static final Set<String> CORE_CLASSES = Collections.emptySet();
    private static final Object LOCK = new Object();
    private static final Executor UI_EXECUTOR = new UiExecutor();
    @GuardedBy(value="LOCK")
    static final Map<String, FirebaseApp> INSTANCES = new ArrayMap();
    private static final String FIREBASE_ANDROID = "fire-android";
    private static final String FIREBASE_COMMON = "fire-core";
    private final Context applicationContext;
    private final String name;
    private final FirebaseOptions options;
    private final ComponentRuntime componentRuntime;
    private final SharedPreferences sharedPreferences;
    private final Publisher publisher;
    private final AtomicBoolean automaticResourceManagementEnabled = new AtomicBoolean(false);
    private final AtomicBoolean deleted = new AtomicBoolean();
    private final AtomicBoolean dataCollectionDefaultEnabled;
    private final List<IdTokenListener> idTokenListeners = new CopyOnWriteArrayList<IdTokenListener>();
    private final List<BackgroundStateChangeListener> backgroundStateChangeListeners = new CopyOnWriteArrayList<BackgroundStateChangeListener>();
    private final List<FirebaseAppLifecycleListener> lifecycleListeners = new CopyOnWriteArrayList<FirebaseAppLifecycleListener>();
    private InternalTokenProvider tokenProvider;
    private IdTokenListenersCountChangedListener idTokenListenersCountChangedListener;

    @NonNull
    @PublicApi
    public Context getApplicationContext() {
        this.checkNotDeleted();
        return this.applicationContext;
    }

    @NonNull
    @PublicApi
    public String getName() {
        this.checkNotDeleted();
        return this.name;
    }

    @NonNull
    @PublicApi
    public FirebaseOptions getOptions() {
        this.checkNotDeleted();
        return this.options;
    }

    public boolean equals(Object o) {
        if (!(o instanceof FirebaseApp)) {
            return false;
        }
        return this.name.equals(((FirebaseApp)o).getName());
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("name", (Object)this.name).add("options", (Object)this.options).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApi
    public static List<FirebaseApp> getApps(Context context) {
        Object object = LOCK;
        synchronized (object) {
            return new ArrayList<FirebaseApp>(INSTANCES.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @PublicApi
    public static FirebaseApp getInstance() {
        Object object = LOCK;
        synchronized (object) {
            FirebaseApp defaultApp = INSTANCES.get(DEFAULT_APP_NAME);
            if (defaultApp == null) {
                throw new IllegalStateException("Default FirebaseApp is not initialized in this process " + ProcessUtils.getMyProcessName() + ". Make sure to call FirebaseApp.initializeApp(Context) first.");
            }
            return defaultApp;
        }
    }

    @NonNull
    @PublicApi
    public static FirebaseApp getInstance(@NonNull String name) {
        Object object = LOCK;
        synchronized (object) {
            FirebaseApp firebaseApp = INSTANCES.get(FirebaseApp.normalize(name));
            if (firebaseApp != null) {
                return firebaseApp;
            }
            List<String> availableAppNames = FirebaseApp.getAllAppNames();
            String availableAppNamesMessage = availableAppNames.isEmpty() ? "" : "Available app names: " + TextUtils.join((CharSequence)", ", availableAppNames);
            String errorMessage = String.format("FirebaseApp with name %s doesn't exist. %s", name, availableAppNamesMessage);
            throw new IllegalStateException(errorMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    @PublicApi
    public static FirebaseApp initializeApp(@NonNull Context context) {
        Object object = LOCK;
        synchronized (object) {
            if (INSTANCES.containsKey(DEFAULT_APP_NAME)) {
                return FirebaseApp.getInstance();
            }
            FirebaseOptions firebaseOptions = FirebaseOptions.fromResource(context);
            if (firebaseOptions == null) {
                Log.d((String)LOG_TAG, (String)"Default FirebaseApp failed to initialize because no default options were found. This usually means that com.google.gms:google-services was not applied to your gradle project.");
                return null;
            }
            return FirebaseApp.initializeApp(context, firebaseOptions);
        }
    }

    @NonNull
    @PublicApi
    public static FirebaseApp initializeApp(@NonNull Context context, @NonNull FirebaseOptions options) {
        return FirebaseApp.initializeApp(context, options, DEFAULT_APP_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NonNull
    @PublicApi
    public static FirebaseApp initializeApp(@NonNull Context context, @NonNull FirebaseOptions options, @NonNull String name) {
        FirebaseApp firebaseApp;
        GlobalBackgroundStateListener.ensureBackgroundStateListenerRegistered(context);
        String normalizedName = FirebaseApp.normalize(name);
        Context applicationContext = context.getApplicationContext() == null ? context : context.getApplicationContext();
        Object object = LOCK;
        synchronized (object) {
            Preconditions.checkState((!INSTANCES.containsKey(normalizedName) ? 1 : 0) != 0, (Object)("FirebaseApp name " + normalizedName + " already exists!"));
            Preconditions.checkNotNull((Object)applicationContext, (Object)"Application context cannot be null.");
            firebaseApp = new FirebaseApp(applicationContext, normalizedName, options);
            INSTANCES.put(normalizedName, firebaseApp);
        }
        firebaseApp.initializeAllApis();
        return firebaseApp;
    }

    @Deprecated
    @KeepForSdk
    public void setTokenProvider(@NonNull InternalTokenProvider tokenProvider) {
        this.tokenProvider = (InternalTokenProvider)Preconditions.checkNotNull((Object)tokenProvider);
    }

    @Deprecated
    @KeepForSdk
    public void setIdTokenListenersCountChangedListener(@NonNull IdTokenListenersCountChangedListener listener) {
        this.idTokenListenersCountChangedListener = (IdTokenListenersCountChangedListener)Preconditions.checkNotNull((Object)listener);
        this.idTokenListenersCountChangedListener.onListenerCountChanged(this.idTokenListeners.size());
    }

    @Deprecated
    @Nullable
    @KeepForSdk
    public String getUid() throws FirebaseApiNotAvailableException {
        this.checkNotDeleted();
        if (this.tokenProvider == null) {
            throw new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode.");
        }
        return this.tokenProvider.getUid();
    }

    @Deprecated
    @NonNull
    @KeepForSdk
    public Task<GetTokenResult> getToken(boolean forceRefresh) {
        this.checkNotDeleted();
        if (this.tokenProvider == null) {
            return Tasks.forException((Exception)new FirebaseApiNotAvailableException("firebase-auth is not linked, please fall back to unauthenticated mode."));
        }
        return this.tokenProvider.getAccessToken(forceRefresh);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PublicApi
    public void delete() {
        boolean valueChanged = this.deleted.compareAndSet(false, true);
        if (!valueChanged) {
            return;
        }
        Object object = LOCK;
        synchronized (object) {
            INSTANCES.remove(this.name);
        }
        this.notifyOnAppDeleted();
    }

    @KeepForSdk
    public <T> T get(Class<T> anInterface) {
        this.checkNotDeleted();
        return (T)this.componentRuntime.get((Class)anInterface);
    }

    @PublicApi
    public void setAutomaticResourceManagementEnabled(boolean enabled) {
        this.checkNotDeleted();
        boolean updated = this.automaticResourceManagementEnabled.compareAndSet(!enabled, enabled);
        if (updated) {
            boolean inBackground = BackgroundDetector.getInstance().isInBackground();
            if (enabled && inBackground) {
                this.notifyBackgroundStateChangeListeners(true);
            } else if (!enabled && inBackground) {
                this.notifyBackgroundStateChangeListeners(false);
            }
        }
    }

    @KeepForSdk
    public boolean isDataCollectionDefaultEnabled() {
        this.checkNotDeleted();
        return this.dataCollectionDefaultEnabled.get();
    }

    @KeepForSdk
    public void setDataCollectionDefaultEnabled(boolean enabled) {
        this.checkNotDeleted();
        if (this.dataCollectionDefaultEnabled.compareAndSet(!enabled, enabled)) {
            this.sharedPreferences.edit().putBoolean(DATA_COLLECTION_DEFAULT_ENABLED, enabled).commit();
            this.publisher.publish(new Event<DataCollectionDefaultChange>(DataCollectionDefaultChange.class, new DataCollectionDefaultChange(enabled)));
        }
    }

    protected FirebaseApp(Context applicationContext, String name, FirebaseOptions options) {
        this.applicationContext = (Context)Preconditions.checkNotNull((Object)applicationContext);
        this.name = Preconditions.checkNotEmpty((String)name);
        this.options = (FirebaseOptions)Preconditions.checkNotNull((Object)options);
        this.idTokenListenersCountChangedListener = new DefaultIdTokenListenersCountChangedListener();
        this.sharedPreferences = applicationContext.getSharedPreferences(FirebaseApp.getSharedPrefsName(name), 0);
        this.dataCollectionDefaultEnabled = new AtomicBoolean(this.readAutoDataCollectionEnabled());
        List<ComponentRegistrar> registrars = ComponentDiscovery.forContext(applicationContext).discover();
        this.componentRuntime = new ComponentRuntime(UI_EXECUTOR, registrars, Component.of(applicationContext, Context.class, new Class[0]), Component.of(this, FirebaseApp.class, new Class[0]), Component.of(options, FirebaseOptions.class, new Class[0]), LibraryVersionComponent.create(FIREBASE_ANDROID, ""), LibraryVersionComponent.create(FIREBASE_COMMON, "16.1.0"), DefaultUserAgentPublisher.component());
        this.publisher = (Publisher)this.componentRuntime.get(Publisher.class);
    }

    private static String getSharedPrefsName(String appName) {
        return FIREBASE_APP_PREFS + appName;
    }

    private boolean readAutoDataCollectionEnabled() {
        if (this.sharedPreferences.contains(DATA_COLLECTION_DEFAULT_ENABLED)) {
            return this.sharedPreferences.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED, true);
        }
        try {
            ApplicationInfo applicationInfo;
            PackageManager packageManager = this.applicationContext.getPackageManager();
            if (packageManager != null && (applicationInfo = packageManager.getApplicationInfo(this.applicationContext.getPackageName(), 128)) != null && applicationInfo.metaData != null && applicationInfo.metaData.containsKey(DATA_COLLECTION_DEFAULT_ENABLED)) {
                return applicationInfo.metaData.getBoolean(DATA_COLLECTION_DEFAULT_ENABLED);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return true;
    }

    private void checkNotDeleted() {
        Preconditions.checkState((!this.deleted.get() ? 1 : 0) != 0, (Object)"FirebaseApp was deleted");
    }

    @Deprecated
    @KeepForSdk
    public List<IdTokenListener> getListeners() {
        this.checkNotDeleted();
        return this.idTokenListeners;
    }

    @KeepForSdk
    @VisibleForTesting
    public boolean isDefaultApp() {
        return DEFAULT_APP_NAME.equals(this.getName());
    }

    @Deprecated
    @KeepForSdk
    @UiThread
    public void notifyIdTokenListeners(@NonNull InternalTokenResult tokenResult) {
        Log.d((String)LOG_TAG, (String)"Notifying auth state listeners.");
        int size = 0;
        for (IdTokenListener listener : this.idTokenListeners) {
            listener.onIdTokenChanged(tokenResult);
            ++size;
        }
        Log.d((String)LOG_TAG, (String)String.format("Notified %d auth state listeners.", size));
    }

    private void notifyBackgroundStateChangeListeners(boolean background) {
        Log.d((String)LOG_TAG, (String)"Notifying background state change listeners.");
        for (BackgroundStateChangeListener listener : this.backgroundStateChangeListeners) {
            listener.onBackgroundStateChanged(background);
        }
    }

    @Deprecated
    @KeepForSdk
    public void addIdTokenListener(@NonNull IdTokenListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull((Object)listener);
        this.idTokenListeners.add(listener);
        this.idTokenListenersCountChangedListener.onListenerCountChanged(this.idTokenListeners.size());
    }

    @Deprecated
    @KeepForSdk
    public void removeIdTokenListener(@NonNull IdTokenListener listenerToRemove) {
        this.checkNotDeleted();
        Preconditions.checkNotNull((Object)listenerToRemove);
        this.idTokenListeners.remove(listenerToRemove);
        this.idTokenListenersCountChangedListener.onListenerCountChanged(this.idTokenListeners.size());
    }

    @KeepForSdk
    public void addBackgroundStateChangeListener(BackgroundStateChangeListener listener) {
        this.checkNotDeleted();
        if (this.automaticResourceManagementEnabled.get() && BackgroundDetector.getInstance().isInBackground()) {
            listener.onBackgroundStateChanged(true);
        }
        this.backgroundStateChangeListeners.add(listener);
    }

    @KeepForSdk
    public void removeBackgroundStateChangeListener(BackgroundStateChangeListener listener) {
        this.checkNotDeleted();
        this.backgroundStateChangeListeners.remove(listener);
    }

    @KeepForSdk
    public String getPersistenceKey() {
        return Base64Utils.encodeUrlSafeNoPadding((byte[])this.getName().getBytes(Charset.defaultCharset())) + "+" + Base64Utils.encodeUrlSafeNoPadding((byte[])this.getOptions().getApplicationId().getBytes(Charset.defaultCharset()));
    }

    @KeepForSdk
    public void addLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull((Object)listener);
        this.lifecycleListeners.add(listener);
    }

    @KeepForSdk
    public void removeLifecycleEventListener(@NonNull FirebaseAppLifecycleListener listener) {
        this.checkNotDeleted();
        Preconditions.checkNotNull((Object)listener);
        this.lifecycleListeners.remove(listener);
    }

    private void notifyOnAppDeleted() {
        for (FirebaseAppLifecycleListener listener : this.lifecycleListeners) {
            listener.onDeleted(this.name, this.options);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    public static void clearInstancesForTest() {
        Object object = LOCK;
        synchronized (object) {
            INSTANCES.clear();
        }
    }

    @KeepForSdk
    public static String getPersistenceKey(String name, FirebaseOptions options) {
        return Base64Utils.encodeUrlSafeNoPadding((byte[])name.getBytes(Charset.defaultCharset())) + "+" + Base64Utils.encodeUrlSafeNoPadding((byte[])options.getApplicationId().getBytes(Charset.defaultCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> getAllAppNames() {
        ArrayList<String> allAppNames = new ArrayList<String>();
        Object object = LOCK;
        synchronized (object) {
            for (FirebaseApp app : INSTANCES.values()) {
                allAppNames.add(app.getName());
            }
        }
        Collections.sort(allAppNames);
        return allAppNames;
    }

    private void initializeAllApis() {
        boolean isDeviceProtectedStorage = ContextCompat.isDeviceProtectedStorage((Context)this.applicationContext);
        if (isDeviceProtectedStorage) {
            UserUnlockReceiver.ensureReceiverRegistered(this.applicationContext);
        } else {
            this.componentRuntime.initializeEagerComponents(this.isDefaultApp());
        }
        this.initializeApis(FirebaseApp.class, this, API_INITIALIZERS, isDeviceProtectedStorage);
        if (this.isDefaultApp()) {
            this.initializeApis(FirebaseApp.class, this, DEFAULT_APP_API_INITITALIZERS, isDeviceProtectedStorage);
            this.initializeApis(Context.class, this.applicationContext, DEFAULT_CONTEXT_API_INITITALIZERS, isDeviceProtectedStorage);
        }
    }

    private <T> void initializeApis(Class<T> parameterClass, T parameter, Iterable<String> apiInitClasses, boolean isDeviceProtectedStorage) {
        for (String apiInitClass : apiInitClasses) {
            try {
                Class<?> initializerClass;
                Method initMethod;
                int initMethodModifiers;
                if (isDeviceProtectedStorage && !DIRECT_BOOT_COMPATIBLE_API_INITIALIZERS.contains(apiInitClass) || !Modifier.isPublic(initMethodModifiers = (initMethod = (initializerClass = Class.forName(apiInitClass)).getMethod("getInstance", parameterClass)).getModifiers()) || !Modifier.isStatic(initMethodModifiers)) continue;
                initMethod.invoke(null, parameter);
            }
            catch (ClassNotFoundException e) {
                if (CORE_CLASSES.contains(apiInitClass)) {
                    throw new IllegalStateException(apiInitClass + " is missing, but is required. Check if it has been removed by Proguard.");
                }
                Log.d((String)LOG_TAG, (String)(apiInitClass + " is not linked. Skipping initialization."));
            }
            catch (NoSuchMethodException e) {
                throw new IllegalStateException(apiInitClass + "#getInstance has been removed by Proguard. Add keep rule to prevent it.");
            }
            catch (InvocationTargetException e) {
                Log.wtf((String)LOG_TAG, (String)"Firebase API initialization failure.", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.wtf((String)LOG_TAG, (String)("Failed to initialize " + apiInitClass), (Throwable)e);
            }
        }
    }

    private static String normalize(@NonNull String name) {
        return name.trim();
    }

    private static class UiExecutor
    implements Executor {
        private static final Handler HANDLER = new Handler(Looper.getMainLooper());

        private UiExecutor() {
        }

        @Override
        public void execute(@NonNull Runnable command) {
            HANDLER.post(command);
        }
    }

    @TargetApi(value=14)
    private static class GlobalBackgroundStateListener
    implements BackgroundDetector.BackgroundStateChangeListener {
        private static AtomicReference<GlobalBackgroundStateListener> INSTANCE = new AtomicReference();

        private GlobalBackgroundStateListener() {
        }

        private static void ensureBackgroundStateListenerRegistered(Context context) {
            GlobalBackgroundStateListener listener;
            if (!PlatformVersion.isAtLeastIceCreamSandwich() || !(context.getApplicationContext() instanceof Application)) {
                return;
            }
            Application application = (Application)context.getApplicationContext();
            if (INSTANCE.get() == null && INSTANCE.compareAndSet(null, listener = new GlobalBackgroundStateListener())) {
                BackgroundDetector.initialize((Application)application);
                BackgroundDetector.getInstance().addListener((BackgroundDetector.BackgroundStateChangeListener)listener);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onBackgroundStateChanged(boolean background) {
            Object object = LOCK;
            synchronized (object) {
                for (FirebaseApp app : new ArrayList<FirebaseApp>(INSTANCES.values())) {
                    if (!app.automaticResourceManagementEnabled.get()) continue;
                    app.notifyBackgroundStateChangeListeners(background);
                }
            }
        }
    }

    @TargetApi(value=24)
    private static class UserUnlockReceiver
    extends BroadcastReceiver {
        private static AtomicReference<UserUnlockReceiver> INSTANCE = new AtomicReference();
        private final Context applicationContext;

        public UserUnlockReceiver(Context applicationContext) {
            this.applicationContext = applicationContext;
        }

        private static void ensureReceiverRegistered(Context applicationContext) {
            UserUnlockReceiver receiver;
            if (INSTANCE.get() == null && INSTANCE.compareAndSet(null, receiver = new UserUnlockReceiver(applicationContext))) {
                IntentFilter intentFilter = new IntentFilter("android.intent.action.USER_UNLOCKED");
                applicationContext.registerReceiver((BroadcastReceiver)receiver, intentFilter);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            Object object = LOCK;
            synchronized (object) {
                for (FirebaseApp app : INSTANCES.values()) {
                    app.initializeAllApis();
                }
            }
            this.unregister();
        }

        public void unregister() {
            this.applicationContext.unregisterReceiver((BroadcastReceiver)this);
        }
    }

    @KeepForSdk
    public static interface BackgroundStateChangeListener {
        @KeepForSdk
        public void onBackgroundStateChanged(boolean var1);
    }

    @Deprecated
    @KeepForSdk
    public static interface IdTokenListenersCountChangedListener {
        @KeepForSdk
        public void onListenerCountChanged(int var1);
    }

    @Deprecated
    @KeepForSdk
    public static interface IdTokenListener {
        @KeepForSdk
        public void onIdTokenChanged(@NonNull InternalTokenResult var1);
    }
}

