/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.components;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.os.Bundle;
import android.support.annotation.VisibleForTesting;
import android.util.Log;
import com.google.firebase.components.ComponentDiscoveryService;
import com.google.firebase.components.ComponentRegistrar;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ComponentDiscovery<T> {
    private static final String TAG = "ComponentDiscovery";
    private static final String COMPONENT_SENTINEL_VALUE = "com.google.firebase.components.ComponentRegistrar";
    private static final String COMPONENT_KEY_PREFIX = "com.google.firebase.components:";
    private final T context;
    private final RegistrarNameRetriever<T> retriever;

    public static ComponentDiscovery<Context> forContext(Context context) {
        return new ComponentDiscovery<Context>(context, new MetadataRegistrarNameRetriever());
    }

    @VisibleForTesting
    ComponentDiscovery(T context, RegistrarNameRetriever<T> retriever) {
        this.context = context;
        this.retriever = retriever;
    }

    public List<ComponentRegistrar> discover() {
        return ComponentDiscovery.instantiate(this.retriever.retrieve(this.context));
    }

    private static List<ComponentRegistrar> instantiate(List<String> registrarNames) {
        ArrayList<ComponentRegistrar> registrars = new ArrayList<ComponentRegistrar>();
        for (String name : registrarNames) {
            try {
                Class<?> loadedClass = Class.forName(name);
                if (!ComponentRegistrar.class.isAssignableFrom(loadedClass)) {
                    Log.w((String)TAG, (String)String.format("Class %s is not an instance of %s", name, COMPONENT_SENTINEL_VALUE));
                    continue;
                }
                registrars.add((ComponentRegistrar)loadedClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException e) {
                Log.w((String)TAG, (String)String.format("Class %s is not an found.", name), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)TAG, (String)String.format("Could not instantiate %s.", name), (Throwable)e);
            }
            catch (InstantiationException e) {
                Log.w((String)TAG, (String)String.format("Could not instantiate %s.", name), (Throwable)e);
            }
            catch (NoSuchMethodException e) {
                Log.w((String)TAG, (String)String.format("Could not instantiate %s", name), (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.w((String)TAG, (String)String.format("Could not instantiate %s", name), (Throwable)e);
            }
        }
        return registrars;
    }

    private static class MetadataRegistrarNameRetriever
    implements RegistrarNameRetriever<Context> {
        private MetadataRegistrarNameRetriever() {
        }

        @Override
        public List<String> retrieve(Context ctx) {
            Bundle metadata = MetadataRegistrarNameRetriever.getMetadata(ctx);
            if (metadata == null) {
                Log.w((String)ComponentDiscovery.TAG, (String)"Could not retrieve metadata, returning empty list of registrars.");
                return Collections.emptyList();
            }
            ArrayList<String> registrarNames = new ArrayList<String>();
            for (String key : metadata.keySet()) {
                Object rawValue = metadata.get(key);
                if (!ComponentDiscovery.COMPONENT_SENTINEL_VALUE.equals(rawValue) || !key.startsWith(ComponentDiscovery.COMPONENT_KEY_PREFIX)) continue;
                registrarNames.add(key.substring(ComponentDiscovery.COMPONENT_KEY_PREFIX.length()));
            }
            return registrarNames;
        }

        private static Bundle getMetadata(Context context) {
            try {
                PackageManager manager = context.getPackageManager();
                if (manager == null) {
                    Log.w((String)ComponentDiscovery.TAG, (String)"Context has no PackageManager.");
                    return null;
                }
                ServiceInfo info = manager.getServiceInfo(new ComponentName(context, ComponentDiscoveryService.class), 128);
                if (info == null) {
                    Log.w((String)ComponentDiscovery.TAG, (String)"ComponentDiscoveryService has no service info.");
                    return null;
                }
                return info.metaData;
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.w((String)ComponentDiscovery.TAG, (String)"Application info not found.");
                return null;
            }
        }
    }

    @VisibleForTesting
    static interface RegistrarNameRetriever<T> {
        public List<String> retrieve(T var1);
    }
}

