/*ForcheckIDE/Version.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

// The version number of this version of the IDE must be defined in info.cpp.

#ifndef VERSION_H
#define VERSION_H

#include <QString>

class Version
{
public:
        Version();
        Version(const QString& strVersion);
        ~Version();
        QString toString();
        QString getMajorVersion();
        QString getMinorVersion();
        QString getRelease();
        bool isKnown();
        bool isNewerRelease(const Version& latestversion);
        bool isSameMinorVersion(const Version& latestversion);
        int major;
        int minor;
        int release;

private:
        QString strversion;
};

#endif // VersionH
