/*ForcheckIDE/Version.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#include "Version.h"
#include "Info.h"

#include <QString>

Version::Version()
{
        strversion.clear();
        major = 0;
        minor = 0;
        release = 0;
}

Version::Version(const QString& strVersion){
        //expected string format: ii.ii, or ii.ii.ii, or ii.ii.ii.ii
        int ndot = 0;
        int strlength = strVersion.length();
        QString strTemp;

        strversion = strVersion;
        major = 0;
        minor = 0;
        release = 0;

        for(int i=0; i<strlength; i++){
                if(strVersion[i] != '.')
                        strTemp += strVersion[i];
                if((strVersion[i] == '.') ||
                   (i == strlength-1)){
                        if(ndot == 0){
                                major = strTemp.toInt();
                        }else if(ndot == 1){
                                minor = strTemp.toInt();
                        }else if(ndot == 2){
                                release = strTemp.toInt();
                        }else{
                         //error
                        }
                        strTemp = "";
                        ndot++;
                }
        }
}

Version::~Version()
{
}

QString Version::toString()
{
    return strversion;
}

QString Version::getMajorVersion()
{
    return QString::number(major);
}

QString Version::getMinorVersion()
{
    return QString::number(minor);
}

QString Version::getRelease()
{
    return QString::number(release);
}

bool Version::isKnown()
{
    return major > 0;
}

bool Version::isNewerRelease(const Version& latestversion){
//return true if latestversion is newer than this version, false otherwise.
    if (major <= 0) return false;
    if(latestversion.major > major)
        return true;
    if (latestversion.major == major &&
        latestversion.minor > minor)
        return true;
    if (latestversion.minor == minor &&
        latestversion.release > release)
        return true;
    return false;
}

bool Version::isSameMinorVersion(const Version& latestversion){
    //return true if latestversion is same version and subversion this version, false otherwise.
    return (latestversion.major == major) && (latestversion.minor >= minor);
}

 
