/*ForcheckIDE/TreeForm.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef TREEFORM_H
#define TREEFORM_H

#include <QDialog>
#include <QXmlStreamReader>
#include <QTreeWidget>
#include <QSize>

class QPushButton;
class QLineEdit;
class QString;
class QMainWindow;

class TreeForm : public QDialog
{
        Q_OBJECT
public:
        TreeForm(const QString& filename, QMainWindow *parent = 0);
        QAction *windowMenuAction() const {return action;}
        QString& getFileName(){return curFileName;}
        void update();

protected:
        QSize sizeHint() const;
        void focusInEvent(QFocusEvent * event);

private:
        QLineEdit *searchEdit;
        QPushButton *sortButton;
        QPushButton *searchButton;
        QPushButton *expandAllButton;
        QPushButton *collapseAllButton;
        QPushButton *helpButton;

        void formCreate();
        bool readFile();
        void readTree();
        void readSub(QTreeWidgetItem *parent);
        void readRef(QTreeWidgetItem *parent, const QString& subid, const QString& subref);

        QXmlStreamReader reader;
        QTreeWidget tree;
        QString curFileName;
        QMainWindow *myParent;
        QAction *action;

private slots:
        void sortClicked();
        void searchClicked();
        void expandAllClicked();
        void collapseAllClicked();
        void helpClicked();

signals:
        void InFocus();
};

#endif
