/*ForcheckIDE/SelectMakefileForm.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef SELECTMAKEFILEFORM_H
#define SELECTMAKEFILEFORM_H

#include <QDialog>

class Project;
class QLineEdit;
class QRadioButton;

class SelectMakefileForm : public QDialog
{
    Q_OBJECT
public:
    SelectMakefileForm(Project *project, QWidget *parent=0);

private:
    Project *myproject;
    QRadioButton *debugButton;
    QRadioButton *releaseButton;
    QLineEdit *makefileEdit;

    void formCreate();
    void formInit(int);
    int makefileindex;

public slots:
    void debugButtonClicked(bool);
    void releaseButtonClicked(bool);
    void selectMakefileClicked();
};

#endif // SELECTMAKEFILEFORM_H
