/*ForcheckIDE/SelectMakeFileForm.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#include "SelectMakefileForm.h"
#include "Environment.h"
#include "Project.h"

#include <QtWidgets>

SelectMakefileForm::SelectMakefileForm(Project *project, QWidget *parent) : QDialog(parent)
{
    setWindowTitle("Select makefile");
    setAttribute(Qt::WA_DeleteOnClose);
    myproject = project;
    formCreate();
    makefileindex = myproject->getMakeFileIndex();
    debugButton->setChecked(makefileindex == 0);
    releaseButton->setChecked(makefileindex == 1);
    formInit(makefileindex);
}

void SelectMakefileForm::formCreate()
{
    debugButton = new QRadioButton("Debug");
    connect(debugButton, SIGNAL(clicked(bool)),
            this, SLOT(debugButtonClicked(bool)));
    releaseButton = new QRadioButton("Release");
    connect(releaseButton, SIGNAL(clicked(bool)),
            this, SLOT(releaseButtonClicked(bool)));

    QLabel *filenamelabel = new QLabel("Makefile:");
    makefileEdit = new QLineEdit();
    makefileEdit->setFixedWidth(400);
    QPushButton *p = new QPushButton("...");
    p->setFixedWidth(25);
    connect(p, SIGNAL(clicked()), this, SLOT(selectMakefileClicked()));

    QHBoxLayout *selectButtonLayout = new QHBoxLayout;
    selectButtonLayout->addWidget(debugButton);
    selectButtonLayout->addWidget(releaseButton);

    QHBoxLayout *filenameLayout = new QHBoxLayout;
    filenameLayout->addWidget(filenamelabel);
    filenameLayout->addWidget(makefileEdit);
    filenameLayout->addWidget(p);

    QVBoxLayout *vboxt = new QVBoxLayout;
    vboxt->addLayout(selectButtonLayout);
    vboxt->addLayout(filenameLayout);
    this->setLayout(vboxt);
}

void SelectMakefileForm::formInit(int makefileindex)
{
    makefileEdit->setText(myproject->getMakeFilename(makefileindex));
}

void SelectMakefileForm::debugButtonClicked(bool checked)
{
    if (checked){
        makefileindex = 0;
        formInit(makefileindex);
        myproject->setMakeFileIndex(makefileindex);
    }
}

void SelectMakefileForm::releaseButtonClicked(bool checked)
{
    if (checked){
        makefileindex = 1;
        formInit(makefileindex);
        myproject->setMakeFileIndex(makefileindex);
    }
}

void SelectMakefileForm::selectMakefileClicked()
{
    QString filename = myproject->getMakeFilename();
    filename = QFileDialog::getOpenFileName(this,
                                            tr("Select makefile"),
                                            QDir::currentPath(),
                                            tr("Make files (*") +
                                            myEnvironment->getMakeExt() +
                                            ")");
    if (filename.isEmpty()) return;
    QDir cwd(myEnvironment->getWorkingDir());
    filename = cwd.relativeFilePath(filename);
    makefileEdit->setText(filename);
    myproject->setMakeFilename(makefileEdit->text());
}
