/*ForcheckIDE/ProjectFrame.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef PROJECTFRAME_H
#define PROJECTFRAME_H

#include "Environment.h"
#include "FileKinds.h"

#include <QTreeWidget>
#include <QProcess>

class Project;
class MakefileForm;
class SelectMakefileForm;
class FileViewer;
class CodeEditor;
class TreeForm;
class OptionsForm;
class LibrarianForm;
class QAction;
class QLabel;
class QActionGroup;
class QMenu;
class QToolBar;
class QMainWindow;
class QFile;
class QMdiArea;
class QSplitter;
class QMdiSubWindow;
class QCheckBox;
class QComboBox;
class QPlainTextEdit;

class ProjectFrame : public QTreeWidget
{
      Q_OBJECT

public:
    ProjectFrame(QMainWindow *parent, QMdiArea *mdiarea, QTabWidget *tabwidget,
                 FileViewer *progressview, FileViewer *reportview, FileViewer *searchview);
    void createActions();
    void addFileActions1(QMenu *filemenu);
    void addFileActions2(QMenu *filemenu);
    void addEditActions(QMenu *filemenu);
    void addProjectActions(QMenu *projectmenu);
    void addAnalysisActions(QMenu *analysismenu);
    void addOptionActions(QMenu *projectmenu);
    void addViewActions(QMenu *viewmenu);
    void addWindowActions(QMenu *windowmenu);
    void addActionsToToolBar(QToolBar *toolbar);
    void addActionsToSearchToolBar(QToolBar *toolbar);
    void addActionsToReplaceToolBar(QToolBar *toolbar);

    void updateEnabled();
    bool projectChanged();
    bool isAnalysing(){return analysing;}
    bool isBuilding(){return building;}
    void openProject(const QString& projectfile);
    void saveProject();
    void closeAllFiles();
    void closeProject();
    void analyse(const bool make, const bool dependencies, const bool selective);
    void getCurrentFileAndKind(QString& filename, FileKind::ETFileKind &filekind);

    QActionGroup *windowActionGroup;

private:
    static const int MAXCOUNT;
    QMainWindow *myParent;
    QMdiArea *mymdiarea;
    QTabWidget *mytabwidget;
    QMenu *windowMenu;
    FileViewer *myprogressview;
    FileViewer *myreportview;
    FileViewer *mysearchview;
    Project *project;
    MakefileForm *makefileForm;
    SelectMakefileForm *selectMakefileForm;
    FileViewer *listView;
    FileViewer *prevviewer;
    CodeEditor *preveditor;
    TreeForm *treeView;
    OptionsForm *optionsForm;
    QTreeWidgetItem *projectTreeItem;
    QTreeWidgetItem *KindTreeItem[FileKind::Count];
    LibrarianForm *librarianForm;
    QString depFilename;
    QString reportFilename;
    QString searchString;
    QString replaceString;
    bool caseSensitiveSearch;
    bool gen_make;
    bool update_dependencies;
    bool analysing;
    bool building;
    bool fileSelected;
    bool viewableSelected;
    bool editableSelected;
    bool addableSelected;
    bool includableSelected;
    bool excludableSelected;
    bool canHaveFileOptionsSelected;
    bool multipleSelectable;
    bool canAddFile;
    bool printableSelected;
    bool searchInReport;

    void createTree(QWidget *parent);
    void fillTree();
    void emptyTree();
    void addToTree(QTreeWidgetItem *parent, const FileKind::ETFileKind fk);
    void addFileToTree(QTreeWidgetItem *parent,
                       const QString filespec,
                       const FileKind::ETFileKind filekind,
                       int index);
    void createProject();
    void updateRecentFileActions();
    void updateTitle(QString projectname = QString());
    void itemSelected(QTreeWidgetItem *item, bool rightbutton);

    void locateFile(QTreeWidgetItem *item, FileKind::ETFileKind &filekind, int &index);
    FileKind::ETFileKind getSelectedFileCategory();
    void getSelectedFilename(QString& filename, FileKind::ETFileKind& filekind);
    QString getFilter(const FileKind::ETFileKind filekind);
    void addFilesFromDir(const QString &path);
    QStringList openFileDialog(const FileKind::ETFileKind filekind);
    QString openDirDialog(const FileKind::ETFileKind filekind);
    void setIncluded(QTreeWidgetItem *item, bool analyse);
    bool fileExists(const QString& filename);

    void editFile(const QString& fileName, int linNum=0);
    bool isModified();
    void saveAll();
    void verifyProject();
    CodeEditor *findEditor(const QString& fileName);
    QMdiSubWindow *findSubWindow(const QString& fileName);
    void addViewer(FileViewer *fileviewer, const QString& fileName);
    void addEditor(CodeEditor *editor, const QString& fileName);
    CodeEditor *activeEditor();
    FileViewer *activeViewer();
    void updateSearchComboBox();
    void updateReplaceComboBox();
    void doReplaceInWindow();
    void doFindReplaceInFiles(bool replace);
    void doUpdateIncDependencies();

    //file menu
    QAction *fileNew;
    QAction *fileOpen;
    QAction *fileView;
    QAction *fileEdit;
    QAction *fileSave;
    QAction *fileClose;
    QAction *fileAbsolutePath;
    QAction *filePrint;
    //edit menu
    QAction *undoAction;
    QAction *redoAction;
    QAction *cutAction;
    QAction *copyAction;
    QAction *pasteAction;
    QAction *selectAllAction;
    QAction *findReplaceAction;
    QAction *findReplaceInFilesAction;
    QAction *gotoAction;
    //search
    QLabel *findLabel;
    QLineEdit *findLine;
    QComboBox *searchComboBox;
    QComboBox *replaceComboBox;
    QCheckBox *caseCheckBox;
    QLabel *replaceLabel;
    QLineEdit *replaceLine;
    QLabel *scopeLabel;
    QComboBox *selectScopeComboBox;
    QAction *replacePrevious;
    QAction *findPrevious;
    QAction *findNext;
    QAction *replaceNext;
    QAction *replaceAll;
    QAction *startSearch;
    //project menu
    QAction *newProjectAction;
    QAction *openProjectAction;
    QAction *saveProjectAction;
    QAction *saveAsProjectAction;
    QAction *closeProjectAction;
    QAction *recentFileActions[Environment::MaxRecentFiles];
    QAction *addFiles;
    QAction *addDir;
    QAction *removeFiles;
    QAction *updateIncDependencies;
    QAction *configureMakefile;
    QAction *selectMakefile;
    QAction *executeMakefile;
    //analysis menu:
    QAction *includeFiles;
    QAction *excludeFiles;
    QAction *analyseSelected;
    QAction *analyseAll;
    QAction *killAnalysis;
    QAction *findPreviousMsg;
    QAction *findNextMsg;
    //options menu
    QAction *defaultOptionsAction;
    QAction *projectOptionsAction;
    QAction *fileOptionsAction;
    //view menu:
    QAction *viewSelectiveAnalysisCommandline;
    QAction *viewAnalysisCommandline;
    QAction *viewSelectiveAnalysisCommandFile;
    QAction *viewAnalysisCommandFile;

    QMenu *recentProjectSubMenu;
    QMenu *popUpMenu;

public slots:
    void changeSubWindowFocus();

private slots:
    void fileNewClicked();
    void fileOpenClicked();
    void fileViewClicked();
    void fileEditRequest(const QString&, int);
    void fileEditClicked();
    void fileSaveClicked();
    void fileCloseClicked();
    void fileAbsolutePathClicked();
    void filePrintClicked();

    void cutClicked();
    void copyClicked();
    void pasteClicked();
    void selectAllClicked();

    void setFindEnabled(bool enable);
    void setReplaceEnabled(bool enable);
    void findReplaceClicked();
    void findPreviousClicked();
    void findNextClicked();
    void replacePreviousClicked();
    void replaceNextClicked();
    void replaceAllClicked();
    void findReplaceInFilesClicked();
    void selectScopeChanged(int);
    void startSearchClicked();
    void startReplaceInFilesClicked();
    void gotoClicked();
    void fileSaved(const QString &);

    void newProjectClicked();
    void openProjectClicked();

    void openRecentProjectClicked();
    void saveProjectClicked();
    void saveAsProjectClicked();
    void closeProjectClicked();
    void removeRecentProjectClicked();
    void addFilesClicked();
    void addDirClicked();
    void removeFilesClicked();
    void updateIncDependenciesClicked();
    void configureMakefileClicked();
    void selectMakefileClicked();
    void executeMakefileClicked();

    void includeFilesClicked();
    void excludeFilesClicked();
    void analyseSelectedClicked();
    void analyseAllClicked();
    void killAnalysisClicked();
    void findPreviousMsgClicked();
    void findNextMsgClicked();
    void defaultOptionsClicked();
    void projectOptionsClicked();
    void fileOptionsClicked();

    void viewSelectiveAnalysisCommandlineClicked();
    void viewAnalysisCommandlineClicked();
    void viewSelectiveAnalysisCommandFileClicked();
    void viewAnalysisCommandFileClicked();
	
    void itemPressed(QTreeWidgetItem*,int);
    void itemClicked(QTreeWidgetItem*,int);
    void itemDoubleClicked(QTreeWidgetItem*,int);
    void itemSelectionChanged();

    void tabChanged(int);

    void closeEdit();
    void viewerOutFocus();
    void editorOutFocus();

    void showAnalysisProgress();
    void analysisFinished(int exitcode, QProcess::ExitStatus exitStatus);
    void showBuildProgress();
    void buildFinished(int exitcode, QProcess::ExitStatus exitStatus);
};
#endif // PROJECTFRAME_H
