/*ForcheckIDE/ProjectFiles.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef PROJECTFILES_H
#define PROJECTFILES_H

#include "FileKinds.h"
#include "Options.h"

#include <QObject>
#include <QList>

class QString;
class IniFile;

class ProjectFiles : public QObject {

        Q_OBJECT

public:
        ProjectFiles(Options *projectoptions,
                     const FileKind::ETFileKind filekind);
        ~ProjectFiles();

        int getNrFiles() const;
        int getNrFilesInAnalysis() const { return nr_files_in_analysis; }
        QString getFilename(int index) const;
        QString getRelFilename(int index) const;
        void setFilename(int index, const QString& newfilespec);
        Options *getFileOptions(int index);
        const Options *getFileOptions(int index) const;
        int findFile(const QString& filespec) const;
        int addFile(const QString& filespec);
        void removeFileAt(int index);
        void renameFileAt(int index, const QString& newfilespec);

        void setAnalyse(int index, bool analyse=true);
        bool analyseFileAt(int index) const;

        void setOption(int index, const QString& optionname, TriStateBool value);

        void save(IniFile &conf);
        bool load(IniFile &conf);

        void setChanged(bool Change);
        bool isChanged() const;

//====================================================================================================
        class FileEntry
        {       
        public:
                FileEntry(ProjectFiles* parent = NULL);
                FileEntry(const FileEntry& original);
                ~FileEntry();
                
                FileEntry operator=(const FileEntry&);
                void save(IniFile& conf, const QString& filespec);

                QString filename;
                Options *fileOptions;
                bool analyseFile;         // Boolean to see whether this file has to be analysed
                bool absolutePathname;    // set when file name is not relative to the project
                                          // see ExtractRelativePath/ExpandFileName

                ProjectFiles *Parent;
        };
//====================================================================================================

private:
        FileEntry *getFileEntry(int index);
        const FileEntry *getFileEntry(int index) const;

        FileKind::ETFileKind kind;
        int nr_files_in_analysis;
        bool changed;
        Options *projectOptions;
        QList<FileEntry *> *fileEntries;
};

#endif
