/*ForcheckIDE/Project.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef PROJECT_H
#define PROJECT_H

#include "ProjectFiles.h"

#include <QDateTime>
#include <QObject>
#include <QFile>
#include <QTextStream>

class Project : public QObject {

        Q_OBJECT
      
public:
        Project();
        ~Project();
        QString getProjectFilename() const { return projectFilename; }
        QString getProjectDirectory() const { return projectDirectory; }
        Options *getProjectOptions() { return myProjectOptions; }

        bool isChanged() const;
        void setChanged(bool c);
        bool makeChanged() const;
        void setMakeChanged(const bool c);

        bool load(const QString& name);
        void save();
        void saveAs(const QString& name);
        
        ProjectFiles *getProjectFiles(const FileKind::ETFileKind filekind);
        QString getProjectFile(const FileKind::ETFileKind filekind, const int index);
        int findFile(const QString& path);
        int findFile(const QString& path, const FileKind::ETFileKind filekind);
        FileKind::ETFileKind getFileKind(const QString& path);
        int addProjectFile(const FileKind::ETFileKind filekind, const QString& file);
        int insertProjectFile(const FileKind::ETFileKind filekind, const int index, const QString& file);
        bool removeProjectFile(const FileKind::ETFileKind filekind, const int index);

        bool setAnalyse(const FileKind::ETFileKind filekind, const int index, bool analyse);
        bool getAnalyse(const FileKind::ETFileKind filekind, const int index);
        QString getFilename(const FileKind::ETFileKind filekind, const int index) const;
        QString getRelFilename(const FileKind::ETFileKind filekind, const int index) const;
        Options* getFileOptions(const FileKind::ETFileKind filekind, const int index);

        int getNrFilesInAnalysis(const FileKind::ETFileKind filekind);
        int getNrFilesInAnalysis();
        int getNrFilesAnalysisAll();
        int getNrFiles();
        int getNrFiles(const FileKind::ETFileKind filekind);

        void setMakeFileIndex(const int& index);
        int getMakeFileIndex() const {return makefileIndex;}
        void setMakeFilename(const QString& filename);
        QString getMakeFilename() const {return makefileName[makefileIndex];}
        QString getMakeFilename(const int makefileindex) const {return makefileName[makefileindex];}
        void setCompiler(const QString& name);
        QString getCompiler(const int makefileindex) const {return compiler[makefileindex];}
        void setCompilerOptions(const QString& compilerOptions);
        QString getCompilerOptions(const int makefileindex) const {return compilerOptions[makefileindex];}
        void setCCompiler(const QString& name);
        QString getCCompiler(const int makefileindex) const {return cCompiler[makefileindex];}
        void setCCompilerOptions(const QString& options);
        QString getCCompilerOptions(const int makefileindex) const {return cCompilerOptions[makefileindex];}
        void setObjDir(const QString& dir);
        QString getObjDir(const int makefileindex) const {return objDir[makefileindex];}
        void setTarget(const QString& target);
        QString getTarget(const int makefileindex) const {return target[makefileindex];}
        void setTargetDir(const QString& dir);
        QString getTargetDir(const int makefileindex) const {return targetDir[makefileindex];}
        void setLinkerOptions(const QString& options);
        QString getLinkerOptions(const int makefileindex) const {return linkerOptions[makefileindex];}
        void genMakefileLeader();
        bool makeCommandFileAn(QFile &commandfile, const bool fullanalysis, const QString& reportfilename);
        bool makeCommandFileDep(QFile &commandfile, const QString& opt, const QString& reportfilename);
        QString makeCommandArgAn(const bool fullanalysis, const QString& reportfilename);
        QString makeCommandArgDep(const QString& opt, const QString& reportfilename);
        int compressUpdateLibrary();

        struct {
                int PW, PL;
        } LastUsedInAnalysis;

        QString title;

private:
        bool changed;
        bool make_changed[2];
        IniFile *fckIdeProjectFile;
        QString projectDirectory;
        int makefileIndex;
        QString projectFilename;
        QString makefileName[2];
        QString compiler[2];
        QString compilerOptions[2];
        QString cCompiler[2];
        QString cCompilerOptions[2];
        QString objDir[2];
        QString target[2];
        QString targetDir[2];
        QString linkerOptions[2];
        QDateTime datetimePreferences[2];   // date/time of preferences taken account for by make
        ProjectFiles *myProjectFiles[FileKind::Count];
        Options *myProjectOptions;
        QFile file;
        QTextStream stream;
};

#endif
