/*ForcheckIDE/PreferencesForm.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef PREFERENCESFORM_H
#define PREFERENCESFORM_H

#define NR_OUTPUT_STREAMS 3
#define NR_OUTPUT_CAT 3

#include <QDialog>
#include <QString>

class QTabWidget;
class QWidget;
class QPushButton;
class QLabel;
class QLineEdit;
class QListWidget;
class QListWidgetItem;
class QComboBox;
class QRadioButton;
class QCheckBox;
class QGroupBox;
class FileExistsValidator;

class CnfOptions;

class PreferencesForm : public QDialog
{
        Q_OBJECT
public:
        PreferencesForm(QWidget *parent=0);
        ~PreferencesForm();
private:
        QTabWidget *tabWidget;

        QWidget *directoriesTab;
        QWidget *extensionsTab;
        QWidget *emulationTab;
        QWidget *editorTab;
        QWidget *buildTab;
        QWidget *messagesTab;
        QWidget *messageReportTab;
        QWidget *numberingTab;
        QWidget *dateTimeFormatTab;
        QWidget *outputTab;
        QWidget *librariesTab;

        QLabel *editorCommandlineLabel;

        QPushButton *helpButton;
        QPushButton *okButton;
        QPushButton *applyButton;
        QPushButton *cancelButton;
        QPushButton *addButton;
        QPushButton *removeButton;
        QPushButton *clearButton;

        QLineEdit *projectExtEdit;
        QLineEdit *makeExtEdit;
        QLineEdit *sourceExtEdit;
        QLineEdit *presourceExtEdit;
        QLineEdit *cSourceExtEdit;
        QLineEdit *includeExtEdit;
        QLineEdit *libraryExtEdit;
        QLineEdit *listingExtEdit;
        QLineEdit *reportExtEdit;
        QLineEdit *refstructExtEdit;
        QLineEdit *moddepExtEdit;
        QLineEdit *editorEdit;
        QLineEdit *editorCommandlineEdit;
        QLineEdit *searchEdit;
        QLineEdit *emulationFileEdit;
        QLineEdit *compilerEdit;
        QLineEdit *compilerOptionsEdit;
        QLineEdit *compilerDebugOptionsEdit;
        QLineEdit *cCompilerEdit;
        QLineEdit *cCompilerOptionsEdit;
        QLineEdit *linkerOptionsEdit;
        QLineEdit *buildUtilityEdit;
        QLineEdit *maxMsgEdit;
        FileExistsValidator *validator;
        QStringList *fileList;

        QGroupBox *levelGroupBox;
        QRadioButton *defaultLevelButton;
        QRadioButton *errorLevelButton;
        QRadioButton *warningLevelButton;
        QRadioButton *informationLevelButton;
        QRadioButton *overflowLevelButton;
        QRadioButton *suppressLevelButton;

        QRadioButton *linesButton;
        QRadioButton *statementsButton;
        QRadioButton *subButton;
        QRadioButton *fileButton;
        QRadioButton *hierButton;
        QRadioButton *seqButton;

        QCheckBox *suppressAllCheck;
        QCheckBox *showRedefinedCheck;
        QCheckBox *viewerCheck;
        QCheckBox *printSourceCheck;
        QCheckBox *printLinStmNumCheck;
        QCheckBox *updateCheck;
        QCheckBox *compressCheck;

        QCheckBox *outputCheck[NR_OUTPUT_STREAMS][NR_OUTPUT_CAT];

        QListWidget *directoriesListBox;
        QListWidget *emulationListBox;
        QListWidget *messagesListBox;
        QComboBox *fileLineFormatComboBox;
        QComboBox *dateFormatComboBox;
        QComboBox *timeFormatComboBox;

        CnfOptions *myCnfOptions;
        int fileIndex[100];
        int rowSelected;
        int msgSelected;
        int searchRow;

        void createTabs();
        void initialize();
        void applyChanges();

        void createIncludeDirectoriesTab();
        void initializeIncludeDirectories();
        void applyChangesIncludeDirectories();

        void createExtensionsTab();
        void initializeExtensions();
        void applyChangesExtensions();

        void createEmulationTab();
        void initializeEmulation();
        void applyChangesEmulation();

        void createEditorTab();
        void resetEditor();
        void initializeEditor();
        void applyChangesEditor();

        void createBuildTab();
        void initializeBuild();
        void applyChangesBuild();

        void createMessagesTab();
        void initializeMessages();
        void applyChangesMessages();

        void createReportMessageTab();
        void initializeReportMessage();
        void applyChangesReportMessage();

        void createNumberingTab();
        void createDateTimeFormatTab();
        void createOutputTab();
        void initializeCnfOptions();
        void applyChangesCnfOptions();

        void createLibrariesTab();
        void initializeLibraries();
        void applyChangesLibraries();

        int rowToMsgnum(const int row);
        void presentMessageInfo(int msgnum);

public slots:
        void tabClicked(int);
        void defaultClicked();
        void helpClicked();
        void okClicked();
        void applyClicked();
        void addDirClicked();
        void itemDirClicked();
        void removeDirClicked();
        void clearDirClicked();
        void selectEmulationFileClicked();
        void emulationListBoxItemClicked(QListWidgetItem *);
        void selectBuildUtilityClicked();
        void messageSelected(QListWidgetItem *);
        void defaultLevelButtonClicked(bool);
        void errorLevelButtonClicked(bool);
        void warningLevelButtonClicked(bool);
        void informationLevelButtonClicked(bool);
        void overflowLevelButtonClicked(bool);
        void suppressLevelButtonClicked(bool);
        void suppressAllClicked(bool);
        void searchEditEntered();
        void showRedefinedClicked();
        void defaultEditorClicked();
        void browseClicked();
        void setPrintSourceCheckEnabled(int state);
    };

#endif
