/*ForcheckIDE/PdfWidget.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef PDFWIDGET_H
#define PDFWIDGET_H

#include <QLabel>
#include <QRectF>
#include <poppler-qt5.h>

class QRubberBand;

class PdfWidget : public QLabel
{
    Q_OBJECT

public:
    PdfWidget(QWidget *parent = 0);
    ~PdfWidget();
    Poppler::Document *document();
    QMatrix matrix() const;
    qreal scale() const;

public slots:
    QRectF searchBackwards(const QString& text);
    QRectF searchForwards(const QString& text);
    bool setDocument(const QString& filePath);
    void setPage(int page = -1);
    void previousPage();
    void nextPage();
    void firstPage();
    void lastPage();
    void setScale(qreal scale);

protected:
    void mousePressEvent(QMouseEvent *event);
    void mouseMoveEvent(QMouseEvent *event);
    void mouseReleaseEvent(QMouseEvent *event);

signals:
    void pageChanged(int currentPage);
    void textSelected(const QString& text);

private:
    void selectedText(const QRectF& rect);
    void showPage(int page = -1);

    Poppler::Document *doc;
    int currentPage;
    QPoint dragPosition;
    QRubberBand *rubberBand;
    QRectF searchLocation;
    qreal scaleFactor;
};

#endif
