/*ForcheckIDE/PpfToc.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef PDFTOC_H
#define PDFTOC_H

#include <poppler-qt5.h>
#include <QTreeWidget>

class QPoint;
class QString;
class HelpBrowser;

class PdfTocTree : public QTreeWidget
{
    Q_OBJECT

public:
    PdfTocTree(HelpBrowser *parent = 0);
    ~PdfTocTree();

    void fillInfo(Poppler::Document *doc);
    void documentClosed();
    QString text(const QPoint& pos);

private:
    void fillToc(const QDomNode& parent, QTreeWidget *tree, QTreeWidgetItem *parentItem);

    HelpBrowser *myparent;

private slots:
//    void mouseDoubleClicked(QTreeWidgetItem *item, int column);
    void mouseDoubleClickEvent(QMouseEvent *event);
};

#endif
