/*ForcheckIDE/PdfToc.cpp*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#include "PdfToc.h"
#include "HelpBrowser.h"

#include <QtXml/QDomNode>
#include <QtXml/QDomElement>
#include <QtXml/QDomDocument>
#include <QMouseEvent>

PdfTocTree::PdfTocTree(HelpBrowser *parent)
{
    myparent = parent;
    setHeaderLabel(tr("Table of contents"));
//    connect(this, SIGNAL(itemDoubleClicked(QTreeWidgetItem *, int)),
//            this, SLOT(mouseDoubleClicked(QTreeWidgetItem *, int)));
}

PdfTocTree::~PdfTocTree()
{
    clear();
}

/*
void PdfTocTree::mouseDoubleClicked(QTreeWidgetItem *item, int column)
{
    QString itemtext = item->text(0);
    emit myparent->tocDoubleClicked(itemtext);
}
*/

void PdfTocTree::mouseDoubleClickEvent(QMouseEvent *event )
{
    QPoint pos = event->pos();
    QTreeWidgetItem *item = itemAt(pos);
    if (item){
        QString itemtext = item->text(0);
        emit myparent->tocDoubleClicked(itemtext);
    }
}

void PdfTocTree::documentClosed()
{
    clear();
}

void PdfTocTree::fillInfo(Poppler::Document *doc)
{
    const QDomDocument *toc = doc->toc();
    if (toc) {
        fillToc(*toc, this, 0);
    } else {
        QTreeWidgetItem *item = new QTreeWidgetItem();
        item->setText(0, tr("No TOC"));
        item->setFlags(item->flags() & ~Qt::ItemIsEnabled);
        addTopLevelItem(item);
    }
}

void PdfTocTree::fillToc(const QDomNode &parent, QTreeWidget *tree, QTreeWidgetItem *parentItem)
{
    QTreeWidgetItem *newitem = 0;
    for (QDomNode node = parent.firstChild(); !node.isNull(); node = node.nextSibling()) {
        QDomElement e = node.toElement();
        if (!parentItem) {
            newitem = new QTreeWidgetItem(tree, newitem);
        } else {
            newitem = new QTreeWidgetItem(parentItem, newitem);
        }
        newitem->setText(0, e.tagName());

        bool isOpen = false;
        if (e.hasAttribute(QString::fromLatin1("Open"))) {
            isOpen = QVariant(e.attribute(QString::fromLatin1("Open"))).toBool();
        }
        if (isOpen) {
            tree->expandItem(newitem);
        }

        if (e.hasChildNodes()) {
            fillToc(node, tree, newitem);
        }
    }
}

QString PdfTocTree::text(const QPoint& pos)
{
    QTreeWidgetItem *item = itemAt(pos);
    QString name;
    if (item){
        name = item->text(0);
    }
    return name;
}
