/*ForcheckIDE/PageSetup.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef PAGESETUP_H
#define PAGESETUP_H

class QSettings;
class QFile;
class QPrinter;

#include <QString>

#define DEFAULT_FONT_NAME "Courier New"
#define DEFAULT_FONT_SIZE 8
#define DEFAULT_MARGIN_LEFT 0
#define DEFAULT_MARGIN_RIGHT 0
#define DEFAULT_MARGIN_TOP 0
#define DEFAULT_MARGIN_BOTTOM 0
#define DEFAULT_WRAP_LONG_LINES true
#define DEFAULT_ORIENTATION 1
#define DEFAULT_PAPER_SIZE 9

class PageSetup {
public:
        PageSetup();
        void save(QSettings& ideConfSettings);
        void restore(QSettings& ideConfSettings);
        void setupPrinter();
        void getPageSize();
        void setupPage();
        void printFile(QFile& file);

        int charactersPerLine;
        int linesPerPage;

private:
        QPrinter *printer;
        QString printer_name;
        QString font_name;
        int font_size;
        int margin_left;
        int margin_right;
        int margin_top;
        int margin_bottom;
        bool wrap_long_lines;
        int orientation;
        int paper_size;
};
#endif // PAGESETUP_H
