/*ForcheckIDE/OptionsForm.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef OPTIONSFORM_H
#define OPTIONSFORM_H

#include "Options.h"

#include <QDialog>

class QGroupBox;
class QPushButton;
class QLabel;
class QAbstractButton;
class QLineEdit;
class QButtonGroup;
class QString;
class QStringList;

class OptionsForm : public QDialog
{
      Q_OBJECT
public:
        OptionsForm(QWidget *parent=0);
        void DefaultOptions(Options *opt,
                            const QString& filename);
        void ProjectOptions(Options *opt,
                            const QString& filename);
        void SourceFileOptions(Options *opt,
                               Options *projopts,
                               const QString& filename);
        void LibraryFileOptions(Options *opt,
                                Options *projopts,
                                const QString& filename);
private:
        struct OptionsGroups_struct {
            QGroupBox *optionGroupBox;
            QAbstractButton **buttons;
            QPushButton **listButtons;
            QLabel **labels;
            QLineEdit **editfields;
            QStringList **valuesList;
        } optionsGroups[OptionsGroup::OptionsGroupCount];
        QPushButton *helpButton;
        QPushButton *okButton;
        QPushButton *cancelButton;
        QPushButton *defaultButton;

        QButtonGroup *buttonGroup[OptionsGroup::OptionsGroupCount];
        QButtonGroup *listButtonGroup[OptionsGroup::OptionsGroupCount];

        void formCreate();
        void fillGroupBox(int optiongroup);
        void optionsToForm(const Options *opts);
        void optionsFromForm(Options *opts);
        void findOpt(QAbstractButton *button, OptionsGroup::ETOptionsGroup &optiongroup, int &index);
        void findListOpt(QAbstractButton *listbutton, OptionsGroup::ETOptionsGroup &optiongroup, int &index);

        OptionsKind::ETOptionsKind currentOptionKind;
        Options *currentOptions;
        QString currentFilename;
        Options *projOpts;

public slots:
        void helpButtonClicked();
        void okButtonClicked();
        void cancelButtonClicked();
        void defaultButtonClicked();
        void buttonClicked(QAbstractButton *button);
        void listButtonClicked(QAbstractButton *listbutton);
};

#endif
