/*ForcheckIDE/NewRelease.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef NEWRELEASE_H
#define NEWRELEASE_H

#include <QDialog>

class QMainWindow;
class QFile;
class QNetworkAccessManager;
class QTimer;
class QNetworkReply;
class QIODevice;

class NewRelease : public QObject
{
    Q_OBJECT
public:
    NewRelease(QMainWindow *parent = 0);
    void checkForNewRelease();

private:
    void saveVersionFile(QIODevice *data);
    void compareVersions();

    bool pwdValid;
    bool httpAborted;
    QMainWindow *myParent;
    QFile *versionfile;
    QTimer *timer;
    QNetworkAccessManager *manager;

signals:

private slots:
    void httpTimeout();
    void downloadFinished(QNetworkReply*);
};

#endif // NEWRELEASE_H
