/*ForcheckIDE/MakefileForm.h*/

/****************************************************************************

    Copyright 2016 Erik Kruyt, Forcheck b.v.

    This file is part of forcheckIDE.

    forcheckIDE is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    forcheckIDE is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with forcheckIDE.  If not, see <http://www.gnu.org/licenses/>.

****************************************************************************/

#ifndef MAKEFILEFORM_H
#define MAKEFILEFORM_H

#include <QDialog>

class Project;
class QLineEdit;
class QRadioButton;
class QPushButton;

class MakefileForm : public QDialog
{
    Q_OBJECT
public:
    MakefileForm(Project *project, bool *gen, QWidget *parent=0);

private:
    Project *myproject;
    QRadioButton *debugButton;
    QRadioButton *releaseButton;
    QLineEdit *makefileEdit;
    QLineEdit *compilerEdit;
    QLineEdit *compilerOptionsEdit;
    QLineEdit *cCompilerEdit;
    QLineEdit *cCompilerOptionsEdit;
    QLineEdit *objDirEdit;
    QLineEdit *targetEdit;
    QLineEdit *targetDirEdit;
    QLineEdit *linkerOptionsEdit;
    QPushButton *applyButton;
    QPushButton *cancelButton;
    QPushButton *genButton;

    void formCreate();
    void formInit(int);
    bool *genpon;
    int makefileindex;

public slots:
    void debugButtonClicked(bool);
    void releaseButtonClicked(bool);
    void selectMakefileClicked();
    void applyClicked();
    void genMakefileClicked();
};

#endif // MAKEFILEFORM_H
